package ibase.dashboard.crm.ejb;
import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;

@Stateless
public class ContactCommDashboard implements ContactCommDashboardLocal, ContactCommDashboardRemote
{
	E12GenericUtility e12GenericUtility = new E12GenericUtility();

	public ContactCommDashboard()
	{

	}

	@SuppressWarnings({ "unchecked"})
	public JSONObject getCommunicationSchedule(String dataSourceName,String loginCode, String empCode) throws RemoteException, ITMException
	{
		StringBuffer xmlString = null;
		JSONObject rowDataBasicJsn = new JSONObject();
		JSONObject rowData = null;
		String sql = "" ;
		ResultSet rs = null;
		PreparedStatement pstmt = null,pstmt1 = null, pstmtDS = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		int count = 0;
		String commPlanId ="",plandate = "",salesPers ="",sconCode = "",commDate = "",contactType = "",
				activityCode = "",planDetail = "",commId = "",resultFlag = "",spName = "", pstmtDSInput = "";;
				Date planDate1= null,commDate1 = null;
				String newPlanDate = "",newCommDate = "";
				String firstName ="",lastName = "",emailAddr = "" ,mobileNo = "",sorgCode = "",sorgName = "",contactPerson = "";
				String dbDateFormat = "",applDateFormat = "";
				StringBuffer dataSourceSql = null;
				try
				{
					E12GenericUtility genericUtility = new E12GenericUtility();	
					conn = connDriver.getConnectDB(dataSourceName);

					dbDateFormat = genericUtility.getDBDateFormat();
					applDateFormat = genericUtility.getApplDateFormat();

					if(empCode == null || empCode.trim().length() == 0)
					{
						empCode = loginCode;
					}
					sql = "SELECT (STR.FIRST_NAME||' '||STR.LAST_NAME) AS CONTACT_PERSON,"+
							" STR.SORG_CODE, "+
							" STR.EMAIL_ADDR, "+
							" STR.MOBILE_NO, "+
							" SP.SP_NAME, "+
							" COM.COMM_PLAN_ID, "+
							" COM.PLAN_DATE, "+
							" COM.ACTIVITY_CODE, "+
							" COM.COMM_ID, "+
							" COM.RESULT_FLAG, "+
							" COM.SALES_PERS, "+
							" COM.SCON_CODE, "+
							" COM.COMM_DATE AS NEW_COMM_DATE, "+
							" CASE COM.CONTACT_TYPE WHEN '1' THEN 'CALL' WHEN '2' THEN 'MAIL' WHEN '3' THEN 'MEETING' WHEN '4' "+ 
							" THEN 'VIDEOCONFERENCING'WHEN '5' THEN 'OTHERS'END AS DESCR," +
							" COM.PLAN_DETAIL," +
							" COM.START_TIME," +
							" COM.END_TIME ," +
							" COM.START_DATE," +
							" COM.END_DATE , " +
							" COM.REMARKS,"+
							" STRO.SORG_NAME "+
							" FROM CONTACT_COMM_PLAN COM " +
							" INNER JOIN STRG_CONTACT STR ON COM.SCON_CODE=STR.SCON_CODE  " +
							" INNER JOIN SALES_PERS SP ON  COM.SALES_PERS=SP.SALES_PERS "+
							" LEFT OUTER JOIN STRG_ORG STRO ON STRO.SORG_CODE = STR.SORG_CODE "+
							" WHERE COM.COMM_DATE > SYSDATE "; 

					dataSourceSql = new StringBuffer(sql);


					pstmtDSInput = "";
					if(empCode.equalsIgnoreCase("TEAM"))
					{
						dataSourceSql.append(" AND SP.EMP_CODE IN (SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO) ORDER BY SP.SP_NAME,NEW_COMM_DATE");
						pstmtDSInput = loginCode;
					}
					else
					{
						dataSourceSql.append(" AND SP.EMP_CODE = ? ORDER BY SP.SP_NAME,NEW_COMM_DATE");
						pstmtDSInput = empCode;
					}

					sql = dataSourceSql.toString();
					pstmtDS = conn.prepareStatement(sql);
					pstmtDS.setString(1, pstmtDSInput);

					rs = pstmtDS.executeQuery();
					while (rs.next())
					{
						count++;
						if(count == 1)
						{
							xmlString = new StringBuffer("<table class='mtBackgroundWhite' border=''><tbody><tr>"
									+ "<th class='mtBackgroundWhite' style='width: 2%;'>Sales Person</th>" 
									+"<th class='mtBackgroundWhite' colspan='' style='width: 2%;'> Date </th>"
									+"<th class='mtBackgroundWhite' colspan='' style='width: 4%;'> Contact Person</th>"
									+"<th class='mtBackgroundWhite' style='width: 4%;'>Plan Detail</th>"
									+"</tr>");
						}
						spName = checkNull(rs.getString("sp_name"));
						contactPerson = checkNull(rs.getString("contact_person"));
						sorgCode = checkNull(rs.getString("sorg_code"));
						emailAddr = checkNull(rs.getString("email_addr"));
						mobileNo = checkNull(rs.getString("mobile_no"));
						commDate1 = rs.getDate("NEW_COMM_DATE");
						String newdate = (commDate1 != null )? genericUtility.getValidDateString(commDate1.toString(), dbDateFormat, applDateFormat ):null;

						xmlString.append("<tr><td class= 'cardHtmlTableBodyAlignLft' rowspan='4' style='text-align: center;'>"+spName+"</td>");
						xmlString.append("<td  rowspan = '2' class= 'cardHtmlTableBodyAlignLft'  >"+newdate+"</td> ");
						xmlString.append("<td class= 'cardHtmlTableBodyAlignLft' >"+contactPerson+"</td>");
						xmlString.append("<td class= 'cardHtmlTableBodyAlignLft' rowspan='4'>"+checkNull(rs.getString("plan_detail"))+"</td></tr>");
						xmlString.append("<tr><td class= 'cardHtmlTableBodyAlignLft' style='border-top: 1px solid transparent;vertical-align:top;'>"+checkNull(rs.getString("SORG_NAME"))+"</td></tr>");
						xmlString.append("<tr><td  rowspan = '2' class= 'cardHtmlTableBodyAlignLft' style='border-top: 1px solid transparent;vertical-align:top;'>From:"+checkNull(rs.getString("start_time"))+" To:"+checkNull(rs.getString("end_time"))+"</td>");
						xmlString.append("<td class= 'cardHtmlTableBodyAlignLft' style='border-top: 1px solid transparent;'>"+emailAddr+"</td></tr>");
						xmlString.append("<tr><td class= 'cardHtmlTableBodyAlignLft' style='border-top: 1px solid transparent;'><img src='../webitm/images/Standard/tele-1-1.ico' style='width:10px;height:10px;'>"+mobileNo+"</td></tr>");
					}

					if(count == 0)
					{
						xmlString = new StringBuffer("<table  id='htmlTable' cellpadding='2'"+
								"align='center'><tbody><tr><td align = 'center' class='gwt-ScrollTable'>No "+
								"Data Found</td></tr>");
					}
					System.out.println("xmlString ::::[ "+xmlString+" ]");
					xmlString.append("</tbody></table>");
					rowData =new JSONObject();
					rowData.put("xmlString", xmlString.toString());
					rowDataBasicJsn.put(0,rowData);
					if(pstmtDS != null)
					{
						pstmtDS.close();
						pstmtDS = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;	
					}
				} 
				catch (Exception e)
				{
					e.printStackTrace();
					throw new ITMException(e);
				} 
				finally
				{
					try
					{
						if (conn != null)
						{
							conn.close();
							conn = null;
						}	
						conn = null;
					} 
					catch (Exception d)
					{
						d.printStackTrace();
						System.out.println("Exception in : ContactCommDashboard :::: " + d.getMessage());
						throw new ITMException(d);
					}
				}
				return rowDataBasicJsn;
	}
	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str.trim();
		}
	}

}