package ibase.dashboard.metadata.servlet;
import ibase.dashboard.metadata.ejb.DashboardParentEJBRemote;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;
public class ParentMetaDataServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;	
	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unused")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
			
		try
		{
			JSONObject jsonObjMetaData     =null;
			JSONObject jsonObjDefaultValue = null;			    
			DashboardParentEJBRemote dashboardParentEJBRemote = null;
			String dataSourceName         ="";	
			String fileName               = request.getParameter("fileName");
            HttpSession session           = request.getSession(true);
            UserInfoBean userInfo         = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
		   if (userInfo!=null)
			{
				dataSourceName   = userInfo.getTransDB();
			}
			else
			{
				userInfo         = new UserInfoBean();
				dataSourceName   = userInfo.getTransDB();
			}
         	if(fileName!=null && fileName.trim().length()>0)
			{
         		//InitialContext ctx       = this.getInitialContext();
     	        //dashboardParentEJBRemote = (DashboardParentEJBRemote)ctx.lookup("ibase/DashboardParentEJB/remote");     		  
     	       // jsonObjDefaultValue      = (JSONObject)dashboardParentEJBRemote.getDefaultFilterValue(dataSourceName);
         	    jsonObjMetaData          = (JSONObject) getMetaData(fileName,userInfo);
			}
			System.out.println("getMetaData  in ParentMetaDataServlet===" + jsonObjMetaData);
			OutputStream outputStream = response.getOutputStream();
			outputStream.write(jsonObjMetaData.toString().getBytes());
			outputStream.flush();
			outputStream.close();

		} catch (Exception e)
		{
			System.out.println("Exception : ParentMetaDataServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

	//add new code for get current financial year and period from database
	
	/*@SuppressWarnings("unchecked")
		public JSONObject getDefaultFilterValue(UserInfoBean userInfo)
	    {
	        ConnDriver connDriver = new ConnDriver();
	        Statement statement = null;
	        ResultSet rs = null;
	        JSONObject parentDataJson = new JSONObject();
	        
	        Connection connection = null;
	        String transDB = "";
	        try
	        {
	           transDB = userInfo.getTransDB();
	           if (transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
	            {
	                connection = connDriver.getConnectDB(transDB);
	            }
	           else
	            {
	                connection = connDriver.getConnectDB("DriverITM");
	            }
	            statement    = connection.createStatement();
	            String query = " Select Acct_Prd,Code,Descr From Period Where To_Date(Sysdate) Between Fr_Date and To_Date ";
	            rs           = statement.executeQuery(query);
	            if (rs.next())
	            {
	            	parentDataJson.put("CURRENT_ACCTCODE",checkNull(rs.getString("Acct_Prd")));
	            	parentDataJson.put("CURRENT_PRDCODE",checkNull(rs.getString("Code")));
	            	parentDataJson.put("CURRENT_SITECODE",userInfo.getSiteCode());
	            	parentDataJson.put("CURRENT_LOGINCODE",userInfo.getSiteCode());
	            	parentDataJson.put("CURRENT_MONTH",  "December");
	            	parentDataJson.put("CURRENT_YEAR",  "2017");
	            	
	            }
	        } catch (Exception e)
	        {
	            e.printStackTrace();
	        } finally
	        {
	            try
	            {
	            	rs.close();
	            	rs = null;
	                statement.close();
	                statement = null;
	                connection.close();
	                connection = null;
	            } catch (Exception ex)
	            {
	                System.out.println("Finally Exception : DashboardFilterServlet: getDefaultFilterValue()" + ex.getMessage());
	                ex.printStackTrace();
	            }
	        }
	        return parentDataJson;
	    }*/
		
  //end the  new code for get current financial year and period from database
	
	@SuppressWarnings("unchecked")
	private JSONObject getMetaData(String fileName,UserInfoBean userInfo ) throws RemoteException, ITMException
	{
		String isCurrentLine = "";		
		JSONObject jsonMetaData          = new JSONObject();
		StringBuffer metaData = new StringBuffer();		
		String filePath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "dashboard" + File.separator + "metadataxml" + File.separator +fileName+".xml";
		System.out.println("Final File Path =" + filePath);
		try
		{
			@SuppressWarnings("resource")
			BufferedReader bufferedReader = new BufferedReader(new FileReader(filePath));
			while ((isCurrentLine = bufferedReader.readLine()) != null)
			{
				System.out.println("isCurrentLine =" + isCurrentLine.trim());
				if (isCurrentLine.trim().length() > 0)
				{
					metaData.append(isCurrentLine.trim());
				}
			}
		} 
		catch (FileNotFoundException e)
		{
			System.out.println("getMetaData in ParentMetaDataServlet ********* ");
		} catch (IOException e)
		{
			e.printStackTrace();
		}
		
		System.out.println(" metaData.toString().replace :=" + metaData.toString().replace("//", "").trim());
		jsonMetaData.put("metaData", metaData.toString().replace("//", "").trim());
		
		
		// add new logic for create sub title----------------
		
		//jsonMetaData.put("CURRENT_ACCTCODE",jsonObjDefaultValue.get("CURRENT_ACCTCODE"));
		//jsonMetaData.put("CURRENT_PRDCODE", jsonObjDefaultValue.get("CURRENT_PRDCODE"));
		
		
		//End logic for sub title-----------
		Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int year = cal.get(Calendar.YEAR);
        int month = cal.get(Calendar.MONTH)+1;
        if(month<4)
        {
        	year = year-1;
        }
		String currentYear  = year+"";
		String nextYear = (year+1)+"";
	    String finYear = currentYear +" - "+ nextYear;	  	    
		System.out.println("Financial Year : " + finYear);
		System.out.println("Period Code : " + month+currentYear);
		jsonMetaData.put("tranDB",    userInfo.getTransDB());
		jsonMetaData.put("SITE_CODE", userInfo.getSiteCode());
		jsonMetaData.put("LOGIN_CODE", userInfo.getLoginCode());
		jsonMetaData.put("ACCT_PRD", finYear);
		jsonMetaData.put("PRDCODE", month+currentYear);
		System.out.println("tranDB in ParentMetaDataServlet ********* :"+userInfo.getTransDB());
		return jsonMetaData;
	}
	
	private InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :RequestHandlerServlet :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :RequestHandlerServlet :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}

	
	
	
	private String checkNull(String str)
	{
		if(str == null)
		{
			return "";
		}
		else
		{
			return str ;
		}

	}	
	
}