package ibase.webitm.ecm.ejb;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

@Stateless
public class ECMCategoryEJB extends ValidatorEJB implements ECMCategoryEJBRemote, ECMCategoryEJBLocal
{

	E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

	public String wfValData() throws RemoteException, ITMException 
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag,	String xtraParams) throws RemoteException, ITMException 
	{
		System.out.println("ECMCategoryEJB :wfValData(String xmlString):" + xmlString);
		System.out.println("ECMCategoryEJB :wfValData(String xmlString1):" + xmlString1);
		System.out.println("ECMCategoryEJB :wfValData(String xmlString2):" + xmlString2);
		System.out.println("ECMCategoryEJB :wfValData(String objContext):" + objContext);
		System.out.println("ECMCategoryEJB :wfValData(String xtraParams):" + xtraParams);
		System.out.println("ECMCategoryEJB :wfValData(String editFlag):" + editFlag);
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try {
			if (xmlString != null && xmlString.trim().length() != 0) {
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);

			System.out.println("ErrString :" + errString);

		}

		catch (Exception e) {
			System.out.println("Exception :ECMCategoryEJB:wfValData(String xmlString):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}

		System.out.println("returning from ECMCategoryEJB wfValData XML");
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag,	String xtraParams) throws RemoteException, ITMException 
	{

		String sql = "", catCode = "", scatCode = "";
		String errString = "";

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		int currentFormNo = 0;
		int count = 0;
		E12GenericUtility genericUtility = new E12GenericUtility();

		try 
		{
			conn = getConnection();


			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}

			switch (currentFormNo) 
			{
			/////////////////////////// VALIDATION FOR CATEGORIES START
			case 1:

				count = 0;
				catCode = genericUtility.getColumnValue("cat_code", dom);

				System.out.println("catCode [" + catCode + "]");

				if (catCode == null || catCode.trim().length() == 0) //NULL CHECK
				{
					System.out.println("<<===========   cat_code Blank ========>> ");
					errString = getErrorString("cat_code", "NULCATCODE", "");
					return errString;
				} 
				else if ("A".equalsIgnoreCase(editFlag)) //DB EXIST CHECK
				{
					sql = "SELECT COUNT(*) FROM ECM_Category WHERE  cat_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, catCode);
					rs = pstmt.executeQuery();
					System.out.println("KAMAL1");
					if (rs.next()) {
						count = rs.getInt(1);
					}
					if (count > 0) {
						System.out.println("<<===========  CATCODE already exist ========>> ");
						errString = getErrorString( "cat_code", "CATCODAEXT", "");
						return errString;
					}
					pstmt.close();
					rs.close();

				}
				break;
				/////////////////////////// VALIDATION FOR CATEGORIES ENDS


				/////////////////////////// VALIDATION FOR SUBCATEGORIES START
			case 2:

				count = 0;
				scatCode = genericUtility.getColumnValue("scat_code", dom);
				Node detailNode = dom.getElementsByTagName("Detail2").item(0);
				String domId = detailNode.getAttributes().getNamedItem("domID").getNodeValue();
				String updateflag = getAttribValue(genericUtility.serializeDom(detailNode), "2", "attribute", "updateFlag");

				System.out.println("domId [" + domId + "]scatCode [" + scatCode + "]updateflag [" + updateflag + "]");

				if (scatCode == null || scatCode.trim().length() == 0) //NULL CHECK
				{
					System.out.println("<<===========   scat_code Blank ========>> ");
					errString = getErrorString(	"scat_code", "NULSCATCOD", "");
					return errString;
				} 
				else 
				{
					System.out.println("CASE 2... DB CHECK");
					if ("A".equalsIgnoreCase(updateflag))  //DB EXIST CHECK
					{
						sql = "SELECT COUNT(*) FROM ECM_Sub_Category WHERE  scat_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, scatCode);
						rs = pstmt.executeQuery();

						if (rs.next()) {
							count = rs.getInt(1); ///////////// rs
						}
						pstmt.close();
						rs.close();
					}

					System.out.println(count + "COUNTEXIST");
					if (count > 0) {
						System.out.println("<<=========== SCATCODE already exist ========>> ");
						errString = getErrorString( "scat_code", "SCATCDAEXT", "");
						return errString;
					} 
					else 
					{
						NodeList detailNodeList = dom2.getElementsByTagName("Detail2");
						for (int temp = 0; temp < detailNodeList.getLength(); temp++)  //ALL DOM EXIST CHECK
						{
							Node detailNode2 = detailNodeList.item(temp);
							String scatCodeCmp = genericUtility.getColumnValueFromNode("scat_code", detailNode2);
							String domIdCmp = detailNode2.getAttributes().getNamedItem("domID").getNodeValue();
							String updateflagCmp = getAttribValue(genericUtility.serializeDom(detailNode2), "2", "attribute", "updateFlag");
							System.out.println("domIdCmp : [" + domIdCmp + "]scatCodeCmp [" + scatCodeCmp + "]updateflagCmp [" + updateflagCmp + "]");

							if (!domId.equalsIgnoreCase(domIdCmp) && scatCode.equalsIgnoreCase(scatCodeCmp) && !"D".equalsIgnoreCase(updateflagCmp)) {
								System.out.println(" scat_code already exist: " + scatCode);
								errString = getErrorString("scat_code", "SCATCDAEXT", "");
								return errString;
							}
						}
					}
				}
				break;
				/////////////////////////// VALIDATION FOR SUBCATEGORIES ENDS
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception :ECMCategoryEJB :wfValData(Document dom):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{
			try
			{
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (conn != null) {
					conn.close();
					conn = null;
				}
			} 
			catch (Exception e) 
			{
				throw new ITMException(e);
			}
		}
		System.out.println("Returning from ECMCategoryEJB wfValData DOM");
		return (errString);
	}

	private String getAttribValue(String formDetailXml, String formNo, String nodeName, String attribStr)
	{
		String attribValue = "";
		try 
		{
			Document detailDom = new E12GenericUtility().parseString(formDetailXml);
			Node attributeNode = detailDom.getElementsByTagName(nodeName).item(0);
			if (attributeNode != null && attributeNode.getAttributes() != null)
			{
				Node attribNode = attributeNode.getAttributes().getNamedItem(attribStr);
				if (attribNode != null) {
					attribValue = attribNode.getNodeValue();
				}
			}
			formDetailXml = new E12GenericUtility().serializeDom(detailDom);

		} 
		catch (Exception e) 
		{
			System.out.println("Exception : getAttribValue of a node :" + e.getMessage());
		}
		return attribValue;
	}

	public String itemChanged() throws RemoteException,ITMException
	{
		return "";
	}
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("ECMCategoryEJB :itemChanged(String xmlString):" + xmlString);
		System.out.println("ECMCategoryEJB :itemChanged(String xmlString1):" + xmlString1);
		System.out.println("ECMCategoryEJB :itemChanged(String xmlString2):" + xmlString2);
		System.out.println("ECMCategoryEJB :itemChanged(String objContext):" + objContext);
		System.out.println("ECMCategoryEJB :itemChanged(String xtraParams):" + xtraParams);
		System.out.println("ECMCategoryEJB :itemChanged(String editFlag):" + editFlag);
		System.out.println("ECMCategoryEJB :itemChanged(String currentColumn):" + currentColumn);
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			System.out.println("xmlString:"+xmlString);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :ECMCategoryEJB :itemChanged(String,String,String,String,String,String):" + e.getMessage() + ":");
			valueXmlString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		System.out.println("returning from ECMCategoryEJB itemChanged   valueXmlString[" + valueXmlString + "]");
		return (valueXmlString);
	}

	public String itemChanged(Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{

		String sql = "", catCode = "", scatCode = "";
		String errString = "";

		StringBuffer valueXmlString = new StringBuffer();
		valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
		valueXmlString.append(editFlag).append("</editFlag> </header>");	

		int currentFormNo = 0;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			if (objContext != null && objContext.trim().length() > 0) 
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			if (currentColumn.equalsIgnoreCase("itm_default")) 
			{
				switch (currentFormNo)
				{
				case 2:

					Node detailNode = currDom.getElementsByTagName("Detail2").item(0);
					String updateflag = getAttribValue(genericUtility.serializeDom(detailNode), "2", "attribute", "updateFlag");

					valueXmlString.append("<Detail2>");
					if ("A".equalsIgnoreCase(updateflag) || "A".equalsIgnoreCase(editFlag))
					{
						valueXmlString.append("<scat_code protect='0' >").append("</scat_code>\r\n");
					}

					valueXmlString.append("</Detail2>");
					System.out.println("valueXmlString" + valueXmlString);
					break;
				}
			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			System.out.println("Exception :ECMCategoryEJB :itemChanged(Document,String):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}

}
