import { Component, OnInit } from '@angular/core';
import { EcmWishListService } from './ecm-wish-list.service';
import { MdSnackBar } from '@angular/material';
import { Item } from '../../ecm-model/product-model';
import { ItemDetail } from '../../ecm-model/product-detail-model';
import { Http} from '@angular/http'
import { Router, ActivatedRoute } from '@angular/router';
import { Store } from '@ngrx/store';
import { AppState } from '../../ecm-store/reducers';
import {  ItemActions, CartActions, WishListActions } from '../../ecm-store/actions';
import { MdDialog, MdDialogRef } from '@angular/material';
import { Observable } from 'rxjs/Observable';
import { EcmCartComponent, ECMConfirmDialog } from '../../ecm-view/ecm-cart/ecm-cart.component';
import { Breadcrumbs } from '../../ecm-breadcrumbs/ecm-breadcrumbs.component';

import { HostUrlService } from '../../host-url.service';

@Component({
  selector: 'app-ecm-wish-list',
  templateUrl: './ecm-wish-list.component.html',
  styleUrls: ['./ecm-wish-list.component.css']
})
export class EcmWishListComponent implements OnInit {
    wishListItems: Observable<ItemDetail[]>;
    cartItems: Observable<ItemDetail[]>;
    errorMessage: string;
    
    hostUrl;

    constructor( private hostUrlService: HostUrlService ,private route: ActivatedRoute, private router: Router, public dialog: MdDialog, public snackBar: MdSnackBar, public wishListService: EcmWishListService, private http: Http, private store: Store<AppState>, private wishListAction: WishListActions, private cartAction: CartActions, public breadcrumbSerivce: Breadcrumbs) 
    { 
        this.hostUrl = hostUrlService.hostUrl;
    }
    ngOnInit() {
        this.wishListItems = this.store.select( 'wishlistItems' );
        this.cartItems = this.store.select( 'cartItems' );
        
        let breadcrumb = [{label: 'Home', url: '/home'}, {label: 'Wishlist', url: 'javascript:void(0)'}];
        this.breadcrumbSerivce.breadcrumbs = breadcrumb;
    }

    deletewishlistItem( item ) {
        this.store.dispatch(this.wishListAction.deleteWishlistItemSuccess(item));
        this.openSnackBar( 'Item Removed from your wishlist' );
    }

    openSnackBar( message: string ) {
        this.snackBar.open( message, '', {
            duration: 2000,
        });
    }

    viewItem( itemCode ) {
        this.router.navigate( ['/detail', itemCode] );
    }
    
    isInCart(itemCode): boolean {
        var incart;
        
        this.cartItems.subscribe( cartItems => {
            if(cartItems.find(x => x.itemCode === itemCode))
                incart = true;
            else
                incart = false;
        } );
        
        return incart;
    }
    
    addToCart( item: ItemDetail ) {
        item.itemQuantity = 1;
        this.store.dispatch( this.cartAction.addToCartSuccess( item ) );
    }
    
    goToCart(){
        this.router.navigate(['/cart']);
    }
    
    confirmDialog( item: any ) {
        this.wishListService.setItemCode( item.itemCode );
        let dialogRef = this.dialog.open( ECMConfirmDialog,{
            width:'300px',
            height:'180px',
            disableClose: true
        });
        dialogRef.componentInstance.dialogTitle = "Remove Item from wishlist?";
        //dialogRef.componentInstance.confirmMsg = "Would you like to remove item from cart?";
        dialogRef.componentInstance.cancelText = "No";
        dialogRef.componentInstance.confirmText = "Yes";
        dialogRef.afterClosed().subscribe( result => {
            if( result == 'true')
            {
                this.deletewishlistItem(item);
            }
        });
    }
}
