import {Injectable} from '@angular/core';
import {Action} from '@ngrx/store';

import {ItemDetail} from '../../ecm-model/product-detail-model';

@Injectable()
export class SubCategoryActions {
    static LOAD_SUBCATEGORY = '[SUBCATEGORY] Load SUBCATEGORY';
    loadSubCategories(catCode): Action {
        return {
            type: SubCategoryActions.LOAD_SUBCATEGORY,
            payload: catCode
        };
    }
    
    static LOAD_SUBCATEGORY_SUCCESS = '[SUBCATEGORY] Load SUBCATEGORY Success';
    loadSubCategoriesSuccess(subcategories): Action {
        console.log('[SUBCATEGORY] Load SUBCATEGORY Success',subcategories.length);
        
        if(!subcategories.length)
        {
            subcategories = [];
        }
        return {
            type: SubCategoryActions.LOAD_SUBCATEGORY_SUCCESS,
            payload: subcategories
        };
        
    }
    
    static RESET_SUBCATEGORY_LIST = '[SUBCATEGORY_LIST] Reset SUBCATEGORY_LIST';
    resetSubCategoryList(): Action {
        return {
            type: SubCategoryActions.RESET_SUBCATEGORY_LIST
        };
    }
    
    static GET_SUBCATEGORY = '[SUBCATEGORY] Get SUBCATEGORY';
    getSubCategory(scatCode): Action {
        return {
            type: SubCategoryActions.GET_SUBCATEGORY,
            payload: scatCode
        };
    }

    static GET_SUBCATEGORY_SUCCESS = '[SUBCATEGORY] Get SUBCATEGORY Success';
    getSubCategorySuccess(subCategory): Action {
        return {
            type: SubCategoryActions.GET_SUBCATEGORY_SUCCESS,
            payload: subCategory
        };
    }
    
    static RESET_BLANK_SUBCATEGORY = '[SUBCATEGORY] Reset Blank SUBCATEGORY';
    resetBlankSubCategory(): Action {
        return {
            type: SubCategoryActions.RESET_BLANK_SUBCATEGORY
        };
    }
}