import { QueryList, EventEmitter, ChangeDetectorRef, ElementRef, AfterContentInit } from '@angular/core';
import { UniqueSelectionDispatcher, CanDisable } from '@angular/material/core';
import { FocusMonitor } from '@angular/cdk/a11y';
import { ControlValueAccessor } from '@angular/forms';
export declare class MatRadioChange {
    source: BBRadiobuttonComponent | null;
    value: any;
}
export declare const MAT_RADIO_GROUP_CONTROL_VALUE_ACCESSOR: any;
export declare class BBRadiobuttonGroup implements AfterContentInit, ControlValueAccessor, CanDisable {
    private _changeDetector;
    _radios: QueryList<BBRadiobuttonComponent>;
    private _name;
    private _value;
    private _selected;
    private _disabled;
    private _isInitialized;
    constructor(_changeDetector: ChangeDetectorRef);
    _controlValueAccessorChangeFn: (value: any) => void;
    onTouched: () => any;
    _markRadiosForCheck(): void;
    writeValue(value: any): void;
    registerOnChange(fn: (value: any) => void): void;
    registerOnTouched(fn: any): void;
    setDisabledState(isDisabled: boolean): void;
    change: EventEmitter<MatRadioChange>;
    name: string;
    value: any;
    selected: BBRadiobuttonComponent | null;
    disabled: boolean;
    _checkSelectedRadioButton(): void;
    ngAfterContentInit(): void;
    _touch(): void;
    private _updateRadioButtonNames();
    private _updateSelectedRadioFromValue();
    _emitChangeEvent(): void;
    ngAfterViewChecked(): void;
}
export declare class BBRadiobuttonComponent {
    private _changeDetector;
    private _radioDispatcher;
    private _focusMonitor;
    private _uniqueId;
    uxDesign: string;
    bbChecked: boolean;
    bbValue: boolean;
    name: string;
    bbId: string;
    bbDisabled: boolean;
    bbRequired: boolean;
    bbLabelPosition: 'before' | 'after';
    bbType: string;
    radioGroup: BBRadiobuttonGroup;
    private _value;
    private _checked;
    _inputElement: ElementRef;
    change: EventEmitter<MatRadioChange>;
    constructor(radioGroup: BBRadiobuttonGroup, _changeDetector: ChangeDetectorRef, _radioDispatcher: UniqueSelectionDispatcher, _focusMonitor: FocusMonitor);
    ngOnInit(): void;
    _markForCheck(): void;
    changeInput(): void;
    private _emitChangeEvent();
}
