/********************************************************
	Title : EcollectionIC[F14ISUN014]
	Date  : 17/02/15
	Developer: Chandrashekar

 ********************************************************/
package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.text.SimpleDateFormat;
import java.util.*;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;

import java.text.DecimalFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.ejb.Stateless;

@Stateless
public class EcollectionIC extends ValidatorEJB implements EcollectionICLocal, EcollectionICRemote {
	E12GenericUtility genericUtility = new E12GenericUtility();

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
		String errString = "";
		Document dom = null, dom1 = null, dom2 = null;
		try {
			System.out.println("Called wfValData [S] from [EJB:" + this.getClass().getSimpleName() + "]");
			if (xmlString != null && xmlString.trim().length() > 0) {
				dom = parseString(xmlString);
				System.out.println("xmlString[" + xmlString + "]");
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0) {
				dom1 = parseString(xmlString1);
				System.out.println("xmlString1[" + xmlString1 + "]");
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) {
				dom2 = parseString(xmlString2);
				System.out.println("xmlString2[" + xmlString2 + "]");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		} catch (Exception e) {
			System.out.println("Exception wfValData [S] in EJB [" + this.getClass().getSimpleName() + "] " + e.getLocalizedMessage());
			throw new ITMException(e);
		}
		return errString;
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException {
		String childNodeName = "", errString = "", errCode = "", userId = "", sql = "", errorType = "", custCode = "", bankCode = "", lineNo = "", chqAmtStr = "", siteCode = "", rcpAmtStr = "", refSer = "", refNo = "", prdCode = "";
		int cnt = 0, ctr = 0, childNodeListLength = 0, currentFormNo = 0;
		NodeList parentNodeList = null, childNodeList = null;
		Node parentNode = null, childNode = null;
		ArrayList<String> errList = new ArrayList<String>(), errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		java.util.Date tranDate = null;
		double rcpAmt = 0, rcpAmtNew = 0, rcpAmtStatus = 0.0, isInvAmt = 0.0, chqAmt = 0.0;
		SimpleDateFormat sdf = null;
		try {
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			System.out.println("Called wfValData [D] from [EJB:" + this.getClass().getSimpleName() + "]");
			// Changes and Commented By Bhushan on 06-06-2016 :START
			// conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			// Changes and Commented By Bhushan on 06-06-2016 :END
			connDriver = null;
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}
			switch (currentFormNo) {
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for (ctr = 0; ctr < childNodeListLength; ctr++) {
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("site_code")) {
						siteCode = this.genericUtility.getColumnValue("site_code", dom);
						if (siteCode != null && siteCode.trim().length() > 0) {
							sql = "select count(*) from site where site_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, siteCode.trim());
							rs = pstmt.executeQuery();
							if (rs.next()) {
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if (cnt == 0) {
								errCode = "VMSITE1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
							
							if (genericUtility.getColumnValue("eff_date", dom) == null) {
								tranDate = null;
							} else {
								tranDate = sdf.parse(genericUtility.getColumnValue("eff_date", dom));
								sql = "select code from period where ?  between fr_date and to_date";
								pstmt = conn.prepareStatement(sql);
								pstmt.setDate(1, new java.sql.Date(tranDate.getTime()));
								rs = pstmt.executeQuery();
								if (rs.next()) {
									prdCode = rs.getString(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								sql = "select count(*) from period_stat where site_code = ? and prd_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, siteCode);
								pstmt.setString(2, prdCode);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									cnt = rs.getInt(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								
								if (cnt == 0) {
									errCode = "VTSITEPD";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
								errCode = nfCheckPeriod("FIN", tranDate, siteCode);
								if (errCode != null && errCode.trim().length() > 0) {
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						} else {
							errCode = "VMSITENUL";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					} else if (childNodeName.equalsIgnoreCase("cust_code")) {
						custCode = this.genericUtility.getColumnValue("cust_code", dom);
						siteCode = this.genericUtility.getColumnValue("site_code", dom);
						if (custCode != null && custCode.trim().length() > 0) {
							sql = "select count(*) as COUNT from customer c join site_customer s on c.cust_code = s.cust_code and s.site_code = ? and c.cust_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, siteCode);
							pstmt.setString(2, custCode);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								cnt = rs.getInt("COUNT");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if (cnt == 0) {
								errCode = "VTCUSTCD8";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						} else {
							errCode = "VMCUSTCD1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					} else if (childNodeName.equalsIgnoreCase("bank_code")) {
						bankCode = this.genericUtility.getColumnValue("bank_code", dom);
						if (bankCode != null && bankCode.trim().length() > 0) {
							sql = "SELECT COUNT(*) AS COUNT FROM BANK WHERE BANK_CODE = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, bankCode);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								cnt = rs.getInt("COUNT");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if (cnt == 0) {
								errCode = "VMBANKMIS1";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						} else {
							errCode = "VMBANKCD1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					} else if (childNodeName.equalsIgnoreCase("chq_amt")) {
						chqAmtStr = this.genericUtility.getColumnValue("chq_amt", dom);
						if (chqAmtStr != null && chqAmtStr.trim().length() > 0) {
							chqAmt = Double.parseDouble(chqAmtStr);
							if (chqAmt <= 0) {
								errCode = "VTRCPAMT";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						} else {
							errCode = "VTRCPAMTNL";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}
				}
				break;
			case 2:
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for (ctr = 0; ctr < childNodeListLength; ctr++) {
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("ref_ser")) {
						refSer = this.genericUtility.getColumnValue("ref_ser", dom);
						custCode = this.genericUtility.getColumnValue("cust_code", dom2, "1");
						System.out.println("refSer : " + refSer + " :::custCode::: " + custCode);
						if (refSer != null && refSer.trim().length() > 0) {
							sql = "SELECT COUNT(*) AS COUNT FROM RECEIVABLES WHERE TRAN_SER = ?  and cust_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refSer);
							pstmt.setString(2, custCode);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								cnt = rs.getInt("COUNT");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if (cnt == 0) {
								errCode = "VTINVRESER";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
						} else {
							errCode = "VTNULRESER";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					} else if (childNodeName.equalsIgnoreCase("ref_no")) {
						refNo = this.genericUtility.getColumnValue("ref_no", dom);
						lineNo = genericUtility.getColumnValue("line_no", dom);
						refSer = genericUtility.getColumnValue("ref_ser", dom);
						custCode = this.genericUtility.getColumnValue("cust_code", dom2, "1");
						System.out.println("IN ref_no  validation : refNo:::"+ refNo +":::refSer:::" + refSer + ":::custCode:::" + custCode);
						if (refNo != null && refNo.trim().length() > 0) {
							sql = "SELECT COUNT(*) AS COUNT FROM RECEIVABLES WHERE REF_NO = ? and tran_ser = ? and cust_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, refNo);
							pstmt.setString(2, refSer);
							pstmt.setString(3, custCode);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								cnt = rs.getInt("COUNT");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if (cnt == 0) {
								errCode = "VTINVREFNO";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							} else {
								if (isDulplicateFrmDom(dom2, refNo, lineNo, refSer)) {
									errCode = "VTDUPREFNO";
									errList.add(errCode);
									errFields.add(childNodeName.toLowerCase());
								}
							}
						} else {
							errCode = "VTNULREFNO";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					} else if (childNodeName.equalsIgnoreCase("rcp_amt")) {
						rcpAmtStr = genericUtility.getColumnValue("rcp_amt", dom);
						refSer = genericUtility.getColumnValue("ref_ser", dom);
						refNo = genericUtility.getColumnValue("ref_no", dom);
						lineNo = genericUtility.getColumnValue("line_no", dom);
						custCode = this.genericUtility.getColumnValue("cust_code", dom1);
						siteCode = this.genericUtility.getColumnValue("site_code", dom1);
						chqAmtStr = this.genericUtility.getColumnValue("chq_amt", dom1);
						if (chqAmtStr != null && chqAmtStr.trim().length() > 0) {
							try {
								chqAmt = Double.parseDouble(chqAmtStr);
							} catch (NumberFormatException n) {
								chqAmt = 0;
							}
						}
						System.out.println("chqAmt>>>>>>[" + chqAmt + "]");
						/*
						 * if(rcpAmtNew <= 0) { errCode = "VTRCPAMT";
						 * errList.add(errCode);
						 * errFields.add(childNodeName.toLowerCase()); }
						 */
//TODO Took care of validation in PostSave Activity.
						/*sql = "SELECT (TOT_AMT - ADJ_AMT) AS AMT FROM RECEIVABLES WHERE TRAN_SER = ? AND REF_NO = ?  AND cust_code = ?  and site_code= ?  ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, checkNull(genericUtility.getColumnValue("ref_ser", dom)));
						pstmt.setString(2, checkNull(genericUtility.getColumnValue("ref_no", dom)));
						pstmt.setString(3, custCode);
						pstmt.setString(4, siteCode);
						rs = pstmt.executeQuery();
						if (rs.next()) {
							rcpAmt = rs.getDouble(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println("rcpAmtNew>>>[" + rcpAmtNew + "]rcpAmt[" + rcpAmt + "]");
						// Start added by chandr shekar on 21-mar-2016
						sql = "select nvl(sum(rcpdet.rcp_amt), 0) as amt from rcpdet_form rcpdet, receipt_form rcpform "
								+ "where rcpform.tran_id=rcpdet.tran_id and rcpdet.ref_ser=?  "
								+ "and rcpdet.rcp_amt>0 and rcpform.status !='X' and rcpdet.ref_no=? "
								+ "AND rcpform.cust_code = ? and rcpform.site_code= ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, checkNull(genericUtility.getColumnValue("ref_ser", dom)));
						pstmt.setString(2, checkNull(genericUtility.getColumnValue("ref_no", dom)));
						pstmt.setString(3, custCode);
						pstmt.setString(4, siteCode);
						rs = pstmt.executeQuery();
						if (rs.next()) {
							rcpAmtStatus = rs.getDouble(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						System.out.println("rcpAmtStatus>>>" + rcpAmtStatus);
						// End added by chandrashekar on 21-mar-2016
						if (rcpAmt - rcpAmtStatus < rcpAmtNew) {
							errCode = "VTINVTLAMT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}*/
						/*
						 * if (ischqAmtGreater(dom2,chqAmt,lineNo)) { errCode =
						 * "VTINVCQAMT"; errList.add(errCode);
						 * errFields.add(childNodeName.toLowerCase()); }
						 */
					}
				} // end for
				break; // case 2 end
			}

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if (errList != null && errListSize > 0) {
				for (cnt = 0; cnt < errListSize; cnt++) {
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........." + errCode);
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn, errCode);
					if (errString.length() > 0) {
						String bifurErrString = errString.substring(
								errString.indexOf("<Errors>") + 8,
								errString.indexOf("<trace>"));
						bifurErrString = bifurErrString
								+ errString.substring(
										errString.indexOf("</trace>") + 8,
										errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if (errorType.equalsIgnoreCase("E")) {
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			} else {
				errStringXml = new StringBuffer("");
			}

		} catch (Exception e) {
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null) {
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}

	// method for item change
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
		Document dom = null, dom1 = null, dom2 = null;
		String valueXmlString = "";
		System.out.println("xmlString............." + xmlString
				+ "\nxmlString1............" + xmlString1
				+ "\nxmlString2............" + xmlString2);
		try {
			if (xmlString != null && xmlString.trim().length() > 0) {
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0) {
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0) {
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom, dom1, dom2, objContext,
					currentColumn, editFlag, xtraParams);
		} catch (Exception e) {
			System.out
					.println("Exception : [EcollectionIC][itemChanged( String, String )] :==>\n"
							+ e.getMessage());
			throw new ITMException(e);
		}
		return valueXmlString;
	}

	// method for item change
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException {
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null, childNodeList = null;
		Node parentNode = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		ConnDriver connDriver = new ConnDriver();
		int currentFormNo = 0, childNodeListLength = 0, ctr = 0;
		String columnValue = "", loginSite = "", loginSiteDesc = "", siteCodeDesc = "", hdrCustCode = "", hdrSiteCode = "", bankCode = "", siteCode = "", custCode = "", bankName = "", custName = "", refNo = "", refSer = "", currencyCode = "", sql = "";
		double rcpAmt1 = 0, exchangeRate = 0.0;

		try {
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(currentDate.getTime());
			// Changes and Commented By Bhushan on 06-06-2016 :START
			// conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			// Changes and Commented By Bhushan on 06-06-2016 :END
			conn.setAutoCommit(false);
			connDriver = null;
			FinCommon finCommon = new FinCommon();

			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext.trim());
			}

			System.out.println("Now the date is :=>  " + sysDate);

			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			
			UserInfoBean userInfo = getUserInfo();
			String userLevel = userInfo.getUserLevel();

			System.out.println("**********ITEMCHANGE FOR CASE" + currentFormNo + "**************" + userLevel);
			
			switch (currentFormNo) {
			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				childNodeListLength = childNodeList.getLength();
				System.out.println("currentColumn[" + currentColumn + "]columnValue ==> '" + columnValue + "'");
				valueXmlString.append("<Detail1>");
				if (currentColumn.trim().equalsIgnoreCase("itm_default")) {
					loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSite");

					sql = "SELECT DESCR,BANK_CODE FROM SITE WHERE SITE_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, loginSite);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						loginSiteDesc = rs.getString("DESCR");
						bankCode = rs.getString("BANK_CODE");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					sql = "SELECT BANK_NAME,CURR_CODE FROM BANK WHERE BANK_CODE =?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, bankCode);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						bankName = checkNull(rs.getString("BANK_NAME"));
						// currencyCode = checkNull(rs.getString("CURR_CODE"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					valueXmlString.append("<tran_date><![CDATA[").append(checkNull(sysDate)).append("]]></tran_date>\r\n");
					valueXmlString.append("<eff_date><![CDATA[").append(checkNull(sysDate)).append("]]></eff_date>\r\n");
					if("2".equalsIgnoreCase(userLevel)) {
						valueXmlString.append("<site_code protect = '1'><![CDATA[").append(loginSite).append("]]></site_code>\r\n");
					} else {
						valueXmlString.append("<site_code><![CDATA[").append(loginSite).append("]]></site_code>\r\n");
					}
					
					valueXmlString.append("<descr><![CDATA[").append(loginSiteDesc).append("]]></descr>\r\n");
					valueXmlString.append("<bank_code><![CDATA[").append(bankCode).append("]]></bank_code>\r\n");
					valueXmlString.append("<status><![CDATA[").append("E").append("]]></status>\r\n");
					valueXmlString.append("<tran_type><![CDATA[").append("E").append("]]></tran_type>\r\n");
					valueXmlString.append("<bank_name>").append("<![CDATA[" + bankName + "]]>").append("</bank_name>\r\n");
					valueXmlString.append("<curr_code>").append("<![CDATA[" + currencyCode + "]]>").append("</curr_code>\r\n");
					// exchangeRate =
					// finCommon.getDailyExchRateSellBuy(currencyCode,"",loginSite,
					// checkNull(sysDate), "S", conn);
					// System.out.println("exchangeRate>>>>["+exchangeRate+"]");
					valueXmlString.append("<exch_rate>").append("<![CDATA[" + exchangeRate + "]]>").append("</exch_rate>\r\n");

				} else if (currentColumn.trim().equalsIgnoreCase("bank_code")) {
					bankCode = checkNull(genericUtility.getColumnValue(
							"bank_code", dom));
					currencyCode = checkNull(genericUtility.getColumnValue(
							"curr_code", dom));
					siteCode = checkNull(genericUtility.getColumnValue(
							"site_code", dom));

					sql = "SELECT BANK_NAME,CURR_CODE FROM BANK WHERE BANK_CODE =?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, bankCode);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						bankName = checkNull(rs.getString("BANK_NAME"));
						// currencyCode = checkNull(rs.getString("CURR_CODE"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					System.out.println("date>>>>>>"
							+ genericUtility.getColumnValue("tran_date", dom));
					// exchangeRate =
					// finCommon.getDailyExchRateSellBuy(currencyCode,"",siteCode,
					// genericUtility.getColumnValue("tran_date", dom), "S",
					// conn);
					// System.out.println("exchangeRate>>>>@@@@@@@@@["+exchangeRate+"]");
					valueXmlString.append("<bank_name>")
							.append("<![CDATA[" + bankName + "]]>")
							.append("</bank_name>\r\n");
					// valueXmlString.append("<curr_code>").append("<![CDATA["+currencyCode+"]]>").append("</curr_code>\r\n");
					// valueXmlString.append("<exch_rate>").append("<![CDATA["+exchangeRate+"]]>").append("</exch_rate>\r\n");

				} else if (currentColumn.trim().equalsIgnoreCase("cust_code")) {
					custCode = checkNull(genericUtility.getColumnValue("cust_code", dom));
					siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));
					//sql = "SELECT CUST_NAME, CURR_CODE FROM CUSTOMER WHERE CUST_CODE = ?";
					//TODO
					sql = "select c.cust_name as CUST_NAME, c.curr_code as CURR_CODE from customer c join site_customer s on c.cust_code = s.cust_code and s.site_code = ? and c.cust_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, custCode);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						custName = checkNull(rs.getString("CUST_NAME"));
						currencyCode = rs.getString("CURR_CODE");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					exchangeRate = finCommon.getDailyExchRateSellBuy(
							currencyCode, "", loginSite, checkNull(sysDate),
							"S", conn);
					System.out.println("exchangeRate in  (cust_code) :"
							+ exchangeRate);
					valueXmlString.append("<exch_rate>")
							.append("<![CDATA[" + exchangeRate + "]]>")
							.append("</exch_rate>\r\n");
					valueXmlString.append("<curr_code><![CDATA[")
							.append(currencyCode).append("]]></curr_code>\r\n");
					valueXmlString.append("<cust_name><![CDATA[")
							.append(custName).append("]]></cust_name>\r\n");

				} else if (currentColumn.trim().equalsIgnoreCase("site_code")) {
					siteCode = checkNull(genericUtility.getColumnValue(
							"site_code", dom));

					sql = "SELECT DESCR,BANK_CODE FROM SITE WHERE SITE_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						siteCodeDesc = checkNull(rs.getString("DESCR"));
						bankCode = rs.getString("BANK_CODE");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					sql = "SELECT BANK_NAME,CURR_CODE FROM BANK WHERE BANK_CODE =?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, bankCode);
					rs = pstmt.executeQuery();
					if (rs.next()) {
						bankName = checkNull(rs.getString("BANK_NAME"));
						// currencyCode = checkNull(rs.getString("CURR_CODE"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					System.out.println("date>>>>>>"
							+ genericUtility.getColumnValue("tran_date", dom));
					// exchangeRate =
					// finCommon.getDailyExchRateSellBuy(currencyCode,"",siteCode,
					// genericUtility.getColumnValue("tran_date", dom), "S",
					// conn);
					// System.out.println("exchangeRate>>>>@@@@@@@@@>>>>>>>>>["+exchangeRate+"]");
					valueXmlString.append("<descr><![CDATA[")
							.append(siteCodeDesc).append("]]></descr>\r\n");
					valueXmlString.append("<bank_code><![CDATA[")
							.append(bankCode).append("]]></bank_code>\r\n");
					valueXmlString.append("<bank_name><![CDATA[")
							.append(bankName).append("]]></bank_name>\r\n");
					/*
					 * valueXmlString.append("<curr_code>").append("<![CDATA["+
					 * currencyCode+"]]>").append("</curr_code>\r\n");
					 * valueXmlString
					 * .append("<exch_rate>").append("<![CDATA["+exchangeRate
					 * +"]]>").append("</exch_rate>\r\n");
					 */
				}
				valueXmlString.append("</Detail1>");
				break;
			case 2:
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				valueXmlString.append("<Detail2>");
				childNodeListLength = childNodeList.getLength();
				System.out.println("currentColumn[" + currentColumn + "] ==> '" + columnValue + "'");
				if (currentColumn.trim().equalsIgnoreCase("itm_default")) {
					hdrCustCode = this.genericUtility.getColumnValue("cust_code", dom1);
					hdrSiteCode = this.genericUtility.getColumnValue("site_code", dom1);
					valueXmlString.append("<line_no__ref><![CDATA[").append("1").append("]]></line_no__ref>\r\n");
					valueXmlString.append("<udf_str1><![CDATA[").append(hdrSiteCode).append("]]></udf_str1>\r\n");
					valueXmlString.append("<udf_str2><![CDATA[").append(hdrCustCode).append("]]></udf_str2>\r\n");
				} else if (currentColumn.trim().equalsIgnoreCase("ref_no")
						|| currentColumn.trim().equalsIgnoreCase("ref_ser")) {
					refNo = checkNull(genericUtility.getColumnValue("ref_no",
							dom));
					refSer = checkNull(genericUtility.getColumnValue("ref_ser",
							dom));
					custCode = this.genericUtility.getColumnValue("cust_code",
							dom1);
					siteCode = this.genericUtility.getColumnValue("site_code",
							dom1);
					sql = "SELECT (TOT_AMT - ADJ_AMT) AS AMT FROM RECEIVABLES  WHERE TRAN_SER = ? AND REF_NO = ? and cust_code= ? and site_code = ?  ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, refSer);
					pstmt.setString(2, refNo);
					pstmt.setString(3, custCode);
					pstmt.setString(4, siteCode);
					rs = pstmt.executeQuery();

					if (rs.next()) {
						rcpAmt1 = rs.getDouble(1);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					System.out.println("receipt amount["
							+ getRequiredDecimal(rcpAmt1, 2) + "]");
					valueXmlString.append("<rcp_amt><![CDATA[")
							.append(getRequiredDecimal(rcpAmt1, 2))
							.append("]]></rcp_amt>\r\n");
				}

				valueXmlString.append("</Detail2>");
				break;
			}
			valueXmlString.append("</Root>");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null) {
					if (rs != null) {
						rs.close();
						rs = null;
					}
					if (pstmt != null) {
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			} catch (Exception d) {
				d.printStackTrace();
			}
		}
		return valueXmlString.toString();
	}

	private String checkNull(String input) {
		if (input == null) {
			input = "";
		}
		return input;
	}

	public String getRequiredDecimal(double actVal, int prec)// Added by
																// chandrashekar
																// on 11-08-14
	{
		String fmtStr = "############0";
		if (prec > 0) {
			fmtStr = fmtStr + "." + "000000000".substring(0, prec);
		}
		DecimalFormat decFormat = new DecimalFormat(fmtStr);
		return decFormat.format(actVal);
	}

	public static java.util.Date relativeDate(java.util.Date date, int days) {
		java.util.Date calculatedDate = null;
		if (date != null) {
			final GregorianCalendar calendar = new GregorianCalendar();
			calendar.setTime(date);
			calendar.add(Calendar.DATE, days);
			calculatedDate = new java.util.Date(calendar.getTime().getTime());
		}
		return calculatedDate;
	}

	private String errorType(Connection conn, String errorCode)
			throws ITMException {
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try {
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				msgType = rs.getString("MSG_TYPE");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new ITMException(ex);
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return msgType;
	}

	private boolean isDulplicateFrmDom(Document dom, String refNo,
			String lineNo, String refSer) throws ITMException {
		NodeList parentList = null, childList = null;
		Node parentNode = null, childNode = null;
		String lineNoDom = "", refNoDom = "", refSerDom = "";
		boolean isDulplicate = false;
		System.out.println("---inside method[isDulplicateFrmDom] -- EJB ["
				+ this.getClass().getSimpleName() + "]");
		try {
			parentList = dom.getElementsByTagName("Detail2");
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = parentNodeListLength; prntCtr > 0; prntCtr--) {
				parentNode = parentList.item(prntCtr - 1);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++) {
					childNode = childList.item(ctr);
					if (childNode != null
							&& childNode.getNodeName().equalsIgnoreCase(
									"attribute")) {
						String updateFlag = "";
						updateFlag = childNode.getAttributes()
								.getNamedItem("updateFlag").getNodeValue();
						if (updateFlag.equalsIgnoreCase("D")) {
							System.out
									.println("Break from here as the record is deleted");
							break;
						}
					}
					if (childNode != null
							&& childNode.getFirstChild() != null
							&& childNode.getNodeName().equalsIgnoreCase(
									"line_no")) {
						lineNoDom = childNode.getFirstChild().getNodeValue()
								.trim();
						System.out.println("lineNo[" + lineNo + "]lineNoDom["
								+ lineNoDom + "]");
						if (lineNo.equalsIgnoreCase(lineNoDom)) {
							System.out
									.println("Break from here as line No match");
							break;
						}
					}
					if (childNode != null
							&& childNode.getFirstChild() != null
							&& childNode.getNodeName().equalsIgnoreCase(
									"ref_no")) {
						refNoDom = childNode.getFirstChild().getNodeValue()
								.trim();
					}
					if (childNode != null
							&& childNode.getFirstChild() != null
							&& childNode.getNodeName().equalsIgnoreCase(
									"ref_ser")) {
						refSerDom = childNode.getFirstChild().getNodeValue()
								.trim();
					}
				}
				if (refSer.trim().equalsIgnoreCase(refSerDom.trim())
						&& refNo.trim().equalsIgnoreCase(refNoDom.trim())) {
					isDulplicate = true;
					break;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		System.out.println("returning from method[isDulplicateFrmDom] -- EJB ["
				+ this.getClass().getSimpleName() + "] return Value : ["
				+ isDulplicate + "]");
		return isDulplicate;
	}

	@SuppressWarnings("unused")
	private boolean ischqAmtGreater(Document dom, double chqAmt, String lineNo) {
		NodeList parentList = null, childList = null;
		Node parentNode = null, childNode = null;
		String rcpAmtSt = "";
		boolean ischqAmtGreater = false;
		double chqAmtMeth = 0.0, chqAmtSum = 0.0;
		System.out.println("---inside ischqAmtGreater--");
		try {
			parentList = dom.getElementsByTagName("Detail2");
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = parentNodeListLength; prntCtr > 0; prntCtr--) {
				parentNode = parentList.item(prntCtr - 1);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++) {
					childNode = childList.item(ctr);
					System.out.println("childNode>>>" + childNode);
					if (childNode != null && childNode.getNodeName().equalsIgnoreCase("attribute")) {
						String updateFlag = "";
						updateFlag = childNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
						System.out.println("updateFlag>>>" + updateFlag);
						if (updateFlag.equalsIgnoreCase("D")) {
							System.out.println("Break from here as the record is deleted");
							break;
						}
					}
					if (childNode != null && childNode.getFirstChild() != null && childNode.getNodeName().equalsIgnoreCase("rcp_amt")) {
						rcpAmtSt = childNode.getFirstChild().getNodeValue().trim();
						if (rcpAmtSt != null && rcpAmtSt.trim().length() > 0) {
							try {
								chqAmtMeth = Double.parseDouble(rcpAmtSt);
							} catch (NumberFormatException n) {
								chqAmtMeth = 0;
							}
						}
					}
				}
				chqAmtSum = chqAmtSum + chqAmtMeth;
			}
			System.out.println("chqAmtSum>>>[" + chqAmtSum + "]chqAmt>>>>[" + chqAmt + "]");
			if (chqAmt < chqAmtSum) {
				ischqAmtGreater = true;
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		System.out.println("ischqAmtGreater>>>>>> [" + ischqAmtGreater + "]");
		return ischqAmtGreater;
	}
}
