package ibase.webitm.ejb.fin.adv;

import java.io.*;
import java.sql.*;
import java.sql.Date;
import java.util.*;
import java.lang.*;
import org.w3c.dom.*;
import javax.ejb.*;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import java.text.ParseException;
import java.text.SimpleDateFormat;


import javax.ejb.Stateless;

@Stateless
public class ReverseChargeInvoiceGpGen extends ProcessEJB implements ReverseChargeInvoiceGpGenLocal,ReverseChargeInvoiceGpGenRemote
{
	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	DistCommon distCommon = new DistCommon();
	
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String retStr = "";
		Document dom = null;
		Document dom2 = null;
//		GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{	
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
		    retStr = process(dom,dom2, windowName, xtraParams);
		}
		catch (Exception e)
		{
			System.out.println("Exception :BankRecoEJB :getData(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retStr;
	}
	
	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Inside Process method:::::::");
		String S1=null,errCode="";
		Timestamp frDate=null,toDate=null,confDt=null,GpDate=null;
		String siteCode=null,tranId=null;
		String sql=null,sqlupd=null,sql1=null;
		String GPSer=null,GPSerFilt=null;
		String GPNo=null,tranDt=null,errString=null;
		Connection con = null;
		int cnt=0;
		PreparedStatement pstmt=null,pstmt1=null;
		boolean count=false;
		ResultSet rs=null,rs1=null;
		E12GenericUtility genericUtility=new E12GenericUtility();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		
		try
		{
			con=getConnection();
			String fromDT=genericUtility.getColumnValue("from_date", headerDom);
			String toDT=genericUtility.getColumnValue("to_date", headerDom);
			siteCode=genericUtility.getColumnValue("site_code",headerDom);
			System.out.println("From Date::::"+fromDT);
			System.out.println("To Date::::"+toDT);
			System.out.println("SiteCode::::"+siteCode);
			if(fromDT==null || fromDT.trim().length()==0)
			{
				errCode="VPEDATE1";
				errString = itmDBAccessEJB.getErrorString("",errCode,"","",con);
				return errString;
			}
			if(toDT==null || toDT.trim().length()==0)
			{
				errCode="VPEDATE1";
				errString = itmDBAccessEJB.getErrorString("",errCode,"","",con);
				return errString;
				
			}
			if(compareDates(fromDT,toDT))
			{
				errCode="VFRTODATE";
				errString = itmDBAccessEJB.getErrorString("",errCode,"","",con);
				return errString;
			}
			
			if(siteCode==null)
			{
				errCode="VTSITEEMT";
				errString = itmDBAccessEJB.getErrorString("",errCode,"","",con);
				return errString;
			}
			if(siteCode !=null && siteCode.trim().length() > 0)
			{
				sql = "select COUNT(1) from site where site_code = ? ";
				pstmt = con.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					cnt = rs.getInt(1);
 				}
				if(rs != null)
					rs.close();
				rs = null;
				if(pstmt != null)
					pstmt.close();
				pstmt = null;
				if(cnt==0)
				{
					errCode="INVDSITECD";
					errString = itmDBAccessEJB.getErrorString("",errCode,"","",con);
					return errString;
				}
			}
			
			frDate=Timestamp.valueOf(genericUtility.getValidDateTimeString(fromDT,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()));
			toDate=Timestamp.valueOf(genericUtility.getValidDateTimeString(toDT,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()));
			System.out.println("From Date::::"+frDate);
			System.out.println("To Date::::"+toDate);
			System.out.println("SiteCode::::"+siteCode);
			
			GPSerFilt=genericUtility.getColumnValue("gp_ser",headerDom);
			
			
			
			
			
			sql="Select gp_ser,tran_date,gp_date,tran_id,conf_date from voucher i,supplier c, site s, state state where "
					+ "c.supp_code = i.supp_code and s.site_code = i.site_code and i.site_code=? and i.gp_no is null and state.state_code = c.STATE_CODE and "
					+ "(c.tax_reg_2 = 'UNREGISTER' or c.tax_reg_2 is null )"
					+ " and (select count(1) from taxtran ti, tax tm where tm.tax_code = ti.tax_code and ti.tran_code = 'VOUCH' and ti.tran_id = i.tran_id and tm.tax_type in ('G','H','I','J') ) > 0 "
					+ " and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' and i.conf_date between ? and ? ";
			pstmt=con.prepareStatement(sql);
			//pstmt.setString(1,"voucher");
			pstmt.setString(1,siteCode);
			pstmt.setTimestamp(2,frDate);
			pstmt.setTimestamp(3,toDate);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				tranDt=rs.getString("tran_date");
				GPSer=checkNull(rs.getString("gp_ser"));
				GpDate=rs.getTimestamp("gp_date");
				tranId=rs.getString("tran_id");
				confDt=rs.getTimestamp("conf_date");
				
				System.out.println("tran_date::::"+tranDt);
				System.out.println("gp_ser::::"+GPSer);
				System.out.println("tran_id::::"+tranId);
				System.out.println("conf_date::::"+confDt);
				System.out.println("confirm Date::::"+confDt);
				if(GPSer==null || GPSer.length()==0)
				{
					errCode="VMPGPSER";
					errString = itmDBAccessEJB.getErrorString("",errCode,"","",con);
					return errString;
				}
				if(GpDate==null)
				{
					GPNo=generateGPNO(siteCode,GPSer,confDt,con);
				}
				else
				{
					GPNo=generateGPNO(siteCode,GPSer,GpDate,con);
				}
				System.out.println("GP NO:::::::::"+GPNo);
				
				sqlupd="update voucher set gp_no =?,gp_date=? where tran_id=?";
				pstmt1=con.prepareStatement(sqlupd);
				//pstmt1.setString(1, "voucher");
				pstmt1.setString(1, GPNo);
				if(GpDate==null)
				{
					System.out.println("Inside null GP DATE");
					pstmt1.setTimestamp(2,confDt);
				}
				else
				{
				    pstmt1.setTimestamp(2, GpDate);
				}
				pstmt1.setString(3, tranId);
				pstmt1.executeUpdate();
				count=true;
				cnt++;
			}
			if(count)
			{
			pstmt.close();
			pstmt=null;
			rs.close();
			rs=null;
			sqlupd=null;
			pstmt1.close();
			pstmt1=null;
			count=false;
			}
			sql1="select gp_ser,tran_date,gp_date,tran_id,conf_date from misc_voucher i,supplier c, site s, state state where"
					+ " c.supp_code = i.sundry_code and i.sundry_type = 'S' and s.site_code = i.site_code and i.site_code=? and i.gp_no is null and state.state_code = c.STATE_CODE and"
					+ " (c.tax_reg_2 = 'UNREGISTER' or c.tax_reg_2 is null)"
					+ " and (select count(1) from taxtran ti,tax tm where tm.tax_code = ti.tax_code and ti.tran_code = 'M-VOUC' and ti.tran_id = i.tran_id and tm.tax_type in ('G','H','I','J') ) > 0"
					+ " and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' and i.conf_date between ? and ? ";
			pstmt=con.prepareStatement(sql1);
			//pstmt.setString(1,"voucher");
			pstmt.setString(1,siteCode);
			pstmt.setTimestamp(2,frDate);
			pstmt.setTimestamp(3,toDate);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				tranDt=rs.getString("tran_date");
				GPSer=checkNull(rs.getString("gp_ser"));
				GpDate=rs.getTimestamp("gp_date");
				tranId=rs.getString("tran_id");
				confDt=rs.getTimestamp("conf_date");
				
				System.out.println("tran_date::::"+tranDt);
				System.out.println("gp_date::::"+GpDate);
				System.out.println("tran_id::::"+tranId);
				System.out.println("conf_date::::"+confDt);
				if(GPSer==null || GPSer.length()==0)
				{
					errCode="VMPGPSER";
					errString = itmDBAccessEJB.getErrorString("",errCode,"","",con);
					return errString;
					
				}

				if(GpDate==null)
				{
					GPNo=generateGPNO(siteCode,GPSer,confDt,con);
				}
				else
				{
					GPNo=generateGPNO(siteCode,GPSer,GpDate,con);
				}
				System.out.println("GP NO:::::::::"+GPNo);
				
				sqlupd="update misc_voucher set gp_no =?,gp_date=? where tran_id=?";
				pstmt1=con.prepareStatement(sqlupd);
				//pstmt1.setString(1, "voucher");
				pstmt1.setString(1, GPNo);
				if(GpDate==null)
				{
					System.out.println("Inside null GP DATE NULL");
					pstmt1.setTimestamp(2,confDt);
				}
				else
				{
				    pstmt1.setTimestamp(2, GpDate);
				}
				pstmt1.setString(3, tranId);
				pstmt1.executeUpdate();
				count=true;
				cnt++;
				//pstmt1.clearParameters();
			
			}
			if(count)
			{
			pstmt.close();
			pstmt=null;
			rs.close();
			rs=null;
			sqlupd=null;
			pstmt1.close();
			pstmt1=null;
			count=false;
			}
			
			//Generating GP no for payable DR
			sql="Select gp_ser,tran_date,gp_date,tran_id,conf_date from drcr_pay i,supplier c, site s, state state where "
					+ "c.supp_code = i.supp_code and s.site_code = i.site_code and i.site_code=? and drcr_flag='D' and i.gp_no is null and state.state_code = c.STATE_CODE and "
					+ "(c.tax_reg_2 = 'UNREGISTER' or c.tax_reg_2 is null )"
					+ " and (select count(1) from taxtran ti, tax tm where tm.tax_code = ti.tax_code and ti.tran_code = 'DRNPAY' and ti.tran_id = i.tran_id and tm.tax_type in ('G','H','I','J') ) > 0 "
					+ " and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' and i.conf_date between ? and ? ";
			
			pstmt=con.prepareStatement(sql);
			//pstmt.setString(1,"voucher");
			pstmt.setString(1,siteCode);
			pstmt.setTimestamp(2,frDate);
			pstmt.setTimestamp(3,toDate);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				tranDt=rs.getString("tran_date");
				GPSer=checkNull(rs.getString("gp_ser"));
				GpDate=rs.getTimestamp("gp_date");
				tranId=rs.getString("tran_id");
				confDt=rs.getTimestamp("conf_date");
				
				System.out.println("tran_date::::"+tranDt);
				System.out.println("gp_date::::"+GPSer);
				System.out.println("tran_id::::"+tranId);
				System.out.println("conf_date::::"+confDt);
				if(GPSer==null || GPSer.length()==0)
				{
					errCode="VMPGPSER";
					errString = itmDBAccessEJB.getErrorString("",errCode,"","",con);
					return errString;
					
				}
				if(GpDate==null)
				{
					GPNo=generateGPNO(siteCode,GPSer,confDt,con);
				}
				else
				{
					GPNo=generateGPNO(siteCode,GPSer,GpDate,con);
				}
				System.out.println("GP NO:::::::::"+GPNo);
				
				sqlupd="update drcr_pay set gp_no =?,gp_date=? where tran_id=?";
				pstmt1=con.prepareStatement(sqlupd);
				//pstmt1.setString(1, "misc_voucher");
				pstmt1.setString(1, GPNo);
				if(GpDate==null)
				{
					System.out.println("Inside null GP DATE NULL");
					pstmt1.setTimestamp(2,confDt);
				}
				else
				{
				    pstmt1.setTimestamp(2, GpDate);
				}
				pstmt1.setString(3, tranId);
				pstmt1.executeUpdate();
				count=true;
				cnt++;
				//pstmt1.executeUpdate();
				
				//pstmt1.clearParameters();

			}
			if(count)
			{
			pstmt.close();
			pstmt=null;
			rs.close();
			rs=null;
			sqlupd=null;
			pstmt1.close();
			pstmt1=null;
			count=false;
			}
			
			//Generating GP no for payable CR
			sql="Select gp_ser,tran_date,gp_date,tran_id,conf_date from drcr_pay i,supplier c, site s, state state where "
					+ "c.supp_code = i.supp_code and s.site_code = i.site_code and i.site_code=? and drcr_flag='C' and i.gp_no is null and state.state_code = c.STATE_CODE and "
					+ "(c.tax_reg_2 = 'UNREGISTER' or c.tax_reg_2 is null )"
					+ " and (select count(1) from taxtran ti, tax tm where tm.tax_code = ti.tax_code and ti.tran_code = 'CRNPAY' and ti.tran_id = i.tran_id and tm.tax_type in ('G','H','I','J') ) > 0 "
					+ " and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' and i.conf_date between ? and ? ";
			
			pstmt=con.prepareStatement(sql);
			//pstmt.setString(1,"voucher");
			pstmt.setString(1,siteCode);
			pstmt.setTimestamp(2,frDate);
			pstmt.setTimestamp(3,toDate);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				tranDt=rs.getString("tran_date");
				GPSer=checkNull(rs.getString("gp_ser"));
				GpDate=rs.getTimestamp("gp_date");
				tranId=rs.getString("tran_id");
				confDt=rs.getTimestamp("conf_date");
				
				System.out.println("tran_date::::"+tranDt);
				System.out.println("gp_date::::"+GPSer);
				System.out.println("tran_id::::"+tranId);
				System.out.println("conf_date::::"+confDt);
				if(GPSer==null || GPSer.length()==0)
				{
					errCode="VMPGPSER";
					errString = itmDBAccessEJB.getErrorString("",errCode,"","",con);
					return errString;
					
				}
				;
				if(GpDate==null)
				{
					GPNo=generateGPNO(siteCode,GPSer,confDt,con);
				}
				else
				{
					GPNo=generateGPNO(siteCode,GPSer,GpDate,con);
				}
				System.out.println("GP NO:::::::::"+GPNo);
				
				sqlupd="update drcr_pay set gp_no =?,gp_date=? where tran_id=?";
				pstmt1=con.prepareStatement(sqlupd);
				//pstmt1.setString(1, "misc_voucher");
				pstmt1.setString(1, GPNo);
				if(GpDate==null)
				{
					System.out.println("Inside null GP DATE NULL");
					pstmt1.setTimestamp(2,confDt);
				}
				else
				{
				    pstmt1.setTimestamp(2, GpDate);
				}
				pstmt1.setString(3, tranId);
				pstmt1.executeUpdate();
				count=true;
				cnt++;
		
			}
			if(count)
			{
			pstmt.close();
			pstmt=null;
			rs.close();
			rs=null;
			sqlupd=null;
			pstmt1.close();
			pstmt1=null;
			}
			if(cnt==0)
			{
				errCode="NODATAERR";
				errString = itmDBAccessEJB.getErrorString("",errCode,"","",con);
				
			}
			if (errCode.equals("") || errCode.trim().length() == 0)
			{
				errCode = "VMSUCC";
				errString = itmDBAccessEJB.getErrorString("",errCode,"","",con);
				con.commit();
			}
			else
			{
				
			}

		}
		catch(Exception e)
		{
			try 
			{
				System.out.println("@@@@@@@@@ Exception.........conn.rollback().........");
				con.rollback();
			}
			catch (SQLException e1) 
			{
				e1.printStackTrace();
				System.out.println("Exception ::"+ e1.getMessage()); 
				throw new ITMException(e1); 
			};
			System.out.println(e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
			
		}
		finally
		{

			try
			{	
				//con.rollback();
			

				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(con !=null)
				{
					con.close();
					con=null;
				}
				
				
			}
			catch(Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception ::"+e.getMessage());
				throw new ITMException(e);
			}
		}

		return  errString;
		
	}
	public String generateGPNO(String site,String gpSer,Timestamp gpDate,Connection conn) throws Exception
	{
		E12GenericUtility genericUtility=new E12GenericUtility();
		String GPno = "",orderType = "",orderTypes = "",keyString = "",keyCol = "",tranSer = "",varValue="";
		String siteCodeExc="";
		SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
		SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
		DistCommon dis = new DistCommon();
		//SELECTING ORDER TYPE OF SALES ORDER

		PreparedStatement pstmt3 = null;

		ResultSet rs = null, rs1 = null,rs3 = null;
		String sql = "",sql1 = "";

		/*sql1 = "select order_type from sorder where  sale_order = ?  ";
		pstmt3 = conn.prepareStatement(sql1);
		pstmt3.setString(1,SOrderNo);
		rs3 = pstmt3.executeQuery();
		while(rs3.next())
		{
			orderType = rs3.getString("order_type");

		}
		rs3.close();
		rs3 = null;
		pstmt3.close();
		pstmt3 = null;*/
		varValue=distCommon.getDisparams("999999", "GP_NO_REQ", conn);
		if("NULLFOUND".equalsIgnoreCase(varValue))
		{
			varValue = "Y";
		}
		if("Y".equals(varValue))
		{
			sql1 = "select site_code__exc "
				+" from site where site_code = ? ";

			pstmt3 = conn.prepareStatement(sql1);
			pstmt3.setString(1,site);
			rs1 = pstmt3.executeQuery();
			if(rs1.next())
			{
				siteCodeExc = checkNull(rs1.getString("site_code__exc"));
			}
			rs1.close();
			rs1 = null;
			pstmt3.close();
			pstmt3 = null;
			System.out.println("gp_date["+gpDate+"]");
			System.out.println("gp_date Format["+sdf.format(gpDate)+"]");
			System.out.println("gp_date Format["+sdf1.format(gpDate)+"]");
			String xmlValues = "";
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +	"<tran_id/>";
			xmlValues = xmlValues + "<site_code>" + siteCodeExc + "</site_code>";
			xmlValues = xmlValues + "<tran_date>"+ gpDate + "</tran_date>";
			xmlValues = xmlValues + "<gp_ser>"+ gpSer + "</gp_ser>";
			xmlValues = xmlValues + "<gp_date>"+ sdf1.format(gpDate) + "</gp_date>";
			xmlValues = xmlValues + "</Detail1></Root>";


			varValue=	distCommon.getDisparams("999999", "EXC_SITE_NO", conn);
			System.out.println("varValue===="+varValue);

			if(	varValue.contains(siteCodeExc))
			{

				site = siteCodeExc+gpSer;//Code need to be migrated

			}
			else
			{

				site = siteCodeExc;//Code need to be migrated

			}

		sql1 = "select key_string, TRAN_ID_COL, REF_SER  from	 transetup where  tran_window = 'gpno'";
		pstmt3 = conn.prepareStatement(sql1);
		rs3 = pstmt3.executeQuery();
		while(rs3.next())
		{
			keyString = rs3.getString("key_string");
			keyCol = rs3.getString("TRAN_ID_COL");
			tranSer = rs3.getString("REF_SER");

		}
		rs3.close();
		rs3 = null;
		pstmt3.close();
		pstmt3 = null;

		TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
		GPno =  tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
		System.out.println("GP NO Generated :::::::::"+GPno);

		return GPno;
	}
		return " ";
}
	private String checkNull(String inp)
	{
		if(inp == null)
			inp = " ";
		return inp.trim();
	}
	public boolean compareDates(String d1,String d2)
    {
		boolean err=false;
        try{
            
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy");
            java.util.Date date1 = sdf.parse(d1);
            java.util.Date date2 = sdf.parse(d2);

            System.out.println("Date1"+sdf.format(date1));
            System.out.println("Date2"+sdf.format(date2));System.out.println();

            // Create 2 dates ends
            //1

            // Date object is having 3 methods namely after,before and equals for comparing
            // after() will return true if and only if date1 is after date 2
            if(date1.after(date2)){
                err=true;
            }
            
           
        }
        catch(ParseException ex){
            ex.printStackTrace();
        }
        return err;
    }


	
	

}
