package ibase.webitm.ejb.gst;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
//import ibase.utility.E12GenericUtility;
import ibase.utility.GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import java.rmi.RemoteException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.w3c.dom.Document;


@javax.ejb.Stateless
public class GstDataPrc extends ProcessEJB implements GstDataPrcLocal,GstDataPrcRemote 
{
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	//E12GenericUtility genericUtility = new E12GenericUtility();
	GenericUtility genericUtility = new GenericUtility();
	DistCommon distCommon = new DistCommon();
	FinCommon finCommon = new FinCommon();
	
	Connection connLocal = null,connGST = null;
	String taxClassAllStr = "", taxEnvAllStr = "",GST_EXPWP_TAXCLASS = "",GST_EXPWOP_TAXCLASS = "",GST_SEZWP_TAXCLASS = "",
			GST_SEZWOP_TAXCLASS = "",GST_DE_TAXCLASS = "",
			GST_NIL_TAXCLASS = "",GST_EXE_TAXCLASS = "",GST_EXPWP_TAXENV = "",GST_EXPWOP_TAXENV = "",GST_SEZWP_TAXENV = "",
			GST_SEZWOP_TAXENV = "",GST_DE_TAXENV = "",GST_NIL_TAXENV = "",GST_EXE_TAXENV = "",gstB2CLInvValStr = "";
	Timestamp fromDate = null, toDate = null;
	String chgUser = "",chgTerm = "",loginSiteCode = "",currDateStr = "";
	java.sql.Timestamp currDate = null,sysDate = null;
	Timestamp currMonthStartDate = null;
	double GST_B2CL_INV_VAL = 0.0;
	
	StringBuffer errorMessage = new StringBuffer();

	public String process() throws RemoteException, ITMException 
	{
		return "";
	}

	public String process(String xmlString, String xmlString2,String windowName, String xtraParams) throws RemoteException,ITMException 
	{
		String retStr = "";
		Document detailDom = null;
		Document headerDom = null;
		
		try 
		{
			System.out.println("xmlString   [" + xmlString + "]");
			System.out.println("xmlString2  [" + xmlString2 + "]");
			System.out.println("windowName   [" + windowName + "]");
			System.out.println("xtraParams   [" + xtraParams + "]");
			
			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				headerDom = genericUtility.parseString(xmlString);
			}
			if (xmlString2 != null && xmlString2.length() != 0) 
			{
				detailDom = genericUtility.parseString(xmlString2);
			}
			
			retStr = process(headerDom, detailDom, windowName, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception GstDataPrc :process()"+ e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retStr;
	}

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		//Connection connGST = null,connLocal = null;	
		ConnDriver connDriverGST = null,connDriverLocal = null;
		
		PreparedStatement pstmt = null,pstmtInsHdr = null,pstmtInsDet = null, pstmtSelHdr = null,pstmtSelDet = null; 
		ResultSet rs = null, rsSelHdr= null, rsSelDet = null;
		
		String period = "", type = "", sql = "",retString = "",prdcode = "";
		//java.sql.Timestamp currDate = null;

		boolean isError = false;
		
		String hdrSql = "",dtlSql = "";

		int cnt = 0;
		
		String monthStr = "",yearStr = "";
		int month = 0, year = 0;
		boolean isNumeric = false;
		
		try
		{
			long startTime = System.currentTimeMillis();
			System.out.println("START TIME FOR GST DATA POPULATION PROCESS IN SECONDS:::["+startTime/1000+"]");
			
			//conn = getConnection();
			connDriverGST = new ConnDriver();
			connGST = connDriverGST.getConnectDB("DriverGST"); //will be changed as DriverITM as using stddbtest database for testing temporary
			connGST.setAutoCommit(false);
			connDriverGST = null;
			
			/*connDriverLocal = new ConnDriver();
			connLocal = connDriverLocal.getConnectDB("DriverITM");
			connLocal.setAutoCommit(false);
			connDriverLocal = null;*/
			
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			sysDate = new java.sql.Timestamp(System.currentTimeMillis());
			currDateStr = sdf.format(sysDate);
			currDate = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			
		    Calendar c = Calendar.getInstance();   
		    c.set(Calendar.DAY_OF_MONTH, 1);
		    currMonthStartDate = Timestamp.valueOf(genericUtility.getValidDateString(sdf.format(c.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
			
			period = checkNull(genericUtility.getColumnValue("prd_code", headerDom));
			type = genericUtility.getColumnValue("gst_type",headerDom);

			System.out.println("Login SiteCode["+loginSiteCode+"] PrdCode["+period+"] Type["+type+"]");
			
			if(period == null || period.trim().length() == 0)
			{
				//retString = itmDBAccessEJB.getErrorString("","INVPRD","","",connLocal);
				retString = itmDBAccessEJB.getErrorString("","INVPRD","","",connGST);
				return retString;
			}
			else if(period !=null && period.trim().length() > 0)
			{
				isNumeric = isNumeric(period); //to check if period is valid number 
				
				if(period.length() != 6 || !isNumeric)
			  	{
			  		System.out.println("Period must be valid six digit number in MMYYYY format");
			  		retString = itmDBAccessEJB.getErrorString("","VTPRDLEN","","",connGST);
			  		return retString;
			  	}
				
				monthStr= period.substring(0,2);
			  	yearStr = period.substring(2,period.length());
			  	
			  	month = Integer.parseInt(monthStr);
			  	year = Integer.parseInt(yearStr);
			  	
			  	if(month > 12 || month < 01) //to check month should not greater 12 or less 01
			  	{
			  		System.out.println("Wrong month entered, it should not be more than 12 and less than 01");
			  		retString = itmDBAccessEJB.getErrorString("","VTPRDMONTH","","",connGST);
			  		return retString;
			  	}
			  	
			  	System.out.println("Month ["+month+"] Year ["+year+"] ");
			  	
				Calendar cal = Calendar.getInstance();
				
				cal.set(year,month-1,1); //to set start date of entered period
				
				fromDate = Timestamp.valueOf(genericUtility.getValidDateString( sdf.format(cal.getTime()) , genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");;
				
				cal.set(year,month,00); //to set end date of entered period
				
				toDate   = Timestamp.valueOf(genericUtility.getValidDateString( sdf.format(cal.getTime()) , genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");;
			}
		
			System.out.println("From Date["+fromDate+"]  To Date["+toDate+"] Period Code["+prdcode+"]");
		
			if ("S".equalsIgnoreCase(type))
			{
				GST_EXPWP_TAXCLASS = getSqlInString(distCommon.getDisparams("999999", "GST_EXPWP_TAXCLASS", connGST));
				GST_EXPWOP_TAXCLASS = getSqlInString(distCommon.getDisparams("999999", "GST_EXPWOP_TAXCLASS", connGST));
				GST_SEZWP_TAXCLASS = getSqlInString(distCommon.getDisparams("999999", "GST_SEZWP_TAXCLASS", connGST));
				GST_SEZWOP_TAXCLASS = getSqlInString(distCommon.getDisparams("999999", "GST_SEZWOP_TAXCLASS", connGST));
				GST_DE_TAXCLASS = getSqlInString(distCommon.getDisparams("999999", "GST_DE_TAXCLASS", connGST));
				GST_NIL_TAXCLASS = getSqlInString(distCommon.getDisparams("999999", "GST_NIL_TAXCLASS", connGST));
				GST_EXE_TAXCLASS = getSqlInString(distCommon.getDisparams("999999", "GST_EXE_TAXCLASS", connGST));
				GST_EXPWP_TAXENV = getSqlInString(distCommon.getDisparams("999999", "GST_EXPWP_TAXENV", connGST));
				GST_EXPWOP_TAXENV = getSqlInString(distCommon.getDisparams("999999", "GST_EXPWOP_TAXENV", connGST));
				GST_SEZWP_TAXENV = getSqlInString(distCommon.getDisparams("999999", "GST_SEZWP_TAXENV", connGST));
				GST_SEZWOP_TAXENV = getSqlInString(distCommon.getDisparams("999999", "GST_SEZWOP_TAXENV", connGST));
				GST_DE_TAXENV = getSqlInString(distCommon.getDisparams("999999", "GST_DE_TAXENV", connGST));
				GST_NIL_TAXENV = getSqlInString(distCommon.getDisparams("999999", "GST_NIL_TAXENV", connGST));
				GST_EXE_TAXENV = getSqlInString(distCommon.getDisparams("999999", "GST_EXE_TAXENV", connGST));
				
				gstB2CLInvValStr = finCommon.getFinparams("999999", "GST_B2CL_INV_VAL", connGST);
				if(("NULLFOUND".equals(gstB2CLInvValStr) || gstB2CLInvValStr == null || gstB2CLInvValStr.trim().length() == 0))
				{
					GST_B2CL_INV_VAL = 0.0;
				}
				else
				{
					GST_B2CL_INV_VAL = Double.parseDouble(gstB2CLInvValStr);
				}
				
				taxClassAllStr = getSqlInString( GST_EXPWP_TAXCLASS +","+ GST_EXPWOP_TAXCLASS +","+ GST_SEZWP_TAXCLASS +","+ GST_SEZWOP_TAXCLASS +","+ GST_DE_TAXCLASS +","+ 
						                         GST_NIL_TAXCLASS +","+ GST_EXE_TAXCLASS);
			
				taxEnvAllStr = getSqlInString( GST_EXPWP_TAXENV +","+ GST_EXPWOP_TAXENV +","+ GST_SEZWP_TAXENV +","+ GST_SEZWOP_TAXENV +","+ GST_DE_TAXENV +","+ 
							                   GST_NIL_TAXENV +","+ GST_EXE_TAXENV);
				
				System.out.println("After TaxClassAllStr ["+taxClassAllStr+"]  TaxEnvAllStr ["+taxEnvAllStr+"]");
				
				/******* 4A started ********/
				/**
				 * 4(A) S-INV Header Sales Invoice  *	
				 */
				  hdrSql = " select '' as  TRAN_ID, "
						  +" to_date(i.GP_DATE) as TRAN_DATE, "
						  +" '' as TRAN_ID__REF, "
						  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
						  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
						  +" '1' as REC_TYPE, " // GSTR1,GSTR2,etc. 
						  +" 'I' as GST_TYPE,"
						  +" '01' as TRAN_TYPE," // b2b,b2c
						  +" i.cust_code as CUST_CODE, "
						  +" c.cust_name as CUST_NAME, "
						  +" state.GST_CODE, " // 2 digit code
						  +" '' as SUBMISSION_TYPE," // M-Modify, D-Delete, A-Accept, R-Reject
						  +" '' as  DOC_CHECKSUM,"
						  +" 'R' as DOC_TYPE, " // R- Regular B2B Invoices,  DE – Deemed Exports, SEWP – SEZ Exports with payment,SEWOP – SEZ exports without payment
						  +" i.GP_NO as DOC_NO, "
						  +" i.gp_date as DOC_DATE, "
						  +" i.net_amt as AMOUNT, "
						  +" 'N' as REVERSE_CHRG, "
						  +" ' ' as LR_NO, "
						  +" null as LR_DATE,"
						  +" ' ' as REAS_CODE, "
						  +" ' ' as REF_ID__INV, "
						  +" null REF_DATE__INV, "
						  +" 'N' as PROV_ASSMNT, " // not required
						  +" '' as ORDER_NO," //not required
						  +" null as ORDER_DATE, "// not required
						  //+" i.invoice_id as  REMARKS, "
						  +" '' as  REMARKS, "
						  +" i.invoice_id as  REF_ID, "
						  +" ' ' as SUBMIT_STATUS, "
						  +" null SUBMIT_DATE, "
						  +" '' ADD_USER, "
					      +" sysdate as ADD_DATE, "
						  +" '' ADD_TERM, "
					      +" ' ' CHG_USER, "
						  +" sysdate CHG_DATE, "
						  +" ' 'CHG_TERM, "
						  +" c.tax_reg_2 as TAX_REG_NO, "
						  +" ' '  as RECO_STATUS, "
						  +" ' ' as ECOM_REG_NO, "
						  +" 'S-INV' as ref_ser "
						  +" from invoice i,customer c, site s, state state"
						  +" where c.cust_code = i.cust_code "
						  +" and s.site_code = i.site_code "
						  +" and state.state_code = c.state_code "
						  +" and c.tax_reg_2 <> 'UNREGISTER' "
						  //+" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
						  +" and (select count(1) from taxtran ti, tax tm  where tm.tax_code = ti.tax_code and ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id and tm.tax_type in ('G','H','I','J') ";
				  		  if(taxClassAllStr.length() > 0)
				  		  {
				  			hdrSql = hdrSql +" and ti.tax_class not in ("+taxClassAllStr+") ";
				  		  }
				  		  if(taxEnvAllStr.length() > 0)
				  		  {
				  			hdrSql = hdrSql +" and ti.tax_env not in ("+taxEnvAllStr+") ";
				  		  }
				  		  hdrSql = hdrSql +" ) > 0 "
				  		  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
						  +" and i.conf_date between ? and ? "
				  		  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
				  
				  
				/**
				 * Detail Sales Invoice Detail 4(A) S-INV*	
				 */ 
				dtlSql = " select '' as  TRAN_ID, "
					    +" it.line_no as LINE_NO, "
					    +" 'A' as STATUS, " //-- M – Modification, A – Accept D – Delete
					    +" 0 as SR_NO__OLD, "
					    +" 'G' as LINE_TYPE,"// -- G – Goods, S – Serice
						+" si.hsn_no as GS_CODE, "
						+" tx.TAXABLE_AMT as TAXABLE_AMT, "
						+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						//-- sum(case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,
					    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
					    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						//-- sum(case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,
					    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
						+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
					    //--sum(case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,
					    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
						+" item.sh_descr GS_DESCR,"
						+" u.descr as UNIT,"
						//--sum(it.quantity__stduom) as QUANTITY,
					    +" (it.quantity__stduom) as QUANTITY,"
						+" 'OE' as SUPPLY_TYPE," // -- E/OE (Ecom/Other than Ecom) 
					    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						//--sum(case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,
					    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
						+" '' as REMARKS "
						+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item, uom u "
						+" where i.invoice_id = it.invoice_id "
						+" and si.site_code = i.site_code "
						+" and si.item_code = it.item_code "
						+" and item.item_code = it.item_code "
						+" and t.tax_code = tx.tax_code "
						+" and t.tax_type in ('G','H','I','J') "
						+" and tx.tran_code = 'S-INV' "
						+" and tx.tran_id = i.invoice_id ";
						if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
						{
							dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
						}
						else
						{	
							dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
						}	
						dtlSql = dtlSql +" and i.invoice_id = ? "
						+" and u.unit = item.unit ";
						//--group by '',it.line_no, 'A', 0, 'G', si.hsn_no, tx.TAXABLE_AMT,t.tax_type,tx.tax_perc, item.sh_descr, item.UNIT, 'OE',''
						 
			  retString = executeSqlAndPopulateData(hdrSql,dtlSql,"4(A) S-INV");	
				
			  /**
				* 4(A) D-ISS Header DistOrd Issue *	
			   */
			   hdrSql = " select '' as  TRAN_ID,"
						+" to_date(i.GP_DATE) as TRAN_DATE,"
						+" '' as TRAN_ID__REF,"
						+" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
						+" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE,"
						+" '1' as REC_TYPE,"// -- GSTR1,GSTR2,etc.
						+" 'I' as GST_TYPE,"
						+" '01' as TRAN_TYPE,"// -- b2b,b2c
						+" i.site_code__dlv as CUST_CODE,"
						+" c.descr as CUST_NAME,"
						+" state.GST_CODE,"// -- 2 digit code
						+" ' ' as SUBMISSION_TYPE,"// -- M-Modify, D-Delete, A-Accept, R-Reject
						+" ' ' as  DOC_CHECKSUM,"
						+" 'R' as DOC_TYPE,"// -- R- Regular B2B Invoices,  DE – Deemed Exports, SEWP – SEZ Exports with payment,SEWOP – SEZ exports without payment
						+" i.GP_NO as DOC_NO,"
						+" i.gp_date as DOC_DATE,"
						+" i.net_amt as AMOUNT,"
						+" 'N' as REVERSE_CHRG,"
						+" ' ' as LR_NO,"
						+" null as LR_DATE,"
						+" ' ' as REAS_CODE,"
						+" ' ' as REF_ID__INV,"
						+" null REF_DATE__INV,"
						+" 'N' as PROV_ASSMNT,"//  -- not required
						+" '' as ORDER_NO,"//  -- not required
						+" null as ORDER_DATE,"// -- not required
						//+" i.tran_id as  REMARKS,"
						+" '' as  REMARKS, "
						+" i.tran_id as  REF_ID, "
						+" ' ' as SUBMIT_STATUS,"
						+" null SUBMIT_DATE,"
						+" '' ADD_USER,"
						+" sysdate ADD_DATE,"
						+" '' ADD_TERM,"
						+" ' ' CHG_USER,"
						+" sysdate CHG_DATE,"
						+" ' 'CHG_TERM,"
						+" ddf_get_siteregno(c.site_code,'GSTIN_NO') as TAX_REG_NO,"
						+" ' '  as RECO_STATUS,"
						+" ' ' as ECOM_REG_NO,"
						+" 'D-ISS' as ref_ser"
						+" from distord_iss i,site c, site s, state state"
						+" where c.site_code = i.site_code__dlv"
						+" and s.site_code = c.site_code"
						+" and state.state_code = c.STATE_CODE "
						//+" and (select count(1) from taxtran ti where ti.tran_code = 'D-ISS' and ti.tran_id = i.tran_id ";
						+" and (select count(1) from taxtran ti, tax tm  where tm.tax_code = ti.tax_code and ti.tran_code = 'D-ISS' and ti.tran_id = i.tran_id and tm.tax_type in ('G','H','I','J') ";
						if(taxClassAllStr.length() > 0)
				  		{
				  		   hdrSql = hdrSql +" and ti.tax_class not in ("+taxClassAllStr+") ";
				  		}
				  		if(taxEnvAllStr.length() > 0)
				  		{
				  		   hdrSql = hdrSql +" and ti.tax_env not in ("+taxEnvAllStr+")  ";
				  		}
				  		hdrSql = hdrSql +" ) > 0 "
				  		+" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
						+" and i.conf_date between ? and ? "
				  		+" and (select count(1) from gst_data_hdr where ref_ser = 'D-ISS' and ref_id = i.tran_id ) = 0 ";
			   
			   /**
				*  Detail DistOrd Issue 4(A) D-ISS*	
			    */
			   dtlSql = " select '' as  TRAN_ID, "
						 +" it.line_no as LINE_NO, "
						 +" 'A' as STATUS," // -- M – Modification, A – Accept D – Delete
						 +" 0 as SR_NO__OLD,"
						 +" 'G' as LINE_TYPE,"// -- G – Goods, S – Serice
						 +" si.hsn_no as GS_CODE,"
						 +" tx.TAXABLE_AMT as TAXABLE_AMT,"
						 +" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						//-- sum(case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,
						 +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						 +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						//-- sum(case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,
						 +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
						 +" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						 //--sum(case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,
						 +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
						 +" item.sh_descr GS_DESCR,"
						 +" u.descr as UNIT,"
						 //--sum(it.quantity__stduom) as QUANTITY,
						 +" (it.quantity) as QUANTITY,"
						 +" 'OE' as SUPPLY_TYPE,"// -- E/OE (Ecom/Other than Ecom)
						 +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						 //--sum(case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,
						 +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
						 +" '' as REMARKS"
						 +" from distord_iss i,distord_issdet it,taxtran tx, siteitem si, tax t, item, uom u " 
						 +" where i.tran_id = it.tran_id "
						 +" and si.site_code = i.site_code "
						 +" and si.item_code = it.item_code "
						 +" and item.item_code = it.item_code "
						 +" and t.tax_code = tx.tax_code "
						 +" and t.tax_type in ('G','H','I','J') "
						 +" and tx.tran_code = 'D-ISS' "
						 +" and tx.tran_id = i.tran_id ";
						 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
						 {
							dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
						 }
						 else
						 {	
							dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
						 }
			   			dtlSql = dtlSql + " and i.tran_id = ? " 
			   			 +" and u.unit = item.unit ";
						 //--group by '',it.line_no, 'A', 0, 'G', si.hsn_no, tx.TAXABLE_AMT,t.tax_type,tx.tax_perc, item.sh_descr, item.UNIT, 'OE',''

				retString = executeSqlAndPopulateData(hdrSql,dtlSql,"4(A) D-ISS");	
				
			    /**
				* 4(A) P-RET Header Porcp Return*	
			    */
				hdrSql = " select '' as  TRAN_ID,"
						+" to_date(i.excise_ref_date) as TRAN_DATE,"
						+" '' as TRAN_ID__REF,"
						+" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
						+" to_char(i.excise_ref_date,'MMYYYY') as PRD_CODE,"
						+" '1' as REC_TYPE,"// -- GSTR1,GSTR2,etc.
						+" 'I' as GST_TYPE,"
						+" '01' as TRAN_TYPE,"// -- b2b,b2c
						+" i.supp_code as CUST_CODE,"
						+" c.supp_name as CUST_NAME,"
						+" state.GST_CODE,"// -- 2 digit code
						+" ' ' as SUBMISSION_TYPE,"// -- M-Modify, D-Delete, A-Accept, R-Reject
						+" ' ' as  DOC_CHECKSUM,"
						+" 'R' as DOC_TYPE,"// -- R- Regular B2B Invoices,  DE – Deemed Exports, SEWP – SEZ Exports with payment,SEWOP – SEZ exports without payment
						+" i.excise_ref as DOC_NO,"
						+" i.excise_ref_date as DOC_DATE,"
						+" i.amount as AMOUNT,"
						+" 'N' as REVERSE_CHRG,"
						+" ' ' as LR_NO,"
						+" null as LR_DATE,"
						+" ' ' as REAS_CODE,"
						+" ' ' as REF_ID__INV,"
						+" null REF_DATE__INV,"
						+" 'N' as PROV_ASSMNT,"//  -- not required
						+" '' as ORDER_NO,"//  -- not required
						+" null as ORDER_DATE,"// -- not required
						//+" i.tran_id as  REMARKS,"
						+" '' as  REMARKS, "
						+" i.tran_id as  REF_ID, "
						+" ' ' as SUBMIT_STATUS,"
						+" null SUBMIT_DATE,"
						+" '' ADD_USER,"
						+" sysdate ADD_DATE,"
						+" '' ADD_TERM,"
						+" ' ' CHG_USER,"
						+" sysdate CHG_DATE,"
						+" ' 'CHG_TERM,"
						+"  c.tax_reg_2 as TAX_REG_NO,"
						+" ' '  as RECO_STATUS,"
						+" ' ' as ECOM_REG_NO,"
						+" 'P-RET' as ref_ser"
						+" from porcp i,supplier c, site s, state state"
						+" where c.supp_code = i.supp_code "
						+" and s.site_code = i.site_code "
						+" and state.state_code = c.STATE_CODE "
						+" and i.tran_ser = 'P-RET' "
						+" and c.tax_reg_2 <> 'UNREGISTER' "
						//+" and (select count(1) from taxtran ti where ti.tran_code = 'P-RET' and ti.tran_id = i.tran_id ";
						+" and (select count(1) from taxtran ti, tax tm  where tm.tax_code = ti.tax_code and ti.tran_code = 'P-RET' and ti.tran_id = i.tran_id and tm.tax_type in ('G','H','I','J') ";
						if(taxClassAllStr.length() > 0)
				  		{
				  		   hdrSql = hdrSql +" and ti.tax_class not in ("+taxClassAllStr+") ";
				  		}
				  		if(taxEnvAllStr.length() > 0)
				  		{
				  		   hdrSql = hdrSql +" and ti.tax_env not in ("+taxEnvAllStr+") ";
				  		}
				  		hdrSql = hdrSql +" ) > 0 "
				  		+" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
						+" and i.conf_date between ? and ? "
						+" and (select count(1) from gst_data_hdr where ref_ser = 'P-RET' and ref_id = i.tran_id ) = 0 ";
				
				/**
				* Detail Porcp Return Detail 4(A) P-RET*	
			    */
				dtlSql = " select '' as  TRAN_ID, "
						 +" it.line_no as LINE_NO, "
						 +" 'A' as STATUS," // -- M – Modification, A – Accept D – Delete
						 +" 0 as SR_NO__OLD,"
						 +" 'G' as LINE_TYPE,"// -- G – Goods, S – Serice
						 +" si.hsn_no as GS_CODE,"
						 +" tx.TAXABLE_AMT as TAXABLE_AMT,"
						 +" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						//-- sum(case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,
						 +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						 +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						//-- sum(case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,
						 +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
						 +" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						 //--sum(case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,
						 +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
						 +" item.sh_descr GS_DESCR,"
						 +" u.descr as UNIT,"
						 //--sum(it.quantity__stduom) as QUANTITY,
						 +" (it.quantity) as QUANTITY,"
						 +" 'OE' as SUPPLY_TYPE,"// -- E/OE (Ecom/Other than Ecom)
						 +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						 //--sum(case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,
						 +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
						 +" '' as REMARKS"
						 +" from porcp i,porcpdet it,taxtran tx, siteitem si, tax t, item item, uom u " 
						 +" where i.tran_id = it.tran_id "
						 +" and si.site_code = i.site_code "
						 +" and si.item_code = it.item_code "
						 +" and item.item_code = it.item_code "
						 +" and t.tax_code = tx.tax_code "
						 +" and t.tax_type in ('G','H','I','J') "
						 +" and tx.tran_code = 'P-RET' "
						 +" and tx.tran_id = i.tran_id ";
						 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
						 {
							dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
						 }
						 else
						 {	
							dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
						 }
						 dtlSql = dtlSql  +" and i.tran_id = ? "
						 +" and u.unit = item.unit ";
						 //--group by '',it.line_no, 'A', 0, 'G', si.hsn_no, tx.TAXABLE_AMT,t.tax_type,tx.tax_perc, item.sh_descr, item.UNIT, 'OE',''
					
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"4(A) P-RET");
					
					/******* 4B started ********/
				    /**
					* 4(B) VOUCH Header Voucher*	
				    */
					hdrSql = " select '' as  TRAN_ID,"
							+" to_date(i.gp_date) as TRAN_DATE,"
							+" '' as TRAN_ID__REF,"
							+" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							+" to_char(i.gp_date,'MMYYYY') as PRD_CODE,"
							+" '1' as REC_TYPE,"// -- GSTR1,GSTR2,etc.
							+" 'I' as GST_TYPE,"
							+" '02' as TRAN_TYPE,"// -- b2b,b2c
							+" i.supp_code as CUST_CODE,"
							+" c.supp_name as CUST_NAME,"
							+" state.GST_CODE,"// -- 2 digit code
							+" ' ' as SUBMISSION_TYPE,"// -- M-Modify, D-Delete, A-Accept, R-Reject
							+" ' ' as  DOC_CHECKSUM,"
							+" 'R' as DOC_TYPE,"// -- R- Regular B2B Invoices,  DE – Deemed Exports, SEWP – SEZ Exports with payment,SEWOP – SEZ exports without payment
							+" i.gp_no as DOC_NO,"
							+" i.gp_date as DOC_DATE,"
							+" i.net_amt as AMOUNT,"
							+" 'Y' as REVERSE_CHRG,"
							+" ' ' as LR_NO,"
							+" null as LR_DATE,"
							+" ' ' as REAS_CODE,"
							+" ' ' as REF_ID__INV,"
							+" null REF_DATE__INV,"
							+" 'N' as PROV_ASSMNT,"//  -- not required
							+" '' as ORDER_NO,"//  -- not required
							+" null as ORDER_DATE,"// -- not required
							//+" i.tran_id as  REMARKS,"
							+" '' as  REMARKS, "
							+" i.tran_id as  REF_ID, "
							+" ' ' as SUBMIT_STATUS,"
							+" null SUBMIT_DATE,"
							+" '' ADD_USER,"
							+" sysdate ADD_DATE,"
							+" '' ADD_TERM,"
							+" ' ' CHG_USER,"
							+" sysdate CHG_DATE,"
							+" ' 'CHG_TERM,"
							+"  c.tax_reg_2 as TAX_REG_NO,"
							+" ' '  as RECO_STATUS,"
							+" ' ' as ECOM_REG_NO,"
							+" 'VOUCH' as ref_ser"
							+" from voucher i,supplier c, site s, state state"
							+" where c.supp_code = i.supp_code "
							+" and s.site_code = i.site_code "
							+" and state.state_code = c.STATE_CODE "
							+" and c.tax_reg_2 = 'UNREGISTER' "
							+" and (select count(1) from taxtran ti, tax tm where tm.tax_code = ti.tax_code "
							+" and ti.tran_code = 'VOUCH' and ti.tran_id = i.tran_id ";
							if(taxClassAllStr.length() > 0)
					  		{
					  		   hdrSql = hdrSql +" and ti.tax_class in ("+taxClassAllStr+") ";
					  		}
							hdrSql = hdrSql +" and tm.tax_group = 'RCM' ) = 0 "
							+" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							+" and i.conf_date between ? and ? "
							+" and (select count(1) from gst_data_hdr where ref_ser = 'VOUCH' and ref_id = i.tran_id ) = 0 ";
					
					/**
					* Detail Voucher 4(B) VOUCH *	
				    */
					dtlSql = " select '' as  TRAN_ID, ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" cast(it.line_no as integer) as LINE_NO, ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" to_number(trim(it.line_no)) as LINE_NO, ";
							 }
							 dtlSql = dtlSql +" 'A' as STATUS," // -- M – Modification, A – Accept D – Delete
							 +" 0 as SR_NO__OLD,"
							 +" 'G' as LINE_TYPE,"// -- G – Goods, S – Serice
							 +" si.hsn_no as GS_CODE,"
							 +" tx.TAXABLE_AMT as TAXABLE_AMT,"
							 +" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							//-- sum(case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,
							 +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							 +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							//-- sum(case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,
							 +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							 +" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							 //--sum(case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,
							 +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							 +" item.sh_descr GS_DESCR,"
							 +" u.descr as UNIT,"
							 //--sum(it.quantity__stduom) as QUANTITY,
							 +" (it.rcp_qty) as QUANTITY,"
							 +" 'OE' as SUPPLY_TYPE,"// -- E/OE (Ecom/Other than Ecom)
							 +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							 //--sum(case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,
							 +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							 +" '' as REMARKS"
							 +" from voucher i,vouchrcp it,taxtran tx, siteitem si, tax t, item item,uom u " 
							 +" where i.tran_id = it.tran_id "
							 +" and si.site_code = i.site_code "
							 +" and si.item_code = it.item_code "
							 +" and item.item_code = it.item_code "
							 +" and t.tax_code = tx.tax_code "
							 +" and t.tax_type in ('G','H','I','J') "
							 +" and tx.tran_code = 'VOUCH' "
							 +" and tx.tran_id = i.tran_id "
							 +" and t.TAX_GROUP = 'RCM' ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							dtlSql = dtlSql +" and i.tran_id = ? "
							 +" and u.unit = item.unit ";
							 //--group by '',it.line_no, 'A', 0, 'G', si.hsn_no, tx.TAXABLE_AMT,t.tax_type,tx.tax_perc, item.sh_descr, item.UNIT, 'OE',''
						
						retString = executeSqlAndPopulateData(hdrSql,dtlSql,"4(B) VOUCH");
						
					/**
					* 4(B) M-VOUC Header MISC-Voucher *	
				    */	
					hdrSql = " select '' as  TRAN_ID,"
							+" to_date(i.gp_date) as TRAN_DATE,"
							+" '' as TRAN_ID__REF,"
							+" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							+" to_char(i.gp_date,'MMYYYY') as PRD_CODE,"
							+" '1' as REC_TYPE,"// -- GSTR1,GSTR2,etc.
							+" 'I' as GST_TYPE,"
							+" '02' as TRAN_TYPE,"// -- b2b,b2c
							+" i.sundry_code as CUST_CODE,"
							+" c.supp_name as CUST_NAME,"
							+" state.GST_CODE,"// -- 2 digit code
							+" ' ' as SUBMISSION_TYPE,"// -- M-Modify, D-Delete, A-Accept, R-Reject
							+" ' ' as  DOC_CHECKSUM,"
							+" 'R' as DOC_TYPE,"// -- R- Regular B2B Invoices,  DE – Deemed Exports, SEWP – SEZ Exports with payment,SEWOP – SEZ exports without payment
							+" i.gp_no as DOC_NO,"
							+" i.gp_date as DOC_DATE,"
							+" i.net_amt as AMOUNT,"
							+" 'Y' as REVERSE_CHRG,"
							+" ' ' as LR_NO,"
							+" null as LR_DATE,"
							+" ' ' as REAS_CODE,"
							+" ' ' as REF_ID__INV,"
							+" null REF_DATE__INV,"
							+" 'N' as PROV_ASSMNT,"//  -- not required
							+" '' as ORDER_NO,"//  -- not required
							+" null as ORDER_DATE,"// -- not required
							//+" i.tran_id as  REMARKS,"
							+" '' as  REMARKS, "
							+" i.tran_id as  REF_ID, "
							+" ' ' as SUBMIT_STATUS,"
							+" null SUBMIT_DATE,"
							+" '' ADD_USER,"
							+" sysdate ADD_DATE,"
							+" '' ADD_TERM,"
							+" ' ' CHG_USER,"
							+" sysdate CHG_DATE,"
							+" ' 'CHG_TERM,"
							+"  c.tax_reg_2 as TAX_REG_NO,"
							+" ' '  as RECO_STATUS,"
							+" ' ' as ECOM_REG_NO,"
							+" 'M-VOUC' as ref_ser"
							+" from misc_voucher i,supplier c, site s, state state "
							+" where c.supp_code = i.sundry_code "
							+" and i.sundry_type = 'S' "
							+" and s.site_code = i.site_code "
							+" and state.state_code = c.STATE_CODE "
							+" and c.tax_reg_2 = 'UNREGISTER' "
							+" and (select count(1) from taxtran ti,tax tm where tm.tax_code = ti.tax_code "
							+" and ti.tran_code = 'M-VOUC' and ti.tran_id = i.tran_id ";
							//+" and ti.tax_class in ("+taxClassStr+") and tm.tax_group = 'RCM' ) = 0  "
							if(taxClassAllStr.length() > 0)
					  		{
					  		   hdrSql = hdrSql +" and ti.tax_class in ("+taxClassAllStr+") ";
					  		}
							hdrSql = hdrSql + " and tm.tax_group = 'RCM' ) = 0 "
							+" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							+" and i.conf_date between ? and ? "
							+" and (select count(1) from gst_data_hdr where ref_ser = 'M-VOUC' and ref_id = i.tran_id ) = 0 ";
					
					/**
					* Detail MISC-Voucher 4(B) M-VOUC *	
				    */
					dtlSql = " select '' as  TRAN_ID, ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" cast(it.line_no as integer) as LINE_NO, ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" to_number(trim(it.line_no)) as LINE_NO, ";
							 }
							 dtlSql = dtlSql +" 'A' as STATUS," // -- M – Modification, A – Accept D – Delete
							 +" 0 as SR_NO__OLD,"
							 +" 'G' as LINE_TYPE,"// -- G – Goods, S – Serice
							 +" si.hsn_no as GS_CODE,"
							 +" tx.TAXABLE_AMT as TAXABLE_AMT,"
							 +" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							//-- sum(case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,
							 +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							 +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							//-- sum(case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,
							 +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							 +" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							 //--sum(case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,
							 +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							 +" item.sh_descr GS_DESCR,"
							 +" u.descr as UNIT,"
							 //--sum(it.quantity__stduom) as QUANTITY,
							 +" (it.quantity) as QUANTITY,"
							 +" 'OE' as SUPPLY_TYPE,"// -- E/OE (Ecom/Other than Ecom)
							 +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							 //--sum(case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,
							 +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							 +" '' as REMARKS"
							 +" from misc_voucher i,misc_vouchdet it,taxtran tx, siteitem si, tax t, item item,uom u " 
							 +" where i.tran_id = it.tran_id "
							 +" and si.site_code = i.site_code "
							 +" and si.item_code = it.item_code "
							 +" and item.item_code = it.item_code "
							 +" and t.tax_code = tx.tax_code "
							 +" and t.tax_type in ('G','H','I','J') "
							 +" and tx.tran_code = 'VOUCH' "
							 +" and tx.tran_id = i.tran_id "
							 +" and tx.line_no = it.line_no"
							 +" and t.TAX_GROUP = 'RCM' ";
							 //+" and tx.tax_class not in ("+taxClassStr+") "
							 if(taxClassAllStr.length() > 0)
						  	 {
								dtlSql = dtlSql +" and tx.tax_class not in ("+taxClassAllStr+") ";
						  	 }
							 dtlSql = dtlSql +" and i.tran_id = ? "
							 +" and u.unit = item.unit ";
							 //--group by '',it.line_no, 'A', 0, 'G', si.hsn_no, tx.TAXABLE_AMT,t.tax_type,tx.tax_perc, item.sh_descr, item.UNIT, 'OE',''
						
						retString = executeSqlAndPopulateData(hdrSql,dtlSql,"4(B) M-VOUC");
					
					/************* 5A started ****************/
					/**
					 * 5(A) S-INV Invoice Header *	
					 */
					hdrSql = " select '' as  TRAN_ID,"
							+" to_date(i.gp_date) as TRAN_DATE, "
							+" '' as TRAN_ID__REF,"
							+" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							+" to_char(i.gp_date,'MMYYYY') as PRD_CODE,"
							+" '1' as REC_TYPE,"// -- GSTR1,GSTR2,etc.
							+" 'I' as GST_TYPE,"
							+" '04' as TRAN_TYPE," //-- b2cl
							+" i.cust_code as CUST_CODE,"
							+" c.cust_name as CUST_NAME,"
							+" st_c.GST_CODE,"// -- 2 digit code
							+" ' ' as SUBMISSION_TYPE,"// -- M-Modify, D-Delete, A-Accept, R-Reject
							+" ' ' as  DOC_CHECKSUM,"
							+" 'R' as DOC_TYPE,"// -- R- Regular B2B Invoices,  DE – Deemed Exports, SEWP – SEZ Exports with payment,SEWOP – SEZ exports without payment
							+" i.gp_no as DOC_NO,"
							+" i.gp_date as DOC_DATE,"
							+" i.net_amt as AMOUNT,"
							+" 'N' as REVERSE_CHRG,"
							+" ' ' as LR_NO,"
							+" null as LR_DATE,"
							+" ' ' as REAS_CODE,"
							+" ' ' as REF_ID__INV,"
							+" null REF_DATE__INV,"
							+" 'N' as PROV_ASSMNT,"//  -- not required
							+" '' as ORDER_NO,"//  -- not required
							+" null as ORDER_DATE,"// -- not required
							//+" i.invoice_id as  REMARKS,"
							+" '' as  REMARKS, "
							+" i.invoice_id as  REF_ID, "
							+" ' ' as SUBMIT_STATUS,"
							+" null SUBMIT_DATE,"
							+" '' ADD_USER,"
							+" sysdate ADD_DATE,"
							+" '' ADD_TERM,"
							+" ' ' CHG_USER,"
							+" sysdate CHG_DATE,"
							+" ' 'CHG_TERM,"
							+"  c.tax_reg_2 as TAX_REG_NO,"
							+" ' '  as RECO_STATUS,"
							+" ' ' as ECOM_REG_NO,"
							+" 'S-INV' as ref_ser"
							+" from invoice i,customer c, site s, state st_c, state st_own "
							+" where c.cust_code = i.cust_code "
							+" and s.site_code = i.site_code "
							+" and st_c.state_code = c.STATE_CODE "
							+" and st_own.state_code = s.STATE_CODE "
							+" and st_c.gst_code <> st_own.gst_code " //--  inter-state only
							+" and i.net_amt > "+GST_B2CL_INV_VAL+" " //-- amount is more than 2.5 lakh " 
							+" and c.tax_reg_2 = 'UNREGISTER' "
						  //+" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
							+" and (select count(1) from taxtran ti, tax tm  where tm.tax_code = ti.tax_code and ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id and tm.tax_type in ('G','H','I','J') ";
							 if(taxClassAllStr.length() > 0)
						  	 {
						  		hdrSql = hdrSql +" and ti.tax_class in ("+taxClassAllStr+") ";
						  	 }
							 hdrSql = hdrSql +" ) > 0 "
							+" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							+" and i.conf_date between ? and ? "
							+" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
					/**
					 * Detail Invoice 5(A) S-INV *	
					 */
					dtlSql =  " select '' as  TRAN_ID, "
							 +" it.line_no as LINE_NO, "
							 +" 'A' as STATUS," // -- M – Modification, A – Accept D – Delete
							 +" 0 as SR_NO__OLD,"
							 +" 'G' as LINE_TYPE,"// -- G – Goods, S – Serice
							 +" si.hsn_no as GS_CODE,"
							 +" tx.TAXABLE_AMT as TAXABLE_AMT,"
							 +" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							//-- sum(case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,
							 +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							 +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							//-- sum(case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,
							 +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							 +" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							 //--sum(case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,
							 +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							 +" item.sh_descr GS_DESCR,"
							 +" u.descr as UNIT,"
							 //--sum(it.quantity__stduom) as QUANTITY,
							 +" (it.quantity) as QUANTITY,"
							 +" 'OE' as SUPPLY_TYPE,"// -- E/OE (Ecom/Other than Ecom)
							 +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							 //--sum(case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,
							 +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							 +" '' as REMARKS "
							 +" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item item, uom u " 
							 +" where i.invoice_id = it.invoice_id "
							 +" and si.site_code = i.site_code "
							 +" and si.item_code = it.item_code "
							 +" and item.item_code = it.item_code "
							 +" and t.tax_code = tx.tax_code "
							 +" and t.tax_type in ('G','H','I','J') "
							 +" and tx.tran_code = 'S-INV' "
							 +" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							 if(taxClassAllStr.length() > 0)
						  	 {
								 dtlSql = dtlSql +" and tx.tax_class not in ("+taxClassAllStr+") ";
						  	 }
							 dtlSql = dtlSql +" and i.invoice_id = ?  "
							 +" and u.unit = item.unit ";		 
							 //--group by '',it.line_no, 'A', 0, 'G', si.hsn_no, tx.TAXABLE_AMT,t.tax_type,tx.tax_perc, item.sh_descr, item.UNIT, 'OE',''
						
			        retString = executeSqlAndPopulateData(hdrSql,dtlSql,"(5A) S-INV");

					/**
					 * 5(A) P-RET Header Porcp Return *	
					 */
					hdrSql = " select '' as  TRAN_ID,"
							+" to_date(i.excise_ref_date) as TRAN_DATE,"
							+" '' as TRAN_ID__REF,"
							+" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							+" to_char(i.excise_ref_date,'MMYYYY') as PRD_CODE,"
							+" '1' as REC_TYPE,"// -- GSTR1,GSTR2,etc.
							+" 'I' as GST_TYPE,"
							+" '04' as TRAN_TYPE,"// -- b2b,b2c
							+" i.supp_code as CUST_CODE,"
							+" c.supp_name as CUST_NAME,"
							+" st_c.GST_CODE,"// -- 2 digit code
							+" ' ' as SUBMISSION_TYPE,"// -- M-Modify, D-Delete, A-Accept, R-Reject
							+" ' ' as  DOC_CHECKSUM,"
							+" 'R' as DOC_TYPE,"// -- R- Regular B2B Invoices,  DE – Deemed Exports, SEWP – SEZ Exports with payment,SEWOP – SEZ exports without payment
							+" i.excise_ref as DOC_NO,"
							+" i.excise_ref_date as DOC_DATE,"
							+" i.amount as AMOUNT,"
							+" 'N' as REVERSE_CHRG,"
							+" ' ' as LR_NO,"
							+" null as LR_DATE,"
							+" ' ' as REAS_CODE,"
							+" ' ' as REF_ID__INV,"
							+" null REF_DATE__INV,"
							+" 'N' as PROV_ASSMNT,"//  -- not required
							+" '' as ORDER_NO,"//  -- not required
							+" null as ORDER_DATE,"// -- not required
							//+" i.tran_id as  REMARKS,"
							+" '' as  REMARKS, "
							+" i.tran_id as  REF_ID, "
							+" ' ' as SUBMIT_STATUS,"
							+" null SUBMIT_DATE,"
							+" '' ADD_USER,"
							+" sysdate ADD_DATE,"
							+" '' ADD_TERM,"
							+" ' ' CHG_USER,"
							+" sysdate CHG_DATE,"
							+" ' 'CHG_TERM,"
							+"  c.tax_reg_2 as TAX_REG_NO,"
							+" ' '  as RECO_STATUS,"
							+" ' ' as ECOM_REG_NO,"
							+" 'P-RET' as ref_ser"
							+" from porcp i,supplier c, site s, state st_c, state st_own "
							+" where c.supp_code = i.supp_code "
							+" and s.site_code = i.site_code "
							+" and st_c.state_code = c.STATE_CODE "
							+" and st_own.state_code = s.STATE_CODE "
							+" and st_c.gst_code <> st_own.gst_code " // --  inter-state only
							+" and i.amount > "+GST_B2CL_INV_VAL+" " //-- amount is more than 2.5 lakh
							+" and i.tran_ser = 'P-RET' "
							+" and c.tax_reg_2 = 'UNREGISTER' "
							+" and (select count(1) from taxtran ti, tax tm  where tm.tax_code = ti.tax_code and ti.tran_code = 'P-RET'"
							+" and ti.tran_id = i.tran_id  and tm.tax_type in ('G','H','I','J') ) > 0 "
							+" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							+" and i.conf_date between ? and ? "
							+" and (select count(1) from gst_data_hdr where ref_ser = 'P-RET' and ref_id = i.tran_id ) = 0 ";
					
					/**
					 * Detail Porcp Return Detail 5(A) P-RET*	
					 */
					dtlSql = " select '' as  TRAN_ID, "
							 +" it.line_no as LINE_NO, "
							 +" 'A' as STATUS," // -- M – Modification, A – Accept D – Delete
							 +" 0 as SR_NO__OLD,"
							 +" 'G' as LINE_TYPE,"// -- G – Goods, S – Serice
							 +" si.hsn_no as GS_CODE,"
							 +" tx.TAXABLE_AMT as TAXABLE_AMT,"
							 +" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							//-- sum(case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,
							 +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							 +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							//-- sum(case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,
							 +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							 +" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							 //--sum(case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,
							 +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							 +" item.sh_descr GS_DESCR,"
							 +" u.descr as UNIT,"
							 //--sum(it.quantity__stduom) as QUANTITY,
							 +" (it.quantity) as QUANTITY,"
							 +" 'OE' as SUPPLY_TYPE,"// -- E/OE (Ecom/Other than Ecom)
							 +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							 //--sum(case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,
							 +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							 +" '' as REMARKS"
							 +" from porcp i,porcpdet it,taxtran tx, siteitem si, tax t, item item,uom u " 
							 +" where i.tran_id = it.tran_id "
							 +" and si.site_code = i.site_code "
							 +" and si.item_code = it.item_code "
							 +" and item.item_code = it.item_code "
							 +" and t.tax_code = tx.tax_code "
							 +" and t.tax_type in ('G','H','I','J') "
							 +" and tx.tran_code = 'P-RET' "
							 +" and tx.tran_id = i.tran_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							 if(taxClassAllStr.length() > 0)
						  	 {
								 dtlSql = dtlSql +" and tx.tax_class not in ("+taxClassAllStr+") ";
						  	 }
							 dtlSql = dtlSql +" and i.tran_id = ? "
							 +" and u.unit = item.unit ";		
							 //--group by '',it.line_no, 'A', 0, 'G', si.hsn_no, tx.TAXABLE_AMT,t.tax_type,tx.tax_perc, item.sh_descr, item.UNIT, 'OE',''
						
						retString = executeSqlAndPopulateData(hdrSql,dtlSql,"(5A) P-RET");
				
						
					/***********6A started************/	
					/**
					 * 6(A) WPAY Header Invoice Exports (Pure Export)- with Payment *	
					 */
					hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'E' as GST_TYPE,"
							  +" '06' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'WPAY' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" i.lr_no as LR_NO, "
							  +" i.lr_date as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  //+" i.stan_code__init as ORDER_NO," 
							  +" station.descr as ORDER_NO," 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state, station station"
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and c.tax_reg_2 <> 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
							  if(GST_EXPWP_TAXCLASS.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_env in ("+GST_EXPWP_TAXCLASS+") ";
						  	  }
							  if(GST_EXPWP_TAXENV.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_env in ("+GST_EXPWP_TAXENV+") ";
						  	  }
							  hdrSql = hdrSql +" ) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 "
							  +" and station.stan_code = i.stan_code__init ";
					/**
					 * Detail Invoice Exports (Pure Export)- with Payment 6(A) WPAY *	
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							+" and t.tax_type in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							dtlSql = dtlSql +" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"(6A) WPAY");
					
					/**
					 * 6(A) WOPAY Header Invoice Exports (Pure Export)- without Payment *	
					 */
					hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'E' as GST_TYPE,"
							  +" '07' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'WOPAY' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" i.lr_no as LR_NO, "
							  +" i.lr_date as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  //+" i.stan_code__init as ORDER_NO," 
							  +" station.descr as ORDER_NO," 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state, station station "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and c.tax_reg_2 <> 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
							  if(GST_EXPWOP_TAXCLASS.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_class in ("+GST_EXPWOP_TAXCLASS+") ";
						  	  }
							  if(GST_EXPWOP_TAXENV.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_env in ("+GST_EXPWOP_TAXENV+") ";
						  	  }
							  hdrSql = hdrSql +" ) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 "
							  +" and station.stan_code = i.stan_code__init ";
					/**
					 * Detail Invoice Exports (Pure Export)- without Payment 6(A) WOPAY*
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							//+" and t.tax_type in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							dtlSql = dtlSql +" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"(6A) WOPAY");
					
					/**
					 * 6(B) SEWP Header--- B2B Export to SEZ with payment *	
					 */
					hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'E' as GST_TYPE,"
							  +" '08' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'SEWP' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" i.lr_no as LR_NO, "
							  +" i.lr_date as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  //+" i.stan_code__init as ORDER_NO," 
							  +" station.descr as ORDER_NO," 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state,station station "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and c.tax_reg_2 <> 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
							  if(GST_SEZWP_TAXCLASS.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_class in ("+GST_SEZWP_TAXCLASS+") ";
						  	  }
							  if(GST_SEZWP_TAXENV.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_env in ("+GST_SEZWP_TAXENV+") ";
						  	  }
							  hdrSql = hdrSql +" ) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 "
							  +" and station.stan_code = i.stan_code__init ";
							  
					/**
					 * Detail ---B2B Export to SEZ with payment 6(B) SEWP *	
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							+" and t.tax_type in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							dtlSql = dtlSql +" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"(6B) SEWP");
					
					
					/**
					 * 6(B) SEWOP Header--- B2B Export to SEZ without payment *	
					 */
					hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'E' as GST_TYPE,"
							  +" '09' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'SEWOP' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" i.lr_no as LR_NO, "
							  +" i.lr_date as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  //+" i.stan_code__init as ORDER_NO,"
							  +" station.descr as ORDER_NO,"
							  +" null as ORDER_DATE, "
							 //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state, station station "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and c.tax_reg_2 <> 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
							  if(GST_SEZWOP_TAXCLASS.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_class in ("+GST_SEZWOP_TAXCLASS+") ";
						  	  }
							  if(GST_SEZWOP_TAXENV.length() > 0)
							  {
							  	   hdrSql = hdrSql +" and ti.tax_env in ("+GST_SEZWOP_TAXENV+") ";
							  }
							  hdrSql = hdrSql +" ) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 "
							  +" and station.stan_code = i.stan_code__init ";
					/**
					 * Detail ---B2B Export to SEZ without payment 6(B) SEWOP *	
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							//+" and t.tax_type in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							 dtlSql = dtlSql +" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"(6B) SEWOP");
					
					/**
					 * 6(C) DE--Header 6C---B2B Deemed Exports*	
					 */
					hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'E' as GST_TYPE,"
							  +" '10' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'DE' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" i.lr_no as LR_NO, "
							  +" i.lr_date as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  //+" i.stan_code__init as ORDER_NO,"
							  +" station.descr as ORDER_NO,"
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state,station station "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and c.tax_reg_2 <> 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
							  if(GST_DE_TAXCLASS.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_class in ("+GST_DE_TAXCLASS+") ";
						  	  }
							  if(GST_DE_TAXENV.length() > 0)
							  {
							  	   hdrSql = hdrSql +" and ti.tax_env in ("+GST_DE_TAXENV+") ";
							  }
							  hdrSql = hdrSql +" ) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 "
							  +" and station.stan_code = i.stan_code__init ";
					/**
					 * Detail ---B2B Deemed Exports 6(C) DE*	
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							//+" and t.tax_type in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							 dtlSql = dtlSql +" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"(6C) DE");
					
					/*********** 7A started ************/	
					/**
					 * 7A(1) B2CS Header B2CS Intra-state supplies  *	
					 */
					hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'I' as GST_TYPE,"
							  +" '11' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" st_c.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'R' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" ' ' as LR_NO, "
							  +" null as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  +" i.stan_code__init as ORDER_NO," // 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state st_c, state st_own"
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and st_c.state_code = c.state_code "
							  +" and s.state_code = st_own.state_code " 
							  +" and st_own.gst_code = st_c.gst_code " //Intra-state supply. Site.GST_CODE = Customer's SITE.GST_CODE 
							  +" and c.tax_reg_2 = 'UNREGISTER' "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
					
					/**
					 * Detail B2CS Intra-state supplies 7A(1) B2CS *	
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item, uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							+" and t.tax_type in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							dtlSql = dtlSql +" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"7A(1) B2CS");
					
					/**
					 * 7B(1) B2CS Header Inter-state supplies  *	
					 */
					hdrSql =   " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'I' as GST_TYPE,"
							  +" '13' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" st_c.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'R' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" ' ' as LR_NO, "
							  +" null as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  +" i.stan_code__init as ORDER_NO," // 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state st_c, state st_own "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and st_c.state_code = c.state_code "
							  +" and s.state_code = st_own.state_code " 
							  +" and st_own.gst_code <> st_c.gst_code " //Site.GST_CODE<>Customer's SITE.GST_CODE 
							  +" and c.tax_reg_2 = 'UNREGISTER' "
							  +" and i.net_amt <= "+GST_B2CL_INV_VAL+" "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
					 		  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
					
					/**
					 * Detail Inter-state supplies 7B(1) B2CS *
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							+" and t.tax_type in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							 dtlSql = dtlSql +" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"7B(1) B2CS");
					
					/******** 8A Started *****/
					/**
					 * 8A(1) NIL Header NIL Inter-State nil rated supplies to registered  *	
					 */
					  hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'L' as GST_TYPE,"
							  +" '15' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'NRATD' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" ' ' as LR_NO, "
							  +" null as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  +" i.stan_code__init as ORDER_NO," // 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and s.state_code <> c.state_code " // site.state_CODE<>customer' state.state_code
							  +" and c.tax_reg_2 <> 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
							  if(GST_NIL_TAXCLASS.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_class in ("+GST_NIL_TAXCLASS+") ";
						  	  }
							  if(GST_NIL_TAXENV.length() > 0)
							  {
							  	   hdrSql = hdrSql +" and ti.tax_env in ("+GST_NIL_TAXENV+") ";
							  }
							  hdrSql = hdrSql +" ) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
					
					/**
					 * Detail NIL Inter-State nil rated supplies to registered 8A(1) NIL*	
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item, uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							+" and t.tax_type in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							 dtlSql = dtlSql +" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"8A(1) NIL");
					
					 /**
					 * 8A(2) NIL Header NIL Inter-State nil rated supplies to registered  *	
					 */
					  hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'L' as GST_TYPE,"
							  +" '16' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'EXEMP' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" ' ' as LR_NO, "
							  +" null as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  +" i.stan_code__init as ORDER_NO," // 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and s.state_code <> c.state_code "
							  +" and c.tax_reg_2 <> 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
							  if(GST_EXE_TAXCLASS.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_class in ("+GST_EXE_TAXCLASS+") ";
						  	  }
							  if(GST_EXE_TAXENV.length() > 0)
							  {
							  	   hdrSql = hdrSql +" and ti.tax_env in ("+GST_EXE_TAXENV+") ";
							  }
							  hdrSql = hdrSql +" ) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";

					/**
					 * Detail NIL Inter-State nil rated supplies to registered 8A(2) NIL*	
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							+" and t.tax_type in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							 dtlSql = dtlSql +" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"8A(2) NIL");
					
				 /**
				  * 8A(3) NIL Header NIL Inter-State nil rated supplies to registered  *	
				  */
				  hdrSql = " select '' as  TRAN_ID, "
						  +" to_date(i.GP_DATE) as TRAN_DATE, "
						  +" '' as TRAN_ID__REF, "
						  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
						  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
						  +" '1' as REC_TYPE, " 
						  +" 'L' as GST_TYPE,"
						  +" '17' as TRAN_TYPE," 
						  +" i.cust_code as CUST_CODE, "
						  +" c.cust_name as CUST_NAME, "
						  +" state.GST_CODE, " 
						  +" '' as SUBMISSION_TYPE," 
						  +" '' as  DOC_CHECKSUM,"
						  +" 'NOGST' as DOC_TYPE, " 
						  +" i.GP_NO as DOC_NO, "
						  +" i.gp_date as DOC_DATE, "
						  +" i.net_amt as AMOUNT, "
						  +" 'N' as REVERSE_CHRG, "
						  +" ' ' as LR_NO, "
						  +" null as LR_DATE,"
						  +" ' ' as REAS_CODE, "
						  +" ' ' as REF_ID__INV, "
						  +" null REF_DATE__INV, "
						  +" 'N' as PROV_ASSMNT, " 
						  +" i.stan_code__init as ORDER_NO," // 
						  +" null as ORDER_DATE, "
						  //+" i.invoice_id as  REMARKS, "
						  +" '' as  REMARKS, "
						  +" i.invoice_id as  REF_ID, "
						  +" ' ' as SUBMIT_STATUS, "
						  +" null SUBMIT_DATE, "
						  +" '' ADD_USER, "
					      +" sysdate as ADD_DATE, "
						  +" '' ADD_TERM, "
					      +" ' ' CHG_USER, "
						  +" sysdate CHG_DATE, "
						  +" ' 'CHG_TERM, "
						  +" c.tax_reg_2 as TAX_REG_NO, "
						  +" ' '  as RECO_STATUS, "
						  +" ' ' as ECOM_REG_NO, "
						  +" 'S-INV' as ref_ser "
						  +" from invoice i,customer c, site s, state state "
						  +" where c.cust_code = i.cust_code "
						  +" and s.site_code = i.site_code "
						  +" and state.state_code = c.state_code "
						  +" and s.state_code <> c.state_code "
						  +" and c.tax_reg_2 <> 'UNREGISTER' "
						  +" and (select count(1) from taxtran ti, tax t where t.tax_code = ti.tax_code "
						  +" and ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id and t.tax_type not in ('G','H','I','J')) > 0 "
						  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
						  +" and i.conf_date between ? and ? "
				  		  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";

					/**
					 * Detail NIL Inter-State nil rated supplies to registered 8A(3) NIL*	
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							+" and t.tax_type not in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							 dtlSql = dtlSql +" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"8A(3) NIL");
					
					/******* 8B started ********/
					/**
					 * 8B(1) NIL Header Intra-state to registered suppliers  *	
					 */
					  hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'L' as GST_TYPE,"
							  +" '18' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'NRATD' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" ' ' as LR_NO, "
							  +" null as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  +" i.stan_code__init as ORDER_NO," // 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and s.state_code = c.state_code "
							  +" and c.tax_reg_2 <> 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
							  if(GST_NIL_TAXCLASS.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_class in ("+GST_NIL_TAXCLASS+") ";
						  	  }
							  if(GST_NIL_TAXENV.length() > 0)
							  {
							  	   hdrSql = hdrSql +" and ti.tax_env in ("+GST_NIL_TAXENV+") ";
							  }
							  hdrSql = hdrSql +" ) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
					  
						/**
						 * Detail Intra-state to registered suppliers 8B(1) NIL *	
						 */
						dtlSql = " select '' as  TRAN_ID, "
							    +" it.line_no as LINE_NO, "
							    +" 'A' as STATUS, " 
							    +" 0 as SR_NO__OLD, "
							    +" 'G' as LINE_TYPE,"
								+" si.hsn_no as GS_CODE, "
								+" tx.TAXABLE_AMT as TAXABLE_AMT, "
								+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
								+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
								+" item.sh_descr GS_DESCR,"
								+" u.descr as UNIT,"
							    +" (it.quantity__stduom) as QUANTITY,"
								+" 'OE' as SUPPLY_TYPE," 
							    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
								+" '' as REMARKS "
								+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item, uom u "
								+" where i.invoice_id = it.invoice_id "
								+" and si.site_code = i.site_code "
								+" and si.item_code = it.item_code "
								+" and item.item_code = it.item_code "
								+" and t.tax_code = tx.tax_code "
								+" and t.tax_type in ('G','H','I','J') "
								+" and tx.tran_code = 'S-INV' "
								+" and tx.tran_id = i.invoice_id ";
								 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
								 {
									dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
								 }
								 else
								 {	
									dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
								 }
								dtlSql = dtlSql +" and i.invoice_id = ? "
								+" and u.unit = item.unit ";
								
						retString = executeSqlAndPopulateData(hdrSql,dtlSql,"8B(1) NIL");
						
					/**
					 * 8B(2) NIL Header Intra-state to registered suppliers  *	
					 */
					  hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'L' as GST_TYPE,"
							  +" '19' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'EXEMP' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" ' ' as LR_NO, "
							  +" null as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  +" i.stan_code__init as ORDER_NO," 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and s.state_code = c.state_code "
							  +" and c.tax_reg_2 <> 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
							  if(GST_EXE_TAXCLASS.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_class in ("+GST_EXE_TAXCLASS+") ";
						  	  }
							  if(GST_EXE_TAXENV.length() > 0)
							  {
							  	   hdrSql = hdrSql +" and ti.tax_env in ("+GST_EXE_TAXENV+") ";
							  }
							  hdrSql = hdrSql +" ) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
					 
						/**
						 * Detail Intra-state to registered suppliers 8B(2) NIL *	
						 */
						dtlSql = " select '' as  TRAN_ID, "
							    +" it.line_no as LINE_NO, "
							    +" 'A' as STATUS, " 
							    +" 0 as SR_NO__OLD, "
							    +" 'G' as LINE_TYPE,"
								+" si.hsn_no as GS_CODE, "
								+" tx.TAXABLE_AMT as TAXABLE_AMT, "
								+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
								+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
								+" item.sh_descr GS_DESCR,"
								+" u.descr as UNIT,"
							    +" (it.quantity__stduom) as QUANTITY,"
								+" 'OE' as SUPPLY_TYPE," 
							    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
								+" '' as REMARKS "
								+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
								+" where i.invoice_id = it.invoice_id "
								+" and si.site_code = i.site_code "
								+" and si.item_code = it.item_code "
								+" and item.item_code = it.item_code "
								+" and t.tax_code = tx.tax_code "
								+" and t.tax_type in ('G','H','I','J') "
								+" and tx.tran_code = 'S-INV' "
								+" and tx.tran_id = i.invoice_id ";
								 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
								 {
									dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
								 }
								 else
								 {	
									dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
								 }
								dtlSql = dtlSql +" and i.invoice_id = ? "
								+" and u.unit = item.unit ";
								
						retString = executeSqlAndPopulateData(hdrSql,dtlSql,"8B(2) NIL");
						
					/**
					  * 8B(3) NIL Header Intra-state to registered suppliers  *	
					 */
					  hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'L' as GST_TYPE,"
							  +" '20' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'NOGST' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" ' ' as LR_NO, "
							  +" null as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  +" i.stan_code__init as ORDER_NO," // 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and s.state_code = c.state_code "
							  +" and c.tax_reg_2 <> 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti, tax t where t.tax_code = ti.tax_code "
							  +" and ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id and t.tax_type not in ('G','H','I','J')) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
					  		  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
					 
						/**
						 * Detail Intra-state to registered suppliers 8B(3) NIL *	
						 */
						dtlSql = " select '' as  TRAN_ID, "
							    +" it.line_no as LINE_NO, "
							    +" 'A' as STATUS, " 
							    +" 0 as SR_NO__OLD, "
							    +" 'G' as LINE_TYPE,"
								+" si.hsn_no as GS_CODE, "
								+" tx.TAXABLE_AMT as TAXABLE_AMT, "
								+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
								+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
								+" item.sh_descr GS_DESCR,"
								+" u.descr as UNIT,"
							    +" (it.quantity__stduom) as QUANTITY,"
								+" 'OE' as SUPPLY_TYPE," 
							    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
								+" '' as REMARKS "
								+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item, uom u "
								+" where i.invoice_id = it.invoice_id "
								+" and si.site_code = i.site_code "
								+" and si.item_code = it.item_code "
								+" and item.item_code = it.item_code "
								+" and t.tax_code = tx.tax_code "
								+" and t.tax_type not in ('G','H','I','J') "
								+" and tx.tran_code = 'S-INV' "
								+" and tx.tran_id = i.invoice_id ";
								 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
								 {
									dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
								 }
								 else
								 {	
									dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
								 }
								dtlSql = dtlSql +" and i.invoice_id = ? "
								+" and u.unit = item.unit ";
								
						retString = executeSqlAndPopulateData(hdrSql,dtlSql,"8B(3) NIL");
						
				  /******* 8C started ********/
				 /**
				  * 8C(1) NIL  Header Inter-state to unregistered suppliers *	
				 */
				  hdrSql = " select '' as  TRAN_ID, "
						  +" to_date(i.GP_DATE) as TRAN_DATE, "
						  +" '' as TRAN_ID__REF, "
						  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
						  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
						  +" '1' as REC_TYPE, " 
						  +" 'L' as GST_TYPE,"
						  +" '21' as TRAN_TYPE," 
						  +" i.cust_code as CUST_CODE, "
						  +" c.cust_name as CUST_NAME, "
						  +" state.GST_CODE, " 
						  +" '' as SUBMISSION_TYPE," 
						  +" '' as  DOC_CHECKSUM,"
						  +" 'NRATD' as DOC_TYPE, " 
						  +" i.GP_NO as DOC_NO, "
						  +" i.gp_date as DOC_DATE, "
						  +" i.net_amt as AMOUNT, "
						  +" 'N' as REVERSE_CHRG, "
						  +" ' ' as LR_NO, "
						  +" null as LR_DATE,"
						  +" ' ' as REAS_CODE, "
						  +" ' ' as REF_ID__INV, "
						  +" null REF_DATE__INV, "
						  +" 'N' as PROV_ASSMNT, " 
						  +" i.stan_code__init as ORDER_NO," // 
						  +" null as ORDER_DATE, "
						  //+" i.invoice_id as  REMARKS, "
						  +" '' as  REMARKS, "
						  +" i.invoice_id as  REF_ID, "
						  +" ' ' as SUBMIT_STATUS, "
						  +" null SUBMIT_DATE, "
						  +" '' ADD_USER, "
					      +" sysdate as ADD_DATE, "
						  +" '' ADD_TERM, "
					      +" ' ' CHG_USER, "
						  +" sysdate CHG_DATE, "
						  +" ' 'CHG_TERM, "
						  +" c.tax_reg_2 as TAX_REG_NO, "
						  +" ' '  as RECO_STATUS, "
						  +" ' ' as ECOM_REG_NO, "
						  +" 'S-INV' as ref_ser "
						  +" from invoice i,customer c, site s, state state "
						  +" where c.cust_code = i.cust_code "
						  +" and s.site_code = i.site_code "
						  +" and state.state_code = c.state_code "
						  +" and s.state_code <> c.state_code "
						  +" and c.tax_reg_2 = 'UNREGISTER' "
						  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
						  if(GST_NIL_TAXCLASS.length() > 0)
					  	  {
					  		   hdrSql = hdrSql +" and ti.tax_class in ("+GST_NIL_TAXCLASS+") ";
					  	  }
						  if(GST_NIL_TAXENV.length() > 0)
						  {
						  	   hdrSql = hdrSql +" and ti.tax_env in ("+GST_NIL_TAXENV+") ";
						  }
						  hdrSql = hdrSql +" ) > 0 "
						  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
						  +" and i.conf_date between ? and ? "
						  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
				  
					/**
					 * Detail Inter-state to unregistered suppliers 8C(1) NIL *	
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item, uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							+" and t.tax_type in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							 dtlSql = dtlSql +" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"8C(1) NIL");	
					
					
				 /**
				  * 8C(2) NIL  Header Inter-state to unregistered suppliers *	
				  */
				  hdrSql = " select '' as  TRAN_ID, "
						  +" to_date(i.GP_DATE) as TRAN_DATE, "
						  +" '' as TRAN_ID__REF, "
						  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
						  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
						  +" '1' as REC_TYPE, " 
						  +" 'L' as GST_TYPE,"
						  +" '22' as TRAN_TYPE," 
						  +" i.cust_code as CUST_CODE, "
						  +" c.cust_name as CUST_NAME, "
						  +" state.GST_CODE, " 
						  +" '' as SUBMISSION_TYPE," 
						  +" '' as  DOC_CHECKSUM,"
						  +" 'EXEMP' as DOC_TYPE, " 
						  +" i.GP_NO as DOC_NO, "
						  +" i.gp_date as DOC_DATE, "
						  +" i.net_amt as AMOUNT, "
						  +" 'N' as REVERSE_CHRG, "
						  +" ' ' as LR_NO, "
						  +" null as LR_DATE,"
						  +" ' ' as REAS_CODE, "
						  +" ' ' as REF_ID__INV, "
						  +" null REF_DATE__INV, "
						  +" 'N' as PROV_ASSMNT, " 
						  +" i.stan_code__init as ORDER_NO," // 
						  +" null as ORDER_DATE, "
						  //+" i.invoice_id as  REMARKS, "
						  +" '' as  REMARKS, "
						  +" i.invoice_id as  REF_ID, "
						  +" ' ' as SUBMIT_STATUS, "
						  +" null SUBMIT_DATE, "
						  +" '' ADD_USER, "
					      +" sysdate as ADD_DATE, "
						  +" '' ADD_TERM, "
					      +" ' ' CHG_USER, "
						  +" sysdate CHG_DATE, "
						  +" ' 'CHG_TERM, "
						  +" c.tax_reg_2 as TAX_REG_NO, "
						  +" ' '  as RECO_STATUS, "
						  +" ' ' as ECOM_REG_NO, "
						  +" 'S-INV' as ref_ser "
						  +" from invoice i,customer c, site s, state state "
						  +" where c.cust_code = i.cust_code "
						  +" and s.site_code = i.site_code "
						  +" and state.state_code = c.state_code "
						  +" and s.state_code <> c.state_code "
						  +" and c.tax_reg_2 = 'UNREGISTER' "
						  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
						  if(GST_EXE_TAXCLASS.length() > 0)
					  	  {
					  		   hdrSql = hdrSql +" and ti.tax_class in ("+GST_EXE_TAXCLASS+") ";
					  	  }
						  if(GST_EXE_TAXENV.length() > 0)
						  {
						  	   hdrSql = hdrSql +" and ti.tax_env in ("+GST_EXE_TAXENV+") ";
						  }
						  hdrSql = hdrSql +" ) > 0 "
						  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
						  +" and i.conf_date between ? and ? "
						  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
				  
				  	/**
					  * Detail Inter-state to unregistered suppliers 8C(2) NIL *	
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item, uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							+" and t.tax_type in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							dtlSql = dtlSql +" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"8C(2) NIL");
				
				/**
				  * 8C(3) NIL Header Inter-state to unregistered suppliers  *	
				 */
				  hdrSql = " select '' as  TRAN_ID, "
						  +" to_date(i.GP_DATE) as TRAN_DATE, "
						  +" '' as TRAN_ID__REF, "
						  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
						  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
						  +" '1' as REC_TYPE, " 
						  +" 'L' as GST_TYPE,"
						  +" '23' as TRAN_TYPE," 
						  +" i.cust_code as CUST_CODE, "
						  +" c.cust_name as CUST_NAME, "
						  +" state.GST_CODE, " 
						  +" '' as SUBMISSION_TYPE," 
						  +" '' as  DOC_CHECKSUM,"
						  +" 'NOGST' as DOC_TYPE, " 
						  +" i.GP_NO as DOC_NO, "
						  +" i.gp_date as DOC_DATE, "
						  +" i.net_amt as AMOUNT, "
						  +" 'N' as REVERSE_CHRG, "
						  +" ' ' as LR_NO, "
						  +" null as LR_DATE,"
						  +" ' ' as REAS_CODE, "
						  +" ' ' as REF_ID__INV, "
						  +" null REF_DATE__INV, "
						  +" 'N' as PROV_ASSMNT, " 
						  +" i.stan_code__init as ORDER_NO," // 
						  +" null as ORDER_DATE, "
						  //+" i.invoice_id as  REMARKS, "
						  +" '' as  REMARKS, "
						  +" i.invoice_id as  REF_ID, "
						  +" ' ' as SUBMIT_STATUS, "
						  +" null SUBMIT_DATE, "
						  +" '' ADD_USER, "
					      +" sysdate as ADD_DATE, "
						  +" '' ADD_TERM, "
					      +" ' ' CHG_USER, "
						  +" sysdate CHG_DATE, "
						  +" ' 'CHG_TERM, "
						  +" c.tax_reg_2 as TAX_REG_NO, "
						  +" ' '  as RECO_STATUS, "
						  +" ' ' as ECOM_REG_NO, "
						  +" 'S-INV' as ref_ser "
						  +" from invoice i,customer c, site s, state state "
						  +" where c.cust_code = i.cust_code "
						  +" and s.site_code = i.site_code "
						  +" and state.state_code = c.state_code "
						  +" and s.state_code <> c.state_code "
						  +" and c.tax_reg_2 = 'UNREGISTER' "
						  +" and (select count(1) from taxtran ti, tax t where t.tax_code = ti.tax_code "
						  +" and ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id and t.tax_type not in ('G','H','I','J') ) > 0 "
						  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
						  +" and i.conf_date between ? and ? "
				  		  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";

				  	/**
					  * Detail Inter-state to unregistered suppliers 8C(3) NIL *	
					 */
					dtlSql = " select '' as  TRAN_ID, "
						    +" it.line_no as LINE_NO, "
						    +" 'A' as STATUS, " 
						    +" 0 as SR_NO__OLD, "
						    +" 'G' as LINE_TYPE,"
							+" si.hsn_no as GS_CODE, "
							+" tx.TAXABLE_AMT as TAXABLE_AMT, "
							+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
						    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
						    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
						    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
							+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
						    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
							+" item.sh_descr GS_DESCR,"
							+" u.descr as UNIT,"
						    +" (it.quantity__stduom) as QUANTITY,"
							+" 'OE' as SUPPLY_TYPE," 
						    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
						    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
							+" '' as REMARKS "
							+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
							+" where i.invoice_id = it.invoice_id "
							+" and si.site_code = i.site_code "
							+" and si.item_code = it.item_code "
							+" and item.item_code = it.item_code "
							+" and t.tax_code = tx.tax_code "
							+" and t.tax_type not in ('G','H','I','J') "
							+" and tx.tran_code = 'S-INV' "
							+" and tx.tran_id = i.invoice_id ";
							 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
							 {
								dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
							 }
							 else
							 {	
								dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
							 }
							dtlSql = dtlSql+" and i.invoice_id = ? "
							+" and u.unit = item.unit ";
							
					retString = executeSqlAndPopulateData(hdrSql,dtlSql,"8C(3) NIL");
					
					 /******* 8D started ********/
					{
					/**
					  * 8D(1) NIL Header Intra-state to unregistered suppliers  *	
					 */
					  hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'L' as GST_TYPE,"
							  +" '24' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'NRATD' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" ' ' as LR_NO, "
							  +" null as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  +" i.stan_code__init as ORDER_NO," // 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and s.state_code = c.state_code "
							  +" and c.tax_reg_2 = 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
							  if(GST_NIL_TAXCLASS.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_class in ("+GST_NIL_TAXCLASS+") ";
						  	  }
							  if(GST_NIL_TAXENV.length() > 0)
							  {
							  	   hdrSql = hdrSql +" and ti.tax_env in ("+GST_NIL_TAXENV+") ";
							  }
							  hdrSql = hdrSql +" ) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
					  
						/**
						 * Detail Intra-state to unregistered suppliers 8D(1) NIL *	
						 */
						dtlSql = " select '' as  TRAN_ID, "
							    +" it.line_no as LINE_NO, "
							    +" 'A' as STATUS, " 
							    +" 0 as SR_NO__OLD, "
							    +" 'G' as LINE_TYPE,"
								+" si.hsn_no as GS_CODE, "
								+" tx.TAXABLE_AMT as TAXABLE_AMT, "
								+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
								+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
								+" item.sh_descr GS_DESCR,"
								+" u.descr as UNIT,"
							    +" (it.quantity__stduom) as QUANTITY,"
								+" 'OE' as SUPPLY_TYPE," 
							    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
								+" '' as REMARKS "
								+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
								+" where i.invoice_id = it.invoice_id "
								+" and si.site_code = i.site_code "
								+" and si.item_code = it.item_code "
								+" and item.item_code = it.item_code "
								+" and t.tax_code = tx.tax_code "
								+" and t.tax_type in ('G','H','I','J') "
								+" and tx.tran_code = 'S-INV' "
								+" and tx.tran_id = i.invoice_id ";
								 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
								 {
									dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
								 }
								 else
								 {	
									dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
								 }
								dtlSql = dtlSql +" and i.invoice_id = ? "
								+" and u.unit = item.unit ";
								
						retString = executeSqlAndPopulateData(hdrSql,dtlSql,"8D(1) NIL");	
						
					 /**
					  * 8D(2) NIL Header Intra-state to unregistered suppliers *	
					 */
					  hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'L' as GST_TYPE,"
							  +" '25' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'EXEMP' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" ' ' as LR_NO, "
							  +" null as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  +" i.stan_code__init as ORDER_NO," // 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and s.state_code = c.state_code "
							  +" and c.tax_reg_2 = 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id ";
							  if(GST_EXE_TAXCLASS.length() > 0)
						  	  {
						  		   hdrSql = hdrSql +" and ti.tax_class in ("+GST_EXE_TAXCLASS+") ";
						  	  }
							  if(GST_EXE_TAXENV.length() > 0)
							  {
							  	   hdrSql = hdrSql +" and ti.tax_env in ("+GST_EXE_TAXENV+") ";
							  }
							  hdrSql = hdrSql +" ) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
					  
					  	/**
						  * Detail Intra-state to unregistered suppliers 8D(2) NIL *	
						 */
						dtlSql = " select '' as  TRAN_ID, "
							    +" it.line_no as LINE_NO, "
							    +" 'A' as STATUS, " 
							    +" 0 as SR_NO__OLD, "
							    +" 'G' as LINE_TYPE,"
								+" si.hsn_no as GS_CODE, "
								+" tx.TAXABLE_AMT as TAXABLE_AMT, "
								+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
								+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
								+" item.sh_descr GS_DESCR,"
								+" u.descr as UNIT,"
							    +" (it.quantity__stduom) as QUANTITY,"
								+" 'OE' as SUPPLY_TYPE," 
							    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
								+" '' as REMARKS "
								+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
								+" where i.invoice_id = it.invoice_id "
								+" and si.site_code = i.site_code "
								+" and si.item_code = it.item_code "
								+" and item.item_code = it.item_code "
								+" and t.tax_code = tx.tax_code "
								+" and t.tax_type in ('G','H','I','J') "
								+" and tx.tran_code = 'S-INV' "
								+" and tx.tran_id = i.invoice_id ";
								 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
								 {
									dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
								 }
								 else
								 {	
									dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
								 }
								dtlSql = dtlSql +" and i.invoice_id = ? "
								+" and u.unit = item.unit ";
								
						retString = executeSqlAndPopulateData(hdrSql,dtlSql,"8D(2) NIL");
					
					/**
					  * 8D(3) NIL Header Intra-state to unregistered suppliers  *	
					 */
					  hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'L' as GST_TYPE,"
							  +" '26' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'NOGST' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" ' ' as LR_NO, "
							  +" null as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  +" i.stan_code__init as ORDER_NO," // 
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state state "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.state_code "
							  +" and s.state_code = c.state_code "
							  +" and c.tax_reg_2 = 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti, tax t where t.tax_code = ti.tax_code "
							  +" and ti.tran_code = 'S-INV' and ti.tran_id = i.invoice_id and t.tax_type not in ('G','H','I','J') ) > 0 "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
					  		  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";

					  	/**
						  * Detail Intra-state to unregistered suppliers 8D(3) NIL *	
						 */
						dtlSql = " select '' as  TRAN_ID, "
							    +" it.line_no as LINE_NO, "
							    +" 'A' as STATUS, " 
							    +" 0 as SR_NO__OLD, "
							    +" 'G' as LINE_TYPE,"
								+" si.hsn_no as GS_CODE, "
								+" tx.TAXABLE_AMT as TAXABLE_AMT, "
								+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
								+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
								+" item.sh_descr GS_DESCR,"
								+" u.descr as UNIT,"
							    +" (it.quantity__stduom) as QUANTITY,"
								+" 'OE' as SUPPLY_TYPE," 
							    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
								+" '' as REMARKS "
								+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
								+" where i.invoice_id = it.invoice_id "
								+" and si.site_code = i.site_code "
								+" and si.item_code = it.item_code "
								+" and item.item_code = it.item_code "
								+" and t.tax_code = tx.tax_code "
								+" and t.tax_type not in ('G','H','I','J') "
								+" and tx.tran_code = 'S-INV' "
								+" and tx.tran_id = i.invoice_id ";
								 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
								 {
									dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
								 }
								 else
								 {	
									dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
								 }
								dtlSql = dtlSql +" and i.invoice_id = ? "
								+" and u.unit = item.unit ";
								
						retString = executeSqlAndPopulateData(hdrSql,dtlSql,"8D(3) NIL");
					 }
					
					 /******* 9A started Need to check query********/
					{
					/**
					  * 9A(1) Header EXPA Export amendments with payment *	
					 */
					  hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'E' as GST_TYPE,"
							  +" '27' as TRAN_TYPE," 
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" 'WPAY' as DOC_TYPE, " 
							  +" i.GP_NO as DOC_NO, "
							  +" i.gp_date as DOC_DATE, "
							  +" i.net_amt as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" ' ' as LR_NO, "
							  +" null as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" ' ' as REF_ID__INV, "
							  +" null REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  +" i.stan_code__init as ORDER_NO," // 
							  +" null as ORDER_DATE, "
							 //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  +" 'S-INV' as ref_ser "
							  +" from invoice i,customer c, site s, state, invoice_amendment a "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code <> c.state_code "
							  +" and c.tax_reg_2 <> 'UNREGISTER' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' "
							  +" and ti.tran_id = i.invoice_id ";
							  if(taxClassAllStr.length() > 0)
						  	  {
								 hdrSql = hdrSql +" and ti.tax_class in ("+taxClassAllStr+") ";
						  	  }
							  hdrSql = hdrSql +" ) = 0  "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
							  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 "
							  +" and to_date(i.conf_date) < ? ";
					  
						/**
						 * Detail  EXPA Export amendments with payment 9A(1) *	
						 */
						dtlSql = " select '' as  TRAN_ID, "
							    +" it.line_no as LINE_NO, "
							    +" 'A' as STATUS, " 
							    +" 0 as SR_NO__OLD, "
							    +" 'G' as LINE_TYPE,"
								+" si.hsn_no as GS_CODE, "
								+" tx.TAXABLE_AMT as TAXABLE_AMT, "
								+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
								+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
								+" item.sh_descr GS_DESCR,"
								+" u.descr as UNIT,"
							    +" (it.quantity__stduom) as QUANTITY,"
								+" 'OE' as SUPPLY_TYPE," 
							    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
								+" '' as REMARKS "
								+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
								+" where i.invoice_id = it.invoice_id "
								+" and si.site_code = i.site_code "
								+" and si.item_code = it.item_code "
								+" and item.item_code = it.item_code "
								+" and t.tax_code = tx.tax_code "
								+" and t.tax_type in ('G','H','I','J') "
								+" and tx.tran_code = 'S-INV' "
								+" and tx.tran_id = i.invoice_id ";
								 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
								 {
									dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
								 }
								 else
								 {	
									dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
								 }
								if(taxClassAllStr.length() > 0)
							  	{
									dtlSql = dtlSql +" and tx.tax_class not in ("+taxClassAllStr+") ";
							  	}
								dtlSql = dtlSql +" and i.invoice_id = ? "
								+" and u.unit = item.unit ";
								
						retString = executeSqlAndPopulateData(hdrSql,dtlSql,"9A(1)");
						
					}
					
					/******* 9B started ********/
					{
					  /**
					  * 9B(1) Header CDNR Credit Note registered *	
					  */
					  hdrSql = " select '' as  TRAN_ID, "
							  +" to_date(i.GP_DATE) as TRAN_DATE, "
							  +" '' as TRAN_ID__REF, "
							  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
							  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
							  +" '1' as REC_TYPE, " 
							  +" 'N' as GST_TYPE,"
						    //+" '29' as TRAN_TYPE," 
							  +" case when i.drcr_flag = 'C' then '29' else '30' end  as TRAN_TYPE, "
							  +" i.cust_code as CUST_CODE, "
							  +" c.cust_name as CUST_NAME, "
							  +" state.GST_CODE, " 
							  +" '' as SUBMISSION_TYPE," 
							  +" '' as  DOC_CHECKSUM,"
							  +" i.drcr_flag as DOC_TYPE, " 
							  +" i.tran_id as DOC_NO, "
							  +" i.conf_date as DOC_DATE, "
							  +" i.amount as AMOUNT, "
							  +" 'N' as REVERSE_CHRG, "
							  +" ' ' as LR_NO, "
							  +" null as LR_DATE,"
							  +" ' ' as REAS_CODE, "
							  +" i.invoice_id as REF_ID__INV, "
							  +" inv.gp_date as REF_DATE__INV, "
							  +" 'N' as PROV_ASSMNT, " 
							  +" ' ' as ORDER_NO,"
							  +" null as ORDER_DATE, "
							  //+" i.invoice_id as  REMARKS, "
							  +" '' as  REMARKS, "
							  +" i.invoice_id as  REF_ID, "
							  +" ' ' as SUBMIT_STATUS, "
							  +" null SUBMIT_DATE, "
							  +" '' ADD_USER, "
						      +" sysdate as ADD_DATE, "
							  +" '' ADD_TERM, "
						      +" ' ' CHG_USER, "
							  +" sysdate CHG_DATE, "
							  +" ' 'CHG_TERM, "
							  +" c.tax_reg_2 as TAX_REG_NO, "
							  +" ' '  as RECO_STATUS, "
							  +" ' ' as ECOM_REG_NO, "
							  //+" 'S-INV' as ref_ser "
					          +" case when i.drcr_flag = 'C' then 'CRNRCP' else 'DRNRCP' end as ref_ser "
							  +" from drcr_rcp i,customer c, site s, state, invoice inv "
							  +" where c.cust_code = i.cust_code "
							  +" and s.site_code = i.site_code "
							  +" and state.state_code = c.STATE_CODE "
							  +" and inv.invoice_id = i.invoice_id "
							  +" and case when i.confirmed is null then 'N' else i.confirmed end  = 'Y' "
							  +" and (select count(1) from taxtran ti where ti.tran_code = 'S-INV' ) = 0 "
							  +" and to_date(inv.conf_date) < '"+currMonthStartDate+"' "
							  +" and c.tax_reg_2 <> 'UNREGISTER' " 
							  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
							  +" and i.conf_date between ? and ? "
					  		  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
					  
						/**
						 * Detail  CDNR Credit Note registered 9B(1) *	
						 */
						dtlSql = " select '' as  TRAN_ID, "
							    +" it.line_no as LINE_NO, "
							    +" 'A' as STATUS, " 
							    +" 0 as SR_NO__OLD, "
							    +" 'G' as LINE_TYPE,"
								+" si.hsn_no as GS_CODE, "
								+" tx.TAXABLE_AMT as TAXABLE_AMT, "
								+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
								+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
								+" item.sh_descr GS_DESCR,"
								+" u.descr as UNIT,"
							    +" (it.quantity__stduom) as QUANTITY,"
								+" 'OE' as SUPPLY_TYPE," 
							    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
								+" '' as REMARKS "
								+" from drcr_rcp i,drcr_rdet it,taxtran tx, siteitem si, tax t, item,uom u  "
								+" where i.tran_id = it.tran_id "
								+" and si.site_code = i.site_code "
								+" and si.item_code = it.item_code  "
								+" and item.item_code = it.item_code "
								+" and t.tax_code = tx.tax_code "
								+" and t.tax_type in ('G','H','I','J') "
								+" and tx.tran_code in ( 'CRNRCP','DRNRCP') "
								+" and tx.tran_id = i.invoice_id ";
								 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
								 {
									dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
								 }
								 else
								 {	
									dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
								 }
								dtlSql = dtlSql +" and i.invoice_id = ? "
								+" and u.unit = item.unit ";
						
							retString = executeSqlAndPopulateData(hdrSql,dtlSql,"9B(1)");
					}
					
					/******11 Started ******/
					{
						/**
						 * 11(A.1) Header AT Intra-State advance received(Rate wise) *	
						 */
						  hdrSql = " select '' as  TRAN_ID, "
								  +" to_date(i.GP_DATE) as TRAN_DATE, "
								  +" '' as TRAN_ID__REF, "
								  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
								  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
								  +" '1' as REC_TYPE, " 
								  +" 'A' as GST_TYPE,"
								  +" '41' as TRAN_TYPE," 
								  +" i.cust_code as CUST_CODE, "
								  +" c.cust_name as CUST_NAME, "
								  +" state.GST_CODE, " 
								  +" '' as SUBMISSION_TYPE," 
								  +" '' as  DOC_CHECKSUM,"
								  +" '' as DOC_TYPE, " 
								  +" i.GP_NO as DOC_NO, "
								  +" i.gp_date as DOC_DATE, "
								  +" i.net_amt as AMOUNT, "
								  +" 'N' as REVERSE_CHRG, "
								  +" ' ' as LR_NO, "
								  +" null as LR_DATE,"
								  +" ' ' as REAS_CODE, "
								  +" ' ' as REF_ID__INV, "
								  +" null REF_DATE__INV, "
								  +" 'N' as PROV_ASSMNT, "
								  +" '' as ORDER_NO," 
								  +" null as ORDER_DATE, "
								  //+" i.invoice_id as  REMARKS, "
								  +" '' as  REMARKS, "
								  +" i.invoice_id as  REF_ID, "
								  +" ' ' as SUBMIT_STATUS, "
								  +" null SUBMIT_DATE, "
								  +" '' ADD_USER, "
							      +" sysdate as ADD_DATE, "
								  +" '' ADD_TERM, "
							      +" ' ' CHG_USER, "
								  +" sysdate CHG_DATE, "
								  +" ' 'CHG_TERM, "
								  +" c.tax_reg_2 as TAX_REG_NO, "
								  +" ' '  as RECO_STATUS, "
								  +" ' ' as ECOM_REG_NO, "
								  +" 'S-INV' as ref_ser "
								  +" from invoice i,customer c, site s, state state "
								  +" where c.cust_code = i.cust_code "
								  +" and s.site_code = i.site_code "
								  +" and state.state_code = c.state_code "
								  +" and s.state_code = c.state_code "
								  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
								  +" and i.conf_date between ? and ? "
						  		  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
						/**
						 * Detail AT Intra-State advance received(Rate wise) 11(A.1)*	
						 */ 
						dtlSql = " select '' as  TRAN_ID, "
							    +" it.line_no as LINE_NO, "
							    +" 'A' as STATUS, " 
							    +" 0 as SR_NO__OLD, "
							    +" 'G' as LINE_TYPE,"
								+" si.hsn_no as GS_CODE, "
								+" tx.TAXABLE_AMT as TAXABLE_AMT, "
								+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
								+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
								+" item.sh_descr GS_DESCR,"
								+" u.descr as UNIT,"
							    +" (it.quantity__stduom) as QUANTITY,"
								+" 'OE' as SUPPLY_TYPE," 
							    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
								+" '' as REMARKS "
								+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
								+" where i.invoice_id = it.invoice_id "
								+" and si.site_code = i.site_code "
								+" and si.item_code = it.item_code "
								+" and item.item_code = it.item_code "
								+" and t.tax_code = tx.tax_code "
								+" and t.tax_type in ('G','H','I','J') "
								+" and tx.tran_code = 'S-INV' "
								+" and tx.tran_id = i.invoice_id ";
								 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
								 {
									dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
								 }
								 else
								 {	
									dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
								 }
								 dtlSql = dtlSql +" and i.invoice_id = ? "
								+" and u.unit = item.unit ";
								 
					  //retString = executeSqlAndPopulateData(hdrSql,dtlSql,"11(A).1"); Not called as it will be changed as per new requirement
					  
					  
					    /**
						 * 11(A.2) Header AT Intra-State advance received(Rate wise)*	
						 */
						  hdrSql = " select '' as  TRAN_ID, "
								  +" to_date(i.GP_DATE) as TRAN_DATE, "
								  +" '' as TRAN_ID__REF, "
								  +" case when s.SITE_CODE__EXC is null then s.site_code else s.SITE_CODE__EXC end as SITE_CODE, "
								  +" to_char(i.GP_DATE,'MMYYYY') as PRD_CODE, "
								  +" '1' as REC_TYPE, " 
								  +" 'A' as GST_TYPE,"
								  +" '42' as TRAN_TYPE," 
								  +" i.cust_code as CUST_CODE, "
								  +" c.cust_name as CUST_NAME, "
								  +" state.GST_CODE, " 
								  +" '' as SUBMISSION_TYPE," 
								  +" '' as  DOC_CHECKSUM,"
								  +" '' as DOC_TYPE, " 
								  +" i.GP_NO as DOC_NO, "
								  +" i.gp_date as DOC_DATE, "
								  +" i.net_amt as AMOUNT, "
								  +" 'N' as REVERSE_CHRG, "
								  +" ' ' as LR_NO, "
								  +" null as LR_DATE,"
								  +" ' ' as REAS_CODE, "
								  +" ' ' as REF_ID__INV, "
								  +" null REF_DATE__INV, "
								  +" 'N' as PROV_ASSMNT, "
								  +" '' as ORDER_NO," 
								  +" null as ORDER_DATE, "
								  //+" i.invoice_id as  REMARKS, "
								  +" '' as  REMARKS, "
								  +" i.invoice_id as  REF_ID, "
								  +" ' ' as SUBMIT_STATUS, "
								  +" null SUBMIT_DATE, "
								  +" '' ADD_USER, "
							      +" sysdate as ADD_DATE, "
								  +" '' ADD_TERM, "
							      +" ' ' CHG_USER, "
								  +" sysdate CHG_DATE, "
								  +" ' 'CHG_TERM, "
								  +" c.tax_reg_2 as TAX_REG_NO, "
								  +" ' '  as RECO_STATUS, "
								  +" ' ' as ECOM_REG_NO, "
								  +" 'S-INV' as ref_ser "
								  +" from invoice i,customer c, site s, state state"
								  +" where c.cust_code = i.cust_code "
								  +" and s.site_code = i.site_code "
								  +" and state.state_code = c.state_code "
								  +" and c.state_code <> s.state_code "
								  +" and case when i.confirmed is null then 'N' else i.confirmed end = 'Y' "
								  +" and i.conf_date between ? and ? "
						  		  +" and (select count(1) from gst_data_hdr where ref_ser = 'S-INV' and ref_id = i.invoice_id ) = 0 ";
						/**
						 * Detail AT Intra-State advance received(Rate wise) 11(A.2)*	
						 */ 
						dtlSql = " select '' as  TRAN_ID, "
							    +" it.line_no as LINE_NO, "
							    +" 'A' as STATUS, " 
							    +" 0 as SR_NO__OLD, "
							    +" 'G' as LINE_TYPE,"
								+" si.hsn_no as GS_CODE, "
								+" tx.TAXABLE_AMT as TAXABLE_AMT, "
								+" case when t.tax_type = 'I'  then tx.tax_perc else 0  end as IGST_PERC,"
							    +" (case when t.tax_type = 'I'  then tx.tax_amt else 0  end) as IGST_AMT,"
							    +" case when t.tax_type = 'H'  then tx.tax_perc else 0  end as CGST_PERC,"
							    +" (case when t.tax_type = 'H'  then tx.tax_amt else 0  end) as  CGST_AMT,"
								+" case when t.tax_type = 'G'  then tx.tax_perc else 0  end as SGST_PERC,"
							    +" (case when t.tax_type = 'G'  then tx.tax_amt else 0  end) as  SGST_AMT,"
								+" item.sh_descr GS_DESCR,"
								+" u.descr as UNIT,"
							    +" (it.quantity__stduom) as QUANTITY,"
								+" 'OE' as SUPPLY_TYPE," 
							    +" case when t.tax_type = 'J'  then tx.tax_perc else 0  end as CESS_PERC,"
							    +" (case when t.tax_type = 'J'  then tx.tax_amt else 0  end) as CESS_AMT,"
								+" '' as REMARKS "
								+" from invoice i,invoice_trace it,taxtran tx, siteitem si, tax t, item,uom u "
								+" where i.invoice_id = it.invoice_id "
								+" and si.site_code = i.site_code "
								+" and si.item_code = it.item_code "
								+" and item.item_code = it.item_code "
								+" and t.tax_code = tx.tax_code "
								+" and t.tax_type in ('G','H','I','J') "
								+" and tx.tran_code = 'S-INV' "
								+" and tx.tran_id = i.invoice_id ";
								 if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
								 {
									dtlSql = dtlSql +" and cast(tx.line_no as integer)  = it.line_no ";
								 }
								 else
								 {	
									dtlSql = dtlSql +" and to_number(trim(tx.line_no)) = it.line_no ";
								 }
								 dtlSql = dtlSql +" and i.invoice_id = ? "
								+" and u.unit = item.unit ";		
								 
					     //retString = executeSqlAndPopulateData(hdrSql,dtlSql,"11(A).2"); Not called as it will be changed as per new requirement
				     }
					
			}
			if ("P".equalsIgnoreCase(type)) 
			{
				
			}
			
			long endTime = System.currentTimeMillis();
			System.out.println("END TIME FOR GST DATA POPULATION PROCESS IN SECONDS:::["+endTime/1000+"]");
			System.out.println("DIFFERANCE IN TIME GST DATA POPULATION PROCESS IN SECONDS:::["+(endTime-startTime)/1000+"]");
		} 
		catch (Exception e)
		{
			System.out.println("Exception inside GstDataPrc==>"+e.getMessage());
			isError = true;
			e.printStackTrace();
			//throw new ITMException(e);
			errorMessage.append("\n["+e.getMessage()+"]");
		}
		finally
		{
			System.out.println("Inside finally isError["+isError+"] connStatus[]");
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(pstmtSelHdr != null)
				{
					pstmtSelHdr.close();pstmtSelHdr = null;
				}
				if(pstmtSelDet != null)
				{
					pstmtSelDet.close();pstmtSelDet = null;
				}
				if(pstmtInsHdr != null)
				{
					pstmtInsHdr.close();pstmtInsHdr = null;
				}
				if(pstmtInsDet != null)
				{
					pstmtInsDet.close();pstmtInsDet = null;
				}
				if(rsSelHdr != null)
				{
					rsSelHdr.close();rsSelHdr = null;
				}
				if(rsSelDet != null)
				{
					rsSelDet.close();rsSelDet = null;
				}
				if(isError)
				{
					System.out.println("GstDataPrc connection RollBack.....");
					//connLocal.rollback();
					connGST.rollback();
					//retString = itmDBAccessEJB.getErrorString("","VTPRCESERR","","",connLocal);
					//retString = itmDBAccessEJB.getErrorString("","VTPRCESERR","","",connGST);
					retString = getError(errorMessage.toString(),"PRCSUCCESS",connGST);
				}
				if(!isError)
				{
					System.out.println("GstDataPrc connection Commit.....");
					//connLocal.commit();//Temporary commented
					//connLocal.rollback();
					connGST.commit();
					//retString = itmDBAccessEJB.getErrorString("","PRCSUCCESS","","",connLocal);
					//retString = itmDBAccessEJB.getErrorString("","PRCSUCCESS","","",connGST);
					retString = getError(errorMessage.toString(),"PRCSUCCESS",connGST);
				}
				if( connLocal != null && !connLocal.isClosed() )
				{
					connLocal.close();connLocal = null;
				}
				if( connGST != null && !connGST.isClosed() )
				{
					connGST.close();connGST = null;
				}
				
				errorMessage.delete(0, errorMessage.length());
			}
			catch (Exception ex)
			{	
				ex.printStackTrace();
				throw new ITMException(ex);
			}		
		}
		System.out.println("Return String from Post Save ["+retString+"]");
		return retString;
	}
	
	public String getError(String message,String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  itmDBAccessEJB.getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
			
			mainStr = begPart + message + endDesc;
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}

	private String generateTranId(String windowName, String siteCode,String tranDateStr, Connection conn) throws ITMException, Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";

		try 
		{
			String monthStr = ""; 
			java.util.Date date= new Date();
			Calendar cal = Calendar.getInstance();
			cal.setTime(date);
			int month = cal.get(Calendar.MONTH);
			month = month - 1;
			if(month < 10)
			{
				monthStr = "0"+month;
			}
			else
			{
				monthStr = ""+month;
			}
			System.out.println("Current Month is=["+monthStr+"]");
			
			
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString(1, windowName);
			rs = pstmt.executeQuery();
			if (rs.next()) 
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("keyString :" + keyString);
			System.out.println("keyCol :" + keyCol);
			System.out.println("tranSer :" + tranSer);

			xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues + "<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<month>" + monthStr + "</month>";
			xmlValues = xmlValues + "<tran_date>" + tranDateStr +"</tran_date>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :[" + xmlValues + "]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE",CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :" + tranId);

		} 
		catch (SQLException ex) 
		{
			System.out.println("Exception ::" + selSql + ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally 
		{
			if (rs != null) 
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null) 
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return tranId;
	}

	private String checkNull(String input) 
	{
		if (input == null) 
		{
			input = "";
		}
		return input;
	}
	
	private String getSqlInString(String strParam) throws ITMException, Exception
	{
		String inSql = "";
		String [] sqlSupp = strParam.split(",");

		for (int i = 0;i<sqlSupp.length;i++)
		{
			//inSql = inSql +"'"+sqlSupp[i]+"',";
			if(("NULLFOUND".equals(sqlSupp[i]) || sqlSupp[i] == null || sqlSupp[i].trim().length() == 0))
			{
				//System.out.println("Not found Disparm");
			}
			else
			{
				inSql = inSql +"'"+sqlSupp[i]+"',";
			}
		}
		if(inSql.lastIndexOf(",") > -1)
		{
			inSql = inSql.substring(0,inSql.length() - 1);
		}
		//System.out.println("inSql : ["+inSql+"]");

		return inSql;
	}
	
	public String executeSqlAndPopulateData (String hdrSql, String dtlSql, String tranSer) throws Exception
	{
		String retString = "";
		
		PreparedStatement pstmt = null,pstmtInsHdr = null,pstmtInsDet = null, pstmtSelHdr = null,pstmtSelDet = null; 
		ResultSet rs = null, rsSelHdr= null, rsSelDet = null;
		
		String period = "", type = "", sql = "",prdcode = "";

		Timestamp docDate = null,lrDate = null,refDateInv = null,orderDate = null;
		
		String invoiceid = "",gstTranId = "",tranidRef = "",prdCode = "",recType = "",tranType = "",custCode = "",custName = "",
				gstCode = "",submissionType = "",docCheckSum = "",docNo = "",revCharge = "",lrNo = "",reasCode = "",refIdInv = "",
				prvAssment = "",orderNo = "",remarks = "",submitStatus = "",
				taxRegNo = "",recoStatus = "",ecomRegNo = "",refSer = "",prdCodeGstHdr = "",stateCode = "",docType = "",
				srNoOld = "",lineType = "",gsCode = "",gsDescr = "",unit = "",supplyType = "",remarksDet = "",distOrdTranID = "",
				tranIDPorcp = "",gstType = "",remarksHdr = "", refID = "";

		int updCnt = 0;
		int detCnts = 0,hdrCnts = 0,lineNo = 0;
		int detSum=0,hdrSum = 0;
		int cnt = 0;
		
		double amount = 0, taxableAmt = 0, igstPerc = 0, igstAmt = 0, cgstPerc = 0, cgstAmt = 0, sgstPerc= 0,sgstAmt = 0,quantity = 0, cessPerc = 0,cessAmt = 0; 

		try
		{
				System.out.println("\n\n\n XXXXXXXXXXXXXXXXXXXX  Started Populating ["+tranSer+"] Data  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX ");
			
				sql = " INSERT INTO GST_DATA_HDR(TRAN_ID,TRAN_DATE,TRAN_ID__REF,SITE_CODE,PRD_CODE,REC_TYPE,GST_TYPE,TRAN_TYPE,CUST_CODE,CUST_NAME,"
						+ " GST_CODE,SUBMISSION_TYPE,DOC_CHECKSUM,DOC_TYPE,DOC_NO,DOC_DATE,AMOUNT,REVERSE_CHRG,LR_NO,LR_DATE,REAS_CODE,"
						+ " REF_ID__INV,REF_DATE__INV,PROV_ASSMNT,ORDER_NO,ORDER_DATE,REMARKS,SUBMIT_STATUS,SUBMIT_DATE,ADD_USER,ADD_DATE,"
						+ " ADD_TERM,CHG_USER,CHG_DATE,CHG_TERM,TAX_REG_NO,RECO_STATUS,ECOM_REG_NO,REF_SER,REF_ID) "
					     +" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
				pstmtInsHdr = connGST.prepareStatement(sql);
				
				sql = " INSERT INTO GST_DATA_DET (TRAN_ID,LINE_NO,STATUS,SR_NO__OLD,LINE_TYPE,GS_CODE,TAXABLE_AMT,IGST_PERC,"
						   +" IGST_AMT,CGST_PERC,CGST_AMT,SGST_PERC,SGST_AMT,GS_DESCR,UNIT,QUANTITY,SUPPLY_TYPE,CESS_PERC,CESS_AMT,REMARKS)"
						   +" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
				//pstmtInsDet = connLocal.prepareStatement(sql);
				pstmtInsDet = connGST.prepareStatement(sql);
			
				sql = hdrSql;
				pstmtSelHdr = connGST.prepareStatement(sql);
				pstmtSelHdr.setTimestamp(1, fromDate);
				pstmtSelHdr.setTimestamp(2, toDate);
				if("9A(1)".equals(tranSer))
				{
					pstmtSelHdr.setTimestamp(3, currMonthStartDate);
				}
				
				rsSelHdr = pstmtSelHdr.executeQuery();
				while(rsSelHdr.next())
				{
					updCnt = 0;
					hdrCnts++;
					
					//gstTranId = rsSelHdr.getString("TRAN_ID");
					//tranDate = rsSelHdr.getString("TRAN_DATE");
					tranidRef = rsSelHdr.getString("TRAN_ID__REF");
					prdCodeGstHdr = rsSelHdr.getString("PRD_CODE");
					recType = rsSelHdr.getString("REC_TYPE");
					gstType = rsSelHdr.getString("GST_TYPE");
					tranType = rsSelHdr.getString("TRAN_TYPE");
					custCode = rsSelHdr.getString("CUST_CODE");
					custName = rsSelHdr.getString("CUST_NAME");
					stateCode = rsSelHdr.getString("GST_CODE");
					submissionType = rsSelHdr.getString("SUBMISSION_TYPE");
					docCheckSum = rsSelHdr.getString("DOC_CHECKSUM");
					docType = rsSelHdr.getString("DOC_TYPE");
					docNo = rsSelHdr.getString("DOC_NO");
					docDate = rsSelHdr.getTimestamp("DOC_DATE");
					amount = rsSelHdr.getDouble("AMOUNT");
					revCharge = rsSelHdr.getString("REVERSE_CHRG");
					lrNo = rsSelHdr.getString("LR_NO");
					lrDate = rsSelHdr.getTimestamp("LR_DATE");
					reasCode = rsSelHdr.getString("REAS_CODE");
					refIdInv = rsSelHdr.getString("REF_ID__INV");
					refDateInv = rsSelHdr.getTimestamp("REF_DATE__INV");
					prvAssment = rsSelHdr.getString("PROV_ASSMNT");
					orderNo = rsSelHdr.getString("ORDER_NO");
					orderDate = rsSelHdr.getTimestamp("ORDER_DATE");
					submitStatus = rsSelHdr.getString("SUBMIT_STATUS");
					//submitDate = rsSelHdr.getTimestamp("SUBMIT_DATE");
					//addUser = rsSelHdr.getString("ADD_USER");
					//addDate = rsSelHdr.getString("ADD_DATE");
					//addTerm = rsSelHdr.getString("ADD_TERM");
					//chgUser = rsSelHdr.getString("CHG_USER");
					//chgDate = rsSelHdr.getString("CHG_DATE");
					//chgTerm = rsSelHdr.getString("CHG_TERM");
					taxRegNo = rsSelHdr.getString("TAX_REG_NO");
					recoStatus = rsSelHdr.getString("RECO_STATUS");
					ecomRegNo = rsSelHdr.getString("ECOM_REG_NO");
					refSer = rsSelHdr.getString("REF_SER");
					remarksHdr = rsSelHdr.getString("REMARKS");
					refID = rsSelHdr.getString("REF_ID");
					
					//gstTranId = ( generateTranId( "w_gstr", loginSiteCode, currDateStr, connLocal) );
					gstTranId = ( generateTranId( "w_gstr", loginSiteCode, currDateStr, connGST) );
					System.out.println("Tran ID generated for tranSer ["+tranSer+"] ["+gstTranId+"]");

					/*sql = " INSERT INTO GST_DATA_HDR(TRAN_ID,TRAN_DATE,TRAN_ID__REF,SITE_CODE,PRD_CODE,REC_TYPE,GST_TYPE,TRAN_TYPE,CUST_CODE,CUST_NAME,"
							+ " GST_CODE,SUBMISSION_TYPE,DOC_CHECKSUM,DOC_TYPE,DOC_NO,DOC_DATE,AMOUNT,REVERSE_CHRG,LR_NO,LR_DATE,REAS_CODE,"
							+ " REF_ID__INV,REF_DATE__INV,PROV_ASSMNT,ORDER_NO,ORDER_DATE,REMARKS,SUBMIT_STATUS,SUBMIT_DATE,ADD_USER,ADD_DATE,"
							+ " ADD_TERM,CHG_USER,CHG_DATE,CHG_TERM,TAX_REG_NO,RECO_STATUS,ECOM_REG_NO,REF_SER,REF_ID) "
						     +" VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
					//pstmtInsHdr = connLocal.prepareStatement(sql);
					pstmtInsHdr = connGST.prepareStatement(sql);*/
					
					pstmtInsHdr.setString(1,gstTranId);	
					pstmtInsHdr.setTimestamp(2,currDate);	
					pstmtInsHdr.setString(3,tranidRef);	
					pstmtInsHdr.setString(4,loginSiteCode);
					pstmtInsHdr.setString(5,prdCodeGstHdr);
					pstmtInsHdr.setString(6,"1");	
					pstmtInsHdr.setString(7,gstType);	
					pstmtInsHdr.setString(8,tranType);
					pstmtInsHdr.setString(9,custCode);
					pstmtInsHdr.setString(10,custName);	
					pstmtInsHdr.setString(11,stateCode);
					pstmtInsHdr.setString(12,"M");	
					pstmtInsHdr.setString(13,docCheckSum);
					pstmtInsHdr.setString(14,docType);
					pstmtInsHdr.setString(15,docNo);	
					pstmtInsHdr.setTimestamp(16,docDate);
					pstmtInsHdr.setDouble(17,amount);	
					pstmtInsHdr.setString(18,"N");
					pstmtInsHdr.setString(19,lrNo);
					pstmtInsHdr.setTimestamp(20,lrDate);
					pstmtInsHdr.setString(21,reasCode);	
					pstmtInsHdr.setString(22,refIdInv);
					pstmtInsHdr.setTimestamp(23,refDateInv);		
					pstmtInsHdr.setString(24,prvAssment);
					pstmtInsHdr.setString(25,orderNo);
					pstmtInsHdr.setTimestamp(26,orderDate);	
					pstmtInsHdr.setString(27,remarksHdr);
					pstmtInsHdr.setString(28,"P");	
					pstmtInsHdr.setString(29,null);
					pstmtInsHdr.setString(30,chgUser);	
					pstmtInsHdr.setTimestamp(31,sysDate);
					pstmtInsHdr.setString(32,chgTerm);	
					pstmtInsHdr.setString(33,chgUser);
					pstmtInsHdr.setTimestamp(34,sysDate);
					pstmtInsHdr.setString(35,chgTerm);	
					pstmtInsHdr.setString(36,taxRegNo);
					pstmtInsHdr.setString(37,recoStatus);		
					pstmtInsHdr.setString(38,ecomRegNo);
					pstmtInsHdr.setString(39,refSer);
					pstmtInsHdr.setString(40,refID);
					
					/*updCnt = pstmtInsHdr.executeUpdate();
					System.out.println("Header ["+tranSer+"] Inserted Cnt TranID["+gstTranId+"] RefID["+refID+"]="+updCnt);
					if(pstmtInsHdr!=null)
					{
						pstmtInsHdr.close();pstmtInsHdr = null;
					}*/
					pstmtInsHdr.addBatch();
					pstmtInsHdr.clearParameters();
					
						sql = dtlSql;
						pstmtSelDet = connGST.prepareStatement(sql);
						pstmtSelDet.setString(1, refID);
						rsSelDet = pstmtSelDet.executeQuery();
						
						//detCnts = 0;
						lineNo = 0;
						detSum = 0;
						while(rsSelDet.next())
						{
							detCnts++;
							lineNo++;
							
							//lineno = rsSelDet.getString("LINE_NO");
							srNoOld = rsSelDet.getString("SR_NO__OLD");
							lineType = rsSelDet.getString("LINE_TYPE");
							gsCode = rsSelDet.getString("GS_CODE");
							taxableAmt = rsSelDet.getDouble("TAXABLE_AMT");
							igstPerc = rsSelDet.getDouble("IGST_PERC");
							igstAmt = rsSelDet.getDouble("IGST_AMT");
							cgstPerc = rsSelDet.getDouble("CGST_PERC");
							cgstAmt = rsSelDet.getDouble("CGST_AMT");
							sgstPerc = rsSelDet.getDouble("SGST_PERC");
							sgstAmt = rsSelDet.getDouble("SGST_AMT");
							gsDescr = rsSelDet.getString("GS_DESCR");
							unit = rsSelDet.getString("UNIT");
							quantity = rsSelDet.getDouble("QUANTITY");
							supplyType = rsSelDet.getString("SUPPLY_TYPE");
							cessPerc = rsSelDet.getDouble("CESS_PERC");
							cessAmt = rsSelDet.getDouble("CESS_AMT");
							remarksDet = rsSelDet.getString("REMARKS");

							/*sql= " INSERT INTO GST_DATA_DET (TRAN_ID,LINE_NO,STATUS,SR_NO__OLD,LINE_TYPE,GS_CODE,TAXABLE_AMT,IGST_PERC,"
									   +" IGST_AMT,CGST_PERC,CGST_AMT,SGST_PERC,SGST_AMT,GS_DESCR,UNIT,QUANTITY,SUPPLY_TYPE,CESS_PERC,CESS_AMT,REMARKS)"
									   +" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
							pstmtInsDet = connLocal.prepareStatement(sql);*/
							
							pstmtInsDet.setString(1,gstTranId);
							pstmtInsDet.setInt(2,lineNo);
							pstmtInsDet.setString(3,"A");	
							pstmtInsDet.setString(4,srNoOld);	
							pstmtInsDet.setString(5,lineType);
							pstmtInsDet.setString(6,gsCode);	
							pstmtInsDet.setDouble(7,taxableAmt);
							pstmtInsDet.setDouble(8,igstPerc);
							pstmtInsDet.setDouble(9,igstAmt);	
							pstmtInsDet.setDouble(10,cgstPerc);
							pstmtInsDet.setDouble(11,cgstAmt);	
							pstmtInsDet.setDouble(12,sgstPerc);
							pstmtInsDet.setDouble(13,sgstAmt);	
							pstmtInsDet.setString(14,gsDescr);
							pstmtInsDet.setString(15,unit);	
							pstmtInsDet.setDouble(16,quantity);
							pstmtInsDet.setString(17,supplyType);
							pstmtInsDet.setDouble(18,cessPerc);	
							pstmtInsDet.setDouble(19,cessAmt);
							pstmtInsDet.setString(20,remarksDet);
							
							pstmtInsDet.addBatch();
							pstmtInsDet.clearParameters();
						}
						if(pstmtSelDet!=null)
						{
							pstmtSelDet.close();pstmtSelDet = null;
						}
						if(rsSelDet!=null)
						{
							rsSelDet.close();rsSelDet = null;
						}
						
						/*if(detCnts>0)
						{
							int[] updateCounts = pstmtInsDet.executeBatch();

							for( int num : updateCounts)
							{
								arrSum = arrSum + num;
						    }
						}
						
						System.out.println(" DetailCnt["+detCnts+"]  Detail Executed["+arrSum+"]");*/
				}
				if(rsSelHdr!=null)
				{
					rsSelHdr.close();rsSelHdr = null;
				}
				if(pstmtSelHdr!=null)
				{
					pstmtSelHdr.close();pstmtSelHdr = null;
				}
				
				System.out.println("Header Counts ["+hdrCnts+"] Detail Count ["+detCnts+"]");
				if(hdrCnts > 0)
				{
					int[] hdrUpdCounts = pstmtInsHdr.executeBatch();
					for( int hdrNum : hdrUpdCounts)
					{
						hdrSum = hdrNum + hdrSum;
				    }
					
					if(detCnts>0)
					{
						int[] detUpdCounts = pstmtInsDet.executeBatch();
	
						for( int detNum : detUpdCounts)
						{
							detSum = detSum + detNum;
					    }
					}
				}
				
				if(pstmtInsHdr != null)
				{
					pstmtInsHdr.close();pstmtInsHdr = null;
				}
				if(pstmtInsDet != null)
				{
					pstmtInsDet.close();pstmtInsDet = null;
				}
				
				System.out.println("HeaderCnt ["+hdrCnts+"] Header Executed ["+hdrSum+"] \n DetailCnt["+detCnts+"]  Detail Executed["+detSum+"]");
				
			System.out.println("XXXXXXXXXXXXXXXXXXXX  Completed Populating ["+tranSer+"] Data  XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
		}
		catch(BatchUpdateException buex)
        {
			System.out.println("Exception inside GstDataPrc SQL Exception==>"+buex.getMessage());
			try
			{
				int [] updateCounts = buex.getUpdateCounts();
				for (int i = 0; i < updateCounts.length; i++)
				{
					System.err.println("  Statement " + i + ":" + updateCounts[i]);
				}
				System.err.println(" Message: " + buex.getMessage());
				System.err.println(" SQLSTATE: " + buex.getSQLState());
				System.err.println(" Error code: " + buex.getErrorCode());
				
				errorMessage.append("\nSection ["+tranSer+"] ["+buex.getMessage()+"] ["+buex.getSQLState()+"] ["+buex.getErrorCode()+"]");
				
				SQLException ex = buex.getNextException();
				while (ex != null)
				{ 
					System.err.println("SQL exception:");
					System.err.println(" Message: " + ex.getMessage());
					System.err.println(" SQLSTATE: " + ex.getSQLState());
					System.err.println(" Error code: " + ex.getErrorCode());
					ex = ex.getNextException();
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
			}
			//throw new ITMException(buex);
        }
		catch(Exception e)
		{
			System.out.println("Inside Exception executeSqlAndPopulateData==>"+e.getMessage());
			errorMessage.append("\nSection ["+tranSer+"] ["+e.getMessage()+"]");
			//throw new Exception();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(pstmtSelHdr != null)
				{
					pstmtSelHdr.close();pstmtSelHdr = null;
				}
				if(pstmtSelDet != null)
				{
					pstmtSelDet.close();pstmtSelDet = null;
				}
				if(pstmtInsHdr != null)
				{
					pstmtInsHdr.close();pstmtInsHdr = null;
				}
				if(pstmtInsDet != null)
				{
					pstmtInsDet.close();pstmtInsDet = null;
				}
				if(rsSelHdr != null)
				{
					rsSelHdr.close();rsSelHdr = null;
				}
				if(rsSelDet != null)
				{
					rsSelDet.close();rsSelDet = null;
				}
			}
			catch(Exception ex)
			{
				System.out.println("Inside finally executeSqlAndPopulateData==>"+ex.getMessage());
			}
		}
		
		return retString;
	}
	
	
	public static boolean isNumeric(String str)  
	{  
	  try  
	  {  
	     int i = Integer.parseInt(str);  
	  }  
	  catch(NumberFormatException nfe)  
	  {  
		 System.out.println("Inside number format Exception"+nfe);
	     return false;  
	  }  
	  return true;  
	}

}