/*
 * Author: Wasim Ansari
 * Date: 26-SEP-2016
 * Request: S16EBAS006 (Sale Order Wizard)
 */

package ibase.webitm.ejb.wms;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Properties;

import javax.ejb.Stateless;
import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Session Bean implementation class SorderWizardPosEJB
 */
@Stateless
public class SorderWizardPosEJB extends ValidatorEJB implements SorderWizardPosEJBRemote,SorderWizardPosEJBLocal 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	MasterStatefulLocal masterStatefulLocal = null;
	DistCommon distComm = new DistCommon();
	FinCommon finCommon = new FinCommon();
    /**
     * Default constructor. 
     */
    public SorderWizardPosEJB() {
        // TODO Auto-generated constructor stub
    }

	@Override
	public String postSave(String xmlStringAll, String tranID, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException 
	{
		String retString="";
		try 
		{
			retString = postSave(xmlStringAll, xtraParams, "", conn);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	
		
	public String postSave(String xmlstring, String xtraParams, String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("Inside SorderWizardPosEJB Post Save");
		
		PreparedStatement pstmt = null, pstmtUpdate = null;
		ResultSet rs = null;
		
		String retString = "",userInfo = "";
		
		SimpleDateFormat simpleDateFormat = null;
		String currDate = "";
		
		boolean isError = false;
		int lineNo = 0;
		Document dom = null;
		
		String siteCodeOrd = "",orderDate = "",itemSer = "",custCode = "",custCodeDlv = "",custCodeBil = "", dlvTerm = "", userId = "",remarks = "",
				crTerm = "",currCode = "",stanCode = "",tranCode = "",transMode = "",currCodeFrt = "",currCodeIns = "",orderType = "",random = "",
				sql = "",priceList = "",priceListClg = "";
		
		String lsCctrcodeSal = "";
		try
		{	
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			dom = genericUtility.parseString(xmlstring);
			
			currDate = getCurrdateAppFormat();
			
			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			
			String addr1 = "",addr2 = "", addr3 = "",city = "",pin = "",stateCode = "",countCode = "",tel1Dlv = "",tel2Dlv = "",emailAddr = "",locGroup = "",
					custName = "",status = "",empCodeOrd = "",saleOrder = "",partQty = "",dueDate = "",acctCodeSal = "",cctrCodeSal = "",lcExchRate = "";
			
			Node detail1Node = dom.getElementsByTagName("Detail1").item(0);
			NodeList detail1List = detail1Node.getChildNodes();
			int detail1ListLen = detail1List.getLength();
			System.out.println("Detail1 Length =========================================="+detail1ListLen);
			for(int ctr = 0 ;ctr < detail1ListLen; ctr++)
			{
				Node childNode = detail1List.item(ctr);
				if(childNode == null || childNode.getNodeType() != childNode.ELEMENT_NODE)
				{
					continue;
				}
				
				if(childNode != null && "sale_order".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					saleOrder = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "order_date".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					orderDate = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "order_type".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					orderType = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "site_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					siteCodeOrd = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "item_ser".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					itemSer = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "cust_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					custCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "cust_code__dlv".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					custCodeDlv = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "cust_code__bil".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					custCodeBil = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "dlv_term".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					dlvTerm = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "cr_term".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					crTerm = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "curr_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					currCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "stan_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					stanCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "tran_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					tranCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "trans_mode".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					transMode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "curr_code__frt".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					currCodeFrt = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "curr_code__ins".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					currCodeIns = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "remarks".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					remarks = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "udf__num2".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					random = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "cust_name".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					custName = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "udf__str2".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					status = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "emp_code__ord".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					empCodeOrd = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "dlv_add1".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					addr1 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "dlv_add2".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					addr2 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "dlv_city".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					city = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "dlv_pin".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					pin = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "state_code__dlv".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					stateCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "count_code__dlv".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					countCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "dlv_add3".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					addr3 = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "tel1__dlv".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					tel1Dlv = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "tel2__dlv".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					tel2Dlv = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "part_qty".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					partQty = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "due_date".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					dueDate = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "price_list".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					priceList = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
				else if(childNode != null && "price_list__clg".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
				{
					priceListClg = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
				}
			}
			
			
			lcExchRate = checkNullAndTrim(String.valueOf(finCommon.getDailyExchRateSellBuy(currCode, "", siteCodeOrd, orderDate, "S", conn)));
			System.out.println("Sales Order Exchange Rate is=["+lcExchRate+"]");
			
			//Changed by wasim on 09-DEC-2016 for account code sal [START]
			/*sql = " SELECT ACCT_CODE__SAL,CCTR_CODE__SAL FROM ITEMSER WHERE ITEM_SER = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemSer);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				acctCodeSal = checkNullAndTrim(rs.getString("ACCT_CODE__SAL"));
				cctrCodeSal = checkNullAndTrim(rs.getString("CCTR_CODE__SAL"));
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}*/
			//Changed by wasim on 09-DEC-2016 for account code sal [START]
			
			lsCctrcodeSal = finCommon.getAcctDetrTtype("", itemSer, "SAL", orderType, conn);
			System.out.println("lsCctrcodeSal in SorderWizPost Save["+lsCctrcodeSal+"]");
			String lsAcctcodeSalArr[] = lsCctrcodeSal.split(",");
			
			if(lsAcctcodeSalArr.length>0)
			{
				acctCodeSal=lsAcctcodeSalArr[0];
			}
			else
			{
				acctCodeSal="";
			}
			if(lsAcctcodeSalArr.length>0)
			{
				cctrCodeSal = lsAcctcodeSalArr[1];
			}
			else
			{
				cctrCodeSal="";
			}
			
			sql = " SELECT EMAIL_ADDR,LOC_GROUP FROM CUSTOMER WHERE CUST_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, custCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				emailAddr = checkNullAndTrim(rs.getString("EMAIL_ADDR"));
				locGroup = checkNullAndTrim(rs.getString("LOC_GROUP"));
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			
			/*sql = " SELECT  PRICE_LIST,PRICE_LIST__CLG FROM CUST_PLIST WHERE CUST_CODE =? AND ORDER_TYPE =? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, custCodeDlv);
			pstmt.setString(2, orderType);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				priceList    = checkNullAndTrim(rs.getString("PRICE_LIST"));
				priceListClg = checkNullAndTrim(rs.getString("PRICE_LIST__CLG"));
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}*/
			
			saleOrder = (saleOrder == null) ? "" : saleOrder;
			
			sql = " SELECT SALE_ORDER  FROM SORDER WHERE SALE_ORDER =  ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, saleOrder);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				saleOrder = checkNullAndTrim((rs.getString("SALE_ORDER")));
				
				// Delete 
				sql = " DELETE FROM SORDDET WHERE SALE_ORDER = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, saleOrder);
				pstmt.executeUpdate();
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}

				sql = " DELETE FROM TAXTRAN WHERE  TRAN_CODE = ? AND TRAN_ID = ? ";
				pstmt = conn.prepareStatement(sql);			
				pstmt.setString(1, "S-ORD");
				pstmt.setString(2, saleOrder);
				pstmt.executeUpdate();
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				
				sql = " DELETE FROM SORD_TERM WHERE SALE_ORDER = ? ";
				pstmt = conn.prepareStatement(sql);			
				pstmt.setString(1, saleOrder);
				pstmt.executeUpdate();
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				
				sql = " DELETE FROM SORDER WHERE SALE_ORDER = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, saleOrder);
				pstmt.executeUpdate();
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
			}
			else
			{
				saleOrder = "";
			}
			if( pstmt != null )
			{
				pstmt.close();pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();rs = null;
			}
			System.out.println("Sale Order Final=======>>["+saleOrder+"]"); 

			StringBuffer xmlString = new StringBuffer();
			StringBuffer xmlStringHdr= new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			xmlStringHdr.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 escription</description>");
			xmlStringHdr.append("<Header0>");
			xmlStringHdr.append("<description>Header0 members</description>");
			xmlStringHdr.append("<objName><![CDATA[").append("sorder").append("]]></objName>");
            xmlStringHdr.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
            xmlStringHdr.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
            xmlStringHdr.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
            xmlStringHdr.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
            xmlStringHdr.append("<action><![CDATA[").append("SAVE").append("]]></action>");
            xmlStringHdr.append("<elementName><![CDATA[").append("").append("]]></elementName>");
            xmlStringHdr.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
            xmlStringHdr.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
            xmlStringHdr.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
            xmlStringHdr.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
            xmlStringHdr.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
            
            xmlStringHdr.append("<Detail1 dbID='' domID=\"1\" objName=\"sorder\" objContext=\"1\">");
            xmlStringHdr.append("<attribute pkNames=\"sale_order:\" status=\"N\" updateFlag=\"A\" selected=\"N\" />");
            
            xmlStringHdr.append("<sale_order><![CDATA[").append(saleOrder).append("]]></sale_order>");
            xmlStringHdr.append("<order_date><![CDATA[").append(orderDate).append("]]></order_date>");
            xmlStringHdr.append("<order_type><![CDATA[").append(orderType).append("]]></order_type>");
            xmlStringHdr.append("<site_code><![CDATA[").append(siteCodeOrd).append("]]></site_code>");
            xmlStringHdr.append("<item_ser><![CDATA[").append(itemSer).append("]]></item_ser>");
            xmlStringHdr.append("<cust_code><![CDATA[").append(custCode).append("]]></cust_code>");
            xmlStringHdr.append("<cust_code__dlv><![CDATA[").append(custCodeDlv).append("]]></cust_code__dlv>");
            xmlStringHdr.append("<cust_code__bil><![CDATA[").append(custCodeBil).append("]]></cust_code__bil>");
            xmlStringHdr.append("<dlv_term><![CDATA[").append(dlvTerm).append("]]></dlv_term>");
            xmlStringHdr.append("<remarks><![CDATA[").append(remarks).append("]]></remarks>");
            xmlStringHdr.append("<cr_term><![CDATA[").append(crTerm).append("]]></cr_term>");
            xmlStringHdr.append("<curr_code><![CDATA[").append(currCode).append("]]></curr_code>");
            xmlStringHdr.append("<stan_code><![CDATA[").append(stanCode).append("]]></stan_code>");
            xmlStringHdr.append("<tran_code><![CDATA[").append(tranCode).append("]]></tran_code>");
            xmlStringHdr.append("<trans_mode><![CDATA[").append(transMode).append("]]></trans_mode>");
            xmlStringHdr.append("<curr_code__frt>").append("<![CDATA["+currCodeFrt+"]]>").append("</curr_code__frt>\r\n");
            xmlStringHdr.append("<curr_code__ins>").append("<![CDATA["+currCodeIns+"]]>").append("</curr_code__ins>\r\n");
            xmlStringHdr.append("<udf__num2>").append("<![CDATA["+random+"]]>").append("</udf__num2>\r\n");
            xmlStringHdr.append("<dlv_to>").append("<![CDATA["+custName+"]]>").append("</dlv_to>\r\n");
            xmlStringHdr.append("<dlv_add1>").append("<![CDATA["+addr1+"]]>").append("</dlv_add1>\r\n");
            xmlStringHdr.append("<dlv_add2>").append("<![CDATA["+addr2+"]]>").append("</dlv_add2>\r\n");
            xmlStringHdr.append("<dlv_add3>").append("<![CDATA["+addr3+"]]>").append("</dlv_add3>\r\n");
            xmlStringHdr.append("<dlv_city>").append("<![CDATA["+city+"]]>").append("</dlv_city>\r\n");
            xmlStringHdr.append("<dlv_pin>").append("<![CDATA["+pin+"]]>").append("</dlv_pin>\r\n");
            xmlStringHdr.append("<stan_code>").append("<![CDATA["+stanCode+"]]>").append("</stan_code>\r\n");
            xmlStringHdr.append("<state_code__dlv>").append("<![CDATA["+stateCode+"]]>").append("</state_code__dlv>\r\n");
            xmlStringHdr.append("<count_code__dlv>").append("<![CDATA["+countCode+"]]>").append("</count_code__dlv>\r\n");
            xmlStringHdr.append("<group_code>").append("<![CDATA["+locGroup+"]]>").append("</group_code>\r\n");
            xmlStringHdr.append("<tel1__dlv>").append("<![CDATA["+tel1Dlv+"]]>").append("</tel1__dlv>\r\n");
            xmlStringHdr.append("<tel2__dlv>").append("<![CDATA["+tel2Dlv+"]]>").append("</tel2__dlv>\r\n");
            xmlStringHdr.append("<part_qty>").append("<![CDATA["+partQty+"]]>").append("</part_qty>\r\n");
            xmlStringHdr.append("<due_date>").append("<![CDATA["+dueDate+"]]>").append("</due_date>\r\n");
            xmlStringHdr.append("<acct_code__sal>").append("<![CDATA["+acctCodeSal+"]]>").append("</acct_code__sal>\r\n");
            xmlStringHdr.append("<cctr_code__sal>").append("<![CDATA["+cctrCodeSal+"]]>").append("</cctr_code__sal>\r\n");
            
            if(lcExchRate.length() == 0)
            {
            	 xmlStringHdr.append("<exch_rate>").append("<![CDATA["+ 1 +"]]>").append("</exch_rate>\r\n");
            	 xmlStringHdr.append("<exch_rate__frt>").append("<![CDATA["+ 1 +"]]>").append("</exch_rate__frt>\r\n");
            	 xmlStringHdr.append("<exch_rate__ins>").append("<![CDATA["+ 1 +"]]>").append("</exch_rate__ins>\r\n");
            }
            else
            {
            	xmlStringHdr.append("<exch_rate>").append("<![CDATA["+lcExchRate+"]]>").append("</exch_rate>\r\n");
            	xmlStringHdr.append("<exch_rate__frt>").append("<![CDATA["+ lcExchRate +"]]>").append("</exch_rate__frt>\r\n");
            	xmlStringHdr.append("<exch_rate__ins>").append("<![CDATA["+ lcExchRate +"]]>").append("</exch_rate__ins>\r\n");
            }
            xmlStringHdr.append("<price_list>").append("<![CDATA["+ priceList +"]]>").append("</price_list>\r\n");
            xmlStringHdr.append("<price_list__clg>").append("<![CDATA["+ priceListClg +"]]>").append("</price_list__clg>\r\n");
            //xmlStringHdr.append("</Detail1>");
	
            StringBuffer xmlStringDet = new StringBuffer();
			String lineNoCntr = "",lineNoOrd = "",itemCode = "",taxChap = "",taxClass = "",taxEnv = "",empCodeAprv = "",unit = "",unitRate = "",itmFlag = "",itemDescr = "",dspDate = "";
			int domID = 0;
			double quantity = 0,rate = 0,rateStd = 0,rateClg = 0, discount = 0;
			
			NodeList detail3NodeList =dom.getElementsByTagName("Detail3");
			int detail3NodeListlen = detail3NodeList.getLength();
			System.out.println("Detail3 Length =========================================="+detail3NodeListlen);
			for(int ctrH = 0; ctrH < detail3NodeListlen ; ctrH++)
			{
				itemCode = "";itemDescr = "";quantity = 0;rate = 0;rateStd = 0;unitRate = "";rateClg = 0;unit = "";
				taxChap = "";taxClass = "";taxEnv ="";itmFlag = "";dspDate = "";itemSer = ""; 
				
				NodeList childNodeList = detail3NodeList.item(ctrH).getChildNodes();
				int childNodeListlen = childNodeList.getLength();

				for(int ctrD = 0; ctrD < childNodeListlen ; ctrD++)
				{
					Node childNode = childNodeList.item(ctrD);
					
					if(childNode == null || childNode.getNodeType() != childNode.ELEMENT_NODE)
					{
						continue;
					}
					
					if(childNode != null && "item_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						itemCode = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "item_descr".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						itemDescr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "quantity".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						quantity = Double.parseDouble(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "rate".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						rate = Double.parseDouble(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "rate__std".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						rateStd = Double.parseDouble(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "unit__rate".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						unitRate = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "rate__clg".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						rateClg = Double.parseDouble(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "unit".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						unit = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "tax_chap".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						taxChap = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "tax_class".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						taxClass = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "tax_env".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						taxEnv = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "item_flg".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						itmFlag = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "dsp_date".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						dspDate = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					else if(childNode != null && "line_no__contr".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						lineNoCntr = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
					// Added by Sneha on 20-01-2017, to add discount field [Start]
					else if(childNode != null && "discount".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						discount = Double.parseDouble(childNode.getFirstChild().getNodeValue());
					}
					// Added by Sneha on 20-01-2017, to add discount field [End]
					else if(childNode != null && "item_ser".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						itemSer = checkNullAndTrim(childNode.getFirstChild().getNodeValue());
					}
				}
				 domID++;
				 
				 xmlStringDet.append("<Detail2 dbID=':' domID='"+ domID +"' objName='sorder' objContext='2'>");
				 xmlStringDet.append("<attribute pkNames='sale_order:line_no:' status='N' updateFlag='A' selected='N'/>");
                 
				 lineNoOrd = "   " + domID;
				 lineNoOrd = lineNoOrd.substring( lineNoOrd.length()-3 );
					
				 xmlStringHdr.append("<sale_order><![CDATA[").append(saleOrder).append("]]></sale_order>");
				 xmlStringDet.append("<line_no><![CDATA[").append(lineNoOrd).append("]]></line_no>");
				 xmlStringDet.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>");
				 xmlStringDet.append("<item_code__ord><![CDATA[").append(itemCode).append("]]></item_code__ord>");
				 xmlStringDet.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>");
				 xmlStringDet.append("<item_ser>").append("<![CDATA["+itemSer+"]]>").append("</item_ser>");
				 xmlStringDet.append("<site_code><![CDATA[").append(siteCodeOrd).append("]]></site_code>");
				 xmlStringDet.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>");
				 xmlStringDet.append("<quantity__stduom><![CDATA[").append(quantity).append("]]></quantity__stduom>");
				 xmlStringDet.append("<unit><![CDATA[").append(unit).append("]]></unit>");
				 xmlStringDet.append("<unit__std><![CDATA[").append(unit).append("]]></unit__std>");
				 xmlStringDet.append("<item_flg><![CDATA[").append(itmFlag).append("]]></item_flg>\r\n");
				 xmlStringDet.append("<rate><![CDATA[").append(rate).append("]]></rate>");
				 xmlStringDet.append("<discount><![CDATA[").append(discount).append("]]></discount>");	// Added by Sneha on 20-01-2017, to add discount field 
				 xmlStringDet.append("<rate__std><![CDATA[").append(rateStd).append("]]></rate__std>");

				 System.out.println("Rate Clg is Sorder PostSave="+rateClg);
				 if(rateClg <= 0 )
				 {
					rateClg = rate;
				 }
				 System.out.println("After rate CLg = "+rateClg);
				 xmlStringDet.append("<rate__clg><![CDATA[").append(rateClg).append("]]></rate__clg>");
				 xmlStringDet.append("<rate__stduom><![CDATA[").append(rate).append("]]></rate__stduom>");
				 xmlStringDet.append("<unit__rate><![CDATA[").append(unitRate).append("]]></unit__rate>");
				 xmlStringDet.append("<tax_chap><![CDATA[").append(taxChap).append("]]></tax_chap>");
				 xmlStringDet.append("<tax_class><![CDATA[").append(taxClass).append("]]></tax_class>");
				 xmlStringDet.append("<tax_env><![CDATA[").append(taxEnv).append("]]></tax_env>");
				 xmlStringDet.append("<conv__qty_stduom>").append("<![CDATA[" + 1 + "]]>").append("</conv__qty_stduom>");
				 xmlStringDet.append("<conv__rtuom_stduom>").append("<![CDATA[" + 1 + "]]>").append("</conv__rtuom_stduom>");
				 xmlStringDet.append("<dsp_date>").append("<![CDATA["+dspDate+"]]>").append("</dsp_date>");
				 xmlStringDet.append("<cust_spec__no>").append("<![CDATA["+lineNoCntr+"]]>").append("</cust_spec__no>");
				 
				 xmlStringDet.append("</Detail2>");
				
			}
			xmlStringHdr.append("</Detail1>");
			
			xmlString.append(xmlStringHdr);
			xmlString.append(xmlStringDet);
			xmlString.append("</Header0></group0></DocumentRoot>");
			
			System.out.println("@@xmlString For generation Sale Order:: "+xmlString.toString());
            masterStatefulLocal = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local"); 
            
            if(xtraParams == null)
            {
            	xtraParams = getXtraParams(userId,siteCodeOrd,userId,conn);
            }
            userInfo  = getUserInfo(xtraParams);

            retString = masterStatefulLocal.processRequest(userInfo, xmlString.toString(), true, conn); 
            
            System.out.println("Sale Order return string"+retString);
			
			if ( retString.indexOf("Success") > -1 && retString.indexOf("<TranID>") > 0 )
			{
			    String tranIDSorder = retString.substring( retString.indexOf("<TranID>")+8, retString.indexOf("</TranID>"));
				System.out.println("Sale Order Created :"+tranIDSorder);
				
				if("A".equalsIgnoreCase(status))
				{
					sql = "SELECT SALE_ORDER FROM SORDER_TEMP WHERE STATUS = ? AND EMP_CODE = ? AND SITE_CODE = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, status);
					pstmt.setString(2, empCodeOrd);		
					pstmt.setString(3, siteCodeOrd);
					rs = pstmt.executeQuery();
					if ( rs.next() )
					{
						sql = " UPDATE SORDDET_TEMP SET SALE_ORDER = ? WHERE SALE_ORDER = ? ";
						pstmtUpdate = conn.prepareStatement(sql);
						pstmtUpdate.setString(1, tranIDSorder);	
						pstmtUpdate.setString(2, checkNullAndTrim((rs.getString("SALE_ORDER"))));
						pstmtUpdate.executeUpdate();
						if( pstmtUpdate != null )
						{
							pstmtUpdate.close();pstmtUpdate = null;
						}
							
						sql = "UPDATE SORDER_TEMP SET STATUS = ?, SALE_ORDER = ? WHERE  SALE_ORDER = ?  ";
						pstmtUpdate = conn.prepareStatement(sql);
						pstmtUpdate.setString(1, "O");	
						pstmtUpdate.setString(2, tranIDSorder);	
						pstmtUpdate.setString(3, checkNullAndTrim(rs.getString("SALE_ORDER")));
						pstmtUpdate.executeUpdate();
						if( pstmtUpdate != null )
						{
							pstmtUpdate.close();pstmtUpdate = null;
						}
					}
					if( pstmt != null )
					{
						pstmt.close();pstmt = null;
					}
					if( rs != null )
					{
						rs.close();rs = null;
					}
				}

				if("E".equalsIgnoreCase(status))
				{
					sql = "UPDATE SORDER_TEMP SET STATUS = ? WHERE SALE_ORDER = ? ";
					pstmtUpdate = conn.prepareStatement(sql);
					pstmtUpdate.setString(1, "O");	
					pstmtUpdate.setString(2, tranIDSorder);	
					pstmtUpdate.executeUpdate();
					if( pstmtUpdate != null )
					{
						pstmtUpdate.close();pstmtUpdate = null;
					}
				}
				
			}
			else
			{
				System.out.println("Error while creating Sale Order");
				//throw new ITMException(retString);
				isError = true; 
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception inside SorderWizardPosEJB==>"+e.getMessage());
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError in Finally SorderWizardPosEJB ["+isError+"]");
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
				}
				if ( rs != null )
				{
					rs.close();rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("retString from post save SorderWizardPosEJB =["+retString+"]");
		return retString;
	}
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		String currAppdate = "";
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}
	
	private String getCurrdateAppFormat() 
	{
		String s = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(timestamp).toString();
		}
		catch (Exception localException)
		{
		}

		return s;
	}
	
	private InitialContext getInitialContext() throws ITMException 
	{
		InitialContext ctx = null;
		try 
		{
			System.out.println("getInitialContext");
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());

		}
		catch (ITMException itme)
		{
			System.out.println("ITMException :StatelessItemChangeServlet :getInitialContext :==>");
			throw itme;
		}
		catch (Exception e) 
		{
			System.out.println("Exception :StatelessItemChangeServlet :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}
	
	public String getUserInfo( String xtraParams )throws ITMException
	{
		StringBuffer userInfoStr = new StringBuffer();
		String userId = "";
		String loginEmpCode = "";
		String loginSiteCode = "";
		String entityCode = "";
		String profileId = "";
		String userType = "";
		
		String chgTerm = "";
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			entityCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode");
			profileId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"profileId");
			userType = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userType");
			
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");
			
			System.out.println("xtraParams  is @@@@@ " + xtraParams);

			userInfoStr.append("<UserInfo>");
			userInfoStr.append("<loginCode>").append("<![CDATA["+userId+"]]>").append("</loginCode>\r\n");
			userInfoStr.append("<empCode>").append("<![CDATA["+loginEmpCode+"]]>").append("</empCode>\r\n");
			userInfoStr.append("<siteCode>").append("<![CDATA["+loginSiteCode+"]]>").append("</siteCode>\r\n");
			userInfoStr.append("<entityCode>").append("<![CDATA["+entityCode+"]]>").append("</entityCode>\r\n");
			userInfoStr.append("<profileId>").append("<![CDATA["+profileId+"]]>").append("</profileId>\r\n");
			userInfoStr.append("<userType>").append("<![CDATA["+userType+"]]>").append("</userType>\r\n");
			
			userInfoStr.append("<remoteHost>").append("<![CDATA["+chgTerm+"]]>").append("</remoteHost>\r\n");
			userInfoStr.append("</UserInfo>");
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return userInfoStr.toString();
	}
	
	public String getXtraParams( String loginCode, String siteCode,String empCode,Connection  conn)throws Exception
	{
		String remotehost = "";
		String entityCode = "";
		String profileId = "";
		String userType = "";
		String userLang = "";
		String userCountry = "";	
		StringBuffer xtraParamsBuff = new StringBuffer();
		
		String sql = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
			
		
		try
		{
				sql = "SELECT USR_LEV,USER_TYPE,ENTITY_CODE,PROFILE_ID,LOGGER_TYPE,USER_LANG,"+
					  "USER_COUNTRY,TRANS_DB, USER_THEME FROM USERS WHERE CODE = ? ";
				pstmt = conn.prepareStatement(sql);			
				pstmt.setString(1,loginCode);			
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					entityCode = rs.getString("ENTITY_CODE");
					profileId  = rs.getString("PROFILE_ID");
					userType   = rs.getString("USER_TYPE");
					userLang   = rs.getString("USER_LANG");
					userCountry= rs.getString("USER_COUNTRY");
				}			
				
				remotehost =  InetAddress.getLocalHost().getHostAddress();
				String XTRA_PARAMS_SEPARATOR = "~~";
				
				xtraParamsBuff.append("loginCode=" + loginCode);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + empCode);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + siteCode);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + entityCode);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + profileId);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userType);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userLang);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userCountry);
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + CommonConstants.ENCODING);
				
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId="+remotehost);
		
				String chgTerm = remotehost;
				if( chgTerm != null && chgTerm.length() > 15 )
				{
					chgTerm = chgTerm.substring(0, 15);
				}
				else if( chgTerm == null || chgTerm.length() == 0 )
				{
					chgTerm = remotehost;
				}
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm );
				
				System.out.println("xtraParamsBuff ["+xtraParamsBuff+"]");
				
				
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return xtraParamsBuff.toString();
	}
}
