package ibase.client;



import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortEvent.ListHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.view.client.ListDataProvider;
import ibase.client.resources.Resources;

/**
 * This class is used to show the data in paged format.
 * 
 * @author base
 */

public class CellTableGridCreator 
{

	public CellTableGridCreator() {
		
		// TODO Auto-generated constructor stub
	}
	 ListDataProvider<CellTableGridInfo> dataProvider = new ListDataProvider<CellTableGridInfo>();
	
	
	@SuppressWarnings("unchecked")
	public ScrollPanel buildCustomGrid(final HashMap<String, HashMap> gridNGraphMeataDataMap,JSONObject jsonObjGridData)
	{
		ScrollPanel sp = new ScrollPanel();
		gridNGraphMeataDataMap.toString().replace('=', ':');
		HashMap<String, ArrayList<String>> graphDataMap = null;
		ArrayList<String> graphDtlList = null;
		LinkedHashMap<String, List<String>> gridIDMap = null;
		final LinkedHashMap<String, List<String>> gridNameMap = null;
		 LinkedHashMap<String, List<String>> gridNameMap1 = null;
		JSONObject tempObj= new JSONObject();
		ArrayList<String> paramDtlList = new ArrayList<String>();
		final CellTable<CellTableGridInfo> table = new CellTable<CellTableGridInfo>();
		List<CellTableGridInfo> CONTACTS = null;
		try
		{
			graphDataMap=gridNGraphMeataDataMap.get("grid");
			JSONObject jsonObjData =(JSONObject) jsonObjGridData.get("grid");
			//set data into list : list of class objects
			CellTableGridInfo cInfo = new CellTableGridInfo();
            CONTACTS = (cInfo.getDataInfo(gridNGraphMeataDataMap,jsonObjGridData));
			/******start of To create header with colspan********/    
			  for (String dataSource : gridNGraphMeataDataMap.keySet())
				{
				  if (dataSource == "grid")
					{
						gridIDMap = (LinkedHashMap<String, List<String>>) gridNGraphMeataDataMap.get(dataSource);
						tempObj=(JSONObject) jsonObjData.get(dataSource);
						
						/**start of  - To add header with colspan: first row of table**/
						table.addAttachHandler( new AttachEvent.Handler() 
					    {
							@Override
							public void onAttachOrDetach(AttachEvent event) 
							{
								LinkedHashMap<String, List<String>> gridNameMap = null;
								try 
								{		
									gridNameMap = (LinkedHashMap<String, List<String>>) gridNGraphMeataDataMap.get("columnName");
									Element elmnt = table.getElement();
									Element elementTr = DOM.createTHead();
									for (Map.Entry<String, List<String>> entry : gridNameMap.entrySet())
									{
										String key = entry.getKey();
										List<String> values = entry.getValue();
										Element elementTd=null;
										if(values.size()==1)
										{
											elementTd = DOM.createTH();
											elementTd.setAttribute( "colspan" , "1" );
											elementTd.setInnerText( "" );
										}
										if(values.size()>1)
										{
											elementTd = DOM.createTH();
											elementTd.setAttribute( "colspan" , ""+values.size() );
											elementTd.setAttribute("id","");
											elementTd.setInnerText( key );
										}
										elementTr.appendChild( elementTd );
									 }	
									elmnt.insertFirst( elementTr );
								}
								catch (Exception e) 
								{
									Window.alert( "Excpetion CellTableGridCreator:buildCustomGrid():for loop dataSource:["+e.getMessage()+"]" );
								}
							}
					    });
						/**End of  - To add header with colspan: first row of table**/
						
						/**start of  - To add header with colspan: second row of table**/						
						paramDtlList= 	cInfo.getClassParameters(gridNGraphMeataDataMap);
						Window.alert("paramDtlList:"+paramDtlList);
						cInfo.setCellTableColumn(paramDtlList,table);						
						/**end of  - To add header with colspan: second row of table**/
						
					}
				}
			  table.setStyleName("celDataCSS");		
			 // table.setWidth(Window.getClientWidth()+ "px" );
			  // Create a data provider.
			   final ListHandler<CellTableGridInfo> sortHandler = new ListHandler<CellTableGridInfo>( dataProvider.getList())
						{
							@Override
							public void onColumnSort(ColumnSortEvent event) {
								super.onColumnSort(event);
								dataProvider.refresh();
							}
						};
			 table.addColumnSortHandler(sortHandler);
			    // Connect the table to the data provider.
			   dataProvider.addDataDisplay(table);
			    // Add the data to the data provider, which automatically pushes it to the
			    // widget.			   
			    List<CellTableGridInfo> list = dataProvider.getList();
			    for (CellTableGridInfo contact : CONTACTS) {
			      list.add(contact);
			    }
				/******end of To create header with colspan********/    
			    sp.add(table);
			    sp.setStyleName("scrollCSS");
		}
		catch(Exception e)
		{
			Window.alert( "Excpetion CellTableGridCreator:buildCustomGrid():["+e.getMessage()+"]" );
		}
		return sp;
		
	}
	
	
}
