
package ibase.webitm.ejb.wms;
/*
 * Author:Wasim Ansari
 * Date:02-APR-15
 * Request ID:D15AKAT002 (PO Case Label Mobile Wizard)
 */
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.InvAllocTraceBean;
import ibase.webitm.ejb.dis.StockUpdate;
import ibase.webitm.reports.utility.XSDParser;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
@javax.ejb.Stateless
public class POCaseWizPos extends ValidatorEJB implements POCaseWizPosLocal, POCaseWizPosRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	boolean isError = false;
	String objName = "";
	String reportName ="";
	String emailID="";
	String cC = "";
	String mailSubject = "";
	String message = "message";
	
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	
	public String postSave( String domString, String tranId,String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		return "";
	}
	
	public String postSave(String domString, String tranId,String editFlag, String xtraParams, Connection conn ) throws ITMException
	{
		System.out.println("in post save of POCaseWizPos........................");		
		System.out.println("hdrDataDom------->>["+domString+"]");
		
		String loginEmpCode = "",userId = "",loginSite = "";
		
		String errString = "";
		Document dom = null;
		String purcOrder = "",itemCode = "",caseLable = "",quantity = "",barCode = "",suppCode = "";
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		
		loginEmpCode = checkNullAndTrim(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
		userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		loginSite = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode")));
		
		try
		{
			System.out.println("Inside Try Block in Post Save.....");
			
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			
			dom = genericUtility.parseString(domString);
			
			String printServiceName = "";// need to be taken from Detail1.
			printServiceName = checkNullAndTrim(( genericUtility.getColumnValue( "printer_name", dom )));
			System.out.println("Printer Name="+printServiceName);
			
			NodeList detail2NodeList = dom.getElementsByTagName("Detail2");
			int detail2NodeListlen = detail2NodeList.getLength();
			
			for(int ctrH = 0; ctrH < detail2NodeListlen ; ctrH++)
			{
				NodeList childNodeList = detail2NodeList.item(ctrH).getChildNodes();
				int detail2ListLen = childNodeList.getLength();
				
				for(int ctr = 0 ;ctr < detail2ListLen; ctr++)
				{
					Node childNode = childNodeList.item(ctr);
					
					if(childNode == null || childNode.getNodeType() != childNode.ELEMENT_NODE)
					{
						continue;
					}
					
					if(childNode != null && "order_no".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{	
						purcOrder = childNode.getFirstChild().getNodeValue();
						System.out.println("Purchase Order="+purcOrder);
					}
					else if(childNode != null && "item_code".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						itemCode = childNode.getFirstChild().getNodeValue();
						System.out.println("Item Code="+itemCode);
					}
					
					else if(childNode != null && "label_no".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{	
						caseLable = childNode.getFirstChild().getNodeValue();
						System.out.println("Case Label="+caseLable);
					}
					else if(childNode != null && "quantity".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null)
					{
						quantity = childNode.getFirstChild().getNodeValue();
						System.out.println("Quantity="+quantity);
					}
					
				}//end inner for loop
				
				
				//sql = "SELECT SUPP_CODE FROM SUPPLIERITEM WHERE ITEM_CODE = ?";
				sql = "SELECT SUPP_CODE FROM PORDER WHERE PURC_ORDER = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, purcOrder);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					suppCode = checkNullAndTrim(rs.getString("SUPP_CODE"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				System.out.println("Supplier Code="+suppCode);
				
				ibase.webitm.reports.utility.JasperReportGenerator jrGenerator = new ibase.webitm.reports.utility.JasperReportGenerator();
				String xsdString ="<Arguments>" +
						"<Argument id=\"arg1\" name=\"as_purc_order\">" +
						"<argType>java.lang.StringArray</argType>" +
						"<value>"+purcOrder+"</value>" +
						"</Argument>" +
						
						"<Argument id=\"arg1\" name=\"as_item_code\">" +
						"<argType>java.lang.StringArray</argType>" +
						"<value>"+itemCode+"</value>" +
						"</Argument>" +
						
						"<Argument id=\"arg1\" name=\"as_supp_code\">" +
						"<argType>java.lang.StringArray</argType>" +
						"<value>"+suppCode+"</value>" +
						"</Argument>" +
						
						"<Argument id=\"arg1\" name=\"as_user_id\">" +
						"<argType>java.lang.String</argType>" +
						"<value>"+userId+"</value>" +
						"</Argument>" +

						"<Argument id=\"arg1\" name=\"as_user_site\">" +
						"<argType>java.lang.String</argType>" +
						"<value>"+loginSite+"</value>" +
						"</Argument>" +
						
						"<Argument id=\"arg8\" name=\"x_path\">" +
						"<argType>java.lang.String</argType>" +
						"<value>/DocumentRoot/d_case_label_rep</value>" +
						"</Argument>" +
						
						"<Argument id=\"arg9\" name=\"design_source\">" +
						"<argType>java.lang.String</argType>" +
						"<value>d_case_label_rep.jrxml</value>" +
						"</Argument>" +
						
						"<Argument id=\"arg9\" name=\"data_source\">" +
						"<argType>java.lang.String</argType>" +
						"<value>SQL</value>" +
						"</Argument>" +
						
						"<Argument id=\"arg9\" name=\"bind_type\">" +
						"<argType>java.lang.Integer</argType>" +
						"<value>"+0+"</value>" +
						"</Argument>" +
						
						"<Argument id=\"arg7\" name=\"report_save_type\">" +
						"<argType>java.lang.String</argType>" +
						"<value>JASPER</value>" +
						"</Argument>" +
						
					"</Arguments>";
				
					System.out.println(" XSD parser **->["+xsdString+"]");
				
					String name = "d_case_label_rep";
					String outputFilename =  this.objName + loginSite + System.currentTimeMillis();
					XSDParser xsdParser = new XSDParser(this.objName);	
					TreeMap argMap = jrGenerator.createArgMap(xsdString);
					
					System.out.println("Last");
					
					jrGenerator.callRemotePrintServlet(name, xsdString, loginEmpCode, printServiceName, 1, conn);
					
			}//end outer for loop
			
			
		}//try block end
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
}

