package ibase.webitm.bean.wms;

import java.io.File;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.wms.ItemTypeWizEJBLocal;
import ibase.webitm.utility.ITMException;

import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;


public class ItemTypeWizBean 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang = "en"; 
	private String user_country = "US";
	
	public ItemTypeWizBean( String objName, HttpSession sessionCtx) throws ITMException 
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}
	
	public ItemTypeWizBean()
	{
		
	}
	
	public String getList( String loginCode, String field, String[] values ) throws ITMException
	{
		System.out.println("loginCode in getList =["+loginCode+"]");
		String itemTypeList = "";

		ItemTypeWizEJBLocal attribWizEJBLocal = null;

		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			attribWizEJBLocal = (ItemTypeWizEJBLocal)ctx.lookup("ibase/ItemTypeWizEJB/local");
			itemTypeList = attribWizEJBLocal.getList(loginCode, field, values);

			String xslFileName = getXSLFileName( "item_type_List_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );

			itemTypeList = (genericUtility).transformToString( xslFileName, itemTypeList, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( attribWizEJBLocal != null )
			{
				attribWizEJBLocal = null;
			}
		}
		return itemTypeList;
	}
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD" + File.separator + "Galaxy");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	public String previousForm( String formNo, String xmlData ) throws ITMException 
	{
		String retHtmlData = null;
		try
		{
			System.out.println("In Method : [previousForm]"+xmlData);
			String xslFileName = getXSLFileName( this.objName + formNo + "_wiz_" + this.user_lang + "_" + this.user_country + "_" + "A" + ".xsl" );
			retHtmlData = (genericUtility).transformToString( xslFileName, xmlData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			
		}
		return retHtmlData;
	}
}
