package ibase.webitm.ejb.dis;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.w3c.dom.Document;

@javax.ejb.Stateless
public class DistIssDelWizPostSave extends ValidatorEJB implements DistIssDelWizPostSaveLocal,DistIssDelWizPostSaveRemote{
	
	public String postSave(String xmlString,String editFlag,String tranId,  String xtraParams,Connection conn) throws RemoteException,ITMException
	{

		System.out.println(">>>>>>>>>>>>>>CONNECTION"+conn);
		System.out.println("------------ DisIssDelWizPostSave postSave method called-----------------tranId : "+ tranId);		
		Document dom = null;
		String errString="";

		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
				System.out.println("xmlString d" + xmlString);
			}
			
			tranId = GenericUtility.getInstance().getColumnValue("tran_id",dom);

			System.out.println("------------ DisIssDelWizPostSave postSave method called-----------------tranId from dom: "+ tranId);
			
			conn = null;
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver= null;
			errString = postSave(dom,tranId,editFlag,xtraParams,conn);


		}
		catch(Exception e)
		{
			System.out.println("Exception : DisIssDelWizPostSave : postSave : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}		
		return errString;
	}

	public String postSave(Document dom,String tranId,String editflag,String xtraParams,Connection conn)
	{
		System.out.println("post save dom data1 ---------------:"+dom);
		String sql = "", error = "";
		String lotSl="", chgTerm = "", chgUser = "";
		int cnt = 0;
		
		PreparedStatement pstmt = null;
		ResultSet rs=null;
		try
		{
			lotSl = GenericUtility.getInstance().getColumnValue("lot_sl",dom);
			chgTerm = GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			chgUser = GenericUtility.getInstance().getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			
			sql = "delete from distord_issdet where tran_id = ? and lot_sl = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			pstmt.setString(2, lotSl);
			cnt = pstmt.executeUpdate();
			if(pstmt != null){
				pstmt.close();
				pstmt = null;
			}
			System.out.println(">>>>>>>successfully deleted record DisIssDelWizPostSave cnt = :" + cnt);
			
			if(cnt > 0){
				sql = "update distord_iss set chg_date = sysdate, chg_user = ?, chg_term = ? where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, chgUser);
				pstmt.setString(2, chgTerm);
				pstmt.setString(3, tranId);
				cnt = pstmt.executeUpdate();
			}
			
			conn.commit();

		}catch(Exception e)
		{
			try {
				System.out.println(">>>>>>>>>>>>In catch Before rollback>>>");
				conn.rollback();
			} catch (SQLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
				error=e1.getMessage();
			}
			System.out.println("Exception ::"+e);
			e.printStackTrace();
			error=e.getMessage();

		}	
		finally
		{
			try {
				System.out.println(">>>>>>>>>>>>In finally Before Commit>>>");
				if(pstmt != null)
					pstmt.close();
				if(conn != null)
				{
					conn.close();	
				}

				if(rs != null)
					rs.close();

				pstmt = null;
				rs = null;
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				error=e.getMessage();
			}		
		}

		return error;

	}
}
