<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<link href="/ibase/webitm/css/theme/galaxy-theme.css" rel="stylesheet" />
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet" />
<link href="/ibase/webitm/css/Standard/default.css" rel="stylesheet" />
<script type="text/javascript" src="/ibase/webitm/js/packLabelWizard.js"></script>

<body onload="setUserTheme()">

	<form name="porderFinish" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">
			<table class="tableClass" id="Details1" border="0" cellspacing="1" cellpadding="1">
					<thead class="table-head" style="text-align:center;">
						<tr>
							<th class="thClass" nowrap="true" valign="bottom" >
								<strong>ASN Number</strong>
							</th>	
							<th class="thClass" nowrap="true" valign="bottom" >
								<strong>Contract Number</strong>
							</th>
							<th class="thClass" nowrap="true" valign="bottom" >
								<strong>Purchase Order</strong>
							</th>
							<th class="thClass" nowrap="true" valign="bottom" >
								<strong>Supplier Code</strong>
							</th>
							<th class="thClass" nowrap="true" valign="bottom" >
								<strong>Supplier Name</strong>
							</th>							
							<th class="thClass" nowrap="true" valign="bottom" >
								<strong>Shipment Date</strong>
							</th>							
						</tr>
					</thead>
					
					<tbody class="table-body"> 
						<xsl:for-each select="//finish">
							<xsl:variable name="asn_no"><xsl:value-of select="asn_no"/></xsl:variable>
							<xsl:variable name="contract_no"><xsl:value-of select="contract_no"/></xsl:variable>
							<xsl:variable name="purc_order"><xsl:value-of select="purc_order"/></xsl:variable>
							<xsl:variable name="supp_code"><xsl:value-of select="supp_code"/></xsl:variable>
							<xsl:variable name="supp_name"><xsl:value-of select="supp_name"/></xsl:variable>
							<xsl:variable name="ship_date"><xsl:value-of select="ship_date"/></xsl:variable>
														
							<tr style="text-align:center;">
								<td>
									<xsl:value-of select="asn_no"/>
								</td>
								<td>
									<xsl:value-of select="contract_no"/>
								</td>
								<td>
									<xsl:value-of select="purc_order"/>
								</td>
								<td>
									<xsl:value-of select="supp_code"/>
								</td>
								<td>
									<xsl:value-of select="supp_name"/>
								</td>	
								<td>
									<xsl:value-of select="ship_date"/>
								</td>	
							</tr>
						</xsl:for-each>
					</tbody>		
			</table>
				<table class="tableClass" id="Details2" border="0" cellspacing="1" cellpadding="1">
					<thead class="table-head" style="text-align:center;">
						<tr>
							<th class="thClass" nowrap="true" valign="bottom" >
								<strong>Item SKU Code</strong>
							</th>
							<th class="thClass" nowrap="true" valign="bottom" >
								<strong>Quantity</strong>
							</th>	
							
							<th class="thClass" nowrap="true" valign="bottom" >
								<strong>Mfg Date</strong>
							</th>
							
							<th class="thClass" nowrap="true" valign="bottom" >
								<strong>EXP Date</strong>
							</th>
							<th class="thClass" nowrap="true" valign="bottom" >
								<strong>Mfg Site</strong>
							</th>
							<th class="thClass" nowrap="true" valign="bottom" >
								<strong>Pack Size</strong>
							</th>
							
						</tr>
					</thead>
					
					<tbody class="table-body"> 
						<xsl:for-each select="//extra">
							<xsl:variable name="item_code"><xsl:value-of select="item_code"/></xsl:variable>
							<xsl:variable name="quantity"><xsl:value-of select="quantity"/></xsl:variable>
							<xsl:variable name="mfg_date"><xsl:value-of select="mfg_date"/></xsl:variable>
							<xsl:variable name="exp_date"><xsl:value-of select="exp_date"/></xsl:variable>
							<xsl:variable name="site_code__mfg"><xsl:value-of select="site_code__mfg"/></xsl:variable>
							<xsl:variable name="pack_size"><xsl:value-of select="pack_size"/></xsl:variable>
							
							<tr style="text-align:center;">
								<td>
									<xsl:value-of select="item_code"/>
								</td>
								<td>
									<xsl:value-of select="quantity"/>
								</td>	
								<td>
									<xsl:value-of select="mfg_date"/>
								</td>
								<td>
									<xsl:value-of select="exp_date"/>
								</td>
								<td>
									<xsl:value-of select="site_code__mfg"/>
								</td>
								<td>
									<xsl:value-of select="pack_size"/>
								</td>
								
							</tr>
						</xsl:for-each>
					</tbody>		
			</table>
			
					<table>
						<tr>
							<td colspan="2">
								<input type="button" style="cursor:hand" onclick="javascript:callForm1('packLabelWiz')" 
								class="button green-Btn pophelp-okcancel" value="Home" title='Home' />
							</td>
				        </tr>
				    </table>
	</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>

