package ibase.e12ria.e12widgets.client;

import java.util.Date;

import com.blogspot.ctasada.gwt.eureka.client.ui.SmallTimeBox;
import com.google.gwt.i18n.shared.DateTimeFormat;
import com.google.gwt.modernizr.client.Modernizr;
import com.google.gwt.modernizr.client.Modernizr.InputType;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SimplePanel;

public class E12TimeBox extends Composite
{
	private SimplePanel container = new SimplePanel();
	private SmallTimeBox smallTimeBox;
	private E12TextBox e12TimeTextBox;
	private double androidVersion = 1.0;
	
	private String standardPattern = "HH:mm:ss";
	private String amPmPattern = "hh:mm a";
	
	private String deviceOS;
	public E12TimeBox(Date date)
	{
		deviceOS = getDeviceOS();
		String deviceVersion;
		//Added by Prajyot On 28MAY2013 [For temporary : Time doesn't get save in JellyBean 4.1 Android Device ] Starts
		deviceVersion = Window.Navigator.getUserAgent();
		if( deviceVersion.indexOf("Android") != -1 )
		{
			deviceVersion = deviceVersion.substring( deviceVersion.indexOf("Android ") + "Android ".length() );
			deviceVersion = deviceVersion.substring(0, deviceVersion.indexOf(";") );
			deviceVersion = deviceVersion.substring(0, deviceVersion.lastIndexOf(".") );
			try{
				androidVersion = Double.parseDouble( deviceVersion );
			}
			catch(Exception e){
				androidVersion = 1.0;
			}
		}
		
		if( Modernizr.inputType(InputType.TIME) && androidVersion >= 4.4 )
		{
			e12TimeTextBox = new E12TextBox( "time" );
			container.add(e12TimeTextBox);
		}
		else if( Modernizr.inputType(InputType.TIME ) && "iOS".equalsIgnoreCase( deviceOS ) )
		{
			e12TimeTextBox = new E12TextBox( "time" );
			container.add(e12TimeTextBox);
		}
		else
		{
			smallTimeBox = new SmallTimeBox( date, true );
			container.add(smallTimeBox);
		}
		initWidget(container);
	}
	
	public String getTime()
	{
		String time = "";
		//Added by Prajyot [For temporary : Time doesn't get save in JellyBean 4.1 Android Device ] Starts
		if( Modernizr.inputType(InputType.TIME) && androidVersion >= 4.4 )
		{
			time = getValue();
		}
		else if( Modernizr.inputType(InputType.TIME) && "iOS".equalsIgnoreCase( deviceOS ) )
		{
			time = getValue();
		}
		else
		{
			time = smallTimeBox.getValueAsString();
		}
		return time;
	}
	
	public void setTime( String time )
	{
		 
		if( time == null || time.length() == 0 )
		{
			return;
		}
		
		//Added by Prajyot [For temporary : Time doesn't get save in JellyBean 4.1 Android Device ] Starts
		if( Modernizr.inputType(InputType.TIME) && androidVersion >= 4.4 )
		{
			setValue( time );
		}
		else if( Modernizr.inputType(InputType.TIME) && "iOS".equalsIgnoreCase( deviceOS ) )
		{
			setValue( time );
		}
		else
		{
			smallTimeBox.setValueAsString(time);
		}
	}
	
	public void setEnabled(boolean enabled) 
	{
		if( Modernizr.inputType(InputType.TIME) && androidVersion >= 4.4 )
		{
			e12TimeTextBox.setEnabled(enabled);
		}
		else if( Modernizr.inputType(InputType.TIME) && "iOS".equalsIgnoreCase( deviceOS ) )
		{
			e12TimeTextBox.setEnabled(enabled);
		}
		else
		{
			smallTimeBox.setEnabled(enabled);
		}
	}

	public void setReadOnly(boolean readOnly) 
	{
		if( Modernizr.inputType(InputType.TIME) && androidVersion >= 4.4 )
		{
			e12TimeTextBox.setReadOnly(readOnly);
		}
		else if( Modernizr.inputType(InputType.TIME) && "iOS".equalsIgnoreCase( deviceOS ) )
		{
			e12TimeTextBox.setReadOnly(readOnly);
		}
		else
		{
			smallTimeBox.setReadOnly(readOnly);
		}
	}
	
	//Commented and Added by Dnyaneshwar Chavan on 10-APR-14 [Resolved the issue of time value not set in TimeBox when system time between 12:00 to 1:00 ] Start
	/*private String formatTime(String value) 
	{
		if( value == null || "".equalsIgnoreCase( value ) )
		{
			return "00:00 AM";
		}
		
		Date timeValue = new Date();
		DateTimeFormat fmt = DateTimeFormat.getFormat("hh:mm a");
		String time[] = value.split(":");
		int hour = (int) Double.parseDouble(time[0]);
		int minutes = (int) Double.parseDouble(time[1]);;

		timeValue.setHours(hour);
		timeValue.setMinutes(minutes);

		return fmt.format(timeValue);
	}*/
	
	private void setValue( String time )
	{
		try
		{ 
			Date standerTime = DateTimeFormat.getFormat( amPmPattern ).parse(time);
			String formatTime = formatTime(standardPattern, standerTime);
			e12TimeTextBox.setValue(formatTime);
		}
		catch(Exception e)
		{
			Window.alert( "Exception: " + e.getMessage() );
		}
	}
	
	private String getValue()
	{
		//time = formatTime( e12TimeTextBox.getValue() );
		Date standerTime = DateTimeFormat.getFormat( standardPattern ).parse(e12TimeTextBox.getValue());
		return formatTime(amPmPattern, standerTime);
	}

	private String formatTime( String pattern, Date date )
	{
		DateTimeFormat dtf = DateTimeFormat.getFormat( pattern );
		return dtf.format( date );
	}
	
	private native String getDeviceOS( )
	/*-{
		var deviceOS = $doc.deviceOS;
		return deviceOS;
	}-*/;
	//Commented and Added by Dnyaneshwar Chavan on 10-APR-14 [Resolved the issue of time value not set in TimeBox when system time between 12:00 to 1:00 ] End
}
