/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import ibase.e12ria.client.E12CommonUtils;
import ibase.e12ria.client.E12Constants;
import ibase.e12ria.client.E12HeaderPanel;
import ibase.e12ria.e12widgets.client.E12ColorfulRadio;
import java.util.HashMap;

public class E12UserSetting {
    Label themeLabel;
    Label fullScreenLabel;
    HorizontalPanel themePanel;
    HorizontalPanel fullScreenPanel;
    boolean isThemeChanged = false;
    String selectedTheme;
    HashMap<String, E12ColorfulRadio> themeMap = new HashMap();
    Command closeCmd;

    public E12UserSetting() {
        this.initE12UserSetting();
    }

    public void initE12UserSetting() {
        this.themeLabel = new Label("Theme");
        this.themePanel = new HorizontalPanel();
        this.fullScreenLabel = new Label("FullScreen");
        this.fullScreenPanel = new HorizontalPanel();
        E12ColorfulRadio blueButton = new E12ColorfulRadio("blue");
        blueButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                E12UserSetting.this.selectedTheme = "blue";
                E12UserSetting.this.applySelectedTheme();
            }
        });
        E12ColorfulRadio grayButton = new E12ColorfulRadio("gray");
        grayButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                E12UserSetting.this.selectedTheme = "gray";
                E12UserSetting.this.applySelectedTheme();
            }
        });
        E12ColorfulRadio greenButton = new E12ColorfulRadio("green");
        greenButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                E12UserSetting.this.selectedTheme = "green";
                E12UserSetting.this.applySelectedTheme();
            }
        });
        E12ColorfulRadio orangeButton = new E12ColorfulRadio("orange");
        orangeButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                E12UserSetting.this.selectedTheme = "orange";
                E12UserSetting.this.applySelectedTheme();
            }
        });
        this.themePanel.add((Widget)blueButton);
        this.themeMap.put("blue", blueButton);
        this.themePanel.add((Widget)grayButton);
        this.themeMap.put("gray", grayButton);
        this.themePanel.add((Widget)orangeButton);
        this.themeMap.put("orange", orangeButton);
        this.themePanel.add((Widget)greenButton);
        this.themeMap.put("green", greenButton);
        this.fullScreenPanel.add((Widget)this.fullScreenLabel);
        this.fullScreenPanel.add((Widget)E12HeaderPanel.hideShowMenu);
    }

    public void clickOnUserSettings(final int xPosOfUserSetting, boolean isFullscreen) {
        E12CommonUtils.getInstance().setTranslucentClass(true);
        E12HeaderPanel.hideShowMenu.setValue(isFullscreen);
        final PopupPanel settingPopupPanel = new PopupPanel();
        settingPopupPanel.setStyleName("poupPanel");
        settingPopupPanel.getElement().getFirstChildElement().getStyle().setPaddingLeft(13.0, Style.Unit.PX);
        settingPopupPanel.setWidth("190px");
        settingPopupPanel.setAnimationEnabled(false);
        settingPopupPanel.setGlassEnabled(true);
        settingPopupPanel.setGlassStyleName("bgGlass");
        Label closeLbl = new Label("x");
        closeLbl.setStyleName("close");
        this.closeCmd = new Command(){

            public void execute() {
                E12CommonUtils.getInstance().setTranslucentClass(false);
                settingPopupPanel.hide();
            }
        };
        closeLbl.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                E12CommonUtils.getInstance().setTranslucentClass(false);
                E12UserSetting.this.closeCmd.execute();
            }
        });
        VerticalPanel welcomeVertPanel = new VerticalPanel();
        welcomeVertPanel.addStyleName("bubblebox");
        welcomeVertPanel.addStyleName("top");
        welcomeVertPanel.setSpacing(6);
        welcomeVertPanel.add((Widget)this.fullScreenPanel);
        welcomeVertPanel.add((Widget)this.themeLabel);
        welcomeVertPanel.add((Widget)this.themePanel);
        welcomeVertPanel.add((Widget)closeLbl);
        settingPopupPanel.add((Widget)welcomeVertPanel);
        settingPopupPanel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                int left = xPosOfUserSetting - offsetWidth + 27 + 25;
                settingPopupPanel.setPopupPosition(left, 38);
                E12CommonUtils.printOnConsole("E12Constants.userTheme in UserSettings : " + E12Constants.userTheme);
                try {
                    if (!E12UserSetting.this.isThemeChanged) {
                        DOM.getElementById((String)("radio-theme-" + E12Constants.userTheme)).setAttribute("checked", "true");
                    }
                }
                catch (Throwable t) {
                    E12CommonUtils.printOnConsole("Execption in UserSettings : " + t);
                }
            }
        });
    }

    private void applySelectedTheme() {
        this.isThemeChanged = true;
        this.themeMap.get(E12Constants.userTheme).setValue(Boolean.valueOf(false));
        this.themeMap.get(this.selectedTheme).setValue(Boolean.valueOf(true));
        Window.alert((String)(String.valueOf(this.selectedTheme) + " theme selected. Some of the component may take impact of theme in next login."));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ACTION", "SET_USER_THEME");
        paramMap.put("USER_ID", E12Constants.userID);
        paramMap.put("USER_THEME", this.selectedTheme);
        paramMap.put("dummyInt", "" + Math.random());
        String paramString = E12CommonUtils.getInstance().getEncodedParamString(paramMap);
        String url = "/ibase/WEBITMRIARequestHandlerServlet?" + paramString;
        RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.POST, url);
        try {
            requestBuilder.sendRequest(null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    E12UserSetting.this.isThemeChanged = true;
                    E12HeaderPanel.userImage.setStyleName(String.valueOf(E12HeaderPanel.userImageClass) + " theme-" + E12UserSetting.this.selectedTheme);
                    E12HeaderPanel.userSetting.setStyleName("header-userSetting theme-" + E12UserSetting.this.selectedTheme);
                    E12Constants.userTheme = E12UserSetting.this.selectedTheme;
                    E12CommonUtils.printOnConsole(" Set Theme :" + E12Constants.userTheme);
                }

                public void onError(Request request, Throwable exception) {
                    Window.alert((String)("onError - Error while setting User Theme : " + exception.getMessage()));
                }
            });
        }
        catch (RequestException ex) {
            Window.alert((String)("RequestException - Error while setting User Theme: " + ex.getMessage()));
        }
        this.closeCmd.execute();
    }
}

