package ibase.webitm.ejb.fin;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class MiscVchEmpIC extends ValidatorEJB implements MiscVchEmpICLocal,MiscVchEmpICRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance();
	
	public String wfValData(String xmlString, String xmlString1, String xmlString2,String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("------------ wfvalData method called-----------------");
		System.out.println("xmlString --->>>  [["+xmlString+"  ]]");
		System.out.println("xmlString1 --->>>  [["+xmlString1+"  ]]");
		System.out.println("xmlString2 --->>>  [["+xmlString2+"  ]]");
		System.out.println("editFlag --->>>  [["+editFlag+"  ]]");
		
		String errString = null;
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
			
		}
		catch(Exception e)
		{
			System.out.println("Exception : MiscVchEmpIC.java : wfValData(String xmlString) : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		
		return errString;
	} //end of wfValData 
	
	
	public String wfValData(Document dom, Document dom1, Document dom2,String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{		
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0;
		String childNodeName = null;
		String analCode = "",sundryCode = "",acctCodeAp="",cctrCodeAp="",siteCode="",currCode="",userId = "",sql="";
		String empCode="",cctrCode="",bankCode="",projCode="",taxClass="",taxChap="",taxEnv="",amount="",errCode="";
		String errString="",errorType="",SundryType="",tranDate="",dueDate="",payMode="",vouchType="",cctrCodeAdv="",acctCodeAdv="";
		Connection conn = null;
		PreparedStatement pstmt;		
		ResultSet rs=null;
		int cnt1=0,cnt=0;		
		int currentFormNo=0,miscCount=0;
		int childNodeListLength;
		java.util.Date tranDateL = null;
		ConnDriver connDriver = new ConnDriver();
		//ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		ArrayList <String> errList = new ArrayList<String>();
		ArrayList <String>errFields = new ArrayList <String> ();
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>"); 
		 ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		try
		{		
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			conn = connDriver.getConnectDB("DriverITM");			
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("user ID form XtraParam : "+userId +"Edit Flag -->>: "+editFlag);
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					System.out.println("Child name --->> "+childNodeName);				
					
					if(childNodeName.equalsIgnoreCase("tran_date"))
					{
						tranDate = checkNull(genericUtility.getColumnValue("tran_date",dom));
						System.out.println("tran_date--->["+tranDate+"]");
						
						if(tranDate.length() == 0){
						errCode = "VMTRNDNN"; 
						errList.add( errCode );
						errFields.add( childNodeName.toLowerCase() );	
						}
					}
					if(childNodeName.equalsIgnoreCase("due_date"))
					{
						dueDate = checkNull(genericUtility.getColumnValue("due_date",dom));
						System.out.println("due_date--->["+dueDate+"]");
						
						if(dueDate.length() == 0){
						errCode = "VMDUEDNN"; 
						errList.add( errCode );
						errFields.add( childNodeName.toLowerCase() );	
						}
					}
					
					if (childNodeName.equalsIgnoreCase("vouch_type"))
					{
						vouchType = checkNull(genericUtility.getColumnValue("vouch_type",dom));
						System.out.println("vouch_type--->["+vouchType+"]");
						if(vouchType.length() == 0){
						errCode = "VMVCHTNN"; 
						errList.add( errCode );
						errFields.add( childNodeName.toLowerCase() );		
						}
					}	
					//new add
					if(childNodeName.equalsIgnoreCase("tran_type"))
					{
						String tranType="";
						tranType = checkNull(genericUtility.getColumnValue("tran_type",dom));
						System.out.println("tran_type---->["+tranType+"]");
						if (tranType.length()==0)
						{
							errCode = "VMTRNTNN"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );						
							
						}
						else
						{								
							sql="select count(*) from gencodes where mod_name = ?  and fld_name = ?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1, "W_MISC_VCH_EMP");
							pstmt.setString(2, tranType);
							rs=pstmt.executeQuery();
							if(rs.next()){
								cnt1=rs.getInt(1);
							}
							if(rs!=null){
							rs.close();
							rs=null;
							}
							if(pstmt!=null){
							pstmt.close();
							pstmt=null;
							}
							System.out.println("tranType cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMTRTGEN"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}
							
						}
						
					}
					//new add end
					if (childNodeName.equalsIgnoreCase("anal_code"))
					{
						analCode = checkNull(genericUtility.getColumnValue("anal_code",dom));
						System.out.println("analCode--->["+analCode+"]");
						if (analCode.length() > 0 ){
						cnt1=getDBRowCount(conn,"Analysis","anal_code",analCode);	
						System.out.println("Anal code cnt1--->"+cnt1);	
						if(cnt1 == 0){
						errCode = "VMANALNF"; 
						errList.add( errCode );
						errFields.add( childNodeName.toLowerCase() );	
						}									
						}
					}	
					if (childNodeName.equalsIgnoreCase("acct_code__ap"))
					{
						acctCodeAp = checkNull(genericUtility.getColumnValue("acct_code__ap",dom));
						System.out.println("payable A/c-->["+acctCodeAp+"]");
						if (acctCodeAp.length()==0)
						{
							errCode = "VMPAYACNN"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
							cnt1=getDBRowCount(conn,"Accounts","ACCT_CODE",acctCodeAp);	
							System.out.println("Payable A/c code cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMPAYACNF"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}
							
						}
					}
					if (childNodeName.equalsIgnoreCase("cctr_code__ap"))
					{
						cctrCodeAp = genericUtility.getColumnValue("cctr_code__ap",dom);
						System.out.println("cctrCodeAp--->>["+cctrCodeAp+"]");
						if (cctrCodeAp !=null && cctrCodeAp.length() > 0)
						{
							cnt1=getDBRowCount(conn,"COSTCTR","CCTR_CODE",cctrCodeAp);	
							System.out.println("cctrCodeAp  code cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMCCTRNF"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}
						}
						
					}
					
					if (childNodeName.equalsIgnoreCase("site_code"))
					{
						siteCode = checkNull(genericUtility.getColumnValue("site_code",dom));
						System.out.println("siteCode---->["+siteCode+"]");
						if (siteCode.length()==0)
						{
							errCode = "VTSITENN"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );								
						}
						else
						{	
							cnt1=getDBRowCount(conn,"site","site_code",siteCode);	
							System.out.println("Site  code cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VTSITEND"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}else{
								if(tranDate.length() > 0){
								tranDateL=simpleDateFormatObj.parse(tranDate);
								String code = checkNull(this.nfCheckPeriod("FIN", tranDateL, siteCode));
								System.out.println("Period check111--->>["+code+"]");
								if(code.length() > 0){
									errCode = code; 
									errList.add( errCode );
									errFields.add( childNodeName.toLowerCase() );	
								}
								}
							}
							
						}
					
					}
					if(childNodeName.equalsIgnoreCase( "curr_code" ))
					{
						currCode = checkNull(genericUtility.getColumnValue("curr_code",dom));
						System.out.println("curr_code---->["+currCode+"]");
						if (currCode.length()==0)
						{
							errCode = "VMCURRCNN"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );						
							
						}
						else
						{	
							cnt1=getDBRowCount(conn,"Currency","CURR_CODE",currCode);	
							System.out.println("curr code cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMCURRCND"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}
							
						}
						
					}
					if( childNodeName.equalsIgnoreCase( "bank_code" ) )
					{ 
						bankCode = checkNull(genericUtility.getColumnValue("bank_code",dom));
						System.out.println("bank_code---->["+bankCode+"]");	
						if(bankCode.length() > 0){
				 		cnt1=getDBRowCount(conn,"Bank","bank_code",bankCode);	
						System.out.println("Bank code cnt1--->"+cnt1);	
						if(cnt1 == 0){
						errCode = "VMBNKND"; 
						errList.add( errCode );
						errFields.add( childNodeName.toLowerCase() );
						}						
						}
						
					}
					if( childNodeName.equalsIgnoreCase( "proj_code" ) )
					{ 
						projCode = checkNull(genericUtility.getColumnValue("proj_code",dom));
						System.out.println("projCode---->["+projCode+"]");
						if ( projCode.length() > 0 )
						{
							cnt1=getDBRowCount(conn,"Project","proj_Code",projCode);	
							System.out.println("projCode cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMPROJCND"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}								
						}
						
					}
					if( childNodeName.equalsIgnoreCase( "pay_mode" ) )
					{ 
						payMode = checkNull(genericUtility.getColumnValue("pay_mode",dom));
						System.out.println("payMode---->["+projCode+"]");
						if(payMode.length() == 0){
						errCode = "VMPAYMNN"; 
						errList.add( errCode );
						errFields.add( childNodeName.toLowerCase() );	
						}
						
					}
					if(childNodeName.equalsIgnoreCase( "tax_class" )) 
					{
						taxClass = checkNull(genericUtility.getColumnValue("tax_class",dom));
						System.out.println("tax_class---->["+taxClass+"]");
						if ( taxClass.length() > 0 )
						{	
							cnt1=getDBRowCount(conn,"TAXCLASS","tax_class",taxClass);	
							System.out.println("TAX_CLASS cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMTAXCLND"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}									
						}
						
					}
					if(childNodeName.equalsIgnoreCase( "tax_chap" ))
					{
						taxChap = checkNull(genericUtility.getColumnValue("tax_chap",dom));
						System.out.println("tax_chap---->["+taxChap+"]");
						if ( taxChap.length() > 0 )
						{	
							cnt1=getDBRowCount(conn,"TAXCHAP","tax_chap",taxChap);	
							System.out.println("tax_chap cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMTAXCPND"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}									
						}
						
					}
					if(childNodeName.equalsIgnoreCase( "tax_env" ))
					{
						taxEnv = checkNull(genericUtility.getColumnValue("tax_env",dom));
						System.out.println("tax_env---->["+taxEnv+"]");
						if ( taxEnv.length() > 0 )
						{										
							cnt1=getDBRowCount(conn,"TAXENV","tax_env",taxEnv);	
							System.out.println("tax_env cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMTAXENND"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}									
						}
						
					}
					
					if (childNodeName.equalsIgnoreCase("acct_code__adv"))
					{
						acctCodeAdv = checkNull(genericUtility.getColumnValue("acct_code__adv",dom));
						System.out.println("acct_code__adv A/c-->["+acctCodeAdv+"]");
						if (acctCodeAdv.length() > 0)
						{
							cnt1=getDBRowCount(conn,"Accounts","ACCT_CODE",acctCodeAdv);	
							System.out.println("acct_code__adv A/c code cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMACTADNF"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}
						}						
					}
					if (childNodeName.equalsIgnoreCase("cctr_code__adv"))
					{
						cctrCodeAdv = genericUtility.getColumnValue("cctr_code__adv",dom);
						//int cctrLen=cctrCodeAdv.length();
						System.out.println("cctr_code__adv--->>["+cctrCodeAdv+"]");
						if (cctrCodeAdv !=null && cctrCodeAdv.length() > 0)
						{
							cnt1=getDBRowCount(conn,"COSTCTR","CCTR_CODE",cctrCodeAdv);	
							System.out.println("cctr_code__adv  code cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMCTRADNF"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}
						}							
					}
					
					
					
				 } //end for loop  
				break;
				case 2 :
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equalsIgnoreCase("sundry_code"))
					{
						sundryCode = checkNull(genericUtility.getColumnValue("sundry_code",dom));
						SundryType = checkNull(genericUtility.getColumnValue("sundry_type",dom));
						System.out.println("sundryCode detail---->["+sundryCode+"]");
						System.out.println("sundry_type detail---->["+SundryType+"]");
						
						if (sundryCode.length()==0)
						{
							errCode = "VMSUNYCNN"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{		
							if("E".equalsIgnoreCase(SundryType)){
								cnt1=getDBRowCount(conn,"employee","emp_code",sundryCode);	
								System.out.println("employee DETAIL cnt1--->"+cnt1);	
							}															
							System.out.println("sundry_code DETAIL cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMSUNYCND"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}							
						}
					}
					
					if (childNodeName.equalsIgnoreCase("acct_code__adv"))
					{
						acctCodeAdv = checkNull(genericUtility.getColumnValue("acct_code__adv",dom));
						System.out.println("acct_code__adv Detail A/c-->["+acctCodeAdv+"]");
						
						if(acctCodeAdv.length() == 0){
							errCode = "VMADVENN"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}else{
							cnt1=getDBRowCount(conn,"Accounts","ACCT_CODE",acctCodeAdv);	
							System.out.println("acct_code__adv A/c code cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMACTADNF"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}
						}						
					}
					if (childNodeName.equalsIgnoreCase("cctr_code__adv"))
					{
						cctrCodeAdv = genericUtility.getColumnValue("cctr_code__adv",dom);
						System.out.println("cctr_code__adv--->>["+cctrCodeAdv+"]");
						if (cctrCodeAdv !=null && cctrCodeAdv.length() > 0)
						{
							cnt1=getDBRowCount(conn,"COSTCTR","CCTR_CODE",cctrCodeAdv);	
							System.out.println("cctr_code__adv  code cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMCTRADNF"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}
						}							
					}
					//--
					if(childNodeName.equalsIgnoreCase("acct_code"))
					{
						String acctCode="";
						acctCode = checkNull(genericUtility.getColumnValue("acct_code",dom));
						System.out.println("acctCode detail---->["+acctCode+"]");
						
						if (acctCode.length()==0)
						{
							errCode = "VMACTCNN"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{		
							cnt1=getDBRowCount(conn,"Accounts","ACCT_CODE",acctCode);	
							System.out.println("acctCode DETAIL cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMACTCNF"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}							
						}
					}	
					
					if(childNodeName.equalsIgnoreCase("cctr_code"))
					{
						cctrCode = genericUtility.getColumnValue("cctr_code",dom);
						System.out.println("cctrCode detail---->["+cctrCode+"]");						
						if(cctrCode.length() > 0){		
							cnt1=getDBRowCount(conn,"costctr","cctr_code",cctrCode);	
							System.out.println("cctrCode DETAIL cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMCCTRND"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}							
						}
					}	
					if(childNodeName.equalsIgnoreCase("amount"))
					{
						amount = checkNull(genericUtility.getColumnValue("amount",dom));
						System.out.println("Amount DETAIL --->["+amount+"]");
						if (amount.length()==0)
						{
							errCode = "VMAMTNN"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );
						}
					}	
					if(childNodeName.equalsIgnoreCase("tax_class"))
					{
						taxClass = checkNull(genericUtility.getColumnValue("tax_class",dom));
						System.out.println("tax_class---->["+taxClass+"]");
						if ( taxClass.length() > 0 )
						{	
							cnt1=getDBRowCount(conn,"TAXCLASS","tax_class",taxClass);	
							System.out.println("TAX_CLASS cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMTAXCLND"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}									
						}						
						
					}
					if(childNodeName.equalsIgnoreCase("tax_chap"))
					{
						taxChap = checkNull(genericUtility.getColumnValue("tax_chap",dom));
						System.out.println("tax_chap---->["+taxChap+"]");
						if ( taxChap.length() > 0 )
						{	
							cnt1=getDBRowCount(conn,"TAXCHAP","tax_chap",taxChap);	
							System.out.println("tax_chap cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMTAXCPND"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}									
						}
					}
					if(childNodeName.equalsIgnoreCase("tax_env"))
					{
						taxEnv = checkNull(genericUtility.getColumnValue("tax_env",dom));
						System.out.println("tax_env---->["+taxEnv+"]");
						if ( taxEnv.length() > 0 )
						{										
							cnt1=getDBRowCount(conn,"TAXENV","tax_env",taxEnv);	
							System.out.println("tax_env cnt1--->"+cnt1);	
							if(cnt1 == 0){
							errCode = "VMTAXENND"; 
							errList.add( errCode );
							errFields.add( childNodeName.toLowerCase() );	
							}									
						}
					}
					
					
				
				}
				break;
											
			} //end switch
			
			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = errList.get(cnt);
					errFldName = errFields.get(cnt);
					System.out.println("errCode .........."+errCode);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn, errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}	
			
		} //end try
		catch (SQLException se) {
			System.out.println("SQLException ::"+se);
			se.printStackTrace();
            throw new ITMException(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
            throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
				if(connDriver!=null){
					connDriver = null;
				}	
				if(rs !=null)
				{
					rs.close();
					rs=null;
				}				
				
			}
			catch(Exception d)
			{
			  d.printStackTrace();
			}
		}
		
		System.out.println("ErrString ::[ "+errStringXml.toString()+" ]");
		return errStringXml.toString();
		
	}
		
		
	public String itemChanged(String xmlString,String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("------------------ itemChanged called------------------");
		System.out.println("xmlString DOM-->>["+xmlString+"]");
		System.out.println("xmlString DOM1-->>["+xmlString1+"]");
		System.out.println("xmlString DOM2-->>["+xmlString2+"]");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{   
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [MiscVchEmpIC ][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
		return valueXmlString;
	}
	
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{		
		System.out.println("@@@@@@@ itemChanged called");
		StringBuffer valueXmlString = new StringBuffer();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		String sundryCode = "",suppName="",acctCodeAp="",acctCodeApDesc="",cctrCodeAp="",cctrCodeApDesc="",actCodeDesc="";
		String empCode = "",siteCode="",siteDesc="",currCode="",exchngRate="",sundryType="";
		String empFname = "",empMname="",deptCode="",cctrCode="",costctrDescr="",acctCode="",acctCodeDescr="";
		String empLname = "",taxClass="",taxChap="",taxEnv="",accountCode="",analCode="",finEntity="",bankCode="";
		String itemDescr = "";
		int currentFormNo =0;
		String columnValue = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr = 0;
		Double dexchngRate = 0.0; 
		try
		{
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);
			connDriver=null;
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext.trim());
			}
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			System.out.println("-------- currentFormNo : "+currentFormNo);
			
			switch(currentFormNo)
			{	
				case 1 :
				valueXmlString.append("<Detail1>");				
				System.out.println("[" + currentColumn + "] ==> '" + columnValue + "'");
				System.out.println("editFlag =>" +editFlag);
				
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{					
					System.out.println("------------in itm_default--------->");
					String confirm="N",loginSite="",siteDescr1="",code="",sundryTypeL="E",vouchType="E",autoPay="Y";
					Calendar currentDate = Calendar.getInstance();					
					String tranDate = simpleDateFormatObj.format(currentDate.getTime());						 
					valueXmlString.append("<tran_date>").append("<![CDATA[" + tranDate + "]]>").append("</tran_date>");
					valueXmlString.append("<confirmed>").append("<![CDATA[" + confirm + "]]>").append("</confirmed>");
									 
					loginSite = checkNull(getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));					
					System.out.println("loginSite ----->>["+loginSite+"]");
					if(loginSite.length() > 0){
					siteDescr1=getColumnDescr(conn, "DESCR", "site", "SITE_CODE", loginSite);					
					}
					System.out.println("loginSite-->["+loginSite.length()+"]");
					System.out.println("tranDate-->["+tranDate.length()+"]");
					if(loginSite.length() > 0 && tranDate.length() > 0){
					code=getCurrCodeExchRate(conn, loginSite, tranDate);
					System.out.println("code--->["+code+"]");
					String [] codeSplit =code.split(",");
					currCode=codeSplit[0];
					exchngRate=codeSplit[1];
					
					bankCode=checkNull(getColumnDescr(conn, "bank_code", "site", "SITE_CODE", loginSite));
					System.out.println("Bank code--->["+bankCode+"]"); 
					}
					
					valueXmlString.append("<site_code>").append("<![CDATA[" + loginSite + "]]>").append("</site_code>");
					valueXmlString.append("<site_descr>").append("<![CDATA[" + siteDescr1 + "]]>").append("</site_descr>");
					valueXmlString.append("<curr_code>").append("<![CDATA[" + currCode + "]]>").append("</curr_code>");
					valueXmlString.append("<exch_rate>").append("<![CDATA[" + exchngRate + "]]>").append("</exch_rate>");
					valueXmlString.append("<bank_code>").append("<![CDATA[" + bankCode + "]]>").append("</bank_code>");
					valueXmlString.append("<due_date>").append("<![CDATA[" + tranDate + "]]>").append("</due_date>");
					
					valueXmlString.append("<vouch_type>").append("<![CDATA[" + vouchType + "]]>").append("</vouch_type>");
					valueXmlString.append("<sundry_type>").append("<![CDATA["+sundryTypeL+"]]>").append("</sundry_type>");
					valueXmlString.append("<auto_pay>").append("<![CDATA["+autoPay+"]]>").append("</auto_pay>");
				}			
									
				if((currentColumn.trim().equalsIgnoreCase("acct_code__ap")))
				{
					acctCodeAp = checkNull(genericUtility.getColumnValue("acct_code__ap",dom));
					System.out.println("payable A/c-->["+acctCodeAp+"]");
					acctCodeApDesc= getColumnDescr(conn, "sh_descr", "accounts", "acct_code", acctCodeAp);
					valueXmlString.append("<sh_descr>").append("<![CDATA[" + acctCodeApDesc + "]]>").append("</sh_descr>");
				}	
				
				else if (currentColumn.trim().equalsIgnoreCase("site_code"))
				{
					String siteDescr1="",code="",tranDate="";
					siteCode = checkNull(genericUtility.getColumnValue("site_code",dom));
					tranDate =checkNull(genericUtility.getColumnValue("tran_date",dom));
					System.out.println("siteCode11 ----->>["+siteCode+"]");
					System.out.println("tranDate ----->>["+tranDate+"]");
					if(siteCode.length() > 0){
					siteDescr1=getColumnDescr(conn, "DESCR", "site", "SITE_CODE", siteCode);
					}
					
					if(siteCode.length() > 0 && tranDate.length() > 0){
					code=getCurrCodeExchRate(conn, siteCode, tranDate);
					System.out.println("code123--->["+code+"]");
					String [] codeSplit =code.split(",");
					currCode=codeSplit[0];
					exchngRate=codeSplit[1];
					
					bankCode=checkNull(getColumnDescr(conn, "bank_code", "site", "SITE_CODE", siteCode));
					System.out.println("Bank code--->["+bankCode+"]");
					}
					
					valueXmlString.append("<site_descr>").append("<![CDATA[" + siteDescr1 + "]]>").append("</site_descr>");
					valueXmlString.append("<curr_code>").append("<![CDATA[" + currCode + "]]>").append("</curr_code>");
					valueXmlString.append("<exch_rate>").append("<![CDATA[" + exchngRate + "]]>").append("</exch_rate>");
					valueXmlString.append("<bank_code>").append("<![CDATA[" + bankCode + "]]>").append("</bank_code>");
					
				}
				else if (currentColumn.trim().equalsIgnoreCase("cctr_code__ap"))
				{
					cctrCodeAp = checkNull(genericUtility.getColumnValue("cctr_code__ap",dom));
					System.out.println("payable Cctr-->["+cctrCodeAp+"]");
					cctrCodeApDesc= getColumnDescr(conn, "sh_descr", "costctr", "cctr_code", cctrCodeAp);
					valueXmlString.append("<costctr_descr>").append("<![CDATA[" + cctrCodeApDesc + "]]>").append("</costctr_descr>");
					
				}
				else if (currentColumn.trim().equalsIgnoreCase("curr_code"))
				{
					String tranDateL="",netAmtS="";
					double netAmtBc=0,totalAmtBc=0;
					currCode = checkNull(genericUtility.getColumnValue("curr_code",dom));
					tranDateL =checkNull(genericUtility.getColumnValue("tran_date",dom));
					siteCode = checkNull(genericUtility.getColumnValue("site_code",dom));
					netAmtS = checkNull(genericUtility.getColumnValue("net_amt",dom));
					System.out.println("currCode -->["+currCode+"]");
					System.out.println("tranDateL -->["+tranDateL+"]");
					System.out.println("siteCode -->["+siteCode+"]");
					System.out.println("netAmtS -->["+netAmtS+"]");
					FinCommon fincmm= new FinCommon();
					if(siteCode.length() > 0 && tranDateL.length() > 0){
					dexchngRate=fincmm.getDailyExchRateSellBuy(currCode,"",siteCode,tranDateL,"B",conn);					
					}
					System.out.println("dexchngRate in curr_code1---->["+dexchngRate+"]");
					if(netAmtS.length() > 0 && dexchngRate > 0){
						netAmtBc=(Double.parseDouble(netAmtS)) * dexchngRate;	
						totalAmtBc=(Double.parseDouble(netAmtS)) * dexchngRate;
					}
					valueXmlString.append("<exch_rate>").append("<![CDATA[" + dexchngRate + "]]>").append("</exch_rate>");
					valueXmlString.append("<net_amt__bc>").append("<![CDATA[" + netAmtBc + "]]>").append("</net_amt__bc>");
					valueXmlString.append("<total_amount__bc>").append("<![CDATA[" + totalAmtBc + "]]>").append("</total_amount__bc>");
					
					
				}
				    valueXmlString.append("</Detail1>");
				  break;
				case 2:
					parentNodeList = dom.getElementsByTagName("Detail2");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					valueXmlString.append("<Detail2>");
					int childListLength = childNodeList.getLength();	
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
					{
						String sundryTypeL="",acctCodeAdvL="",cctrCodeAdvL="";
						System.out.println("detail itm default called................");
						sundryType = checkNull(genericUtility.getColumnValue("sundry_type",dom1));
						acctCodeAdvL = checkNull(genericUtility.getColumnValue("acct_code__adv",dom1));
						cctrCodeAdvL = genericUtility.getColumnValue("cctr_code__adv",dom1);		
						System.out.println("sundryType--->["+sundryType+"]");
						System.out.println("acctCodeAdvL--->["+acctCodeAdvL+"]");
						System.out.println("cctrCodeAdvL--->["+cctrCodeAdvL+"]");
						
						if(sundryType.length() > 0){
							valueXmlString.append("<sundry_type>").append("<![CDATA[" + sundryType + "]]>").append("</sundry_type>");
						}
						if(acctCodeAdvL.length() > 0){
							valueXmlString.append("<acct_code__adv>").append("<![CDATA[" + acctCodeAdvL + "]]>").append("</acct_code__adv>");
							acctCodeApDesc= getColumnDescr(conn, "sh_descr", "accounts", "acct_code", acctCodeAdvL);
							
						}
						if(cctrCodeAdvL !=null && cctrCodeAdvL.length() > 0){
							valueXmlString.append("<cctr_code__adv>").append("<![CDATA[" + cctrCodeAdvL + "]]>").append("</cctr_code__adv>");
							cctrCodeApDesc= checkNull(getColumnDescr(conn, "sh_descr", "costctr", "cctr_code", cctrCodeAdvL));
						}
						valueXmlString.append("<accounts_descr>").append("<![CDATA[" + acctCodeApDesc + "]]>").append("</accounts_descr>");
						valueXmlString.append("<costctr_descr>").append("<![CDATA[" + cctrCodeApDesc + "]]>").append("</costctr_descr>");
						System.out.println("sundry_type A/c itm D-->["+sundryType+"]");
					}
					
					
					if (currentColumn.trim().equals("acct_code__adv"))
					{
						acctCodeAp = checkNull(genericUtility.getColumnValue("acct_code__adv",dom));
						System.out.println("acct_code__adv A/c-->["+acctCodeAp+"]");
						acctCodeApDesc= checkNull(getColumnDescr(conn, "sh_descr", "accounts", "acct_code", acctCodeAp));						
						valueXmlString.append("<accounts_descr>").append("<![CDATA[" + acctCodeApDesc + "]]>").append("</accounts_descr>");
					}
					
					else if (currentColumn.trim().equals("cctr_code__adv")) 
					{
						cctrCode = genericUtility.getColumnValue("cctr_code__adv",dom);
						System.out.println("cctr_code__adv A/c-->["+cctrCode+"]");
						cctrCodeApDesc= getColumnDescr(conn, "sh_descr", "costctr", "cctr_code", cctrCode);
						valueXmlString.append("<costctr_descr>").append("<![CDATA[" + cctrCodeApDesc + "]]>").append("</costctr_descr>");
					}					
					else if (currentColumn.trim().equals("sundry_code"))
					{
						String sql="",empFName="",empMName="",empLName="",deptCodeL="";
						sundryCode = checkNull(genericUtility.getColumnValue("sundry_code",dom));
						System.out.println("sundry_code A/c-->["+sundryCode+"]");
						if(sundryCode.length() > 0){
						sql="select emp_fname,emp_mname,emp_lname,dept_code from  Employee"
								+ " where emp_code = ?  ";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1, sundryCode);
						rs=pstmt.executeQuery();
						if(rs.next()){
						empFName=checkNull(rs.getString(1));
						empMName=checkNull(rs.getString(2));
						empLName=checkNull(rs.getString(3));
						deptCodeL=checkNull(rs.getString(4));
						}
						if(rs!=null){
						rs.close();
						rs=null;
						}
						if(pstmt!=null){
						pstmt.close();
						pstmt=null;
						}					
						}
						System.out.println("Employee Descr-->>["+empFName+" "+empMName+" "+empLName+ "]");
						valueXmlString.append("<emp_code>").append("<![CDATA[" + sundryCode + "]]>").append("</emp_code>");
						valueXmlString.append("<emp_fname>").append("<![CDATA[" + empFName + "]]>").append("</emp_fname>");
						valueXmlString.append("<emp_mname>").append("<![CDATA[" + empMName + "]]>").append("</emp_mname>");
						valueXmlString.append("<emp_lname>").append("<![CDATA[" + empLName + "]]>").append("</emp_lname>");
						valueXmlString.append("<dept_code>").append("<![CDATA[" + deptCodeL + "]]>").append("</dept_code>");
					}
					
					valueXmlString.append("</Detail2>");
				}// end switch 
			valueXmlString.append("</Root>");			
			
			
		} //end try-------------------------------------------------------------
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+e.getMessage());			
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
					conn = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}				
			}
			catch(Exception d)
			{
			  d.printStackTrace();
			}			
		}
		
		return valueXmlString.toString();
	}
	private String getCurrCodeExchRate(Connection conn,String siteCode,String tranDate)
	{
		System.out.println("In getBankCodeExchRate method site code--->["+siteCode+"]");
		ResultSet rs=null;
		PreparedStatement pstmt=null;
		String sql="",currCode="",finEntity="",exchngRate="";
		double dexchngRate=0.0;
		try{
			sql="SELECT B.CURR_CODE,A.FIN_ENTITY FROM SITE A, FINENT B WHERE A.FIN_ENTITY = B.FIN_ENTITY"
					+ "  AND A.SITE_CODE = ?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, siteCode);
			rs=pstmt.executeQuery();
			if(rs.next()){
			currCode=checkNull(rs.getString(1));
			finEntity=checkNull(rs.getString(2));
			}
			System.out.println("currCode1-->["+currCode+"] finEntity2-->["+finEntity+"]");
			if(rs!=null){
			rs.close();
			rs=null;
			}
			if(pstmt!=null){
			pstmt.close();
			pstmt=null;
			}
			FinCommon fincmm= new FinCommon();
			dexchngRate=fincmm.getDailyExchRateSellBuy(currCode,"",siteCode,tranDate,"B",conn);
			System.out.println("After return rate from fincommon--->>["+dexchngRate+"]");
			exchngRate= checkNull(Double.toString(dexchngRate));
		}
		catch(Exception e){
			System.out.println("Exception : getBankCodeExchRate...");
			e.printStackTrace();
		}
		if(exchngRate.length() == 0){
			exchngRate= " ";
		}
		if(currCode.length() == 0){
			currCode= " ";
		}
		System.out.println("Return String from getBankCodeExchRate --->>["+exchngRate+","+currCode+"]");
		return currCode+","+exchngRate;
	}
	protected int getDBRowCount(Connection conn, String table_name, String whrCondCol, String whrCondVal)
	{
			int count=-1;
			
			if(conn!=null){
				
				ResultSet rs=null;
				PreparedStatement pstmt = null;
				
				String sql="select count(1) from "+table_name+" where "+whrCondCol+" = ?";
				System.out.println("SQL in getDBRowCount method : "+sql);
				try
				{
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,whrCondVal);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);
					}
				}
				catch(SQLException e)
				{
					System.out.println("SQL Exception In getDBRowCount method of MiscVchEmpIC Class : "+e.getMessage());
					e.printStackTrace();
				}
				catch(Exception ex)
				{
					System.out.println("Exception In getDBRowCount method of MiscVchEmpIC Class : "+ex.getMessage());
					ex.printStackTrace();
				}finally{
					
					try{
						
						if(pstmt!=null){
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null){
							rs.close();
							rs = null;
						}
					}catch (SQLException se) {
						se.printStackTrace();
					}
				}
			}else{
				try {
					throw new SQLException("Connection passed to MiscVchEmpIC.getDBRowCount() method ");
				} catch (SQLException e) {
					e.printStackTrace();					
				}
			}
				
		return count;
	}	

	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, checkNull(errorCode));			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	public String checkNull(String input)	
	{
		if (input == null)
		{
			input="";
		}
		return input.trim();
	}
	
	
	protected String getNameOrDescrForCode(Connection conn, String table_name, String descr_col_name,String whrCondCol, String whrCondVal)
	{
			String descr = null;
			
			if(conn!=null){
				
				ResultSet rs=null;
				PreparedStatement pstmt = null;
				
				String sql="SELECT "+descr_col_name+" FROM "+table_name+" WHERE "+whrCondCol+" = ?";
				
				System.out.println("SQL in getNameOrDescrForCode method : "+sql);
				try
				{
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,whrCondVal);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						descr = rs.getString(descr_col_name);
					}
					
					descr=descr==null ?"" :descr;
				}
				catch(SQLException e)
				{
					System.out.println("SQL Exception In getNameOrDescrForCode method of MiscVchEmpIC Class : "+e.getMessage());
					e.printStackTrace();
				}
				catch(Exception ex)
				{
					System.out.println("Exception In getNameOrDescrForCode method of MiscVchEmpIC Class : "+ex.getMessage());
					ex.printStackTrace();
				}finally{
					
					try{
						
						if(pstmt!=null){
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null){
							rs.close();
							rs = null;
						}
					}catch (SQLException se) {
						se.printStackTrace();
					}
				}
			}else{
				try {
					throw new SQLException("Connection passed to MiscVchEmpIC.getNameOrDescrForCode() method is null");
				} catch (SQLException e) {
					e.printStackTrace();
				}
			}
				
		return descr;
	}

	public String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value) 
	{

			PreparedStatement pstmt = null ;
			ResultSet rs = null ; 
			String sql = "";
			String findValue = "";
			try
			{			
				sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,value);
				rs = pstmt.executeQuery();
				if(rs.next())
				{					
					findValue = rs.getString(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;	        
			}
			catch(Exception e)
			{
				System.out.println("Exception in getColumnDescr ");
				e.printStackTrace();
			}
			System.out.println("returning String from getColumnDescr " + findValue);
			return findValue;
		 
	}
	
	

}

