/********************************************************
	Title : PhysicalCountProcess[D14DSUN018]
	Date  : 22/07/14
	Developer: Chandrashekar

 ********************************************************/
package ibase.webitm.utility.wms;
import ibase.webitm.utility.*;
import ibase.webitm.ejb.*;
import ibase.system.config.*;
import java.rmi.RemoteException;
import java.sql.*;
import org.w3c.dom.*;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3
public class PhysicalCountProcess extends ProcessEJB implements PhysicalCountProcessLocal,PhysicalCountProcessRemote
{	
String loginSiteCode = null;
String loginEmpCode = null;
GenericUtility genericUtility = GenericUtility.getInstance();
String currDateTs = null;
String chgUser = "";
String chgTerm = ""; 
ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
public String process(String xmlString, String xmlString2, String windowName, String xtraParams)
	throws RemoteException,ITMException
{
	Document detailDom = null;
	Document headerDom = null;
	String retStr = "";
	System.out.println("Process method called......");
	try
	{	
		if(xmlString != null && xmlString.trim().length()!=0)
		{
			headerDom = genericUtility.parseString(xmlString); 
			System.out.println("headerDom" + headerDom);
		}
		if(xmlString2 != null && xmlString2.trim().length()!=0)
		{
			detailDom = genericUtility.parseString(xmlString2); 
			System.out.println("detailDom" + detailDom);
		}
		retStr = process(headerDom, detailDom, windowName, xtraParams);
	}
	catch (Exception e)
	{			
		System.out.println("Exception :PhysicalCountProcess :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
		e.printStackTrace();
		throw new ITMException(e);
	}
	return retStr;
}//END OF PROCESS (1)

public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
{
	Connection conn = null;	
	String resultString = "", errString = "";
	boolean isError = false;
	PreparedStatement pstmt = null;	
	ResultSet rs = null;
	ibase.utility.UserInfoBean userInfo = null;
	
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();	
	String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
	loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
	loginEmpCode =  checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
	System.out.println("loginSiteCode["+loginSiteCode+"]"+"loginEmpCode["+loginEmpCode+"]");

	try
	{
		ConnDriver connDriver = new ConnDriver();			
		conn = connDriver.getConnectDB("DriverITM");			
		connDriver = null;
		conn.setAutoCommit(false);	
		
		PhysicalCountSchedule phycntprc = new PhysicalCountSchedule();		
		resultString = phycntprc.insertSchedule(loginSiteCode, loginEmpCode,userInfo);
	} // end of try code 
   	catch(Exception e)
	{
		isError = true;
		e.printStackTrace();
		errString = e.getMessage();
		throw  new ITMException(e);
	}		
	finally
	{
		try
		{
			if(rs != null)rs.close();
			rs = null;
			if(pstmt != null)pstmt.close();
			pstmt = null;				
			if(conn != null)
			{	System.out.println("isError["+isError+"]");
				//if(isError)
				if(resultString.indexOf("PROCSUCC") > -1)
				{	
					conn.commit();
					System.out.println("commiting connection.............");
					/*if(errString.equals(""))
					{
						errString = "PROCSUCC";
					}*/
					resultString = itmDBAccessEJB.getErrorString("","PROCSUCC",userId);
				}	
				else if(resultString.indexOf("VTWRKCAL") > -1)
				{
					conn.rollback();
					System.out.println("connection rollback.............");
					resultString = itmDBAccessEJB.getErrorString("","VTWRKCAL",userId);
					
				}	
				else if(resultString.indexOf("VTNORECARD") > -1)
				{
					conn.rollback();
					System.out.println("connection rollback.............");
					resultString = itmDBAccessEJB.getErrorString("","VTNORECARD",userId);
				}
				else
				{
					conn.rollback();
					System.out.println("connection rollback.............");
					resultString = itmDBAccessEJB.getErrorString("","VTRECDINS",userId);
				}
				conn.close();
				conn = null;	
			}
		}
		catch(SQLException sqle)
		{
			sqle.printStackTrace();
		}
	}	
	System.out.println("returning from     "+resultString);
	return resultString;
	} //end process
private String checkNull(String input)
{
	if(input == null)
	{
		input = "";
	}
	return input;
}

}

 