
package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import javax.ejb.Stateless; // added for ejb3
import ibase.webitm.ejb.ITMDBAccessEJB;


@Stateless // added for ejb3
public class SiteStrgCustomer extends ValidatorEJB implements SiteStrgCustomerLocal,SiteStrgCustomerRemote
{
		GenericUtility genericUtility = GenericUtility.getInstance(); 
		public String wfValData(String xmlString, String xmlString1, String xmlString2,String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
		{
			System.out.println("hello wfvalData");
			String errString = null;
			Document dom = null;
			Document dom1 = null;
			Document dom2 = null;
			try
			{
				dom = parseString(xmlString);
				dom1 = parseString(xmlString1);
				dom2 = parseString(xmlString2);
				System.out.println("@@@@@@@@  wfValData called");
				errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
				
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
			
			return (errString);
		}
		
		public String wfValData(Document dom, Document dom1, Document dom2,String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
		{
			NodeList parentNodeList = null;
			NodeList childNodeList = null;
			Node parentNode = null;
			Node childNode = null;
			int ctr=0;
			String childNodeName = null;
			String errString = "";
			Connection conn = null;
			PreparedStatement pstmt = null ;
			ResultSet rs = null;
			String sql = "";
			int cnt=0;
			int currentFormNo=0;
			int childNodeListLength;
			ConnDriver connDriver = new ConnDriver();
			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
			
			String siteCode="",sitecodePay="",taxClass="",taxEnv = "",crTerm="",userId="",currCode="",scCode="";
			
			try
			{
				System.out.println("@@@@@@@@ wfvaldata called");
				conn = connDriver.getConnectDB("DriverITM");
				connDriver = null;
				userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
				if(objContext != null && objContext.trim().length()>0)
				{
					currentFormNo = Integer.parseInt(objContext);
				}
				switch(currentFormNo)
				{
					case 1 :
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
				
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNodeName.equalsIgnoreCase("site_code"))
						{

							System.out.println("validation site_code executed");
							siteCode = genericUtility.getColumnValue("site_code",dom);
							if(siteCode != null && siteCode.trim().length() > 0)
							{
								sql =" select count(*) from site where site_code = ?  ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,siteCode.trim());
								rs = pstmt.executeQuery();
								System.out.println("@@@@@@@@@  executed sql"+sql);
								if(rs.next())
								{
									cnt =  rs.getInt(1);
									if(cnt == 0) 
										 {
											errString = itmDBAccessEJB.getErrorString("","VTSITECD1",userId);
											return errString;
										 }						
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}

	   						}

							else
							{
								
								errString = itmDBAccessEJB.getErrorString("","VMSITECD1",userId);
								return errString;
							}
						}
						
						if(childNodeName.equalsIgnoreCase("curr_code"))
						{
							System.out.println("validation curr_code executed");
							currCode = genericUtility.getColumnValue("curr_code",dom);
						
							
							if(currCode != null && currCode.trim().length() > 0)
							{
								sql =" select count(*) from currency where curr_code = ? ";
								pstmt = conn.prepareStatement(sql);
								
								pstmt.setString(1,currCode.trim());
								rs = pstmt.executeQuery();
								System.out.println("@@@@@@@@@  executed sql"+sql);
								if(rs.next())
								{
									cnt =  rs.getInt(1);
									if(cnt == 0) 
									{
										//currency code pay entered is not defined in master.
										errString = itmDBAccessEJB.getErrorString("","VTCURRCD1",userId);
										return errString;
									}									
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
	   						}

//							else
//							{
//								//currency code pay cannot be empty
//								errString = itmDBAccessEJB.getErrorString("","SITETAXAE6",userId);
//								return errString;
//							}

						}
					
						if(childNodeName.equalsIgnoreCase("site_code__pay"))
						{
							System.out.println("validation site_code_pay executed");
							sitecodePay = genericUtility.getColumnValue("site_code__pay",dom);
						
							
							if(sitecodePay != null && sitecodePay.trim().length() > 0)
							{
								sql =" select count(*) from site where site_code=? ";
								pstmt = conn.prepareStatement(sql);
								
								pstmt.setString(1,sitecodePay.trim());
								rs = pstmt.executeQuery();
								System.out.println("@@@@@@@@@  executed sql"+sql);
								if(rs.next())
								{
									cnt =  rs.getInt(1);
									if(cnt == 0) 
									{
										//site code pay entered is not defined in master.
										errString = itmDBAccessEJB.getErrorString("","VTSITECP1 ",userId);
										return errString;
										
									}									
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
	   						}

//							else
//							{
//								//site code pay cannot be empty
//								errString = itmDBAccessEJB.getErrorString("","SITETAXAE2",userId);
//								return errString;
//								
//							}

						}
						
						if(childNodeName.equalsIgnoreCase("tax_class"))
						{
							System.out.println("validation tax_class executed");
							taxClass = genericUtility.getColumnValue("tax_class",dom);
						
							
							if(taxClass != null && taxClass.trim().length() > 0)
							{
								sql =" select count(*) from taxclass where tax_class=? ";
								pstmt = conn.prepareStatement(sql);
								
								pstmt.setString(1,taxClass.trim());
								rs = pstmt.executeQuery();
								System.out.println("@@@@@@@@@  executed sql"+sql);
								if(rs.next())
								{
									cnt =  rs.getInt(1);
									if(cnt == 0) 
									{
										// tax class entered is not defined in master.
										errString = itmDBAccessEJB.getErrorString("","VTTAXCLA1",userId);
										return errString;
									}									
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
	   						}

//							else
//							{
//								//tax class cannot be empty
//								errString = itmDBAccessEJB.getErrorString("","SITETAXAE4",userId);
//								return errString;
//							}
						}
						
						if(childNodeName.equalsIgnoreCase("tax_env"))
						{
							System.out.println("validation tax_env executed");
							taxEnv = genericUtility.getColumnValue("tax_env",dom);
						
							
							if(taxEnv != null && taxEnv.trim().length() > 0)
							{
								sql =" select count(*) from taxenv where tax_env=? ";
								pstmt = conn.prepareStatement(sql);
								
								pstmt.setString(1,taxEnv.trim());
								rs = pstmt.executeQuery();
								System.out.println("@@@@@@@@@  executSITETAXAed sql"+sql);
								if(rs.next())
								{
									cnt =  rs.getInt(1);
									if(cnt == 0) 
									{
										// tax env entered is not defined in master.
										errString = itmDBAccessEJB.getErrorString("","VTTAXENV1",userId);
										return errString;
									}									
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
	   						}

//							else
//							{
//								//tax env cannot be empty
//								errString = itmDBAccessEJB.getErrorString("","SITETAXAE5",userId);
//								return errString;
//							}

						}
						if(childNodeName.equalsIgnoreCase("sc_code"))
						{
							System.out.println("validation sc_code executed");
							scCode = genericUtility.getColumnValue("sc_code",dom);
						
							if(scCode != null && scCode.trim().length() > 0)
							{
								sql =" select count(*) from strg_customer where sc_code=? ";
								pstmt = conn.prepareStatement(sql);
								
								pstmt.setString(1,scCode.trim());
								rs = pstmt.executeQuery();
								System.out.println("@@@@@@@@@  executed sql"+sql);
								if(rs.next())
								{
										cnt =  rs.getInt(1);
									if(cnt == 0) 
									{
										// sc code no in master .
										errString = itmDBAccessEJB.getErrorString("","SITETAXA8",userId);
										return errString;
									}									
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
										pstmt.close();
									pstmt = null;
								}

	   							}
	
							else
							{
								System.out.println("else execued sie ocde");
									//sc code cannot be empty
								errString = itmDBAccessEJB.getErrorString("","SITETAXAE8",userId);
								return errString;
							}
					
							
							}

						if(childNodeName.equalsIgnoreCase("cr_term"))
						{
							System.out.println("validation cr_term executed");
							crTerm = genericUtility.getColumnValue("cr_term",dom);
							
							
							if(crTerm != null && crTerm.trim().length() > 0)
							{
								sql =" select count(*) from crterm where cr_term=? ";
								pstmt = conn.prepareStatement(sql);
								
								pstmt.setString(1,crTerm.trim());
								rs = pstmt.executeQuery();
								System.out.println("@@@@@@@@@  executed sql"+sql);
								if(rs.next())
								{
									cnt =  rs.getInt(1);
									if(cnt == 0) 
									{
										// crdit term entered is not defined in master.
											errString = itmDBAccessEJB.getErrorString("","VTCRTERM1",userId);
										return errString;
									}									
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}

	   						}

//							else
//							{
//								//credit term cannot be empty
//								errString = itmDBAccessEJB.getErrorString("","SITETAXAE3",userId);
//								return errString;
//							}

						}

						
						
					} // end for
										
				} //END switch
			}//END TRY
			catch(Exception e)
			{
				System.out.println("Exception ::"+e);
				e.printStackTrace();
				errString=e.getMessage();
                throw new ITMException(e);
			}
			finally
			{
				try
				{
					if(conn!=null)
					{
						if(rs != null )rs.close();
						rs = null;
						if(pstmt != null )pstmt.close();
						pstmt =null;
						conn.close();
					}
					conn = null;
				}
				catch(Exception d)
				{
				  d.printStackTrace();
				}
			}
			System.out.println("ErrString ::"+errString);
			return errString;
		}//END OF VALIDATIONreturn errString;
	

		public String itemChanged(String xmlString,String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
		{
			System.out.println("@@@@@@@ default itemChanged called");
			Document dom = null;
			Document dom1 = null;
			Document dom2 = null;
			String valueXmlString = "";
			try
			{   
				dom = parseString(xmlString);
				dom1 = parseString(xmlString1);
				dom2 = parseString(xmlString2);
				valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
			}
			catch(Exception e)
			{
				System.out.println("Exception : [TrainingEJB][itemChanged(String,String)] :==>\n"+e.getMessage());
			}
			return valueXmlString;
		}
		public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
		{
			System.out.println("@@@@@@@ itemChanged called");
			StringBuffer valueXmlString = new StringBuffer();
			NodeList parentNodeList = null;
			NodeList childNodeList = null;
			Node parentNode = null;
			Node childNode = null;
			Connection conn = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null ;
			String childNodeName = null;
			GenericUtility genericUtility = GenericUtility.getInstance();
			ConnDriver connDriver = new ConnDriver();
			String sql="";
			int currentFormNo =0;
			String columnValue="",scCode="",scCodeFirstName="",chgTerm="",chgUser="",scCodeMiddleName="",
					scCodeLastName="",scCurrCode= "";
					
							

			int ctr=0;
			try
			{   
				conn = connDriver.getConnectDB("DriverITM");
				conn.setAutoCommit(false);
				connDriver=null;
				if(objContext != null && objContext.trim().length()>0)
				{
					currentFormNo = Integer.parseInt(objContext.trim());
				}
				valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
				valueXmlString.append(editFlag).append("</editFlag></header>");
				
					
					chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chg_term");
					chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chg_user");
				
				System.out.println("**********ITEMCHANGE FOR CASE"+currentFormNo+"**************");
				switch(currentFormNo)
				{
					case 1 :
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					ctr = 0; 
					valueXmlString.append("<Detail1>");
					int childNodeListLength = childNodeList.getLength();
					do
					{ 
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNodeName.equals(currentColumn))
						{
							if (childNode.getFirstChild()!= null)
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
							}
						}
						ctr++;
						}
					while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
					System.out.println("[" + currentColumn + "] ==> '" + columnValue + "'");
					
				
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
					{
						System.out.println("--------------------ITM_DEFAULT-----------------------");
						Calendar currentDate = Calendar.getInstance();
						SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
						String sysDate = sdf.format(currentDate.getTime());
						System.out.println("Now the date is :=>  " + sysDate);
								
						valueXmlString.append("<chg_date><![CDATA[").append(sysDate).append("]]></chg_date>\r\n");
						valueXmlString.append("<chg_term><![CDATA[").append(chgTerm).append("]]></chg_term>");
						valueXmlString.append("<chg_user><![CDATA[").append(chgUser).append("]]></chg_user>");
						
					}
				
					
					if((currentColumn.trim().equalsIgnoreCase("sc_code")))
					{
						scCode = genericUtility.getColumnValue("sc_code",dom);
						System.out.println("sc_code ==== "+scCode);
						if(scCode != null && scCode.trim().length()>0 )
						{
						sql = "select first_name,middle_name,last_name,curr_code from strg_customer where sc_code = ?";
						
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,scCode.trim());
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							scCodeFirstName= rs.getString("first_name");
							scCodeMiddleName= rs.getString("middle_name");
							scCodeLastName= rs.getString("last_name");
							scCurrCode = rs.getString("curr_code");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						valueXmlString.append("<first_name_desc>").append("<![CDATA[" + scCodeFirstName + "]]>").append("</first_name_desc>");
						valueXmlString.append("<middle_name_desc>").append("<![CDATA[" +scCodeMiddleName + "]]>").append("</middle_name_desc>");
						valueXmlString.append("<last_name_desc>").append("<![CDATA[" + scCodeLastName + "]]>").append("</last_name_desc>");
						valueXmlString.append("<curr_code>").append("<![CDATA[" + scCurrCode +"]]>").append("</curr_code>");
						
						}
						else
						{
							valueXmlString.append("<first_name_desc>").append("<![CDATA["+""+"]]>").append("</first_name_desc>");
							valueXmlString.append("<middle_name_desc>").append("<![CDATA["+""+"]]>").append("</middle_name_desc>");
							valueXmlString.append("<last_name_desc>").append("<![CDATA["+""+"]]>").append("</last_name_desc>");
							valueXmlString.append("<curr_code>").append("<![CDATA[]]").append("</curr_code>");
						}
					}
					
					valueXmlString.append("</Detail1>");
										
				}
				valueXmlString.append("</Root>");
				
			}// end try
			catch(Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception ::"+e.getMessage());
				throw new ITMException(e);
			}
			finally
			{
				try
				{
					if(conn!=null)
					{
						if(rs != null )
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						conn.close();
						conn = null;
					}
				}
				catch(Exception d)
				{
				  d.printStackTrace();
				}			
			}
			return valueXmlString.toString();
		}//End of itemChanged	 

	}