
package ibase.webitm.ejb.wms;
/*
 * Author:Wasim Ansari
 * Date:02-JUNE-15
 * Request ID:D15AKAT002 (PO Case Label Metis)
 */
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.InvAllocTraceBean;
import ibase.webitm.ejb.dis.StockUpdate;
import ibase.webitm.reports.utility.XSDParser;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
@javax.ejb.Stateless
public class POCaseLabelPrc extends ProcessEJB implements POCaseLabelPrcLocal, POCaseLabelPrcRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	boolean isError = false;
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Entered in case label generation process.");		
		String retStr = "";
		Document detailDom = null;
		Document headerDom = null;
		
		E12GenericUtility genericUtility = new E12GenericUtility();			
		try
		{	
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString); 
				System.out.println("xmlString--->>" + xmlString);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2); 
				System.out.println("xmlString2 --->>" + xmlString2);
			}
			
			retStr = process(headerDom, detailDom, windowName, xtraParams);

		}
		catch (Exception e)
		{
			System.out.println("Exception :PODProcess :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
			e.printStackTrace();
			retStr = e.getMessage();
		}
		return retStr;
	}
	
	public String process(Document dom, Document dom2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String retString = "";
		String loginEmpCode = "",userId = "",loginSite = "",chgTerm = "";
		String errString = "";
		String purcOrder = "",itemCode = "",caseLable = "",quantity = "",oldQuantity = "",barCode = "",confirmed = "",shipperSize = "";
		String labelNo = "", descr = "",refSer = "",currDate = "";
		int count = 0,caseCount = 0;
		Timestamp today = new Timestamp(System.currentTimeMillis());
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		
		System.out.println(xtraParams);
		loginEmpCode = checkNullAndTrim(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode"));
		userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		loginSite = checkNullAndTrim((genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode")));
		chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
		
		try
		{
			System.out.println("Inside Try Block in Post Save.....");
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			System.out.println("Today date is="+today);
			
			purcOrder = checkNullAndTrim(( genericUtility.getColumnValue( "purc_order", dom )));
			//purcOrder = genericUtility.getColumnValue( "purc_order", dom );
			System.out.println("Purchase Order="+purcOrder);
			
			itemCode = checkNullAndTrim(( genericUtility.getColumnValue( "item_code", dom )));
			//itemCode =  genericUtility.getColumnValue( "item_code", dom );
			System.out.println("Item Code="+itemCode);
			
			if(!purcOrder.equalsIgnoreCase("") && !itemCode.equalsIgnoreCase(""))
			{
				sql = "select * from CASE_LABEL where order_no = ? and item_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, purcOrder);
				pstmt.setString(2, itemCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					System.out.println("Item Code already present in CASE_LABEL table with this Purchase Order");
					errString = itmDBAccessEJB.getErrorString("","VTCASELBL","","",conn);
					return errString;
				}
				else
				{	
					sql = "select confirmed from porder where purc_order = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, purcOrder);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						confirmed = checkNullAndTrim(rs.getString("confirmed"));
					}
					else
					{
						errString = itmDBAccessEJB.getErrorString("","VTPORD1","","",conn);
						return errString;
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				
					if("Y".equalsIgnoreCase(confirmed))
					{
						System.out.println("Purchase order is confirmed="+purcOrder);
						
							sql = "SELECT QUANTITY FROM PORDDET WHERE ITEM_CODE = ? AND PURC_ORDER = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, itemCode);
							pstmt.setString(2, purcOrder);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								quantity = checkNullAndTrim(rs.getString("QUANTITY"));
								oldQuantity = quantity;
								
								sql = "SELECT REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_porder'";
								pstmt = conn.prepareStatement(sql);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									refSer = checkNullAndTrim(rs.getString("REF_SER"));
									System.out.println("Ref Series"+refSer);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								
								//Changed by wasim on 17-12-2015 to set quantity as shippersize [START]
								//sql = "SELECT DESCR,UDF__STR2 FROM ITEM WHERE ITEM_CODE = ? ";
								sql =  " SELECT I.DESCR,I.UDF__STR2,L.SHIPPER_SIZE FROM ITEM I,ITEM_LOT_PACKSIZE L"
									   +" WHERE I.ITEM_CODE = ? AND I.ITEM_CODE = L.ITEM_CODE";
								//Changed by wasim on 17-12-2015 to set quantity as shippersize [END]
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, itemCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									descr   = checkNullAndTrim(rs.getString("DESCR"));
									barCode = checkNullAndTrim(rs.getString("UDF__STR2"));
									shipperSize = checkNullAndTrim(rs.getString("SHIPPER_SIZE"));
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								
								//Changed by wasim on 17-12-2015 to set quantity as shippersize [START]
								/*System.out.println("Quantity Length="+quantity.length());
								
								if(quantity.length() == 1)
								{
									quantity = "000"+quantity;
								}
								else if(quantity.length() == 2)
								{
									quantity = "00"+quantity;
								}
								else if(quantity.length() == 3)
								{
									quantity = "0"+quantity;
								}
								
								System.out.println("New Quantity="+quantity);
								
								labelNo = purcOrder + quantity + barCode;
								System.out.println("Label Number is="+labelNo);*/
								System.out.println("Shipper Size Length="+shipperSize.length());
								
								if(shipperSize.length() == 1)
								{
									shipperSize = "000"+shipperSize;
								}
								else if(shipperSize.length() == 2)
								{
									shipperSize = "00"+shipperSize;
								}
								else if(shipperSize.length() == 3)
								{
									shipperSize = "0"+shipperSize;
								}
								
								System.out.println("New Quantity="+shipperSize);
								
								labelNo = purcOrder + shipperSize + barCode;
								System.out.println("Label Number is="+labelNo);
								//Changed by wasim on 17-12-2015 to set quantity as shippersize [END]
								
								sql = "Insert into CASE_LABEL (ITEM_CODE,LOT_NO,ORDER_NO,REF_SER,QUANTITY,LABEL_NO,"
										+ "CHG_USER,CHG_DATE,CHG_TERM ) "
									+ " values (?,?,?,?,?,?,?,?,?)";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, itemCode);
								pstmt.setString(2, "   ");
								pstmt.setString(3, purcOrder);
								pstmt.setString(4, refSer);
								//pstmt.setString(5, oldQuantity);
								pstmt.setString(5, shipperSize);
								pstmt.setString(6, labelNo);
								pstmt.setString(7, loginEmpCode);
								pstmt.setTimestamp(8, today);
								pstmt.setString(9, chgTerm);
								caseCount = pstmt.executeUpdate();
								pstmt.close(); pstmt = null;
								System.out.println("Record inserted successfully in Case Label ...."+caseCount);
								
								if(caseCount > 0)
								{
									retString = itmDBAccessEJB.getErrorString("", "VTPRCCS", "", "", conn);
									return retString;
								}
								else
								{
									retString = itmDBAccessEJB.getErrorString("", "VTPRCNC", "", "", conn);
									return retString;
								}
							}
							else
							{
								System.out.println("Item Code does not belong to this Purchase Order");
								errString = itmDBAccessEJB.getErrorString("","VTPURCDET","","",conn);
								return errString;
							}
					}
					else
					{
						System.out.println("Purchase Order is not Confirmed");
						errString = itmDBAccessEJB.getErrorString("","VTNOTCONF","","",conn);
						return errString;
					}
				}//end purchase order check in case label table.
			}
			else
			{
				if(purcOrder.equalsIgnoreCase("") || purcOrder.length() < 0)
				{	
					System.out.println("Purchase Order is blank");
					errString = itmDBAccessEJB.getErrorString("","VTPORD1","","",conn);
					return errString;
				}
				else if (itemCode.equalsIgnoreCase("") || itemCode.length() < 0)
				{
					System.out.println("Item Code is blank");
					errString = itmDBAccessEJB.getErrorString("","VMITEMCD","","",conn);
					return errString;
				}
			}
		}
		catch(Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(isError)
				{
					System.out.println("Rollbacking.................");
					conn.rollback();
				}
				else
				{
					System.out.println("commiting.................");
					conn.commit();
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return retString;
	}
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}

	@Override
	public String process() throws RemoteException, ITMException {
		// TODO Auto-generated method stub
		return null;
	}
}

