<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body onload="checkMisMatchCount();">
<script type="text/javascript" src="/ibase/webitm/js/gstRecoWizard.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
		
<link href="/ibase/webitm/css/Galaxy/galaxy-theme.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/Standard/default.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/gstRecoWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/circle.css" rel="stylesheet"/>
<!-- <link href="/ibase/webitm/css/jquery.datetimepicker.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/> -->

<script>
<![CDATA[
	$(function() 
	{
		var acc = document.getElementsByClassName("accordionParent");
		var i;
		
		for (i = 0; i < acc.length; i++)
		{
		    acc[i].onclick = function()
		    {
		    	if(this.attributes.expanded.value == "false")
		   		{
		    		this.attributes.expanded.value = "true";
		   		}
		    	else
		   		{
		    		this.attributes.expanded.value = "false";
		   		}
	       		this.classList.remove("activeAccor");
		       	this.classList.toggle("active");
		        this.nextElementSibling.classList.toggle("show");
		        
		        var expAttributes = $("button[expanded='true']");
		        var expCnt = expAttributes.length;
		        
		        if(expCnt == acc.length)
		       	{
		        	document.getElementById("accorAct").value = "Collapse All";	
		       	}
		        else
		       	{
		        	document.getElementById("accorAct").value = "Expand All";	
		       	}
		  	}
		}
	});
	
	$(function() 
	{
		var panel = document.getElementsByClassName("panel");
	
		for (var j = 0; j < panel.length; j++)
		{
			panel[j].onclick = function()
		    {
		       if(this.id != "")
		       {
		       		var acc = document.getElementsByClassName("accordion");
		       		for(var i=0; i<acc.length; i++)
		       		{
		       			acc[i].classList.remove("activeAccor");
		       		}
		       		this.previousElementSibling.classList.add("activeAccor");
		       }
		  	}
		}
	});
	
	$(document).on("keydown", function (e) {
	    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
	        e.preventDefault();
	    }
	    else if(e.which === 13){
	    	 e.preventDefault();
	    }
	});
	
	window.onclick = function (event)
	{
		if(!event.target.matches("#showDataMismatchTable"))
		{
			document.getElementById("showDataMismatch").style.display="none";
		}
	}

]]>
</script>


<form name="gstWizForm2" id="gstWizForm2" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">
	<div class="contentHeaderLbl" style="position:fixed;overflow:hidden;width:97%;">
		&#160;&#160;<img src="/ibase/images/menuImages/web/wavegeneration.png" onerror="this.src='/ibase/images/menuImages/errMenu.png'" style="position: absolute; margin-left: -20px; height: 20px; width: 20px;"/>
		&#160;GST Data Reconcilation
		<input type="button" Value="Expand All" class="button" id="accorAct" onclick="expandCollapse();" style="float: right;margin-right:2px;"/>
		<input type="hidden" Value="Select All" class="button" id="selectAllRow" onclick="selectAllRows();" style="float: right;margin-right:2px;"/>
	</div><br/><br/>
	
	<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;height:0px;">
		<table id="errorActivityTable" width="100%" height="13%" class="tableClass"  style="margin: 10px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
				<xsl:for-each select="//error">
					<xsl:if test="position() = 1">
						<tr>	
							<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
								Message :
							</td> 
							<td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
								Description :
							</td>
							<td class="tdss_rightAlign"    style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
								<a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
							</td>
						</tr>
					</xsl:if>
					<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
					<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
					<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
					<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
					<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
					<tr style="background: rgba(255, 204, 0, 0.66);">
						 <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
							<xsl:value-of select="message"/>
						</td> 
						<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" nowrap="true">
							<xsl:value-of select="description"/>
							<br></br>
							<xsl:value-of select="trace"/>
						</td>
						<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
						</td>
					</tr>
					<script><![CDATA[]]>formatDetailWithErr();</script>
				</xsl:for-each>
				<xsl:for-each select="//error">
					<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
					<xsl:if test="position() = 1">
						<xsl:if test="$type = 'W'">
						<tr style="background: rgba(255, 204, 0, 0.66);">
							<td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"   nowrap="true" valign="bottom">
								<input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
							</td>
							<td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true">
							</td>
						</tr>
						</xsl:if>
					</xsl:if>	
				</xsl:for-each>
		</table>
	</div>
	
	<!-- <div id = "showDataMismatch" class = "misMatchPanel">
		  <table id ="showDataMismatchTable" class="tableClass">
			<thead class="table-head">
				<tr>
					<th nowrap="true"  style = "text-align:center">
						Title
					</th>
					<th nowrap="true"  style = "text-align:center">
						Purchase
					</th>
					<th nowrap="true"  style = "text-align:center">
						Supply
					</th>
				</tr>
			</thead>
			<tbody class="table-body">
					<tr class='trClass'>
						<td nowrap="true" style = "">
							GSTIN
						</td>
						<td nowrap="true" id = "gstin" style = "">
							
						</td>
						<td nowrap="true" id = "gstin__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Invoice No
						</td>
						<td nowrap="true" id = "doc_no" style = "">
						
						</td>
						<td nowrap="true" id = "doc_no__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Invoice Date
						</td>
						<td nowrap="true" id = "doc_date" style = "">
							cess_amt
						</td>
						<td nowrap="true" id = "doc_date__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							HSN/SAC
						</td>
						<td nowrap="true" id = "gs_code" style = "">
							
						</td>
						<td nowrap="true" id = "gs_code__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Quantity
						</td>
						<td nowrap="true" id = "quantity" style = "">
							
						</td>
						<td nowrap="true" id = "quantity__gstr" style = "">
							
						</td>
					</tr>	
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Rate
						</td>
						<td nowrap="true" id = "rate" style = "">
							
						</td>
						<td nowrap="true" id = "rate__gstr" style = "">
							
						</td>
					</tr>	
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Taxable Amount
						</td>
						<td nowrap="true" id = "taxable_amt" style = "">
							
						</td>
						<td nowrap="true" id = "taxable_amt__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							IGST Amount
						</td>
						<td nowrap="true" id = "igst_amt" style = "">
							
						</td>
						<td nowrap="true" id = "igst_amt__gstr" style = "">
							
						</td>
					</tr>	
					<tr class='trClass'>
						<td nowrap="true" style = "">
							CGST Amount
						</td>
						<td nowrap="true" id = "cgst_amt" style = "">
							
						</td>
						<td nowrap="true" id = "cgst_amt__gstr" style = "">
							
						</td>
					</tr>	
					<tr class='trClass'>
						<td nowrap="true" style = "">
							SGST Amount
						</td>
						<td nowrap="true" id = "sgst_amt" style = "">
							
						</td>
						<td nowrap="true" id = "sgst_amt__gstr" style = "">
							
						</td>
					</tr>
					New Columns added
					<tr class='trClass'>
						<td nowrap="true" style = "">
							GST CODE
						</td>
						<td nowrap="true" id = "gst_code" style = "">
							
						</td>
						<td nowrap="true" id = "gst_code__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							ITC Type
						</td>
						<td nowrap="true" id = "itc_type" style = "">
							
						</td>
						<td nowrap="true" id = "itc_type__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							ITC IGST
						</td>
						<td nowrap="true" id = "itc_igst" style = "">
							
						</td>
						<td nowrap="true" id = "itc_igst__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							ITC CGST
						</td>
						<td nowrap="true" id = "itc_cgst" style = "">
							
						</td>
						<td nowrap="true" id = "itc_cgst__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							ITC SGST
						</td>
						<td nowrap="true" id = "itc_sgst" style = "">
							
						</td>
						<td nowrap="true" id = "itc_sgst__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							ITC CESS
						</td>
						<td nowrap="true" id = "itc_cess" style = "">
							
						</td>
						<td nowrap="true" id = "itc_cess__gstr" style = "">
							
						</td>
						<td nowrap="true" id = "gst_rate" style = "">
							
						</td>
					</tr>
			</tbody>
		  </table>
	</div> -->
	
	
	
	<div id = "showDataMismatch" class = "misMatchPanel">
		  <table id ="showDataMismatchTable" class="tableClass">
			<thead class="table-head">
				<tr>
					<th nowrap="true"  style = "text-align:center">
						Title
					</th>
					<th nowrap="true"  style = "text-align:center">
						Purchase
					</th>
					<th nowrap="true"  style = "text-align:center">
						Supply
					</th>
				</tr>
			</thead>
			<tbody class="table-body">
					<tr class='trClass'>
						<td nowrap="true" style = "">
							GSTIN
						</td>
						<td nowrap="true" id = "gstin" style = "">
							
						</td>
						<td nowrap="true" id = "gstin__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Invoice No
						</td>
						<td nowrap="true" id = "doc_no" style = "">
						
						</td>
						<td nowrap="true" id = "doc_no__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Invoice Date
						</td>
						<td nowrap="true" id = "doc_date" style = "">
							
						</td>
						<td nowrap="true" id = "doc_date__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Customer Code 
						</td>
						<td nowrap="true" id = "cust_code" style = "">
							
						</td>
						<td nowrap="true" id = "cust_code__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Amount
						</td>
						<td nowrap="true" id = "amount" style = "">
							
						</td>
						<td nowrap="true" id = "amount__gstr" style = "">
							
						</td>
					</tr>	
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Reverse Charge  
						</td>
						<td nowrap="true" id = "reverse_chrg" style = "">
							
						</td>
						<td nowrap="true" id = "reverse_chrg__gstr" style = "">
							
						</td>
					</tr>	
					
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Reason Code
						</td>
						<td nowrap="true" id = "reas_code" style = "">
							
						</td>
						<td nowrap="true" id = "reas_code__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Order No
						</td>
						<td nowrap="true" id = "order_no" style = "">
							
						</td>
						<td nowrap="true" id = "order_no__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							Tran Type
						</td>
						<td nowrap="true" id = "tran_type" style = "">
							
						</td>
						<td nowrap="true" id = "tran_type__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							remarks
						</td>
						<td nowrap="true" id = "remarks" style = "">
							
						</td>
						<td nowrap="true" id = "remarks__gstr" style = "">
							
						</td>
					</tr>
					
				<!-- New Columns added -->	
					<tr class='trClass'>
						<td nowrap="true" style = "">
							GST CODE
						</td>
						<td nowrap="true" id = "gst_code" style = "">
							
						</td>
						<td nowrap="true" id = "gst_code__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							GST TYPE
						</td>
						<td nowrap="true" id = "gst_type" style = "">
							
						</td>
						<td nowrap="true" id = "gst_type__gstr" style = "">
							
						</td>
					</tr>
					
					<!-- <tr class='trClass'>
						<td nowrap="true" style = "">
							IGST Amount
						</td>
						<td nowrap="true" id = "igst_amt" style = "">
							
						</td>
						<td nowrap="true" id = "igst_amt__gstr" style = "">
							
						</td>
					</tr>	
					<tr class='trClass'>
						<td nowrap="true" style = "">
							CGST Amount
						</td>
						<td nowrap="true" id = "cgst_amt" style = "">
							
						</td>
						<td nowrap="true" id = "cgst_amt__gstr" style = "">
							
						</td>
					</tr>	
					<tr class='trClass'>
						<td nowrap="true" style = "">
							SGST Amount
						</td>
						<td nowrap="true" id = "sgst_amt" style = "">
							
						</td>
						<td nowrap="true" id = "sgst_amt__gstr" style = "">
							
						</td>
					</tr> -->
					
				<!-- 	<tr class='trClass'>
						<td nowrap="true" style = "">
							ITC IGST
						</td>
						<td nowrap="true" id = "itc_igst" style = "">
							
						</td>
						<td nowrap="true" id = "itc_igst__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							ITC CGST
						</td>
						<td nowrap="true" id = "itc_cgst" style = "">
							
						</td>
						<td nowrap="true" id = "itc_cgst__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							ITC SGST
						</td>
						<td nowrap="true" id = "itc_sgst" style = "">
							
						</td>
						<td nowrap="true" id = "itc_sgst__gstr" style = "">
							
						</td>
					</tr>
					<tr class='trClass'>
						<td nowrap="true" style = "">
							ITC CESS
						</td>
						<td nowrap="true" id = "itc_cess" style = "">
							
						</td>
						<td nowrap="true" id = "itc_cess__gstr" style = "">
							
						</td>
						<td nowrap="true" id = "gst_rate" style = "">
							
						</td>
					</tr> -->
			</tbody>
		  </table>
	</div>
	
	
	
	
	
	<div id="popHelpContainer"></div>
	<div id="overlay"></div>
	<div id="mainPageHeaderContatiner">
		<div id="detailPage-input-Container">
			<xsl:for-each select="//Detail2">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				
				<xsl:if test="$dbID = '0'">
					<xsl:variable name="prd_code"><xsl:value-of select="prd_code"/></xsl:variable>
					<xsl:variable name="gstin"><xsl:value-of select="gstin"/></xsl:variable>
					<input type="hidden" value="{$prd_code}" name="Detail2.{normalize-space($dbID)}.prd_code" id="prd_code" />
					<input type="hidden" value="{$gstin}" name="Detail2.{normalize-space($dbID)}.gstin" id="gstin" />
				</xsl:if>	
			
				<xsl:if test ="$dbID != '0'">
					<xsl:variable name="custDbID"><xsl:value-of select="@domID"/></xsl:variable>
					<xsl:variable name="supp_img_path"><xsl:value-of select="supp_img_path"/></xsl:variable>
					<xsl:variable name="suppIDList"><xsl:value-of select="suppIDList"/></xsl:variable>
					
					<input type = "hidden" id = "suppIDList{$custDbID}" value = "{$suppIDList}"></input>
					
					<button class="accordion accordionParent" id="custPerc{$custDbID}"  type="button" expanded="false">
						
						<div id="percClass{$custDbID}" class="c100 small p100">
						  <img src="{$supp_img_path}" class="custImg"/>
						  <div class="slice">
							<div id="custbar{$custDbID}" class="bar"></div>
							<div id="custfill{$custDbID}" class="fill"></div>
						  </div>
						</div>
						
						<div style="margin-left:10px;" class="dataSummry">
							<span class="headerText">Supplier- <xsl:value-of select="supp_name"/> &#160; GSTIN - <xsl:value-of select="supp_code"/>&#160;</span>
							<br></br>
							<span class="subText">State Code- <xsl:value-of select="supp_addr"/> </span>
						</div>
						
						<div class="mismatchImg">
						 <!--  <img src="/ibase/images/galaxy/mismatch.png" id = "misMatch{$custDbID}" alt="Mismatch Found" width="20" height="20" style = "border-radius:50%;visibility:hidden"></img> -->
						  	<!--  <img src="/ibase/images/galaxy/greenTick.png" id = "Match{$custDbID}" alt="Match Found" width="20" height="20" style = "border-radius:50%;visibility:hidden"></img>  -->
						   	 <img src="" id = "Match{$custDbID}" alt="Match Found" width="20" height="20" style = "visibility:hidden"></img>
 						  	 
						</div>
					</button>
					<div class="panel" id="custPanel{$custDbID}">
						<xsl:for-each select="Invoices/invoice">
						<xsl:variable name="soDbID"><xsl:value-of select="@domID"/></xsl:variable>
						<xsl:variable name="domIDList"><xsl:value-of select="domIDList"/></xsl:variable>
						
						<input type = "hidden" id = "domIDList{$soDbID}" value = "{$domIDList}"></input>
						
							<button class="accordion accordionSO" onclick = 'openAccordion(this,"{$soDbID}")' type="button" expanded="false">
								<!-- <div class="dataSummry" style = "margin-top:8px">
									<SELECT id='Detail2.{$soDbID}.status' name="Detail2.{$soDbID}.status" align="LEFT" TABINDEX="170" onclick = "event.stopPropagation();" onchange="setSubmitType('{$soDbID}','{$soDbID}','{$soDbID}')" class="input_editable">
									<SELECT id='submitStatus{$soDbID}' name="Detail2.{$soDbID}.status" align="LEFT" TABINDEX="170" onclick = "event.stopPropagation();" onchange="setSubmitType('{$soDbID}','{$soDbID}','{$soDbID}')" class="input_editable">
										<OPTION value="X">Select</OPTION>
										<OPTION value="A">Accept</OPTION>
										<OPTION value="M">Modify</OPTION>
										<OPTION value="D">Delete</OPTION>
										<OPTION value="R">Reject</OPTION>
										<OPTION value="P">Pending</OPTION>
									</SELECT>
								</div> -->
								<div style="margin-left:10px;" class="dataSummry">
									<span class="headerText">Invoice No - <xsl:value-of select="invoice_id"/>&#160;-</span>
									<!-- <span class="headerText">Invoice Date - <xsl:value-of select="order_date"/>&#160;</span> -->
									<br></br>
									<span class="subText">Doc No - <xsl:value-of select="doc_no"/>&#160;</span>
									<span class="subText">Doc Date - <xsl:value-of select="doc_date"/>&#160;</span>
									<!-- <span class="subText">Amount - <xsl:value-of select="inv_amt"/>&#160;</span>
									<span class="subText">Site Code - <xsl:value-of select="site_code"/>&#160;</span> -->
								</div>
								<div class="selectSummry">
									<!-- <p><xsl:value-of select="data_match"/> mismatch found</p> -->
									<p id = "Detail2.{$soDbID}.mismatch"  style = "display:inline"></p><p style = "display:inline">mismatch found</p>

									<xsl:variable name="reco_status"><xsl:value-of select="reco_status"/></xsl:variable>
									
									<!-- <xsl:choose>
									     <xsl:when test="$reco_status ='E'">
									        <p>Reconcilation Status - Open</p>
									     </xsl:when>
									     <xsl:when test="$reco_status ='M'">
									        <p>Reconcilation Status - Manual</p>
									     </xsl:when>
									      <xsl:when test="$reco_status ='A'">
									        <p>Reconcilation Status - Automatic</p>
									     </xsl:when>
									     <xsl:otherwise>
								            <p>Reconcilation Status - None</p>
								         </xsl:otherwise>
									</xsl:choose> -->
									&#160;
									<SELECT id='submitStatus{$soDbID}' align="LEFT" TABINDEX="170" onclick = "event.stopPropagation();" onchange="setSubmitType('{$soDbID}','{$soDbID}','{$soDbID}')" class="input_editable">
											<OPTION value="X">Select</OPTION>
											<OPTION value="A">Accept</OPTION>
											<OPTION value="M">Modify</OPTION>
											<OPTION value="D">Delete</OPTION>
											<OPTION value="R">Reject</OPTION>
											<OPTION value="P">Pending</OPTION>
									</SELECT>
									
								</div>
						  	</button>
						  	<div class="panel panelSO">
						  		<span id ="spanGSTR1_{$soDbID}" style = "display:inline-block;width:calc(50% - 33px);overflow-x:scroll;border-right:1px solid #dadada" onscroll="scrollGstrData('spanGSTR1_{$soDbID}','spanGSTR2_{$soDbID}')">
								  <table id ="details{$soDbID}" class="tableClass">
									<thead class="table-head">
										<!-- <tr>
											<th nowrap="true" style="border-left:0px solid black !important;" >
											<Input id='selectAll{$soDbID}' type='checkbox' name='selectAll' custId='{$custDbID}' tableId='{$soDbID}' onClick="checkAll('{$custDbID}','details{$soDbID}','{$soDbID}')"/>
											</th>
											<th nowrap="true">Sr No</th>
											<th nowrap="true">Status</th>
											<th nowrap="true">IGST(%)</th>
											<th nowrap="true">IGST Amount</th>
											<th nowrap="true">CGST(%)</th>
											<th nowrap="true">CGST Amount</th>
											<th nowrap="true">SCGT(%)</th>
											<th nowrap="true">SCGT Amount</th>
											<th nowrap="true">CESS(%)</th>
											<th nowrap="true">CESS Amount</th>
											
											<th nowrap="true" style = "display:none">GSTIN</th>
											<th nowrap="true" style = "display:none">Invoice No</th>
											<th nowrap="true" style = "display:none">Invoice Date</th>
											<th nowrap="true" style = "display:none">HSN/SAC</th>
											<th nowrap="true" style = "display:none">Quantity</th>
											<th nowrap="true" style = "display:none">Rate</th>
											<th nowrap="true" style = "display:none">Taxable Amount</th>
											
											<th nowrap="true">GST CODE</th>
											<th nowrap="true">ITC TYPE</th>
											<th nowrap="true">ITC IGST</th>
											<th nowrap="true">ITC CGST</th>
											<th nowrap="true">ITC SGST</th>
											<th nowrap="true">ITC CESS</th>
											<th nowrap="true">GST RATE</th>
											
										</tr> -->
										
										<tr>
											<th nowrap="true" style="border-left:0px solid black !important;" >
											<Input id='selectAll{$soDbID}' type='checkbox' name='selectAll' custId='{$custDbID}' tableId='{$soDbID}' onClick="checkAll('{$custDbID}','details{$soDbID}','{$soDbID}')"/>
											</th>
											
											
											<th nowrap="true">Sr No</th>
											<th nowrap="true">Customer Code</th>
											<th nowrap="true">Amount</th>
											<th nowrap="true">Reverse Charge</th>
											<th nowrap="true">Reason Code</th>
											<th nowrap="true">Order No</th>
											<th nowrap="true">Tran Type</th>
											<th nowrap="true">Remarks</th>
											<th nowrap="true">GST CODE</th>
											<th nowrap="true">GST TYPE</th>
											<!-- <th nowrap="true">CGST Amount</th>
											<th nowrap="true">SCGT(%)</th>
											<th nowrap="true">SCGT Amount</th>
											<th nowrap="true">CESS(%)</th>
											<th nowrap="true">CESS Amount</th> -->
											
											<th nowrap="true" style = "display:none">GSTIN</th>
											<th nowrap="true" style = "display:none">Invoice No</th>
											<th nowrap="true" style = "display:none">Invoice Date</th>
											<th nowrap="true" style = "display:none">HSN/SAC</th>
											<th nowrap="true" style = "display:none">Quantity</th>
											<th nowrap="true" style = "display:none">Rate</th>
											<th nowrap="true" style = "display:none">Taxable Amount</th>
											<!-- <th nowrap="true">ITC IGST</th>
											<th nowrap="true">ITC CGST</th>
											<th nowrap="true">ITC SGST</th>
											<th nowrap="true">ITC CESS</th>
											<th nowrap="true">GST RATE</th> -->
											
										</tr>
									</thead>
									<tbody class="table-body">
										<xsl:for-each select="gstr1">
										<xsl:variable name="linedbID"><xsl:value-of select="@domID"/></xsl:variable>
										<xsl:variable name="tran_id"><xsl:value-of select="tran_id"/></xsl:variable>
										<xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
										<xsl:variable name="status"><xsl:value-of select=" status"/></xsl:variable>
										<!-- <xsl:variable name="igst_perc"><xsl:value-of select="igst_perc"/></xsl:variable> -->
										<xsl:variable name="igst_amt"><xsl:value-of select="igst_amt"/></xsl:variable>
										<!-- <xsl:variable name="cgst_perc"><xsl:value-of select="cgst_perc"/></xsl:variable> -->
										<xsl:variable name="cgst_amt"><xsl:value-of select="cgst_amt"/></xsl:variable>
										<!-- <xsl:variable name="scgt_perc"><xsl:value-of select="scgt_perc"/></xsl:variable> -->
										<xsl:variable name="sgst_amt"><xsl:value-of select="sgst_amt"/></xsl:variable>
										<xsl:variable name="cess_perc"><xsl:value-of select="cess_perc"/></xsl:variable>
										<xsl:variable name="cess_amt"><xsl:value-of select="cess_amt"/></xsl:variable>
										
										<xsl:variable name="tax_reg_no"><xsl:value-of select="tax_reg_no"/></xsl:variable>
										<xsl:variable name="doc_no"><xsl:value-of select="doc_no"/></xsl:variable>
										<xsl:variable name="doc_date"><xsl:value-of select="doc_date"/></xsl:variable>
										<xsl:variable name="gs_code"><xsl:value-of select="gs_code"/></xsl:variable>
										<xsl:variable name="quantity"><xsl:value-of select="quantity"/></xsl:variable>
										<xsl:variable name="rate"><xsl:value-of select="rate"/></xsl:variable>
										<xsl:variable name="taxable_amt"><xsl:value-of select="taxable_amt"/></xsl:variable>
										
										<xsl:variable name="gst_code"><xsl:value-of select="gst_code"/></xsl:variable>
										<xsl:variable name="itc_type"><xsl:value-of select="itc_type"/></xsl:variable>
										<xsl:variable name="itc_igst"><xsl:value-of select="itc_igst"/></xsl:variable>
										<xsl:variable name="itc_cgst"><xsl:value-of select="itc_cgst"/></xsl:variable>
										<xsl:variable name="itc_sgst"><xsl:value-of select="itc_sgst"/></xsl:variable>
										<xsl:variable name="itc_cess"><xsl:value-of select="itc_cess"/></xsl:variable>
										<xsl:variable name="gst_rate"><xsl:value-of select="gst_rate"/></xsl:variable>
										
										<!--  newly added by kaustubh   -->
										<xsl:variable name="cust_code"><xsl:value-of select="cust_code"/></xsl:variable>
										<xsl:variable name="order_no"><xsl:value-of select="order_no"/></xsl:variable>
										<xsl:variable name="amount"><xsl:value-of select="amount"/></xsl:variable>
										<xsl:variable name="reverse_chrg"><xsl:value-of select="reverse_chrg"/></xsl:variable>
										<xsl:variable name="reas_code"><xsl:value-of select="reas_code"/></xsl:variable>
										<xsl:variable name="gst_type"><xsl:value-of select="gst_type"/></xsl:variable>
										<xsl:variable name="prd_code"><xsl:value-of select="prd_code"/></xsl:variable>
										<xsl:variable name="cust_name"><xsl:value-of select="cust_name"/></xsl:variable>
										<xsl:variable name="reverse_chrg"><xsl:value-of select="reverse_chrg"/></xsl:variable>
										<xsl:variable name="lr_no"><xsl:value-of select="lr_no"/></xsl:variable>
										<xsl:variable name="lr_date"><xsl:value-of select="lr_date"/></xsl:variable>
										<xsl:variable name="reas_code"><xsl:value-of select="reas_code"/></xsl:variable>
										<xsl:variable name="ecom_reg_no"><xsl:value-of select="ecom_reg_no"/></xsl:variable>
										<xsl:variable name="gst_code"><xsl:value-of select="gst_code"/></xsl:variable>
										<xsl:variable name="gst_type"><xsl:value-of select="gst_type"/></xsl:variable>
										
										<!--<input type="hidden" id="Detail2.{normalize-space($linedbID)}.tran_id" name="Detail2.{normalize-space($linedbID)}.tran_id" value="{$tran_id}"></input>-->
										
										<xsl:choose>
										    <xsl:when test="line_no">
												<tr class='trClass' id="{$linedbID}" onclick="setCheckboxRow(event,this,{$soDbID},'{$custDbID}','details{$soDbID}');"
												     ondblclick="showGSTRData('{$linedbID}')" >
													<td nowrap="true" style="border-left:0px solid black !important;">
														<!-- <Input type='checkbox' value="true" class="selectAll{$soDbID}" name="Detail2.{normalize-space($linedbID)}.selectbox" id="Detail2.{normalize-space($linedbID)}.selectbox" onclick="setCheckbox(this,'{$linedbID}','{$soDbID}','{$custDbID}','details{$soDbID}');" tabindex="-1" /> -->
														<Input type='checkbox' class="selectAll{$soDbID}" name="Detail2.{normalize-space($linedbID)}.selectbox" id="Detail2.{normalize-space($linedbID)}.selectbox"
															 onclick = "setChecked(this,'{$linedbID}')" value="true" tabindex="-1"  />
													</td>
													<!-- <td nowrap="true">
														<xsl:value-of select="line_no"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="status"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="igst_perc"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="igst_amt"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="cgst_perc"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="cgst_amt"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="scgt_perc"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="sgst_amt"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="cess_perc"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="cess_amt"/>
													</td>
													
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="tax_reg_no"/>
													</td>
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="doc_no"/>
													</td>
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="doc_date"/>
													</td>
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="gs_code"/>
													</td>
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="quantity"/>
													</td>
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="rate"/>
													</td>
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="taxable_amt"/>
													</td>
													
													<td nowrap="true" >
														<xsl:value-of select="gst_code"/>
													</td>
													<td nowrap="true" >
														<xsl:value-of select="itc_type"/>
													</td>
													<td nowrap="true" >
														<xsl:value-of select="itc_igst"/>
													</td>
													<td nowrap="true" >
														<xsl:value-of select="itc_cgst"/>
													</td>
													<td nowrap="true" >
														<xsl:value-of select="itc_sgst"/>
													</td>
													<td nowrap="true" >
														<xsl:value-of select="itc_cess"/>
													</td>
													<td nowrap="true" >
														<xsl:value-of select="gst_rate"/>
													</td> -->
													
													
													<!-- added by kaustubh -->
													
													<td nowrap="true">
														<xsl:value-of select="line_no"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="cust_code"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="amount"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="reverse_chrg"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="order_no"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="reas_code"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="tran_type"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="remarks"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="gst_code"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="gst_type"/>
													</td>
														
												</tr>
											</xsl:when>
											<xsl:otherwise>
											        <tr id="{$linedbID}"  ondblclick="showGSTRData('{$linedbID}')" >
											        	<td nowrap="true" style="border-left:0px solid black !important;">
															<Input type='checkbox' class="selectAll{$soDbID}" name="Detail2.{normalize-space($linedbID)}.selectbox" id="Detail2.{normalize-space($linedbID)}.selectbox"
															 onclick = "setChecked(this)" value="false" tabindex="-1" disabled = "true" />
														</td>
														<td colspan = "17">
															Purchase data not found for this record
														</td>
											        </tr>
											</xsl:otherwise>
										 </xsl:choose>  
										 
										 	<input type="hidden" id="Detail2.{normalize-space($linedbID)}.tran_id" name="Detail2.{normalize-space($linedbID)}.tran_id" value="{$tran_id}"></input>
											<input type="hidden" id="Detail2.{normalize-space($linedbID)}.data_match" name="Detail2.{normalize-space($linedbID)}.data_match" value=""></input>
										
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.tax_reg_no" id="Detail2.{normalize-space($linedbID)}.tax_reg_no" value="{$tax_reg_no}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.doc_no" id="Detail2.{normalize-space($linedbID)}.doc_no" value="{$doc_no}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.doc_date" id="Detail2.{normalize-space($linedbID)}.doc_date" value="{$doc_date}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.gs_code" id="Detail2.{normalize-space($linedbID)}.gs_code" value="{$gs_code}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.quantity" id="Detail2.{normalize-space($linedbID)}.quantity" value="{$quantity}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.rate" id="Detail2.{normalize-space($linedbID)}.rate" value="{$rate}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.taxable_amt" id="Detail2.{normalize-space($linedbID)}.taxable_amt" value="{$taxable_amt}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.line_no" id="Detail2.{normalize-space($linedbID)}.line_no" value="{$line_no}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.status" id="Detail2.{normalize-space($linedbID)}.status" value="{$status}"></input>
											<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.igst_perc" id="Detail2.{normalize-space($linedbID)}.igst_perc" value="{$igst_perc}"></input> -->
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.igst_amt" id="Detail2.{normalize-space($linedbID)}.igst_amt" value="{$igst_amt}"></input>
											<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.cgst_perc" id="Detail2.{normalize-space($linedbID)}.cgst_perc" value="{$cgst_perc}"></input> -->
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cgst_amt" id="Detail2.{normalize-space($linedbID)}.cgst_amt" value="{$cgst_amt}"></input>
											<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.scgt_perc" id="Detail2.{normalize-space($linedbID)}.scgt_perc" value="{$scgt_perc}"></input> -->
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.sgst_amt" id="Detail2.{normalize-space($linedbID)}.sgst_amt" value="{$sgst_amt}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cess_perc" id="Detail2.{normalize-space($linedbID)}.cess_perc" value="{$cess_perc}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cess_amt" id="Detail2.{normalize-space($linedbID)}.cess_amt" value="{$cess_amt}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.gst_code" id="Detail2.{normalize-space($linedbID)}.gst_code" value="{$gst_code}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.itc_type" id="Detail2.{normalize-space($linedbID)}.itc_type" value="{$itc_type}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.itc_igst" id="Detail2.{normalize-space($linedbID)}.itc_igst" value="{$itc_igst}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.itc_cgst" id="Detail2.{normalize-space($linedbID)}.itc_cgst" value="{$itc_cgst}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.itc_sgst" id="Detail2.{normalize-space($linedbID)}.itc_sgst" value="{$itc_sgst}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.itc_cess" id="Detail2.{normalize-space($linedbID)}.itc_cess" value="{$itc_cess}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.gst_rate" id="Detail2.{normalize-space($linedbID)}.gst_rate" value="{$gst_rate}"></input>
										
										
										<!-- added by kaustubh on 28 sep 2017 -->
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cust_code" id="Detail2.{normalize-space($linedbID)}.cust_code" value="{$cust_code}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.amount" id="Detail2.{normalize-space($linedbID)}.amount" value="{$amount}"></input>	
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.reverse_chrg" id="Detail2.{normalize-space($linedbID)}.reverse_chrg" value="{$reverse_chrg}"></input>	
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.reas_code" id="Detail2.{normalize-space($linedbID)}.reas_code" value="{$reas_code}"></input>	
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.gst_type" id="Detail2.{normalize-space($linedbID)}.gst_type" value="{$gst_type}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.prd_code" id="Detail2.{normalize-space($linedbID)}.prd_code" value="{$prd_code}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cust_code" id="Detail2.{normalize-space($linedbID)}.cust_code" value="{$cust_code}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cust_name" id="Detail2.{normalize-space($linedbID)}.cust_name" value="{$cust_name}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.lr_no" id="Detail2.{normalize-space($linedbID)}.lr_no" value="{$lr_no}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.lr_date" id="Detail2.{normalize-space($linedbID)}.lr_date" value="{$lr_date}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.reas_code" id="Detail2.{normalize-space($linedbID)}.reas_code" value="{$reas_code}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.ecom_reg_no" id="Detail2.{normalize-space($linedbID)}.ecom_reg_no" value="{$ecom_reg_no}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.gst_code" id="Detail2.{normalize-space($linedbID)}.gst_code" value="{$gst_code}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.gst_type" id="Detail2.{normalize-space($linedbID)}.gst_type" value="{$gst_type}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.order_no" id="Detail2.{normalize-space($linedbID)}.order_no" value="{$order_no}"></input>
										
										
											
											
										</xsl:for-each>
									</tbody>
								  </table>
								</span>
								
								<!-- <span style="display:inline-block;height:72px;border:1px solid #dadada;"></span> -->
								
								<span id ="" style = "display:inline-block;width:63px;overflow-x:scroll;border-right:1px solid #dadada;" >
								  <table id ="" class="tableClass">
									<thead class="table-head">
										<tr>
											<th nowrap="true"  style = "text-align:center">
												VS
											</th>
										</tr>
									</thead>
									<tbody class="table-body">
										<xsl:for-each select="gstr1">
											<xsl:variable name="linedbID"><xsl:value-of select="@domID"/></xsl:variable>
											<tr class='trClass' ondblclick="showGSTRData('{$linedbID}')" >
												<td nowrap="true" style = "text-align:center">
													<!-- <Input type='checkbox' class="" name="selectbox" id="selectbox"  style = "visibility:hidden"
													 value="true" tabindex="-1"  /> -->
													  <div style="height:19px;line-height:31px;">
													 <img src="" id = "misMatch.{$soDbID}.{$linedbID}" alt="Match Found"  style = "visibility:hidden;height:17px;margin:1px;"></img>
													 </div>
												</td>
											</tr>	
										</xsl:for-each>
									</tbody>
								  </table>
								</span>
								
								<span id ="spanGSTR2_{$soDbID}" style = "display:inline-block;width:calc(50% - 33px);overflow-x:scroll" onscroll="scrollGstrData('spanGSTR1_{$soDbID}','spanGSTR2_{$soDbID}')">
								  <table id ="details_GST{$soDbID}" class="tableClass">
									<thead class="table-head">
										<!-- <tr>
											<th nowrap="true" style="border-left:0px solid black !important;" >
											<Input id='selectAll{$soDbID}' type='checkbox' name='selectAll' custId='{$custDbID}' tableId='{$soDbID}' onClick="checkAll('{$custDbID}','details{$soDbID}','{$soDbID}')"/>
											</th>
											<th nowrap="true">Sr No</th>
											<th nowrap="true">Status</th>
											<th nowrap="true">IGST(%)</th>
											<th nowrap="true">IGST Amount</th>
											<th nowrap="true">CGST(%)</th>
											<th nowrap="true">CGST Amount</th>
											<th nowrap="true">SCGT(%)</th>
											<th nowrap="true">SCGT Amount</th>
											<th nowrap="true">CESS(%)</th>
											<th nowrap="true">CESS Amount</th>
											
											<th nowrap="true" style = "display:none">GSTIN</th>
											<th nowrap="true" style = "display:none">Invoice No</th>
											<th nowrap="true" style = "display:none">Invoice Date</th>
											<th nowrap="true" style = "display:none">HSN/SAC</th>
											<th nowrap="true" style = "display:none">Quantity</th>
											<th nowrap="true" style = "display:none">Rate</th>
											<th nowrap="true" style = "display:none">Taxable Amount</th>
											
											<th nowrap="true">GST CODE</th>
											<th nowrap="true">ITC TYPE</th>
											<th nowrap="true">ITC IGST</th>
											<th nowrap="true">ITC CGST</th>
											<th nowrap="true">ITC SGST</th>
											<th nowrap="true">ITC CESS</th>
											<th nowrap="true">GST RATE</th>
											
										</tr> -->
										
										<tr>
											<th nowrap="true" style="border-left:0px solid black !important;" >
											<Input id='selectAll{$soDbID}' type='checkbox' name='selectAll' custId='{$custDbID}' tableId='{$soDbID}' onClick="checkAll('{$custDbID}','details{$soDbID}','{$soDbID}')"/>
											</th>
											<th nowrap="true">Sr No</th>
											<th nowrap="true">Customer Code </th>
											<th nowrap="true">Amount</th>
											<th nowrap="true">Reverse Charge</th>
											<th nowrap="true">Reason Code</th>
											<th nowrap="true">Order No</th>
											<th nowrap="true">Tran Type</th>
											<th nowrap="true">Remarks</th>
											<th nowrap="true">GST CODE</th>
											<th nowrap="true">GST TYPE</th>
											<!-- <th nowrap="true">CGST Amount</th>
											<th nowrap="true">SCGT(%)</th>
											<th nowrap="true">SCGT Amount</th>
											<th nowrap="true">CESS(%)</th>
											<th nowrap="true">CESS Amount</th> -->
											
											<th nowrap="true" style = "display:none">GSTIN</th>
											<th nowrap="true" style = "display:none">Invoice No</th>
											<th nowrap="true" style = "display:none">Invoice Date</th>
											<th nowrap="true" style = "display:none">HSN/SAC</th>
											<th nowrap="true" style = "display:none">Quantity</th>
											<th nowrap="true" style = "display:none">Rate</th>
											<th nowrap="true" style = "display:none">Taxable Amount</th>
											
											
											<!-- <th nowrap="true">ITC IGST</th>
											<th nowrap="true">ITC CGST</th>
											<th nowrap="true">ITC SGST</th>
											<th nowrap="true">ITC CESS</th>
											<th nowrap="true">GST RATE</th> -->
											
										</tr>
										
									</thead>
									<tbody class="table-body">
										<xsl:for-each select="gstr2">
										<xsl:variable name="linedbID"><xsl:value-of select="@domID"/></xsl:variable>
										<xsl:variable name="tran_id"><xsl:value-of select="tran_id"/></xsl:variable>
										<xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>
										<xsl:variable name="status"><xsl:value-of select=" status"/></xsl:variable>
										<!-- <xsl:variable name="igst_perc"><xsl:value-of select="igst_perc"/></xsl:variable> -->
										<xsl:variable name="igst_amt"><xsl:value-of select="igst_amt"/></xsl:variable>
										<!-- <xsl:variable name="cgst_perc"><xsl:value-of select="cgst_perc"/></xsl:variable> -->
										<xsl:variable name="cgst_amt"><xsl:value-of select="cgst_amt"/></xsl:variable>
										<!-- <xsl:variable name="scgt_perc"><xsl:value-of select="scgt_perc"/></xsl:variable> -->
										<xsl:variable name="sgst_amt"><xsl:value-of select="sgst_amt"/></xsl:variable>
										<xsl:variable name="cess_perc"><xsl:value-of select="cess_perc"/></xsl:variable>
										<xsl:variable name="cess_amt"><xsl:value-of select="cess_amt"/></xsl:variable>
										
										<xsl:variable name="tax_reg_no"><xsl:value-of select="tax_reg_no"/></xsl:variable>
										<xsl:variable name="doc_no"><xsl:value-of select="doc_no"/></xsl:variable>
										<xsl:variable name="doc_date"><xsl:value-of select="doc_date"/></xsl:variable>
										<xsl:variable name="gs_code"><xsl:value-of select="gs_code"/></xsl:variable>
										<xsl:variable name="quantity"><xsl:value-of select="quantity"/></xsl:variable>
										<xsl:variable name="rate"><xsl:value-of select="rate"/></xsl:variable>
										<xsl:variable name="taxable_amt"><xsl:value-of select="taxable_amt"/></xsl:variable>
										
										<xsl:variable name="gst_code"><xsl:value-of select="gst_code"/></xsl:variable>
										<xsl:variable name="itc_type"><xsl:value-of select="itc_type"/></xsl:variable>
										<xsl:variable name="itc_igst"><xsl:value-of select="itc_igst"/></xsl:variable>
										<xsl:variable name="itc_cgst"><xsl:value-of select="itc_cgst"/></xsl:variable>
										<xsl:variable name="itc_sgst"><xsl:value-of select="itc_sgst"/></xsl:variable>
										<xsl:variable name="itc_cess"><xsl:value-of select="itc_cess"/></xsl:variable>
										<xsl:variable name="gst_rate"><xsl:value-of select="gst_rate"/></xsl:variable>
										
										
										<xsl:variable name="cust_code"><xsl:value-of select="cust_code"/></xsl:variable>
										<xsl:variable name="order_no"><xsl:value-of select="order_no"/></xsl:variable>
										<xsl:variable name="amount"><xsl:value-of select="amount"/></xsl:variable>
										<xsl:variable name="reverse_chrg"><xsl:value-of select="reverse_chrg"/></xsl:variable>
										<xsl:variable name="reas_code"><xsl:value-of select="reas_code"/></xsl:variable>
										<xsl:variable name="gst_type"><xsl:value-of select="gst_type"/></xsl:variable>
										<xsl:variable name="cust_code"><xsl:value-of select="cust_code"/></xsl:variable>
										<xsl:variable name="prd_code"><xsl:value-of select="prd_code"/></xsl:variable>
										<xsl:variable name="cust_name"><xsl:value-of select="cust_name"/></xsl:variable>
										<xsl:variable name="lr_no"><xsl:value-of select="lr_no"/></xsl:variable>
										<xsl:variable name="lr_date"><xsl:value-of select="lr_date"/></xsl:variable>
										<xsl:variable name="reas_code"><xsl:value-of select="reas_code"/></xsl:variable>
										<xsl:variable name="ecom_reg_no"><xsl:value-of select="ecom_reg_no"/></xsl:variable>
										<xsl:variable name="gst_code"><xsl:value-of select="gst_code"/></xsl:variable>
										
										<!--<input type="hidden" id="Detail2.{normalize-space($linedbID)}.tran_id__gstn" name="Detail2.{normalize-space($linedbID)}.tran_id__gstn" value="{$tran_id}"></input>-->
										
										<xsl:choose>
										    <xsl:when test="line_no">
												<tr class='trClass' id="{$linedbID}" onclick="setCheckboxRow(event,this,{$soDbID},'{$custDbID}','details{$soDbID}');" 
													ondblclick="showGSTRData('{$linedbID}')" >
													<td nowrap="true" style="border-left:0px solid black !important;">
														<!-- <Input type='checkbox' value="true" class="selectAll{$soDbID}" name="Detail2.{normalize-space($linedbID)}.selectbox" id="Detail2.{normalize-space($linedbID)}.selectbox" onclick="setCheckbox(this,'{$linedbID}','{$soDbID}','{$custDbID}','details{$soDbID}');" tabindex="-1" /> -->
														<Input type='checkbox' class="selectAll{$soDbID}" name="selectbox" id="selectbox"  style = "visibility:hidden"
														 onclick = "setChecked(this,'{$linedbID}')" value="true" tabindex="-1"  />
													</td>
													<!-- <td nowrap="true">
														<xsl:value-of select="line_no"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="status"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="igst_perc"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="igst_amt"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="cgst_perc"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="cgst_amt"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="scgt_perc"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="sgst_amt"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="cess_perc"/>
													</td>
													<td nowrap="true">
														<xsl:value-of select="cess_amt"/>
													</td>
													
													
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="tax_reg_no"/>
													</td>
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="doc_no"/>
													</td>
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="doc_date"/>
													</td>
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="gs_code"/>
													</td>
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="quantity"/>
													</td>
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="rate"/>
													</td>
													<td nowrap="true" style = "display:none">
														<xsl:value-of select="taxable_amt"/>
													</td>
													
													<td nowrap="true" >
														<xsl:value-of select="gst_code"/>
													</td>
													<td nowrap="true" >
														<xsl:value-of select="itc_type"/>
													</td>
													<td nowrap="true" >
														<xsl:value-of select="itc_igst"/>
													</td>
													<td nowrap="true" >
														<xsl:value-of select="itc_cgst"/>
													</td>
													<td nowrap="true" >
														<xsl:value-of select="itc_sgst"/>
													</td>
													<td nowrap="true" >
														<xsl:value-of select="itc_cess"/>
													</td>
													<td nowrap="true" >
														<xsl:value-of select="gst_rate"/>
													</td> -->
													
													
													<td nowrap="true">
														<xsl:value-of select="line_no"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="cust_code"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="amount"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="reverse_chrg"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="reverse_chrg"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="reas_code"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="gst_code"/>
													</td>
													
													<td nowrap="true">
														<xsl:value-of select="gst_type"/>
													</td>
														
													
													
												</tr>
										 	</xsl:when>
											<xsl:otherwise>
											        <tr id="{$linedbID}" ondblclick="showGSTRData('{$linedbID}')">
											        	<td nowrap="true" style="border-left:0px solid black !important;">
															<Input type='checkbox' class="selectAll{$soDbID}" name="selectbox" id="selectbox"
															 onclick = "setChecked(this)" value="false" tabindex="-1" disabled = "true" style = "visibility:hidden" />
														</td>
														<td colspan = "17">
															Downloaded data not found for this record
														</td>
											        </tr>
											</xsl:otherwise>
										 </xsl:choose> 
										 
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.tran_id__gstn" id="Detail2.{normalize-space($linedbID)}.tran_id__gstn" value="{$tran_id}"></input>
						
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.tax_reg_no__gstr" id="Detail2.{normalize-space($linedbID)}.tax_reg_no__gstr" value="{$tax_reg_no}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.doc_no" id="Detail2.{normalize-space($linedbID)}.doc_no__gstr" value="{$doc_no}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.doc_date" id="Detail2.{normalize-space($linedbID)}.doc_date__gstr" value="{$doc_date}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.gs_code__gstr" id="Detail2.{normalize-space($linedbID)}.gs_code__gstr" value="{$gs_code}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.quantity__gstr" id="Detail2.{normalize-space($linedbID)}.quantity__gstr" value="{$quantity}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.rate__gstr" id="Detail2.{normalize-space($linedbID)}.rate__gstr" value="{$rate}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.taxable_amt__gstr" id="Detail2.{normalize-space($linedbID)}.taxable_amt__gstr" value="{$taxable_amt}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.line_no__gstr" id="Detail2.{normalize-space($linedbID)}.line_no__gstr" value="{$line_no}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.status__gstr" id="Detail2.{normalize-space($linedbID)}.status__gstr" value="{$status}"></input>
											<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.igst_perc__gstr" id="Detail2.{normalize-space($linedbID)}.igst_perc__gstr" value="{$igst_perc}"></input> -->
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.igst_amt__gstr" id="Detail2.{normalize-space($linedbID)}.igst_amt__gstr" value="{$igst_amt}"></input>
											<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.cgst_perc__gstr" id="Detail2.{normalize-space($linedbID)}.cgst_perc__gstr" value="{$cgst_perc}"></input> -->
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cgst_amt__gstr" id="Detail2.{normalize-space($linedbID)}.cgst_amt__gstr" value="{$cgst_amt}"></input>
											<!-- <input type="hidden" name="Detail2.{normalize-space($linedbID)}.scgt_perc__gstr" id="Detail2.{normalize-space($linedbID)}.scgt_perc__gstr" value="{$scgt_perc}"></input> -->
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.sgst_amt__gstr" id="Detail2.{normalize-space($linedbID)}.sgst_amt__gstr" value="{$sgst_amt}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cess_perc__gstr" id="Detail2.{normalize-space($linedbID)}.cess_perc__gstr" value="{$cess_perc}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cess_amt__gstr" id="Detail2.{normalize-space($linedbID)}.cess_amt__gstr" value="{$cess_amt}"></input>
											
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.gst_code__gstr" id="Detail2.{normalize-space($linedbID)}.gst_code__gstr" value="{$gst_code}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.itc_type__gstr" id="Detail2.{normalize-space($linedbID)}.itc_type__gstr" value="{$itc_type}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.itc_igst__gstr" id="Detail2.{normalize-space($linedbID)}.itc_igst__gstr" value="{$itc_igst}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.itc_cgst__gstr" id="Detail2.{normalize-space($linedbID)}.itc_cgst__gstr" value="{$itc_cgst}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.itc_sgst__gstr" id="Detail2.{normalize-space($linedbID)}.itc_sgst__gstr" value="{$itc_sgst}"></input>
											<input type="hidden" name="Detail2.{normalize-space($linedbID)}.itc_cess__gstr" id="Detail2.{normalize-space($linedbID)}.itc_cess__gstr" value="{$itc_cess}"></input>
                                            <input type="hidden" name="Detail2.{normalize-space($linedbID)}.gst__rate" id="Detail2.{normalize-space($linedbID)}.gst_rate" value="{$gst_rate}"></input>
                                            
                                            
                                            <!-- added by kaustubh on 29 sep 2017 -->
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cust_code__gstr" id="Detail2.{normalize-space($linedbID)}.cust_code__gstr" value="{$cust_code}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.amount__gstr" id="Detail2.{normalize-space($linedbID)}.amount__gstr" value="{$amount}"></input>	
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.reverse_chrg__gstr" id="Detail2.{normalize-space($linedbID)}.reverse_chrg__gstr" value="{$reverse_chrg}"></input>	
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.reas_code__gstr" id="Detail2.{normalize-space($linedbID)}.reas_code__gstr" value="{$reas_code}"></input>	
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.gst_type__gstr" id="Detail2.{normalize-space($linedbID)}.gst_type__gstr" value="{$gst_type}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.prd_code__gstr" id="Detail2.{normalize-space($linedbID)}.prd_code__gstr" value="{$prd_code}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cust_code__gstr" id="Detail2.{normalize-space($linedbID)}.cust_code__gstr" value="{$cust_code}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.cust_name__gstr" id="Detail2.{normalize-space($linedbID)}.cust_name__gstr" value="{$cust_name}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.lr_no__gstr" id="Detail2.{normalize-space($linedbID)}.lr_no__gstr" value="{$lr_no}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.lr_date__gstr" id="Detail2.{normalize-space($linedbID)}.lr_date__gstr" value="{$lr_date}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.reas_code__gstr" id="Detail2.{normalize-space($linedbID)}.reas_code__gstr" value="{$reas_code}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.ecom_reg_no__gstr" id="Detail2.{normalize-space($linedbID)}.ecom_reg_no__gstr" value="{$ecom_reg_no}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.gst_code__gstr" id="Detail2.{normalize-space($linedbID)}.gst_code__gstr" value="{$gst_code}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.gst_type__gstr" id="Detail2.{normalize-space($linedbID)}.gst_type__gstr" value="{$gst_type}"></input>
										<input type="hidden" name="Detail2.{normalize-space($linedbID)}.order_no__gstr" id="Detail2.{normalize-space($linedbID)}.order_no__gstr" value="{$order_no}"></input>
										
                                            
                                            
                                            
                                            
                                            <xsl:variable name="cust_code"><xsl:value-of select="cust_code"/></xsl:variable>
										<xsl:variable name="amount"><xsl:value-of select="amount"/></xsl:variable>
										<xsl:variable name="reverse_chrg"><xsl:value-of select="reverse_chrg"/></xsl:variable>
										<xsl:variable name="reas_code"><xsl:value-of select="reas_code"/></xsl:variable>
										<xsl:variable name="gst_type"><xsl:value-of select="gst_type"/></xsl:variable>
                                            
                                            
                                            
										</xsl:for-each>
									</tbody>
								  </table>
								</span>
							</div>
						</xsl:for-each>
					</div>
				</xsl:if>
			</xsl:for-each>
		</div>
		<div id="btnDiv" style="width:100%;">
			<input type="hidden" value="2" name="FORM_NO" ID="FORM_NO" />
			<input type="hidden"  value="gstreco_wiz" name="OBJ_NAME" />
			<input type="hidden"  name="PRE_FORM_VAL" ID="PRE_FORM_VAL" />
			<input type="hidden"  value="gstWizUtilPage" name="JSP_NAME" />
			<input type="hidden" value="1:MP" name="formType" id="formType" />
			<input type="hidden"  value="finish" name="action" id="action" />
			<input type="button" style="margin-left:2px;" value="Previous" class="button" title="back" id="back" onclick="form2Previous();"/>
			<input type="submit" style="margin-left:2px;" value="Finish" class="button" title="finish" id="finish" onclick="return validateSubmit();setActionVal('finish');" />
		</div>
		
	</div>
	
	<div id="buttonreplacement">
		<img src="/ibase/images/preload.gif" alt="Please wait work in progress" ></img>
		<span>Please wait......</span>
	</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
