package ibase.webitm.ejb.wms;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.w3c.dom.Document;

@javax.ejb.Stateless

public class PoRcpPostSave extends ValidatorEJB implements PoRcpPostSaveLocal, PoRcpPostSaveRemote
{        
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String postSave( String domString, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		System.out.println("In PoRcpPostSave ... ");

		PreparedStatement pstmt = null,pstmtUpt =null;
		Document dom = null;                
		ResultSet rs =null;
		boolean isError = false;

		String tranId = "",sqlP ="",sql="",lineNo ="";
		double quantity=0,rate =0,discount =0,taxAmt = 0,netAmt = 0,frtAmt = 0,exchRateFrt = 0
		,insuranceAmt = 0,exchRateIns = 0,clearingCharges = 0,exchRateClr = 0
		,otherCharges = 0,exchRateOthch = 0,netAmtCal=0,tax=0,amt=0,discountCal=0,totalAddlCost=0 ,
		totalnetAmt=0,totaldiscount=0;
		int updtdet=0,updtPorcp=0;

		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();		
			dom = genericUtility.parseString(domString);

			System.out.println("DOM---->>["+genericUtility.serializeDom(dom).toString()+"]");

			tranId = genericUtility.getColumnValue("tran_id",dom);

			sql="SELECT QUANTITY__STDUOM , RATE__STDUOM , DISCOUNT , TAX_AMT ,LINE_NO FROM PORCPDET WHERE TRAN_ID= ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId );
			rs = pstmt.executeQuery();

			while (rs.next())
			{
				quantity = rs.getDouble("QUANTITY__STDUOM");
				rate = rs.getDouble("RATE__STDUOM");
				discount = rs.getDouble("DISCOUNT");
				taxAmt = rs.getDouble("TAX_AMT");
				lineNo = rs.getString("LINE_NO");

				/*System.out.println("quantity::::::"+quantity);
				System.out.println("rate:::::"+rate);
				System.out.println("discount:::::"+discount);
				System.out.println("taxAmt:::::"+taxAmt);
				System.out.println("lineNo:::::"+lineNo);*/

				netAmtCal=(( quantity * rate )-(( quantity * rate * discount )/100 )+ taxAmt );
				System.out.println("netAmtCal  :::::["+  netAmtCal + "]");
				totalnetAmt = totalnetAmt + netAmtCal;
				System.out.println("totalnetAmt  :::::["+  totalnetAmt + "]");

				discountCal =(( quantity * rate * discount )/100 );
				System.out.println("discountCal  :::::["+  discountCal + "]");
				totaldiscount = totaldiscount + discountCal;
				System.out.println("totaldiscount  :::::["+  totaldiscount + "]");

				sql=" UPDATE PORCPDET SET NET_AMT = ?  WHERE TRAN_ID=?  AND LINE_NO=  ? ";
				pstmtUpt=conn.prepareStatement(sql);
				pstmtUpt.setDouble(1,netAmtCal);
				pstmtUpt.setString(2,tranId);
				pstmtUpt.setString(3,lineNo);
				updtdet = pstmtUpt.executeUpdate();
				System.out.println("Update Record for PORCPDET["+updtdet+"]");
				if(pstmtUpt != null)
				{
					pstmtUpt.close();
					pstmtUpt = null;
				}

			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}

			sql="SELECT SUM(TAX_AMT) FROM PORCPDET WHERE TRAN_ID= ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				taxAmt = rs.getDouble(1);

				System.out.println("taxAmt:::::"+taxAmt);
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}


			sqlP=" SELECT FRT_AMT,EXCH_RATE__FRT,INSURANCE_AMT,EXCH_RATE__INS,CLEARING_CHARGES, EXCH_RATE__CLR, OTHER_CHARGES, EXCH_RATE__OTHCH FROM PORCP WHERE TRAN_ID= ? " ;
			pstmt = conn.prepareStatement(sqlP);
			pstmt.setString(1,tranId );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				frtAmt = rs.getDouble("FRT_AMT");
				exchRateFrt = rs.getDouble("EXCH_RATE__FRT");
				insuranceAmt = rs.getDouble("INSURANCE_AMT");
				exchRateIns = rs.getDouble("EXCH_RATE__INS");
				clearingCharges = rs.getDouble("CLEARING_CHARGES");
				exchRateClr = rs.getDouble("EXCH_RATE__CLR");
				otherCharges = rs.getDouble("OTHER_CHARGES");
				exchRateOthch = rs.getDouble("EXCH_RATE__OTHCH");

				/*System.out.println("frtAmt:::"+frtAmt);
				System.out.println("exchRateFrt:::::"+exchRateFrt);
				System.out.println("insuranceAmt:::::"+insuranceAmt);
				System.out.println("exchRateIns:::"+exchRateIns);
				System.out.println("clearingCharges:::::"+clearingCharges);
				System.out.println("exchRateClr:::::"+exchRateClr);
				System.out.println("otherCharges::::::"+otherCharges);
				System.out.println("exchRateOthch::::"+exchRateOthch);*/

			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}

			totalAddlCost=( frtAmt * exchRateFrt )+( insuranceAmt * exchRateIns )+( clearingCharges * exchRateClr )+( otherCharges * exchRateOthch );

			sqlP=" UPDATE PORCP SET TAX = ? ,AMOUNT = ? ,DISCOUNT = ?,TOTAL_ADDITIONAL_COST = ? "
				+" WHERE  TRAN_ID = ? ";

			pstmt = conn.prepareStatement(sqlP);
			pstmt.setDouble(1,taxAmt );
			pstmt.setDouble(2,totalnetAmt );
			pstmt.setDouble(3,totaldiscount);
			pstmt.setDouble(4,totalAddlCost);
			pstmt.setString(5,tranId);
			updtPorcp = pstmt.executeUpdate();
			System.out.println("Update Record for PORCP["+updtPorcp+"]");
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			System.out.println("taxAmt:::::"+taxAmt);
			System.out.println("amount:::"+totalnetAmt);
			System.out.println("totalAddlCost:::"+totalAddlCost);
		}

		catch(Exception e)
		{
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError="+isError);
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
				}

				if(pstmt != null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(rs != null)
				{
					rs.close();
					rs=null;
				}
				if(pstmtUpt != null)
				{
					pstmtUpt.close();
					pstmtUpt = null;
				}
			}
			catch(Exception e1)
			{
				throw new ITMException(e1);
			}
		}
		System.out.println("Out PoRcpPostSave ... ");
		return "";                
	}
}