package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.InwardSupplies;
import ibase.webitm.bean.gst.InwardSuppliesDetails;

public class InwardSuppliesSerailizer extends JsonSerializer<InwardSupplies>
{
	@Override
	public void serialize(InwardSupplies inwardSupplies, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
	{
		if(inwardSupplies != null)
		{
			json.writeStartObject();
			
			json.writeFieldName("isup_details");
			if(inwardSupplies.inwardSuppliesDetails != null)
			{
				json.writeStartArray();
				for(InwardSuppliesDetails eachData : inwardSupplies.inwardSuppliesDetails)
				{
					json.writeStartObject();
					json.writeStringField("ty", eachData.type);
					json.writeNumberField("inter", eachData.interSuppliesAmount);
					json.writeNumberField("intra", eachData.intraSuppliesAmount);
					json.writeEndObject();
				}
				json.writeEndArray();
			}
			
			json.writeEndObject();
		}
	}
}
