package ibase.dashboard.wms.servlet;

import ibase.dashboard.wms.ejb.StockRequirementRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;

public class StockDetailServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException
	{
		StockRequirementRemote stockrequirementRemote = null;
		InitialContext context           = null;
		AppConnectParm appConnectParm    = new AppConnectParm();
		String dataSourceName            = "";
		String loginCode                   = "";
		HttpSession session              = null;
		JSONObject jsonObjData           = null;
		OutputStream outputStream        = null;
		UserInfoBean userInfo            = null;
		String itemseries                    = "";
		try
		{
			
			response.setContentType("application/xml");
			session        = request.getSession(true);
			userInfo       = (UserInfoBean) session.getAttribute("USER_INFO");
			loginCode      = userInfo.getLoginCode();
			System.out.println("Login code: "+loginCode);
			dataSourceName = request.getParameter("dataSourceName");
			itemseries     = request.getParameter("itemseries");	
			context        = new InitialContext(appConnectParm.getProperty());
			stockrequirementRemote = (StockRequirementRemote) context.lookup("ibase/StockRequirement/remote");
			jsonObjData    = (JSONObject) stockrequirementRemote.getStockDetail(loginCode,dataSourceName,itemseries);
			outputStream   = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data inside StockRequirement which are build the Graph==="+ jsonObjData);

		}
		catch (Exception e)
		{
			System.out.println("Exception : StockRequirement :doPost(HttpServletRequest request, HttpServletResponse response) :"
							+ e);
			try
			{
				throw new ITMException(e);
			}
			catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}
