/*
 * Author:Manish Singh
 * Date:30-Apr-15
 * Request ID:D15AKAT019 (Site Specification Report)
 */

package ibase.webitm.ejb.wms;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class SiteSpecRptIC extends ValidatorEJB implements SiteSpecRptICLocal, SiteSpecRptICRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();	

	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = null;
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("Val xmlString :: " + xmlString);
			System.out.println("Val xmlString1 :: " + xmlString1);
			System.out.println("Val xmlString2 :: " + xmlString2);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException( e );
		}
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("wfValData.....called..");
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0,currentFormNo =0,childNodeListLength =0;
	    String userId="";
		String childNodeName = null,childNodeValue = null;
		String errString = "";
		String siteCode = "";
		int count = 0;
		int cnt = 0;
		String sql = "" ;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1 :
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();
					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{	
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						System.out.println("SiteSpecRpt_codechildNodeName.editFlag." + childNodeName+".." + editFlag);
						if(childNode.getFirstChild()!= null)
						{
							childNodeValue = childNode.getFirstChild().getNodeValue();
						}
		
						if(childNodeName.equalsIgnoreCase("SITE_CODE") )
						{
							if (childNode.getFirstChild() == null)
							{
								errString = getErrorString("SITE_CODE","VMSITENULL",userId);
								break ;
							}
							else
							{		
								 siteCode = genericUtility.getColumnValue("site_code",dom);
								 sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ?";
								 pstmt = conn.prepareStatement(sql);
								 pstmt.setString(1,siteCode);
								 rs = pstmt.executeQuery();
								 if( rs.next() )
								 {
									count = rs.getInt("COUNT");
								 }
								 if( count == 0 )
								 {
									 errString = getErrorString("SITE_CODE","VMSTCDNMST",userId);
									 break;
								 }
								 if(pstmt != null)
								 {
									 pstmt.close();
									 pstmt = null;									 
								 }
								 
								 if(rs != null)
								 {
									 rs.close();
									 rs = null;
								 }
								
							}
							
							
						}
						else if(childNodeName.equalsIgnoreCase("REPORT_NAME"))
						{
							if (childNode.getFirstChild() == null)
							{
								errString = getErrorString("REPORT_NAME","VMRPTNULL",userId);
								break ;
							}
						}
						
					}
					break;
				
			}//END SWITCH
			if(!"E".equalsIgnoreCase(editFlag))
			{
				siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));
				sql =" SELECT count(1) FROM SITE_SPEC_REPORT WHERE site_code=? " ;	
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, siteCode);
				rs1 = pstmt1.executeQuery();

				if(rs1.next())
				{
					cnt = rs1.getInt(1);
				}
				pstmt1.close();
				rs1.close();
				if(cnt != 0 )
				{	 
					errString = getErrorString("obj_name","VTEXIST",userId);
					return errString;
				}	
			}
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
			errString=e.getMessage();
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		System.out.println("ErrString ::"+errString);
		return errString;
	}
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1,
			String xmlString2, String objContext, String currentColumn,
			String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";		
		try
		{
			System.out.println("xmlString["+xmlString+"]");
			System.out.println("xmlString1["+xmlString1+"]");
			System.out.println("xmlString2["+xmlString2+"]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("xmlString["+xmlString+"]");
				
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 	
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
		
			valueXmlString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		
		return valueXmlString;
	}

	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException
	{
		Connection conn = null;
		int currentFormNo = 0;
		StringBuffer valueXmlString = new StringBuffer();
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength = 0;
		String childNodeName = "";
		String siteCode = "";
		int ctr = 0;
		String descr = "";
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = null;
		try
		{

			siteCode = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverValidator");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n" );

			switch ( currentFormNo )
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					valueXmlString.append( "<Detail1>\r\n" );
					childNodeListLength = childNodeList.getLength();
					do
					{   
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						ctr ++;
					}while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
					{
						valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
						sql = "SELECT descr FROM SITE WHERE SITE_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							descr = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						valueXmlString.append( "<site_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></site_descr>\r\n" );
					}
									
					else if( currentColumn.trim().equalsIgnoreCase( "site_code" ) )
					{
						siteCode = genericUtility.getColumnValue("site_code",dom);
						sql = "SELECT descr FROM SITE WHERE SITE_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							descr = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						valueXmlString.append( "<site_descr><![CDATA[" ).append( checkNull( descr) ).append( "]]></site_descr>\r\n" );
					}
					valueXmlString.append("</Detail1>\r\n");
					break;
				}	
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}			
		}
		
		valueXmlString.append( "</Root>\r\n" );	
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		
		return valueXmlString.toString();
	}
	private String checkNull( String input )
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}	

}
