package ibase.dashboard.wms.servlet;
import ibase.dashboard.wms.ejb.FGWarehouseRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class CreditComplianceDetailServlet extends HttpServlet
{
    private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		FGWarehouseRemote fgWarehouseRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String siteCode ="";
		String finEntity = "";
		String itemSer = "";
		String custCode = "";
		try
		{
			response.setContentType("application/xml");

			dataSourceName = request.getParameter("dataSourceName");
			siteCode = request.getParameter("siteCode");
			custCode = request.getParameter("custCode");
			finEntity = request.getParameter("finEntity");
			itemSer = request.getParameter("itemSer");
			
			
			context = new InitialContext(appConnectParm.getProperty());
			fgWarehouseRemote = (FGWarehouseRemote) context.lookup("ibase/FGWarehouse/remote");
			JSONObject jsonObjData = (JSONObject) fgWarehouseRemote.getCreditComplianceDetail(dataSourceName, siteCode,finEntity,itemSer,custCode);
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for CreditComplianceDetailServlet build the Graph is===" + jsonObjData);
		
			

		} catch (Exception e)
		{
			System.out.println("Exception : CreditComplianceDetailServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}