

/********************************************************
	Title : JvVal
	Date  : 26/07/2011
	Developer: Dipak Chattar

********************************************************/

package ibase.webitm.ejb.fin;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.util.*;
import java.io.*;
import java.util.Calendar;
import java.text.SimpleDateFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.DecimalFormat;
import java.sql.Timestamp;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.CDATASection;
import javax.ejb.Stateless; // added for ejb3


@Stateless // added for ejb3

public class JvVal extends ValidatorEJB implements JvValLocal, JvValRemote
{
	GenericUtility genericUtility = GenericUtility.getInstance();
	String winName = null;
	FinCommon finCommon = null;
	ValidatorEJB validator = null;
  
	//method for validation
   public String wfValData(String xmlString, String xmlString1, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	 {
	    String errString = "";
	    Document dom = null;
		Document dom1 = null;
		try
		{
		  System.out.println("Val xmlString :: " + xmlString);
		  System.out.println("Val xmlString1 :: " + xmlString1);
		  dom = parseString(xmlString);
		  dom1 = parseString(xmlString1);
		  errString = wfValData(dom, dom1, objContext, editFlag, xtraParams);
	    }
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	 }

   //method for validation
  public String wfValData(Document dom, Document dom1, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
	   NodeList parentNodeList = null;
	   NodeList childNodeList = null;
	   Node parentNode = null;
	   Node childNode = null;
	   int ctr=0;
	   int cnt = 0;
	   int pos = 0;
	   int currentFormNo = 0;
	   int refNoLen = 0;
	   int childNodeListLength;
	   int siteRevLen = 0;
	   boolean siteEmptyFlag = false;
	   boolean refEmptyFlag = false;
	   boolean revDateEmpFlag = false;
	   String errorType = "";
	   String objName = "";
	   String childNodeName = null;
	   String errString = "";
	   String errCode = "";
	   String userId = "";
	   String sql = "";
	   String fromDate = "";
	   String validUptoDate = "";
	   String siteCode = "";
	   String finEntity = "";
	   String refNo = "";
	   String refSer = "";
	   String reverSible = "";
	   String projectCode = "";
	   String acctCode = "";
	   String cctrCode = "";
	   String empCode = "";
       String analCode = "";
	   String sundryType = "";
	   String sundryCode = "";
	   String siteTrim = "";
	   String siteCRevTrim = "";
	   String siteCodeRev = "";
	   String siteCodeJv = "";
	   String currCode = "";
	   String tranDate = "";
	   String revDate = "";
	   Date tranPdate = null;
	   ArrayList<String> errList = new ArrayList<String>();
	   ArrayList<String> errFields = new ArrayList<String>();
	   Connection conn = null;
	   PreparedStatement pstmt = null ;
	   ResultSet rs = null;
	   ConnDriver connDriver = new ConnDriver();
       StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		
		try
		 {
		   finCommon = new FinCommon();
		   validator = new ValidatorEJB();
		   conn = connDriver.getConnectDB("DriverITM");
		   connDriver = null;
		   SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
           userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
		   
		   if(objContext != null && objContext.trim().length() > 0)
			{
			  currentFormNo = Integer.parseInt(objContext);
			}

			switch(currentFormNo)
			{
			 case 1 :parentNodeList = dom.getElementsByTagName("Detail1");
			         parentNode = parentNodeList.item(0);
					 childNodeList = parentNode.getChildNodes();
					 childNodeListLength = childNodeList.getLength();
					 for(ctr = 0; ctr < childNodeListLength; ctr ++)
					 {
					  childNode = childNodeList.item(ctr);
				      childNodeName = childNode.getNodeName();
					  
					  if(childNodeName.equalsIgnoreCase("site_code"))
                        {     
						      siteCode = genericUtility.getColumnValue("site_code", dom); 
							  if(siteCode == null || (siteCode.length() == 0))
						       {
						         errList.add("VMSITECOD");
							     errFields.add(childNodeName.toLowerCase());
                               }
							  if(siteCode != null && (siteCode.trim().length()!= 0))
							   {
						        sql = " select count(*) from site where site_code = ? ";
							    pstmt =  conn.prepareStatement(sql);
							    pstmt.setString(1,siteCode);
							    rs = pstmt.executeQuery();
							    if(rs.next())
							    {
								  cnt =  rs.getInt(1);
								  if(cnt == 0) 
								   {
									errCode = "VMSITE1";
									errList.add(errCode);
						            errFields.add(childNodeName.toLowerCase());	
								  }									
							     }
							     rs.close();
							     rs = null;
							     pstmt.close();
							     pstmt = null;
						      }
                              
							    
					    }

                      else if(childNodeName.equalsIgnoreCase("site_code__rev"))
						{ 
                         siteCodeRev = genericUtility.getColumnValue("site_code__rev", dom); 
						 siteCode = genericUtility.getColumnValue("site_code", dom);
						 if(siteCodeRev == null || (siteCodeRev.length() == 0))
						       {
						         errList.add("VMSITECOD");
							     errFields.add(childNodeName.toLowerCase());
                               }
                         if(siteCodeRev != null && (siteCodeRev.trim().length()!= 0) && siteCode.trim().equalsIgnoreCase(siteCodeRev.trim()))
							{
						       sql = " select count(*) from site where site_code = ? ";
							    pstmt =  conn.prepareStatement(sql);
							    pstmt.setString(1,siteCodeRev);
							    rs = pstmt.executeQuery();
							    if(rs.next())
							    {
								  cnt =  rs.getInt(1);
								  if(cnt == 0) 
								   {
									errCode = "VMSITE1";
									errList.add(errCode);
						            errFields.add(childNodeName.toLowerCase());	
								   }									
							    }
							       rs.close();
							       rs = null;
							       pstmt.close();
							       pstmt = null;
						    }
                              
						 else if((siteCodeRev != null) && (siteCode != null) && (!siteCode.trim().equalsIgnoreCase(siteCodeRev.trim())))
						   {
							 sql = "SELECT COUNT(*) FROM IBCA_PAY_CTRL WHERE SITE_CODE__FROM = ? AND SITE_CODE__TO = ?" ; 
                             System.out.println("sql [" + sql + "]");
							 System.out.println("siteCodeRev [" + siteCodeRev + "]");
							 pstmt = conn.prepareStatement(sql);
							 pstmt.setString(1,siteCode);
							 pstmt.setString(2,siteCodeRev);
						     rs = pstmt.executeQuery();
							 while(rs.next())
							  {	
							   cnt = rs.getInt(1);						
							  }									
									  
							 if(cnt == 0)
							   {
							    errCode = "VTNIBCA";
                                errList.add(errCode);
						        errFields.add(childNodeName.toLowerCase());
							   }	   
							 if(pstmt != null)
							  {
							    pstmt.close();
							  }
									
                            }
				        }   
						

                       else if(childNodeName.equalsIgnoreCase("tran_date"))
						 {
					       siteCode = genericUtility.getColumnValue("site_code", dom);
					       tranDate = genericUtility.getColumnValue("tran_date", dom);
						   try
						   {
							 tranPdate = simpleDateFormat.parse(tranDate);
                             errCode = validator.nfCheckPeriod("FIN",new java.util.Date(tranPdate.getTime()),siteCode);
						   }
						   catch (ParseException e)
						     {
							   System.out.println("Exception in transaction date [tran_date_validation]"+e);
                               e.printStackTrace();
                               throw new ITMException(e);
						    }
						   
                           if(errCode.trim().length() > 0)
							{
                             errList.add(errCode);
						     errFields.add(childNodeName.toLowerCase()); 
                            }
					   
					     }
                        


					   else if(childNodeName.equalsIgnoreCase("fin_entity"))
                         {     
						   finEntity = genericUtility.getColumnValue("fin_entity", dom); 
						   if(finEntity != null && (finEntity.trim().length()!= 0))
							 {
						       sql = "SELECT COUNT(*) FROM FINENT WHERE FIN_ENTITY = ?";
							   pstmt =  conn.prepareStatement(sql);
							   pstmt.setString(1,finEntity);
							   rs = pstmt.executeQuery();
							   if(rs.next())
							   {
								cnt =  rs.getInt(1);
								if(cnt == 0) 
								 {
									errCode = "VMFENTY1";
									errList.add(errCode);
						            errFields.add(childNodeName.toLowerCase());   
								 }									
							   }
							   rs.close();
							   rs = null;
							   pstmt.close();
							   pstmt = null;
							 }
                              
                              
						 } 

                      else if(childNodeName.equalsIgnoreCase("ref_no"))
						  
						 { 
						   refNo = genericUtility.getColumnValue("ref_no", dom); 
						   refSer = genericUtility.getColumnValue("ref_ser", dom); 
					       if(refNo!= null && (refNo.trim().length() > 0))
							{
							  sql = "SELECT COUNT(*) FROM GLTRACE WHERE REF_ID = ? AND REF_SER = ?";
							  System.out.println("sql [" + sql + "]");
							  System.out.println("refNo [" + refNo + "]");
							  pstmt = conn.prepareStatement(sql);
							  pstmt.setString(1,refNo);
							  pstmt.setString(2, refSer);
							  rs = pstmt.executeQuery();
							  while(rs.next())
							   {	
							    cnt = rs.getInt(1);						
							   }									
									  
							  if(cnt == 0)
								{
							     errCode = "VTREF4";
                                 errList.add(errCode);
						         errFields.add(childNodeName.toLowerCase());
								}
									   
							  if(pstmt != null)
							   {
							    pstmt.close();
							   }
							}
						  }    

                      else if(childNodeName.equalsIgnoreCase("reversible"))
					    { 
						   reverSible = genericUtility.getColumnValue("reversible", dom); 
                           revDate = genericUtility.getColumnValue("rev_date", dom); 
						   tranDate = genericUtility.getColumnValue("tran_date", dom);
						   if("Y".equalsIgnoreCase(reverSible))
							{
                             if(revDate == null)
							   {
								 errCode = "VTJOUR1";
							     errList.add(errCode);
								 errFields.add(childNodeName.toLowerCase());
							    }
							  else if( (revDate != null && tranDate !=null ) && (simpleDateFormat.parse( revDate ).before( simpleDateFormat.parse( tranDate ) )))
							    {
								  errCode = "VTJOUR2";
							      errList.add(errCode);
								  errFields.add(childNodeName.toLowerCase());
							    }
						     }
						   }

                      else if(childNodeName.equalsIgnoreCase( "curr_code"))
						 {
						   if(childNode.getFirstChild() != null)
							 {
							   currCode =genericUtility.getColumnValue("curr_code", dom); 
                               
							   if(currCode== null || (currCode.trim().length() == 0))
								{
							      errCode = "VTCURRCD2";
							      errList.add(errCode);
								  errFields.add(childNodeName.toLowerCase());
							    }

							       sql = "SELECT COUNT(*) FROM CURRENCY WHERE CURR_CODE = ?";
							       System.out.println("sql [" + sql + "]");
							       System.out.println("columnValue [" + currCode + "]");
							       pstmt = conn.prepareStatement(sql);
							       pstmt.setString(1,currCode);
							       rs = pstmt.executeQuery();
							       while(rs.next())
								   {	
								    cnt = rs.getInt(1);
								   }
									
							       if(cnt == 0)
								    {
								     errCode = "VTCURRCD1";
                                     errList.add(errCode);
						             errFields.add(childNodeName.toLowerCase());
								    }
								 
							       if(pstmt != null)
								   {
								     pstmt.close();
								   }
								}
							
                             }

                      else if(childNodeName.equalsIgnoreCase("proj_code"))
						{     
						  projectCode = genericUtility.getColumnValue("proj_code", dom); 
						  if(projectCode!= null && (projectCode.trim().length() > 0 ))
							{
						     sql = "SELECT COUNT(*) FROM PROJECT WHERE PROJ_CODE = ?";
							 pstmt =  conn.prepareStatement(sql);
							 pstmt.setString(1,projectCode);
							 rs = pstmt.executeQuery();
							 if(rs.next())
							 {
							 	cnt =  rs.getInt(1);
								if(cnt == 0) 
								{
									errCode = "VMPROJ1";
									errList.add(errCode);
						            errFields.add(childNodeName.toLowerCase());
								}									
							 }
							 rs.close();
							 rs = null;
							 pstmt.close();
							 pstmt = null;
                           }
						   
						    
						}
                  }
                      break;
                   
			 case 2 : parentNodeList = dom.getElementsByTagName("Detail2");
			          parentNode = parentNodeList.item(0);
					  childNodeList = parentNode.getChildNodes();
					  childNodeListLength = childNodeList.getLength();
                      for(ctr = 0; ctr < childNodeListLength; ctr ++)
					  {
					   childNode = childNodeList.item(ctr);
					   childNodeName = childNode.getNodeName();
                       if(childNodeName.equalsIgnoreCase("acct_code"))
						 { 
						   siteCode = genericUtility.getColumnValue("site_code", dom); 
						   acctCode = genericUtility.getColumnValue("acct_code", dom); 
						   if(acctCode != null && (acctCode.trim().length() != 0 ))
							{
						     errCode = finCommon.isAcctCode(siteCode, acctCode, "", conn);
							}
							else
							 {
							  errCode = "VMACCTCD1";
							 }
						   
						    if(errCode != null && (errCode.trim()!= ""))
							{
							  errList.add(errCode);
						      errFields.add(childNodeName.toLowerCase());
							}
						     
						  }  

                         else if(childNodeName.equalsIgnoreCase("cctr_code"))
						   { 
							acctCode = genericUtility.getColumnValue("acct_code", dom);
						  	cctrCode = genericUtility.getColumnValue("cctr_code", dom);
							if(cctrCode == null || (cctrCode.trim().length() == 0 ))
							 {
							   errCode = "VMCCTRCD1";
							 }
							else
							   {
							    errCode = finCommon.isCctrCode(acctCode, cctrCode, "", conn);
							   }

							if(errCode != null && (errCode.trim()!= ""))
							 {
							   errList.add(errCode);
						       errFields.add(childNodeName.toLowerCase());
							 }
							  
						   }  

                        else if(childNodeName.equalsIgnoreCase("emp_code"))
						   { 
							 empCode = genericUtility.getColumnValue("emp_code", dom); 
							 siteCode = genericUtility.getColumnValue("site_code", dom);
							 refSer = genericUtility.getColumnValue("ref_ser", dom);
							 errCode = finCommon.isEmployee(siteCode, empCode, refSer, conn);
							 if(errCode != null && (errCode.trim()!= ""))
							  {
							   errList.add(errCode);
						       errFields.add(childNodeName.toLowerCase());
							  }
							   
						  }  

                        else if(childNodeName.equalsIgnoreCase("anal_code"))
						     { 
							  analCode = genericUtility.getColumnValue("anal_code", dom); 
							  acctCode = genericUtility.getColumnValue("acct_code", dom);
							  refSer = genericUtility.getColumnValue("ref_ser", dom);
                              errCode = finCommon.isAnalysis(acctCode, analCode, refSer, conn);
							  if(errCode != null && (errCode.trim()!= ""))
							   {
							     errList.add(errCode);
						         errFields.add(childNodeName.toLowerCase());
							   }
							   
							 } 
                        //added for validating JV Site Code
                        else if(getObjName(parentNode)!=null && (getObjName(parentNode).trim().equalsIgnoreCase("journal_oth_site")) && (childNodeName.equalsIgnoreCase("site_code__jv")))
                           {     
							  siteCodeJv = genericUtility.getColumnValue("site_code__jv", dom); 
							  if(siteCodeJv == null || (siteCodeJv.trim().length() == 0 ))
						       {
						         errList.add("VMSITECOD");
							     errFields.add(childNodeName.toLowerCase());
                               }
							  if(siteCodeJv != null && (siteCodeJv.trim().length()!= 0 ))
							   {
						        sql = " select count(*) from site where site_code = ? ";
							    pstmt =  conn.prepareStatement(sql);
							    pstmt.setString(1,siteCodeJv);
							    rs = pstmt.executeQuery();
							    if(rs.next())
							    {
								  cnt =  rs.getInt(1);
								  if(cnt == 0) 
								   {
									errCode = "VMSITE1";
									errList.add(errCode);
						            errFields.add(childNodeName.toLowerCase());
								  }									
							     }
							     rs.close();
							     rs = null;
							     pstmt.close();
							     pstmt = null;
						      }
                              
							    
						   }

                        else if(childNodeName.equalsIgnoreCase("sundry_type"))
						  { 
						    sundryType = genericUtility.getColumnValue("sundry_type", dom); 
							if(sundryType != null && (sundryType.trim().length())!= 0)
							  {
							    sql = "SELECT COUNT(*) FROM SUNDRY_TYPE WHERE SUNDRY_TYPE = ?";
							    pstmt =  conn.prepareStatement(sql);
							    pstmt.setString(1,sundryType);
							    rs = pstmt.executeQuery();
							    if(rs.next())
							    {
								 cnt =  rs.getInt(1);
								 if(cnt == 0) 
								  {
									errCode = "VTSUND4";
									errList.add(errCode);
						            errFields.add(childNodeName.toLowerCase());
								  }									
							     }
							      rs.close();
							      rs = null;
							      pstmt.close();
							      pstmt = null;
                              }
							   
							     
						  } 
                         
                        else if(childNodeName.equalsIgnoreCase("sundry_code"))
						  { 
						    
							sundryCode = genericUtility.getColumnValue("sundry_code", dom); 
							sundryType = genericUtility.getColumnValue("sundry_type", dom);
							siteCode = genericUtility.getColumnValue("site_code", dom);
							refSer = genericUtility.getColumnValue("ref_ser", dom);
							errCode = finCommon.isSundryCode(siteCode, sundryType, sundryCode, refSer, conn);
						    if(errCode != null && (errCode.trim()!= ""))
							 {
							   errList.add(errCode);
						       errFields.add(childNodeName.toLowerCase());
							 }
							  
			  			  } 
					
					    else if(childNodeName.equalsIgnoreCase("proj_code"))
                          {     
							projectCode = genericUtility.getColumnValue("proj_code", dom);
							if(projectCode!= null && (projectCode.trim().length() > 0))
							  {
							    sql = "SELECT COUNT(*) FROM PROJECT WHERE PROJ_CODE = ?";
							    pstmt =  conn.prepareStatement(sql);
							    pstmt.setString(1,projectCode);
							    rs = pstmt.executeQuery();
							    if(rs.next())
							    {
							 	  cnt =  rs.getInt(1);
								  if(cnt == 0) 
								  {
									errCode = "VMPROJ1";
									errList.add(errCode);
						            errFields.add(childNodeName.toLowerCase());	
								  }									
							   }
							    rs.close();
							    rs = null;
							    pstmt.close();
							    pstmt = null;
							  }
							   
							    
						  }

					   }
					   break;
        
		    } //end switch
			
		    int errListSize = errList.size();
		    cnt = 0;
		    String errFldName = null;
		    if(errList != null && errListSize > 0)
			 {
		      for(cnt = 0; cnt < errListSize; cnt ++)
			  {
			    errCode = errList.get(cnt);
			    errFldName = errFields.get(cnt);
				System.out.println("errCode .........." + errCode);
			    errString = getErrorString(errFldName, errCode, userId);
			    errorType =  errorType(conn , errCode);
				if(errString.length() > 0)
				 {
				   String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
				   bifurErrString = bifurErrString;
				   bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
				   errStringXml.append(bifurErrString);
				   errString = "";
				 }
					
			    if(errorType.equalsIgnoreCase("E"))
				 {
				   break;
				 }
			  }
				   errList.clear();
				   errList = null;
				   errFields.clear();
				   errFields = null;
				   errStringXml.append("</Errors> </Root> \r\n");
			}
		   else
			  {
			    errStringXml = new StringBuffer("");
			  }
		 }//end try
		
	   catch(Exception e)
		{
		  e.printStackTrace();
		  errString = e.getMessage();
		  throw new ITMException(e);
		}
		
	   finally
		{
		  try
		    {
			  if(conn != null)
			   {
				  if(rs != null) 
				  rs.close();
				  rs = null;
				  if(pstmt != null) 
				  pstmt.close();
				  pstmt = null;
				  conn.close();
				}
				 conn = null;
			} 
		  catch(Exception d)
			{
			  d.printStackTrace();
			  throw new ITMException(d);
			}
		}
		
		errString = errStringXml.toString();
		return errString;
	}//end of validation


// method for item change
   public String itemChanged(String xmlString, String xmlString1, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
	  Document dom = null;
	  Document dom1 = null;
	  String valueXmlString = "";
	  try
		{   
		  dom = parseString(xmlString);
		  dom1 = parseString(xmlString1);
		  valueXmlString = itemChanged(dom, dom1, objContext, currentColumn, editFlag, xtraParams);
		}
	  catch(Exception e)
		{
		  System.out.println("Exception : [JvVal][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
        return valueXmlString;
	}

	// method for item change
   public String itemChanged(Document dom, Document dom1, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
	  StringBuffer valueXmlString = new StringBuffer();
	  NodeList parentNodeList = null;
	  NodeList childNodeList = null;
	  Node parentNode = null;
	  Node childNode = null;
	  String childNodeName = null;
	  String columnValue = null;
	  String Col_name = "";
	  String siteCode = "";
	  String description = "";
	  String description1 = "";
	  String description2 = "";
	  String description3 = "";
	  String tranDate = "";
	  String siteCodeRev = "";
	  String reverSible = "";
	  String currCode = "";
	  String finEntity = "";
	  String tranId = "";
	  String projectCode = "";
	  String acctCode = "";
	  String sundryCode = "";
	  String sundryType = "";
	  String staTus = "";
	  String siteCodeFor = "";
	  String startTag = "";
	  String endTag = "";
	  String dateNow = "";
	  String objName = null;
	  int ctr = 0;
	  int cnt = 0;
	  int currentFormNo = 0;
	  Connection conn = null;
	  PreparedStatement pstmt = null;
	  ResultSet rs = null ;
	  GenericUtility genericUtility = GenericUtility.getInstance();
	  ConnDriver connDriver = new ConnDriver();
	  
	  try
		{   
		  conn = connDriver.getConnectDB("DriverITM");
		  conn.setAutoCommit(false);
		  connDriver = null;
		  Calendar currentDate = Calendar.getInstance();
		  SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
		  if(objContext != null && objContext.trim().length() > 0)
		   {
			 currentFormNo = Integer.parseInt(objContext);
		   }
		  valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
		  valueXmlString.append(editFlag).append("</editFlag> </header>");
		  valueXmlString.append("<Detail>");

		  switch(currentFormNo)
			{
			  case 1 : parentNodeList = dom.getElementsByTagName("Detail1");
					   parentNode = parentNodeList.item(0);
					   childNodeList = parentNode.getChildNodes();
					   ctr = 0;
					   int childNodeListLength = childNodeList.getLength();
					   do
					    {   
						 childNode = childNodeList.item(ctr);
						 childNodeName = childNode.getNodeName();
					   if(childNodeName.equals(currentColumn))
						{
							if(childNode.getFirstChild() != null)
							{
							  columnValue = childNode.getFirstChild().getNodeValue().trim();
							}
						}
					      ctr ++;
					    }while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));
				   
				       if(currentColumn.trim().equalsIgnoreCase("itm_default"))
					    {
						  siteCode =(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
                          dateNow = simpleDateFormat.format(currentDate.getTime());
                          valueXmlString.append("<tran_date>").append("<![CDATA[" + dateNow + "]]>").append("</tran_date>");
					      valueXmlString.append("<eff_date>").append("<![CDATA[" + dateNow + "]]>").append("</eff_date>");
                          valueXmlString.append("<site_code>").append("<![CDATA[" +  siteCode + "]]>").append("</site_code>");
                          valueXmlString.append("<rev_date protect = \"1\">").append("</rev_date>");
                          valueXmlString.append("<auto_rev protect = \"1\">").append("</auto_rev>");
                          valueXmlString.append("<site_code__rev protect = \"1\">").append("<![CDATA[" + siteCode + "]]>").append("</site_code__rev>");
                          valueXmlString.append("<site_code>").append("<![CDATA[" + getAbsString(siteCode) + "]]>").append("</site_code>");
					      setNodeValue(dom, "site_code", getAbsString(siteCode)); 
                          valueXmlString.append( "<site_code__close protect = \"1\">").append("</site_code__close>" );
                          valueXmlString.append( "<prd_code__fr protect = \"1\">").append("</prd_code__fr>");
                          valueXmlString.append( "<prd_code__to protect = \"1\">").append("</prd_code__to>");
                          valueXmlString.append( "<acct_code__fr protect = \"1\">").append("</acct_code__fr>");
					      valueXmlString.append( "<acct_code__to protect = \"1\">").append("</acct_code__to>");
                          if((getObjName(parentNode)!=null) && (getObjName(parentNode)!=null) && (getObjName(parentNode).trim().equalsIgnoreCase("journal_oth_site")))
							{
					          valueXmlString.append("<site_code__for protect = \"0\">").append("</site_code__for>");
							  valueXmlString.append("<site_descr_1 protect = \"1\">").append("</site_descr_1>");
                            }                   
	   					  else
						    {    
						        valueXmlString.append("<site_code__for protect = \"1\">").append("<![CDATA[" +  siteCode + "]]>").append("</site_code__for>");
								valueXmlString.append("<site_descr_1 protect = \"1\">").append("<![CDATA[" +  description + "]]>").append("</site_descr_1>");
							}
				        }//end of if

                       else if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
					    {
				          valueXmlString.append("<site_code__close protect = \"1\">").append("</site_code__close>");
					      valueXmlString.append("<prd_code__fr protect = \"1\">").append("</prd_code__fr>");
					      valueXmlString.append("<prd_code__to protect = \"1\">").append("</prd_code__to>");
					      valueXmlString.append("<acct_code__fr protect = \"1\">").append("</acct_code__fr>");
					      valueXmlString.append("<acct_code__to protect = \"1\">").append("</acct_code__to>"); 
					    }

                       else if(currentColumn.trim().equalsIgnoreCase("tran_date"))
					    {
				    	  tranDate = genericUtility.getColumnValue("tran_date", dom);
				    	  valueXmlString.append("<eff_date>").append("<![CDATA[" + tranDate + "]]>").append("</eff_date>");
					    } 

				       else if(currentColumn.trim().equalsIgnoreCase("site_code"))
					    {
				    	  siteCode = genericUtility.getColumnValue("site_code", dom);
				    	  description = findValue(conn, "descr" ,"site", "site_code", siteCode);
                          description1 = findValue(conn, "fin_entity" ,"site", "site_code", siteCode);
                          valueXmlString.append("<site_code__rev>").append("<![CDATA[" + siteCode + "]]>").append("</site_code__rev>");
						  valueXmlString.append("<site_b_descr>").append("<![CDATA[" + description + "]]>").append("</site_b_descr>");
						  valueXmlString.append("<site_descr>").append("<![CDATA[" + description + "]]>").append("</site_descr>");
						  valueXmlString.append( "<fin_entity>").append("<![CDATA[" + description1 + "]]>").append("</fin_entity>");
						  description2 = findValue(conn, "curr_code" ,"finent", "fin_entity", description1);
						  valueXmlString.append("<curr_code>").append("<![CDATA[" + description2 + "]]>").append("</curr_code>");
                          valueXmlString.append("<exch_rate protect = \"1\">").append("<![CDATA[" + 1 + "]]>").append("</exch_rate>");
						  siteCodeRev = genericUtility.getColumnValue("site_code__rev", dom);
                          description3 = findValue(conn, "link_type" ,"ibca_pay_ctrl", "site_code__from", "site_code__to", siteCode, siteCodeRev);
                          valueXmlString.append("<link_type>").append("<![CDATA[" + description3 + "]]>").append("</link_type>");
						  }

                       else if(currentColumn.trim().equalsIgnoreCase("site_code__rev"))
					    {
				    	 siteCodeRev = genericUtility.getColumnValue("site_code__rev", dom);
				    	 description = findValue(conn, "descr" , "site", "site_code", siteCodeRev);
                         valueXmlString.append("<site_b_descr>").append("<![CDATA[" + description + "]]>").append("</site_b_descr>");
						 description1 = findValue(conn, "link_type" , "ibca_pay_ctrl", "site_code__from", "site_code__to", siteCode, siteCodeRev);
						 valueXmlString.append("<link_type>").append("<![CDATA[" + description1 + "]]>").append("</link_type>");
					    }

                       else if(currentColumn.trim().equalsIgnoreCase("site_code__for"))
					    {
				    	 siteCodeFor = genericUtility.getColumnValue("site_code__for", dom);
				    	 description = findValue(conn, "descr" ,"site", "site_code", siteCodeFor);
                         valueXmlString.append("<site_descr_1>").append("<![CDATA[" + description + "]]>").append("</site_descr_1>");
					    }
				    
                       else if(currentColumn.trim().equalsIgnoreCase("reversible"))
					    {
				    	 reverSible = genericUtility.getColumnValue("reversible", dom);
						 siteCodeRev = genericUtility.getColumnValue("site_code__rev", dom);
						 if(reverSible.equalsIgnoreCase("Y"))
						  {
							tranDate = genericUtility.getColumnValue("tran_date", dom);
                            valueXmlString.append("<site_code__rev protect = \"0\">").append("<![CDATA[" + siteCodeRev + "]]>").append("</site_code__rev>");
							valueXmlString.append("<rev_date protect = \"0\">").append("</rev_date>");
							valueXmlString.append("<auto_rev protect = \"0\">").append("</auto_rev>");
                            valueXmlString.append("<rev_date>").append("<![CDATA[" + tranDate + "]]>").append("</rev_date>");  
						    staTus = genericUtility.getColumnValue("status", dom);
						    if(staTus.equalsIgnoreCase("A"))
						     {
						      valueXmlString.append("<status>").append("<![CDATA[" + "N" + "]]>").append("</status>");
						      valueXmlString.append("<auto_rev>").append("<![CDATA[" + "Y" + "]]>").append("</auto_rev>");
						     }
						  }
						 else
						   {
							valueXmlString.append("<rev_date protect = \"1\">").append("</rev_date>");
							valueXmlString.append("<site_code__rev protect = \"1\">").append("<![CDATA[" + siteCodeRev + "]]>").append("</site_code__rev>");
							valueXmlString.append("<auto_rev protect = \"1\">").append("</auto_rev>");
                            valueXmlString.append("<auto_rev>").append("<![CDATA[" + "N" + "]]>").append("</auto_rev>" );
					        valueXmlString.append("<status>").append("<![CDATA[" + "A" + "]]>").append("</status>" );
					       }	
					     }

                       else if(currentColumn.trim().equalsIgnoreCase("curr_code"))
					    {
				    	 currCode = genericUtility.getColumnValue("curr_code", dom);
                         finEntity = genericUtility.getColumnValue("fin_entity", dom);
				    	 description = findValue(conn, "std_exrt" , "currency", "curr_code", currCode);
					     description1 = findValue(conn, "curr_code" , "finent", "fin_entity", finEntity);
						 if((description1.trim()) == (currCode.trim()))
							 valueXmlString.append("<exch_rate protect = \"1\">").append("<![CDATA[" + description + "]]>").append ("</exch_rate>");
						 else
						    valueXmlString.append("<exch_rate protect = \"0\">").append("<![CDATA[" + description + "]]>").append ("</exch_rate>");
                        }
				   
                        valueXmlString.append("</Detail>");
		                break;
						

              case 2 : parentNodeList = dom.getElementsByTagName("Detail2");
					   parentNode = parentNodeList.item(0);
					   childNodeList = parentNode.getChildNodes();
					   ctr = 0;
					   String lineNo = "";
					   childNodeListLength = childNodeList.getLength();
					   do
					    {   
						 childNode = childNodeList.item(ctr);
						 childNodeName = childNode.getNodeName();
						 if(childNodeName.equals(currentColumn))
						  {
							if(childNode.getFirstChild() != null)
							{
							  columnValue = childNode.getFirstChild().getNodeValue().trim();
							}
						  }
						 ctr ++;
					    }while(ctr < childNodeListLength  && ! childNodeName.equals(currentColumn));

                       if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				        {   
					     int lineNum = 0;
					     lineNo = (genericUtility.getValueFromXTRA_PARAMS(xtraParams, "line_no"));
					     tranId = genericUtility.getColumnValue("tran_id", dom);
					     projectCode = genericUtility.getColumnValue("proj_code", dom);
					     lineNum = Integer.parseInt(lineNo);
                         if(lineNum > 0)
					     valueXmlString.append("<line_no>").append("<![CDATA[" + lineNo + "]]>").append("</line_no>");
                         valueXmlString.append("<tran_id>").append("<![CDATA[" + tranId + "]]>").append("</tran_id>");
					     valueXmlString.append("<proj_code>").append("<![CDATA[" +  projectCode + "]]>").append("</proj_code>");
					    }

                       else if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				        {
						  sundryType = genericUtility.getColumnValue("sundry_type", dom);
						  sundryCode = genericUtility.getColumnValue("sundry_code", dom);
					      if("C".equalsIgnoreCase(sundryType))
							{
					         description = findValue(conn, "cust_name" , "customer", "cust_code", sundryCode);
							}
						  else if("R".equalsIgnoreCase(sundryType))
					       {
					        description1 = findValue(conn, "first_name" , "strg_customer", "sc_code", sundryCode);
						    description2 = findValue(conn, "middle_name" , "strg_customer", "sc_code", sundryCode);
						    description3 = findValue(conn, "last_name" , "strg_customer", "sc_code", sundryCode);
                            description = description1.trim() + " " +  description2.trim() + "" + description3.trim();
					       }
                          else if("B".equalsIgnoreCase(sundryType))
					       {
					        description = findValue(conn, "bank_name" , "bank", "bank_code", sundryCode);
					       }
					      else if("E".equalsIgnoreCase(sundryType))
					       { 
                            description1 = findValue(conn, "emp_fname" , "employee", "emp_code", sundryCode);
						    description2 = findValue(conn, "emp_lname" , "employee", "emp_code", sundryCode);
                            description = description1.trim() + " " +  description2.trim();
					       }
                          else if("P".equalsIgnoreCase(sundryType))
					       { 
                            description = findValue(conn, "sp_name" ,"sales_pers", "sales_pers", sundryCode);
					       }
                          else if("T".equalsIgnoreCase(sundryType))
					       { 
                            description = findValue(conn, "tran_name" , "transporter", "tran_code", sundryCode);
					       }
					      else if("S".equalsIgnoreCase(sundryType))
					       { 
                            description = findValue(conn, "supp_name" , "supplier", "supp_code", sundryCode);
					       }
                          else if("X".equalsIgnoreCase(sundryType))
					       { 
                            description = findValue(conn, "tauth_name" , "tax_authority", "tauth_code", sundryCode);
					       }
                          else if("L".equalsIgnoreCase(sundryType))
					       { 
                            description = findValue(conn, "party_name" , "loanparty", "party_code", sundryCode);
					       }
					        
                           valueXmlString.append("<sundry_name>").append("<![CDATA[" + description + "]]>").append("</sundry_name>"); 
				        
				        }

                       else if(currentColumn.trim().equalsIgnoreCase("acct_code"))
				        {
					     acctCode = genericUtility.getColumnValue("acct_code", dom);
					     description = findValue(conn, "descr" , "accounts", "acct_code", acctCode);
                         valueXmlString.append("<accounts_descr>").append("<![CDATA[" + description + "]]>").append("</accounts_descr>");
				        }

				       else if(currentColumn.trim().equalsIgnoreCase("sundry_code"))
				        {
					      sundryType = genericUtility.getColumnValue("sundry_type", dom);
						  sundryCode = genericUtility.getColumnValue("sundry_code", dom);
					      if("C".equalsIgnoreCase(sundryType))
							{
					         description = findValue(conn, "cust_name" , "customer", "cust_code", sundryCode);
							}
						  else if("R".equalsIgnoreCase(sundryType))
					       {
					        description1 = findValue(conn, "first_name" , "strg_customer", "sc_code", sundryCode);
						    description2 = findValue(conn, "middle_name" , "strg_customer", "sc_code", sundryCode);
						    description3 = findValue(conn, "last_name" , "strg_customer", "sc_code", sundryCode);
                            description = description1.trim() + " " +  description2.trim() + "" + description3.trim();
					       }
                          else if("B".equalsIgnoreCase(sundryType))
					       {
					        description = findValue(conn, "bank_name" , "bank", "bank_code", sundryCode);
					       }
					      else if("E".equalsIgnoreCase(sundryType))
					       { 
                            description1 = findValue(conn, "emp_fname" , "employee", "emp_code", sundryCode);
						    description2 = findValue(conn, "emp_lname" , "employee", "emp_code", sundryCode);
                            description = description1.trim() + " " +  description2.trim();
					       }
                          else if("P".equalsIgnoreCase(sundryType))
					       { 
                            description = findValue(conn, "sp_name" ,"sales_pers", "sales_pers", sundryCode);
					       }
                          else if("T".equalsIgnoreCase(sundryType))
					       { 
                            description = findValue(conn, "tran_name" , "transporter", "tran_code", sundryCode);
					       }
					      else if("S".equalsIgnoreCase(sundryType))
					       { 
                            description = findValue(conn, "supp_name" , "supplier", "supp_code", sundryCode);
					       }
                          else if("X".equalsIgnoreCase(sundryType))
					       { 
                            description = findValue(conn, "tauth_name" , "tax_authority", "tauth_code", sundryCode);
					       }
                          else if("L".equalsIgnoreCase(sundryType))
					       { 
                            description = findValue(conn, "party_name" , "loanparty", "party_code", sundryCode);
					       }
					        
                           valueXmlString.append("<sundry_name>").append("<![CDATA[" + description + "]]>").append("</sundry_name>"); 
				        }

                         valueXmlString.append("</Detail>");	
		                 break;

            }
			           valueXmlString.append("</Root>");
		}
	  catch(Exception e)
		{
		  e.printStackTrace();
		  System.out.println("Exception ::"+ e.getMessage());
		  throw new ITMException(e);
		}
	  finally
		{
			try
			{
				if(conn != null)
				{
					if(pstmt != null)
					pstmt.close();
					if(rs != null)
					rs.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
				
			}
		   catch(Exception d)
			{
			    d.printStackTrace();
			}			
		}
		 return valueXmlString.toString();
	}	 


 private String findValue(Connection conn, String columnName ,String tableName, String columnName2, String value) throws  ITMException, RemoteException
	{

	  PreparedStatement pstmt = null ;
	  ResultSet rs = null ; 
	  String sql = "";
	  String findValue = "";

	  try
	   {			
		 sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"  = ?";

	     pstmt = conn.prepareStatement(sql);
		 pstmt.setString(1,value);
	     rs = pstmt.executeQuery();
	    	
	     if(rs.next())
	      {					
	    	findValue = rs.getString(columnName);
		  }
		 rs.close();
		 rs = null;
		 pstmt.close();
		 pstmt = null;	        
	   }
	  catch(Exception e)
		{
		  System.out.println("Exception in findValue ");
		  e.printStackTrace();
		  throw new ITMException(e); 
		}

	  System.out.println("returning String from findValue ");
	  return findValue;
	}


 private String findValue(Connection conn, String columnName, String tableName, String columnName1, String columnName2, String value1, String value2) throws  ITMException, RemoteException
	{

	  PreparedStatement pstmt = null ;
	  ResultSet rs = null ; 
	  String sql = "";
	  String findValue = "";

	  try
		{
		  sql = "SELECT " + columnName + " from " + tableName + " where " + columnName1 +"  = ?" + " and " + columnName2 +"  = ?";
		  pstmt = conn.prepareStatement(sql);
		  pstmt.setString(1,value1);
		  pstmt.setString(2,value2);
	      rs = pstmt.executeQuery();
	    	
	      if(rs.next())
	       {					
	    	 findValue = rs.getString(columnName);
		   }
		  rs.close();
		  rs = null;
		  pstmt.close();
		  pstmt = null;	        
		}
	  catch(Exception e)
		{
		  System.out.println("Exception in findValue ");
		  e.printStackTrace();
		  throw new ITMException(e); 
		}

	  System.out.println("returning String from findValue ");
	  return findValue;
	}


  private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
     
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		

		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

   public String getObjName(Node node) throws Exception
	 {
		String objName = null;
		NamedNodeMap attrMap = node.getAttributes();
		objName = attrMap.getNamedItem("objName").getNodeValue();
		return objName;
	}

    private static void setNodeValue(Document dom, String nodeName, String nodeVal) throws Exception
	  {
		Node tempNode = dom.getElementsByTagName(nodeName).item(0);

		if(tempNode != null)
		{
			if(tempNode.getFirstChild() == null)
			{
				CDATASection cDataSection = dom.createCDATASection(nodeVal);
				tempNode.appendChild(cDataSection);
			}
			else
			{
				tempNode.getFirstChild().setNodeValue(nodeVal);
			}
		}
		tempNode = null;
	  }	


   private static void setNodeValue(Document dom, String nodeName, double nodeVal) throws Exception
	  {
		setNodeValue(dom, nodeName, Double.toString(nodeVal));
	  }


   private static void setNodeValue(Document dom, String nodeName, int nodeVal) throws Exception
	  {
		setNodeValue(dom, nodeName, Integer.toString(nodeVal));
	  }


	private static String getAbsString(String str)
	  {
		return(str == null || str.trim().length() == 0 || "null".equalsIgnoreCase(str.trim()) ? "" : str.trim() );
	  }

}	
	