/*
*	PURPOSE : Inv Hold Generation
*	Author: Sandesh
*	Date:	30/08/11
*/
package ibase.webitm.ejb.dis;

import ibase.ejb.*;
import ibase.utility.*;
import ibase.system.config.*;
import ibase.utility.BaseLogger;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.utility.ITMException;
import ibase.utility.CommonConstants;

import java.lang.*;
import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import javax.ejb.*;
import java.text.*;
import java.util.*;

import javax.xml.parsers.*;
import org.w3c.dom.*;

public class InvHoldGen 
{
	public String generateHoldTrans( String lockCode, String refID, String refSer, String siteCode, ArrayList stockList, String xtraParams, Connection conn )throws RemoteException,ITMException
	{
		String sql = "";
		String confirmed = "";
		String itemCode = "";
		String locCode = "";
		String lotSl = "";
		String lotNo = "";
		String chgUser = "";
		String chgTerm = "";
		String retString = "";
		String tranId = "";
		java.sql.Timestamp chgDate = null,currDate = null;
		int lineNo = 0;

		boolean isError = false;

		PreparedStatement pstmtHold = null;
		PreparedStatement pstmtHolddet = null;
		PreparedStatement pstmtSel = null;
		ResultSet rsSel = null;
		java.util.Date date = null;

		
		try
		{
			if ( lockCode == null || lockCode.trim().length() == 0 )
			{
				return "";
			}
			conn.setAutoCommit(false);

			String holdInsertSql = "INSERT INTO INV_HOLD(TRAN_ID,TRAN_DATE,SITE_CODE,CONFIRMED,REF_ID,REF_SER,CHG_USER,CHG_DATE,CHG_TERM, LOCK_CODE) VALUES(?,?,?,?,?,?,?,?,?,?)";

			pstmtHold = conn.prepareStatement(holdInsertSql);

			String holddetInsertSql = "INSERT INTO INV_HOLD_DET(TRAN_ID,LINE_NO,ITEM_CODE,SITE_CODE,LOC_CODE,LOT_NO,LOT_SL,HOLD_STATUS)	VALUES(?,?,?,?,?,?,?,?)";

			pstmtHolddet = conn.prepareStatement(holddetInsertSql);
			GenericUtility genericUtility = GenericUtility.getInstance();

			chgDate = new java.sql.Timestamp( System.currentTimeMillis() );

			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			chgDate =	java.sql.Timestamp.valueOf(sdf.format(date).toString() + " 00:00:00.0");


			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );

			int updCnt = 0;

			tranId = generateTranId( "w_inv_hold", conn );

			pstmtHold.setString( 1, tranId );
			pstmtHold.setTimestamp( 2, currDate );
			pstmtHold.setString( 3, siteCode );
			pstmtHold.setString( 4, "N" );
			pstmtHold.setString( 5, refID );
			pstmtHold.setString( 6, refSer );
			pstmtHold.setString( 7, userId );
			pstmtHold.setTimestamp( 8, currDate );
			pstmtHold.setString( 9, chgTerm );
			pstmtHold.setString( 10, lockCode );

			updCnt = pstmtHold.executeUpdate();
			pstmtHold.clearParameters();
			
			if( updCnt > 0 )
			{					
				System.out.println( updCnt + " rows updated successfully" );
			}
			
			HashMap dataMap = new HashMap();

			for ( int ctr = 0; ctr < stockList.size(); ctr++ )
			{
				lineNo++;
				dataMap = (HashMap)stockList.get(ctr);
				
				itemCode = "";
				siteCode = "";
				locCode = "";
				lotNo = "";
				lotSl = "";
				
				if ( dataMap.get("item_code") != null )
				{
					itemCode = (String)dataMap.get("item_code");
				}
				if ( dataMap.get("site_code") != null )
				{
					siteCode = (String)dataMap.get("site_code");
				}
				if ( dataMap.get("loc_code") != null )
				{
					locCode = (String)dataMap.get("loc_code");
				}
				if ( dataMap.get("lot_no") != null )
				{
					lotNo = (String)dataMap.get("lot_no");
				}
				if ( dataMap.get("lot_sl") != null )
				{
					lotSl = (String)dataMap.get("lot_sl");
				}
				pstmtHolddet.setString( 1, tranId );
				pstmtHolddet.setInt( 2, lineNo );
				pstmtHolddet.setString( 3, itemCode );
				pstmtHolddet.setString( 4, siteCode );
				pstmtHolddet.setString( 5, locCode );
				pstmtHolddet.setString( 6, lotNo );
				pstmtHolddet.setString( 7, lotSl );
				pstmtHolddet.setString( 8, "H" );
				pstmtHolddet.addBatch();
				pstmtHolddet.clearParameters();
				dataMap.clear();
			}
			pstmtHolddet.executeBatch();
			pstmtHolddet.clearBatch();
		}
		catch(BatchUpdateException buex)
        {
			isError = true;
			retString = "ERROR";
			int [] updateCounts = buex.getUpdateCounts();
			for (int i = 0; i < updateCounts.length; i++)
			{
				System.err.println("  Statement " + i + ":" + updateCounts[i]);
			}
			System.err.println(" Message: " + buex.getMessage());
			System.err.println(" SQLSTATE: " + buex.getSQLState());
			System.err.println(" Error code: " + buex.getErrorCode());
			SQLException ex = buex.getNextException();
			while (ex != null)
			{ 
				System.err.println("SQL exception:");
				System.err.println(" Message: " + ex.getMessage());
				System.err.println(" SQLSTATE: " + ex.getSQLState());
				System.err.println(" Error code: " + ex.getErrorCode());
				ex = ex.getNextException();
			}
        }
		catch (Exception e)
		{
			isError = true;
			retString = "ERROR";
			System.out.println ( "Exception: InvHoldGen: " + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( !isError )
				{
					//conn.commit();
				}
				if ( rsSel !=null )
				{
					rsSel.close();
					rsSel = null;
				}
				if ( pstmtHold!=null )
				{
					pstmtHold.close();
					pstmtHold = null;
				}
				if ( pstmtHolddet!=null )
				{
					pstmtHolddet.close();
					pstmtHolddet = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception ::==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return retString;
	}

	private String generateTranId( String windowName, Connection conn )throws ITMException
    {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";
		String paySiteCode = "";
		String effectiveDate = "";

		java.sql.Date effDate = null;

		 try
         {
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
				//System.out.println("selSql :"+selSql);
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
					keyString = rs.getString("KEY_STRING");
					keyCol = rs.getString("TRAN_ID_COL");
					tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +        "<tran_id></tran_id>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);
         }
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
						rs.close();
						rs = null;
				}
				if (pstmt != null)
				{
						pstmt.close();
						pstmt = null;
				}
			}
			catch(Exception e){}
		}
        return tranId;
     }//generateTranTd()		
}
