/**
 *  Purpose: Dashboard for Consignment Details, Reuest ID: W15CSUN006  
 *  Author: Sneha Mestry
 *  Date: 16-06-2015
 */

package ibase.webitm.servlet.wms;


import ibase.system.config.AppConnectParm;
import ibase.webitm.ejb.wms.ConsignmentDetailsRemote;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;


public class ConsignmentDetailsServlet extends HttpServlet
{
	
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		ConsignmentDetailsRemote  consignmentDetailsRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "", fromDate = "", toDate = "";
		String siteCode = "";
		try
		{
			response.setContentType("application/xml");
			dataSourceName = request.getParameter("dataSourceName");
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			siteCode = userInfo.getSiteCode();
			System.out.println(" siteCode :::::::::: " + siteCode); 
			
			//Changed by Sneha, for date parameter Request ID: W15ESUN005 
			fromDate = request.getParameter("fromDate"); 
			toDate = request.getParameter("toDate");
			System.out.println(" fromDate :::::::::: " + fromDate);
			System.out.println(" toDate :::::::::: " + toDate);
			//End by Sneha, for date parameter Request ID: W15ESUN005 
			

			context = new InitialContext(appConnectParm.getProperty());
			consignmentDetailsRemote = (ConsignmentDetailsRemote) context.lookup("ibase/ConsignmentDetails/remote");

			//Start by Sneha on 21-07-2015, Request ID: D15DKAT009 
			JSONObject jsonObjData = (JSONObject)consignmentDetailsRemote.getConsignmentDetails(dataSourceName, siteCode, fromDate, toDate);
			//End by Sneha on 21-07-2015, Request ID: D15DKAT009 
			
			//Here invoke EJB define method 
			//JSONObject jsonObjData = (JSONObject)consignmentDetailsRemote.getConsignmentDetails(dataSourceName, siteCode);
			OutputStream outputStream = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for ConsignmentDetailsServlet build to Graph and Grid===" + jsonObjData);	
			
		} 
		catch (Exception e)
		{
			System.out.println("Exception in: ConsignmentDetailsServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e.getMessage());
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}