
CREATE TABLE EMP_SECURITIES_HDR 
(
TRAN_ID           CHAR(10)     NOT NULL,
EMP_CODE          CHAR(10)     NOT NULL,
ACCT_PRD          CHAR(6)      NOT NULL,
TRAN_DATE         DATE         NOT NULL,
LAST_REMIND_DATE  DATE,
REMIND_COUNT      NUMBER(3,0),
STATUS            CHAR(1)      NOT NULL,
STATUS_DATE       DATE         NOT NULL,
ADD_DATE          DATE         NOT NULL,
ADD_USER          CHAR(10)     NOT NULL,
ADD_TERM          VARCHAR2(15) NOT NULL,
CHG_DATE          DATE         NOT NULL,
CHG_USER          CHAR(10)     NOT NULL,
chg_term          varchar2(15) NOT NULL
) ;

ALTER TABLE EMP_SECURITIES_HDR ADD ( CONSTRAINT EMP_SECURITIES_HDR_X PRIMARY KEY ( TRAN_ID ));


CREATE TABLE EMP_SECURITIES_DTL 
(
TRAN_ID            CHAR(10)     NOT NULL,
LINE_NO            NUMBER(3,0)  NOT NULL,
RELATIVE_NAME      VARCHAR2(75) NOT NULL,
PAN_NO             VARCHAR2(30) NOT NULL, 
RELATIONSHIP       VARCHAR2(10) NOT NULL,
MODE_OF_SECURITY   CHAR(1)      NOT NULL,
DP_ID              VARCHAR2(30),
CLIENT_ID          VARCHAR2(30),
FOLIO_NO           VARCHAR2(30), 
TYPE_OF_SECURITY   CHAR(1)      NOT NULL,
NO_OF_SECURITIES   NUMBER(8,0),
SHAREHOLDING_PERC  NUMBER(5,2),
UNITS_FUTURE       NUMBER(8,0),
VALUE_FUTURE       NUMBER(18,2), 
UNITS_OPTION       NUMBER(8,0),
VALUE_OPTION       NUMBER(18,2)
) ;

ALTER TABLE EMP_SECURITIES_DTL ADD ( CONSTRAINT EMP_SECURITIES_DTL_X PRIMARY KEY ( TRAN_ID, LINE_NO ));


---TRANSETUP--------

Insert into transetup (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,UDF_1,UDF_2,UDF_3,UDF_4,UDF_5,REPEATE_ADD,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,SITE_ACC_COL,CONFIRM_COL,CONFIRM_VAL,REPEAT_ADD_DET,REPEATADDDET,LOAD_MODE,AUTO_CONFIRM,LEDG_POST_CONF,CHG_DATE_ON_CONF,TRAN_ID_COL,MAIL_OPTION,CONFIRM_MODE,GARBAGE_OPT,VAL_FLAG_EDI,VERIFY_PASSWORD,CUST_ACC_COL,SALES_PERS_ACC_COL,SUPP_ACC_COL,ITEM_SER_ACC_CODE,EMP_ACC_COL,ITEM_SER_ACC_COL,WORKFLOW_OPT,TABLE_NAME,APPLICATION,TABLE_DESC,TRAN_DATE_COL,TRAN_ID__FROM,TRAN_ID__TO,TABLE_NAME_DET1,TABLE_NAME_DET2,TABLE_NAME_DET3,MULTITIRE_OPT,REF_SER,VIEW_MODE,TAX_FORMS,SIGN_STATUS,USER_TRAN_WINDOW,CUSTOM_PREVIEW_OBJ,IGNOREERRLIST_ONLOAD,CHILDDATA_ARGOPT,EDIT_TMPLT,WRKFLW_INIT,EDITTAX,FORMAL_ARGS,AUDIT_TRAIL_OPT,EDIT_OPT,CACHE_OPT,OPTIMIZE_MODE,EDIT_EXPR,RATE_COL,QTY_COL,EDIT_EXPR_INP,RCP_CACHE_STATUS,PRINT_CONTROL,TRANSFER_MODE,PROFILE_ID__RES,TRAN_COMPL_MSG,PERIOD_OPTION,WRKFLW_PRIORITY,EXEC_TYPE,DISP_META_DATA,START_FORM,ISATTACHMENT,HEADER_FORM_NO,ALLOW_ATTACH,MSG_ONSAVE,CONFIRM_DATE_COL,CONFIRM_BY_COL,WF_STATUS,ISGWTINITIATED,RESTART_FORM,BROW_DATA_DEF,CMS_PATH,DEF_VIEW,VIEW_OPTS,FUNCTION_TYPE,COMPL_ACTION,IN_WF_VAL,IN_WF_COL,CANCEL_VAL,CANCEL_COL,THUMB_ALT_COL,THUMB_IMAGE_COL,THUMB_OBJ,DEFAULT_DATA_ROW,ATTACH_COUNT_MIN,DEFAULT_EDITOR) 
values ('w_emp_securities','2','2','A','seq10',null,null,null,null,null,'N',to_timestamp('06-MAY-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','0',null,'STATUS','S',null,null,'E',null,'N','N','TRAN_ID','0','0',null,null,null,null,null,null,null,null,null,null,'emp_securities_hdr','ADM',null,null,null,null,'emp_securities_dtl',null,null,null,'PC','F',null,null,null,null,null,'2',null,null,null,null,'0','0',null,null,null,null,null,null,null,null,null,null,null,'M',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null);



-----ITEM2MENU-----
insert into itm2menu (application,level_1,level_2,level_3,level_4,level_5,win_name,descr,comments,menu_path,icon_path,close_icon,open_icon,obj_type,chg_date,chg_term,chg_user,mob_deploy,default_state,def_action)
values ('ADM',2,28,0,0,0,'w_emp_securities','Employee Securities','Employee Securities','ADM.2.28.0.0.0','e12_logo.gif',null,null,'T',sysdate,'BASE','BASE',null,null,null);

----OBJ_FORMS----------
insert into obj_forms(win_name,title,form_no) values('w_emp_securities','Header','1');
insert into obj_forms(win_name,title,form_no) values('w_emp_securities','Detail','2');


-----OBJ_ACTIONS------
Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT,SHOW_IN_PANEL,SWIPE_POSITION,MULTI_ROW_OPT,ACTION_ID) 
values ('emp_securities',1,'add.gif','Adding new','a','a','A','Add','1',null,null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE           ','BASE      ',null,null,null,null,null,null,null);

Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT,SHOW_IN_PANEL,SWIPE_POSITION,MULTI_ROW_OPT,ACTION_ID) 
values ('emp_securities',2,'edit.gif','Editing Record','a','a','E','Edit','1',null,null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE           ','BASE      ',null,null,null,null,null,null,null);

Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT,SHOW_IN_PANEL,SWIPE_POSITION,MULTI_ROW_OPT,ACTION_ID) 
values ('emp_securities',3,'edit.gif','Editing Record','a','a','E','Edit','2',null,null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE           ','BASE      ',null,null,null,null,null,null,null);

Insert into obj_actions (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,PLACEMENT,ACTION_TYPE,TRAN_TYPE,CHG_DATE,CHG_TERM,CHG_USER,IS_CONFIRMATION_REQ,SEP_DUTY_OPT,RE_AUTH_OPT,SHOW_IN_PANEL,SWIPE_POSITION,MULTI_ROW_OPT,ACTION_ID) 
values ('emp_securities',4,'cancel.gif','Submit','emp_secu_submit','a','F','Submit','1','2',null,'U',null,null,null,null,null,null,null,null,null,null,null);


-----SYSTEM_EVENTS------
Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) 
values ('emp_securities','emp_secu_submit','1','emp_securities_submit',null,'0',to_timestamp('23-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'Base      ','Base','2','EJB','EmployeeSecuritySubmit',null);

Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) 
values ('emp_securities','post_item_change','1','poic_emp_securities',null,'0',to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE','2','EJB','EmployeeSecurityIC',null);

Insert into system_events (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,METHOD_RULE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME,COMM_FORMAT) 
values ('emp_securities','pre_validate','1','prv_emp_securities',null,'0',to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE','2','EJB','EmployeeSecurityIC',null);

            
-----SYSTEM_EVENT_SERVICES-----
Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM,RETURN_XFRM_XSL) 
values ('emp_securities_submit',null,'http://localhost:8080/axis/services/ActionHandlerService',null,'actionHandler','String','S',null,null,to_timestamp('23-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'Rohan     ','Base', EMPTY_BLOB());

Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM,RETURN_XFRM_XSL) 
values ('poic_emp_securities','Employee ItemChange','http://localhost:9090/axis/services/ValidatorService','Base Information','itemChanged','String','S',null,null,to_timestamp('04-DEC-07','DD-MON-RR HH.MI.SSXFF AM'),'NIRAJA    ','BASE22', EMPTY_BLOB());

Insert into system_event_services (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,RETURN_DESCR,RETURN_XFRM,CHG_DATE,CHG_USER,CHG_TERM,RETURN_XFRM_XSL) 
values ('prv_emp_securities','Employee Validation','http://localhost:9090/axis/services/ValidatorService','Base Information','wfValData','String','S',null,null,to_timestamp('04-DEC-07','DD-MON-RR HH.MI.SSXFF AM'),'NIRAJA    ','BASE22', EMPTY_BLOB());

            

----- SYSTEM_SERVICE_ARGS------
Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('emp_securities_submit',1,'COMPONENT_TYPE','I','COMPONENT_TYPE','S',null,to_timestamp('23-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE      ','EJB');

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('emp_securities_submit',2,'COMPONENT_NAME','I','COMPONENT_NAME','S',null,to_timestamp('23-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE','EmployeeSecuritySubmit');

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('emp_securities_submit',3,'<tran_id>','I','Tran Id Wave','B.String',null,to_timestamp('23-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE      ',null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('emp_securities_submit',4,'XTRA_PARAMS','I','XTRA_PARAMS','S',null,to_timestamp('23-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE      ',null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('emp_securities_submit',5,'XML_DATA_ALL','I','XML_DATA_ALL','S',null,to_timestamp('23-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE      ',null);


Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_emp_securities',1,'COMPONENT_TYPE','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,'EJB');

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_emp_securities',2,'COMPONENT_NAME','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,'EmployeeSecurityIC');

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_emp_securities',3,'XML_DATA','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_emp_securities',4,'XML_DATA_1','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_emp_securities',5,'XML_DATA_ALL','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_emp_securities',6,'OBJ_CONTEXT','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_emp_securities',7,'FOCUSED_COLUMN','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_emp_securities',8,'EDIT_FLAG','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('poic_emp_securities',9,'XTRA_PARAMS','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);


Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_emp_securities',1,'COMPONENT_TYPE','I',null,'C.String',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,'EJB');

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_emp_securities',2,'COMPONENT_NAME','I',null,'C.String',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,'EmployeeSecurityIC');

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_emp_securities',3,'XML_DATA','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_emp_securities',4,'XML_DATA_1','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_emp_securities',5,'XML_DATA_ALL','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_emp_securities',6,'OBJ_CONTEXT','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_emp_securities',7,'EDIT_FLAG','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);

Insert into system_service_args (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,ARG_XFRM,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
values ('prv_emp_securities',8,'XTRA_PARAMS','I',null,'S',null,to_timestamp('20-SEP-16','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ',null,null);


 
-----OBJ_ITEMCHANGE----
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('emp_securities','1  ','emp_code','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('emp_securities','1  ','itm_default','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('emp_securities','1  ','itm_defaultedit','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('emp_securities','2  ','itm_default','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('emp_securities','2  ','itm_defaultedit','Y');
Insert into OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) values ('emp_securities','2  ','mode_of_security','Y');
Insert into OBJ_ITEMCHANGE (obj_name,form_no,field_name,mandatory) values ('emp_securities','2  ','relationship','Y');


-----MESSAGES--------
insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC01','Please Enter Name','Name Cannot Be Empty.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC02','Please Select Relationship','RelationShip Cannot Be Empty.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC03','Please Enter Pan No','Pan No Cannot Be Empty.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC04','Please Select Mode Of Security','Mode Of Security cannot Be Empty.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC05','Please Enter Type Of Security','Type Of Security Cannot Be Empty.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC06','Invalid No Of Security','Please Enter Valid No Of Security.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTPRCEXED','Percentage Limit Exced','Please Enter Valid Shareholding Percentage.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC07','Invalid Units future','Please Enter Valiod Units future.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC08','Invalid Units Option','Please Enter Valid Units Option.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC9','Invalid Value Option','Please Enter Valid Value Option.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC10','Invalid Value future','Please Enter Valid future.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPACCT','Invalid Acct Prd','Transaction not allow in same accounting prd','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC31','Invalid Pan No','Please Enter Valid Pan No.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
values ('VTALRDCACL','Already Canceled','Transaction is already Canceled','E',null,null,null,null,SYSDATE,'SUN','SUN',null,null);

Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
values ('VTALRDSUB','Already Submitted','Transaction is already Submitted','E',null,null,null,null,SYSDATE,'SUN','SUN',null,null);

Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
values ('VTSUBSUCSS','Submitted successfully','Transaction Submitted successfully','P',null,null,null,null,SYSDATE,'SUN','SUN',null,null);

Insert into messages (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE,CHG_DATE,CHG_USER,CHG_TERM,OVERRIDE_INPUT,MAIL_OPTION) 
values ('VTSUBFAIL','Submite Fail','Transaction Submite Fail','E',null,null,null,null,SYSDATE,'SUN','SUN',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC41','Invalid Mode Of Security','Please Enter Valid Mode Of Security.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC51','Invalid Type Of Security','Please Enter Valid Type Of Security.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSEC21','Invalid Relationship','Please Select Valid Relationship.','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSELF','Invalid Relationship','Please SELF relation record','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTDUPLPAN','Duplicate Pan No','Duplicate Pan no found','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTDUPLFLO','Duplicate Folio No','Duplicate Folio no found','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTDUPLDP','Duplicate Dp id','Duplicate Dp id found','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTDUPLCLN','Duplicate Client id','Duplicate Client id found','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTPRCEXED','Shareholding prc exids','Shareholding prc can not be more than 100','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPSECDC','Invalid No of security','No of security can not be in decimal','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);


insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPUFDC','Invalid Unit Future','Unit Future can not be in decimal','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPUODC','Invalid Unit Options','Unit Options can not be in decimal','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPVODC','Invalid Value Options','Value Options can not be in decimal','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,msg_time,alarm,err_source,chg_date,chg_user,chg_term,override_input,mail_option) 
values ('VTEMPVFDC','Invalid Value Future','Value Future can not be in decimal','E','Y',0,null,null,to_timestamp('22-OCT-00','DD-MON-RR HH.MI.SSXFF AM'),'SUN','HDP',null,null);

------POPHELP-----


Insert into POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,FILTER_STRING,SQL_INPUT,DEFAULT_COL,POP_ALIGN,QUERY_MODE,PAGE_CONTEXT,POPHELP_COLS,POPHELP_SOURCE,MULTI_OPT,HELP_OPTION,POPUP_XSL_NAME,AUTO_FILL_LEN,THUMB_OBJ,THUMB_IMAGE_COL,THUMB_ALT_COL) 
values ('RELATIONSHIP','W_EMP_SECURITIES','SELECT FLD_VALUE AS RELATIONSHIP FROM GENCODES WHERE FLD_NAME = ''RELATIONSHIP'' AND MOD_NAME = ''W_EMP_SECURITIES'' ',null,'Relationship',0,0,to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','0',null,null,0,null,null,null,null,null,null,null,null,null,null,null,null);

Insert into POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,FILTER_STRING,SQL_INPUT,DEFAULT_COL,POP_ALIGN,QUERY_MODE,PAGE_CONTEXT,POPHELP_COLS,POPHELP_SOURCE,MULTI_OPT,HELP_OPTION,POPUP_XSL_NAME,AUTO_FILL_LEN,THUMB_OBJ,THUMB_IMAGE_COL,THUMB_ALT_COL) 
values ('TYPE_OF_SECURITY','W_EMP_SECURITIES','SELECT FLD_VALUE AS TYPE_OF_SECURITY , DESCR AS DESCRIPTION FROM GENCODES WHERE FLD_NAME = ''TYPE_OF_SECURITY'' AND MOD_NAME = ''W_EMP_SECURITIES'' ',null,'Type Of Security',0,0,to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','0',null,null,0,null,null,null,null,null,null,null,null,null,null,null,null);

Insert into POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,DW_OBJECT,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,FILTER_STRING,SQL_INPUT,DEFAULT_COL,POP_ALIGN,QUERY_MODE,PAGE_CONTEXT,POPHELP_COLS,POPHELP_SOURCE,MULTI_OPT,HELP_OPTION,POPUP_XSL_NAME,AUTO_FILL_LEN,THUMB_OBJ,THUMB_IMAGE_COL,THUMB_ALT_COL) 
values ('MODE_OF_SECURITY','W_EMP_SECURITIES','SELECT FLD_VALUE AS MODE_OF_SECURITY , DESCR AS DESCRIPTION FROM GENCODES WHERE FLD_NAME = ''MODE_OF_SECURITY'' AND MOD_NAME = ''W_EMP_SECURITIES'' ',null,'Mode Of Security',0,0,to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','0',null,null,0,null,null,null,null,null,null,null,null,null,null,null,null);


-----GENCODES-----

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3) 
values ('MODE_OF_SECURITY','W_EMP_SECURITIES','E','ELECTRONIC','ELECTRONIC',to_timestamp('23-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3) 
values ('MODE_OF_SECURITY','W_EMP_SECURITIES','P','PHYSICAL','PHYSICAL',to_timestamp('23-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3) 
values ('RELATIONSHIP','W_EMP_SECURITIES','SELF','SELF','SELF',to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3) 
values ('RELATIONSHIP','W_EMP_SECURITIES','BROTHER','BROTHER','BROTHER',to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3) 
values ('RELATIONSHIP','W_EMP_SECURITIES','FATHER','FATHER','FATHER',to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3)
values ('RELATIONSHIP','W_EMP_SECURITIES','MOTHER','MOTHER','MOTHER',to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3) 
values ('RELATIONSHIP','W_EMP_SECURITIES','SPOUSE','SPOUSE','SPOUSE',to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3) 
values ('RELATIONSHIP','W_EMP_SECURITIES','SISTER','SISTER','SISTER',to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3) 
values ('RELATIONSHIP','W_EMP_SECURITIES','DAUGHTER','DAUGHTER','DAUGHTER',to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3)
values ('RELATIONSHIP','W_EMP_SECURITIES','SON','SON','SON',to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3) 
values ('TYPE_OF_SECURITY','W_EMP_SECURITIES','S','Shares','Shares',to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3) 
values ('TYPE_OF_SECURITY','W_EMP_SECURITIES','W','Warrants','Warrants',to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

Insert into gencodes (FLD_NAME,MOD_NAME,FLD_VALUE,DESCR,SH_DESCR,CHG_DATE,CHG_USER,CHG_TERM,ACTIVE,UDF_STR1,UDF_STR2,UDF_STR3)
values ('TYPE_OF_SECURITY','W_EMP_SECURITIES','C','Convertible Debentures','Convertible Debentures',to_timestamp('24-JAN-17','DD-MON-RR HH.MI.SSXFF AM'),'BASE      ','BASE           ','Y',null,null,null);

--------------SHOULD be ADDED by AHEMAD now---

--Modified by Ahmed on 23/Jan/2017[start]--

ALTER TABLE EMP_SECURITIES_HDR ADD ( CONSTRAINT UK_EMP_SECURITIES_HDR_EA UNIQUE ( EMP_CODE, ACCT_PRD ));
ALTER TABLE EMP_SECURITIES_DTL ADD ( CONSTRAINT FK_EMP_SECURITIES_DTL_X FOREIGN KEY ( TRAN_ID ) REFERENCES EMP_SECURITIES_HDR);

SET DEFINE OFF;

INSERT INTO PAYRPARM (PRD_CODE, VAR_NAME, VAR_TYPE, VAR_VALUE, DESCR, VAR_SUBS, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('999999', 'ANN_DISC_MAIL_FREQ', 'S', '7,7,2', 'INTERVAL OF DAYS FOR REMINDER MAIL', null, FN_SYSDATE(), 'BASE', 'BASE');

INSERT INTO PAYRPARM (PRD_CODE, VAR_NAME, VAR_TYPE, VAR_VALUE, DESCR, VAR_SUBS, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('999999', 'INIT_DISC_MAIL_FREQ', 'S', '2,5,7,2', 'INTERVAL OF DAYS FOR REMINDER MAIL', null, FN_SYSDATE(), 'BASE', 'BASE');


INSERT INTO ADM_ENV (FIN_ENTITY, SITE_CODE, APP_TYPE, DEPT_CODE, EMP_CODE__HR, VALID_FROM, VALID_TO, GEO_LOC, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('9S', 'SP801', 'EMSEC', 'IT01', 'E30055', to_timestamp('2016-04-01', 'YYYY-MM-DD HH.MI.SSXFF AM'), to_timestamp('2018-03-31', 'YYYY-MM-DD HH.MI.SSXFF AM'), '801', FN_SYSDATE(), 'AALI', 'AALI');

INSERT INTO ADM_ENV (FIN_ENTITY, SITE_CODE, APP_TYPE, DEPT_CODE, EMP_CODE__HR, VALID_FROM, VALID_TO, GEO_LOC, CHG_DATE, CHG_USER, CHG_TERM) VALUES ('9S', 'SP801', 'EMSEC', 'IT01', 'E32788', to_timestamp('2016-04-01', 'YYYY-MM-DD HH.MI.SSXFF AM'), to_timestamp('2018-03-31', 'YYYY-MM-DD HH.MI.SSXFF AM'), '801', FN_SYSDATE(), 'AALI', 'AALI');

INSERT INTO MAIL_FORMAT (FORMAT_CODE, FORMAT_TYPE, SEND_TO, COPY_TO, BLIND_COPY, SUBJECT, BODY_TEXT, BODY_COMP, PRIORITY, DELIVERY_REPORT, RETURN_RECEIPT, MAIL_APPLICATION, MAIL_SERVER, MAIL_BOX, MAIL_ID, ATTACH_TYPE, ATTACH_TEXT, ATTACH_OBJECT, WINNAME, WIN_NAME, MAIL_GENERATION, MAIL_DESCR, FN_NAME, COND_METHOD, EMAIL_EXPR) VALUES ('ANN_DISC_INT_MAIL', 'T', '{(E)EMP_CODE}', null, null, 'Annual Disclosure Intimation Mail', 'Dear Sir/Madam,  Kindly view the record and do the needful.', null, null, null, null, 'M', null, null, null, null, null, null, null, 'w_emp_securities', null, null, null, null, null);

INSERT INTO MAIL_FORMAT (FORMAT_CODE, FORMAT_TYPE, SEND_TO, COPY_TO, BLIND_COPY, SUBJECT, BODY_TEXT, BODY_COMP, PRIORITY, DELIVERY_REPORT, RETURN_RECEIPT, MAIL_APPLICATION, MAIL_SERVER, MAIL_BOX, MAIL_ID, ATTACH_TYPE, ATTACH_TEXT, ATTACH_OBJECT, WINNAME, WIN_NAME, MAIL_GENERATION, MAIL_DESCR, FN_NAME, COND_METHOD, EMAIL_EXPR) VALUES ('INIT_DISC_INT_MAIL', 'T', '{(E)EMP_CODE}', null, null, 'Initial Disclosure Intimation Mail', 'Dear Sir/Madam,  Kindly view the record and do the needful.', null, null, null, null, 'M', null, null, null, null, null, null, null, 'w_emp_securities', null, null, null, null, null);

INSERT INTO MAIL_FORMAT (FORMAT_CODE, FORMAT_TYPE, SEND_TO, COPY_TO, BLIND_COPY, SUBJECT, BODY_TEXT, BODY_COMP, PRIORITY, DELIVERY_REPORT, RETURN_RECEIPT, MAIL_APPLICATION, MAIL_SERVER, MAIL_BOX, MAIL_ID, ATTACH_TYPE, ATTACH_TEXT, ATTACH_OBJECT, WINNAME, WIN_NAME, MAIL_GENERATION, MAIL_DESCR, FN_NAME, COND_METHOD, EMAIL_EXPR) VALUES ('INIT_DISC_REM_MAIL', 'T', '{(E)EMP_CODE}', null, null, 'Initial Disclosure Reminder Mail', 'Dear Sir/Madam,  Kindly view the record and do the needful.', null, null, null, null, 'M', null, null, null, null, null, null, null, 'w_emp_securities', null, null, null, null, null);

INSERT INTO MAIL_FORMAT (FORMAT_CODE, FORMAT_TYPE, SEND_TO, COPY_TO, BLIND_COPY, SUBJECT, BODY_TEXT, BODY_COMP, PRIORITY, DELIVERY_REPORT, RETURN_RECEIPT, MAIL_APPLICATION, MAIL_SERVER, MAIL_BOX, MAIL_ID, ATTACH_TYPE, ATTACH_TEXT, ATTACH_OBJECT, WINNAME, WIN_NAME, MAIL_GENERATION, MAIL_DESCR, FN_NAME, COND_METHOD, EMAIL_EXPR) VALUES ('ANN_DISC_REM_MAIL', 'T', '{(E)EMP_CODE}', null, null, 'Annual Disclosure Reminder Mail', 'Dear Sir/Madam,  Kindly view the record and do the needful.', null, null, null, null, 'M', null, null, null, null, null, null, null, 'w_emp_securities', null, null, null, null, null);

COMMIT;
--Modified by Ahmed on 23/Jan/2017[end]--

--------------------------------------------- VALLABH KADAM [13/FEB/17]---------------------------------------------------------

update transetup set confirm_col='STATUS',confirm_val='S',def_view='T' where tran_window ='w_emp_securities';

--------------------------------------------- VALLABH KADAM [13/FEB/17]END ---------------------------------------------------------
