
------------------------------------------------pallet_req_hdr-----------------------------------------------------

create table pallet_req_hdr
(
tran_id 	char(10) 	not null,
tran_date 	date,
site_code 	char(5) 	not null,
loc_code 	char(8),
remarks 	varchar2(60),
confirmed 	char(1),
conf_date 	date,
emp_code__aprv 	char(10),
add_user 	char(10) 	not null,
add_date 	date 		not null,
add_term 	varchar2(15) 	not null,
chg_user 	char(10) 	not null,
chg_date 	date 		not null,
chg_term 	varchar2(15) 	not null 
) TABLESPACE ITM_DIS_D2;

ALTER TABLE pallet_req_hdr ADD CONSTRAINT PALLETIZE_REQ_HDR_X PRIMARY KEY (TRAN_ID) USING INDEX TABLESPACE ITM_DIS_I1;

ALTER TABLE pallet_req_hdr ADD CONSTRAINT FK_PALLETIZE_REQ_HDR_SITE_CODE FOREIGN KEY (SITE_CODE) REFERENCES SITE (SITE_CODE);

ALTER TABLE pallet_req_hdr ADD CONSTRAINT FK_PALLET_REQ_HDR_EMP_CODE_APR FOREIGN KEY (emp_code__aprv) REFERENCES employee (emp_code);

------------------------------------------------PALLET_REQ_DET-----------------------------------------------------

create table pallet_req_det
(
tran_id 	char(10) 	not null,
line_no 	number(3) 	not null,
pallet_no 	char(15),
loc_code 	char(8),
status 		char(1)
) TABLESPACE ITM_DIS_D2;

ALTER TABLE pallet_req_det ADD CONSTRAINT PALLET_REQ_DET_X PRIMARY KEY (TRAN_ID, LINE_NO) USING INDEX TABLESPACE ITM_DIS_I1;

ALTER TABLE pallet_req_det ADD CONSTRAINT FK_pallet_req_det_ FOREIGN KEY (tran_id) REFERENCES pallet_req_hdr (tran_id);


---------------------------------------------------------system entry-------------------------------------------------------------------------------------
INSERT INTO TRANSETUP (TRAN_WINDOW,SAVE_FLAG,VAL_FLAG,KEY_FLAG,KEY_STRING,CHG_DATE,CHG_USER,CHG_TERM,EDI_OPTION,CONFIRM_COL,CONFIRM_VAL,LEDG_POST_CONF,CHG_DATE_ON_CONF,TRAN_ID_COL,MAIL_OPTION,CONFIRM_MODE,TABLE_NAME,APPLICATION,REF_SER,VIEW_MODE,CHILDDATA_ARGOPT,AUDIT_TRAIL_OPT,PERIOD_OPTION) 
VALUES ('w_pallet_req','2','2','A','PR,seq08',SYSDATE,'BASE','BASE','0','confirmed','Y','N','N','TRAN_ID','0','0','pallet_req_hdr','WMS','PR','F','2','0','M');

INSERT INTO OBJ_FORMS (WIN_NAME,TITLE,OBJ_BROW_NAME,FORM_NO) 
VALUES ('w_pallet_req','Header','d_pallet_req','1');

INSERT INTO OBJ_FORMS (WIN_NAME,TITLE,OBJ_BROW_NAME,FORM_NO)
VALUES ('w_pallet_req','Detail','d_pallet_req','2');

Insert into OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER)
VALUES ('pallet_req',1,'add.gif','Adding new','a','a','A','Add','1','S',sysdate,'BASE','BASE');

INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) 
VALUES ('pallet_req',2,'edit.gif','Editing Existing Record','a','a','E','Edit','1','S',SYSDATE,'BASE','BASE');

INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,IMAGE,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER)
VALUES ('pallet_req',6,'delete.gif','Delete  Property','a','a','D','Delete','1','S',sysdate,'BASE','BASE');

INSERT INTO ITM2MENU (APPLICATION,LEVEL_1,LEVEL_2,LEVEL_3,LEVEL_4,LEVEL_5,WIN_NAME,DESCR,MENU_PATH,ICON_PATH,CHG_DATE,CHG_TERM,CHG_USER) 
VALUES ('WMS',4,2,0,0,0,'w_pallet_req','Pallet Request','AWMS.4.2.0.0.0','e12_logo.gif',sysdate,'BASE','BASE');

-------------------------------------------------------------validation-----------------------------------------------------------------------------
INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('pallet_req','pre_validate','1','prv_pallet_req','0',SYSDATE,'BASE','BASE','2','EJB','PalletReqIC');

INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('prv_pallet_req','Pallet Request','http://localhost:9090/axis/services/ValidatorService','base','wfValData','String','S',sysdate,'base','base');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES ('prv_pallet_req',1,'COMPONENT_TYPE','I','C.String',SYSDATE,'BASE','BASE','EJB');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
VALUES ('prv_pallet_req',2,'COMPONENT_NAME','I','C.String',SYSDATE,'BASE','BASE','PalletReqIC');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('prv_pallet_req',3,'XML_DATA','I','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
values ('prv_pallet_req',4,'XML_DATA_1','I','S',sysdate,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('prv_pallet_req',5,'XML_DATA_ALL','I','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('prv_pallet_req',6,'OBJ_CONTEXT','I','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('prv_pallet_req',7,'EDIT_FLAG','I','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('prv_pallet_req',8,'XTRA_PARAMS','I','S',sysdate,'BASE','BASE');

----------------------------------------------------------------item change---------------------------------------------------------------------------
INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME) 
VALUES ('pallet_req','post_item_change','1','poic_pallet_req','0',SYSDATE,'BASE','BASE','2','EJB','PalletReqIC');

INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('poic_pallet_req','Pallet Request','http://localhost:9090/axis/services/ValidatorService','base','itemChanged','String','S',sysdate,'base','base');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES ('poic_pallet_req',1,'COMPONENT_TYPE','I','S',SYSDATE,'BASE','BASE','EJB');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
VALUES ('poic_pallet_req',2,'COMPONENT_NAME','I','S',SYSDATE,'BASE','BASE','PalletReqIC');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('poic_pallet_req',3,'XML_DATA','I','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('poic_pallet_req',4,'XML_DATA_1','I','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('poic_pallet_req',5,'XML_DATA_2','I','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('poic_pallet_req',6,'OBJ_CONTEXT','I','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('poic_pallet_req',7,'FOCUSED_COLUMN','I','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('poic_pallet_req',8,'EDIT_FLAG','I','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('poic_pallet_req',9,'XTRA_PARAMS','I','S',sysdate,'BASE','BASE');

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
values ('pallet_req','1  ','itm_default','Y');

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
values ('pallet_req','1  ','loc_code','Y');

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
values ('pallet_req','1  ','site_code','Y');

INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY)
VALUES ('pallet_req','2  ','itm_default','Y');

----------------------------------------------------------confirm-----------------------------------------------------------------------------
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,ACTION_TYPE,CHG_DATE,CHG_TERM,CHG_USER) 
VALUES ('pallet_req',3,'Confirm','pre_Pallet_conf','N','C','Confirm','1','2','U',SYSDATE,'BASE','Base');

INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('pallet_req','pre_Pallet_conf','1','Pallet_confirm','0',SYSDATE,'Base','BASE','2','EJB','PalletReqConf');

INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_confirm','Action To Confirm Stock  transfer','http://localhost:8080/axis/services/ActionHandlerService','Base Information','confirm','String','S',sysdate,'Base','Base');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES ('Pallet_confirm',1,'COMPONENT_TYPE','I','Component Type','S',SYSDATE,'Base','Base','EJB');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES ('Pallet_confirm',2,'COMPONENT_NAME','I','Component name','S',SYSDATE,'Base','Base','PalletReqConf');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_confirm',3,'<tran_id>','B.String',SYSDATE,'Base','Base');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_confirm',4,'XTRA_PARAMS','params','S',SYSDATE,'Base','Base');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('Pallet_confirm',5,'FORCED_FLAG','flag','S',sysdate,'Base','Base');

------------------------------------------------------------Expire -----------------------------------------------------------------------------
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,ACTION_TYPE)
VALUES ('pallet_req',4,'Expire','pallet_exp','a','R','Expire','2','4','U');

INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('pallet_req','pallet_exp','1','Pallet_expire','0',SYSDATE,'Base','BASE','2','EJB','PalletReqExpiryAct');

INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_expire','Action To Set Expire Pallet','http://localhost:8080/axis/services/ActionHandlerService','Base Information','actionHandler','String','S',sysdate,'Base','Base');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
VALUES ('Pallet_expire',1,'COMPONENT_TYPE','I','Component Type','C.String',SYSDATE,'BASE','BASE','EJB');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
VALUES ('Pallet_expire',2,'COMPONENT_NAME','I','Component Name','C.String',SYSDATE,'BASE','BASE','PalletReqExpiryAct');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
VALUES ('Pallet_expire',3,'ACTION_TYPE','I','Action Type','C.String',SYSDATE,'BASE','BASE','EXPIRY');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_expire',4,'XML_DATA','I','XML data for Current form','S',SYSDATE,'BASE','BASE ');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_expire',5,'XML_DATA_1','I','XML data of form no 1','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('Pallet_expire',6,'OBJ_CONTEXT','I','Object context','S',SYSDATE,'BASE','BASE ');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_expire',7,'XTRA_PARAMS','I','Extra Arguments','S',sysdate,'BASE','BASE');

-----------------------------------------------------------Near Expire-----------------------------------------------------------------------------
INSERT INTO OBJ_ACTIONS (OBJ_NAME,LINE_NO,DESCRIPTION,SERVICE_CODE,INTERACTIVE,RIGHTS_CHAR,TITLE,FORM_NO,SERVICE_HANDLER,ACTION_TYPE)
VALUES ('pallet_req',5,'Near To Expire','pre_pallet_exl','a','R','NearExpire','2','4','U');

INSERT INTO SYSTEM_EVENTS (OBJ_NAME,EVENT_CODE,EVENT_CONTEXT,SERVICE_CODE,OVERWRITE_CORE,CHG_DATE,CHG_USER,CHG_TERM,RESULT_HANDLE,COMP_TYPE,COMP_NAME)
VALUES ('pallet_req','pre_pallet_exl','1','Pallet_explist','0',SYSDATE,'Base','BASE','2','EJB','PalletReqExpiryAct');

INSERT INTO SYSTEM_EVENT_SERVICES (SERVICE_CODE,SERVICE_DESCR,SERVICE_URI,SERVICE_PROVIDER,METHOD_NAME,RETURN_VALUE,RETURN_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('Pallet_explist','Action To Set near to Expire Pallet','http://localhost:8080/axis/services/ActionHandlerService','Base Information','actionHandler','String','S',sysdate,'Base','Base');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE) 
VALUES ('Pallet_explist',1,'COMPONENT_TYPE','I','Component Type','C.String',SYSDATE,'BASE','BASE','EJB');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
VALUES ('Pallet_explist',2,'COMPONENT_NAME','I','Component Name','C.String',SYSDATE,'BASE','BASE ','PalletReqExpiryAct');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM,ARG_VALUE)
VALUES ('Pallet_explist',3,'ACTION_TYPE','I','Action Type','C.String',SYSDATE,'BASE','BASE','NEXPIRY');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_explist',4,'XML_DATA','I','XML data for Current form','S',SYSDATE,'BASE','BASE ');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_explist',5,'XML_DATA_1','I','XML data of form no 1','S',SYSDATE,'BASE','BASE');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('Pallet_explist',6,'OBJ_CONTEXT','I','Object context','S',SYSDATE,'BASE','BASE ');

INSERT INTO SYSTEM_SERVICE_ARGS (SERVICE_CODE,LINE_NO,ARG_NAME,ARG_MODE,DESCR,ARG_TYPE,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('Pallet_explist',7,'XTRA_PARAMS','I','Extra Arguments','S',sysdate,'BASE','BASE');

------------------------------------------------------------messages---------------------------------------------------------------------------

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('VMLOCATEXT','Invalid location code','Entered location code should present in Location Master and inv_stat should not be AWMS','E','Y',sysdate,'base','base');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMLOCATNUL','Invalid Location Code','Location code cannot be blank. Please enter  Location Code','E','Y',sysdate,'base','base');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('VMPALLENUL','Invalid Pallet Number','Pallet Number  cannot be blank. Please enter  Pallet Number','E','Y',sysdate,'base','base');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMTRANSCOF','Transaction Already Confirm','Selected Transaction is already confirm.','E','Y',sysdate,'base','base');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('VMPALLEEXT','Invalid Pallet Number','Entered Pallet number should present in Location Master and inv_stat should  be AWMS.Please Enter Pallet No','E','Y',sysdate,'base','base');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMTRANSACN','Transaction Confirm.','Selected Transaction  Confirm Successfully.','P','Y',SYSDATE,'base','base');

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('VMPALLETSM','Invalid Pallet Number','Entered Pallet number is already added in this transaction.','E','Y',sysdate,'base','base');

--------------------------------------------------------------pophelp--------------------------------------------------------------------------------------

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,CHG_TERM,DIST_OPT,HELP_OPTION)
VALUES ('SITE_CODE','W_PALLET_REQ','SELECT SITE_CODE,DESCR FROM SITE','User-defined Type',0,0,SYSDATE,'BASE','BASE','0','0');

-------------------------------------------------------------INVSTAT---------------------------------------------------------
INSERT INTO INVSTAT (INV_STAT,DESCR,AVAILABLE,OVERISS,PLAN_PROD,RECORD,CHG_DATE,CHG_USER,CHG_TERM,USABLE,STAT_TYPE) 
VALUES ('AWMS ','AWMS','Y','N','N','N',SYSDATE,'BASE','BASE','N','M');

-------------------------------------------------------27/10/15---------------------------------------------------------------------

ALTER TABLE pallet_req_det
DROP CONSTRAINT FK_pallet_req_det_;

ALTER TABLE PALLET_REQ_DET ADD CONSTRAINT FK_PALLET_REQ_DET FOREIGN KEY (TRAN_ID) REFERENCES PALLET_REQ_HDR (TRAN_ID) ON DELETE CASCADE;

--------------------------------------------------------------29/10/15-------------------------------------------------------------------------


INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,CHG_DATE,CHG_USER,CHG_TERM) 
VALUES ('VMPALLETQN','Invalid Pallet Number','Entered Pallet quantity should be more than zero .Please Enter Pallet No','E','Y',sysdate,'base','base');
----------------------------------------------------------------------30/10/15--------------------------------------------------------------

INSERT INTO MESSAGES (MSG_NO,MSG_STR,MSG_DESCR,MSG_TYPE,MSG_OPT,
CHG_DATE,CHG_USER,CHG_TERM)
VALUES ('VMPALLETCF','Pallet number not entered','Transcation details not present.Please Enter Pallet Number','E','Y',sysdate,'BASE','BASE');

UPDATE MESSAGES SET MSG_DESCR='Entered Pallet number should present in Location Master and inventory state should  be AWMS.Please Enter Pallet No'
WHERE MSG_NO='VMPALLEEXT';


UPDATE MESSAGES SET MSG_DESCR='Entered location code should present in Location and inventory state should not be AWMS  '
WHERE MSG_NO='VMLOCATEXT';


INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER
,CHG_TERM,DIST_OPT,SQL_INPUT,HELP_OPTION) 
VALUES ('LOC_CODE','W_PALLET_REQ','SELECT LOC_CODE,DESCR FROM LOCATION WHERE INV_STAT!=''AWMS'' AND SITE_CODE=''?''',
'User-defined Type',0,0,SYSDATE,'BASE','BASE','0',':site_code',
'0');

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,
CHG_TERM,DIST_OPT,SQL_INPUT,HELP_OPTION) 
VALUES ('PALLET_NO','W_PALLET_REQ','SELECT LOC_CODE AS PALLET_NO ,DESCR FROM LOCATION WHERE INV_STAT=''AWMS'' AND SITE_CODE=''?'''
,'User-defined Type',0,0,SYSDATE,'BASE','BASE','0',':site_code',
'0');


INSERT INTO OBJ_ITEMCHANGE (OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY) 
values ('pallet_req','2','loc_code','Y');

------------------------------------------------------------10/11/2015------------------------------------------------------------------------
UPDATE POPHELP SET SQL_STR='SELECT DISTINCT L.LOC_CODE
AS PALLET_NO ,L.DESCR FROM STOCK S ,LOCATION L WHERE L.INV_STAT=''AWMS'' AND 
L.SITE_CODE=''?'' AND S.LOC_CODE=L.LOC_CODE AND S.QUANTITY>0' where MOD_NAME='W_PALLET_REQ' and FIELD_NAME='PALLET_NO';


--------------------------------------------------------------4/12/2015--------------------------------------------------------------

DELETE FROM POPHELP WHERE mod_name='W_PALLET_REQ' AND field_name='PALLET_NO';
DELETE FROM POPHELP WHERE mod_name='W_PALLET_REQ' AND field_name='LOC_CODE';
DELETE from pophelp where mod_name='W_PALLET_REQ' AND FIELD_NAME='SITE_CODE' ;


insert into pophelp (field_name,mod_name,sql_str,msg_title,width,height,
chg_date,chg_user,chg_term,dist_opt,sql_input,help_option) 
values ('LOC_CODE','W_PALLET_REQ',
'SELECT LOC_CODE,DESCR FROM LOCATION WHERE INV_STAT NOT IN (''AWMS'',''AWMSQ'') AND SITE_CODE=''?''',
'User-defined Type',0,0,sysdate,
'BASE','BASE','0',':site_code',
'0');

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,
CHG_TERM,DIST_OPT,SQL_INPUT,HELP_OPTION) 
VALUES ('PALLET_NO','W_PALLET_REQ','select distinct s.loc_code as pallet_no  from stock s where 
S.INV_STAT IN (''AWMS'') AND S.SITE_CODE=''?'' AND S.QUANTITY > 0
union all
select distinct substr(s.loc_code,1,instr(s.loc_code,''Q'')-1)  from stock s where
S.INV_STAT IN (''AWMSQ'') AND S.SITE_CODE=''?'' AND S.QUANTITY > 0'
,'User-defined Type',0,0,sysdate,'BASE','BASE','0',':site_code,:site_code',
'0');


----------------------------------------------As per client requirment 15/12/2015--------------------------------------------------

insert into messages (msg_no,msg_str,msg_descr,msg_type,msg_opt,chg_date,chg_user,chg_term) 
values ('VMPALDCOEX','Invalid Pallet Number',
'Entered Pallet Number already added in previous  transaction.','E','Y',sysdate,'base','base');

DELETE FROM POPHELP WHERE mod_name='W_PALLET_REQ' AND field_name='PALLET_NO';
commit;


INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,
chg_term,dist_opt,sql_input,help_option) 
values ('PALLET_NO','W_PALLET_REQ','select distinct s.loc_code as pallet_no  from stock s where 
S.INV_STAT IN (''AWMS'') AND S.SITE_CODE=''?'' AND S.QUANTITY > 0 and FN_CHK_PRS(TRIM(S.LOC_CODE)) = 0
union all
select distinct substr(s.loc_code,1,instr(s.loc_code,''Q'')-1)  from stock s where
s.inv_stat in (''AWMSQ'') and s.site_code=''?'' and s.quantity > 0 
and FN_CHK_PRS(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,''Q'')-1)) = 0'
,'User-defined Type',0,0,sysdate,'BASE','BASE','0',':site_code,:site_code',
'0');

-------------------------------------------------------16/12/2015------------------------------------------------------------


delete from pophelp where mod_name='W_PALLET_REQ' AND field_name='PALLET_NO';
commit;

INSERT INTO POPHELP (FIELD_NAME,MOD_NAME,SQL_STR,MSG_TITLE,WIDTH,HEIGHT,CHG_DATE,CHG_USER,
chg_term,dist_opt,sql_input,help_option) 
values ('PALLET_NO','W_PALLET_REQ','select distinct s.loc_code as pallet_no  from stock s where 
S.INV_STAT IN (''AWMS'') AND S.SITE_CODE=''?'' AND S.QUANTITY > 0 and FN_CHK_PRS(TRIM(S.LOC_CODE),'''') = 0
union all
select distinct substr(s.loc_code,1,instr(s.loc_code,''Q'')-1)  from stock s where
s.inv_stat in (''AWMSQ'') and s.site_code=''?'' and s.quantity > 0 
and FN_CHK_PRS(SUBSTR(S.LOC_CODE,1,INSTR(S.LOC_CODE,''Q'')-1),'''') = 0'
,'User-defined Type',0,0,sysdate,'BASE','BASE','0',':site_code,:site_code',
'0');

-------------------------------------------------------------------END----------------------------------------------------------------------------


