package ibase.dashboard.wms.servlet;

import ibase.dashboard.wms.ejb.WMS3PLSummDtlDashboardRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class OrderStatusDtlPieServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		WMS3PLSummDtlDashboardRemote wms3PLSummDtlDashboardRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		
		String dataSourceName = "";
		String facilityCode = "";
		String businessType = "";
		JSONObject jsonObjData = null;
		OutputStream outputStream = null;
		HttpSession session = null;
		UserInfoBean userInfo = null;
		String sessionSiteCode = "";
		String sessionUserLevel = "";
		try
		{
			
			response.setContentType("application/xml");
			facilityCode = request.getParameter("facilityCode");
			businessType = request.getParameter("businessType");
			dataSourceName = request.getParameter("dataSourceName");

			session     	= request.getSession(true);
			userInfo 		= (UserInfoBean) session.getAttribute("USER_INFO");
			sessionSiteCode 	= userInfo.getSiteCode();
			sessionUserLevel = userInfo.getUserLevel();
			System.out.println("in OrderStatusDtlPieQtyWiseServlet sessionSiteCode :"+sessionSiteCode+" sessionUserLevel: "+sessionUserLevel);
			
			System.out.println("*********** In OrderStatusDtlPieServlet facilityCode is *************** =" + facilityCode);
			
			context = new InitialContext(appConnectParm.getProperty());
			wms3PLSummDtlDashboardRemote = (WMS3PLSummDtlDashboardRemote) context.lookup("ibase/WMS3PLSummDtlDashboard/remote");
			jsonObjData = (JSONObject) wms3PLSummDtlDashboardRemote.getOrderStatusDtlPie(facilityCode, businessType, dataSourceName,sessionSiteCode,sessionUserLevel);
			outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			
			/*String jsonObjDataStr ="{'SP101' :{'0':{'product_category':'Picked','category_value':{'WIP':'15000','Total':'','Ship':''},'date':0},'1':{'product_category':'Packed','category_value':{'WIP':'15000','Total':'','Ship':''},'date':1},'2':{'product_category':'Wave','category_value':{'WIP':'15000','Total':'','Ship':''},'date':2},'3':{'product_category':'TotalAmt','category_value':{'WIP':'','Total':'10000','Ship':''},'date':3},'4':{'product_category':'Shipment','category_value':{'WIP':'','Total':'','Ship':'15000'},'date':4}}, 'SP102' :{'0':{'product_category':'Picked','category_value':{'WIP':'15000','Total':'','Ship':''},'date':0},'1':{'product_category':'Packed','category_value':{'WIP':'15000','Total':'','Ship':''},'date':1},'2':{'product_category':'Wave','category_value':{'WIP':'15000','Total':'','Ship':''},'date':2},'3':{'product_category':'TotalAmt','category_value':{'WIP':'','Total':'10000','Ship':''},'date':3},'4':{'product_category':'Shipment','category_value':{'WIP':'','Total':'','Ship':'15000'},'date':4}}}";
			outputStream   = response.getOutputStream();			
			outputStream.write(jsonObjDataStr.toString().replace('\'', '"').getBytes());
			outputStream.flush();
			outputStream.close();*/
			System.out.println(" Final data set for OrderStatusDtlPieServlet for the build the Graph is===" + jsonObjData);		

		}
		catch (Exception e)
		{
			System.out.println("Exception : OrderStatusDtlPieServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			}
			catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}
