/**
 * @author : Pavan Rane
 * @Version : 1.0
 * Date : 26/02/18
 * Request Id: F17KGTP006
 */
package ibase.webitm.ejb.fin.adv;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;

import javax.ejb.Stateless;

/**
 * Session Bean implementation class DisputedReceivablesConf
 */
@Stateless
public class DisputedReceivablesConf extends ActionHandlerEJB implements DisputedReceivablesConfRemote, DisputedReceivablesConfLocal {

	E12GenericUtility genericUtility = new E12GenericUtility();
	@Override
	public String confirm(String tranId, String xtraParams, String forcedFlag)  
			throws RemoteException, ITMException {
		System.out.println("--------------confirm method of DisputedReceivablesConf ------------- : ");
		String retString = "";
		ITMDBAccessEJB itmDBAccessEJB = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String confirm = "", sql = "" ;
		
		try 
		{
			conn = getConnection();
			conn.setAutoCommit(false);
			itmDBAccessEJB = new ITMDBAccessEJB();
			
			sql = "select confirmed from disputed_recv where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) 
			{
				confirm = rs.getString("confirmed");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if(confirm != null  && "Y".equalsIgnoreCase(confirm))
			{
				System.out.println("The Selected transaction is already confirmed");
				retString = itmDBAccessEJB.getErrorString("","VTMCONF1   ","","",conn);
				return retString;
			}
			else
			{
				System.out.println("----------confirmDisputedReceivables called--------");
				retString = confirmDisputedReceivables(tranId, xtraParams, forcedFlag, conn);
				return retString;
			}
		}
		catch (Exception e) 
		{
			System.out.println("Exception :confirmDisputedReceivables :confirm():"+ e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		return retString;
	}

	/**
	 * @param tranId
	 * @param xtraParams
	 * @param forcedFlag
	 * @param conn
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	private String confirmDisputedReceivables(String tranId, String xtraParams, String forcedFlag, Connection conn)
			throws RemoteException, ITMException {
		
		ITMDBAccessEJB itmDBAccessEJB = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null ;
		ResultSet rs = null;
		ResultSet rs1 = null;
		String sql = "";
		String sql1 = "";
		String errString = "" ; 
		String winName = "";
		String ledgPostConf = "";
		String tranIdhdr = "";
		String siteCode = "";
		String custCode = "";
		String confirmed = ""; 
		String empCodeAprv = "";
		String remarks = "";
		String chgUser = "";
		String chgTerm = ""; 
		String descr = ""; 
		String custName = "";
		String recType = "";				
		String tranIdDet = "";
		String lineNo = "";
		String refSer = "";
		String refId = "";
		String currCode = "";
		String cctrCode = "";
		String acctCode = "";
		String refType = "";
		String refType__o = ""; 
		String reasCode = "";
		String loginEmpCode="";			
		double disputeAmt = 0.0;
		double exchRate = 0.0;
		double totAmt = 0.0;
		double adjAmt = 0.0;
		double dispAmt = 0.0;
		double disputeAmtDet = 0.0;
		boolean connStatus=false;	
		Timestamp today = null;
		Timestamp tranDate = null;
		Timestamp refDate = null;
		Timestamp dueDate = null;
		Timestamp confirmedDate = null;
		Timestamp chgDate = null;
		Timestamp expRcpDate = null;
		HashMap disputedRecvMap = null;
		ArrayList DetList = null;
		
		try {
			
			if (conn==null)
			{				
				conn = getConnection();				
				conn.setAutoCommit(false);	
				connStatus = true;
			}			
			System.out.println("conn TOP:["+conn != null+"]["+!conn.isClosed()+"]["+connStatus+"]");
			itmDBAccessEJB = new ITMDBAccessEJB();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
			today = java.sql.Timestamp.valueOf(sdf.format(new java.sql.Timestamp(System.currentTimeMillis())) + " 00:00:00.000");
			
			//Get Data from disputed_recv
			sql=" SELECT tran_id, tran_date, site_code, cust_code, dispute_amt, confirmed, confirmed_date, emp_code__aprv, " +
					" remarks, chg_date, chg_user, chg_term,  rec_type " +
					" FROM disputed_recv " + 					
					" where tran_id = ?  ";
				
				pstmt = conn.prepareStatement(sql);							
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				System.out.println("tranId------["+ tranId+"]");				
				if(rs.next())
				{
					tranIdhdr = rs.getString(1);
					tranDate = rs.getTimestamp(2);
					siteCode = rs.getString(3);
					custCode = rs.getString(4);
					disputeAmt = rs.getDouble(5);
					confirmed = rs.getString(6);
					confirmedDate = rs.getTimestamp(7);
					empCodeAprv = rs.getString(8);
					remarks = rs.getString(9);
					chgDate = rs.getTimestamp(10);
					chgUser = rs.getString(11);
					chgTerm = rs.getString(12);
					recType = rs.getString(13);											
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("recType:["+recType+"]");
				if( recType != null || recType.trim().length() > 0)	
				{
					if(recType != null  && "R".equalsIgnoreCase(recType))
					{
						winName = "w_disputed_recv";
					}
					else
					{
						winName = "w_disputed_recv_new";
					}
				}
				else
				{	
					winName = "w_disputed_recv";
				}
				
				sql = " select ledg_post_conf from transetup where tran_window =  ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,winName);
				rs = pstmt.executeQuery();			
				if (rs.next())
				{
					ledgPostConf = checkNull(rs.getString(1));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(ledgPostConf != null  && "Y".equalsIgnoreCase(ledgPostConf))
				{
					/*if((tranDate.compareTo(today)!= 0))
					{*/
						tranDate = today;
						
						sql1 = "update disputed_recv set tran_date = ? where tran_id = ? ";	
						pstmt1 = conn.prepareStatement(sql1);
						pstmt1.setTimestamp(1, tranDate);
						pstmt1.setString(2, tranId);						
						int cnt = pstmt1.executeUpdate();
						pstmt1.close();
						pstmt1 = null;
					//}
					//disputedRecvMap.put("tran_date", tranDate);					
				}
				
				//Get Data from disputed_recv_det and receivables 
				  sql = "SELECT disputed_recv_det.tran_id, disputed_recv_det.line_no, disputed_recv_det.ref_ser, "+   
			       " disputed_recv_det.ref_id, disputed_recv_det.dispute_amt, receivables.ref_date,  "+ 
			       " receivables.due_date,  receivables.curr_code, receivables.exch_rate, receivables.cctr_code, "+   
			       " receivables.acct_code, disputed_recv_det.ref_type, disputed_recv_det.ref_type__o, disputed_recv_det.exp_rcp_date, disputed_recv_det.reas_code "+
			       " FROM disputed_recv_det, receivables  "+
			       " WHERE ( disputed_recv_det.ref_ser = receivables.tran_ser ) " +
			       " and ( disputed_recv_det.ref_id = receivables.ref_no ) " +
			       " and ( ( DISPUTED_RECV_DET.TRAN_ID = ? ) ) " +   
			       " ORDER BY disputed_recv_det.line_no ASC ";   
			  pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				System.out.println("tranId------["+ tranId+"]");
				int updCount = 0;
				while(rs.next())
				{
					updCount ++;
					
					tranId= rs.getString(1);
					lineNo= rs.getString(2);
					refSer = rs.getString(3);
					refId = rs.getString(4);
					disputeAmtDet = rs.getDouble(5);
					refDate = rs.getTimestamp(6);
					dueDate = rs.getTimestamp(7);
					currCode = rs.getString(8);
					exchRate = rs.getDouble(9);
					cctrCode = rs.getString(10);
					acctCode = rs.getString(11);
					refType =  rs.getString(12);
					refType = rs.getString(13);
					expRcpDate = rs.getTimestamp(14);
					reasCode = rs.getString(15);					
															
					if(recType != null  && "R".equalsIgnoreCase(recType))
					{
						sql1 = "select tot_amt, adj_amt, dispute_amt from receivables " +
								" where tran_ser = ? and ref_no = ? ";
						pstmt1 = conn.prepareStatement(sql1);
						pstmt1.setString(1, refSer);
						pstmt1.setString(2, refId);
						rs1 = pstmt1.executeQuery();
						if(rs1.next())
						{						
							totAmt = rs1.getDouble(1);
							adjAmt = rs1.getDouble(2);
							dispAmt = rs1.getDouble(3);
						}
						rs1.close();
						rs1 = null;
						pstmt1.close();
						pstmt1 = null;
						//if lc_totamt < (lc_adjamt + lc_dispamt + lc_dispute_amt ) or ( lc_dispamt + lc_dispute_amt ) < 0 then
						if (totAmt < (adjAmt + dispAmt + disputeAmtDet) || dispAmt + disputeAmtDet < 0)
						{							
							System.out.println("ledg_post_conf is alredy Y....");
							errString = itmDBAccessEJB.getErrorString("","VTAMT1   ","","",conn);							
							return errString;	
						
						}
						
						/**
						 * If rec_type in disputed_recv is 'R' then updates  disputeAmt = disputeAmt +  
						 * and refType, tranSer and refNo from disputed_recv_det in receivables.
						 * Otherwise updates the exp_rcp_date with reason code and refType in receivables						 * 
						*/	
						sql1 = "update receivables set dispute_amt = dispute_amt + ?, ref_type = ? " +
								" where tran_ser = ? and ref_no = ? ";
						pstmt1 = conn.prepareStatement(sql1);
						pstmt1.setDouble(1, disputeAmtDet);
						pstmt1.setString(2, recType);//refType
						pstmt1.setString(3, refSer);
						pstmt1.setString(4, refId);
						int cnt = pstmt1.executeUpdate();
						pstmt1.close();
						pstmt1 = null;
						System.out.println("update receivables dispute_amt & ref_type cnt["+cnt+"]");
					}
					else
					{		//recType = "R" end if
						sql1 = "update receivables set exp_rcp_date	= ?, reas_code = ?, ref_type = ? " +
								" where tran_ser = ? and ref_no = ?";
						pstmt1 = conn.prepareStatement(sql1);
						pstmt1.setTimestamp(1, expRcpDate);
						pstmt1.setString(2, reasCode);
						pstmt1.setString(3, recType);
						pstmt1.setString(4, refSer);
						pstmt1.setString(5, refId);
						int cnt = pstmt1.executeUpdate();
						pstmt1.close();
						pstmt1 = null;
						System.out.println("update receivables exp_rcp_date & reas_code cnt["+cnt+"]");
					}
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("Detail data count["+updCount+"]");
						
				loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
				chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
				
				System.out.println("loginEmpCode["+loginEmpCode+"]--chgUser["+chgUser+"]");								
				if(errString == null || errString.trim().length() == 0)
				{					
					System.out.println("loginEmpCode---"+loginEmpCode);
					sql = " update disputed_recv set confirmed = 'Y', confirmed_date = ?, emp_code__aprv = ? where tran_id = ? ";						
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, today);
					pstmt.setString(2, loginEmpCode);
					pstmt.setString(3, tranId);
					int updateCount = pstmt.executeUpdate();
					System.out.println("no of row update = "+updateCount);
					pstmt.close();
					pstmt = null;
					if(updateCount > 0)
					{

						errString = itmDBAccessEJB.getErrorString("","VTCICONF3","","",conn);
					}
					else 
					{						
						System.out.println("The Selected transaction is already confirmed");					
						errString = itmDBAccessEJB.getErrorString("","VTMCONF1   ","","",conn);
						return errString;
					}
					
					/*sql = " SELECT EDI_OPTION INTO :LS_EDI_OPTION FROM TRANSETUP where tran_window = ? ";						
					pstmt = conn.prepareStatement(sql);								
					pstmt.setString(, tranId);
					int updateCnt = pstmt.executeUpdate();
					System.out.println("no of row update = "+updateCnt);
					pstmt.close();
					pstmt = null;
					if(updateCnt > 0)
					{
							errString = itmDBAccessEJB.getErrorString("","VTCICONF3","","",conn);
					}
					else 
					{						
						System.out.println("The Selected transaction is already confirmed");
						errString = itmDBAccessEJB.getErrorString("","VTMCONF1","","",conn);					
						return errString;
					}*/
					
				}else 
				{
					//errString = itmDBAccessEJB.getErrorString("","VTDESNCONF ","","",conn);
					return errString;
				}
				
		}
		catch (Exception e) {			
			if(conn!=null)
			{
				try {
					conn.rollback();
				} catch (SQLException ex) {

					System.out.println("Exception : "+e);
					e.printStackTrace();
					throw new ITMException(e);

				}
			}
			System.out.println("Exception : "+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{	System.out.println("[-----errString----]["+errString+"]");									
					if( conn != null && !conn.isClosed() ) 
					{						
						System.out.println(errString.indexOf("VTCICONF3") > -1);
						if(errString.indexOf("VTCICONF3") > -1)
						{
							System.out.println("commited successfully");
							conn.commit();
						}
						else
						{
							conn.rollback();
						}
						conn.close();
						conn = null;
					}			
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				//conn.close();
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
	
	return errString;
}
    
	private String checkNull(String str) {
		if (str == null) {
			return "";
		} else {
			return str;
		}

	}

	private double checkIntNull(String str) {
		if (str == null || str.trim().length() == 0) {
			return 0;
		} else {
			return Double.parseDouble(str);
		}

	}

	private double checkDoubleNull(String str) {
		if (str == null || str.trim().length() == 0) {
			return 0.0;
		} else {
			return Double.parseDouble(str);
		}
	}


}
