package ibase.dashboard.common.hibernate.utility;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;

import ibase.utility.CommonConstants;
public class HibernateUtil 
{
	private static SessionFactory sessionFactory = null;
	static 
	{
		try 
		{
			//String hibernetCfgPath = "hibernate.cfg.xml";
			String hibernetCfgPath = CommonConstants.JBOSSHOME+File.separator+"server"+File.separator+"default"+File.separator+"deploy"+File.separator+"ibase.ear"+File.separator+"ibase.war"+File.separator+"setting"+File.separator+"hibernate.cfg.xml";
			//String hibernetCfgPath ="/home/base/OfficeWork/eclipseWS/PlaceTimeEntityWebService/hibernate.cfg.xml";
			System.out.println("path for cfg file is ===="+hibernetCfgPath);
			File file = new File(hibernetCfgPath);
			System.out.println("file.exist():"+file.exists());
			System.out.println("cfg file ===="+file.getAbsolutePath());
			System.out.println("new Configuration() ===="+new Configuration());
			
			/*Configuration configuration = new Configuration().configure(file);
			System.out.println("path for cfg file is ===="+hibernetCfgPath);
			ServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().applySettings(configuration.getProperties()).build();
			sessionFactory = configuration.buildSessionFactory(serviceRegistry);*/
		
			
			StandardServiceRegistry standardRegistry = new StandardServiceRegistryBuilder().configure(new File(hibernetCfgPath)).build();
	    	Metadata metaData = new MetadataSources(standardRegistry).getMetadataBuilder().build();
	    	sessionFactory = metaData.getSessionFactoryBuilder().build();
			
			System.out.println("Session factory created successfully:"+sessionFactory);
		} 
		catch (Exception ex) 
		{
			System.out.println("Initial SessionFactory creation failed." + ex);
			throw new ExceptionInInitializerError(ex);
		}
	}
	public static SessionFactory getSessionFactory() 
	{
		return sessionFactory;
	}
	public static void shutdown() 
	{
		getSessionFactory().close();
	}
	private static final Map<String, SessionFactory> sessionFactories = new HashMap<String, SessionFactory>();

	private static SessionFactory buildSessionFactory(String dbName) 
	{
		System.out.println("dbName is ==="+dbName);
		try 
		{
			//String hibernetCfgPath = "hibernate.cfg.xml";
			String hibernetCfgPath = CommonConstants.JBOSSHOME+File.separator+"server"+File.separator+"default"+File.separator+"deploy"+File.separator+"ibase.ear"+File.separator+"ibase.war"+File.separator+"setting"+File.separator+"hibernate.cfg.xml";
			//String hibernetCfgPath ="/home/base/OfficeWork/eclipseWS/PlaceTimeEntityWebService/hibernate.cfg.xml";

			System.out.println("path for cfg file is ===="+hibernetCfgPath);
			
			StandardServiceRegistry standardRegistry = new StandardServiceRegistryBuilder().configure(new File(hibernetCfgPath)).build();
	    	Metadata metaData = new MetadataSources(standardRegistry).getMetadataBuilder().build();
	    	sessionFactory = metaData.getSessionFactoryBuilder().build();
	    	sessionFactories.put(dbName,sessionFactory);
	    	
	        return sessionFactory;
		} 
		catch (final HibernateException e) 
		{
			System.err.println("Initial SessionFactory creation failed." + e);
			e.printStackTrace();
			throw new ExceptionInInitializerError(e);
	    }
		catch (Throwable ex) 
		{
			// Make sure you log the exception, as it might be swallowed
			System.err.println("Initial SessionFactory creation failed." + ex);
			ex.printStackTrace();
			throw new ExceptionInInitializerError(ex);
		}
	}
	
	public static SessionFactory getSessionFactory(String dbName) 
	{
		System.out.println("Inside getSessionFactory method :::"+dbName);
		if( "DEFAULT".equalsIgnoreCase(dbName) )
		{
			if(getSessionFactory().isClosed())
			{
				buildSessionFactory(dbName);
			}
			return getSessionFactory();
		}
		else
		{
			SessionFactory sessionFactory = sessionFactories.get(dbName);
			if( sessionFactory == null || sessionFactory.isClosed() )
			{
				sessionFactory = buildSessionFactory(dbName);
			}
			return sessionFactory;
		}
	}

	public static void shutdown(String dbName) 
	{
		// Close caches and connection pools
		getSessionFactory(dbName).close();
	}
	
	/* Added By Saitej Dhaul On 18 Dec 2018 START */
	
	public static String DB_DATE_FORMAT = "yyyy-MM-dd";
	public static String APPL_DATE_FORMAT = "dd/MM/yyyy";
	
	//Get Date object in Provided Format
	public static Date getDateObject(String dateStr, String dateFormat) 
	{
		Date dateObj = null;
		SimpleDateFormat simpleDateFormat = null;
		try
		{			
			simpleDateFormat = new SimpleDateFormat(dateFormat);
			dateObj = simpleDateFormat.parse(dateStr);
		}
		catch(Exception e)
		{
			System.out.println("Exception :GenericUtility :getDateObject :==>\n"+e.getMessage());
			e.printStackTrace();
		}
		return dateObj;
	}
	
	//While Sending date to Client End
	//Get formatted Date String DB to APPL format
	public static String getValidDB2APPLDate(String dateStr)
	{
		return getValidDateString(dateStr, DB_DATE_FORMAT, APPL_DATE_FORMAT);
	}
	
	//While inserting / updating date to Database
	//Get formatted Date String APPL to DB format
	public static String getValidAPPL2DBDate(String dateStr)
	{
		return getValidDateString(dateStr, APPL_DATE_FORMAT, DB_DATE_FORMAT);
	}
	
	private static String getValidDateString(String dateStr, String sourceDateFormat, String targetDateFormat) 
	{
		Object date = null;
		SimpleDateFormat sdfOutput = null;
		String retDateStr = "";
		try
		{
			if (!(sourceDateFormat.equalsIgnoreCase(targetDateFormat)))
			{
				if (sourceDateFormat.indexOf("/") != -1)
				{
					dateStr.replace('/', '-');
				}
				else if (sourceDateFormat.indexOf(".") != -1)
				{
					dateStr.replace('.', '-');
				}

				date = new SimpleDateFormat(sourceDateFormat).parse(dateStr);
				sdfOutput = new SimpleDateFormat(targetDateFormat);
				retDateStr = sdfOutput.format(date);
			}
			else
			{
				retDateStr = dateStr;
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception :GenericUtility :getValidDateString :==>"+e.getMessage());
			e.printStackTrace();
		}
		return retDateStr;
	}

	/* Added By Saitej Dhaul On 18 Dec 2018 END */
	
}