SET DEFINE OFF;

ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_FNAME_LONG VARCHAR2(30);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_MNAME_LONG VARCHAR2(30);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_LNAME_LONG VARCHAR2(30);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_FNAME_LONG_O VARCHAR2(30);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_MNAME_LONG_O VARCHAR2(30);
ALTER TABLE EMPLOYEE_DET_CHANGE ADD EMP_LNAME_LONG_O VARCHAR2(30);


UPDATE EMPLOYEE_DET_CHANGE SET EMP_FNAME_LONG = EMP_FNAME WHERE EMP_FNAME_LONG IS NULL;
UPDATE EMPLOYEE_DET_CHANGE SET EMP_MNAME_LONG = EMP_MNAME WHERE EMP_MNAME_LONG IS NULL;
UPDATE EMPLOYEE_DET_CHANGE SET EMP_LNAME_LONG = EMP_LNAME WHERE EMP_LNAME_LONG IS NULL;

UPDATE EMPLOYEE_DET_CHANGE SET EMP_FNAME_LONG_O = EMP_FNAME_O WHERE EMP_FNAME_LONG_O IS NULL;
UPDATE EMPLOYEE_DET_CHANGE SET EMP_MNAME_LONG_O = EMP_MNAME_O WHERE EMP_MNAME_LONG_O IS NULL;
UPDATE EMPLOYEE_DET_CHANGE SET EMP_LNAME_LONG_O = EMP_LNAME_O WHERE EMP_LNAME_LONG_O IS NULL;
COMMIT;

ALTER TABLE EMPLOYEE_DET_CHANGE MODIFY EMP_FNAME_LONG NOT NULL;
ALTER TABLE EMPLOYEE_DET_CHANGE MODIFY EMP_MNAME_LONG NOT NULL;
ALTER TABLE EMPLOYEE_DET_CHANGE MODIFY EMP_LNAME_LONG NOT NULL;
ALTER TABLE EMPLOYEE_DET_CHANGE MODIFY EMP_FNAME_LONG_O NOT NULL;
ALTER TABLE EMPLOYEE_DET_CHANGE MODIFY EMP_MNAME_LONG_O NOT NULL;
ALTER TABLE EMPLOYEE_DET_CHANGE MODIFY EMP_LNAME_LONG_O NOT NULL;

Create Or Replace Trigger Trg_empdetchg_Empnames Before Insert Or Update On Employee_Det_Change 
REFERENCING OLD AS OLD NEW AS NEW FOR EACH ROW 

BEGIN

	IF :NEW.EMP_FNAME_LONG_O IS NULL AND :NEW.EMP_FNAME_O IS NOT NULL THEN
		:NEW.EMP_FNAME_LONG_O := :NEW.EMP_FNAME_O;
	ELSIF :NEW.EMP_FNAME_LONG_O IS NOT NULL AND :NEW.EMP_FNAME_O IS NULL THEN
		:NEW.EMP_FNAME_O := :NEW.EMP_FNAME_LONG_O ;
	END IF;

	IF :NEW.EMP_MNAME_LONG_O IS NULL AND :NEW.EMP_MNAME_O IS NOT NULL THEN
		:NEW.EMP_MNAME_LONG_O := :NEW.EMP_MNAME_O;
	ELSIF :NEW.EMP_MNAME_LONG_O IS NOT NULL AND :NEW.EMP_MNAME_O IS NULL THEN
		:NEW.EMP_MNAME_O := :NEW.EMP_MNAME_LONG_O ;
	END IF;

	IF :NEW.EMP_LNAME_LONG_O IS NULL AND :NEW.EMP_LNAME_O IS NOT NULL THEN
		:NEW.EMP_LNAME_LONG_O := :NEW.EMP_LNAME_O;
	ELSIF :NEW.EMP_LNAME_LONG_O IS NOT NULL AND :NEW.EMP_LNAME_O IS NULL THEN
		:NEW.EMP_LNAME_O := :NEW.EMP_LNAME_LONG_O ;
	END IF;

	IF :NEW.EMP_FNAME_LONG IS NULL AND :NEW.EMP_FNAME IS NOT NULL THEN
		:NEW.EMP_FNAME_LONG := :NEW.EMP_FNAME;
	ELSIF :NEW.EMP_FNAME_LONG IS NOT NULL AND :NEW.EMP_FNAME IS NULL THEN
		:NEW.EMP_FNAME := TRIM(SUBSTR(:NEW.EMP_FNAME_LONG,1,15)) ;
	ELSIF :NEW.EMP_FNAME_LONG <> :OLD.EMP_FNAME_LONG AND :NEW.EMP_FNAME = :OLD.EMP_FNAME THEN
		:NEW.EMP_FNAME := TRIM(SUBSTR(:NEW.EMP_FNAME_LONG,1,15)) ;
	ELSIF :NEW.EMP_FNAME_LONG = :OLD.EMP_FNAME_LONG AND :NEW.EMP_FNAME <> :OLD.EMP_FNAME THEN
		:NEW.EMP_FNAME_LONG := :NEW.EMP_FNAME;
	END IF;

	IF :NEW.EMP_MNAME_LONG IS NULL AND :NEW.EMP_MNAME IS NOT NULL THEN
		:NEW.EMP_MNAME_LONG := :NEW.EMP_MNAME;
	ELSIF :NEW.EMP_MNAME_LONG IS NOT NULL AND :NEW.EMP_MNAME IS NULL THEN
		:NEW.EMP_MNAME := TRIM(SUBSTR(:NEW.EMP_MNAME_LONG,1,15)) ;
	ELSIF :NEW.EMP_MNAME_LONG <> :OLD.EMP_MNAME_LONG AND :NEW.EMP_MNAME = :OLD.EMP_MNAME THEN
		:NEW.EMP_MNAME := TRIM(SUBSTR(:NEW.EMP_MNAME_LONG,1,15)) ;
	ELSIF :NEW.EMP_MNAME_LONG = :OLD.EMP_MNAME_LONG AND :NEW.EMP_MNAME <> :OLD.EMP_MNAME THEN
		:NEW.EMP_MNAME_LONG := :NEW.EMP_MNAME;
	END IF;

	IF :NEW.EMP_LNAME_LONG IS NULL AND :NEW.EMP_LNAME IS NOT NULL THEN
		:NEW.EMP_LNAME_LONG := :NEW.EMP_LNAME;
	ELSIF :NEW.EMP_LNAME_LONG IS NOT NULL AND :NEW.EMP_LNAME IS NULL THEN
		:NEW.EMP_LNAME := TRIM(SUBSTR(:NEW.EMP_LNAME_LONG,1,15)) ;
	ELSIF :NEW.EMP_LNAME_LONG <> :OLD.EMP_LNAME_LONG AND :NEW.EMP_LNAME = :OLD.EMP_LNAME THEN
		:NEW.EMP_LNAME := TRIM(SUBSTR(:NEW.EMP_LNAME_LONG,1,15)) ;
	ELSIF :NEW.EMP_LNAME_LONG = :OLD.EMP_LNAME_LONG AND :NEW.EMP_LNAME <> :OLD.EMP_LNAME THEN
		:NEW.EMP_LNAME_LONG := :NEW.EMP_LNAME;
	END IF;


END;
/

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_det_chg',
	'1',
	'emp_fname_long',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_det_chg',
	'1',
	'emp_mname_long',
	'Y'
);

INSERT INTO OBJ_ITEMCHANGE 
(
	OBJ_NAME,
	FORM_NO,
	FIELD_NAME,
	MANDATORY
)
VALUES 
(
	'emp_det_chg',
	'1',
	'emp_lname_long',
	'Y'
);

COMMIT;

