import { Component, OnInit, Input, Output, EventEmitter, ViewChild } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { Http } from '@angular/http';
import { EcmTemplateInterface } from './ecm-template.component';
import { ItemDetail } from '../../ecm-model/product-detail-model';
import { EcmRecentViewComponent } from '../../ecm-view/ecm-recent-view/ecm-recent-view.component';

@Component( {
    selector: 'ecm-celebration',
    templateUrl: './ecm-celebration.component.html',
    styleUrls: ['./ecm-celebration.component.css']
})
export class EcmCelebrationComponent implements OnInit, EcmTemplateInterface {

    @Input() itemDetail: ItemDetail;
    @Output() scrollToReviews = new EventEmitter();
    @Output() doActivity = new EventEmitter();
    @ViewChild( 'recentView' ) recentView: EcmRecentViewComponent;

    userActionUrl = '/ecm/service/feeds/cart';
    itemCode;
    myCity;
    actionPerformed
    activityPerformed;
    transPortFacility;
    thingsToCarry;
    itemDetailpath;

    constructor( private route: ActivatedRoute, private router: Router, private http: Http ) { }

    ngOnInit() {
    
        console.log( "ngOnInit EcmCelebrationComponent Object Keys : " + Object.keys( this.itemDetail ) )
        console.log( this.itemDetail );
        this.route.params.subscribe( params => {
            this.itemCode = params['key'];
        });

        this.myCity = localStorage.getItem( 'mycity' );

    }

    ngAfterViewInit() {
        this.recentView.ngOnInit();
    }

    ngOnDestroy() {
        if ( this.recentView )
            this.recentView.doDestroy( this.itemDetail.itemCode );
    }

    createRatings( ratings ) {
        var rating: number[] = [];
        for ( var i = 1; i <= ratings; i++ ) {
            rating.push( i );
        }
        return rating;
    }

}
