/**
 * PURPOSE : Validation and Itemchange for Replenishment Issue
 * AUTHOR : Lalit
 * DATE : 24/08/2011
 */

package ibase.webitm.ejb.wms;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;

import org.w3c.dom.*;

import javax.ejb.*;
import javax.naming.InitialContext;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class ReplIssIC extends ValidatorEJB implements ReplIssICLocal, ReplIssICRemote 
{
	/**
	 * The method is defined without any parameter and returns blank string
	 */
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(DOM)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();    

		try
		{
			System.out.println( "xmlString ::" + xmlString);
			System.out.println( "xmlString1 ::" + xmlString1);
			System.out.println( "xmlString2 ::" + xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			errString = wfValData( currFormDataDom, hdrDataDom, allFormDataDom, objContext, xtraParams);
			System.out.println( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	public String wfValData(Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String xtraParams) throws RemoteException, ITMException
	{   				
		String replOrder = "";
		String columnValue = "", objName = "";			
		String errString = "";
		String lpnNo = "";
		String lpnNoBrow = "";
		String itemCode = "";
		String siteCode = "";		
		String lotNo = "";
		String lotSl = "";
		String locCodeTo = "";
		String locCodeSys = "";//variable added by deepak - 25/11/11
		String confirmed = "";
		String singleLotSl = "";
		String itemLotOpt = "";
		String rowCountStr = "";
		String sql = "";
		String itemLocType = "";
		String locationLocType = "";
		String tranID = "*";
		String sugLocInvstat = "";
		String pickType = "";
		String varName = "";
		String lotSlNew = "";
		String pickOrder = "", orderType = "",cartonNo = "";
		
		//Changed By Rohan on 06-09-12 to define variable.start
		String status = "";
		String sqlStatus = "";
		String replOrd = "";
		//Changed By Rohan on 06-09-12 to define variable.end
		//Changed by sumit on 06/08/12 
		String locCode = ""; 
		//Changed by sankara on 10-08-12 [start]
		String waveId = "";
		String holdStatus = "";
		//Changed by sankara on 10-08-12 [end]
		//Changed by Rohan on 06-10-12 for define variable.start
		String sqlitem = "";
		String hazMaterial = "";
		String sqlPtcn = "";
		String ptcnReport = "";
		PreparedStatement pstmtitem = null;
		ResultSet rsitem = null;
		String sqlTran = "";		
		//Changed by Rohnan on 15-10-12 for bug fixing
		//String pickOrd = "";
		String replOrderS = "";
		String transMode = "";
		String itemCd = "";
		String sqlptcn = "";
		String ptcnHaz = "";
		String waveIdHaz = "";
		//Changed by Rohan on 06-10-12 for define variable.end
		//Chnaged by Rohan on 29-10-12 to define variable.start
		String sqlCancle = "";
		String cancleStatus = "";
		//Changed by Rohan on 29-10-12 to define variable.end
		
		//Changed By Rohan on 29-12-10 to define variables.start
		String pickOrd = "";
		String PicklineNoOrd = "";
	    String sqlReplCnt = "";
	    java.util.Date tranDate = null;
		String prdCode = "";
	    int cntRepl = 0;
	  //Changed By Rohan on 29-12-10 to define variables.end
	    String noArt = "";//Changed by sumit on 25/02/13
		DistCommon distCommon = new DistCommon();

		List<String> lpnNoList;

		int count = 0;
		int rowCount = 0;
		int noOfChilds = 0;
		int noOfParent = 0;
		int lineNoOrd = 0, cnt = 0;

		double quantity = 0.0;

		GenericUtility genericUtility = GenericUtility.getInstance();

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;		

		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "";
		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();

		DistCommon distComm = new DistCommon();
		//Changed by sumit on 20/09/12 declare ptcn variable.
		String ptcn = "";
		 //changed by sankara on 18/11/13 validation for different assign user
		 String assignTo = "";
		//changed by sankara on 12/04/14 validation for compared alloc_qty from srodalloc
	     double stockalloocqty = 0.0;
	     double sordallocqty = 0.0;
	     double activeReplQty = 0.0;

		try
		{	
			int currentFormNo = 0;				
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverValidator" );
			SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );

			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			
			objName = checkNullAndTrim(getObjNameFromDom( hdrDataDom, "objName", "1" ));
			System.out.println(" objName =[" + objName + "]");

			NodeList parentList = currFormDataDom.getElementsByTagName( "Detail" + currentFormNo );
			NodeList childList = null;	
			noOfParent = parentList.getLength();						

			switch ( currentFormNo )  // Switch Case for form number
			{
			case 1:
			{	
				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();

				for ( int ctr = 0; ctr < noOfChilds; ctr++ ) //Loop for each node of current detail
				{	
					Node childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					String childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					if ( "repl_order".equalsIgnoreCase( childNodeName ) )
					{
						replOrder = genericUtility.getColumnValue( "repl_order", currFormDataDom );
						if( replOrder == null || replOrder.trim().length() == 0 )
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "repl_order", "NULREPLORD", userId );
							errList.add( "NULREPLORD" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						else
						{

							sql = "SELECT COUNT(*) AS COUNT FROM REPL_ORD_HDR WHERE REPL_ORDER = ?";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, replOrder );
							rs = pstmt.executeQuery();

							if( rs.next() )
							{
								count = rs.getInt("COUNT");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if( count <= 0 )
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString( "repl_order", "INVREPLORD", userId );
								errList.add( "INVREPLORD" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
							else
							{
								//Changed by sumit on 28/09/12 validation in case of wave canceled start.
								//Changed by sumit on 02/10/12 stop validation as this repl is required for other wave task task (as per pragyan) start   
								/*sql = " SELECT WAVE_TASK.CANCEL FROM WAVE_TASK, REPL_ORD_HDR " +
										" WHERE REPL_ORD_HDR.WAVE_ID = WAVE_TASK.WAVE_ID " +
										" AND REPL_ORD_HDR.REPL_ORDER = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, replOrder);
								rs = pstmt.executeQuery();
								if( rs.next())
								{
									System.out.println(" wave cancel - >["+rs.getString("CANCEL")+"]");
									if( "Y".equalsIgnoreCase(rs.getString("CANCEL")))
									{
										errList.add( "REPLCANCEL" );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;		*/		
								//Changed by sumit on 02/10/12 stop validation as this repl is required for other wave task task (as per pragyan) end.
								//Changed by sumit on 28/09/12 validation in case of wave canceled end.
								
								//Changed by Rohan on 19-02-13 to add validation if all replanishment line item cancle.start
								
								sql=" SELECT COUNT(*) AS CNT FROM REPL_ORD_DET WHERE REPL_ORDER = ? AND CASE WHEN CANCEL_MODE IS NULL THEN 'N' ELSE CANCEL_MODE END <> 'Y' ";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, replOrder );
								rs = pstmt.executeQuery();

								if( rs.next() )
								{
									cntRepl = rs.getInt("CNT");
								}
								System.out.println("cntRepl::::"+cntRepl);
								if(cntRepl == 0)
								{
									errList.add( "CANCELREPL" );
									errFields.add( childNodeName.toLowerCase() );
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;		
								//Changed by Rohan on 19-02-13 to add validation if all replanishment line item cancle.end

								//Changed by sankara on 10-08-2012 for proces hold[start]
								sql=" SELECT WAVE_ID FROM REPL_ORD_HDR WHERE REPL_ORDER = ? ";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, replOrder );
								rs = pstmt.executeQuery();

								if( rs.next() )
								{
									waveId = rs.getString("WAVE_ID");
								}

								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if(waveId != null && waveId.trim().length() > 0)
								{
									sql= "SELECT HOLD_STATUS FROM WAVE_TASK WHERE WAVE_ID = ? ";
									pstmt = conn.prepareStatement( sql );
									pstmt.setString( 1, waveId );
									rs = pstmt.executeQuery();
								if( rs.next() )
								{
									holdStatus = rs.getString("HOLD_STATUS");
								}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
								}
								if("Y".equalsIgnoreCase(holdStatus))
								{
									errList.add( "PRCESHLD" );
									errFields.add( childNodeName.toLowerCase() );
								}
								
								//Changed by sankara on 10-08-2012 for proces hold[end]

								sql = "SELECT CONFIRMED FROM REPL_ISS_HDR WHERE REPL_ORDER = ?";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, replOrder );
								rs = pstmt.executeQuery();

								if( rs.next() )
								{
									confirmed = rs.getString("CONFIRMED");
									//orderType = rs.getString("ORDER_TYPE");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if ( confirmed != null && confirmed.trim().length() > 0 && "Y".equalsIgnoreCase(confirmed.trim()) )
								{
									errList.add( "REPISSCNF1" );
									errFields.add( childNodeName.toLowerCase() );
								}

								sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR WHERE REPL_ORDER = ?";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, replOrder );
								rs = pstmt.executeQuery();

								if( rs.next() )
								{
									orderType = rs.getString("ORDER_TYPE");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								//Changed By Pragyan 
								//if ( "active_repl_iss".equalsIgnoreCase(objName) && ! orderType.trim().equalsIgnoreCase("A") && ! orderType.trim().equalsIgnoreCase("E"))
								System.out.println("objName****"+objName+"orderType***"+orderType);
								if ( "active_repl_iss".equalsIgnoreCase(objName) && ! orderType.trim().equalsIgnoreCase("A") && ! orderType.trim().equalsIgnoreCase("E") && ! orderType.trim().equalsIgnoreCase("Q")  && ! orderType.trim().equalsIgnoreCase("T") && ! orderType.trim().equalsIgnoreCase("I") && ! orderType.trim().equalsIgnoreCase("P"))
								{
									
									/*errList.add( "ACTIVEPICK" );
									errFields.add( childNodeName.toLowerCase() );*/
									if(orderType.trim().equalsIgnoreCase("I"))
									{
										errList.add( "IDONETHNOM" );
										errFields.add( childNodeName.toLowerCase() );
										
									}
									else
									{
										errList.add( "VTACTREPLO" );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
								//Changed By Pragyan 07-apr-14 to "E" remove error type from replenishment 
								//Changed By Pragyan 
								//else if ( "repl_iss".equalsIgnoreCase(objName) && ! orderType.trim().equalsIgnoreCase("C") &&  ! orderType.trim().equalsIgnoreCase("M") &&  ! orderType.trim().equalsIgnoreCase("E")  &&  ! orderType.trim().equalsIgnoreCase("F")  &&  ! orderType.trim().equalsIgnoreCase("G")  &&  ! orderType.trim().equalsIgnoreCase("H")  &&  ! orderType.trim().equalsIgnoreCase("J")  &&  ! orderType.trim().equalsIgnoreCase("K") && ! orderType.trim().equalsIgnoreCase("I") )//added by akhilesh on 23/jun/2012 put upper condition(orderType.trim().equalsIgnoreCase("I")) in this if
								//Changed by Rohan on 05-09-12 for stock to dock replanishment
								//else if ( "repl_iss".equalsIgnoreCase(objName) && ! orderType.trim().equalsIgnoreCase("C") &&  ! orderType.trim().equalsIgnoreCase("M") &&  ! orderType.trim().equalsIgnoreCase("E")  &&  ! orderType.trim().equalsIgnoreCase("F")  &&  ! orderType.trim().equalsIgnoreCase("G")  &&  ! orderType.trim().equalsIgnoreCase("H")  &&  ! orderType.trim().equalsIgnoreCase("J")  &&  ! orderType.trim().equalsIgnoreCase("K") && ! orderType.trim().equalsIgnoreCase("I") && ! orderType.trim().equalsIgnoreCase("Q")  && ! orderType.trim().equalsIgnoreCase("D") && ! orderType.trim().equalsIgnoreCase("L"))//added by akhilesh on 23/jun/2012 put upper condition(orderType.trim().equalsIgnoreCase("I")) in this if		
								//else if ( "repl_iss".equalsIgnoreCase(objName) && ! orderType.trim().equalsIgnoreCase("C") &&  ! orderType.trim().equalsIgnoreCase("M") &&  ! orderType.trim().equalsIgnoreCase("E")  &&  ! orderType.trim().equalsIgnoreCase("F")  &&  ! orderType.trim().equalsIgnoreCase("G")  &&  ! orderType.trim().equalsIgnoreCase("H")  &&  ! orderType.trim().equalsIgnoreCase("J")  &&  ! orderType.trim().equalsIgnoreCase("K") && ! orderType.trim().equalsIgnoreCase("I") &&  ! orderType.trim().equalsIgnoreCase("D") && ! orderType.trim().equalsIgnoreCase("L"))//added by akhilesh on 23/jun/2012 put upper condition(orderType.trim().equalsIgnoreCase("I")) in this if
								//else if ( "repl_iss".equalsIgnoreCase(objName) && ! orderType.trim().equalsIgnoreCase("C") &&  ! orderType.trim().equalsIgnoreCase("M") &&  ! orderType.trim().equalsIgnoreCase("E")  &&  ! orderType.trim().equalsIgnoreCase("F")  &&  ! orderType.trim().equalsIgnoreCase("G")  &&  ! orderType.trim().equalsIgnoreCase("H")  &&  ! orderType.trim().equalsIgnoreCase("J")  &&  ! orderType.trim().equalsIgnoreCase("K") && ! orderType.trim().equalsIgnoreCase("I") &&  ! orderType.trim().equalsIgnoreCase("D") && ! orderType.trim().equalsIgnoreCase("L"))//added by akhilesh on 23/jun/2012 put upper condition(orderType.trim().equalsIgnoreCase("I")) in this if
								else if ( "repl_iss".equalsIgnoreCase(objName) && ! orderType.trim().equalsIgnoreCase("C") &&  ! orderType.trim().equalsIgnoreCase("M") &&  ! orderType.trim().equalsIgnoreCase("F")  &&  ! orderType.trim().equalsIgnoreCase("G")  &&  ! orderType.trim().equalsIgnoreCase("H")  &&  ! orderType.trim().equalsIgnoreCase("J")  &&  ! orderType.trim().equalsIgnoreCase("K") && ! orderType.trim().equalsIgnoreCase("I") &&  ! orderType.trim().equalsIgnoreCase("D") && ! orderType.trim().equalsIgnoreCase("L"))//added by akhilesh on 23/jun/2012 put upper condition(orderType.trim().equalsIgnoreCase("I")) in this if
								{
									/*System.out.println("equals ignores case");
									errList.add( "CASEPICK" );
									errFields.add( childNodeName.toLowerCase() );*/
									
									if(orderType.trim().equalsIgnoreCase("E"))
									{
										System.out.println("equals ignores case");
										errList.add( "EDONETHACT" );
										errFields.add( childNodeName.toLowerCase() );
										
									}
									else
									{
										System.out.println("equals ignores case");
										errList.add( "VTCASREPLO" );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
								//Change by Rohan on 05-09-12
								//else if ( "repl_iss_dock".equalsIgnoreCase(objName) && ! orderType.trim().equalsIgnoreCase("D") &&  ! orderType.trim().equalsIgnoreCase("L") )
								//else if ( "repl_iss_dock".equalsIgnoreCase(objName) &&  ! orderType.trim().equalsIgnoreCase("L") )
								else if ( "repl_iss_dock".equalsIgnoreCase(objName) &&  ! orderType.trim().equalsIgnoreCase("D") &&  ! orderType.trim().equalsIgnoreCase("L") )
								{
									//errList.add( "CASEPICK" );
									errList.add( "REPLPICK" );
									errFields.add( childNodeName.toLowerCase() );
								}
								
								/*//Changed by Rohan on 06-09-12 to check previous task finish or not.start
								//if("L".equalsIgnoreCase(orderType) || "Q".equalsIgnoreCase(orderType) || "T".equalsIgnoreCase(orderType))
								if("L".equalsIgnoreCase(orderType))
								{
									
									System.out.println("Enter in order type L");
									sql = "SELECT REPL_ORDER FROM REPL_ORD_DET WHERE PICK_ORDER = ?";
									pstmt = conn.prepareStatement( sql );
									pstmt.setString( 1, replOrder );
									
									rs = pstmt.executeQuery();

									if( rs.next() )
									{
										replOrd = rs.getString("REPL_ORDER");
									}
									
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									
									sqlStatus = "SELECT STATUS FROM WAVE_TASK_DET WHERE REF_ID = ?";
									pstmt = conn.prepareStatement( sqlStatus );
									pstmt.setString( 1, replOrd );
									
									rs = pstmt.executeQuery();

									if( rs.next() )
									{
										status = rs.getString("STATUS");
									}
									
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									
									if("N".equalsIgnoreCase(status))
									{
										errList.add( "PRVTASK" );
										errFields.add( childNodeName.toLowerCase() );
									}
									
								}
								//Changed by Rohan on 06-09-12 to check previous task finish or not.end
*/								
								// cpatil start on 11-sept-12 
								
								
								pickOrder = checkNull(genericUtility.getColumnValue( "REPL_ORDER", currFormDataDom  ));
								
								//Changed By Pragyan 08-May-14 to check the cancel mode for hold stocks
								/*sql = " select count (*) from stock where (item_code, site_code, loc_code, lot_no, lot_sl ) in  " +
									  " ( select item_code, site_code, loc_code, lot_no, lot_sl from repl_ord_det where repl_order = ? ) and ( hold_qty > 0 ) ";*/
								sql = " select count (*) from stock where (item_code, site_code, loc_code, lot_no, lot_sl ) in  " +
										  " ( select item_code, site_code, loc_code, lot_no, lot_sl from repl_ord_det where repl_order = ? " +
										  " and case when cancel_mode is null then 'N' else  cancel_mode end <> 'Y') and ( hold_qty > 0 )";
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,replOrder);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									cnt = rs.getInt(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								if( cnt > 0 )
								{
									errList.add( "INVITMQTST" );
									errFields.add( childNodeName.toLowerCase() );
								}
								// cpatil end on 11-sept-12
								//Changed by Rohan on 29-10-12 to add warning msg on replanishment scan if wave cancle.start
								
								sqlCancle = "SELECT CANCEL FROM WAVE_TASK WHERE WAVE_ID = ?";
								pstmt =  conn.prepareStatement(sqlCancle);
								pstmt.setString(1,waveId);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									cancleStatus = checkNull(rs.getString("CANCEL"));
								}
								//Changed By rohan to add validation in case of stock to dock if wave cancle.start
								if("D".equalsIgnoreCase(orderType) || "L".equalsIgnoreCase(orderType) || "H".equalsIgnoreCase(orderType))
								{
									if("Y".equalsIgnoreCase(cancleStatus.trim()))
									{
										errList.add( "NTREPLSCAN" );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
								else
								{	
								//Changed By rohan to add validation in case of stock to dock if wave cancle.end
									if("Y".equalsIgnoreCase(cancleStatus.trim()))
									{
										errList.add( "REPLWAVCAN" );
										errFields.add( childNodeName.toLowerCase() );
									}
								//Changed By rohan to add validation in case of stock to dock if wave cancle	
								}	
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								//Changed by Rohan on 29-10-12 to add warning msg on replanishment scan if wave cancle.end
							}
							
						}
						
						
						//Changed By Pragyan 
						//Changed by Rohan on 06-09-12 to check previous task finish or not.start
						//if("L".equalsIgnoreCase(orderType) || "Q".equalsIgnoreCase(orderType) || "T".equalsIgnoreCase(orderType))
						//if(!"F".equalsIgnoreCase(orderType) && !"G".equalsIgnoreCase(orderType) && !"E".equalsIgnoreCase(orderType))
						if("I".equalsIgnoreCase(orderType) || "J".equalsIgnoreCase(orderType) || "K".equalsIgnoreCase(orderType) ||  "L".equalsIgnoreCase(orderType) || "Q".equalsIgnoreCase(orderType) || "T".equalsIgnoreCase(orderType))
						{
							
							System.out.println("Enter in order type L");
							//sql = "SELECT REPL_ORDER FROM REPL_ORD_DET WHERE PICK_ORDER = ?";
							sql = "SELECT PICK_ORDER FROM REPL_ORD_DET WHERE REPL_ORDER = ? AND PICK_ORDER IS NOT NULL";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, replOrder );
							
							rs = pstmt.executeQuery();

							if( rs.next() )
							{
								//replOrd = rs.getString("REPL_ORDER");
								replOrd = rs.getString("PICK_ORDER");
							}
							
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							sqlStatus = "SELECT STATUS FROM WAVE_TASK_DET WHERE REF_ID = ?";
							pstmt = conn.prepareStatement( sqlStatus );
							pstmt.setString( 1, replOrd );
							
							rs = pstmt.executeQuery();

							if( rs.next() )
							{
								status = rs.getString("STATUS");
							}
							
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							
							if("N".equalsIgnoreCase(status))
							{
								errList.add( "PRVTASK" );
								errFields.add( childNodeName.toLowerCase() );
							}
							
						}
						//Changed by Rohan on 06-09-12 to check previous task finish or not.end
						//changed by sankara on 18/11/13 validation for different assign user start.
						sql = " SELECT ASSIGN_TO FROM REPL_ORD_HDR WHERE REPL_ORDER = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, replOrder );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							assignTo = checkNull (rs.getString("ASSIGN_TO"));
						}					
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						System.out.println("userId:"+userId);
						System.out.println("assignTo:"+assignTo);
						if(assignTo !=null && assignTo.trim().length() > 0 && !assignTo.trim().equalsIgnoreCase(userId) )
						{
							errList.add( "INVREPKTSK" );
							errFields.add( childNodeName.toLowerCase() );
						}
						//changed by sankara on 18/11/13 validation for different assign user end.
						//changed by sankara on 03/01/13 for doing replenishment order wise start.
						sql = " SELECT SITE_CODE, ITEM_CODE, LOC_CODE, LOT_NO, LOT_SL FROM REPL_ORD_DET WHERE REPL_ORDER = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, replOrder );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							siteCode = checkNull (rs.getString("SITE_CODE"));
							itemCode = checkNull (rs.getString("ITEM_CODE"));
							locCode =  checkNull (rs.getString("LOC_CODE"));
							lotNo =    checkNull (rs.getString("LOT_NO")); 
							lpnNo =  checkNull (rs.getString("LOT_SL")); 
						}					
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						sql = " SELECT R.REPL_ORDER FROM REPL_ORD_HDR R, WAVE_TASK W, WAVE_TASK_DET WD, REPL_ORD_DET RT WHERE " +
							  " R.REPL_ORDER = WD.REF_ID AND R.REPL_ORDER = RT.REPL_ORDER AND R.WAVE_ID = W.WAVE_ID AND W.WAVE_ID = WD.WAVE_ID " +
							  " AND WD.STATUS ='N' AND W.CANCEL = 'N' AND ( RT.CANCEL_MODE='N' OR RT.CANCEL_MODE IS NULL )  " +
							  " AND RT.SITE_CODE = ? AND RT.ITEM_CODE = ? AND RT.LOC_CODE = ? AND RT.LOT_NO = ? AND RT.LOT_SL = ? " +
							  " ORDER BY REPL_ORDER ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, siteCode );
						pstmt.setString( 2, itemCode );
						pstmt.setString( 3, locCode );
						pstmt.setString( 4, lotNo );
						pstmt.setString( 5, lpnNo );
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							replOrd = checkNull(rs.getString("REPL_ORDER"));
							System.out.println("replOrd-->"+replOrd);
							System.out.println("headerreplOrder-->"+replOrder);

							if( !replOrder.trim().equalsIgnoreCase( replOrd ) )
							{
								errList.add( "VTREPLORDR" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						//changed by sankara on 03/01/13 for doing replenishment order wise end.
						//changed by sankara on 12/04/14 validation for quantity compared from sordalloc and stock start.
						if ("repl_iss".equalsIgnoreCase(objName.trim()))
						{
							sql = " SELECT SITE_CODE, ITEM_CODE, LOC_CODE, LOT_NO, LOT_SL FROM REPL_ORD_DET WHERE REPL_ORDER = ? ";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, replOrder );
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								siteCode = checkNull(rs.getString("SITE_CODE"));
								itemCode = checkNull(rs.getString("ITEM_CODE"));
								locCode = checkNull(rs.getString("LOC_CODE")); 
								lotNo = checkNull(rs.getString("LOT_NO")); 
								lotSl = checkNull(rs.getString("LOT_SL")); 									
							}
							System.out.println("siteCode:::::"+siteCode);
							System.out.println("itemCode:::::"+itemCode);
							System.out.println("locCode:::::"+locCode);
							System.out.println("lotNo:::::"+lotNo);
							System.out.println("lotSl:::::"+lotSl);								
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							sql = " SELECT SUM(QUANTITY) AS QUANTITY,SUM(ALLOC_QTY) AS ALLOC_QTY FROM STOCK WHERE SITE_CODE = ? AND ITEM_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ? AND QUANTITY >0 ";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, siteCode );
							pstmt.setString( 2, itemCode );
							pstmt.setString( 3, locCode );
							pstmt.setString( 4, lotNo );
							pstmt.setString( 5, lotSl );
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								quantity = rs.getDouble("QUANTITY");
								stockalloocqty = rs.getDouble("ALLOC_QTY");						
							}
							System.out.println("stockquantity:::::"+quantity);
							System.out.println("stockallocqty:::::"+stockalloocqty);
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							sql = " SELECT SUM(QTY_ALLOC) AS  QTY_ALLOC FROM SORDALLOC WHERE SITE_CODE = ? AND ITEM_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ? AND QTY_ALLOC >0 ";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, siteCode );
							pstmt.setString( 2, itemCode );
							pstmt.setString( 3, locCode );
							pstmt.setString( 4, lotNo );
							pstmt.setString( 5, lotSl );
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								sordallocqty = rs.getDouble("QTY_ALLOC");				
							}
							System.out.println("sordallocqty:::::"+sordallocqty);
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							double finalQty =  stockalloocqty - sordallocqty;
							
							/*sql = "SELECT SUM(D.QUANTITY) AS QUANTITY FROM REPL_ORD_DET D, REPL_ORD_HDR H WHERE D.ITEM_CODE = ? " 
									+" AND D.SITE_CODE = ? AND D.LOC_CODE = ? AND D.LOT_NO = ? AND D.LOT_SL = ? "
				    				+" AND CASE WHEN CANCEL_MODE IS NULL THEN 'N' ELSE CANCEL_MODE END <> 'Y'  "
				    				+" AND H.REPL_ORDER = D.REPL_ORDER AND H.ORDER_TYPE IN('Q','T','P','E','I') ";
							pstmt =  conn.prepareStatement(sql);
							pstmt.setString(1, itemCode);
							pstmt.setString(2, siteCode);
							pstmt.setString(3, locCode);
							pstmt.setString(4, lotNo);
							pstmt.setString(5, lotSl);
							
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								activeReplQty = rs.getDouble("QUANTITY");
							}
							
							
							System.out.println("activeReplQty["+activeReplQty+"]");
							finalQty = finalQty - activeReplQty;
							System.out.println("finalQty["+finalQty+"]");*/
							
							if(rs != null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt != null)
							{
								pstmt.close();
								pstmt = null;
							}

							if( finalQty > 0 ) 
							{
								errList.add( "INVALOCQTY" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						//changed by sankara on 12/04/14 validation for quantity comared from sordalloc and stock end.
					}
					else if( "site_code".equalsIgnoreCase( childNodeName ) )
					{
						siteCode = genericUtility.getColumnValue( "site_code", currFormDataDom );
						sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, siteCode );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							count = rs.getInt("COUNT");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if( count <= 0 )
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "site_code", "INVDSITECD", userId );
							errList.add( "INVDSITECD" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
					}
					else if( "carton_no".equalsIgnoreCase( childNodeName ) )
					{


						cartonNo = genericUtility.getColumnValue( "carton_no", currFormDataDom );
						replOrder = genericUtility.getColumnValue( "repl_order", currFormDataDom );
						sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR WHERE REPL_ORDER = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, replOrder );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							orderType = rs.getString("ORDER_TYPE");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						if( "D".equals(orderType) || "L".equals(orderType)  )
						{
							if( cartonNo == null || cartonNo.trim().length() == 0)
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString( "site_code", "INVDSITECD", userId );
								errList.add( "VTINVCTND" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
							else
							{
								sql = "SELECT count(1) FROM CARTON_MASTER WHERE CARTON_NO = ? and PICK_ORDER = ? ";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, cartonNo );
								pstmt.setString( 2, replOrder );
								rs = pstmt.executeQuery();

								if( rs.next() )
								{
									count = rs.getInt(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								if( count == 0)
								{
									// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
									//errString = getErrorString( "site_code", "INVDSITECD", userId );
									errList.add( "VTINVCTND" );
									errFields.add( childNodeName.toLowerCase() );
									// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								}

							}
						}
					}
				}
			} //End of case 1 Validation
			break;
			//Changed by sankara on 17/07/13 adding validation where user going to do this task which is already processing by other user start...
			case 2:
			{
				System.out.println("INCASE2");
				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();

				for ( int ctr = 0; ctr < noOfChilds; ctr++ ) //Loop for each node of current detail
				{	
					Node childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					String childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					
					if ( "repl_order".equalsIgnoreCase( childNodeName ) )
					{
						replOrder = genericUtility.getColumnValue( "repl_order", currFormDataDom );
						sql = "SELECT CONFIRMED,CHG_USER FROM REPL_ISS_HDR WHERE REPL_ORDER = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, replOrder );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							if( "N".equalsIgnoreCase(rs.getString("CONFIRMED")) && !userId.trim().equalsIgnoreCase(rs.getString("CHG_USER").trim()))
							{
								errList.add( "VMACTRECHG" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;		
					}
					else if( "site_code".equalsIgnoreCase( childNodeName ) )
					{
						if ( childNode.getFirstChild() == null)
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "site_code", "NULLSITECD", userId );
							//break;
							errList.add( "NULLSITECD" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						siteCode = genericUtility.getColumnValue( "site_code", currFormDataDom );
						sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, siteCode );
						rs = pstmt.executeQuery();

						if( rs.next() )
						{
							count = rs.getInt("COUNT");
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;

						if( count == 0 )
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "site_code", "INVDSITECD", userId );
							//break;
							errList.add( "INVDSITECD" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
						else //added by kunal on 15-feb-14 for period code
						{
							
							siteCode = genericUtility.getColumnValue("site_code", currFormDataDom);
							
							System.out.println("364 site code ="+siteCode);
							if (genericUtility.getColumnValue("tran_date", currFormDataDom) != null)
							{
								tranDate = sdf1.parse(genericUtility.getColumnValue("tran_date", currFormDataDom));
								sql = "select code from period where ?  between fr_date and to_date";
								pstmt = conn.prepareStatement(sql);
								pstmt.setDate(1, new java.sql.Date(tranDate.getTime()));
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									prdCode = rs.getString(1);

								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								sql = "select count(*) from period_stat where site_code = ? and prd_code = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, siteCode);
								pstmt.setString(2, prdCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									count = rs.getInt(1);

								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								if (count == 0)
								{
									errList.add( "VTSITEPD" );
									errFields.add( childNodeName.toLowerCase() );
									break;
								}
								// nvo_functions_adv.nf_check_period('SAL',mdate1,msite_code)
								errCode = nfCheckPeriod("IC", tranDate, siteCode);
								System.out.println("425 Error Code = " + errCode);
								if (errCode != null && errCode.trim().length() > 0)
								{
									errList.add(errCode);
									errFields.add( childNodeName.toLowerCase() );
								
								}
							} 							 
						}//end 
					}//End of site_code validation
			   }
			}
			break;
			//Changed by sankara on 17/07/13 adding validation where user going to do this task which is already processing by other user end....
			case 3:
			{
				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();
				//Changed by sumit on 25/02/13 getting obj_name
				objName = getObjNameFromDom(currFormDataDom, "objName", objContext);
				System.out.println(" onj_name ["+objName+"]");
				for ( int ctr = 0; ctr < noOfChilds; ctr++ )  //Loop for each node of current detail
				{	
					Node childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					String childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName:::::: [" + childNodeName + "] columnValue [" + columnValue + "]");
					//Changed by sumit on 25/02/13 validation for no_art start
					
					if ( "lot_sl".equalsIgnoreCase( childNodeName ) )
					{									
						
						replOrder =  genericUtility.getColumnValue("repl_order", allFormDataDom, "3" );
						lpnNo =  genericUtility.getColumnValue("lot_sl", allFormDataDom, "3" );
						System.out.println("test2="+replOrder+"  "+lpnNo);
						
						System.out.println("lo2="+genericUtility.getColumnValue("line_no__ord", allFormDataDom, "3" ) );
						
						lineNoOrd = Integer.parseInt( genericUtility.getColumnValue("line_no__ord", allFormDataDom, "3" ) );

						sql = "SELECT COUNT(*) AS COUNT FROM REPL_ORD_DET WHERE LOT_SL = ? AND REPL_ORDER = ? AND LINE_NO = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, lpnNo );
						pstmt.setString( 2, replOrder );
						pstmt.setInt( 3, lineNoOrd );
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							count = rs.getInt("COUNT");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						if( count <= 0 )
						{
							// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							//errString = getErrorString( "lot_sl", "INVLDLOTSL", userId );
							//break;
							errList.add( "INVLDLOTSL" );
							errFields.add( childNodeName.toLowerCase() );
							// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
						}
					}
					//else if ( "lot_sl_new".equalsIgnoreCase( childNodeName ) ) //added by kunal mandhre on 05/JUN/12 - WM1ESUN007
					else if ( "lot_sl__new".equalsIgnoreCase( childNodeName ) && "active_repl_iss".equalsIgnoreCase(getObjNameFromDom(currFormDataDom, "objName", objContext)) ) //added by kunal mandhre on 05/JUN/12 - WM1ESUN007
					{
						//String orderType = "";
						//Chnaged by Rohan on 25/05/13 for getting site code from dom
						siteCode = genericUtility.getColumnValue( "site_code", currFormDataDom );
						//lotSlNew =  genericUtility.getColumnValue("lot_sl_new", allFormDataDom, "3" );
						lotSlNew =  genericUtility.getColumnValue("lot_sl__new", allFormDataDom, "3" );
						replOrder =  checkNull(genericUtility.getColumnValue("repl_order", allFormDataDom, "3" ));
						
						//Chnaged by Rohan on 10-02-12 allow lpn no start with NJ & CN & allow only 10 Character.start
						if(!lotSlNew.startsWith("NJ") && !lotSlNew.startsWith("CN") && !lotSlNew.startsWith("DM") && !lotSlNew.startsWith("EX") )
						{
							errList.add( "VTINVLPN" );
							errFields.add( childNodeName.toLowerCase());
						}
						
						if(lotSlNew.length() != 10)
						{
							errList.add( "VTINVLEN" );
							errFields.add( childNodeName.toLowerCase());
						}
						//Chnaged by Rohan on 10-02-12 allow lpn no start with NJ & CN & allow only 10 Character.end
						
						//Changed by sumit on 22/05/13 checking duplicate  lot_sl__new from dom and stock start.
						//Changed by Rohan on 25-05-13 for checking duplicate lpn site wise
						//sql = " SELECT LOT_SL FROM STOCK WHERE LOT_SL = ?";
						sql = " SELECT LOT_SL FROM STOCK WHERE LOT_SL = ? AND SITE_CODE = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString(1, lotSlNew );
						//Changed by Rohan on 25-05-13 for checking duplicate lpn site wise
						pstmt.setString(2, siteCode );
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							errList.add( "DUPLOTSLNW" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else
						{
						
						  ArrayList arrayList = checkDuplicaterecord(allFormDataDom);
						  Set set = new HashSet(arrayList);
						  System.out.println("Size of arrayList ["+arrayList.size()+"]");
						  System.out.println("Size of Set ["+set.size()+"]");								  
						  if(set.size() < arrayList.size())
						  {
							  errList.add( "DUPLOTSLNW" );
							  errFields.add( childNodeName.toLowerCase() );
						  }	
						  set.clear();
						}
						rs.close(); rs =null;
						pstmt.close(); pstmt = null;
						//Changed by sumit on 22/05/13 checking duplicate  lot_sl__new from dom and stock end.
						
						sql = "select pick_order from repl_ord_det where repl_order= ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, replOrder);
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							pickOrder = rs.getString("pick_order") == null?"":rs.getString("pick_order");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						sql = "select pick_type from pick_ord_hdr where pick_order = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, replOrder);
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							orderType = rs.getString("pick_type") == null?"":rs.getString("pick_type");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						if((lotSlNew == null || lotSlNew.trim().length()== 0) && "A".equalsIgnoreCase(orderType) )
						{
							errList.add( "LPNORDTYPE" );
							errFields.add( childNodeName.toLowerCase() );
						}								
					}
					//Commented By mahesh Patidar on 01/08/12

					else if( "loc_code__to".equalsIgnoreCase( childNodeName ) && ! "active_repl_iss".equalsIgnoreCase(getObjNameFromDom(currFormDataDom, "objName", objContext)))
					{								
						itemCode = checkNull(genericUtility.getColumnValue("item_code", allFormDataDom, "3" ));
						siteCode = checkNull(genericUtility.getColumnValue("site_code", allFormDataDom, "3" ));
						locCodeTo = checkNull(genericUtility.getColumnValue("loc_code__to", allFormDataDom, "3" ));
						lotNo = checkNull(genericUtility.getColumnValue("lot_no", allFormDataDom, "3" ));
						lpnNo = checkNull(genericUtility.getColumnValue("lot_sl", allFormDataDom, "3" ));
						replOrder =  checkNull(genericUtility.getColumnValue("repl_order", allFormDataDom, "3" ));
						tranID =  checkNull(genericUtility.getColumnValue("tran_id", hdrDataDom ));
						//Changed by sumit on 06/08/12 getting value of location code
						locCode = checkNull(genericUtility.getColumnValue("loc_code", allFormDataDom, "3" ));							
						
						String disparmVal = "";
						//sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR WHERE REPL_ORDER = ? ";
						//Changed by sumit on 18/09/12 getting ptcn 
						//sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR WHERE REPL_ORDER = ? ";
						sql = 	" SELECT ROH.ORDER_TYPE, WID.PTCN FROM REPL_ORD_HDR ROH, WAVE_TASK_DET WID WHERE ROH.REPL_ORDER = ? " +
								" AND ROH.REPL_ORDER = WID.REF_ID ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, replOrder );
						rs = pstmt.executeQuery();
						if ( rs.next() )
						{
							orderType = checkNull(rs.getString("ORDER_TYPE"));
							ptcn = checkNull(rs.getString("PTCN"));
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;
						if (!"A".equals(orderType) && !"E".equals(orderType) && !"Q".equals(orderType) && !"T".equals(orderType))
						{
							if ( !("L".equalsIgnoreCase(orderType)))
							{	
								
								sql = "SELECT SINGLE_LOT_SL, ITEM_LOT_OPT FROM LOCATION WHERE LOC_CODE = ?";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, locCodeTo );
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									singleLotSl = checkNull(rs.getString("SINGLE_LOT_SL"));
									itemLotOpt = checkNull(rs.getString("ITEM_LOT_OPT"));
								}
								else
								{
									errList.add( "INVLOCCODE" );
									errFields.add( childNodeName.toLowerCase() );
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								//Changed Pragyan To add the validation as Mahesh Patidar.start
								sql = "SELECT loc_type FROM LOCATION WHERE LOC_CODE = ? ";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, locCodeTo );
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									itemLocType = checkNullAndTrim(rs.getString(1));
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
		
								sql = "SELECT LOC_TYPE FROM ITEM WHERE ITEM_CODE = ? ";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, itemCode );
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									locationLocType = checkNullAndTrim(rs.getString(1));
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
		
								if(! itemLocType.equals(locationLocType))
								{
									errList.add( "VMLOCTYP1" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}	
							//Changed Pragyan To add the validation as Mahesh Patidar.end				

						

							if ( "D".equalsIgnoreCase(orderType) ||  "L".equalsIgnoreCase(orderType))
							{
								disparmVal = distComm.getDisparams( "999999", "DOCKLOC_INVSTAT", conn );
								System.out.println(" disparmVal =[" + disparmVal + "]");

								sql = "SELECT COUNT(*) COUNT FROM LOCATION LOC, INVSTAT ISTAT WHERE LOC.INV_STAT = ISTAT.INV_STAT " +
										"AND LOC.LOC_CODE = ? AND LOC.INV_STAT = ? AND ISTAT.AVAILABLE = 'Y' "+
										"AND (CASE WHEN ISTAT.STAT_TYPE IS NULL THEN ' ' ELSE ISTAT.STAT_TYPE END) <> 'S' ";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, locCodeTo );
								pstmt.setString( 2, disparmVal );
								rs = pstmt.executeQuery();	
								if( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								if ( count == 0 )
								{
									errList.add( "VTLOCCODE7" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
							else 
							{
								sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR  WHERE REPL_ORDER = ?";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, replOrder );
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									pickType = checkNull(rs.getString("ORDER_TYPE"));
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;

								System.out.println("pick type =[" +pickType+ "]");//
								//Changed By Pragyan 07-apr-14 to set pick type for order type "E"
								//Changed By Sumit as the pick type "Q" required.
								//if ( "A".equalsIgnoreCase(pickType.trim()) || "I".equalsIgnoreCase(pickType.trim()) )//Active pick
								//if ( "A".equalsIgnoreCase(pickType.trim()) || "I".equalsIgnoreCase(pickType.trim()) || "Q".equalsIgnoreCase(pickType.trim()) ||  "T".equalsIgnoreCase(pickType.trim() ))//Active pick
								if ( "A".equalsIgnoreCase(pickType.trim()) || "I".equalsIgnoreCase(pickType.trim()) || "Q".equalsIgnoreCase(pickType.trim()) ||  "T".equalsIgnoreCase(pickType.trim() ))//Active pick
								{
									varName = "ACTIVE_PICK_INVSTAT";
								}
								else if ( "C".equalsIgnoreCase(pickType.trim()) || "M".equalsIgnoreCase(pickType.trim()) || "J".equalsIgnoreCase(pickType.trim()) || "K".equalsIgnoreCase(pickType.trim()))//Case pick & master pick
								{
									varName = "CASE_PICK_INVSTAT";
								}
								else if("E".equalsIgnoreCase(pickType.trim()) || "F".equalsIgnoreCase(pickType.trim()) || "G".equalsIgnoreCase(pickType.trim()) ||"H".equalsIgnoreCase(pickType.trim()) )
								{
									varName = "PND_INVSTAT";
								}
								else if("L".equalsIgnoreCase(pickType.trim()) || "D".equalsIgnoreCase(pickType.trim()))
								{
									varName = "DOCKLOC_INVSTAT";
								}

								disparmVal = distComm.getDisparams( "999999", varName, conn );

								//Changed by sumit on 08/08/12 checking location in case of PND inv_stat START.
								/*sql = "SELECT COUNT(*) AS COUNT FROM LOCATION A, INVSTAT B "
											+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
											+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
											+ " AND A.INV_STAT = ? AND LOC_CODE = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, disparmVal);
									pstmt.setString(2, locCodeTo);*/
								if ("PND_INVSTAT".equalsIgnoreCase(varName)) 
								{									
									sql = "SELECT COUNT(*) AS COUNT FROM LOCATION A, INVSTAT B "
											+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
											+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
											+ " AND A.INV_STAT = ? AND LOC_CODE = ? "
											+ " and LOC_GROUP = (SELECT DROP_GROUP FROM LOCATION WHERE LOC_CODE = ? )";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, disparmVal);
									pstmt.setString(2, locCodeTo);
									pstmt.setString(3, locCode );
									rs = pstmt.executeQuery(); //added by Kunal on 07/09/12
									if (rs.next())
									{
										count = rs.getInt("COUNT");
									}
									rs.close(); rs = null;
									pstmt.close(); pstmt = null;
									if ( count == 0 )
									{
										errList.add( "INVPNDLOC1" ); //change the message code on 17/09/12 kunal 
										errFields.add( childNodeName.toLowerCase() );
									}
								}
								else
								{
									sql = "SELECT COUNT(*) AS COUNT FROM LOCATION A, INVSTAT B "
											+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
											+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
											+ " AND A.INV_STAT = ? AND LOC_CODE = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, disparmVal);
									pstmt.setString(2, locCodeTo);
									rs = pstmt.executeQuery();  //added by Kunal on 07/09/12
									if (rs.next())
									{
										count = rs.getInt("COUNT");
									}
									rs.close(); rs = null;
									pstmt.close(); pstmt = null;
									if ( count == 0 )
									{
										errList.add( "INVLOCCODE" );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
								//Changed by sumit on 08/08/12 checking location in case of PND inv_stat end.
								/*
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									count = rs.getInt("COUNT");
								}
								rs.close(); rs = null;
								pstmt.close(); pstmt = null;
								if ( count == 0 )
								{
									errList.add( "INVLOCCODE" );
									errFields.add( childNodeName.toLowerCase() );
								}*/

								if( singleLotSl.trim().equalsIgnoreCase("Y") )
								{
									sql = "SELECT QUANTITY FROM STOCK WHERE SITE_CODE = ?  AND LOC_CODE = ? ORDER BY QUANTITY DESC";
									pstmt = conn.prepareStatement( sql );
									pstmt.setString( 1, siteCode );
									pstmt.setString( 2, locCodeTo );
									rs = pstmt.executeQuery();	
									if( rs.next() )
									{
										quantity = rs.getDouble("QUANTITY");
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;

									if( quantity != 0 )
									{
										errList.add( "VTLOCCODE1" );
										errFields.add( childNodeName.toLowerCase() );
									}
									String locCodeExist = "";
									NodeList locCodeNodeList = null;
									ArrayList dupLocCodeList = new ArrayList();

									int noOfLocCode = 0;
									int listLen = 0;
									int recCnt = 0;
									int locCodeCntDb = 0;

									locCodeNodeList = allFormDataDom.getElementsByTagName("loc_code__to");
									noOfLocCode = locCodeNodeList.getLength();

									for( int idx = 0; idx < noOfLocCode; idx++ )
									{
										if ( locCodeNodeList.item( idx ).getFirstChild() != null )
										{
											dupLocCodeList.add((String)( locCodeNodeList.item( idx ).getFirstChild() ).getNodeValue());
										}
									}
									listLen = dupLocCodeList.size();
									if ( listLen > 0 )
									{
										recCnt = 1;
										for( int i = 0; i < listLen - 1; i++ )
										{
											for ( int j = i+1; j < listLen; j++ )
											{
												if ( ((String)dupLocCodeList.get(i)).equalsIgnoreCase((String)dupLocCodeList.get(j)) )
												{
													recCnt++;
													break;
												}
											}
											if( recCnt > 1 )
											{
												break;
											}
										}
									}
									System.out.println("recCnt = ["+recCnt+"]");

									if( recCnt > 1 )
									{
										errList.add( "DUPLOCCODE" );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
								else
								{
									if( itemLotOpt.trim().equals("0") )  
									{
										//changed by sankara on 13/09/2012 to add quantity
										//sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
										sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE (ITEM_CODE <> ? OR LOT_NO <> ?) AND SITE_CODE = ? AND LOC_CODE = ? AND QUANTITY > 0"; 
										pstmt = conn.prepareStatement( sql );
										//changed by sankara on 13/09/2012 to set a strings in a row based on sql[Satrt]
								/*		pstmt.setString( 1, itemCode );
										pstmt.setString( 2, siteCode );
										pstmt.setString( 3, locCodeTo );
										pstmt.setString( 4, lotNo );    */
										pstmt.setString( 1, itemCode );
										pstmt.setString( 2, lotNo );
										pstmt.setString( 3, siteCode );
										pstmt.setString( 4, locCodeTo );
										//changed by sankara on 13/09/2012 to set a strings in a row based on sql[End]
										rs = pstmt.executeQuery();
										if( rs.next() )
										{
											count = rs.getInt("COUNT");
										}
										rs.close();
										rs = null;
										pstmt.close();
										pstmt = null;

										if( count > 0 )
										{
											errList.add( "VTLOCCODE2" );
											errFields.add( childNodeName.toLowerCase() );
										}
									}
									else if( itemLotOpt.trim().equals("1") )  //Validation for single item_code multiple lot_no
									{
										//changed by sankara on 13/09/2012 to add quantity
										//sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? ";
										sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND QUANTITY > 0";
										pstmt = conn.prepareStatement( sql );
										//changed by sankara on 13/09/2012 to set a strings in a row based on sql[Satrt]
									/*	pstmt.setString( 1, itemCode );
										pstmt.setString( 2, siteCode );
										pstmt.setString( 3, locCodeTo );
										pstmt.setString( 4, lotNo );     */
										pstmt.setString( 1, itemCode );
										pstmt.setString( 2, siteCode );
										pstmt.setString( 3, locCodeTo );
										//changed by sankara on 13/09/2012 to set a strings in a row based on sql[End]
										rs = pstmt.executeQuery();
										if( rs.next() )
										{
											count = rs.getInt("COUNT");
										}
										rs.close();
										rs = null;
										pstmt.close();
										pstmt = null;
										if( count > 0 )
										{
											errList.add( "VTLOCCODE4" );
											errFields.add( childNodeName.toLowerCase() );
										}	
									}
								}

								sql = "SELECT RIH.CONFIRMED FROM REPL_ISS_HDR RIH, REPL_ISS_DET RID"
										+ " WHERE RIH.TRAN_ID = RID.TRAN_ID AND RID.ITEM_CODE = ?"
										+ " AND RID.SITE_CODE = ? AND RID.LOC_CODE__TO = ?"
										+ " AND RID.LOT_NO = ? AND RID.LOT_SL = ? AND RIH.TRAN_ID <> ? ";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, itemCode );
								pstmt.setString( 2, siteCode );
								pstmt.setString( 3, locCodeTo );
								pstmt.setString( 4, lotNo );
								pstmt.setString( 5, lpnNo );
								pstmt.setString( 6, tranID );
								rs = pstmt.executeQuery();	

								if( rs.next() )
								{
									confirmed = checkNull(rs.getString("CONFIRMED"));
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if( confirmed.trim().equalsIgnoreCase("N") )
								{
									errList.add( "VTLOCCODE6" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}//else of if ( "D".equalsIgnoreCase(orderType) )
						}
						
						//changed by sankara on 08/05/14 for loc code to and suggestion loc code check start.
						locCodeSys = checkNull(genericUtility.getColumnValue("loc_code__sys", allFormDataDom, "3" ));	
						System.out.println("locCodeSys:::::::"+locCodeSys);
						System.out.println("locCodeTo::::::::"+locCodeTo);
						if( !locCodeSys.trim().equalsIgnoreCase(locCodeTo.trim()))
						{
							errList.add( "VTSYSLOCCD" );
							errFields.add( childNodeName.toLowerCase() );
						}
						//changed by sankara on 08/05/14 for loc code to and suggestion loc code check end.
						//Changed by sumit on 09/10/12 write this code in post save start.
						/*if("D".equals(orderType) || "L".equals(orderType))
						{
							System.out.println("Calling Jasper Report ***************************************");
							errString = generateReport(replOrder, ptcn, conn,xtraParams);
							if( errString.trim().length() == 0)
							{
								System.out.println(" report genetrated successfully ");
							}
							
						}*/
						//Changed by sumit on 09/10/12 write this code in post save end.
					}
					//Changed by Rohan on 11-10-12 to add start hazmat validation in case of stock to dock.start
					//Changed by Rohan on 15-10-12 for bug fixing
					//else if("item_code".equalsIgnoreCase( childNodeName ) && "repl_iss_dock".equalsIgnoreCase(getObjNameFromDom(currFormDataDom, "objName", objContext)) )
					else if("item_code".equalsIgnoreCase(childNodeName.trim()))	
					{
						System.out.println("Enter in item code validation");
						//to check item is hazarous.start
						itemCd = checkNull(genericUtility.getColumnValue("item_code", allFormDataDom, "3" ));
						//Chnaged by rohan on 15-10-12 for bug fixing
						//pickOrd =  checkNull(genericUtility.getColumnValue("repl_order", allFormDataDom, "3" ));
						replOrderS =  checkNull(genericUtility.getColumnValue("repl_order", allFormDataDom, "3" ));
						
						//Changed by Rohan on 15-10-12 to check stock to dock present or not.satrt
						/*
						sqlitem = "SELECT HAZARDOUS FROM ITEM WHERE ITEM_CODE=? ";
						pstmtitem = conn.prepareStatement(sqlitem);
						
						pstmtitem.setString(1,itemCd);
						
						rsitem = pstmtitem.executeQuery();
						if(rsitem.next())
						{
							hazMaterial = rsitem.getString("HAZARDOUS") == null?"":rsitem.getString("HAZARDOUS");
										
							System.out.println("hazardous*"+hazMaterial);
						}
						if(pstmtitem != null)
						{
							pstmtitem.close();
							pstmtitem = null;
						}
						if(rsitem != null)
						{
							rsitem.close();
							rsitem = null;
						}
						*/
						//to check item is hazarous.end
						//to check transporter mode.start
						//Changed by Rohan on 15-10-12 to check stock to dock present or not.end
						
						//Changed by rohan on 15-10-12 to check order type of replanishment 
						//sqlptcn ="SELECT PTCN,WAVE_ID FROM WAVE_TASK_DET WHERE REF_ID = ?";
						sqlptcn ="SELECT W.PTCN,W.WAVE_ID,R.ORDER_TYPE FROM WAVE_TASK_DET W,REPL_ORD_HDR R WHERE W.REF_ID = ?"
								 + " AND R.REPL_ORDER = W.REF_ID";
						pstmtitem = conn.prepareStatement(sqlptcn);
						pstmtitem.setString(1,replOrderS);
						rsitem = pstmtitem.executeQuery();
						if(rsitem.next())
						{
							ptcnHaz = rsitem.getString("PTCN") == null?"":rsitem.getString("PTCN");
							waveIdHaz = rsitem.getString("WAVE_ID") == null?"":rsitem.getString("WAVE_ID");
							//Changed by Rohan on 15-10-12 to get order type
							orderType = rsitem.getString("ORDER_TYPE") == null?"":rsitem.getString("ORDER_TYPE");
							
						}
						if(pstmtitem != null)
						{
							pstmtitem.close();
							pstmtitem = null;
						}
						if(rsitem != null)
						{
							rsitem.close();
							rsitem = null;
						}
						
						//Changed by Rohan on 15-10-12 to call validation in stock to dock case only.start
						if("D".equalsIgnoreCase(orderType) || "L".equalsIgnoreCase(orderType))
						{
						    //Changed by Rohan on 15-10-12 to call validation in stock to dock case only.end	
						
							//Changed by Rohan on 15-10-12 to check hazardous material.start
							sqlitem = "SELECT HAZARDOUS FROM ITEM WHERE ITEM_CODE=? ";
							pstmtitem = conn.prepareStatement(sqlitem);
							
							pstmtitem.setString(1,itemCd);
							
							rsitem = pstmtitem.executeQuery();
							if(rsitem.next())
							{
								hazMaterial = rsitem.getString("HAZARDOUS") == null?"":rsitem.getString("HAZARDOUS");
										
							}
							if(pstmtitem != null)
							{
								pstmtitem.close();
								pstmtitem = null;
							}
							if(rsitem != null)
							{
								rsitem.close();
								rsitem = null;
							}
							//Changed by Rohan on 15-10-12 to check hazardous material.end
							sqlTran  = "SELECT TRANS_MODE FROM DESPATCH WHERE DESP_ID IN(SELECT REF_ID FROM WAVE_TASK_DET "
									   +" WHERE REF_SER = ? AND WAVE_ID = ? AND PTCN = ?)";
							pstmtitem = conn.prepareStatement(sqlTran);
							
							pstmtitem.setString(1,"S-DSP");
							pstmtitem.setString(2,waveIdHaz);
							pstmtitem.setString(3,ptcnHaz);
							
							rsitem = pstmtitem.executeQuery();
							if(rsitem.next())
							{
								transMode = rsitem.getString("TRANS_MODE") == null?"":rsitem.getString("TRANS_MODE");
											
							}
							if(pstmtitem != null)
							{
								pstmtitem.close();
								pstmtitem = null;
							}
							if(rsitem != null)
							{
								rsitem.close();
								rsitem = null;
							}
							//to check transporter mode.end
							if("Y".equalsIgnoreCase(hazMaterial) && "A".equalsIgnoreCase(transMode))
							{
								errList.add( "VTHAZMAT" );
								errFields.add( childNodeName.toLowerCase() );		
							}
						//Changed by Rohan on 15-10-12 to call validation in stock to dock case only	
						}	
					}
					//Changed by Rohan on 11-10-12 to add start hazmat validation in case of stock to dock.start
					else if("pick_order".equalsIgnoreCase(childNodeName.trim()))	
					{
						System.out.println("Enter in Pick_order_ validation");
						
					    
						pickOrd = checkNull(genericUtility.getColumnValue("pick_order", allFormDataDom, "3" ));
						PicklineNoOrd =  checkNull(genericUtility.getColumnValue("line_no__ord", allFormDataDom, "3" ));
						
						System.out.println("Pick Order"+pickOrd+"PicklineNoOrd"+PicklineNoOrd);
						
						sqlReplCnt = "SELECT COUNT(*) AN COUNT FROM REPL_ORD_DET WHERE PICK_ORDER= ? AND LINE_NO__PICK = ?";
						pstmt = conn.prepareStatement( sqlReplCnt );
						pstmt.setString( 1,pickOrd );
						pstmt.setString( 2,PicklineNoOrd );
						rs = pstmt.executeQuery();	

						if( rs.next() )
						{
							cntRepl = rs.getInt("COUNT");
						}
						if(cntRepl > 0)
						{
							errList.add( "DEPREPLORD" );
							errFields.add( childNodeName.toLowerCase() );	
						}
						if(rs != null)
						{	
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{	
							pstmt.close();
							pstmt = null;
						}	
						
					}
					//Changed by sumit on 25/02/13 validation no_art start
					else if ( "no_art".equalsIgnoreCase( childNodeName ) && "active_repl_iss".equalsIgnoreCase(objName))
					{
							
						noArt = checkNull(genericUtility.getColumnValue("no_art", currFormDataDom ));
						replOrder = genericUtility.getColumnValue("repl_order", currFormDataDom );
						locCode = genericUtility.getColumnValue("loc_code", currFormDataDom );
						siteCode = genericUtility.getColumnValue("site_code", currFormDataDom );
						lotSl = genericUtility.getColumnValue("lot_sl", currFormDataDom );
						itemCode = genericUtility.getColumnValue("item_code", currFormDataDom );
						lotNo = genericUtility.getColumnValue("lot_no", currFormDataDom );
						System.out.println(" noArt ["+noArt+"] replOrder ["+replOrder+"]");
						if( noArt == null || noArt.trim().length() == 0 )
						{
							errList.add( "NULLNOART" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else if (!noArt.matches("((-|\\+)?[0-9]+(\\.[0-9]+)?)+")) // NO_ART SHOLUD BE A NUMBER
						{
							errList.add( "ARTNOTANUM" );
							errFields.add( childNodeName.toLowerCase() );
						}
						else 
						{
							double tempNoArt = 0.0;							
							sql = " SELECT  RID.SITE_CODE, RID.ITEM_CODE, RID.LOC_CODE, RID.LOT_NO, RID.LOT_SL,  SUM(RID.QUANTITY) AS QUANTITY , " +
								  " SUM(RID.NO_ART) AS NO_ART FROM REPL_ORD_DET RID WHERE RID.REPL_ORDER = ? AND ITEM_CODE = ? AND SITE_CODE = ? " +
								  " AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ? AND CASE WHEN CANCEL_MODE IS NULL THEN 'N' ELSE CANCEL_MODE END <> 'Y' " +
								  " GROUP BY RID.SITE_CODE, RID.ITEM_CODE, RID.LOC_CODE, RID.LOT_NO, RID.LOT_SL ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, replOrder);
							pstmt.setString(2, itemCode);
							pstmt.setString(3, siteCode);
							pstmt.setString(4, locCode);
							pstmt.setString(5, lotNo);
							pstmt.setString(6, lotSl);							
							rs = pstmt.executeQuery();
							if( rs.next())
							{
								tempNoArt = rs.getDouble("NO_ART");
							}
							rs.close(); rs =null;
							pstmt.close(); pstmt = null;
							
							if ( Double.parseDouble(noArt) != tempNoArt)
							{
								errList.add( "INVNOOFART" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
					}
					//Changed by sumit on 25/02/13 validation no_art end
					//Changed By rohan on 29-10-12 to add warning if depended repanishment present.start
					
					//Changed By Rohan on 29-10-12 to add warning if depended repanishment present.end

					//Ended By Mahesh Patidar on 01/08/12
					//Changed By Mahesh Patidar on 10/08/12

					//						else if( "loc_code__to".equalsIgnoreCase( childNodeName ) )
					//						{								
					//							itemCode = checkNull(genericUtility.getColumnValue("item_code", allFormDataDom, "2" ));
					//							siteCode = checkNull(genericUtility.getColumnValue("site_code", allFormDataDom, "2" ));
					//							locCodeTo = checkNull(genericUtility.getColumnValue("loc_code__to", allFormDataDom, "2" ));
					//							lotNo = checkNull(genericUtility.getColumnValue("lot_no", allFormDataDom, "2" ));
					//							lpnNo = checkNull(genericUtility.getColumnValue("lot_sl", allFormDataDom, "2" ));
					//							replOrder =  checkNull(genericUtility.getColumnValue("repl_order", allFormDataDom, "2" ));
					//							tranID =  checkNull(genericUtility.getColumnValue("tran_id", hdrDataDom ));
					//
					//							sql = "SELECT SINGLE_LOT_SL, ITEM_LOT_OPT FROM LOCATION WHERE LOC_CODE = ?";
					//							pstmt = conn.prepareStatement( sql );
					//							pstmt.setString( 1, locCodeTo );
					//							rs = pstmt.executeQuery();
					//							if( rs.next() )
					//							{
					//								singleLotSl = checkNull(rs.getString("SINGLE_LOT_SL"));
					//								itemLotOpt = checkNull(rs.getString("ITEM_LOT_OPT"));
					//							}
					//							else
					//							{
					//								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//								//errString = getErrorString( "loc_code__to", "INVLOCCODE", userId );
					//								//break;
					//								errList.add( "INVLOCCODE" );
					//								errFields.add( childNodeName.toLowerCase() );
					//								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//							}
					//							rs.close();
					//							rs = null;
					//							pstmt.close();
					//							pstmt = null;
					//							
					//							//changes added by gulzar on 01/12/11 - to include order type for validating Dock location
					//							//String orderType = "";
					//							String disparmVal = "";
					//							sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR WHERE REPL_ORDER = ? ";
					//							pstmt = conn.prepareStatement( sql );
					//							pstmt.setString( 1, replOrder );
					//							rs = pstmt.executeQuery();
					//							if ( rs.next() )
					//							{
					//								orderType = checkNull(rs.getString("ORDER_TYPE"));
					//							}
					//							rs.close(); rs = null;
					//							pstmt.close(); pstmt = null;
					//
					//							if ( "D".equalsIgnoreCase(orderType) )
					//							{
					//								disparmVal = distComm.getDisparams( "999999", "DOCKLOC_INVSTAT", conn );
					//								System.out.println(" disparmVal =[" + disparmVal + "]");
					//
					//								sql = "SELECT COUNT(*) COUNT FROM LOCATION LOC, INVSTAT ISTAT WHERE LOC.INV_STAT = ISTAT.INV_STAT " +
					//										"AND LOC.LOC_CODE = ? AND LOC.INV_STAT = ? AND ISTAT.AVAILABLE = 'Y' "+
					//										"AND (CASE WHEN ISTAT.STAT_TYPE IS NULL THEN ' ' ELSE ISTAT.STAT_TYPE END) <> 'S' ";
					//								pstmt = conn.prepareStatement( sql );
					//								pstmt.setString( 1, locCodeTo );
					//								pstmt.setString( 2, disparmVal );
					//								rs = pstmt.executeQuery();	
					//								if( rs.next() )
					//								{
					//									count = rs.getInt("COUNT");
					//								}
					//								if ( count == 0 )
					//								{
					//									errList.add( "VTLOCCODE7" );
					//									errFields.add( childNodeName.toLowerCase() );
					//								}
					//							}
					//							else
					//							{
					//								//End changes by gulzar on 01/12/11
					//								// 13/06/12 manoharan commented order_type of repl_ord_hdr to be used
					//								
					//								//sql = "SELECT POD.PICK_TYPE FROM REPL_ORD_DET ROD,PICK_ORD_HDR POD WHERE ROD.PICK_ORDER = POD.PICK_ORDER AND ROD.REPL_ORDER = ?";
					//								sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR  WHERE REPL_ORDER = ?";
					//								pstmt = conn.prepareStatement( sql );
					//								pstmt.setString( 1, replOrder );
					//								rs = pstmt.executeQuery();
					//								if (rs.next())
					//								{
					//									pickType = checkNull(rs.getString("ORDER_TYPE"));
					//								}
					//								rs.close(); rs = null;
					//								pstmt.close(); pstmt = null;
					//
					//								System.out.println("pick type =[" +pickType+ "]");
					//
					//								if ( "A".equalsIgnoreCase(pickType.trim()) || "I".equalsIgnoreCase(pickType.trim()) )//Active pick
					//								{
					//									varName = "ACTIVE_PICK_INVSTAT";
					//								}
					//								else if ( "C".equalsIgnoreCase(pickType.trim()) || "M".equalsIgnoreCase(pickType.trim()) || "J".equalsIgnoreCase(pickType.trim()) || "K".equalsIgnoreCase(pickType.trim()))//Case pick & master pick
					//								{
					//									varName = "CASE_PICK_INVSTAT";
					//								}
					//								else if("E".equalsIgnoreCase(pickType.trim()) || "F".equalsIgnoreCase(pickType.trim()) || "G".equalsIgnoreCase(pickType.trim()) ||"H".equalsIgnoreCase(pickType.trim()) )
					//								{
					//									varName = "PND_INVSTAT";
					//								}
					//								else if("L".equalsIgnoreCase(pickType.trim()) || "D".equalsIgnoreCase(pickType.trim()))
					//								{
					//									varName = "DOCKLOC_INVSTAT";
					//								}
					//								//Validation added by Kunal Mandhre on 13/06/12 for pick type = E,F,G,H,I,J,K,L cases
					//
					//								disparmVal = distComm.getDisparams( "999999", varName, conn );
					//
					//								sql = "SELECT COUNT(*) AS COUNT FROM LOCATION A, INVSTAT B "
					//									+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
					//									+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
					//									+ " AND A.INV_STAT = ? AND LOC_CODE = ? ";
					//
					//								pstmt = conn.prepareStatement( sql );
					//								pstmt.setString( 1, disparmVal );
					//								pstmt.setString( 2, locCodeTo );
					//								rs = pstmt.executeQuery();
					//								if (rs.next())
					//								{
					//									count = rs.getInt("COUNT");
					//								}
					//								rs.close(); rs = null;
					//								pstmt.close(); pstmt = null;
					//								if ( count == 0 )
					//								{
					//									errList.add( "INVLOCCODE" );
					//									errFields.add( childNodeName.toLowerCase() );
					//								}
					//							
					//								//changes added by gulzar to consider for dock location - 04/12/11
					//
					//								if( singleLotSl.trim().equalsIgnoreCase("Y") )
					//								{
					//									sql = "SELECT QUANTITY FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ?"
					//											  + " AND LOC_CODE = ? AND lOT_NO = ? AND LOT_SL = ?";
					//									pstmt = conn.prepareStatement( sql );
					//									pstmt.setString( 1, itemCode );
					//									pstmt.setString( 2, siteCode );
					//									pstmt.setString( 3, locCodeTo );
					//									pstmt.setString( 4, lotNo );
					//									pstmt.setString( 5, lpnNo );
					//									rs = pstmt.executeQuery();	
					//									if( rs.next() )
					//									{
					//										quantity = rs.getDouble("QUANTITY");
					//									}
					//									rs.close();
					//									rs = null;
					//									pstmt.close();
					//									pstmt = null;
					//									
					//									if( quantity != 0 )
					//									{
					//										// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//										//errString = getErrorString( "loc_code__to", "VTLOCCODE1", userId );
					//										//break;
					//										errList.add( "VTLOCCODE1" );
					//										errFields.add( childNodeName.toLowerCase() );
					//										// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//									}
					//									//Changed by Gulzar on 5/12/2012
					//									String locCodeExist = "";
					//									NodeList locCodeNodeList = null;
					//									ArrayList dupLocCodeList = new ArrayList();
					//
					//									int noOfLocCode = 0;
					//									int listLen = 0;
					//									int recCnt = 0;
					//									int locCodeCntDb = 0;
					//
					//									locCodeNodeList = allFormDataDom.getElementsByTagName("loc_code__to");
					//									noOfLocCode = locCodeNodeList.getLength();
					//									
					//									for( int idx = 0; idx < noOfLocCode; idx++ )
					//									{
					//										if ( locCodeNodeList.item( idx ).getFirstChild() != null )
					//										{
					//											dupLocCodeList.add((String)( locCodeNodeList.item( idx ).getFirstChild() ).getNodeValue());
					//										}
					//									}
					//									listLen = dupLocCodeList.size();
					//									if ( listLen > 0 )
					//									{
					//										recCnt = 1;
					//										for( int i = 0; i < listLen - 1; i++ )
					//										{
					//											for ( int j = i+1; j < listLen; j++ )
					//											{
					//												if ( ((String)dupLocCodeList.get(i)).equalsIgnoreCase((String)dupLocCodeList.get(j)) )
					//												{
					//													recCnt++;
					//													break;
					//												}
					//											}
					//											if( recCnt > 1 )
					//											{
					//												break;
					//											}
					//										}
					//									}
					//									System.out.println("recCnt = ["+recCnt+"]");
					//		
					//									if( recCnt > 1 )
					//									{
					//										errList.add( "DUPLOCCODE" );
					//										errFields.add( childNodeName.toLowerCase() );
					//									}
					//									//End changed by Gulzar on 5/12/2012
					//								}//singleLotSl = Y
					//								else
					//								{
					//									if( itemLotOpt.trim().equals("0") )  // Validation for single item_code single lot_no
					//									{
					//										/*--commented by gulzar - 01/12/11
					//										sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
					//										pstmt = conn.prepareStatement( sql );
					//										pstmt.setString( 1, itemCode );
					//										pstmt.setString( 2, siteCode );
					//										pstmt.setString( 3, locCodeTo );
					//										pstmt.setString( 4, lotNo );
					//										rs = pstmt.executeQuery();
					//										if( rs.next() )
					//										{
					//											count = rs.getInt("COUNT");
					//										}
					//										rs.close();
					//										rs = null;
					//										pstmt.close();
					//										pstmt = null;
					//
					//										if( count > 0 )
					//										{
					//											// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//											//errString = getErrorString("loc_code__to", "VTLOCCODE3", userId );
					//											//break;
					//											errList.add( "VTLOCCODE3" );
					//											errFields.add( childNodeName.toLowerCase() );
					//											// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//										}
					//										*/
					//										sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
					//										pstmt = conn.prepareStatement( sql );
					//										pstmt.setString( 1, itemCode );
					//										pstmt.setString( 2, siteCode );
					//										pstmt.setString( 3, locCodeTo );
					//										pstmt.setString( 4, lotNo );
					//										rs = pstmt.executeQuery();
					//										if( rs.next() )
					//										{
					//											count = rs.getInt("COUNT");
					//										}
					//										rs.close();
					//										rs = null;
					//										pstmt.close();
					//										pstmt = null;
					//
					//										if( count > 0 )
					//										{
					//											// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//											//errString = getErrorString("loc_code__to", "VTLOCCODE2", userId );
					//											{	
					//												Node childNode = childList.item( ctr );
					//												if( childNode.getNodeType() != Node.ELEMENT_NODE )
					//												{
					//													continue;
					//												}
					//												String childNodeName = childNode.getNodeName();
					//												if ( childNode != null && childNode.getFirstChild() != null )
					//												{
					//													columnValue = childNode.getFirstChild().getNodeValue();
					//												}
					//												System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
					//												if ( "lot_sl".equalsIgnoreCase( childNodeName ) )
					//												{									
					//													replOrder =  genericUtility.getColumnValue("repl_order", allFormDataDom, "2" );
					//													lpnNo =  genericUtility.getColumnValue("lot_sl", allFormDataDom, "2" );
					//													lineNoOrd = Integer.parseInt( genericUtility.getColumnValue("line_no__ord", allFormDataDom, "2" ) );
					//
					//													sql = "SELECT COUNT(*) AS COUNT FROM REPL_ORD_DET WHERE LOT_SL = ? AND REPL_ORDER = ? AND LINE_NO = ?";
					//													pstmt = conn.prepareStatement( sql );
					//													pstmt.setString( 1, lpnNo );
					//													pstmt.setString( 2, replOrder );
					//													pstmt.setInt( 3, lineNoOrd );
					//													rs = pstmt.executeQuery();	
					//													if( rs.next() )
					//													{
					//														count = rs.getInt("COUNT");
					//													}
					//													rs.close();
					//													rs = null;
					//													pstmt.close();
					//													pstmt = null;
					//
					//													if( count <= 0 )
					//													{
					//														// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//														//errString = getErrorString( "lot_sl", "INVLDLOTSL", userId );
					//														//break;
					//														errList.add( "INVLDLOTSL" );
					//														errFields.add( childNodeName.toLowerCase() );
					//														// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//													}								
					//												}
					//												else if ( "lot_sl_new".equalsIgnoreCase( childNodeName ) ) //added by kunal mandhre on 05/JUN/12 - WM1ESUN007
					//												{
					//													//String orderType = "";
					//													
					//													lotSlNew =  genericUtility.getColumnValue("lot_sl_new", allFormDataDom, "2" );
					//													replOrder =  checkNull(genericUtility.getColumnValue("repl_order", allFormDataDom, "2" ));
					//													
					//													sql = "select pick_order from repl_ord_det where repl_order= ? ";
					//													pstmt = conn.prepareStatement( sql );
					//													pstmt.setString( 1, replOrder);
					//													rs = pstmt.executeQuery();	
					//													if( rs.next() )
					//													{
					//														pickOrder = rs.getString("pick_order") == null?"":rs.getString("pick_order");
					//													}
					//													rs.close();
					//													rs = null;
					//													pstmt.close();
					//													pstmt = null;
					//													
					//													sql = "select pick_type from pick_ord_hdr where pick_order = ?";
					//													pstmt = conn.prepareStatement( sql );
					//													pstmt.setString( 1, replOrder);
					//													rs = pstmt.executeQuery();	
					//													if( rs.next() )
					//													{
					//														orderType = rs.getString("pick_type") == null?"":rs.getString("pick_type");
					//													}
					//													rs.close();
					//													rs = null;
					//													pstmt.close();
					//													pstmt = null;
					//
					//													if((lotSlNew == null || lotSlNew.trim().length()== 0) && "A".equalsIgnoreCase(orderType) )
					//													{
					//														errList.add( "LPNORDTYPE" );
					//														errFields.add( childNodeName.toLowerCase() );
					//													}								
					//												}
					//												/*
					//												else if( "loc_code__to".equalsIgnoreCase( childNodeName ) )
					//												{								
					//													itemCode = checkNull(genericUtility.getColumnValue("item_code", allFormDataDom, "2" ));
					//													siteCode = checkNull(genericUtility.getColumnValue("site_code", allFormDataDom, "2" ));
					//													locCodeTo = checkNull(genericUtility.getColumnValue("loc_code__to", allFormDataDom, "2" ));
					//													lotNo = checkNull(genericUtility.getColumnValue("lot_no", allFormDataDom, "2" ));
					//													lpnNo = checkNull(genericUtility.getColumnValue("lot_sl", allFormDataDom, "2" ));
					//													replOrder =  checkNull(genericUtility.getColumnValue("repl_order", allFormDataDom, "2" ));
					//													tranID =  checkNull(genericUtility.getColumnValue("tran_id", hdrDataDom ));
					//
					//													sql = "SELECT SINGLE_LOT_SL, ITEM_LOT_OPT FROM LOCATION WHERE LOC_CODE = ?";
					//													pstmt = conn.prepareStatement( sql );
					//													pstmt.setString( 1, locCodeTo );
					//													rs = pstmt.executeQuery();
					//													if( rs.next() )
					//													{
					//														singleLotSl = checkNull(rs.getString("SINGLE_LOT_SL"));
					//														itemLotOpt = checkNull(rs.getString("ITEM_LOT_OPT"));
					//													}
					//													else
					//													{
					//														// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//														//errString = getErrorString( "loc_code__to", "INVLOCCODE", userId );
					//														//break;
					//														errList.add( "INVLOCCODE" );
					//														errFields.add( childNodeName.toLowerCase() );
					//														// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//													}
					//													rs.close();
					//													rs = null;
					//													pstmt.close();
					//													pstmt = null;
					//													
					//													//changes added by gulzar on 01/12/11 - to include order type for validating Dock location
					//													//String orderType = "";
					//													String disparmVal = "";
					//													sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR WHERE REPL_ORDER = ? ";
					//													pstmt = conn.prepareStatement( sql );
					//													pstmt.setString( 1, replOrder );
					//													rs = pstmt.executeQuery();
					//													if ( rs.next() )
					//													{
					//														orderType = checkNull(rs.getString("ORDER_TYPE"));
					//													}
					//													rs.close(); rs = null;
					//													pstmt.close(); pstmt = null;
					//
					//													if ( "D".equalsIgnoreCase(orderType) )
					//													{
					//														disparmVal = distComm.getDisparams( "999999", "DOCKLOC_INVSTAT", conn );
					//														System.out.println(" disparmVal =[" + disparmVal + "]");
					//
					//														sql = "SELECT COUNT(*) COUNT FROM LOCATION LOC, INVSTAT ISTAT WHERE LOC.INV_STAT = ISTAT.INV_STAT " +
					//																"AND LOC.LOC_CODE = ? AND LOC.INV_STAT = ? AND ISTAT.AVAILABLE = 'Y' "+
					//																"AND (CASE WHEN ISTAT.STAT_TYPE IS NULL THEN ' ' ELSE ISTAT.STAT_TYPE END) <> 'S' ";
					//														pstmt = conn.prepareStatement( sql );
					//														pstmt.setString( 1, locCodeTo );
					//														pstmt.setString( 2, disparmVal );
					//														rs = pstmt.executeQuery();	
					//														if( rs.next() )
					//														{
					//															count = rs.getInt("COUNT");
					//														}
					//														if ( count == 0 )
					//														{
					//															errList.add( "VTLOCCODE7" );
					//															errFields.add( childNodeName.toLowerCase() );
					//														}
					//													}
					//													else
					//													{
					//														//End changes by gulzar on 01/12/11
					//														// 13/06/12 manoharan commented order_type of repl_ord_hdr to be used
					//														
					//														//sql = "SELECT POD.PICK_TYPE FROM REPL_ORD_DET ROD,PICK_ORD_HDR POD WHERE ROD.PICK_ORDER = POD.PICK_ORDER AND ROD.REPL_ORDER = ?";
					//														sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR  WHERE REPL_ORDER = ?";
					//														pstmt = conn.prepareStatement( sql );
					//														pstmt.setString( 1, replOrder );
					//														rs = pstmt.executeQuery();
					//														if (rs.next())
					//														{
					//															pickType = checkNull(rs.getString("ORDER_TYPE"));
					//														}
					//														rs.close(); rs = null;
					//														pstmt.close(); pstmt = null;
					//
					//														System.out.println("pick type =[" +pickType+ "]");
					//
					//														if ( "A".equalsIgnoreCase(pickType.trim()) || "I".equalsIgnoreCase(pickType.trim()) )//Active pick
					//														{
					//															varName = "ACTIVE_PICK_INVSTAT";
					//														}
					//														else if ( "C".equalsIgnoreCase(pickType.trim()) || "M".equalsIgnoreCase(pickType.trim()) || "J".equalsIgnoreCase(pickType.trim()) || "K".equalsIgnoreCase(pickType.trim()))//Case pick & master pick
					//														{
					//															varName = "CASE_PICK_INVSTAT";
					//														}
					//														else if("E".equalsIgnoreCase(pickType.trim()) || "F".equalsIgnoreCase(pickType.trim()) || "G".equalsIgnoreCase(pickType.trim()) ||"H".equalsIgnoreCase(pickType.trim()) )
					//														{
					//															varName = "PND_INVSTAT";
					//														}
					//														else if("L".equalsIgnoreCase(pickType.trim()) || "D".equalsIgnoreCase(pickType.trim()))
					//														{
					//															varName = "DOCKLOC_INVSTAT";
					//														}
					//														//Validation added by Kunal Mandhre on 13/06/12 for pick type = E,F,G,H,I,J,K,L cases
					//
					//														disparmVal = distComm.getDisparams( "999999", varName, conn );
					//
					//														sql = "SELECT COUNT(*) AS COUNT FROM LOCATION A, INVSTAT B "
					//															+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
					//															+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
					//															+ " AND A.INV_STAT = ? AND LOC_CODE = ? ";
					//
					//														pstmt = conn.prepareStatement( sql );
					//														pstmt.setString( 1, disparmVal );
					//														pstmt.setString( 2, locCodeTo );
					//														rs = pstmt.executeQuery();
					//														if (rs.next())
					//														{
					//															count = rs.getInt("COUNT");
					//														}
					//														rs.close(); rs = null;
					//														pstmt.close(); pstmt = null;
					//														if ( count == 0 )
					//														{
					//															errList.add( "INVLOCCODE" );
					//															errFields.add( childNodeName.toLowerCase() );
					//														}
					//													
					//														//changes added by gulzar to consider for dock location - 04/12/11
					//
					//														if( singleLotSl.trim().equalsIgnoreCase("Y") )
					//														{
					//															sql = "SELECT QUANTITY FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ?"
					//																	  + " AND LOC_CODE = ? AND lOT_NO = ? AND LOT_SL = ?";
					//															pstmt = conn.prepareStatement( sql );
					//															pstmt.setString( 1, itemCode );
					//															pstmt.setString( 2, siteCode );
					//															pstmt.setString( 3, locCodeTo );
					//															pstmt.setString( 4, lotNo );
					//															pstmt.setString( 5, lpnNo );
					//															rs = pstmt.executeQuery();	
					//															if( rs.next() )
					//															{
					//																quantity = rs.getDouble("QUANTITY");
					//															}
					//															rs.close();
					//															rs = null;
					//															pstmt.close();
					//															pstmt = null;
					//															
					//															if( quantity != 0 )
					//															{
					//																// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//																//errString = getErrorString( "loc_code__to", "VTLOCCODE1", userId );
					//																//break;
					//																errList.add( "VTLOCCODE1" );
					//																errFields.add( childNodeName.toLowerCase() );
					//																// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//															}
					//															//Changed by Gulzar on 5/12/2012
					//															String locCodeExist = "";
					//															NodeList locCodeNodeList = null;
					//															ArrayList dupLocCodeList = new ArrayList();
					//
					//															int noOfLocCode = 0;
					//															int listLen = 0;
					//															int recCnt = 0;
					//															int locCodeCntDb = 0;
					//
					//															locCodeNodeList = allFormDataDom.getElementsByTagName("loc_code__to");
					//															noOfLocCode = locCodeNodeList.getLength();
					//															
					//															for( int idx = 0; idx < noOfLocCode; idx++ )
					//															{
					//																if ( locCodeNodeList.item( idx ).getFirstChild() != null )
					//																{
					//																	dupLocCodeList.add((String)( locCodeNodeList.item( idx ).getFirstChild() ).getNodeValue());
					//																}
					//															}
					//															listLen = dupLocCodeList.size();
					//															if ( listLen > 0 )
					//															{
					//																recCnt = 1;
					//																for( int i = 0; i < listLen - 1; i++ )
					//																{
					//																	for ( int j = i+1; j < listLen; j++ )
					//																	{
					//																		if ( ((String)dupLocCodeList.get(i)).equalsIgnoreCase((String)dupLocCodeList.get(j)) )
					//																		{
					//																			recCnt++;
					//																			break;
					//																		}
					//																	}
					//																	if( recCnt > 1 )
					//																	{
					//																		break;
					//																	}
					//																}
					//															}
					//															System.out.println("recCnt = ["+recCnt+"]");
					//								
					//															if( recCnt > 1 )
					//															{
					//																errList.add( "DUPLOCCODE" );
					//																errFields.add( childNodeName.toLowerCase() );
					//															}
					//															//End changed by Gulzar on 5/12/2012
					//														}//singleLotSl = Y
					//														else
					//														{
					//															if( itemLotOpt.trim().equals("0") )  // Validation for single item_code single lot_no
					//															{
					//																/*--commented by gulzar - 01/12/11
					//																sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
					//																pstmt = conn.prepareStatement( sql );
					//																pstmt.setString( 1, itemCode );
					//																pstmt.setString( 2, siteCode );
					//																pstmt.setString( 3, locCodeTo );
					//																pstmt.setString( 4, lotNo );
					//																rs = pstmt.executeQuery();
					//																if( rs.next() )
					//																{
					//																	count = rs.getInt("COUNT");
					//																}
					//																rs.close();
					//																rs = null;
					//																pstmt.close();
					//																pstmt = null;
					//
					//																if( count > 0 )
					//																{
					//																	// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//																	//errString = getErrorString("loc_code__to", "VTLOCCODE3", userId );
					//																	//break;
					//																	errList.add( "VTLOCCODE3" );
					//																	errFields.add( childNodeName.toLowerCase() );
					//																	// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//																}
					//																*/
					//																sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
					//																pstmt = conn.prepareStatement( sql );
					//																pstmt.setString( 1, itemCode );
					//																pstmt.setString( 2, siteCode );
					//																pstmt.setString( 3, locCodeTo );
					//																pstmt.setString( 4, lotNo );
					//																rs = pstmt.executeQuery();
					//																if( rs.next() )
					//																{
					//																	count = rs.getInt("COUNT");
					//																}
					//																rs.close();
					//																rs = null;
					//																pstmt.close();
					//																pstmt = null;
					//
					//																if( count > 0 )
					//																{
					//																	// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//																	//errString = getErrorString("loc_code__to", "VTLOCCODE2", userId );
					//																	//break;
					//																	errList.add( "VTLOCCODE2" );
					//																	errFields.add( childNodeName.toLowerCase() );
					//																	// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//																}
					//															}		//break;
					//											errList.add( "VTLOCCODE2" );
					//											errFields.add( childNodeName.toLowerCase() );
					//											// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//										}
					//									}//itemLotOpt = 0
					//					
					//									else if( itemLotOpt.trim().equals("1") )  //Validation for single item_code multiple lot_no
					//									{
					//										sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? ";
					//										pstmt = conn.prepareStatement( sql );
					//										pstmt.setString( 1, itemCode );
					//										pstmt.setString( 2, siteCode );
					//										pstmt.setString( 3, locCodeTo );
					//										pstmt.setString( 4, lotNo );
					//										rs = pstmt.executeQuery();
					//										if( rs.next() )
					//										{
					//											count = rs.getInt("COUNT");
					//										}
					//										rs.close();
					//										rs = null;
					//										pstmt.close();
					//										pstmt = null;
					//										if( count > 0 )
					//										{
					//											// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//											//errString = getErrorString("loc_code__to", "VTLOCCODE4", userId );
					//											//break;
					//											errList.add( "VTLOCCODE4" );
					//											errFields.add( childNodeName.toLowerCase() );
					//											// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//										}	
					//									}//itemLotOpt = 1 
					//								}
					//								
					//								sql = "SELECT RIH.CONFIRMED FROM REPL_ISS_HDR RIH, REPL_ISS_DET RID"
					//									  + " WHERE RIH.TRAN_ID = RID.TRAN_ID AND RID.ITEM_CODE = ?"
					//									  + " AND RID.SITE_CODE = ? AND RID.LOC_CODE__TO = ?"
					//									  + " AND RID.LOT_NO = ? AND RID.LOT_SL = ? AND RIH.TRAN_ID <> ? ";
					//								pstmt = conn.prepareStatement( sql );
					//								pstmt.setString( 1, itemCode );
					//								pstmt.setString( 2, siteCode );
					//								pstmt.setString( 3, locCodeTo );
					//								pstmt.setString( 4, lotNo );
					//								pstmt.setString( 5, lpnNo );
					//								pstmt.setString( 6, tranID );
					//								rs = pstmt.executeQuery();	
					//							
					//								if( rs.next() )
					//								{
					//									confirmed = checkNull(rs.getString("CONFIRMED"));
					//								}
					//								rs.close();
					//								rs = null;
					//								pstmt.close();
					//								pstmt = null;
					//							
					//								if( confirmed.trim().equalsIgnoreCase("N") )
					//								{
					//									// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//									//errString = getErrorString( "loc_code__to", "VTLOCCODE6", userId );
					//									//break;
					//									errList.add( "VTLOCCODE6" );
					//									errFields.add( childNodeName.toLowerCase() );
					//									// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
					//								}
					//							}//else of if ( "D".equalsIgnoreCase(orderType) )
					//						}
					//Ended By Mahesh Patidar

				}
				/*
					for( int prnt = 0; prnt < noOfParent; prnt++ )  // Loop for multiple details in allFormDataDom
					{
						childList = parentList.item(prnt).getChildNodes();
						noOfChilds = childList.getLength();

						rowCountStr = ""+(prnt+1);
						System.out.println("rowCountStr=["+rowCountStr+"]");

						for ( int ctr = 0; ctr < noOfChilds; ctr++ )  //Loop for each node of current detail
						{	
							Node childNode = childList.item( ctr );
							if( childNode.getNodeType() != Node.ELEMENT_NODE )
							{
								continue;
							}
							String childNodeName = childNode.getNodeName();
							if ( childNode != null && childNode.getFirstChild() != null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
							}
							System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
							if ( "lot_sl".equalsIgnoreCase( childNodeName ) )
							{									
								replOrder =  genericUtility.getColumnValue("repl_order", allFormDataDom, "2", rowCountStr );
								lpnNo =  genericUtility.getColumnValue("lot_sl", allFormDataDom, "2", rowCountStr );
								lineNoOrd = Integer.parseInt( genericUtility.getColumnValue("line_no__ord", allFormDataDom, "2", rowCountStr ) );

								sql = "SELECT COUNT(*) AS COUNT FROM REPL_ORD_DET WHERE LOT_SL = ? AND REPL_ORDER = ? AND LINE_NO = ?";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, lpnNo );
								pstmt.setString( 2, replOrder );
								pstmt.setInt( 3, lineNoOrd );
								rs = pstmt.executeQuery();	
								if( rs.next() )
								{
									count = rs.getInt("COUNT");
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}							
								if( count <= 0 )
								{
									errString = getErrorString( "lot_sl", "INVLDLOTSL", userId );
									break;
								}								
							}
							else if( "loc_code__to".equalsIgnoreCase( childNodeName ) )
							{								
								itemCode = genericUtility.getColumnValue("item_code", allFormDataDom, "2", rowCountStr );
								siteCode = genericUtility.getColumnValue("site_code", allFormDataDom, "2", rowCountStr );
								locCodeTo = genericUtility.getColumnValue("loc_code__to", allFormDataDom, "2", rowCountStr );
								lotNo = genericUtility.getColumnValue("lot_no", allFormDataDom, "2", rowCountStr );
								lpnNo = genericUtility.getColumnValue("lot_sl", allFormDataDom, "2", rowCountStr );
								replOrder =  genericUtility.getColumnValue("repl_order", allFormDataDom, "2", rowCountStr );

								sql = "SELECT SINGLE_LOT_SL, ITEM_LOT_OPT FROM LOCATION WHERE LOC_CODE = ?";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, locCodeTo );
								rs = pstmt.executeQuery();
								if( rs.next() )
								{
									singleLotSl = checkNull(rs.getString("SINGLE_LOT_SL"));
									itemLotOpt = checkNull(rs.getString("ITEM_LOT_OPT"));
								}
								else
								{
									errString = getErrorString( "loc_code__to", "INVLOCCODE", userId );
									break;
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}

								if( singleLotSl.trim().equalsIgnoreCase("Y") )
								{
									sql = "SELECT QUANTITY FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ?"
											  + " AND LOC_CODE = ? AND lOT_NO = ? AND LOT_SL = ?";
									pstmt = conn.prepareStatement( sql );
									pstmt.setString( 1, itemCode );
									pstmt.setString( 2, siteCode );
									pstmt.setString( 3, locCodeTo );
									pstmt.setString( 4, lotNo );
									pstmt.setString( 5, lpnNo );
									rs = pstmt.executeQuery();	
									if( rs.next() )
									{
										quantity = rs.getDouble("QUANTITY");
									}
									if( rs != null )
									{
										rs.close();
										rs = null;
									}
									if( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}

									if( quantity != 0 )
									{
										errString = getErrorString( "loc_code__to", "INVLOCCODE", userId );
										break;
									}
								}
								else
								{
									if( itemLotOpt.trim().equals("0") )  // Validation for single item_code single lot_no
									{
										sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
										pstmt = conn.prepareStatement( sql );
										pstmt.setString( 1, itemCode );
										pstmt.setString( 2, siteCode );
										pstmt.setString( 3, locCodeTo );
										pstmt.setString( 4, lotNo );
										rs = pstmt.executeQuery();
										if( rs.next() )
										{
											count = rs.getInt("COUNT");
										}
										if( rs != null )
										{
											rs.close();
											rs = null;
										}
										if( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										if( count > 0 )
										{
											errString = getErrorString("loc_code__to", "INVLOCCODE", userId );
											break;
										}	
									}
									else if( itemLotOpt.trim().equals("1") )  //Validation for single item_code multiple lot_no
									{
										sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? ";
										pstmt = conn.prepareStatement( sql );
										pstmt.setString( 1, itemCode );
										pstmt.setString( 2, siteCode );
										pstmt.setString( 3, locCodeTo );
										pstmt.setString( 4, lotNo );
										rs = pstmt.executeQuery();
										if( rs.next() )
										{
											count = rs.getInt("COUNT");
										}
										if( rs != null )
										{
											rs.close();
											rs = null;
										}
										if( pstmt != null )
										{
											pstmt.close();
											pstmt = null;
										}
										if( count > 0 )
										{
											errString = getErrorString("loc_code__to", "INVLOCCODE", userId );
											break;
										}	
									}
								}									

								sql = "SELECT RIH.CONFIRMED FROM REPL_ISS_HDR RIH, REPL_ISS_DET RID"
									  + " WHERE RIH.TRAN_ID = RID.TRAN_ID AND RID.ITEM_CODE = ?"
									  + " AND RID.SITE_CODE = ? AND RID.LOC_CODE__TO = ?"
									  + " AND RID.LOT_NO = ? AND RID.LOT_SL = ?";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, itemCode );
								pstmt.setString( 2, siteCode );
								pstmt.setString( 3, locCodeTo );
								pstmt.setString( 4, lotNo );
								pstmt.setString( 5, lpnNo );
								rs = pstmt.executeQuery();	

								if( rs.next() )
								{
									confirmed = checkNull(rs.getString("CONFIRMED"));
								}
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}

								if( confirmed.trim().equalsIgnoreCase("N") )
								{
									errString = getErrorString( "loc_code__to", "INVLOCCODE", userId );
									break;
								}									
							}
						}
						if ( errString != null && errString.trim().length() > 0 )
						{
							break;
						}
					}
				 */
			} 
			break;
			//Added By Mahesh Patidar on 31/07/12
			case 4:
			{
				//Changed by Rohan on 26-04-13 for define variable.start
				String currentLoction = "";
				int noOfLocCode = 0;
				NodeList locCodeNodeList = null;
				HashMap<String, String> locCodeList = new HashMap<String, String>();
				String itemCode1 = "";
				String lotNo1 = "";
				String locKeyVal = "";
				String[] temp ;    
				//Changed by Rohan on 26-04-13 for define variable.end
				
				childList = parentList.item(0).getChildNodes();
				noOfChilds = childList.getLength();
				for ( int ctr = 0; ctr < noOfChilds; ctr++ )  
				{	
					Node childNode = childList.item( ctr );
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}
					String childNodeName = childNode.getNodeName();
					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");

					if( "loc_code__to".equalsIgnoreCase( childNodeName ) && "active_repl_iss".equalsIgnoreCase(getObjNameFromDom(currFormDataDom, "objName", objContext)) )
					{	
						
						/*itemCode = checkNull(genericUtility.getColumnValue("item_code", allFormDataDom, "3" ));
						siteCode = checkNull(genericUtility.getColumnValue("site_code", allFormDataDom, "3" ));
						locCodeTo = columnValue ;//checkNull(genericUtility.getColumnValue("loc_code__to", currFormDataDom));
						lotNo = checkNull(genericUtility.getColumnValue("lot_no", allFormDataDom, "3" ));
						lpnNo = checkNull(genericUtility.getColumnValue("lot_sl", allFormDataDom, "3" ));
						replOrder =  checkNull(genericUtility.getColumnValue("repl_order", allFormDataDom, "3" ));*/
						
						locCodeTo = columnValue ;//checkNull(genericUtility.getColumnValue("loc_code__to", currFormDataDom));
						itemCode = checkNull(genericUtility.getColumnValue("item_code", allFormDataDom, "4" ));
						siteCode = checkNull(genericUtility.getColumnValue("site_code", allFormDataDom, "4" ));
						lotNo = checkNull(genericUtility.getColumnValue("lot_no", allFormDataDom, "4" ));
						lpnNo = checkNull(genericUtility.getColumnValue("lot_sl", allFormDataDom, "4" ));
						//replOrder =  checkNull(genericUtility.getColumnValue("repl_order", allFormDataDom, "4" ));
						replOrder =  checkNull(genericUtility.getColumnValue("repl_order", allFormDataDom, "3" ));
						
						System.out.println("itemCode"+itemCode+"siteCode"+siteCode+"lotNo"+lotNo+"lpnNo"+lpnNo+"replOrder"+replOrder);
						
						tranID =  checkNull(genericUtility.getColumnValue("tran_id", hdrDataDom ));
						//locCode = checkNull(genericUtility.getColumnValue("loc_code", allFormDataDom, "3" ));
						locCode = checkNull(genericUtility.getColumnValue("loc_code", currFormDataDom));
						String taskStatus = "N";
						
						
						sql = "SELECT STATUS FROM WAVE_TASK_DET WHERE REF_ID = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, replOrder );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							taskStatus = checkNull(rs.getString("STATUS"));
							
						}
						if("Y".equalsIgnoreCase(taskStatus))
						{
							errList.add( "ACTRPLCONF" );
							errFields.add( childNodeName.toLowerCase() );
							break;
						}						
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						
						
						
						sql = "SELECT SINGLE_LOT_SL, ITEM_LOT_OPT FROM LOCATION WHERE LOC_CODE = ?";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, locCodeTo );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							singleLotSl = checkNull(rs.getString("SINGLE_LOT_SL"));
							itemLotOpt = checkNull(rs.getString("ITEM_LOT_OPT"));
						}
						else
						{
							errList.add( "INVLOCCODE" );
							errFields.add( childNodeName.toLowerCase() );
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;


						sql = "SELECT loc_type FROM LOCATION WHERE LOC_CODE = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, locCodeTo );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							itemLocType = checkNullAndTrim(rs.getString(1));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						sql = "SELECT loc_type FROM item WHERE item_code = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, itemCode );
						rs = pstmt.executeQuery();
						if( rs.next() )
						{
							locationLocType = checkNullAndTrim(rs.getString(1));
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						if(! itemLocType.equals(locationLocType))
						{
							errList.add( "VMLOCTYP1" );
							errFields.add( childNodeName.toLowerCase() );
						}

						String disparmVal = "";
						sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR WHERE REPL_ORDER = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, replOrder );
						rs = pstmt.executeQuery();
						if ( rs.next() )
						{
							orderType = checkNull(rs.getString("ORDER_TYPE"));
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;

						if ( "D".equalsIgnoreCase(orderType) )
						{
							disparmVal = distComm.getDisparams( "999999", "DOCKLOC_INVSTAT", conn );
							System.out.println(" disparmVal =[" + disparmVal + "]");

							sql = "SELECT COUNT(*) COUNT FROM LOCATION LOC, INVSTAT ISTAT WHERE LOC.INV_STAT = ISTAT.INV_STAT " +
									"AND LOC.LOC_CODE = ? AND LOC.INV_STAT = ? AND ISTAT.AVAILABLE = 'Y' "+
									"AND (CASE WHEN ISTAT.STAT_TYPE IS NULL THEN ' ' ELSE ISTAT.STAT_TYPE END) <> 'S' ";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, locCodeTo );
							pstmt.setString( 2, disparmVal );
							rs = pstmt.executeQuery();	
							if( rs.next() )
							{
								count = rs.getInt("COUNT");
							}
							if ( count == 0 )
							{
								errList.add( "VTLOCCODE7" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						else
						{
							sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR  WHERE REPL_ORDER = ?";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, replOrder );
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								pickType = checkNull(rs.getString("ORDER_TYPE"));
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;

							System.out.println("pick type =[" +pickType+ "]");

							/*if ( "A".equalsIgnoreCase(pickType.trim()) || "I".equalsIgnoreCase(pickType.trim()) )//Active pick
							{
								varName = "ACTIVE_PICK_INVSTAT";
							}
							else if ( "C".equalsIgnoreCase(pickType.trim()) || "M".equalsIgnoreCase(pickType.trim()) || "J".equalsIgnoreCase(pickType.trim()) || "K".equalsIgnoreCase(pickType.trim()))//Case pick & master pick
							{
								varName = "CASE_PICK_INVSTAT";
							}
							else if("E".equalsIgnoreCase(pickType.trim()) || "F".equalsIgnoreCase(pickType.trim()) || "G".equalsIgnoreCase(pickType.trim()) ||"H".equalsIgnoreCase(pickType.trim()) )
							{
								varName = "PND_INVSTAT";
							}
							else if("L".equalsIgnoreCase(pickType.trim()) || "D".equalsIgnoreCase(pickType.trim()))
							{
								varName = "DOCKLOC_INVSTAT";
							}*/
							//Changed By Pragyan 07-apr-14 to set proper pick type
							//Changed By Sumit as the pick type "Q" required.
							//if ( "A".equalsIgnoreCase(pickType.trim()) || "I".equalsIgnoreCase(pickType.trim()) )//Active pick//
							//if ( "A".equalsIgnoreCase(pickType.trim()) || "I".equalsIgnoreCase(pickType.trim()) || "Q".equalsIgnoreCase(pickType.trim()) ||  "T".equalsIgnoreCase(pickType.trim()) ||  "P".equalsIgnoreCase(pickType.trim()))//Active pick
							if ( "A".equalsIgnoreCase(pickType.trim()) || "I".equalsIgnoreCase(pickType.trim()) || "Q".equalsIgnoreCase(pickType.trim()) ||  "T".equalsIgnoreCase(pickType.trim()) ||  "P".equalsIgnoreCase(pickType.trim()) )//Active pick
							{
								varName = "ACTIVE_PICK_INVSTAT";
							}
							else if ( "C".equalsIgnoreCase(pickType.trim()) || "M".equalsIgnoreCase(pickType.trim()) || "J".equalsIgnoreCase(pickType.trim()) || "K".equalsIgnoreCase(pickType.trim()))//Case pick & master pick
							{
								varName = "CASE_PICK_INVSTAT";
							}
							else if("E".equalsIgnoreCase(pickType.trim()) || "F".equalsIgnoreCase(pickType.trim()) || "G".equalsIgnoreCase(pickType.trim()) ||"H".equalsIgnoreCase(pickType.trim()) )
							{
								varName = "PND_INVSTAT";
							}
							else if("L".equalsIgnoreCase(pickType.trim()) || "D".equalsIgnoreCase(pickType.trim()))
							{
								varName = "DOCKLOC_INVSTAT";
							}
							
							disparmVal = distComm.getDisparams( "999999", varName, conn );

							if ("PND_INVSTAT".equalsIgnoreCase(varName)) 
							{									
								sql = "SELECT COUNT(*) AS COUNT FROM LOCATION A, INVSTAT B "
										+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
										+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
										+ " AND A.INV_STAT = ? AND LOC_CODE = ? "
										+ " and LOC_GROUP = (SELECT DROP_GROUP FROM LOCATION WHERE LOC_CODE = ? )";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, disparmVal);
								pstmt.setString(2, locCodeTo);
								pstmt.setString(3, locCode );
							}
							else
							{
								sql = "SELECT COUNT(*) AS COUNT FROM LOCATION A, INVSTAT B "
										+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
										+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
										+ " AND A.INV_STAT = ? AND LOC_CODE = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, disparmVal);
								pstmt.setString(2, locCodeTo);
							}
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								count = rs.getInt("COUNT");
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							if ( count == 0 )
							{
								errList.add( "INVLOCCODE" );
								errFields.add( childNodeName.toLowerCase() );
							}
							if( singleLotSl.trim().equalsIgnoreCase("Y") )
							{
								sql = "SELECT QUANTITY FROM STOCK WHERE SITE_CODE = ?  AND LOC_CODE = ? ORDER BY QUANTITY DESC";
								pstmt = conn.prepareStatement( sql );
								pstmt.setString( 1, siteCode );
								pstmt.setString( 2, locCodeTo );
								rs = pstmt.executeQuery();	
								if( rs.next() )
								{
									quantity = rs.getDouble("QUANTITY");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								if( quantity != 0 )
								{
									errList.add( "VTLOCCODE1" );
									errFields.add( childNodeName.toLowerCase() );
								}
								//Changed by Rohan on 26-03-13 for define validation out of  singleLotSl validation.start
								/*
								String locCodeExist = "";
								NodeList locCodeNodeList = null;
								ArrayList dupLocCodeList = new ArrayList();

								int noOfLocCode = 0;
								int listLen = 0;
								int recCnt = 0;
								int locCodeCntDb = 0;

								locCodeNodeList = allFormDataDom.getElementsByTagName("loc_code__to");
								noOfLocCode = locCodeNodeList.getLength();

								for( int idx = 0; idx < noOfLocCode; idx++ )
								{
									if ( locCodeNodeList.item( idx ).getFirstChild() != null )
									{
										dupLocCodeList.add((String)( locCodeNodeList.item( idx ).getFirstChild() ).getNodeValue());
									}
								}
								listLen = dupLocCodeList.size();
								if ( listLen > 0 )
								{
									recCnt = 1;
									for( int i = 0; i < listLen - 1; i++ )
									{
										for ( int j = i+1; j < listLen; j++ )
										{
											if ( ((String)dupLocCodeList.get(i)).equalsIgnoreCase((String)dupLocCodeList.get(j)) )
											{
												recCnt++;
												break;
											}
										}
										if( recCnt > 1 )
										{
											break;
										}
									}
								}
								System.out.println("recCnt = ["+recCnt+"]");

								if( recCnt > 1 )
								{
									errList.add( "DUPLOCCODE" );
									errFields.add( childNodeName.toLowerCase() );
								}
								*/
								//Changed by Rohan on 26-03-13 for define validation out of  singleLotSl validation.end
							}
							else
							{
								if( itemLotOpt.trim().equals("0") )  
								{
									//changed by sankara on 14/09/2012  to add quantity
									//sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO <> ?";
									sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE (ITEM_CODE <> ? OR LOT_NO <> ?) AND SITE_CODE = ? AND LOC_CODE = ? AND QUANTITY > 0"; 
									pstmt = conn.prepareStatement( sql );
									//changed by sankara on 14/09/2012 to set the strings in a row based on sql [Start]
								/*	pstmt.setString( 1, itemCode );
									pstmt.setString( 2, siteCode );
									pstmt.setString( 3, locCodeTo );
									pstmt.setString( 4, lotNo );   */
									pstmt.setString( 1, itemCode );
									pstmt.setString( 2, lotNo ); 
									pstmt.setString( 3, siteCode );
									pstmt.setString( 4, locCodeTo );
									//changed by sankara on 14/09/2012 to set the strings in a row based on sql [End]
									rs = pstmt.executeQuery();
									if( rs.next() )
									{
										count = rs.getInt("COUNT");
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;

									if( count > 0 )
									{
										errList.add( "VTLOCCODE2" );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
								else if( itemLotOpt.trim().equals("1") )  
								{
									//changed by sankara on 14/09/2012  to add quantity
									//sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? ";
									sql = "SELECT COUNT(*) AS COUNT FROM STOCK WHERE  ITEM_CODE <> ? AND SITE_CODE = ? AND LOC_CODE = ? AND QUANTITY > 0";
									pstmt = conn.prepareStatement( sql );
									//changed by sankara on 14/09/2012 to set the strings in a row based on sql [Start]
								/*	pstmt.setString( 1, itemCode );
									pstmt.setString( 2, siteCode );
									pstmt.setString( 3, locCodeTo );
									pstmt.setString( 4, lotNo );    */
									pstmt.setString( 1, itemCode );
									pstmt.setString( 2, siteCode );
									pstmt.setString( 3, locCodeTo );
									//changed by sankara on 14/09/2012 to set the strings in a row based on sql [Start]
									rs = pstmt.executeQuery();
									if( rs.next() )
									{
										count = rs.getInt("COUNT");
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									if( count > 0 )
									{
										errList.add( "VTLOCCODE4" );
										errFields.add( childNodeName.toLowerCase() );
									}	
								} 
							}
							//Changed by Rohan on 26-03-13 for define validation out of  singleLotSl validation.start
							System.out.println("singleLotSl:::["+singleLotSl+"itemLotOpt::["+itemLotOpt+"]");
							if( singleLotSl.trim().equalsIgnoreCase("Y") || !itemLotOpt.trim().equals("2")  )
							{	
								locCodeNodeList = allFormDataDom.getElementsByTagName("Detail4");
								noOfLocCode = locCodeNodeList.getLength();
								if(noOfLocCode > 1)
								{	
									for( int idx = 0; idx < noOfLocCode; idx++ )
									{
										if ( locCodeNodeList.item( idx ).getFirstChild() != null )
										{
											currentLoction = GenericUtility.getInstance().getColumnValueFromNode("loc_code__to",locCodeNodeList.item(idx)).trim();
											itemCode1 = GenericUtility.getInstance().getColumnValueFromNode("item_code",locCodeNodeList.item(idx)).trim();
											lotNo1 = GenericUtility.getInstance().getColumnValueFromNode("lot_no",locCodeNodeList.item(idx)).trim();
											System.out.println("Current location["+currentLoction+"itemCode1"+itemCode1+"lotNo1"+lotNo1);
											//Chnaged by Rohan on 29-05-13 for bug fixing.start
											if(singleLotSl.trim().equalsIgnoreCase("Y"))
											{		
												if(!locCodeList.containsKey(currentLoction))
												{
													locCodeList.put(currentLoction,"ACTLOC");
												}
												else
												{
													errList.add( "DUPLOCCODE" );
													errFields.add( childNodeName.toLowerCase() );
												}
										    }
											//Chnaged by Rohan on 29-05-13 for bug fixing.start
											else if(itemLotOpt.trim().equalsIgnoreCase("0"))
											{
												if(!locCodeList.containsKey(currentLoction))
												{
													locCodeList.put(currentLoction,itemCode1+":"+lotNo1);
									
												}
												else
												{
													locKeyVal = locCodeList.get(currentLoction);
													temp = locKeyVal.split(":");
													if(!temp[0].trim().equalsIgnoreCase(itemCode1.trim()) || !temp[1].trim().equalsIgnoreCase(lotNo1.trim()))
													{	
														errList.add( "SNGIEMLOT" );
														errFields.add( childNodeName.toLowerCase() );
													}	
												}
											}
											else
											{
												if(!locCodeList.containsKey(currentLoction))
												{
													locCodeList.put(currentLoction,itemCode1);
												}
												else
												{
													locKeyVal = locCodeList.get(currentLoction);
													if(!locKeyVal.trim().equalsIgnoreCase(itemCode1.trim()))
													{	
														errList.add( "SGITMMULLT" );
														errFields.add( childNodeName.toLowerCase() );
													}	
												}
											}
											//Chnaged by Rohan on 29-05-13 for bug fixing.end
									     }
								     }	
							     }
							}
							//Changed by Rohan on 26-03-13 for define validation out of  singleLotSl validation.end
							sql = "SELECT RIH.CONFIRMED FROM REPL_ISS_HDR RIH, REPL_ISS_DET RID"
									+ " WHERE RIH.TRAN_ID = RID.TRAN_ID AND RID.ITEM_CODE = ?"
									+ " AND RID.SITE_CODE = ? AND RID.LOC_CODE__TO = ?"
									+ " AND RID.LOT_NO = ? AND RID.LOT_SL = ? AND RIH.TRAN_ID <> ? ";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, itemCode );
							pstmt.setString( 2, siteCode );
							pstmt.setString( 3, locCodeTo );
							pstmt.setString( 4, lotNo );
							pstmt.setString( 5, lpnNo );
							pstmt.setString( 6, tranID );
							rs = pstmt.executeQuery();	

							if( rs.next() )
							{
								confirmed = checkNull(rs.getString("CONFIRMED"));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if( confirmed.trim().equalsIgnoreCase("N") )
							{
								errList.add( "VTLOCCODE6" );
								errFields.add( childNodeName.toLowerCase() );
							}
						}
						//changed by sankara on 08/05/14 for check loc code to and suggestion loc code start.
						locCodeTo = checkNull(genericUtility.getColumnValue("loc_code__to", allFormDataDom, "4" ));
						locCodeSys = checkNull(genericUtility.getColumnValue("loc_code__sys", allFormDataDom, "4" ));
						System.out.println("dom4locCodeTo::::::"+locCodeTo);
						System.out.println("dom4locCodeSys::::::"+locCodeSys);
						if( !locCodeSys.trim().equalsIgnoreCase(locCodeTo.trim()))
						{
							errList.add( "VTSYSLOCCD" );
							errFields.add( childNodeName.toLowerCase() );
						}
						//changed by sankara on 08/05/14  check loc code to and suggestion loc code end.
					}
				}
			}
			//Ended By Mahesh Patidar
			}//End of switch statement
			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = (String)errList.get(cnt);
					errFldName = (String)errFields.get(cnt);
					System.out.println("errCode .........."+errCode);
					//String errMsg = hashMap.get(errCode)!=null ? hashMap.get(errCode).toString():"";
					//System.out.println("errMsg .........."+errMsg);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString;//+"<trace>"+errMsg+"</trace>";
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;

				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();
		}
		catch ( Exception e )
		{
			System.out.println ( "Exception: ReplIssIC: wfValData( Document currFormDataDom ): " + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
					rs.close();
					rs = null;
				}				
				if (pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null  )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception : ReplIssIC:wfValData : " + e.getMessage() );
				throw new ITMException(e);
			}
		}
		return errString;
	}
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";

			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	/**
	 * The public method is defined without any parameters and returns blank string
	 */
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	/**
	 * The public method is used for converting the current form data into a document(dom)
	 * The dom is then given as argument to the overloaded function wfValData to perform validation
	 * Returns validation string if exists else returns null in XML format
	 * @param xmlString contains the current form data in XML format
	 * @param xmlString1 contains all the header information in the XML format
	 * @param xmlString2 contains the data of all the forms in XML format
	 * @param objContext represents the form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currFormDataDom = null;
		Document hdrDataDom = null;
		Document allFormDataDom = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1 ["+xmlString1+"]");
		System.out.println("xmlString2 ["+xmlString2+"]");
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				currFormDataDom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				hdrDataDom = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				allFormDataDom = genericUtility.parseString(xmlString2); 
			}
			System.out.println ( "Calling  itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams )");
			errString = itemChanged( currFormDataDom, hdrDataDom, allFormDataDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :ReplIssIC :itemChanged(String,String):" + e.getMessage() + ":" );
			throw new ITMException(e);
		}
		System.out.println ( "returning from ReplIssIC itemChanged \n[" + errString + "]" );

		return errString;
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currFormDataDom contains the current form data as a document object model
	 * @param hdrDataDom contains all the header information
	 * @param allFormDataDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 */
	public String itemChanged( Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String currentColumn,String editFlag, String xtraParams ) throws RemoteException,ITMException
	{		
		String retString = "";		
		String columnValue = "";
		String siteCode = "";
		String itemCode = "";
		String locCode = "";
		String lotNo = "";
		String lpnNo = "";
		String confirmed = "";
		String currDate = "";		
		String replOrder = "";
		String siteDescr = "";
		String sql = "";
		String ordLineNos = "",locCodeto = "";
		String tranID = "";
		String locCodeSys = "";
		String pickType = "";
		String disparmVal = "";
		String varName = "";
		String suggLocCode = "";
		String stockSql = "";		 
		String lotSl = "",lotSlNew = "";//Changed by sumit on 07/02/13
		ArrayList sugstLocList = null;

		int currentFormNo = 0;
		int lineNoOrd = 0;
		int domID = 0;
		int locListSize = 0;
		int count = 0;

		double quantity = 0;
		double noArt = 0;

		Connection conn = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;//added by sumit on 20/02/13 
		PreparedStatement pstmtStock = null;
		ResultSet rs = null ;
		ResultSet rs1 = null ; //added by sumit on 20/02/13
		ResultSet rsStock = null ;
		NodeList parentNodeList = null;
		Node parentNode = null;
		int parentNodeListLength = 0;
		int ctr = 0, issLineNo = 0;
		StringBuffer valueXmlString;
		String objName = "",tranId = "",singleLotSl = "";
		//Changed By Pragyan 26/11/12 To set the last used Inventory for scaning.start
		String casePickInv = "",activePickInv = "",invReserve = "",invDeepReserve = "", invPndReserve = "", partialResrvLoc = "";
		String replOrderChkInv = "";
		String replOrderChk = "";
		//Changed By Pragyan 26/11/12 To set the last used Inventory for scaning.end
		String replLine = "";// changed by sumit on 20/02/13
		System.out.println("xtraParams=["+xtraParams+"]");
		String objNameChk = "";
		DistCommon distComm = new DistCommon();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		//changed by sankara on 18/11/13 for repl order set itm default
		String assignTo = "";
		String invstat = "";
		

		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String dbDateFormat = genericUtility.getDBDateFormat();
			String applDateFormat = genericUtility.getApplDateFormat();

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );			
			columnValue = genericUtility.getColumnValue( currentColumn, currFormDataDom );
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			
			
			casePickInv  = distComm.getDisparams("999999","CASE_PICK_INVSTAT",conn);
			activePickInv  = distComm.getDisparams("999999","ACTIVE_PICK_INVSTAT",conn);
			invReserve  = distComm.getDisparams("999999","RESERV_LOCATION",conn);
			invDeepReserve = distComm.getDisparams("999999","DEEP_STORE_INVSTAT",conn);
			invPndReserve = distComm.getDisparams("999999","PND_INVSTAT",conn);
			partialResrvLoc = distComm.getDisparams("999999","PRSRV_INVSTAT",conn);
			
			System.out.println("current form no["+currentFormNo+"]");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );
			valueXmlString.append("</editFlag>\r\n</Header>\r\n");
			switch ( currentFormNo )  // Switch statement for performing item change on detail forms
			{	
			case 1:
			{
				valueXmlString.append( "<Detail1 domID='1'>\r\n" );

				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					//Changed By Pragyan 26/11/12 To set the last used Inventory for scaning.start
					String loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
					
					System.out.println("MAP_USER_STR_VAL----["+USER_DEFINED_VALUE_MAP.toString()+"]");
					
					if(USER_DEFINED_VALUE_MAP.containsKey(loginCode))
					{
						System.out.println("USER_DEFINED_VALUE_MAP---- Inside["+USER_DEFINED_VALUE_MAP.toString()+"]");
						replOrderChkInv = (String)USER_DEFINED_VALUE_MAP.get(loginCode);
						objNameChk = getObjNameFromDom(currFormDataDom, "objName", objContext);
						System.out.println("objNameChk["+objNameChk+"]");
						System.out.println("replOrderChkInv["+replOrderChkInv+"]");
						if("repl_iss".equalsIgnoreCase(objNameChk))
						{
						
							//changed by sankara on 18/11/13 for rep order set itm default
							//sql =" SELECT REPL_ORDER,LOC_CODE FROM (SELECT  DISTINCT R.REPL_ORDER ,L.LOC_CODE" +
							 sql =" SELECT REPL_ORDER,LOC_CODE,ASSIGN_TO FROM (SELECT  DISTINCT R.REPL_ORDER ,L.LOC_CODE,H.ASSIGN_TO" +
								 " FROM REPL_ORD_DET R,REPL_ORD_HDR H,WAVE_TASK_DET W,LOCATION L,WAVE_TASK WH" +
								 " WHERE W.WAVE_ID = WH.WAVE_ID AND R.REPL_ORDER = H.REPL_ORDER AND" +
								 //Changed By Pragyan 01/03/13 To check the repl order cancel flag
								 " CASE WHEN R.CANCEL_MODE IS NULL THEN 'N' ELSE R.CANCEL_MODE END <> 'Y' AND " +
								 " R.REPL_ORDER = W.REF_ID AND W.STATUS = 'N' AND H.ORDER_TYPE NOT IN ('E','Q','T','P','I') " +
								//Changed by sankara on 18/11/13 for rep order set itm default
								 //" AND FN_VALID_REPL(H.REPL_ORDER) = 'Y' AND R.LOC_CODE = L.LOC_CODE  AND L.INV_STAT = ? AND FN_CHECK_REPL_ORD_USER(H.REPL_ORDER,?) = 1) ORDER BY LOC_CODE";
								//Changed by sankara on 28/11/13 for rep order set itm default start.
								/* " AND FN_VALID_REPL(H.REPL_ORDER) = 'Y' AND R.LOC_CODE = L.LOC_CODE  AND L.INV_STAT = ? AND H.ASSIGN_TO = ? " +
								   " AND FN_CHECK_REPL_ORD_USER(H.REPL_ORDER,?) = 1) ORDER BY REPL_ORDER, LOC_CODE ";   */
								" AND FN_VALID_REPL(H.REPL_ORDER) = 'Y' AND R.LOC_CODE = L.LOC_CODE  AND L.INV_STAT = ? AND (H.ASSIGN_TO = ? OR H.ASSIGN_TO IS NULL) " +
							    " AND FN_CHECK_REPL_ORD_USER(H.REPL_ORDER,?) = 1) ORDER BY ASSIGN_TO,REPL_ORDER,LOC_CODE ";
						}
						else if("active_repl_iss".equalsIgnoreCase(objNameChk))
						{
							//changed by sankara on 18/11/13 for rep order set itm default
							//sql = " SELECT REPL_ORDER,LOC_CODE FROM (SELECT DISTINCT R.REPL_ORDER ,L.LOC_CODE FROM REPL_ORD_DET R,REPL_ORD_HDR H," +
							  sql = " SELECT REPL_ORDER,LOC_CODE,ASSIGN_TO FROM (SELECT DISTINCT R.REPL_ORDER ,L.LOC_CODE,H.ASSIGN_TO FROM REPL_ORD_DET R,REPL_ORD_HDR H," +
								  " WAVE_TASK_DET W,LOCATION L ,WAVE_TASK WH WHERE W.WAVE_ID = WH.WAVE_ID AND R.REPL_ORDER = H.REPL_ORDER AND " +
								  //Changed By Pragyan 01/03/13 To check the repl order cancel flag
								  " CASE WHEN R.CANCEL_MODE IS NULL THEN 'N' ELSE R.CANCEL_MODE END <> 'Y' " +
								  " AND R.REPL_ORDER = W.REF_ID AND W.STATUS = 'N' AND H.ORDER_TYPE IN ('E','Q','T','P','I') " +
								 //changed by sankara on 18/11/13 for rep order set itm default
								 // "AND FN_VALID_REPL(H.REPL_ORDER) = 'Y' AND R.LOC_CODE = L.LOC_CODE  AND L.INV_STAT = ? AND FN_CHECK_REPL_ORD_USER(H.REPL_ORDER,?) = 1) ORDER BY LOC_CODE ";
								//changed by sankara on 28/11/13 for rep order set itm default start.
								/*" AND FN_VALID_REPL(H.REPL_ORDER) = 'Y' AND R.LOC_CODE = L.LOC_CODE  AND L.INV_STAT = ? AND H.ASSIGN_TO = ? " +
								  " AND FN_CHECK_REPL_ORD_USER(H.REPL_ORDER,?) = 1) ORDER BY REPL_ORDER, LOC_CODE ";   */
								  " AND FN_VALID_REPL(H.REPL_ORDER) = 'Y' AND R.LOC_CODE = L.LOC_CODE  AND L.INV_STAT = ? AND (H.ASSIGN_TO = ? OR H.ASSIGN_TO IS NULL) " +
								  " AND FN_CHECK_REPL_ORD_USER(H.REPL_ORDER,?) = 1) ORDER BY ASSIGN_TO,REPL_ORDER,LOC_CODE ";
						}
						System.out.println("CURRENT SQL["+sql+"]");
						
						pstmt = conn.prepareStatement( sql );
						//changed by sankara on 18/11/13 for rep order set itm default start.
						//pstmt.setString( 1, replOrderChkInv );		
						//pstmt.setString( 2, loginCode );
						pstmt.setString( 1, replOrderChkInv );		
						pstmt.setString( 2, loginCode );				
						pstmt.setString( 3, loginCode );
						//Changed by sankara on 18/11/13 for rep order set itm default end.
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							replOrderChk = rs.getString("REPL_ORDER");
							//changed by sankara on 18/11/13 for rep order set itm default
							assignTo = checkNull(rs.getString("ASSIGN_TO"));
							System.out.println("assignTo--->:"+assignTo);
						}
						if(rs != null )
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(replOrderChk == null || replOrderChk.length() <= 0)
						{
							System.out.println("RETURNING MESSAGES AND REMOVE THE KEY FOR THAT USER["+loginCode+"]");
							USER_DEFINED_VALUE_MAP.remove(loginCode);
							//Changed By Pragyan To send the Fatal Error.
							return itmDBAccessEJB.getErrorString("","RECONEXIST","","",conn);
						}
						//changed by sankara on 18/11/13 for rep order set itm default start.
						//valueXmlString.append( "<repl_order><![CDATA[" ).append( checkNull( replOrderChk )).append( "]]></repl_order>\r\n" );
						 //changed by sankara on 28/11/13 for rep order set itm default start.
						/*if(assignTo !=null && assignTo.trim().length() > 0 )
						{
							valueXmlString.append( "<repl_order><![CDATA[" ).append( checkNull( replOrderChk )).append( "]]></repl_order>\r\n" );
						}   */
						if(assignTo != null && assignTo.trim().length() > 0 && replOrderChk != null && replOrderChk.trim().length() > 0  )
						{
							System.out.println("assign_to is not null");
							valueXmlString.append( "<repl_order><![CDATA[" ).append( checkNull( replOrderChk )).append( "]]></repl_order>\r\n" );
						}
					   if((assignTo == null || assignTo.trim().length() <= 0)  && replOrderChk != null && replOrderChk.trim().length() > 0  )
					   {
						   System.out.println("repl order mismatch");
						   valueXmlString.append( "<repl_order><![CDATA[" ).append( checkNull( replOrderChk )).append( "]]></repl_order>\r\n" );
					   }
					 //changed by sankara on 28/11/13 for rep order set itm default end.
					//changed by sankara on 18/11/13 for rep order set itm default end.
					}
					//Changed By Pragyan 26/11/12 To set the last used Inventory for scaning.end
					//changed by sankara on 18/11/13 for rep order set itm default start.
					else
					{   
						System.out.println("INSIDEELSE::::::::::::");
						objNameChk = getObjNameFromDom(currFormDataDom, "objName", objContext);
						System.out.println("objNameChk:"+objNameChk);
						if("repl_iss".equalsIgnoreCase(objNameChk))
						{
							sql =   " SELECT REPL_ORDER,LOC_CODE,INV_STAT,ASSIGN_TO FROM (SELECT  DISTINCT R.REPL_ORDER ,L.LOC_CODE,L.INV_STAT,H.ASSIGN_TO" +
									" FROM REPL_ORD_DET R,REPL_ORD_HDR H,WAVE_TASK_DET W,LOCATION L,WAVE_TASK WH" +
									" WHERE W.WAVE_ID = WH.WAVE_ID AND R.REPL_ORDER = H.REPL_ORDER AND" +
									" CASE WHEN R.CANCEL_MODE IS NULL THEN 'N' ELSE R.CANCEL_MODE END <> 'Y' AND " +
									" R.REPL_ORDER = W.REF_ID AND W.STATUS = 'N' AND H.ORDER_TYPE NOT IN ('E','Q','T','P','I') " +
									//changed by sankara on 28-11-13 for set repl order itm default start.
									/*" AND FN_VALID_REPL(H.REPL_ORDER) = 'Y' AND R.LOC_CODE = L.LOC_CODE AND H.ASSIGN_TO = ? AND FN_CHECK_REPL_ORD_USER(H.REPL_ORDER,?) = 1) "+
									" ORDER BY REPL_ORDER,ASSIGN_TO,LOC_CODE ";*/
									" AND FN_VALID_REPL(H.REPL_ORDER) = 'Y' AND R.LOC_CODE = L.LOC_CODE  AND (H.ASSIGN_TO = ? OR H.ASSIGN_TO IS NULL)  AND FN_CHECK_REPL_ORD_USER(H.REPL_ORDER,?) = 1) "+
									" ORDER BY ASSIGN_TO,REPL_ORDER,LOC_CODE ";
							       //changed by sankara on 28-11-13 for set repl order itm default end.
						}
						else if("active_repl_iss".equalsIgnoreCase(objNameChk))
						{

							sql =   " SELECT REPL_ORDER,LOC_CODE,INV_STAT,ASSIGN_TO FROM (SELECT  DISTINCT R.REPL_ORDER,L.LOC_CODE,L.INV_STAT,H.ASSIGN_TO" +
									" FROM REPL_ORD_DET R,REPL_ORD_HDR H, WAVE_TASK_DET W,LOCATION L ,WAVE_TASK WH" +
									" WHERE W.WAVE_ID = WH.WAVE_ID AND R.REPL_ORDER = H.REPL_ORDER AND " +  
									" CASE WHEN R.CANCEL_MODE IS NULL THEN 'N' ELSE R.CANCEL_MODE END <> 'Y' " +
									" AND R.REPL_ORDER = W.REF_ID AND W.STATUS = 'N' AND H.ORDER_TYPE IN ('E','Q','T','P','I') " +
									//changed by sankara on 28-11-13 for set repl order itm default start.
									/*" AND FN_VALID_REPL(H.REPL_ORDER) = 'Y' AND R.LOC_CODE = L.LOC_CODE AND H.ASSIGN_TO = ? AND FN_CHECK_REPL_ORD_USER(H.REPL_ORDER,?) = 1) "+
									" ORDER BY REPL_ORDER,ASSIGN_TO,LOC_CODE ";*/
									" AND FN_VALID_REPL(H.REPL_ORDER) = 'Y' AND R.LOC_CODE = L.LOC_CODE AND (H.ASSIGN_TO = ? OR H.ASSIGN_TO IS NULL) AND FN_CHECK_REPL_ORD_USER(H.REPL_ORDER,?) = 1) "+
									" ORDER BY ASSIGN_TO,REPL_ORDER,LOC_CODE ";
							       //changed by sankara on 28-11-13 for set repl order itm default end.
						}					
						System.out.println("CURRENT SQL["+sql+"]");						
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, loginCode );
						pstmt.setString( 2, loginCode );
						rs = pstmt.executeQuery();	
						if( rs.next() )
						{
							replOrderChk = rs.getString("REPL_ORDER");
							System.out.println("replOrderChk:"+replOrderChk);
							invstat =  checkNull( rs.getString("INV_STAT")); 
							System.out.println("invstat:"+invstat);
							assignTo = checkNull( rs.getString("ASSIGN_TO"));
							System.out.println("assignTo:"+assignTo);					
						}
						if(rs != null )
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						//changed by sankara on 28-11-13 for set repl order itm default
						//if(assignTo != null && assignTo.trim().length() > 0 )
						if(assignTo != null && assignTo.trim().length() > 0 && replOrderChk != null && replOrderChk.trim().length() > 0  )
						{
							valueXmlString.append( "<repl_order><![CDATA[" ).append( checkNull( replOrderChk )).append( "]]></repl_order>\r\n" );
							USER_DEFINED_VALUE_MAP.put(loginCode, invstat);
							System.out.println("USER_DEFINED_VALUE_MAP->"+USER_DEFINED_VALUE_MAP);
						}	 
					}
					//changed by sankara on 18/11/13 for rep order set itm default end.
					//valueXmlString.append( "<trans_mode><![CDATA[" ).append( "E" ).append( "]]></trans_mode>\r\n" );
					System.out.println("CHanges by rohan");
					siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
					System.out.println("CHanges by rohan"+siteCode);
					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, siteCode );						
					rs = pstmt.executeQuery();	
					if( rs.next() )
					{
						siteDescr = rs.getString("DESCR");
					}
					valueXmlString.append( "<descr><![CDATA[" ).append( checkNull( siteDescr )).append( "]]></descr>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[" ).append( checkNull( loginCode )).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<site_code><![CDATA[" ).append( checkNull( siteCode )).append( "]]></site_code>\r\n" );
					if(rs != null )
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				valueXmlString.append("</Detail1>\r\n");
			} //Case 1. End
			break;
			case 2:  //Case 1. Start
			{
				System.out.println("inside case 1 itemchange");
				//valueXmlString.append( "<Detail1 domID='1'>\r\n" );

				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					String loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));
					String chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" ));
					siteCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" ));
					replOrder = genericUtility.getColumnValue( "repl_order", hdrDataDom );
					//Changed By Pragyan 15-sep-12 To add Carton No 
					String cartonNo = "";//checkNull(genericUtility.getColumnValue( "carton_no", hdrDataDom ));
				
				
					System.out.println("siteCode from xtraParams = ["+siteCode+"]");
					System.out.println("Carton No To scan = ["+cartonNo+"]");
					
					if ( siteCode.trim().length() == 0 || "INVALID_SITE".equalsIgnoreCase(siteCode.trim()) )
					{
						siteCode = getSiteCode( xtraParams, conn );
					}
					System.out.println("siteCode = ["+siteCode+"]");
					//valueXmlString.append( "<site_code><![CDATA[" ).append( checkNull( siteCode )).append( "]]></site_code>\r\n" );


					java.sql.Date tranDateDb = null;

					sql = "select tran_id,tran_date,site_code,confirmed from  repl_iss_hdr where repl_order = ? ";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, replOrder );
					rs = pstmt.executeQuery();
					if ( rs.next() )
					{
						tranId = checkNull(rs.getString("tran_id"));
						tranDateDb = rs.getDate("tran_date");
						siteCode = checkNull(rs.getString("site_code"));
						confirmed = checkNull(rs.getString("confirmed"));
						//valueXmlString.append("<Detail2 domID='1' selected=\"Y\">\r\n");
						//valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n"); //added by Kunal on 30/08/12
						//valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull( tranId )).append( "]]></tran_id>\r\n" );
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					//  04/10/12 manoharan
					if( confirmed == null || confirmed.equals("") || confirmed.trim().length() == 0 )
					{
						confirmed = "N";
					}
					if ( tranId == null || tranId.trim().length() == 0 || "Y".equalsIgnoreCase(confirmed) ) // 04/10/12 manoharan 
					{
						tranId = genericUtility.getColumnValue( "tran_id", currFormDataDom );
						valueXmlString.append("<Detail2 domID='1' selected=\"N\">\r\n");
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n"); //added by Kunal on 30/08/12
						valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull( tranId )).append( "]]></tran_id>\r\n" );
					}
					else if (tranId != null && tranId.trim().length() > 0 && "N".equalsIgnoreCase(confirmed) ) // else condition added for edit mode
					{
						//tranId = genericUtility.getColumnValue( "tran_id", currFormDataDom );
						valueXmlString.append("<Detail2 domID='1' selected=\"Y\">\r\n");
						valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n");
						valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull( tranId )).append( "]]></tran_id>\r\n" );
					}
					//  end 04/10/12 manoharan


					//if( confirmed.equals("") || confirmed.trim().length() == 0 )
					//{
					//	confirmed = "N";
					//}
					valueXmlString.append( "<confirmed><![CDATA[" ).append( checkNull( confirmed )).append( "]]></confirmed>\r\n" );

					if ( tranDateDb != null )
					{
						currDate = genericUtility.getValidDateString( tranDateDb.toString() , dbDateFormat, applDateFormat );
					}
					else
					{
						java.util.Date date = new java.util.Date();
						currDate = dtFormat.format( date );
					}
					sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, siteCode );						
					rs = pstmt.executeQuery();	
					if( rs.next() )
					{
						siteDescr = rs.getString("DESCR");
					}
					valueXmlString.append( "<descr><![CDATA[" ).append( checkNull( siteDescr )).append( "]]></descr>\r\n" );
					valueXmlString.append( "<site_code><![CDATA[" ).append( checkNull( siteCode )).append( "]]></site_code>\r\n" );
					valueXmlString.append( "<tran_date><![CDATA[" ).append( checkNull( currDate )).append( "]]></tran_date>\r\n" );						
					valueXmlString.append( "<repl_order><![CDATA[" ).append( checkNull( replOrder )).append( "]]></repl_order>\r\n" );
					valueXmlString.append( "<chg_user><![CDATA[" ).append( loginCode ).append( "]]></chg_user>\r\n" );
					valueXmlString.append( "<chg_date><![CDATA[" ).append( currDate ).append( "]]></chg_date>\r\n" );
					valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );

					//changes added by gulzar on 01/12/11 - to include order type of replenishment order
					String orderType = "";
					sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR WHERE REPL_ORDER = ? ";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, replOrder );
					rs = pstmt.executeQuery();
					if ( rs.next() )
					{
						orderType = checkNull(rs.getString("ORDER_TYPE"));
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					
					//Changed By Pragyan 26/11/12 To set the last used Inventory for scaning.start
					if("H".equalsIgnoreCase(orderType) || "E".equalsIgnoreCase(orderType) || "F".equalsIgnoreCase(orderType) || "G".equalsIgnoreCase(orderType))
					{
							USER_DEFINED_VALUE_MAP.put(loginCode, invDeepReserve);
							System.out.println("USER_DEFINED_VALUE_MAP----set 1loginCode["+loginCode+"]invDeepReserve"+invDeepReserve);
					}
					else if("L".equalsIgnoreCase(orderType) || "N".equalsIgnoreCase(orderType) || "J".equalsIgnoreCase(orderType) || "K".equalsIgnoreCase(orderType) || "I".equalsIgnoreCase(orderType))
					{
						    USER_DEFINED_VALUE_MAP.put(loginCode, invPndReserve);
						    System.out.println("USER_DEFINED_VALUE_MAP----set 2loginCode["+loginCode+"]invDeepReserve"+invDeepReserve);
					}
					else if("D".equalsIgnoreCase(orderType) || "C".equalsIgnoreCase(orderType) || "M".equalsIgnoreCase(orderType) || "P".equalsIgnoreCase(orderType))
					{
						    USER_DEFINED_VALUE_MAP.put(loginCode, invReserve);
						    System.out.println("USER_DEFINED_VALUE_MAP----set 3loginCode["+loginCode+"]invDeepReserve"+invReserve);
					}
					else if("Q".equalsIgnoreCase(orderType))
					{
						  USER_DEFINED_VALUE_MAP.put(loginCode, casePickInv);
						  System.out.println("USER_DEFINED_VALUE_MAP----set 3loginCode["+loginCode+"]invDeepReserve"+casePickInv);
					}	
					else if("T".equalsIgnoreCase(orderType))
					{
						    USER_DEFINED_VALUE_MAP.put(loginCode, partialResrvLoc);
						    System.out.println("USER_DEFINED_VALUE_MAP----set 4loginCode["+loginCode+"]invDeepReserve"+invDeepReserve);
					}
					//Changed By Pragyan 26/11/12 To set the last used Inventory for scaning.end
										
					//Changed by Rohan on 18-09-12 to select carton no.start
					sql = "SELECT CARTON_NO FROM CARTON_MASTER WHERE PICK_ORDER = ?";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, replOrder );
					rs = pstmt.executeQuery();
					if ( rs.next() )
					{
						cartonNo = checkNull(rs.getString("CARTON_NO"));
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					//Changed by Rohan on 18-09-12 to select carton no.end
					
					valueXmlString.append( "<order_type><![CDATA[" ).append( orderType ).append( "]]></order_type>\r\n" );
					//Changed By Pragyan 15-sep-12 To add Carton No 
					valueXmlString.append( "<carton_no><![CDATA[" ).append( cartonNo ).append( "]]></carton_no>\r\n" ); 
//					Changed By Dhanraj 11-JUL-14 To add Carton No org. 
					valueXmlString.append( "<carton_no_org><![CDATA[" ).append( cartonNo ).append( "]]></carton_no_org>\r\n" );
					//End changes by gulzar on 01/12/11
				}
				valueXmlString.append("</Detail2>\r\n");
				
				System.out.println("manoharan 04/10/12 valueXmlString [" + valueXmlString.toString() + "]");
			} //Case 1. End
			break;
			case 3:  //Case 2. Start
			{
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					replOrder = checkNull(genericUtility.getColumnValue( "repl_order", hdrDataDom ));
					tranID = checkNull(genericUtility.getColumnValue( "tran_id", hdrDataDom ));
					if ( tranID.trim().length() == 0 )
					{
						String replIssID = "";
						sql = "SELECT TRAN_ID FROM REPL_ISS_HDR WHERE REPL_ORDER = ? ";
						pstmt = conn.prepareStatement( sql );
						pstmt.setString( 1, replOrder );
						rs = pstmt.executeQuery();
						if ( rs.next() )
						{
							replIssID = checkNull(rs.getString("TRAN_ID"));
						}
						rs.close(); rs = null;
						pstmt.close(); pstmt = null;
						if ( replIssID.trim().length() > 0 )
						{
							tranID = replIssID;
							//Changed by sumit on 21/02/13 commenting no need of this code,  getting dom id by normal increment start
							/*sql = "SELECT MAX(LINE_NO) FROM REPL_ISS_DET WHERE TRAN_ID = ? ";

							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, tranID );
							rs = pstmt.executeQuery();
							if ( rs.next() )
							{
								domID = rs.getInt(1);
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;*/
							//Changed by sumit on 21/02/13 commenting no need of this code,  getting dom id by normal increment end
						}
					}

					//added by chitranjan to get location code ,var_name ,pick_type from stock and invstat location for suggested location //23/11/11
					sugstLocList = new ArrayList();
					//Changed By Pragyan 07-APR-14 to get pick type properly.start
					//Changed by sumit on 19/02/13 modifide sql as this is wrong.
					//sql = "SELECT POD.PICK_TYPE , ROD.ITEM_CODE FROM REPL_ORD_DET ROD,PICK_ORD_HDR POD WHERE ROD.PICK_ORDER = POD.PICK_ORDER AND ROD.REPL_ORDER = ?";
					/*sql = " SELECT DISTINCT POH.PICK_TYPE , ROD.ITEM_CODE FROM REPL_ORD_DET ROD,PICK_ORD_HDR POH , PICK_ORD_DET POD " +
							" WHERE POH.PICK_ORDER = POD.PICK_ORDER AND POD.REPL_ORDER = ROD.REPL_ORDER AND ROD.REPL_ORDER = ? ";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, replOrder );
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						pickType = checkNull(rs.getString("PICK_TYPE"));
						itemCode = checkNull(rs.getString("ITEM_CODE"));//Added By Mahesh Patidar on 07/08/12
					}
					rs.close();
					pstmt.close();
					System.out.println("pick type =[" +pickType+ "]")

					if ( "A".equalsIgnoreCase(pickType.trim()) )//Active pick
					{
						varName = "ACTIVE_PICK_INVSTAT";
						objName = "active_repl_iss";
					}
					else if ( "C".equalsIgnoreCase(pickType.trim()) || "M".equalsIgnoreCase(pickType.trim()) )//Case pick & master pick
					{
						varName = "CASE_PICK_INVSTAT";
						objName = "repl_iss";
					}
					
					 */
					//Changed By Pragyan 07-APR-14 to get pick type properly.end
					//changes added by gulzar to consider for dock location - 04/12/11
					String orderType = "";
					sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR WHERE REPL_ORDER = ? ";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, replOrder );
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						orderType = checkNull(rs.getString("ORDER_TYPE"));
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
							
					//Changed By Pragyan 07-APR-14 to get pick type properly.start
					
					if ( "A".equalsIgnoreCase(orderType.trim()) || "I".equalsIgnoreCase(orderType.trim()) || "Q".equalsIgnoreCase(orderType.trim()) ||  "T".equalsIgnoreCase(orderType.trim()) ||  "E".equalsIgnoreCase(orderType.trim()))//Active pick
					{
						pickType = "A";
						objName = "active_repl_iss";
						varName = "ACTIVE_PICK_INVSTAT";
					}
					else if ( "C".equalsIgnoreCase(orderType.trim()) || "M".equalsIgnoreCase(orderType.trim()) || "J".equalsIgnoreCase(orderType.trim()) || "K".equalsIgnoreCase(orderType.trim()))//Case pick & master pick
					{
						varName = "CASE_PICK_INVSTAT";
						objName = "repl_iss";
					}
					else if("E".equalsIgnoreCase(orderType.trim()) || "F".equalsIgnoreCase(orderType.trim()) || "G".equalsIgnoreCase(orderType.trim()) ||"H".equalsIgnoreCase(orderType.trim()) )
					{
						objName = "repl_iss";
						varName = "PND_INVSTAT";
					}
					else if("L".equalsIgnoreCase(orderType.trim()) || "D".equalsIgnoreCase(orderType.trim()))
					{
						objName = "repl_iss";
						varName = "DOCKLOC_INVSTAT";
					}
							

					/*if ( "D".equalsIgnoreCase(orderType.trim()) )
					{
						varName = "DOCKLOC_INVSTAT";
					}*/
					//End changes by gulzar - 04/12/11
					
					//Changed By Pragyan 07-APR-14 to get pick type properly.end

					disparmVal = distComm.getDisparams( "999999", varName, conn );
					System.out.println(" disparmVal =[" + disparmVal + "]");

					//Commented and changes below by gulzar on 12/23/2011
					/*
						sql = "SELECT A.LOC_CODE FROM STOCK A , INVSTAT B, LOCATION C "
							+ " WHERE A.LOC_CODE = C.LOC_CODE AND C.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' "
							+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' " 
							+ " AND A.QUANTITY = 0 AND C.INV_STAT = ?  ORDER BY LOC_CODE ";

					 */
					sql = "SELECT A.LOC_CODE AS LOC_CODE,A.SINGLE_LOT_SL  FROM LOCATION A, INVSTAT B , ITEM I "
							+ " WHERE A.INV_STAT = B.INV_STAT AND B.AVAILABLE = 'Y' " 
							+ " AND I.LOC_TYPE = A.LOC_TYPE AND I.ITEM_CODE = ?"
							+ " AND (CASE WHEN B.STAT_TYPE IS NULL THEN ' ' ELSE B.STAT_TYPE END) <> 'S' "
							+ " AND A.INV_STAT = ? ORDER BY LOC_CODE ";

					double stockQty = 0d;
					stockSql = "SELECT SUM(CASE WHEN QUANTITY IS NULL THEN 0 ELSE QUANTITY END) AS STOCK_QTY "
							+  " FROM STOCK WHERE LOC_CODE = ? ";

					pstmtStock =  conn.prepareStatement(stockSql);

					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1, itemCode);
					pstmt.setString(2, disparmVal);
					rs = pstmt.executeQuery();
					while (rs.next())
					{
						suggLocCode = checkNull(rs.getString("LOC_CODE") );
						singleLotSl = checkNull(rs.getString("SINGLE_LOT_SL") );
						System.out.println("SINGLE_LOT_SL="+singleLotSl);
						System.out.println("sugg loc code = "+suggLocCode);
						pstmtStock.setString( 1, suggLocCode );
						rsStock = pstmtStock.executeQuery();
						if ( rsStock.next() )
						{
							stockQty = rsStock.getDouble("STOCK_QTY");
							System.out.println("stock qty="+stockQty);	
							if ( stockQty == 0 || "N".equalsIgnoreCase(singleLotSl.trim())) //added by Kunal on 01/09/12
							{
								System.out.println("sugg loc code add for case 1 = "+suggLocCode);
								sugstLocList.add(suggLocCode);
							}
						}
						else
						{
							System.out.println("sugg loc code add for case 2 = "+suggLocCode);
							sugstLocList.add(suggLocCode);
						}
						pstmtStock.clearParameters();
						rsStock.close(); rsStock = null;
					}
					rs.close(); rs = null;						
					pstmt.close(); pstmt = null;
					pstmtStock.close(); pstmtStock = null;

					//End changes by gulzar on 12/23/2011

					System.out.println("suggested location list...>> "+sugstLocList);
					locListSize = sugstLocList.size();
					//Added By Mahesh Patidar on 08/08/12
					if(locListSize > 0)
					{
						locCodeto = checkNull((String) sugstLocList.get(0)); 
					}
					//Ended By Mahesh Patidar 
					System.out.println("locListSize...>:::::>>> ["+locListSize+"] loc code to["+locCodeto+"]");
					//end of changes by chitranjan - 23/11/11


					//Changed by sumit on 21/02/13 changing sql for active repl_iss start
					/*sql = "SELECT RID.TRAN_ID, RID.LINE_NO, RID.REPL_ORDER, RID.LINE_NO__ORD, RID.SITE_CODE, RID.ITEM_CODE, RID.LOC_CODE, RID.LOT_NO, "+
							" RID.LOT_SL, RID.QUANTITY, RID.NO_ART, RID.LOC_CODE__TO, ITEM.DESCR ITEM_DESCR, ITEM.UNIT UNIT,RID.LOC_CODE__SYS as LOC_CODE__SYS, RID.LOT_SL__NEW"+
							" FROM REPL_ISS_DET RID, ITEM ITEM WHERE RID.TRAN_ID = ? AND RID.ITEM_CODE = ITEM.ITEM_CODE ORDER BY LINE_NO ";*/
					
					if("active_repl_iss".equalsIgnoreCase(objName))
					{
						sql = " SELECT  RID.SITE_CODE, RID.ITEM_CODE, RID.LOC_CODE, RID.LOT_NO, RID.LOT_SL, RID.LOC_CODE__TO, ITEM.DESCR AS ITEM_DESCR ," +
								" ITEM.UNIT UNIT,RID.LOC_CODE__SYS as LOC_CODE__SYS, RID.LOT_SL__NEW,  SUM(RID.QUANTITY) AS QUANTITY , SUM(RID.NO_ART) AS NO_ART " +
								" FROM REPL_ISS_DET RID, ITEM ITEM WHERE RID.TRAN_ID = ? AND RID.ITEM_CODE = ITEM.ITEM_CODE " +
								" GROUP BY RID.SITE_CODE, RID.ITEM_CODE, RID.LOC_CODE, RID.LOT_NO, RID.LOT_SL,RID.LOC_CODE__TO, ITEM.DESCR, UNIT, LOC_CODE__SYS, RID.LOT_SL__NEW ";
						
						replLine = "SELECT LINE_NO, LINE_NO__ORD FROM REPL_ISS_DET WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ?" +
								" AND LOT_SL = ? AND REPL_ORDER = ? AND TRAN_ID = ? ORDER BY LINE_NO";
						pstmt1 = conn.prepareStatement(replLine);
					}
					else
					{
						sql = "SELECT RID.TRAN_ID, RID.LINE_NO, RID.REPL_ORDER, RID.LINE_NO__ORD, RID.SITE_CODE, RID.ITEM_CODE, RID.LOC_CODE, RID.LOT_NO, "+
							" RID.LOT_SL, RID.QUANTITY, RID.NO_ART, RID.LOC_CODE__TO, ITEM.DESCR ITEM_DESCR, ITEM.UNIT UNIT,RID.LOC_CODE__SYS as LOC_CODE__SYS, RID.LOT_SL__NEW"+
							" FROM REPL_ISS_DET RID, ITEM ITEM WHERE RID.TRAN_ID = ? AND RID.ITEM_CODE = ITEM.ITEM_CODE ORDER BY LINE_NO ";
					}
					//Changed by sumit on 21/02/13 changing sql for active repl_iss end

					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, tranID );
					rs = pstmt.executeQuery();
					while ( rs.next() )
					{
						//Changed by sumit on 21/02/13 seperated line_no in case of  active_repl_iss start
						/*lineNoOrd = rs.getInt("LINE_NO__ORD");
						ordLineNos = ordLineNos + "'" + lineNoOrd + "',";
						// 04/10/12 manoharan
						issLineNo = rs.getInt("LINE_NO");*/
						if("active_repl_iss".equalsIgnoreCase(objName))
						{
							pstmt1.setString(1, rs.getString("ITEM_CODE"));
							pstmt1.setString(2, rs.getString("SITE_CODE"));
							pstmt1.setString(3, rs.getString("LOC_CODE"));
							pstmt1.setString(4, rs.getString("LOT_NO"));
							pstmt1.setString(5, rs.getString("LOT_SL"));
							pstmt1.setString(6, replOrder);
							pstmt1.setString(7, tranID);
							rs1 = pstmt1.executeQuery();
							if( rs1.next() )
							{
								lineNoOrd = rs1.getInt("LINE_NO__ORD");
								issLineNo = rs1.getInt("LINE_NO");
							}
							rs1.close();rs1 = null;
							pstmt1.clearParameters();
						}
						else
						{						
							lineNoOrd = rs.getInt("LINE_NO__ORD");
							ordLineNos = ordLineNos + "'" + lineNoOrd + "',";
							// 04/10/12 manoharan
							issLineNo = rs.getInt("LINE_NO");
						}
						//Changed by sumit on 21/02/13 seperated line_no in case of  active_repl_iss end
						
						//Changed by sumit on 21/02/13 open the commented domId and using this domId start
						//domID++;
						//valueXmlString.append( "<Detail2 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName=\"pick_iss\" selected=\"Y\">\r\n" );
						//valueXmlString.append( "<Detail3 domID='"+ issLineNo +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"Y\">\r\n" );
						domID++;
						valueXmlString.append( "<Detail3 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"Y\">\r\n" );
						//Changed by sumit on 21/02/13 open the commented domid using domId end
						valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n"); //added by Kunal on 30/08/12
						//valueXmlString.append( "<attribute selected=\"Y\"/>\r\n" );
						//Changed by sumit on 22/02/13 setting tran_id 
						//valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull(rs.getString("TRAN_ID")) ).append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<tran_id><![CDATA[" ).append( tranID ).append( "]]></tran_id>\r\n" );
						valueXmlString.append( "<line_no><![CDATA[" ).append( issLineNo ).append( "]]></line_no>\r\n" );
						//Changed by sumit on 22/02/13 using repl_order from header 
						//valueXmlString.append( "<repl_order><![CDATA[" ).append( checkNull(rs.getString("REPL_ORDER")) ).append( "]]></repl_order>\r\n" );
						valueXmlString.append( "<repl_order><![CDATA[" ).append( replOrder ).append( "]]></repl_order>\r\n" );
						valueXmlString.append( "<line_no__ord><![CDATA[" ).append( lineNoOrd ).append( "]]></line_no__ord>\r\n" );
						valueXmlString.append( "<order_type><![CDATA[" ).append( orderType ).append( "]]></order_type>\r\n" );
						valueXmlString.append( "<item_code><![CDATA[" ).append( checkNullAndTrim( rs.getString("ITEM_CODE") )).append( "]]></item_code>\r\n" );
						valueXmlString.append( "<item_descr><![CDATA[" ).append( checkNull( rs.getString("ITEM_DESCR") )).append( "]]></item_descr>\r\n" );
						valueXmlString.append( "<site_code><![CDATA[" ).append( checkNull( rs.getString("SITE_CODE") )).append( "]]></site_code>\r\n" );
						valueXmlString.append( "<loc_code><![CDATA[" ).append( checkNullAndTrim( rs.getString("LOC_CODE") ) ).append( "]]></loc_code>\r\n" );
						valueXmlString.append( "<lot_no><![CDATA[" ).append( checkNullAndTrim( rs.getString("LOT_NO") )).append( "]]></lot_no>\r\n" );
						valueXmlString.append( "<lot_sl><![CDATA[" ).append( checkNullAndTrim( rs.getString("LOT_SL") )).append( "]]></lot_sl>\r\n" );
						valueXmlString.append( "<quantity><![CDATA[" ).append( rs.getDouble("QUANTITY")).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<unit><![CDATA[" ).append( rs.getString("UNIT")).append( "]]></unit>\r\n" );
						valueXmlString.append( "<no_art><![CDATA[" ).append( rs.getDouble("NO_ART") ).append( "]]></no_art>\r\n" );
						valueXmlString.append( "<loc_code__to><![CDATA[" ).append( checkNull(rs.getString("LOC_CODE__TO")) ).append( "]]></loc_code__to>\r\n" );
						//changes made by chitranjan for suggested location code //23/11/11
						//valueXmlString.append( "<loc_code__sys><![CDATA[" ).append( rs.getString("LOC_CODE__TO") ).append( "]]></loc_code__sys>\r\n" );
						System.out.println("loc code sys="+rs.getString("LOC_CODE__SYS"));
						// 12/10/12 manoharan issue is already saved so set the lot_sl__new from issue
						valueXmlString.append( "<loc_code__sys><![CDATA[" ).append( rs.getString("LOC_CODE__SYS") ).append( "]]></loc_code__sys>\r\n" ); //change done by kunal on 01/09/12
						//							valueXmlString.append( "<loc_code__sys><![CDATA[" ).append(locCodeto ).append( "]]></loc_code__sys>\r\n" ); //Changed By Mahesh Patidar on 08/08/12
						//if ( "A".equalsIgnoreCase(pickType.trim()) )//Active pick
						//{
						//	valueXmlString.append( "<lot_sl__new><![CDATA[]]></lot_sl__new>\r\n" );
						//}
						//else
						//{
							valueXmlString.append( "<lot_sl__new><![CDATA[" ).append( checkNullAndTrim( rs.getString("LOT_SL__NEW") )).append( "]]></lot_sl__new>\r\n" );
						//}
						valueXmlString.append("</Detail3>\r\n");
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					//Changed by sumit on 21/02/13 closing statement start
					if( rs1 != null )
					{
						rs1.close(); rs1 = null;
					}
					if( pstmt1 != null )
					{
						pstmt1.close(); pstmt1 = null;
					}
					//Changed by sumit on 21/02/13 closing statement end

					if ( ordLineNos.trim().length() > 1 )
					{
						ordLineNos = ordLineNos.substring( 0, ordLineNos.length()-1 );
					}
					sql = "SELECT MAX(LINE_NO)  FROM REPL_ISS_DET WHERE TRAN_ID = ?";
					
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, tranID );
					rs = pstmt.executeQuery();

					if ( rs.next() )
					{
						domID = rs.getInt(1);
						//locCodeTo = rs.getString("LOC_CODE__TO");
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					//Changed by sumit on 20/02/13 commented and written new sql start
					/*if ( domID == 0 )
					{
						sql = "SELECT REPL_ORD_DET.LINE_NO, REPL_ORD_DET.ITEM_CODE, REPL_ORD_DET.SITE_CODE, "+
								"REPL_ORD_DET.LOC_CODE, REPL_ORD_DET.LOT_NO, REPL_ORD_DET.LOT_SL, REPL_ORD_DET.QUANTITY,"+
								"REPL_ORD_DET.NO_ART,ITEM.DESCR ITEM_DESCR,ITEM.UNIT,SITE.DESCR SITE_DESCR, REPL_ORD_DET.LOC_CODE__TO "+
								"FROM REPL_ORD_DET REPL_ORD_DET, ITEM ITEM, SITE SITE WHERE REPL_ORDER = ? "+
								//Changed by Rohan on 30-01-13 for dispaly only uncancel repanishment
								" AND CASE WHEN REPL_ORD_DET.CANCEL_MODE IS NULL THEN 'N' ELSE REPL_ORD_DET.CANCEL_MODE END <> 'Y' "+
								"AND REPL_ORD_DET.ITEM_CODE = ITEM.ITEM_CODE(+) " +
								"AND REPL_ORD_DET.SITE_CODE = SITE.SITE_CODE(+) ";
						pstmt = conn.prepareStatement( sql );
					}
					else
					{
						sql = "SELECT REPL_ORD_DET.LINE_NO, REPL_ORD_DET.ITEM_CODE, REPL_ORD_DET.SITE_CODE, "+
								"REPL_ORD_DET.LOC_CODE, REPL_ORD_DET.LOT_NO, REPL_ORD_DET.LOT_SL, REPL_ORD_DET.QUANTITY,"+
								"REPL_ORD_DET.NO_ART,ITEM.DESCR ITEM_DESCR,ITEM.UNIT,SITE.DESCR SITE_DESCR, REPL_ORD_DET.LOC_CODE__TO "+
								"FROM REPL_ORD_DET REPL_ORD_DET, ITEM ITEM, SITE SITE "+
								"WHERE REPL_ORDER = ? AND LINE_NO NOT IN("+ordLineNos+") "+
								//Changed by Rohan on 30-01-13 for dispaly only uncancel repanishment
								" AND CASE WHEN REPL_ORD_DET.CANCEL_MODE IS NULL THEN 'N' ELSE REPL_ORD_DET.CANCEL_MODE END <> 'Y' "+
								"AND REPL_ORD_DET.ITEM_CODE = ITEM.ITEM_CODE(+) " +
								"AND REPL_ORD_DET.SITE_CODE = SITE.SITE_CODE(+) ";
						pstmt = conn.prepareStatement( sql );
					}*/					
					sql = " SELECT ROD.ITEM_CODE, ROD.SITE_CODE, ROD.LOC_CODE, ROD.LOT_NO, ROD.LOT_SL, I.DESCR AS ITEM_DESCR , I.UNIT, S.DESCR AS SITE_DESCR , " +
							" ROD.LOC_CODE__TO , SUM(QUANTITY) AS QUANTITY , SUM(NO_ART) AS NO_ART  FROM REPL_ORD_DET ROD, ITEM I , SITE S " +
							" WHERE ROD.REPL_ORDER = ? AND ROD.ITEM_CODE = I.ITEM_CODE AND ROD.SITE_CODE = S.SITE_CODE " +
							" AND (ROD.REPL_ORDER, ROD.LINE_NO) NOT IN (SELECT REPL_ORDER, LINE_NO__ORD FROM REPL_ISS_DET WHERE REPL_ORDER = ? )" +
							" AND CASE WHEN ROD.CANCEL_MODE IS NULL THEN 'N' ELSE ROD.CANCEL_MODE END <> 'Y' " +
							" GROUP BY ROD.ITEM_CODE,ROD.SITE_CODE, ROD.LOC_CODE, ROD.LOT_NO, ROD.LOT_SL,  I.DESCR , I.UNIT, S.DESCR , ROD.LOC_CODE__TO " +
							//Changed by sumit on 22/05/13 ordering loc_code.
							" ORDER BY ROD.LOC_CODE ";
					pstmt = conn.prepareStatement(sql);
					
					replLine = "SELECT LINE_NO FROM REPL_ORD_DET WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ?" +
							" AND LOT_SL = ? AND REPL_ORDER = ? ORDER BY LINE_NO";
					pstmt1 = conn.prepareStatement(replLine);
					//Changed by sumit on 20/02/13 commented and written new sql end
					
					
					pstmt.setString( 1, replOrder );
					//Changed by sumit on 22/03/13 setter as per sql
					pstmt.setString( 2, replOrder );
					rs = pstmt.executeQuery();

					String itemDescr = "";
					String unit = "";
					while ( rs.next() )
					{
						//Changed by sumit on 20/02/13 commenting line no and reteriving line number from below code from repl_ord_det						
						//lineNoOrd = rs.getInt("LINE_NO");
						itemCode = rs.getString("ITEM_CODE");
						itemDescr = rs.getString("ITEM_DESCR");
						siteCode = rs.getString("SITE_CODE");
						siteDescr = rs.getString("SITE_DESCR");
						locCode = rs.getString("LOC_CODE");
						lotNo = rs.getString("LOT_NO");
						lpnNo = rs.getString("LOT_SL");
						quantity = rs.getDouble("QUANTITY");
						unit = rs.getString("UNIT");
						noArt = rs.getDouble("NO_ART");
						locCodeto = rs.getString("LOC_CODE__TO"); 

						//Changed by sumit on 20/02/13  reteriving repl line number from repl_ord_det start
						pstmt1.setString(1, itemCode);
						pstmt1.setString(2, siteCode);
						pstmt1.setString(3, locCode);
						pstmt1.setString(4, lotNo);
						pstmt1.setString(5, lpnNo);
						pstmt1.setString(6, replOrder);
						rs1 = pstmt1.executeQuery();
						if( rs1.next() )
						{
							lineNoOrd = rs1.getInt("LINE_NO");
						}
						rs1.close();rs1 = null;
						pstmt1.clearParameters();
						//Changed by sumit on 20/02/13  reteriving repl line number from repl_ord_det end 

						domID++;
						//valueXmlString.append( "<Detail2 domID='"+ domID +"' selected=\"N\">\r\n" );
						valueXmlString.append( "<Detail3 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"N\">\r\n" );
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n"); //added by Kunal on 30/08/12
						valueXmlString.append( "<tran_id/>" );
						valueXmlString.append( "<line_no/>" );
						//valueXmlString.append( "<line_no/>" );//changed by gulzar on 12/22/2011
						//Changed by sumit on 22/02/13 changing line_no
						//valueXmlString.append( "<line_no><![CDATA[" ).append( domID ).append( "]]></line_no>\r\n" );//changed by gulzar on 12/22/2011						
						//valueXmlString.append( "<line_no><![CDATA[" ).append( lineNoOrd ).append( "]]></line_no>\r\n" );
						valueXmlString.append( "<repl_order><![CDATA[" ).append( replOrder ).append( "]]></repl_order>\r\n" );
						valueXmlString.append( "<line_no__ord><![CDATA[" ).append( lineNoOrd ).append( "]]></line_no__ord>\r\n" );
						valueXmlString.append( "<order_type><![CDATA[" ).append( orderType ).append( "]]></order_type>\r\n" );
						valueXmlString.append( "<item_code><![CDATA[" ).append( checkNullAndTrim( itemCode )).append( "]]></item_code>\r\n" );
						valueXmlString.append( "<item_descr><![CDATA[" ).append( checkNull( itemDescr )).append( "]]></item_descr>\r\n" );
						valueXmlString.append( "<site_code><![CDATA[" ).append( checkNull( siteCode )).append( "]]></site_code>\r\n" );
						valueXmlString.append( "<site_descr><![CDATA[" ).append( checkNull( siteDescr )).append( "]]></site_descr>\r\n" );
						valueXmlString.append( "<loc_code><![CDATA[" ).append( checkNullAndTrim( locCode )).append( "]]></loc_code>\r\n" );
						valueXmlString.append( "<lot_no><![CDATA[" ).append( checkNullAndTrim( lotNo )).append( "]]></lot_no>\r\n" );
						valueXmlString.append( "<lot_sl><![CDATA[" ).append( checkNullAndTrim( lpnNo )).append( "]]></lot_sl>\r\n" );
						valueXmlString.append( "<quantity><![CDATA[" ).append( quantity).append( "]]></quantity>\r\n" );
						valueXmlString.append( "<unit><![CDATA[" ).append( unit).append( "]]></unit>\r\n" );
						valueXmlString.append( "<no_art><![CDATA[" ).append( noArt ).append( "]]></no_art>\r\n" );
						//added by chitranjan for insert loc_code__sys into repl_iss_det //:-23/11/11
						if (locCodeto == null || locCodeto.trim().length() == 0)
						{
							if(locListSize > 0 && count < locListSize)
							{
								System.out.println("loc_code__sys set from suggloc list");
								valueXmlString.append("<loc_code__sys><![CDATA[").append( sugstLocList.get(count)).append("]]></loc_code__sys>\r\n");

								count++;
							}
						}
						else
						{
							System.out.println("loc_code__sys set from loc_code_to");
							valueXmlString.append("<loc_code__sys><![CDATA[").append( locCodeto).append("]]></loc_code__sys>\r\n");
						}
						//valueXmlString.append("<loc_code__to><![CDATA[").append( locCodeto).append("]]></loc_code__to>\r\n");
						//valueXmlString.append( "<loc_code__to/>" );
						//Changed by sumit on 25/02/13 setting lot_sl_new in case of psrv to active( Order type "T" 
						//if ( "A".equalsIgnoreCase(pickType.trim()) )//Active pick
						//Changed by sumit on 03/04/13 adding condition for pnd to active
						//if ( "A".equalsIgnoreCase(pickType.trim()) && !"T".equalsIgnoreCase(orderType))						
						if ( ("A".equalsIgnoreCase(pickType.trim()) && !"T".equalsIgnoreCase(orderType) && !"I".equalsIgnoreCase(orderType)) ||  "E".equalsIgnoreCase(orderType) )
						{
							valueXmlString.append( "<lot_sl__new><![CDATA[]]></lot_sl__new>\r\n" );
						}
						else
						{
							valueXmlString.append( "<lot_sl__new><![CDATA[" ).append( checkNullAndTrim( lpnNo )).append( "]]></lot_sl__new>\r\n" );
						}
						valueXmlString.append("</Detail3>\r\n");
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
					
					//Changed by sumit on 20/02/13 closing prepared statement start
					if( pstmt1 != null)
					{
						pstmt1.close(); pstmt1 = null;
					}
					if( rs1 != null )
					{
						rs1.close(); rs1 = null;
					}
					//Changed by sumit on 20/02/13 closing prepared statement end

					///////////
					String updatedDetailDomStr = addSelectedRecToDom( allFormDataDom, valueXmlString.toString() );

					valueXmlString = null;
					valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );
					valueXmlString.append("</editFlag>\r\n</Header>\r\n");
					updatedDetailDomStr = updatedDetailDomStr.substring(updatedDetailDomStr.indexOf("<Root>") + "<Root>".length(), updatedDetailDomStr.indexOf("</Root>") );
					valueXmlString.append(updatedDetailDomStr);

					System.out.println("\n**************************\n");
					System.out.println("updatedDetailDomStr[1]:>>>>>>>>>>> "+updatedDetailDomStr);

					///////////

				}//itm_detault

			}  //Case 2. End
			break;
			//Added By Mahesh Patidar on 31/07/12
			case 4: 
			{
				//Changed by sumit on 26/03/13 create new variable for dom id
				int newInt = 0;
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )
				{
					parentNodeList = allFormDataDom.getElementsByTagName("Detail3");
					parentNodeListLength = parentNodeList.getLength();

					for(ctr = 0; ctr < parentNodeListLength ; ctr++ )
					{
						System.out.println("TEST LENGTH="+parentNodeListLength);
						parentNode = parentNodeList.item(ctr);
						Element  parentNode1 = (Element)parentNodeList.item(ctr);
						//String selected = parentNode1.getAttribute("selected");//change by Kunal on 31/08/12
						
						String selected = getAttribValue(parentNode, "attribute", "selected");
						System.out.println("status ="+getAttribValue(parentNode, "attribute", "status"));
						//String selected = parentNode.getFirstChild().getAttributes().getNamedItem("selected").getNodeValue();
						System.out.println("value of selected the detail["+selected+"]");
						if("Y".equalsIgnoreCase(selected))
						{
							
							newInt++; //Changed by sumit on 26/02/13 increament domID here
							tranId = genericUtility.getColumnValueFromNode("tran_id", parentNode) ;
							int lineNo = Integer.parseInt(genericUtility.getColumnValueFromNode("line_no", parentNode).trim());
							
							/*sql = "SELECT COUNT(1) FROM REPL_ISS_DET WHERE TRAN_ID = ? AND LINE_NO = ?  ";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, tranId );
							pstmt.setInt( 2, lineNo );
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								valueXmlString.append( "<Detail4 domID='"+(lineNo)+"' selected=\"Y\">\r\n" ); //commet by kunal 03/09/12 
								valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n"); //added by Kunal on 03/09/12
								valueXmlString.append( "<tran_id><![CDATA[" ).append( tranId ).append( "]]></tran_id>\r\n" );
								valueXmlString.append( "<loc_code__sys><![CDATA[" ).append(checkNullAndTrim(genericUtility.getColumnValueFromNode("loc_code__sys", parentNode))).append( "]]></loc_code__sys>\r\n" );
								valueXmlString.append( "<loc_code__to><![CDATA[" ).append(checkNullAndTrim(genericUtility.getColumnValueFromNode("loc_code__to", parentNode))).append( "]]></loc_code__to>\r\n" );
							}
							else
							{
								valueXmlString.append( "<Detail4 domID='"+(ctr+1)+"'>\r\n" );
								valueXmlString.append( "<tran_id/>" );
								valueXmlString.append( "<loc_code__sys><![CDATA[" ).append(checkNullAndTrim(genericUtility.getColumnValueFromNode("loc_code__sys", parentNode))).append( "]]></loc_code__sys>\r\n" );
								valueXmlString.append( "<loc_code__to><![CDATA[]]></loc_code__to>\r\n" );
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							*/
							
							//Changed by sumit on 07/02/13 getting all required value from 3rd detail and display selected and unselected record start
							/*valueXmlString.append( "<Detail4 domID='"+(ctr+1)+"'>\r\n" );
							valueXmlString.append( "<tran_id/>" );
							valueXmlString.append( "<loc_code__sys><![CDATA[" ).append(checkNullAndTrim(genericUtility.getColumnValueFromNode("loc_code__sys", parentNode))).append( "]]></loc_code__sys>\r\n" );
							valueXmlString.append( "<loc_code__to><![CDATA[]]></loc_code__to>\r\n" );
							valueXmlString.append( "<line_no><![CDATA[" ).append( lineNo ).append( "]]></line_no>\r\n" );//changed by gulzar on 12/22/2011
							valueXmlString.append( "<item_code><![CDATA[" ).append( genericUtility.getColumnValueFromNode("item_code", parentNode)).append( "]]></item_code>\r\n" );
							valueXmlString.append( "<item_descr><![CDATA[" ).append( genericUtility.getColumnValueFromNode("item_descr", parentNode)).append( "]]></item_descr>\r\n" );
							valueXmlString.append( "<site_code><![CDATA[" ).append( genericUtility.getColumnValueFromNode("site_code", parentNode)).append( "]]></site_code>\r\n" );
							valueXmlString.append( "<site_descr><![CDATA[" ).append( genericUtility.getColumnValueFromNode("site_descr", parentNode)).append( "]]></site_descr>\r\n" );
							valueXmlString.append( "<loc_code><![CDATA[" ).append( genericUtility.getColumnValueFromNode("loc_code", parentNode)).append( "]]></loc_code>\r\n" );
							valueXmlString.append( "<lot_no><![CDATA[" ).append( genericUtility.getColumnValueFromNode("lot_no", parentNode)).append( "]]></lot_no>\r\n" );
							valueXmlString.append( "<lot_sl><![CDATA[" ).append( genericUtility.getColumnValueFromNode("lot_sl", parentNode)).append( "]]></lot_sl>\r\n" );
							
							// 13/09/12 manoharan new lpn number to be matched
							valueXmlString.append( "<lot_sl__new><![CDATA[" ).append(checkNullAndTrim( genericUtility.getColumnValueFromNode("lot_sl__new", parentNode))).append( "]]></lot_sl__new>\r\n" );
							// end 13/09/12 manoharan new lpn number to be matched
							
							valueXmlString.append("</Detail4>\r\n");*/
							String itemDescr = "";
							locCodeSys = genericUtility.getColumnValueFromNode("loc_code__sys", parentNode);
							itemCode =  genericUtility.getColumnValueFromNode("item_code", parentNode);
							itemDescr = genericUtility.getColumnValueFromNode("item_descr", parentNode);
							siteCode = genericUtility.getColumnValueFromNode("site_code", parentNode);
							siteDescr = genericUtility.getColumnValueFromNode("site_descr", parentNode);
							locCode = genericUtility.getColumnValueFromNode("loc_code", parentNode);
							lotNo = genericUtility.getColumnValueFromNode("lot_no", parentNode);
							lotSl = genericUtility.getColumnValueFromNode("lot_sl", parentNode);
							lotSlNew = genericUtility.getColumnValueFromNode("lot_sl__new", parentNode);
							replOrder = genericUtility.getColumnValueFromNode("repl_order", parentNode);
							lineNoOrd = Integer.parseInt(genericUtility.getColumnValueFromNode("line_no__ord", parentNode));
							System.out.println("itemCode ----- ["+itemCode+"]");
							//Changed By Pragyan To check th pick type proper way.start
							/*//Changed by sumit on 19/02/13 modifide sql as this is wrong.
							//sql = "SELECT POD.PICK_TYPE , ROD.ITEM_CODE FROM REPL_ORD_DET ROD,PICK_ORD_HDR POD WHERE ROD.PICK_ORDER = POD.PICK_ORDER AND ROD.REPL_ORDER = ?";
							sql = " SELECT DISTINCT POH.PICK_TYPE , ROD.ITEM_CODE FROM REPL_ORD_DET ROD,PICK_ORD_HDR POH , PICK_ORD_DET POD " +
									" WHERE POH.PICK_ORDER = POD.PICK_ORDER AND POD.REPL_ORDER = ROD.REPL_ORDER AND ROD.REPL_ORDER = ? ";
							pstmt = conn.prepareStatement( sql );
							pstmt.setString( 1, replOrder );
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								pickType = checkNull(rs.getString("PICK_TYPE"));
								//itemCode = checkNull(rs.getString("ITEM_CODE"));//Added By Mahesh Patidar on 07/08/12
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
							System.out.println("pick type =[" +pickType+ "]");

							if ( "A".equalsIgnoreCase(pickType.trim()) )//Active pick
							{								
								objName = "active_repl_iss";
							}
							else if ( "C".equalsIgnoreCase(pickType.trim()) || "M".equalsIgnoreCase(pickType.trim()) )//Case pick & master pick
							{								
								objName = "repl_iss";
							}			
							
							 */
					String orderType = "";
					sql = "SELECT ORDER_TYPE FROM REPL_ORD_HDR WHERE REPL_ORDER = ? ";
					pstmt = conn.prepareStatement( sql );
					pstmt.setString( 1, replOrder );
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						orderType = checkNull(rs.getString("ORDER_TYPE"));
					}
					rs.close(); rs = null;
					pstmt.close(); pstmt = null;
							
					//Changed By Pragyan 07-APR-14 to get pick type properly.start
					
					if ( "A".equalsIgnoreCase(orderType.trim()) || "I".equalsIgnoreCase(orderType.trim()) || "Q".equalsIgnoreCase(orderType.trim()) ||  "T".equalsIgnoreCase(orderType.trim()) ||  "E".equalsIgnoreCase(orderType.trim()))//Active pick
					{
						pickType = "A";
						objName = "active_repl_iss";
						varName = "ACTIVE_PICK_INVSTAT";
					}
					else if ( "C".equalsIgnoreCase(orderType.trim()) || "M".equalsIgnoreCase(orderType.trim()) || "J".equalsIgnoreCase(orderType.trim()) || "K".equalsIgnoreCase(orderType.trim()))//Case pick & master pick
					{
						varName = "CASE_PICK_INVSTAT";
						objName = "repl_iss";
					}
					else if("E".equalsIgnoreCase(orderType.trim()) || "F".equalsIgnoreCase(orderType.trim()) || "G".equalsIgnoreCase(orderType.trim()) ||"H".equalsIgnoreCase(orderType.trim()) )
					{
						objName = "repl_iss";
						varName = "PND_INVSTAT";
					}
					else if("L".equalsIgnoreCase(orderType.trim()) || "D".equalsIgnoreCase(orderType.trim()))
					{
						objName = "repl_iss";
						varName = "DOCKLOC_INVSTAT";
					}
					//Changed By Pragyan To check th pick type proper way.end
							
							sql = "SELECT RID.REPL_ORDER, RID.LINE_NO__ORD, RID.SITE_CODE, RID.ITEM_CODE, RID.LOC_CODE, RID.LOT_NO, "+
									" RID.LOT_SL, RID.QUANTITY, RID.NO_ART, RID.LOC_CODE__TO, RID.LOC_CODE__SYS as LOC_CODE__SYS, RID.LOT_SL__NEW"+
									" FROM REPL_ISS_DET RID WHERE RID.REPL_ORDER = ? AND RID.LINE_NO__ORD = ? AND RID.ITEM_CODE = ? " +
									" AND RID.SITE_CODE = ? AND RID.LOC_CODE__SYS = ? AND RID.LOC_CODE = ? AND RID.LOT_NO = ? " +
									" AND RID.LOT_SL = ? AND CASE WHEN RID.LOC_TO_ASSIGNED IS NULL THEN 'N' ELSE RID.LOC_TO_ASSIGNED end = 'Y' ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, replOrder);
							pstmt.setInt(2, lineNoOrd);
							pstmt.setString(3, itemCode);
							pstmt.setString(4, siteCode);
							pstmt.setString(5, locCodeSys);
							pstmt.setString(6, locCode);
							pstmt.setString(7, lotNo);
							pstmt.setString(8, lotSl);
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								//valueXmlString.append( "<Detail4 domID='"+(ctr+1)+"'>\r\n" ); newInt
								//Changed by sumit on 26/02/13 changed dom id.
								//valueXmlString.append( "<Detail4 domID='"+(ctr+1)+"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"Y\">\r\n" );
								valueXmlString.append( "<Detail4 domID='"+newInt+"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"Y\">\r\n" );
								valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\" />\r\n"); 
								valueXmlString.append( "<tran_id/>" );
								valueXmlString.append( "<loc_code__sys><![CDATA[" ).append(checkNullAndTrim(locCodeSys)).append( "]]></loc_code__sys>\r\n" );
								valueXmlString.append( "<loc_code__to><![CDATA[" ).append(rs.getString("LOC_CODE__TO")).append( "]]></loc_code__to>\r\n" );
								valueXmlString.append( "<line_no><![CDATA[" ).append( lineNo ).append( "]]></line_no>\r\n" );
								valueXmlString.append( "<item_code><![CDATA[" ).append( itemCode ).append( "]]></item_code>\r\n" );
								valueXmlString.append( "<item_descr><![CDATA[" ).append( itemDescr ).append( "]]></item_descr>\r\n" );
								valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
								valueXmlString.append( "<site_descr><![CDATA[" ).append( siteDescr ).append( "]]></site_descr>\r\n" );
								valueXmlString.append( "<loc_code><![CDATA[" ).append( locCode ).append( "]]></loc_code>\r\n" );
								valueXmlString.append( "<lot_no><![CDATA[" ).append( lotNo ).append( "]]></lot_no>\r\n" );
								valueXmlString.append( "<lot_sl><![CDATA[" ).append( lotSl ).append( "]]></lot_sl>\r\n" );
								valueXmlString.append( "<lot_sl__new><![CDATA[" ).append(lotSlNew.trim()).append( "]]></lot_sl__new>\r\n" );	
								valueXmlString.append( "<repl_order><![CDATA[" ).append(replOrder).append( "]]></repl_order>\r\n" );
								
								valueXmlString.append("</Detail4>\r\n");
							}
							else
							{								
								//valueXmlString.append( "<Detail4 domID='"+(ctr+1)+"'>\r\n" );
								//Changed by sumit on 26/02/13 changed dom id.
								//valueXmlString.append( "<Detail4 domID='"+(ctr+1)+"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"N\">\r\n" );
								valueXmlString.append( "<Detail4 domID='"+(newInt)+"' objContext = '"+currentFormNo+"' objName='"+objName+"' selected=\"N\">\r\n" );
								valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");
								valueXmlString.append( "<tran_id/>" );
								valueXmlString.append( "<loc_code__sys><![CDATA[" ).append(checkNullAndTrim(locCodeSys)).append( "]]></loc_code__sys>\r\n" );
								valueXmlString.append( "<loc_code__to><![CDATA[" ).append("").append( "]]></loc_code__to>\r\n" );
								valueXmlString.append( "<line_no><![CDATA[" ).append( lineNo ).append( "]]></line_no>\r\n" );
								valueXmlString.append( "<item_code><![CDATA[" ).append( itemCode ).append( "]]></item_code>\r\n" );
								valueXmlString.append( "<item_descr><![CDATA[" ).append( itemDescr ).append( "]]></item_descr>\r\n" );
								valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
								valueXmlString.append( "<site_descr><![CDATA[" ).append( siteDescr ).append( "]]></site_descr>\r\n" );
								valueXmlString.append( "<loc_code><![CDATA[" ).append( locCode ).append( "]]></loc_code>\r\n" );
								valueXmlString.append( "<lot_no><![CDATA[" ).append( lotNo ).append( "]]></lot_no>\r\n" );
								valueXmlString.append( "<lot_sl><![CDATA[" ).append( lotSl ).append( "]]></lot_sl>\r\n" );
								valueXmlString.append( "<lot_sl__new><![CDATA[" ).append(lotSlNew.trim()).append( "]]></lot_sl__new>\r\n" );
								valueXmlString.append( "<repl_order><![CDATA[" ).append(replOrder).append( "]]></repl_order>\r\n" );
								valueXmlString.append("</Detail4>\r\n");
							}
							rs.close(); rs = null;
							pstmt.close(); pstmt = null;
						}
					}
					
								
					String updatedDetailDomStr = addSelectedRecToDom( allFormDataDom, valueXmlString.toString() );

					valueXmlString = null;
					valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>").append( editFlag );
					valueXmlString.append("</editFlag>\r\n</Header>\r\n");
					updatedDetailDomStr = updatedDetailDomStr.substring(updatedDetailDomStr.indexOf("<Root>") + "<Root>".length(), updatedDetailDomStr.indexOf("</Root>") );
					valueXmlString.append(updatedDetailDomStr);
					System.out.println("\n*******sumit*******************\n");
					System.out.println("updatedDetailDomStr[4]:>>>>>>>>>>> "+updatedDetailDomStr);
					//Changed by sumit on 07/02/13 getting all required value from 3rd detail and display selected and unselected record end
				}

			}  
			//Ended By Mahesh Patidar on 31/07/12
			}
		}
		catch (Exception e)
		{				
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{	
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
				//Changed by sumit on 20/02/13 closing prepared statement start
				if( pstmt1 != null)
				{
					pstmt1.close(); pstmt1 = null;
				}
				if( rs1 != null )
				{
					rs1.close(); rs1 = null;
				}
				//Changed by sumit on 20/02/13 closing prepared statement end
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );	
		return valueXmlString.toString();
	}

	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string.  
	 * @param input
	 */
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}		
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string otherwise trim the input string and return.  
	 * @param input
	 */
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	private String getSiteCode( String xtraParams, Connection connObject ) throws ITMException
	{
		String defaultSite = "";
		String empSite = "";
		String workSite = "";
		String sql = "";
		String loginCode = "";

		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			GenericUtility genericUtility = GenericUtility.getInstance();
			loginCode = checkNull(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" ));

			sql = "SELECT USERS.EMP_CODE, USERS.ENTITY_CODE, USERS.SITE_CODE__DEF, EMP.EMP_SITE, EMP.WORK_SITE "+
					"FROM USERS USERS, EMPLOYEE EMP WHERE USERS.EMP_CODE = EMP.EMP_CODE AND USERS.CODE = ? ";
			pstmt = connObject.prepareStatement( sql );
			pstmt.setString( 1, loginCode );						
			rs = pstmt.executeQuery();	
			if( rs.next() )
			{
				defaultSite = checkNull(rs.getString("SITE_CODE__DEF"));
				empSite = checkNull(rs.getString("EMP_SITE"));
				workSite = checkNull(rs.getString("WORK_SITE"));
			}
			if ( defaultSite.trim().length() == 0 && empSite.trim().length() > 0 )
			{
				defaultSite = empSite;
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
		}
		catch (Exception e)
		{				
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{	
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		System.out.println("defaultSite = ["+defaultSite+"]");
		return defaultSite;
	}
	private String addSelectedRecToDom( Document allFormDataDom, String detailString ) throws Exception
	{
		ArrayList selectedList = new ArrayList();
		NodeList detailList = null;
		Node currDetail = null;
		NodeList currDetailList = null;
		String selectedVal = "", nodeName = "", updateStatus = "";
		String domIDVal = "";
		String updatedDetailDomStr = "";
		String attributeVal = "";
		String locCodeTo = "";
		String columnValue = "";

		HashMap toUpdateMap = new HashMap();

		Node elementName = null;

		int currDetailListLength = 0;
		int	detailListLength = 0;

		int selectedValCnt = 0;

		GenericUtility genericUtility = GenericUtility.getInstance();

		try
		{
			detailList = allFormDataDom.getElementsByTagName("Detail2");
			detailListLength = detailList.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detailList.item(ctr);
				currDetailList = currDetail.getChildNodes();
				currDetailListLength = currDetailList.getLength();

				attributeVal = "";
				columnValue = "";

				ArrayList toUpdNodeList = new ArrayList();
				HashMap dataMap = new HashMap();

				for ( int i=0; i< currDetailListLength; i++ )
				{
					Node childNode = currDetailList.item(i);
					nodeName = childNode.getNodeName();
					if (nodeName.equalsIgnoreCase("Attribute"))
					{
						attributeVal = checkNull(currDetailList.item(i).getAttributes().getNamedItem("selected").getNodeValue());
						System.out.println("attributeVal =["+attributeVal+"]");
					}//if (nodeName = Attribute
					else if (nodeName.equalsIgnoreCase("loc_code__to"))
					{
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							locCodeTo = childNode.getFirstChild().getNodeValue();
							//toUpdNodeList.add( 1, childNode );
							dataMap.put("loc_code__to", childNode);
						}
					}
				}//End of inner for loop
				if ( "Y".equalsIgnoreCase(attributeVal.trim()) )
				{
					if ( currDetail.getAttributes().getNamedItem( "domID" ) != null )
					{
						domIDVal = checkNull(currDetail.getAttributes().getNamedItem( "domID" ).getNodeValue());
						System.out.println("domIDVal =["+domIDVal+"]");
					}
					toUpdateMap.put( domIDVal, dataMap );
				}
			}//End of for loop

			System.out.println("toUpdateMap:>>>>>>>>>>>: "+toUpdateMap);

			detailList = null;

			detailString = detailString + "</Root>\r\n" ;	
			System.out.println("detailString:>>>>>>>>>>> "+detailString);
			Document detailDom = genericUtility.parseString(detailString); 

			Element elementAttr = null;

			detailList = detailDom.getElementsByTagName("Detail2");
			detailListLength = detailList.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				currDetail = detailList.item(ctr);

				if ( currDetail.getAttributes().getNamedItem( "selected" ) != null )
				{
					selectedVal = checkNull(currDetail.getAttributes().getNamedItem( "selected" ).getNodeValue());
					System.out.println("selectedVal =["+selectedVal+"]");
					if ( "N".equalsIgnoreCase(selectedVal.trim()) )
					{
						if ( currDetail.getAttributes().getNamedItem( "domID" ) != null )
						{
							//ArrayList aList = null;

							HashMap dataMap = new HashMap();

							domIDVal = checkNull(currDetail.getAttributes().getNamedItem( "domID" ).getNodeValue());
							System.out.println("domIDVal =["+domIDVal+"]");
							System.out.println("toUpdateMap.containsKey(domIDVal) =["+toUpdateMap.containsKey(domIDVal)+"]");
							if ( toUpdateMap.containsKey(domIDVal) )
							{
								elementAttr = (Element)currDetail;
								elementAttr.setAttribute( "selected" , "Y" );

								Node locCodeToNode = null;

								dataMap = (HashMap)toUpdateMap.get(domIDVal);

								if ( dataMap.get("loc_code__to") != null )
								{
									locCodeToNode = (Node)dataMap.get("loc_code__to");
								}

								Node updatedNode = null;

								currDetailList = currDetail.getChildNodes();
								currDetailListLength = currDetailList.getLength();

								for ( int i = 0; i < currDetailListLength; i++ )
								{
									elementName = currDetailList.item(i);
									nodeName = elementName.getNodeName();
									if( elementName.getNodeType() != Node.ELEMENT_NODE || nodeName.equalsIgnoreCase("#text") )
									{
										continue;
									}
									System.out.println("nodeName =["+nodeName+"]");
									if ( nodeName.equalsIgnoreCase("loc_code__to") )
									{
										//System.out.println("LocCodeToNode =["+genericUtility.serializeDom( LocCodeToNode )+"]");
										updatedNode = detailDom.importNode(locCodeToNode, true);
										//System.out.println("updatedNode =["+genericUtility.serializeDom( updatedNode )+"]");
										(detailDom.getElementsByTagName("Detail2").item(ctr)).replaceChild(updatedNode, elementName );
									}
								}//inner for loop
							}//if ( toUpdateMap.containsKey(domIDVal) )
						}//if ( currDetail.getAttributes().getNamedItem( "domID" )
					}//if ( "N".equalsIgnoreCase(selectedVal.trim()) )
				}//if ( currDetail.getAttributes().getNamedItem( "selected" )
			}//outer for loop
			updatedDetailDomStr = genericUtility.serializeDom( detailDom );
			System.out.println("updatedDetailDomStr:>>>>>>>>>>> "+updatedDetailDomStr);
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw e;
		}

		return updatedDetailDomStr;
	}
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null,reqDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				if( objName != null && objName.trim().length() > 0)
				{				
					return objName;
				}
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return objName;
	}
	//added by kunal on 1/09/12
	private String getAttribValue(Node detailNode, String nodeName, String attribStr)
	{
		String attribValue = "";
		try
		{
			String domStr = GenericUtility.getInstance().serializeDom(detailNode);
			Document dom = GenericUtility.getInstance().parseString(domStr);
			if( dom != null /*&& dom.getAttributes() != null*/)
			{
				Node attributeNode = dom.getElementsByTagName( nodeName ).item(0);
				attribValue = getAttribValue(attributeNode, attribStr);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}

	private String getAttribValue(Node detailNode, String attribStr)
	{
		String attribValue = "";
		try
		{
			if( detailNode != null && detailNode.getAttributes() != null)
			{
				Node attribNode = detailNode.getAttributes().getNamedItem( attribStr );
				if( attribNode != null )
				{
					attribValue = checkNull( attribNode.getNodeValue() );
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : getAttribValue :" + e.getMessage());
		}
		return attribValue;
	}
	
	//Changed by sumit 20/09/12 to printing repl stock to dock report start.
	//Changed by sumit 20/09/12 write this code in post save end.
    /*private String generateReport(String replOrder,String ptcn, Connection conn,String xtraParams ) throws ITMException
    {
    	String errString ="";
    	String printMode = "";
    	String outputFilename = "";
    	TreeMap argMap = null;
    	DistCommon discommon = new DistCommon();
    	GenericUtility genericUtility = GenericUtility.getInstance();
    	try
    	{    		
    		String printerStr  = discommon.getDisparams("999999","STOCK_TO_DOCK_PRINTER",conn);
    		System.out.println("PRINT MODE CALLED");
    		String chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");								
			System.out.println(" printerStr ->["+printerStr+"]");				
			if(printerStr.trim().length() > 0)
			{					
				String reportObjName = discommon.getDisparams("999999","STOCK_TO_DOCK_OBJ_NAME",conn);					
				String reportSavetype = "NATIVE";					
				ibase.webitm.reports.utility.JasperReportGenerator jrGenerator = new ibase.webitm.reports.utility.JasperReportGenerator();
				String xsdString ="<Arguments>" +
							"<Argument id=\"REPLORDER\" name=\"REPLORDER\">" +
							"<argType>java.lang.String</argType>" +
							//"<value>"+ptcnList.get(i)+"</value>" +
							"<value>"+replOrder+"</value>" +
							"</Argument>" +
							"<Argument id=\"PTCN\" name=\"PTCN\">" +
							"<argType>java.lang.String</argType>" +
							//"<value>"+ptcnList.get(i)+"</value>" +
							"<value>"+ptcn+"</value>" +
							"</Argument>" +
							"<Argument id=\"x_path\" name=\"x_path\">" +
							"<argType>java.lang.String</argType>" +
							"<value>/DocumentRoot/wave_task_main</value>" +
							"</Argument>" +
							"<Argument id=\"design_source\" name=\"design_source\">" +
							"<argType>java.lang.String</argType>" +
							"<value>wave_task_main.jrxml</value>" +
							"</Argument>" +
							"<Argument id=\"data_source\" name=\"data_source\">" +
							"<argType>java.lang.String</argType>" +
							"<value>SQL</value>" +
							"</Argument>" +
							"<Argument id=\"bind_type\" name=\"bind_type\">" +
							"<argType>java.lang.Integer</argType>" +
							"<value>0</value>" +
							"</Argument>" +
							"<Argument id=\"report_type\" name=\"report_type\">" +
							"<argType>java.lang.String</argType>" +
							"<value>JASPER</value>" +
							"</Argument>" +
							"<Argument id=\"report_save_type\" name=\"report_save_type\">" +
							"<argType>java.lang.String</argType>" +
							//Changed by sumit on 07/09/12  changed NATIVE to PDF
							//"<value>NATIVE</value>" +									
							"<value>"+reportSavetype+"</value>" +
							"</Argument>" +
							"</Arguments>";
				System.out.println(" XSD parser **->["+xsdString+"]");						
				errString = jrGenerator.printReport(reportObjName, xsdString, chgUser, printerStr, 1, conn);			
					
				//}
				System.out.println(" PRINTING task completed--------**------->");
			}			
    	}
    	catch (Exception e)
    	{
    		e.printStackTrace();
    		throw new ITMException(e);
    	}
    	
    	return errString;
    }*/
	//Changed by sumit 20/09/12 write this code in post save end.
  //Changed by sumit 20/09/12 to printing repl stock to dock report end.
	
	//Changed by sumit on 22/05/13 checking duplicate lot_sl__new start.
	private ArrayList checkDuplicaterecord(Document dom) throws ITMException
	{
		ArrayList arryList = new ArrayList();
		
		NodeList parentNodeList = null, childNodeList  = null;
		Node parentNode = null, childNode = null;
	    int parentNodeListLength = 0;
	    String childNodeName = "";
		
		try {
			parentNodeList = dom.getElementsByTagName("Detail3");
			parentNodeListLength = parentNodeList.getLength();
			for (int row = 0; row < parentNodeList.getLength(); row++) 
			{
				parentNode = parentNodeList.item(row);				
				//String updateFlag = getAttribValue(parentNode,"attribute", "updateFlag"); //(parentNode, "attribute", "status"));
				//System.out.println(" sumit updateFlag ["+updateFlag+"]");
				childNodeList = parentNode.getChildNodes();
				
				//System.out.println("************* first For loop *************["+ parentNode.getNodeName() + "]");
				for (int col = 0; col < childNodeList.getLength(); col++) {
					childNode = childNodeList.item(col);
					
					if (childNode.getNodeType() == childNode.ELEMENT_NODE) {
						childNodeName = childNode.getNodeName();
						//System.out.println("childNodeNamechildNodeName ** ["+childNodeName+"]");						
						if ("lot_sl__new".equalsIgnoreCase(childNodeName)) 
						{
							if(childNode.getFirstChild() != null)
							{
								arryList.add(childNode.getFirstChild().getNodeValue().trim());
							//arrayList.add(i,childNode.getFirstChild().getNodeValue());
							//map = sprsCode != null ? sprsCode : "";
							}
													
						}						
					}
				}
			}
			System.out.println("=====lot_sl__new-->[" + arryList+ "]");	
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return arryList;
	}	
	//Changed by sumit on 22/05/13 checking duplicate lot_sl__new end
}
