package ibase.webitm.util.gst;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.codec.binary.Base64;

public class AESEncryption 
{
    private final String AES_TRANSFORMATION = "AES/ECB/PKCS5Padding";
    private final String AES_ALGORITHM = "AES";
    private final int ENC_BITS = 256;
    private final String CHARACTER_ENCODING = "UTF-8";

    private Cipher ENCRYPT_CIPHER;
    private Cipher DECRYPT_CIPHER;
    private KeyGenerator KEYGEN;

    public AESEncryption() throws Exception 
    {
        ENCRYPT_CIPHER = Cipher.getInstance(AES_TRANSFORMATION);
        DECRYPT_CIPHER = Cipher.getInstance(AES_TRANSFORMATION);
        KEYGEN = KeyGenerator.getInstance(AES_ALGORITHM);
        KEYGEN.init(ENC_BITS);
    }


    public String encodeBase64String(byte[] bytes) 
    {
        return new String(java.util.Base64.getEncoder().encode(bytes));
    }


    public byte[] decodeBase64StringTOByte(String stringData) throws Exception 
    {
        return java.util.Base64.getDecoder().decode(stringData.getBytes(CHARACTER_ENCODING));
    }


    public String generateSecureKey() throws Exception 
    {
        SecretKey secretKey = KEYGEN.generateKey();
        return encodeBase64String(secretKey.getEncoded());
    }

    public String encryptEK(byte[] plainText, byte[] secret) throws Exception 
    {

        SecretKeySpec sk = new SecretKeySpec(secret, AES_ALGORITHM);
        ENCRYPT_CIPHER.init(Cipher.ENCRYPT_MODE, sk);
        return Base64.encodeBase64String(ENCRYPT_CIPHER.doFinal(plainText));
    }

    public byte[] decrypt(String plainText, byte[] secret) throws Exception 
    {
        SecretKeySpec sk = new SecretKeySpec(secret, AES_ALGORITHM);
        DECRYPT_CIPHER.init(Cipher.DECRYPT_MODE, sk);
        return DECRYPT_CIPHER.doFinal(Base64.decodeBase64(plainText));
    }
}
