package ibase.client;

import ibase.e12ria.e12table.client.ColumnInfoBean;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell.Context;
import com.google.gwt.cell.client.EditTextCell;
import com.google.gwt.dom.builder.shared.TableCellBuilder;
import com.google.gwt.dom.builder.shared.TableRowBuilder;
import com.google.gwt.dom.client.Style.Cursor;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.AbstractHeaderOrFooterBuilder;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.cellview.client.ColumnSortList.ColumnSortInfo;
import com.google.gwt.user.cellview.client.Header;
import com.google.gwt.user.cellview.client.TextHeader;

public class CustomHeaderBuilder extends AbstractHeaderOrFooterBuilder<ColumnInfoBean>  {

	
	public CustomHeaderBuilder(AbstractCellTable<ColumnInfoBean> table,boolean isFooter)
	{
		super(table, isFooter);
		// TODO Auto-generated constructor stub
	}

	private Header<String> firstNameHeader = new TextHeader("Name");
	protected boolean buildHeaderOrFooterImpl() 
	{
		Column<ColumnInfoBean, String> firstNameColumn = new Column<ColumnInfoBean, String>(new EditTextCell()) {
		      @Override
		      public String getValue(ColumnInfoBean object) {
		        return object.getDisplayNameOfCol();
		      }
		    };
		 
	      TableRowBuilder tr = startRow();
	      tr.startTH().colSpan(2).rowSpan(2);
	      tr.endTH();

	      TableCellBuilder th = tr.startTH().colSpan(2);
	    
	      th.style().trustedProperty("border-right", "10px solid white").cursor(Cursor.POINTER).endStyle();
	      th.text("Current Year").endTH();

	      // Information group header.
	      th = tr.startTH().colSpan(3);
	      th.text("Previous Year").endTH();

	      // Get information about the sorted column.
	      ColumnSortList sortList = null;
	      ColumnSortInfo sortedInfo = (sortList.size() == 0) ? null : sortList.get(0);
	      Column<?, ?> sortedColumn = (sortedInfo == null) ? null : sortedInfo.getColumn();
	      boolean isSortAscending = (sortedInfo == null) ? false : sortedInfo.isAscending();
		 tr = startRow();
	      buildHeader(tr, firstNameHeader, firstNameColumn, sortedColumn, isSortAscending, false, false);
	      
		return true;
	}
	private void buildHeader(TableRowBuilder out, Header<?> header, Column<ColumnInfoBean, ?> column,
	        Column<?, ?> sortedColumn, boolean isSortAscending, boolean isFirst, boolean isLast) {
	      // Choose the classes to include with the element.
	     
	      boolean isSorted = true;
	    

	      // Create the table cell.
	      TableCellBuilder th = out.startTH();

	      // Associate the cell with the column to enable sorting of the column.
	      enableColumnHandlers(th, column);

	      // Render the header.
	      Context context = new Context(0, 2, header.getKey());
	      renderSortableHeader(th, context, header, isSorted, isSortAscending);

	      // End the table cell.
	      th.endTH();
	    }
	  

}
