<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">
<html>
<script type="text/javascript" src="/ibase/webitm/js/ItemTypeWiz.js"></script>
<script><![CDATA[
$(document).on("keydown", function (e) {alert(e.which );
   if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
       e.preventDefault();
   }
   else if(e.which === 13){
    e.preventDefault();
   }
});]]></script>
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/theme/galaxy-theme.css" rel="stylesheet"/>
<style type="text/css">
.header_class
{border:inset 0;font-family: 'MuseoLight-300', sans-serif; color : #COCOCO; background : #FFF; text-align : left; font-size: 14px;}
.input_editablecenter
{border:solid 0; font-family: 'MuseoLight-300', sans-serif; border-color: lightgrey;color : #COCOCO; background : #FFF; text-align : left; font-size: 14px;}
.tableClass_rep
{margin-left:0px}

.td_leftAlign{

background-color: #FFF;
    
    font-family: "MuseoLight-300",sans-serif;
    font-size: 14px;
    text-shadow: none;
    text-align:left;
}

.input_editable
{border:solid 1px;font-family: 'MuseoLight-300', sans-serif; border-color: #ccc;color : #COCOCO; background : #FFF; text-align : left; font-size: 14px;}

.td_rightAlign{

background-color: #FFF;
    font-family: "MuseoLight-300",sans-serif;
    font-size: 14px;
    text-shadow: none;    
    text-align:right;
}

.editDisplayheder
{readOnly:true; TEXT-ALIGN:left; color:#000; padding:5px 5px 10px 5px; font-size:16px; }

.editDisplayColumnClass 
{readOnly:true; margin-left:2px; BACKGROUND:#fff; TEXT-ALIGN:LEFT; margin-bottom:10px; border-top: none; border-bottom:solid 1px #ebebeb; border-right:solid 1px #ebebeb; border-left:solid 1px #ebebeb;}

.editDisplayColumnClass td
{ 
padding:5px; border-bottom: none; font-size:14px;}



.button{
border: 1px solid #E7E7E7;
border-radius: 2px;
-moz-border-radius: 2px;
-webkit-border-radius: 2px;
-moz-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.5);
-webkit-box-shadow: 0 1px 1px rgba(0, 0, 0, 0.5);
box-shadow: 0 1px 1px rgba(0, 0, 0, 0.5);
color: #333;
height: 22px;
font-family: 'MuseoLight-300', sans-serif;
font-size: 12px;
background-color: #e7e7e7;
cursor: pointer;
margin-left:10px;
}

.button:hover
 {
border: 1px solid #E7E7E7 !important;
background-color: #e7e7e7 !important;
color: #000 !important;
-moz-box-shadow: 0 2px 1px rgba(0, 0, 0, 0.5) !important;
-webkit-box-shadow: 0 2px 1px rgba(0, 0, 0, 0.5) !important;
box-shadow: 0 2px 1px rgba(0, 0, 0, 0.5) !important;
text-shadow: none;
}

.button:active
 {
text-shadow: none;
background-color: #d6d6d6 !important;
color: #000 !important;
-moz-box-shadow: 0 2px 1px rgba(0, 0, 0, 0.5) !important;
-webkit-box-shadow: 0 2px 1px rgba(0, 0, 0, 0.5) !important;
box-shadow: 0 2px 1px rgba(0, 0, 0, 0.5) !important;
border: 1px solid #E7E7E7 !important;
}

.divclass
{
  border : solid 1px lightgray;
  line-height : 23px;
  width:99.5%
}

.button.disabled {
	background: #EBEBEB !important;
    color:gray !IMPORTANT;
    pointer-events:none !IMPORTANT;
}

.button.enabled {
    color:#333 !IMPORTANT;
    pointer-events:auto !IMPORTANT;
}
</style>

<body onload = "pageLoadHeader()">

<form name="item_type_wizI" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">

	<TABLE border="0" width="100%" height="2%" class="header_td" cellpadding="0" cellspacing="0" style="background-color: #f7f8fa;border-bottom: #6cf 3px solid">
		<TR>
			<div class='contentHeaderLbl'><img src="/ibase/images/menuImages/web/Dailyactivityreport.png" onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px;margin-top:9px; height: 20px; width: 20px;"/>
				<td class="header_main" nowrap="true" align="left" valign="middle" style="padding-left: 10px;font-size:16px;" width="2%" > 
				      Attribute Details :
				</td>
			</div>
		</TR>
	</TABLE>
	<div class="pageContentWrapper" style="height:72%;">
	<table id="activityTable" Class="editDisplayColumnClass" border="0" cellSpacing="0" width="100%" cellPadding="0">
		<xsl:for-each select="//Detail1">
				<!--<xsl:variable name="site_code"><xsl:value-of select="site_code"/></xsl:variable>-->
				<xsl:variable name="item_type"><xsl:value-of select="item_type"/></xsl:variable>
				<xsl:variable name="phy_attrib_2"><xsl:value-of select="phy_attrib_2"/></xsl:variable>
				<xsl:variable name="phy_attrib_1"><xsl:value-of select="phy_attrib_1"/></xsl:variable>
				<xsl:variable name="phy_attrib_3"><xsl:value-of select="phy_attrib_3"/></xsl:variable>
				<xsl:variable name="phy_attrib_8"><xsl:value-of select="phy_attrib_8"/></xsl:variable>
				<xsl:variable name="phy_attrib_9"><xsl:value-of select="phy_attrib_9"/></xsl:variable>
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			<tr>
				 <td class="td_rightAlign" nowrap="true">
                            <strong>Item Type :</strong>
                 </td>
				
				<td class="td_leftAlign">
				<div style="position:relative; width: 60%;">
					<input type="text" class="input_editable" value="{$item_type}"
						name="Detail1.{normalize-space($dbID)}.item_type" id="Detail1.{normalize-space($dbID)}.item_type"
						maxlength="10" ISCHANGED="false" readOnly="1"
						onkeydown="javascript:openSearchPopup(event, '{normalize-space($dbID)}','','item_type', 'Item Type', 0);"
						style="width: 50%;"/>
					<div style="width:1%;float: right;">
						<a
							href="javascript:callListJSP('{normalize-space($dbID)}','','item_type', 'Item Type', 0);"
							style="float: left;text-decoration: none;" tabindex = "-1"
							id="Detail1.{normalize-space($dbID)}.item_type_pophelp">
							<img src="/ibase/webitm/images/pophelp.png" style="margin-left: -205px;"
								title="Select Item Type" />
						</a>
					</div>
				</div>
			</td>
			</tr>
		  <tr>
				<td class="td_rightAlign" nowrap="true">
					<strong>Attribute1 :</strong>
				</td>
				<td class="td_leftAlign">
					<!--Changed by Santosh on 29/03/2017 for label and textbox mismatch issue  -->
					<!-- <input type="text" readonly = "1" class="input_editable" name="Detail1.{normalize-space($dbID)}.phy_attrib_2" value="{phy_attrib_2}" id="Detail1.{normalize-space($dbID)}.phy_attrib_2" maxlength="15"  style="width: 30%;" /> -->
					<input type="text" readonly = "1" class="input_editable" name="Detail1.{normalize-space($dbID)}.phy_attrib_1" value="{phy_attrib_1}" id="Detail1.{normalize-space($dbID)}.phy_attrib_1" maxlength="15"  style="width: 30%;"/>		
				</td>
		   </tr>
		  <tr>
				<td class="td_rightAlign" nowrap="true">
					<strong>Attribute2 :</strong>
				</td>
				<td class="td_leftAlign">
					<!--Changed by Santosh on 29/03/2017 for label and textbox mismatch issue  -->
					<!-- <input type="text" readonly = "1" class="input_editable" name="Detail1.{normalize-space($dbID)}.phy_attrib_1" value="{phy_attrib_1}" id="Detail1.{normalize-space($dbID)}.phy_attrib_1" maxlength="15"  style="width: 30%;"/> -->
					<input type="text" readonly = "1" class="input_editable" name="Detail1.{normalize-space($dbID)}.phy_attrib_2" value="{phy_attrib_2}" id="Detail1.{normalize-space($dbID)}.phy_attrib_2" maxlength="15"  style="width: 30%;" />		
				</td>
		   </tr>
		  <tr>
				<td class="td_rightAlign" nowrap="true">
					<strong>Attribute3 :</strong>
				</td>
				<td class="td_leftAlign">
					<input type="text" readonly = "1" class="input_editable" name="Detail1.{normalize-space($dbID)}.phy_attrib_3" value="{phy_attrib_3}" id="Detail1.{normalize-space($dbID)}.phy_attrib_3" maxlength="15"  style="width: 30%;"/>		
				</td>
		   </tr>
		  <tr>
				<td class="td_rightAlign" nowrap="true">
					<strong>Attribute4 :</strong>
				</td>
				<td class="td_leftAlign">
					<input type="text" readonly = "1" class="input_editable" name="Detail1.{normalize-space($dbID)}.phy_attrib_8" value="{phy_attrib_8}" id="Detail1.{normalize-space($dbID)}.phy_attrib_8" maxlength="15"  style="width: 30%;"/>		
				</td>
		   </tr>
		   <tr>
				<td class="td_rightAlign" nowrap="true">
					<strong>Attribute5 :</strong>
				</td>
				<td class="td_leftAlign">
					<input type="text" readonly = "1" class="input_editable" name="Detail1.{normalize-space($dbID)}.phy_attrib_9" value="{phy_attrib_9}" id="Detail1.{normalize-space($dbID)}.phy_attrib_9" maxlength="15"  style="width: 30%;"/>		
				</td>
		   </tr>
		   <tr style="height: 10px;">
			</tr>
			<tr>
				<td class="td_leftAlign">
					<input type="submit" style="cursor:hand" value="Next" class="button" title='Next' id="next" onclick="javascript:return checkNullvalidation()" />
				</td>
			</tr>
		</xsl:for-each>
	</table>
		<div style="border: 1px solid transparent; width: 100%;">

							<input type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
							<input type="hidden" value="item_type_wiz" name="OBJ_NAME"
								id="OBJ_NAME" />
							<input type="hidden" value="next" name="action" id="action" />

							<table id="errorActivityTable" class="tableClass" border="0"
								cellSpacing="2" cellPadding="1" width="98%">
								<xsl:for-each select="//error">
									<xsl:variable name="message">
										<xsl:value-of select="message" />
									</xsl:variable>
									<xsl:variable name="description">
										<xsl:value-of select="description" />
									</xsl:variable>
									<xsl:variable name="type">
										<xsl:value-of select="type" />
									</xsl:variable>
									<xsl:variable name="dbID">
										<xsl:value-of select="@domId" />
									</xsl:variable>
									<xsl:variable name="column_name">
										<xsl:value-of select="@column_name" />
									</xsl:variable>

									<tr>
										<xsl:if test="position() = 1">
											<td class="td_leftAlign" nowrap="true" valign="bottom"
												width="20%">
												<xsl:value-of select="message" />
											</td>
											<td class="td_leftAlign" nowrap="true" valign="bottom"
												width="40%">
												Description :
												<xsl:value-of select="description" />
											</td>
										</xsl:if>
										<xsl:if test="$type = 'W'">
											<td class="td_leftAlign" nowrap="true" valign="bottom"
												width="20%">
												Override Warnings :
												<input type="checkbox" name="forceSave" value="false"
													onClick="setChecked(this)" />
											</td>
										</xsl:if>
									</tr>

								</xsl:for-each>
							</table>
						</div>
						
						<div id="buttonreplacement" style="margin-left:450px;display:none;">
							<img src="/ibase/images/preload.gif" alt="Please wait work in progress" >
						 	Please wait......
							</img>	
						</div>
	</div>
</form>
</body>

</html>
</xsl:template>
</xsl:stylesheet>