package ibase.webitm.ejb.sys;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import ibase.webitm.utility.ITMException;
import org.w3c.dom.*;

public class UtilMethods {
	public UtilMethods(){

	}

	public static UtilMethods getInstance()
	{
		return new UtilMethods();
	}

    /**
     * Returns Relative date as java.sql.Timestamp
     *
     * @param     baseDate  Timestamp for which the relative date is to be returned
     * @param     noOfDays Number of days as int
     * @return    Relative date as java.sql.Timestamp
     * @exception none
     */
	public java.sql.Timestamp RelativeDate(java.sql.Timestamp baseDate, int noOfDays)
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(baseDate);
		cal.add(Calendar.DATE, noOfDays);
		Date newDate = cal.getTime();
    	SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
    	return java.sql.Timestamp.valueOf(sdt.format(newDate) + " 00:00:00.000");

	}
    /**
     * Returns Relative date as java.util.Date
     *
     * @param     baseDate  java.util.Date for which the relative date is to be returned
     * @param     noOfDays Number of days as int
     * @return    Relative date as java.util.Date
     * @exception none
     */
	public Date RelativeDate(Date baseDate, int noOfDays)
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(baseDate);
		cal.add(Calendar.DATE, noOfDays);
		Date newDate = cal.getTime();
		return newDate;
	}
    /**
     * Returns java.util.Date after adding specified months
     *
     * @param     baseDate  java.util.Date for which the specified months to be added
     * @param     noOfMonths Number of months as int
     * @return    date as java.util.Date
     * @exception none
     */
	public Date AddMonths(Date baseDate, int noOfMonths)
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(baseDate);
		cal.add(Calendar.MONTH, noOfMonths);
		java.util.Date newDate = cal.getTime();
		return newDate;
	}
    /**
     * Returns java.sql.Timestamp after adding specified months
     *
     * @param     baseDate  java.sql.Timestamp for which the specified months to be added
     * @param     noOfMonths Number of months as int
     * @return    date as java.sql.Timestamp
     * @exception none
     */
	public java.sql.Timestamp AddMonths(java.sql.Timestamp baseDate, int noOfMonths)
	{
		Calendar cal = Calendar.getInstance();
		cal.setTime(baseDate);
		cal.add(Calendar.MONTH, noOfMonths);
		java.util.Date newDate = cal.getTime();
    	SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
    	return java.sql.Timestamp.valueOf(sdt.format(newDate) + " 00:00:00.000");

	}

    /**
     * Returns elapsed days as long
     *
     * @param     date1  java.sql.Timestamp 1st date
     * @param     date2 java.sql.Timestamp 2nd date
     * @return    Elapsed days as long
     * @exception none
     */
    public long DaysAfter(java.sql.Timestamp date1, java.sql.Timestamp date2)
    {
    	// 18-04-2007 manoharan to find the elapsed days
    	// between 2 dates (timestamp).
    	// Return positive days if first argument date1 is earlier date
    	// and second argument date2 is a later date
    	// other wise returns negative days
    	Calendar calen = Calendar.getInstance();
    	Calendar calen1 = Calendar.getInstance();
    	SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
    	long totDays = 0;

    	date1 = java.sql.Timestamp.valueOf(sdt.format(date1) + " 00:00:00.000");
    	calen.setTime(date1);

    	date2 = java.sql.Timestamp.valueOf(sdt.format(date2) + " 00:00:00.000");
    	calen1.setTime(date2);

    	totDays = (calen1.getTime().getTime() - calen.getTime().getTime()) / (24 * 3600 * 1000);

    	return totDays;
    }

    /**
     * Returns double formated to String with specified decimal places
     *
     * @param     actVal  The double value to be formated
     * @param     prec Number of decimal places
     * @return    Formated string
     * @exception none
     */
	public String getReqDecString(double actVal, int prec)
	{
		String fmtStr = "############0";
		String strValue = null;
		if (prec > 0)
		{
			fmtStr = fmtStr + "." + "000000000".substring(0, prec);
		}
		DecimalFormat decFormat = new DecimalFormat(fmtStr);
		return decFormat.format(actVal);
	}
    /**
     * Returns elapse months between to Timstamps
     *
     * @param     date1  Thwe 1st Timestamp value
     * @param     date2 The 2nd Timestamp value
     * @return    Number of elapsed months as int 
     * @exception none
     */
    public int MonthsBetween(java.sql.Timestamp date1, java.sql.Timestamp date2)
    {
    	// 18-04-2007 manoharan to find the elapsed months
    	// between 2 dates (timestamp).
    	Calendar calen = Calendar.getInstance();
    	Calendar calen1 = Calendar.getInstance();
    	SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd");
    	long totDays = 0;
    	int startMonth = 0, endMonth = 0, startDay = 0;
    	int totMonths = 0;
		java.sql.Timestamp tmpDate = null;

    	date1 = java.sql.Timestamp.valueOf(sdt.format(date1) + " 00:00:00.000");

    	date2 = java.sql.Timestamp.valueOf(sdt.format(date2) + " 00:00:00.000");
    	if (date2.compareTo(date1) < 0)
    	{
    		tmpDate = date2;
    		date2 = date1;
    		date1 = tmpDate;
    	}
    	calen.setTime(date1);
    	calen1.setTime(date2);

    	startDay = calen.get(Calendar.DAY_OF_MONTH);
    	startMonth = calen.get(Calendar.MONTH) + 1;
    	endMonth = calen1.get(Calendar.MONTH) + 1;
    	System.out.println("start month before" + startMonth);
    	if (startDay > 15)
    	{
    		startMonth++;
    		if ( startMonth > 12)
    		{
    			startMonth = 1;
    		}
    	}

    	if (startMonth > endMonth)
    	{
    		totMonths = 12 - startMonth + 1 + endMonth;
    	}
    	else
    	{
    		totMonths = endMonth - startMonth + 1;
    	}

    	return totMonths ;
    }
    /**
     * Returns elapse time between 2 Timestamps
     *
     * @param     date1  The 1st Timestamp value
     * @param     date2 The 2nd Timestamp value
     * @return    The time in hh.mm as double
     * @exception none
     */
    public double ElapsedTimeHHMM(java.sql.Timestamp date1, java.sql.Timestamp date2)
    {
    	// 19/01/2009 manoharan to find the elapsed time
    	// between 2 dates (timestamp). in the format hh.mm
    	// Return positive hours/minutes if first argument date1 is earlier date
    	// and second argument date2 is a later date
    	// other wise returns negative hours/minutes
    	Calendar calen = Calendar.getInstance();
    	Calendar calen1 = Calendar.getInstance();
    	SimpleDateFormat sdt = new SimpleDateFormat("yyyy-MM-dd kk:mm");
    	double totHHMM = 0;
    	long totalTime = 0,amills = 0, bmills = 0;
		java.sql.Timestamp tmpDate;
		int multiplier = 1;
    	if (date2.compareTo(date1) < 0)
    	{
    		tmpDate = date2;
    		date2 = date1;
    		date1 = tmpDate;
    		multiplier = -1;
    	}

    	date1 = java.sql.Timestamp.valueOf(sdt.format(date1) + ":00.000");
    	
    	
    	calen.setTime(date1);

    	date2 = java.sql.Timestamp.valueOf(sdt.format(date2) + ":00.000");
    	calen1.setTime(date2);
    	bmills = calen.getTimeInMillis();
		amills = calen1.getTimeInMillis();
		
		totalTime = amills - bmills;
		
		//System.out.println("Total Time Spend :: "+totalTime+" Milliseconds");

		int totSecs = (int)(((double)1/1000)*(totalTime));
		int totalHrs = (int)(totSecs / 3600);
		int totlMts = (int)(((totSecs - ( totalHrs *  3600))/ 60));

		totSecs = (int) ( totSecs - (( totalHrs *  3600) + (totlMts * 60)) );

		//System.out.println("Tot Hours   : " + totalHrs);
		//System.out.println("tot Minutes : " + totlMts);
		
		totHHMM = (double) Double.parseDouble( Integer.toString(totalHrs).trim() + "." + Integer.toString(totlMts).trim() );
		totHHMM = totHHMM * multiplier ;
    	return totHHMM;
    }
    
	//***** Modified by Vishal on 23/06/2017.Start
	public Date today()
    {
		Calendar rightNow = Calendar.getInstance();
		rightNow.clear(Calendar.HOUR);
		rightNow.clear(Calendar.MINUTE);
		rightNow.clear(Calendar.SECOND);
		rightNow.clear(Calendar.MILLISECOND);
		Date today = rightNow.getTime();
		return today;
	}
    public java.sql.Date todaySqlDate()
    {
		java.sql.Date today =  new java.sql.Date(System.currentTimeMillis());
		return today;
	}

	public java.sql.Time now()
	{
		return new java.sql.Time(System.currentTimeMillis());
	}

	public java.sql.Date getSqlDate(java.sql.Timestamp ts1)  throws ITMException
	{
		java.sql.Date sd = null;
		try
		{
			sd = new java.sql.Date(ts1.getTime());
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return sd;
	}
   
	public java.sql.Date date(java.sql.Timestamp ts1)  throws ITMException
	{
		java.sql.Date sd = null;
		try
		{
			sd = new java.sql.Date(ts1.getTime());
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return sd;
	}
   
	public java.sql.Date getSqlDate(int year, int month, int day)  throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		java.sql.Date today = null;
		try
		{
			rightNow.set(Calendar.DAY_OF_MONTH , day);
			rightNow.set(Calendar.	MONTH , month - 1);
			rightNow.set(Calendar.YEAR , year);
			rightNow.clear(Calendar.HOUR);
			rightNow.clear(Calendar.MINUTE);
			rightNow.clear(Calendar.SECOND);
			rightNow.clear(Calendar.MILLISECOND);
			java.util.Date dt = rightNow.getTime();
			today = new java.sql.Date(dt.getTime());
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return today;
	}

	public java.sql.Date date(int year, int month, int day)  throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		java.sql.Date today = null;
		try
		{
			rightNow.set(Calendar.DAY_OF_MONTH , day);
			rightNow.set(Calendar.	MONTH , month - 1);
			rightNow.set(Calendar.YEAR , year);
			rightNow.clear(Calendar.HOUR);
			rightNow.clear(Calendar.MINUTE);
			rightNow.clear(Calendar.SECOND);
			rightNow.clear(Calendar.MILLISECOND);
			java.util.Date dt = rightNow.getTime();
			today = new java.sql.Date(dt.getTime());
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return today;
	}


	public int year(java.sql.Date sd)  throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		int year = 0;
		try
		{
			rightNow.setTime(sd);
			year = rightNow.get(Calendar.YEAR);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return year;
	}

	public int year(java.util.Date sd)  throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		int year = 0;
		try
		{
			rightNow.setTime(sd);
			year = rightNow.get(Calendar.YEAR);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return year;
	}

	public int year(java.sql.Timestamp st)  throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		int year = 0;
		try
		{
			rightNow.setTime(st);
			year = rightNow.get(Calendar.YEAR);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return year;
	}

	public int month(java.sql.Date sd)  throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		int month = 0;
		try
		{
			rightNow.setTime(sd);
			month = rightNow.get(Calendar.MONTH) + 1;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return month;
	}

	public int month(java.util.Date sd)  throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		int month = 0;
		try
		{
			rightNow.setTime(sd);
			month = rightNow.get(Calendar.MONTH) + 1;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return month;
	}

	public int month(java.sql.Timestamp st)  throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		int month = 0;
		try
		{
			rightNow.setTime(st);
			month = rightNow.get(Calendar.MONTH) + 1;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return month;
	}

	public int day(java.sql.Date sd)  throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		int day = 0;
		try
		{
			rightNow.setTime(sd);
			day = rightNow.get(Calendar.DAY_OF_MONTH);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return day;
	}

	public int day(java.util.Date sd)  throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		int day = 0;
		try
		{
			rightNow.setTime(sd);
			day = rightNow.get(Calendar.DAY_OF_MONTH);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return day;
	}

	public int day(java.sql.Timestamp st)  throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		int day = 0;
		try
		{
			rightNow.setTime(st);
			day = rightNow.get(Calendar.DAY_OF_MONTH);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return day;
	}

	public java.util.Date getUtilDate(java.util.Date date)   throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		Date today = null;
		try
		{
			rightNow.setTime(date);
			rightNow.clear(Calendar.HOUR);
			rightNow.clear(Calendar.MINUTE);
			rightNow.clear(Calendar.SECOND);
			rightNow.clear(Calendar.MILLISECOND);
			today = rightNow.getTime();
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return today;
	}

	public java.util.Date date(java.util.Date date)   throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		Date today = null;
		try
		{
			rightNow.setTime(date);
			rightNow.clear(Calendar.HOUR);
			rightNow.clear(Calendar.MINUTE);
			rightNow.clear(Calendar.SECOND);
			rightNow.clear(Calendar.MILLISECOND);
			today = rightNow.getTime();
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return today;
	}

	public java.sql.Timestamp dateTime(java.util.Date ud) throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		Date today = null;
		java.sql.Timestamp ts = null;
		try
		{
			rightNow.setTime(ud);
			rightNow.clear(Calendar.HOUR);
			rightNow.clear(Calendar.MINUTE);
			rightNow.clear(Calendar.SECOND);
			rightNow.clear(Calendar.MILLISECOND);
			today = rightNow.getTime();
			ts = new java.sql.Timestamp(today.getTime());
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return ts;
	}

	public java.sql.Timestamp dateTime(java.sql.Date sd) throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		Date today = null;
		java.sql.Timestamp ts = null;
		try
		{
			rightNow.setTime(sd);
			rightNow.clear(Calendar.HOUR);
			rightNow.clear(Calendar.MINUTE);
			rightNow.clear(Calendar.SECOND);
			rightNow.clear(Calendar.MILLISECOND);
			today = rightNow.getTime();
			ts = new java.sql.Timestamp(today.getTime());
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return ts;
	}


	public java.sql.Timestamp dateTime(java.sql.Date sd, java.sql.Time sqlTime) throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		Date today = null;
		String timeStr = "";
		String timeStrArr[];
		java.sql.Timestamp ts = null;
		try
		{
			timeStr = sqlTime.toString();
			timeStrArr = timeStr.split(":");
			rightNow.setTime(sd);
			rightNow.set(Calendar.HOUR , Integer.parseInt(timeStrArr[0]));
			rightNow.set(Calendar.MINUTE,Integer.parseInt(timeStrArr[1]));
			rightNow.clear(Calendar.SECOND);
			rightNow.clear(Calendar.MILLISECOND);
			today = rightNow.getTime();
			ts = new java.sql.Timestamp(today.getTime());
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return ts;
	}

	public java.sql.Timestamp dateTime(java.util.Date ud, java.sql.Time sqlTime) throws ITMException
	{
		Calendar rightNow = Calendar.getInstance();
		Date today = null;
		String timeStr = "";
		String timeStrArr[];
		java.sql.Timestamp ts = null;
		try
		{
			timeStr = sqlTime.toString();
			timeStrArr = timeStr.split(":");
			rightNow.setTime(ud);
			rightNow.set(Calendar.HOUR , Integer.parseInt(timeStrArr[0]));
			rightNow.set(Calendar.MINUTE,Integer.parseInt(timeStrArr[1]));
			rightNow.clear(Calendar.SECOND);
			rightNow.clear(Calendar.MILLISECOND);
			today = rightNow.getTime();
			ts = new java.sql.Timestamp(today.getTime());
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return ts;
	}



	public double mod(double value1 , double value2)
	{
		return value1 % value2;
	}

	public double mod(double value1 , Double value2) throws ITMException
	{
		double d1 = 0;
		try
		{
			d1 = value1 % value2;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return d1;
     }

	public double mod(double value1 , int value2)
	{
		return value1 % value2;
	}

	public double mod(double value1 , Integer value2) throws ITMException
	{
		double d1 = 0;
 		try
		{
			d1 = value1 % value2;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return d1;
	}

	public double mod(int value1 , int value2)
	{
		return value1 % value2;
	}

	public double mod(int value1 , Integer value2) throws ITMException
	{
		double d1 = 0;
		try
		{
			d1 = value1 % value2;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return d1;
	}

	public double mod(int value1 , double value2)
	{
		return value1 % value2;
	}


	public double mod(int value1 , Double value2) throws ITMException
	{
		double d1 = 0;
		try
		{
			d1 = value1 % value2;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return d1;
	}

	public double mod(Integer value1 , Integer value2) throws ITMException
	{
		double d1 = 0;
		try
		{
			d1 = value1 % value2;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return d1;
	}

	public double mod(Integer value1 , int value2) throws ITMException
	{
		double d1 = 0;
		try
		{
			d1 = value1 % value2;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return d1;
	}

	public double mod(Integer value1 , double value2) throws ITMException
	{
		double d1 = 0;
		try
		{
			d1 = value1 % value2;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return d1;
	}

	public double mod(Integer value1 , Double value2) throws ITMException
	{
		double d1 = 0;
		try
		{
			d1 = value1 % value2;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return d1;
	}

	public double mod(Double value1 , Double value2) throws ITMException
	{
		double d1 = 0;
		try
		{
			d1 = value1 % value2;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return d1;
	}

	public double mod(Double value1 , double value2) throws ITMException
	{
		double d1 = 0;
		try
		{
			d1 = value1 % value2;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return d1;
	}

	public double mod(Double value1 , int value2) throws ITMException
	{
		double d1 = 0;
		try
		{
			d1 = value1 % value2;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return d1;
	}

	public double mod(Double value1 , Integer value2) throws ITMException
	{
		double d1 = 0;
		try
		{
			d1 = value1 % value2;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return d1;
	}

	/*
	public String mid( String lsStr, int start, int liColWidth )  throws ITMException
	{
		String str1 = null;
		try
		{
			str1 = lsStr.substring( start, liColWidth );
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return str1;
	}
	*/
	public String mid( String lsStr, int start, int liColWidth )  throws ITMException
	{
		String str1 = null;
		try
		{
			if (start > 0)
			{
				start = start - 1;
			}
			if (liColWidth > 0)
			{
				liColWidth = start + liColWidth;
			}
			str1 = lsStr.substring( start, liColWidth );
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return str1;
	}

	public String mid( String lsStr, int start )  throws ITMException
	{
		String str1 = null;
		try
		{
			if (start > 0)
			{
				start = start - 1;
			}
			str1 = lsStr.substring( start );
			
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return str1;
	}

	public String left( String src, int size ) throws ITMException
	{
		String str1 = null;
		try
		{
			if( src.length() < size)
			{
				size = src.length();
			}
			str1 = src.substring( 0, size );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return str1;
	}

	public String right( String src, int size ) throws ITMException
	{
		String str1 = null;
		try
		{
			if( src.length() < size )
			{
				str1 = "";
			}
			else
			{
				str1 = src.substring( src.length() - size );
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return str1;
	}

	public int pos( String str, String searchChar ) throws ITMException
	{
		int i1 = 0;
		try
		{
			i1 = str.indexOf( searchChar );
			if (i1 == -1)
			{
				i1 = 0;
			}
			else
			{
				i1 = i1 + 1;
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return i1;
	}

	public int pos( String str, String searchChar, int position ) throws ITMException
	{
		int i1 = 0;
		try
		{
			i1 = ( str.indexOf( searchChar, position ) == -1 ? 0 : str.indexOf( searchChar, position ) + 1 );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return i1 ;
	}

	public String space( int noOfSpaces )
	{
		String blankStr = null;
		blankStr = "";
		for( int cnt = 0; cnt < noOfSpaces ; cnt++ )
		{
			blankStr = blankStr + " ";
		}
		return blankStr;
	}

	public int getRowCount( Document dom, int formNo ) throws ITMException
	{
		int rowCount = 0;
		NodeList detailList = null;
		String detail = null;
		try
		{
			detail = "Detail" + formNo;
			detailList = dom.getElementsByTagName( detail );
			rowCount = detailList.getLength();
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return rowCount;
	}

	public boolean isnumber( String str )
	{
		int val;
		try
		{
			val = Integer.parseInt( str );
		}catch( NumberFormatException nex )
		{
			return false;
		}catch( Exception ex )
		{
			return false;
		}
		return true;
	}


	public String leftTrim(String str)  throws ITMException
	{
		String returnStr = null;
		try
		{
			if (str == null)
			{
				returnStr = null;
			}
			else if (str == null || str.trim().length() == 0)
			{
				returnStr = "";
			}
			else
			{
				StringBuilder sb = new StringBuilder(str);
				while (Character.isWhitespace(sb.charAt(0)))
				{
					sb.deleteCharAt(0); 
				}
				returnStr = sb.toString();
			}
		}
		catch (Exception e)
		{
			returnStr = null;
		}
		return returnStr;
	}

	public String rightTrim(String str)  throws ITMException
	{
		String returnStr = null;
		try
		{
			if (str == null)
			{
				returnStr = null;
			}
			else if (str == null || str.trim().length() == 0)
			{
				returnStr = "";
			}
			else
			{
				StringBuilder sb = new StringBuilder(str);
				while (Character.isWhitespace(sb.charAt(sb.length() - 1)))
				{
					sb.deleteCharAt(sb.length() - 1); 
				}
				returnStr = sb.toString();
			}
		}
		catch (Exception e)
		{
			returnStr = null;
		}
		return returnStr;
	}

	public String convertToString(int ival) throws ITMException
	{
		String returnStr = null;
		try
		{
			returnStr = String.valueOf(ival); 
		}
		catch (Exception e)
		{
			returnStr = null;
		}
		return returnStr;
	}

	public String convertToString(double dval) throws ITMException
	{
		String returnStr = null;
		try
		{
			returnStr = String.valueOf(dval); 
		}
		catch (Exception e)
		{
			returnStr = null;
		}
		return returnStr;
	}

	public String convertToString(Integer ival) throws ITMException
	{
		String returnStr = null;
		try
		{
			returnStr = ival.toString();
		}
		catch (Exception e)
		{
			returnStr = null;
		}
		return returnStr;
	}


	public int DaysAfter(Date d1, Date d2) throws ITMException
	{
		int noDays = 0;
		try
		{
			noDays = (int)( (d2.getTime() - d1.getTime()) / (1000 * 60 * 60 * 24));
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
		}
		return noDays;
	}

	public int DaysAfter(java.sql.Date d1, java.sql.Date d2) throws ITMException
	{
		int noDays = 0;
		try
		{
			noDays = (int)( (d2.getTime() - d1.getTime()) / (1000 * 60 * 60 * 24));
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return noDays;
	}

	public double convertMinutesToHours(int min)  throws ITMException
	{
		double hrs = 0d, dReminder = 0d;
		int i1 = 0, iSign = 1;
		try
		{
			if (min != 0)
			{
				if (min < 0)
				{
					iSign = -1;
					min = min * -1;
				}
				dReminder = mod(min , 60);
				i1 = (min  - (int)dReminder) / 60;
				hrs = i1 + (dReminder / 100.0);
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return (hrs * iSign);
	}

	public int convertTimeInMin(double dTime)  throws ITMException
	{
		double dReminder = 0d;
		int min = 0, iSign = 1;
		try
		{
			if (dTime != 0)
			{
				if (dTime < 0)
				{
					iSign = -1;
					dTime = dTime * -1d;
				}
				dReminder = mod(dTime , 1d);
				min = (int)(((dTime - dReminder) * 60) + (dReminder * 100));
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return (min * iSign);
	}

	public java.sql.Time stringToTime(String str) throws ITMException
	{
		java.sql.Time sTime = null;
		try
		{
			String[] s = str.split(":");
			if (s.length < 2)
			{
				str = str + ":00:00";
			}
			else if (s.length < 3)
			{
				str = str + ":00";
			}
			System.out.println("\r\nTime String :::"+ str + "\r\n");
			return sTime.valueOf(str);
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	
	public int upperBound(String strArr[]) throws ITMException
	{
		int iLength = 0;
		try
		{
			return strArr.length;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	public int upperBound(int intArr[]) throws ITMException
	{
		int iLength = 0;
		try
		{
			return intArr.length;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	public int upperBound(java.sql.Timestamp tsArr[]) throws ITMException
	{
		int iLength = 0;
		try
		{
			return tsArr.length;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	public int upperBound(java.sql.Date sdArr[]) throws ITMException
	{
		int iLength = 0;
		try
		{
			return sdArr.length;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	

	public int convertTimeInMin(java.sql.Time sqlTime)  throws ITMException
	{
		String timeStr = "";
		String timeStrArr[];
		int min = 0, iSign = 1;
		try
		{
			timeStr = sqlTime.toString();
			timeStrArr = timeStr.split(":");
			min = (Integer.parseInt(timeStrArr[0]) * 60) + (Integer.parseInt(timeStrArr[1]));
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return (min * iSign);
	}
	public int abs(int intVal)  throws ITMException
	{
		try
		{
			if (intVal < 0)
			{
				intVal = intVal * -1;
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return intVal;
	}
	public double abs(double dblVal)  throws ITMException
	{
		try
		{
			if (dblVal < 0d)
			{
				dblVal = dblVal * -1;
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return dblVal;
	}

	//***** Modified by Vishal on 23/06/2017.End


}
