
ALTER TABLE charge_back_det DROP CONSTRAINT CB_CHECK_NET_AMT_ZERO;

------------------------ TRIGGER------------------------------------
CREATE OR REPLACE
TRIGGER TRIG_MDRCR_VAL_CB_AMT 
before insert or update
on misc_drcr_rcp
referencing old as old new as new
for each row
declare
PRAGMA AUTONOMOUS_TRANSACTION; -- 03/Apr-15 add by manoharan to avoid mutating
iscb number(3);
cbnetamt number(14,3);
cbclaumamt number(14,3);
drcramt number(14,3);
diffamt number(14,3);
ll_count number(3) := 0;
begin
 if :new.sreturn_no is not null and length(trim(:new.sreturn_no)) > 0 then

  select count(*) into iscb from charge_back where tran_id = :new.sreturn_no;
  if iscb > 0 then
	--- 03-Apr-15 manoharan during insert check  already
		if inserting then
			begin
				select count(1) into ll_count from misc_drcr_rcp where sreturn_no = :new.sreturn_no;
			exception when others then
				ll_count := 0;
			end;
			if ll_count > 0 then
				raise_application_error (-20500,'Credit Note already created against the charge back');
			end if;
		end if;
	--- 03-Apr-15 manoharan during insert check  already

  begin
    cbnetamt := 0;
    cbclaumamt := 0;
    drcramt := 0;
    iscb := 0;
    select NVL(net_amt,0), NVL(claum_amt,0) into cbnetamt, cbclaumamt from charge_back where tran_id = :new.sreturn_no;
    if cbclaumamt <= 0 then
     begin
      drcramt := cbnetamt;
      cbclaumamt := 0;
     end;
    else
     if cbclaumamt < cbnetamt then
      drcramt := cbclaumamt;
      diffamt := nvl(:new.amount , 0) - nvl(drcramt , 0); 
      drcramt := drcramt + diffamt;
     else
      drcramt := cbnetamt;
     end if;
    end if;
    
    if :new.drcr_flag = 'D' then
    drcramt:= drcramt * (-1);
    end if;
    
    if abs(nvl(:new.amount , 0) - nvl(drcramt , 0)) > 0 then
    begin
    drcramt := nvl(:new.amount , 0); 
    end;
    end if;
    
    
    if abs(nvl(:new.amount , 0) - nvl(drcramt , 0)) > 0.999 then
     begin
      raise_application_error (-20500,'Credit Note Amount not same as charge back amount CB Amount: (' || drcramt || ')  CN Amount: (' || :new.amount || ')');
     end;
    end if;
   end;
  end if;
 end if;
end;

-------------------------------05-Jan-2017----------------------------------------------


Insert into finparm (PRD_CODE,VAR_NAME,VAR_TYPE,VAR_VALUE,CHG_DATE,CHG_USER,CHG_TERM,DESCR,VAR_SUBS,ADDL_VALUE)
values ('999999','ANAL_CODE','S','OO181',to_date('12-06-03','DD-MM-RR'),'BASE      ','99SYSTEM4      ','ANAL CODE',null,null);

update transetup set tax_forms = 2 ,tran_date_col = 'TRAN_DATE' where tran_window = 'w_charge_back_loc';

update transetup set tran_date_col = 'TRAN_DATE' where tran_window in ( 'w_misc_drcr_rcp_cr','w_misc_drcr_rcp_dr');

Insert into tenvseq (TAX_ENV,REF_SER,SEQ_NO,TAX_CODE,TAX_TABLE,TAX_TABLE__MARK,USE_MARKING,ACCT_CODE,CCTR_CODE,ACCT_CODE__REVR,CCTR_CODE__REVR) values ('DOMPUR-134','S-CHBL',10,'EXC  ','134',null,null,'3784      ',null,null,null);
Insert into tenvseq (TAX_ENV,REF_SER,SEQ_NO,TAX_CODE,TAX_TABLE,TAX_TABLE__MARK,USE_MARKING,ACCT_CODE,CCTR_CODE,ACCT_CODE__REVR,CCTR_CODE__REVR) values ('DOMPUR-134','S-CHBL',20,'ECESS','134',null,null,'3784      ',null,null,null);
Insert into tenvseq (TAX_ENV,REF_SER,SEQ_NO,TAX_CODE,TAX_TABLE,TAX_TABLE__MARK,USE_MARKING,ACCT_CODE,CCTR_CODE,ACCT_CODE__REVR,CCTR_CODE__REVR) values ('DOMPUR-134','S-CHBL',30,'SHEC ','134',null,null,'3784      ',null,null,null);


update obj_itemchange set mandatory = 'Y' where obj_name in ( 'misc_drcr_rcp_cr','misc_drcr_rcp_dr') and field_name in ('itm_default','site_code','sundry_code');


update OBJ_FORMS set qty_col = 'quantity' ,rate_col = 'rate__diff' where win_name = 'w_charge_back_loc' and form_no = 2;

Insert into tenvseq (TAX_ENV,REF_SER,SEQ_NO,TAX_CODE,TAX_TABLE,TAX_TABLE__MARK,USE_MARKING,ACCT_CODE,CCTR_CODE,ACCT_CODE__REVR,CCTR_CODE__REVR)
values ('TC1       ','      ',10,'TC1  ','1S ',null,null,null,null,null,null);
Insert into tenvseq (TAX_ENV,REF_SER,SEQ_NO,TAX_CODE,TAX_TABLE,TAX_TABLE__MARK,USE_MARKING,ACCT_CODE,CCTR_CODE,ACCT_CODE__REVR,CCTR_CODE__REVR) 
values ('TC1       ','      ',11,'TC2  ','1S ',null,null,null,null,null,null);



