package ibase.webitm.ejb.dis;
import ibase.webitm.utility.*;

import org.w3c.dom.*;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.system.config.*;

import java.rmi.RemoteException;
import java.util.*;
import java.text.*;
import java.sql.*;

import javax.ejb.*;

import java.util.Calendar;
import java.util.Date;

import javax.naming.InitialContext;

import ibase.system.config.AppConnectParm;


//import ibase.webitm.ejb.MasterStateful;
//import ibase.webitm.ejb.MasterStatefulHome;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;

import javax.xml.rpc.ParameterMode;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3
public class ChrgBckLocConf extends ActionHandlerEJB implements ChrgBckLocConfLocal, ChrgBckLocConfRemote
{
	//GenericUtility genericUtility = GenericUtility.getInstance();
	E12GenericUtility genericUtility= new  E12GenericUtility();
	String userId ="";
	String termId = "";
	String loginSite = "";
	
	FinCommon finCommon = new FinCommon();
	/* public void ejbCreate() throws RemoteException, CreateException
	{
		System.out.println("Create Method Called....");
	}
	public void ejbRemove()
	{
	}
	public void ejbActivate()
	{
	}
	public void ejbPassivate()
	{
	} */
	public String confirm() throws RemoteException,ITMException
	{
		System.out.println("confirm() Method Called....");
		return "";
	}
	public String confirm(String xmlString, String xtraParams, String objContext) throws RemoteException,ITMException
	{
		String  retString = null;
		System.out.println("Xtra Params : " + xtraParams);
		//genericUtility = GenericUtility.getInstance();
		try
		{
			retString = actionConfirm(xmlString, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :actionHandler(String xmlString):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning from  actionHandler"+retString);
		return (retString);
	}
	private String actionConfirm(String tranID, String xtraParams) throws RemoteException,ITMException, Exception
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int cnt = 0;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		ConnDriver connDriver = new ConnDriver();
		String sql = "";
		String siteCode = "";
		String custCode = "";
		String empCode = "";
		String confirmed = "";
		double netAmt = 0;  //Added for debit note creation
		userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
		loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
		empCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
		termId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "termId" );
		java.sql.Timestamp currDate = null;
		java.sql.Timestamp tranDate = null;
		String returnString = null;
		boolean conFlag = false;
		String errStr = "";
		Timestamp sysDate = null;

		try
		{
			//Changes and Commented By Bhushan on 09-06-2016 :START
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changes and Commented By Bhushan on 09-06-2016 :END 
			conn.setAutoCommit(false);
			connDriver = null;
			currDate = new Timestamp( System.currentTimeMillis() );
			/*sql = "select tran_id, tran_date, site_code, cust_code, confirmed "
			  +"	from charge_back "
			  +" where tran_id = ? ";*/ // sql comment by sagar on 13/07/15
			System.out.println(">>>>CommonConstants.DB_NAME:"+ CommonConstants.DB_NAME);
			if("db2".equalsIgnoreCase(CommonConstants.DB_NAME)) // conditions is added by sagar on 13/07/15 
			{
				sql = " select tran_id, tran_date, site_code, cust_code, confirmed,net_amt " 
					+ " from charge_back where tran_id = ? for update ";

			}
			else if("mssql".equalsIgnoreCase(CommonConstants.DB_NAME))
			{
				sql = " select tran_id, tran_date, site_code, cust_code, confirmed,net_amt "
					+ " from charge_back (updlock) where tran_id = ? ";

			}
			else 
			{
				System.out.println(">>>Oracle:");
				/*sql = " select tran_id, tran_date, site_code, cust_code, confirmed "
					+ " from charge_back where tran_id = ? for update nowait ";*/
				
				sql = " select tran_id, tran_date, site_code, cust_code, confirmed,net_amt "
						+ " from charge_back where tran_id = ? for update nowait ";
			}
			System.out.println(">>>>ChrgBckLocConf sql:"+ sql);
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, tranID );
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				tranDate = rs.getTimestamp("tran_date");
				siteCode = rs.getString("site_code");
				custCode = rs.getString("cust_code");
				confirmed = rs.getString("confirmed");
				netAmt = rs.getDouble("net_amt"); //ADDED FOR AMOUNT COMPARISION FOR CREATION OF CR OR DR NOTE
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if( confirmed != null && confirmed.trim().equals("Y") )
			{
				errStr = "TRNADYCONF";
				returnString = itmDBAccessEJB.getErrorString("",errStr,userId);
				return returnString;
			}
			/**
			 * VALLABH KADAM 22/JUN/15
			 * While verification
			 * If the Transaction is already 'CANCEL'
			 * that is STATUS='X'
			 * The Confirmed is not allow [VTCNCLCNFL]
			 * Req Id :- [D15BSUN003]
			 * */
			sql = " select  count(*) from charge_back where tran_id = ? and status = 'X'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranID.trim());
			rs = pstmt.executeQuery();
			if(rs.next()) 
			{
				cnt  = rs.getInt(1);
			}if(rs != null)
				rs.close();
			rs = null;
			if(pstmt != null)
				pstmt.close();
			pstmt=null;
			if(cnt > 0)
			{
				errStr = "VTCNCLCNFL";
				returnString = itmDBAccessEJB.getErrorString("",errStr,userId);
				return returnString;			    
			}

			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDateStr = sdf.format(currentDate.getTime());
			System.out.println(">>>>>>>Now sysDateStr :=>  " + sysDateStr +"netAmt>>>"+netAmt);	
			sysDate= Timestamp.valueOf(genericUtility.getValidDateString(sysDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) + " 00:00:00.0");
			System.out.println(">>>>>>>>sysDate:"+sysDate);	

			sql = "update charge_back set "
				+" confirmed = 'Y', "
				+" VERIFY_FLAG = 'Y', "
				+" conf_date = ?, "
				+" emp_code__aprv = ?,"
				+ "STATUS='A',"//VALLABH KADAM STATUS='A' as APPROVE
				+ " STATUS_DATE=?" //VALLABH KADAM STATUS_DATE
				+" where tran_id = ? ";
			// +" and confirmed <> 'Y' ";
			System.out.println( "upd sql " + sql );
			pstmt = conn.prepareStatement( sql );
			pstmt.setTimestamp( 1, currDate );
			pstmt.setString( 2, empCode );
			pstmt.setTimestamp(3, sysDate);
			pstmt.setString( 4, tranID );
			int chkupdt = pstmt.executeUpdate();
			System.out.println("chkupdt==>"+ chkupdt);

			pstmt.close();
			pstmt = null;
			// 02/07/13 manoharan time value to be removed
			currDate = new java.sql.Timestamp(System.currentTimeMillis()) ;
			String currAppdate = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(currDate).toString();
			currDate = Timestamp.valueOf(genericUtility.getValidDateString( currAppdate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0") ;
			// end 02/07/13 manoharan time value to be removed
			if( chkupdt > 0) // condition is added by sagar on 13/07/15 
			{
				
				if(netAmt > 0)
				{
					returnString = createMiscCrnoteCback(currDate, "", siteCode, tranID, tranID, tranDate, tranDate, custCode, custCode, "Y", xtraParams, conn );
				}
				else  // Added for Debit note generation if amt < 0: Start
				{
					returnString = createMiscDrnoteCback(currDate, "", siteCode, tranID, tranID, tranDate, tranDate, custCode, custCode, "Y", xtraParams, conn );
				}
				// Added for Debit note generation if amt < 0 :End
				if( returnString .equals("VTSUCC1") )
				{
					conFlag = true;
					errStr = "TRANCONFSC";
				}
				else
				{
					conFlag = false;
					errStr = returnString;
				}
				returnString = itmDBAccessEJB.getErrorString("",errStr,userId); 
			}
			else
			{
				System.out.println(">>>Record not updated for charge_back:");
				returnString = itmDBAccessEJB.getErrorString("", "VTTRNCNFM2", userId);
			}
		}
		catch(Exception e)
		{
			System.out.println("ChrgBckLocConfEJB..."+e.getMessage());
			e.printStackTrace();
			try
			{
				conn.rollback();
			}
			catch(Exception e1)
			{
				System.out.println("ChrgBckLocConfEJB..."+e1.getMessage());
				e1.printStackTrace();
			}
		}
		finally
		{
			try
			{
				if(conFlag)
				{
					System.out.println("Commiting connection.......");
					conn.commit();
				}
				else
				{
					System.out.println("Connection Rollback.......");
					conn.rollback();
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception ChrgBckLocConfEJB....... :\n"+e.getMessage());
			}
		}
		System.out.println("retString ::"+returnString);
		return returnString;
	}
	/*private String createMiscCrnoteCback(Timestamp currDate, String str, String siteCode, String tranIdFr, String tranIdTo, Timestamp tranDateFr, Timestamp tranDateTo, String custCodeFr, String custCodeTo, String confirm, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		System.out.println("Inside createMiscCrnoteCback................");
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmtHdr = null;
		PreparedStatement pstmtDtl = null;
		ResultSet rs = null;
		//Statement stmt = null;
		ResultSet rSet = null;
		String sql = null;
		String custCodeCr = "";
		String currCode = "";
		String finEntity = "";
		String acctCode = "";
		String cctrCode = "";
		String empCodeAprv = "";
		String tranIdSel = "";
		String pOrderNo = "";
		String siteCodeCr = "";
		String itemSer = "";
		String remarks = "";
		String detAcct = "";
		String errCode = "";
		String retString = "";
		String detCctr = "";
		String tranType = "";
		String reasonCd = "";
		String crNtTranId = "";
		String acctCodeTax = "";
		String cctrCodeTax = "";
		String round = "";
		String insDtlsql = "";
		String asPost = confirm;
		double roundTo = 0.0;
		double exchgRate = 0.0;
		double netAmt = 0.0;
		double claimAmt = 0.0;
		double grossAmount = 0.0;
		double drcrAmt = 0.0;
		double amtTax = 0.0;
		double total = 0.0;
		double roundAmt = 0.0;
		double diffAmt = 0.0;
		double discountAmt = 0.0;
		int llLineNo = 0;
		java.sql.Timestamp tranDate = null;
		java.sql.Timestamp pOrderDate = null;
		String insHdrSql = "insert into MISC_DRCR_RCP ( "
			+" TRAN_ID, TRAN_SER, TRAN_DATE, EFF_DATE, FIN_ENTITY, "
			+" SITE_CODE, SUNDRY_TYPE, SUNDRY_CODE, ACCT_CODE, CCTR_CODE, "
			+" AMOUNT, CURR_CODE, EXCH_RATE, REMARKS, DRCR_FLAG, "
			+" TRAN_ID__RCV, CONFIRMED, CHG_USER, CHG_DATE, CHG_TERM, "
			+" CONF_DATE, EMP_CODE__APRV, DUE_DATE, TRAN_TYPE, ITEM_SER, "
			+" AMOUNT__BC, SRETURN_NO, ADJ_MISC_CRN, ADJ_AMOUNT, PARENT__TRAN_ID, "
			+" REV__TRAN, ROUND_ADJ, "
			+" CUST_REF_NO, CUST_REF_DATE, CUST_REF_AMT, RND_OFF, RND_TO ) "
			+" values ( "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?  ) ";

		String insertDtl = "insert into MISC_DRCR_RDET( "
			+" TRAN_ID, LINE_NO, ACCT_CODE, CCTR_CODE, AMOUNT, "
			+" NET_AMT, REF_NO, REAS_CODE, ANAL_CODE"
			+" ) values ( "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ? )";

		DistCommon disComm = new DistCommon();

		try
		{	
			pstmtHdr = conn.prepareStatement( insHdrSql );
			pstmtDtl = conn.prepareStatement( insertDtl );
			sql = "select a.cust_code__credit, a.curr_code, a.exch_rate, a.emp_code__aprv, a.tran_id, "
				+" a.net_amt, a.porder_no, a.porder_date, a.claum_amt, a.site_code__cr, a.item_ser, "
				+" a.amount, a.remarks, sum(b.discount_amt) as discAmt "
				+" from charge_back a, charge_back_det b "
				+"	where a.tran_id = b.tran_id "
				+" and a.tran_id >= ? "
				+" and	a.tran_id <= ? "
				+" and a.tran_date >= ? "
				+" and a.tran_date <= ? "
				+" and a.cust_code >= ? "
				+" and a.cust_code <= ? "
				+" and a.site_code = ? "
				// +" and a.confirmed = 'Y' "
				+" group by a.cust_code__credit, a.curr_code, a.exch_rate, a.emp_code__aprv, a.tran_id, "
				+" a.net_amt, a.porder_no, a.porder_date, a.claum_amt, a.site_code__cr, a.item_ser, "
				+" a.amount, a.remarks";

			pstmt = conn.prepareStatement( sql );
			pstmt.setString( 1, tranIdFr );
			pstmt.setString( 2, tranIdTo );
			pstmt.setTimestamp( 3, tranDateFr );
			pstmt.setTimestamp( 4, tranDateTo );
			pstmt.setString( 5, custCodeFr );
			pstmt.setString( 6, custCodeTo );
			pstmt.setString( 7, siteCode );

			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				custCodeCr = rs.getString("cust_code__credit");
				currCode = rs.getString("curr_code");
				exchgRate = rs.getDouble("exch_rate");
				empCodeAprv = rs.getString("emp_code__aprv");
				tranIdSel = rs.getString("tran_id");
				netAmt = rs.getDouble("net_amt");
				pOrderNo = rs.getString("porder_no");
				pOrderDate = rs.getTimestamp("porder_date");
				claimAmt = rs.getDouble("claum_amt");
				siteCodeCr = rs.getString("site_code__cr");
				itemSer = rs.getString("item_ser");
				grossAmount = rs.getDouble("amount");
				remarks = rs.getString("remarks");
				discountAmt = rs.getDouble("discAmt");

				//System.out.println("claimAmt==>["+claimAmt+"]");
				//System.out.println("netAmt==>["+netAmt+"]");
				//System.out.println("grossAmount ie amount==>["+grossAmount+"]");
				if( siteCodeCr == null || siteCodeCr.trim().length() == 0 )
				{
					siteCodeCr = siteCode;
				}

				sql = "select fin_entity from site where site_code = ?" ;
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, siteCodeCr.trim() );
				rSet = pstmt1.executeQuery();
				if( rSet.next() )
				{
					finEntity = rSet.getString( "fin_entity" );
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;

				sql = "select acct_code__ar, cctr_code__ar from customer where cust_code = ? " ;
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, custCodeCr.trim() );
				rSet = pstmt1.executeQuery();
				if( rSet.next() )
				{
					acctCode = rSet.getString( "acct_code__ar" );
					cctrCode = rSet.getString( "cctr_code__ar" );
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;
				// 21/07/10 manoharan make cctr_code blank in case null
				if (cctrCode == null)
				{
					cctrCode = "     ";
				}
				// end 21/07/10
				detAcct = disComm.getDisparams( "999999", "DRCR_ACCT_CBACK", conn );

				if( detAcct == null || detAcct.equalsIgnoreCase( "NULLFOUND" ) || detAcct.trim().length() == 0 )
				{
					errCode = "VMDRCRACCT"; //'DS000' + string(sqlca.sqldbcode)
					break;
				}

				detCctr = disComm.getDisparams( "999999", "DRCR_CCTR_CBACK", conn );

				if( detCctr == null || detCctr.equalsIgnoreCase( "NULLFOUND" ) || detCctr.trim().length() == 0 )
				{
					// 21/07/10 manoharan if cctr_code is null then assign as cctr_code__ar (blank included)
					//errCode = "VMLSCCTR"; //'DS000' + string(sqlca.sqldbcode)
					//break;
					detCctr = cctrCode;
					// end 21/07/10 manoharan if cctr_code is null then assign as cctr_code__ar (blank included)
				}

				tranType = disComm.getDisparams( "999999", "CHARGE_BACK_TRAN_TYPE", conn );

				if( tranType == null || tranType.equalsIgnoreCase( "NULLFOUND" ) || tranType.trim().length() == 0 )
				{
					errCode = "VMLSTRTYPE"; //'DS000' + string(sqlca.sqldbcode)
					break;
				}

				reasonCd = disComm.getDisparams( "999999", "CHARGE_BACK_REASON_CODE", conn );
				System.out.println( "reasonCd ::" + reasonCd );
				if( reasonCd == null || reasonCd.equalsIgnoreCase( "NULLFOUND" ) || reasonCd.trim().length() == 0 )
				{
					errCode = "VMREASON"; //'DS000' + string(sqlca.sqldbcode)
					break;
				}
				if( claimAmt <= 0 )
				{
					claimAmt = 0;
					drcrAmt = netAmt;
				}
				else
				{
					drcrAmt = claimAmt < netAmt ? claimAmt : netAmt;
				}

				//crNtTranId = generateTranId("W_MISC_DRCR_RCP_CR", getCurrdateInAppFormat(), loginSite, userId, tranType );
				crNtTranId = generateTranId("W_MISC_DRCR_RCP_CR", getCurrdateInAppFormat(), siteCodeCr, userId, tranType );
				//-----------------------Inserting into header-----------------------------------
				pstmtHdr.setString( 1, crNtTranId );
				pstmtHdr.setString( 2, "MDRCRC" );
				pstmtHdr.setTimestamp( 3, currDate );
				pstmtHdr.setTimestamp( 4, currDate );
				pstmtHdr.setString( 5, finEntity );
				pstmtHdr.setString( 6, siteCodeCr);
				pstmtHdr.setString( 7, "C" );
				pstmtHdr.setString( 8, custCodeCr );
				pstmtHdr.setString( 9, acctCode == null ? "" : acctCode );
				pstmtHdr.setString( 10, cctrCode == null ? "    " : cctrCode );
				sql = "select nvl(round,'N') ls_round, nvl(round_to,0.001) lc_round_to from customer where cust_code = ? ";
				pstmt1 = conn.prepareStatement( sql );
				pstmt1.setString(1, custCodeCr );
				rSet = pstmt1.executeQuery();
				if( rSet.next() )
				{
					round = rSet.getString( "ls_round" );
					roundTo = rSet.getDouble( "lc_round_to" );
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;

				roundAmt = disComm.getRndamt( drcrAmt, round, roundTo );
				
				System.out.println("drcrAmt in CREDIT note["+drcrAmt+"]roundAmt["+roundAmt);
				diffAmt = roundAmt - drcrAmt;

				//pstmtHdr.setDouble( 11, drcrAmt );
				pstmtHdr.setDouble( 11, roundAmt );
				pstmtHdr.setString( 12, currCode == null || currCode.trim().length() == 0 ? "" : currCode);
				pstmtHdr.setDouble( 13, exchgRate );

				if( remarks == null || remarks.trim().length() == 0 )
				{
					String tRemStr = null;
					System.out.println("tranIdSel->"+tranIdSel+" pOrderNo->"+pOrderNo+" pOrderDate->"+pOrderDate);
					tRemStr = ( "CB " + tranIdSel );
					pstmtHdr.setString( 14, tRemStr );
				}
				else
				{
					pstmtHdr.setString( 14, remarks.trim() );
				}
				pstmtHdr.setString( 15, "C" );
				pstmtHdr.setString( 16, "" );
				pstmtHdr.setString( 17, "N" );
				pstmtHdr.setString( 18, userId );
				pstmtHdr.setTimestamp( 19, currDate );
				pstmtHdr.setString( 20, termId );
				pstmtHdr.setNull( 21, java.sql.Types.DATE );
				pstmtHdr.setString( 22, empCodeAprv );
				pstmtHdr.setTimestamp( 23, currDate );
				pstmtHdr.setString( 24, ( tranType == null || tranType.trim().length() == 0 ? "" :tranType.trim() ) );
				pstmtHdr.setString( 25, ( itemSer == null || itemSer.trim().length() == 0 ? "" : itemSer.trim() ) );
				//pstmtHdr.setDouble( 26, drcrAmt );
				pstmtHdr.setDouble( 26, roundAmt * exchgRate);
				pstmtHdr.setString( 27, ( tranIdSel == null || tranIdSel.trim().length() == 0 ? "" :  tranIdSel.trim() ) );
				pstmtHdr.setString( 28, "" ); //ADJ_MISC_CRN
				pstmtHdr.setDouble( 29, 0.0 ); //ADJ_AMOUNT
				pstmtHdr.setString( 30, "" ); //PARENT__TRAN_ID
				pstmtHdr.setString( 31, "" ); //REV__TRAN
				pstmtHdr.setDouble( 32, 0.0 ); //ROUND_ADJ
				//pstmt.setInt( 33, 0 ); //LINE_NO__SRET
				//pstmt.setInt( 34, 0 ); //LINE_NO__SRET
				//pstmt.setString( 35, "" ); //LOT_NO
				pstmtHdr.setString( 33, "" ); //CUST_REF_NO
				pstmtHdr.setNull( 34, java.sql.Types.DATE ); //CUST_REF_DATE
				pstmtHdr.setDouble( 35, 0.0 ); //CUST_REF_AMT
				pstmtHdr.setDouble( 36, 0.0 ); //RND_OFF
				pstmtHdr.setDouble( 37, 0.0 ); //RND_TO

				int updtCnt = pstmtHdr.executeUpdate();
				//System.out.println("updtCnt==>"+updtCnt);
				//-----------------------Inserting into detail-----------------------------------
				llLineNo = 0;
				pstmtDtl.setString( 1, crNtTranId );
				llLineNo++;
				pstmtDtl.setInt( 2, llLineNo );
				pstmtDtl.setString( 3, detAcct );
				pstmtDtl.setString( 4, detCctr );
				if( claimAmt > 0 && claimAmt < netAmt )
				{
					pstmtDtl.setDouble( 5, drcrAmt );
					pstmtDtl.setDouble( 6, drcrAmt );
				}
				else
				{
					pstmtDtl.setDouble( 5, grossAmount );
					pstmtDtl.setDouble( 6, grossAmount );
				}
				pstmtDtl.setString( 7, tranIdSel ); //ref_no
				pstmtDtl.setString( 8, ( reasonCd == null || reasonCd.trim().length() == 0 ? "" : reasonCd.trim() ) ); //reas_code
				pstmtDtl.setString( 9, "" ); //ANAL_CODE

				pstmtDtl.addBatch();

				sql = "select acct_code, cctr_code, sum(tax_amt) taxamt "
					+" from taxtran "
					+" where tran_code = 'S-CHB' and tran_id = ? "
					+" and tax_amt <> 0 "
					+" and effect <> 'N' "
					+" group by acct_code, cctr_code " ;
				//
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, tranIdSel);
				rSet = pstmt1.executeQuery();
				while( rSet.next() )
				{
					acctCodeTax = rSet.getString( "acct_code" );
					cctrCodeTax = rSet.getString( "acct_code" );
					amtTax =  rSet.getDouble( "taxamt" );

					if( acctCodeTax == null || acctCodeTax.trim().length() == 0 )
					{
						acctCodeTax = detAcct;
					}
					if( cctrCodeTax == null || cctrCodeTax.trim().length() == 0 )
					{
						cctrCodeTax = detCctr;
					}

					total = total + amtTax;

					pstmtDtl.setString( 1, crNtTranId );

					llLineNo++;
					pstmtDtl.setInt( 2, llLineNo );
					pstmtDtl.setString( 3, acctCodeTax );
					pstmtDtl.setString( 4, cctrCodeTax );
					pstmtDtl.setDouble( 5, amtTax);
					pstmtDtl.setDouble( 6, 0.0 );
					pstmtDtl.setString( 7, "" ); //ref_no
					pstmtDtl.setString( 8, "" ); //reas_code
					pstmtDtl.setString( 9, "" ); //ANAL_CODE

					pstmtDtl.addBatch();
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;

				pstmtDtl.executeBatch();

				pstmtDtl.close();
				pstmtDtl = null;
				pstmtHdr.close();
				pstmtHdr = null;

				sql = "update charge_back set "
					+" tran_id__crn = ? "
					+" where tran_id = ? ";

				pstmt1 = conn.prepareStatement( sql );
				pstmt1.setString(1, crNtTranId );
				pstmt1.setString(2, tranIdSel );
				int updCount = 0 ;
				updCount = pstmt1.executeUpdate();

				if( updCount == 0 )
				{
					errCode = "DS000NR";
					break;
				}
				pstmt1.close();
				pstmt1 = null;

				sql = "select nvl(round,'N') ls_round, nvl(round_to,0.001) lc_round_to from customer where cust_code = ? ";
				pstmt1 = conn.prepareStatement( sql );
				pstmt1.setString(1, custCodeCr );
				rSet = pstmt1.executeQuery();
				if( rSet.next() )
				{
					round = rSet.getString( "ls_round" );
					roundTo = rSet.getDouble( "lc_round_to" );
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;

				roundAmt = disComm.getRndamt( drcrAmt, round, roundTo );
				diffAmt = roundAmt - drcrAmt;
				
				System.out.println("diffAmt IN CR["+diffAmt+"]");
				if( diffAmt != 0 )
				{
					//1. update header
					//2. insert record in detail
					insDtlsql = "insert into MISC_DRCR_RDET( "
						+" TRAN_ID, LINE_NO, ACCT_CODE, CCTR_CODE, AMOUNT, "
						+" NET_AMT, REF_NO, REAS_CODE, ANAL_CODE, TAX_AMT"
						+" ) values ( "
						+" ?, ?, ?, ?, ?, "
						+" ?, ?, ?, ?, ? )";
					pstmt1 = conn.prepareStatement( insDtlsql );
					pstmt1.setString( 1, crNtTranId );

					llLineNo++;

					pstmt1.setInt( 2, llLineNo );
					pstmt1.setString( 3, detAcct );
					pstmt1.setString( 4, detCctr );
					pstmt1.setDouble( 5, -diffAmt);
					pstmt1.setDouble( 6, -diffAmt );
					pstmt1.setString( 7, "" ); //ref_no
					pstmt1.setString( 8, reasonCd.trim() ); //reas_code
					pstmt1.setString( 9, "" ); //ANAL_CODE
					pstmt1.setDouble( 10, 0 );

					pstmt1.executeUpdate();

					pstmt1.close();
					pstmt1 = null;
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if( "Y".equalsIgnoreCase( asPost )  )
			{
				conn.commit();
				retString = retrieveMiscDrcrRcp( "misc_drcr_rcp",crNtTranId,xtraParams,"N" );
				errCode = getErrCodeFromErrStr(retString);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtDtl != null)
				{
					pstmtDtl.close();
					pstmtDtl = null;
				}
				if(pstmtHdr != null)
				{
					pstmtHdr.close();
					pstmtHdr = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception ChrgBckLocConfEJB....... :\n"+e.getMessage());
			}
		}
		return errCode;
	}*/
	public String retrieveMiscDrcrRcp(String businessObj, String tranIdFr,String xtraParams, String forcedFlag) throws ITMException
	{
		String methodName = "";
		String compName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		String sql = "";
		Connection conn = null;
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		int cnt = 0;

		try
		{
			ConnDriver connDriver = new ConnDriver();
			//Changes and Commented By Bhushan on 09-06-2016 :START
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changes and Commented By Bhushan on 09-06-2016 :END 
			conn.setAutoCommit(false);
			methodName = "gbf_post";
			actionURI = "http://NvoServiceurl.org/" + methodName;

			sql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = 'pre_confirm' ";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1,businessObj);
			rs = pStmt.executeQuery();
			if ( rs.next() )
			{
				serviceCode = rs.getString("SERVICE_CODE");
				compName = rs.getString("COMP_NAME");
			}
			// Changed by Manish on 01/04/16 for max cursor issue [start]
			if (pStmt != null)
			{
				pStmt.close();
				pStmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			// Changed by Manish on 01/04/16 for max cursor issue [end]
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1,serviceCode);
			rs = pStmt.executeQuery();
			if ( rs.next() )
			{
				serviceURI = rs.getString("SERVICE_URI");
			}
			// Changed by Manish on 01/04/16 for max cursor issue [start]
			if (pStmt != null)
			{
				pStmt.close();
				pStmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			// Changed by Manish on 01/04/16 for max cursor issue [end]
			Service service = new Service();
			Call call = (Call)service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(serviceURI));			
			call.setOperationName( new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName ) );
			call.setUseSOAPAction(true);
			call.setSOAPActionURI(actionURI); 
			Object[] aobj = new Object[4];

			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

			aobj[0] = new String(compName);
			aobj[1] = new String(tranIdFr);
			aobj[2] = new String(xtraParams);
			aobj[3] = new String(forcedFlag);

			call.setReturnType(XMLType.XSD_STRING);
			retString = (String)call.invoke(aobj);
			System.out.println("Return string from NVO is:==>["+retString+"]");	
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				if (rs !=null)
				{
					rs.close();
					rs=null;
				}
				if( conn != null ){
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{}
		}
		return retString;
	}
	private String getCurrdateInAppFormat()
	{
		String currAppdate =null;
		java.sql.Timestamp currDate = null;
		Object date = null;
		SimpleDateFormat DBDate=null;
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility= new  E12GenericUtility();
		try
		{
			currDate =new java.sql.Timestamp(System.currentTimeMillis()) ;
			System.out.println( genericUtility.getDBDateFormat());
			DBDate= new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = DBDate.parse(currDate.toString());
			currDate =	java.sql.Timestamp.valueOf(DBDate.format(date).toString() + " 00:00:00.0");
			currAppdate = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(currDate).toString();
		}
		catch(Exception e)
		{
			System.out.println("Exception in  getCurrdateInAppFormat:::"+e.getMessage());
		}
		return (currAppdate);
	}
	private String generateTranId(String windowName, String tranDate, String siteCode ,String signBy,String tranType)
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String generateTranIdSql = null;
		String tranId = null;
		String xmlValues = null;
		StringBuffer xmlValuesBuff = new StringBuffer();
		String refSer = "";
		String keyString = "";
		String tranIdCol = "";
		try
		{
			ConnDriver connDriver = new ConnDriver();
			//Changes and Commented By Bhushan on 13-06-2016 :START
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changes and Commented By Bhushan on 13-06-2016 :END
			conn.setAutoCommit(false);
			generateTranIdSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE UPPER(TRAN_WINDOW)= ?";
			System.out.println("[ChargeBackLocConfEJB :: generateTranId : input Paramaters][windowName]["+windowName+"][tranDate]["+tranDate+"][siteCode]["+siteCode+"]");
			System.out.println( "[ChargeBackLocConfEJB : generateTranId : Tran generator Sql[" + generateTranIdSql+"]" );
			pstmt = conn.prepareStatement( generateTranIdSql );
			pstmt.setString(1, windowName);
			rs = pstmt.executeQuery();

			if( rs.next() )
			{
				keyString = rs.getString("KEY_STRING");
				tranIdCol = rs.getString("TRAN_ID_COL");
				refSer = rs.getString("REF_SER");
			}
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			System.out.println("[Output of Tran generator Sql ][keyString]["+keyString+"][tranIdCol]["+tranIdCol+"][refSer]["+refSer+"]");	

			xmlValuesBuff.append("<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>");
			xmlValuesBuff.append("<Header></Header>");
			xmlValuesBuff.append("<Detail1>");
			xmlValuesBuff.append("<tran_id></tran_id>");
			xmlValuesBuff.append("<site_code><![CDATA["+siteCode+"]]></site_code>");
			xmlValuesBuff.append("<tran_date><![CDATA["+tranDate+"]]></tran_date>");
			xmlValuesBuff.append("<vouch_type><![CDATA[F]]></vouch_type>");
			xmlValuesBuff.append("<tran_type><![CDATA["+tranType+"]]></tran_type>");
			// 20/07/10 manoharan drcr_flag added
			xmlValuesBuff.append("<drcr_flag><![CDATA[C]]></drcr_flag>");
			// end 20/07/10 manoharan drcr_flag added
			xmlValuesBuff.append("</Detail1></Root>");
			xmlValues = xmlValuesBuff.toString();
			System.out.println("xmlValues  :[" + xmlValues + "]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues,signBy, CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(refSer, tranIdCol, keyString, conn);
			System.out.println("tranId :"+tranId);
			conn.commit();
		}
		catch (SQLException ex)
		{			
			ex.printStackTrace();
		}
		catch (Exception e)
		{		
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if( conn != null ){
					conn.close();
					conn = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return tranId;
	}
	private String getErrCodeFromErrStr( String errStr ) throws RemoteException,ITMException
	{
		String retErrCode = null;

		try
		{
			Document ParseRetString = genericUtility.parseString( errStr );
			NodeList RetStringNodeList = ParseRetString.getElementsByTagName("error");
			Node RetStringNode = RetStringNodeList.item(0);
			retErrCode = RetStringNode.getAttributes().getNamedItem("id").getNodeValue();
		}
		catch(Exception exception)
		{
			exception.printStackTrace();
			throw new ITMException( exception );
		}
		return retErrCode;		
	}
	
	private String createMiscCrnoteCback(Timestamp currDate, String str, String siteCode, String tranIdFr, String tranIdTo, Timestamp tranDateFr, Timestamp tranDateTo, String custCodeFr, String custCodeTo, String confirm, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		System.out.println("Inside createMiscDrnoteCback................");
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmtHdr = null;
		PreparedStatement pstmtDtl = null;
		ResultSet rs = null;
		Statement stmt = null;
		ResultSet rSet = null;
		String sql = null;
		String custCodeCr = "";
		String currCode = "";
		String finEntity = "";
		String acctCode = "";
		String cctrCode = "";
		String empCodeAprv = "";
		String tranIdSel = "";
		String pOrderNo = "";
		String siteCodeCr = "";
		String itemSer = "";
		String remarks = "";
		String detAcct = "";
		String errCode = "";
		String retString = "";
		String detCctr = "";
		String tranType = "";
		String reasonCd = "";
		String drNtTranId = "";
		String acctCodeTax = "";
		String cctrCodeTax = "";
		String round = "";
		String insDtlsql = "";
		String asPost = confirm;
		double roundTo = 0.0;
		double exchgRate = 0.0;
		double netAmt = 0.0;
		double claimAmt = 0.0;
		double grossAmount = 0.0;
		double drcrAmt = 0.0;
		double amtTax = 0.0;
		double total = 0.0;
		double roundAmt = 0.0;
		double diffAmt = 0.0;
		double discountAmt = 0.0 ,taxAmt = 0.0;
		int llLineNo = 0;
		java.sql.Timestamp tranDate = null;
		java.sql.Timestamp pOrderDate = null;
		
		StringBuffer xmlBuff = null;
		StringBuffer xmlBuffDet = null;
		String xmlString="",errString = "",taxClass = "",taxEnv = "",taxChap = "",analCode = "" ;
		Document dom = null ;
			
		
		ArrayList diffAmtList = null;
		
		
		/*String insHdrSql = "insert into MISC_DRCR_RCP ( "
			+" TRAN_ID, TRAN_SER, TRAN_DATE, EFF_DATE, FIN_ENTITY, "
			+" SITE_CODE, SUNDRY_TYPE, SUNDRY_CODE, ACCT_CODE, CCTR_CODE, "
			+" AMOUNT, CURR_CODE, EXCH_RATE, REMARKS, DRCR_FLAG, "
			+" TRAN_ID__RCV, CONFIRMED, CHG_USER, CHG_DATE, CHG_TERM, "
			+" CONF_DATE, EMP_CODE__APRV, DUE_DATE, TRAN_TYPE, ITEM_SER, "
			+" AMOUNT__BC, SRETURN_NO, ADJ_MISC_CRN, ADJ_AMOUNT, PARENT__TRAN_ID, "
			+" REV__TRAN, ROUND_ADJ, "
			+" CUST_REF_NO, CUST_REF_DATE, CUST_REF_AMT, RND_OFF, RND_TO ) "
			+" values ( "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?  ) ";

		String insertDtl = "insert into MISC_DRCR_RDET( "
			+" TRAN_ID, LINE_NO, ACCT_CODE, CCTR_CODE, AMOUNT, "
			+" NET_AMT, REF_NO, REAS_CODE, ANAL_CODE"
			+" ) values ( "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ? )";*/

		DistCommon disComm = new DistCommon();

		try
		{	
			//pstmtHdr = conn.prepareStatement( insHdrSql );
			//pstmtDtl = conn.prepareStatement( insertDtl );
			
			diffAmtList = new ArrayList();
			xmlBuff = new StringBuffer();		
			System.out.println("--XML CREATION ------");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			xmlBuff.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
			xmlBuff.append("<DocumentRoot>");
			xmlBuff.append("<description>").append("Datawindow Root").append("</description>");
			xmlBuff.append("<group0>");
			xmlBuff.append("<description>").append("Group0 description").append("</description>");
			xmlBuff.append("<Header0>");
			xmlBuff.append("<objName><![CDATA[").append("misc_drcr_rcp_cr").append("]]></objName>");  
			xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
			xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			xmlBuff.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
			xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
			xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			xmlBuff.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
			xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
			xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			xmlBuff.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
			xmlBuff.append("<description>").append("Header0 members").append("</description>");	
			xmlBuff.append("<Detail1 dbID=\"\" domID=\"1\" objName=\"misc_drcr_rcp_cr\" objContext=\"1\">");  
			xmlBuff.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
			xmlBuff.append("<tran_id/>");	
			
			
			sql = "select a.cust_code__credit, a.curr_code, a.exch_rate, a.emp_code__aprv, a.tran_id, "
				+" a.net_amt,a.tax_amt, a.porder_no, a.porder_date, a.claum_amt, a.site_code__cr, a.item_ser, "
				+" a.amount, a.remarks, sum(b.discount_amt) as discAmt ,b.tax_class as tax_class,b.tax_chap as tax_chap,b.tax_env as tax_env    "
				+" from charge_back a, charge_back_det b "
				+"	where a.tran_id = b.tran_id "
				+" and a.tran_id >= ? "
				+" and	a.tran_id <= ? "
				+" and a.tran_date >= ? "
				+" and a.tran_date <= ? "
				+" and a.cust_code >= ? "
				+" and a.cust_code <= ? "
				+" and a.site_code = ? "
				// +" and a.confirmed = 'Y' "
				+" group by a.cust_code__credit, a.curr_code, a.exch_rate, a.emp_code__aprv, a.tran_id, "
				+" a.net_amt,a.tax_amt, a.porder_no, a.porder_date, a.claum_amt, a.site_code__cr, a.item_ser, "
				+" a.amount, a.remarks ,b.tax_class ,b.tax_chap ,b.tax_env";

			pstmt = conn.prepareStatement( sql );
			pstmt.setString( 1, tranIdFr );
			pstmt.setString( 2, tranIdTo );
			pstmt.setTimestamp( 3, tranDateFr );
			pstmt.setTimestamp( 4, tranDateTo );
			pstmt.setString( 5, custCodeFr );
			pstmt.setString( 6, custCodeTo );
			pstmt.setString( 7, siteCode );

			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				
				custCodeCr = rs.getString("cust_code__credit");
				currCode = rs.getString("curr_code");
				exchgRate = rs.getDouble("exch_rate");
				empCodeAprv = rs.getString("emp_code__aprv");
				tranIdSel = rs.getString("tran_id");
				netAmt = rs.getDouble("net_amt");
				taxAmt = rs.getDouble("tax_amt");
				pOrderNo = rs.getString("porder_no");
				pOrderDate = rs.getTimestamp("porder_date");
				claimAmt = rs.getDouble("claum_amt");
				siteCodeCr = rs.getString("site_code__cr");
				itemSer = rs.getString("item_ser");
				grossAmount = rs.getDouble("amount");
				remarks = rs.getString("remarks");
				discountAmt = rs.getDouble("discAmt");
				taxClass = rs.getString("tax_class");
				taxChap = rs.getString("tax_chap");
				taxEnv = rs.getString("tax_env");

				System.out.println("taxClass==>["+taxClass+"]");
				System.out.println("taxChap==>["+taxChap+"]");
				System.out.println("taxEnv==>["+taxEnv+"]");
				
				System.out.println("netAmt==>["+netAmt+"]grossAmount["+grossAmount+"]taxAmt["+taxAmt+"]");
				if( siteCodeCr == null || siteCodeCr.trim().length() == 0 )
				{
					siteCodeCr = siteCode;
				}

				sql = "select fin_entity from site where site_code = ?" ;
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, siteCodeCr.trim() );
				rSet = pstmt1.executeQuery();
				if( rSet.next() )
				{
					finEntity = rSet.getString( "fin_entity" );
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;

				sql = "select acct_code__ar, cctr_code__ar from customer where cust_code = ? " ;
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, custCodeCr.trim() );
				rSet = pstmt1.executeQuery();
				if( rSet.next() )
				{
					acctCode = rSet.getString( "acct_code__ar" );
					cctrCode = rSet.getString( "cctr_code__ar" );
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;
				// 21/07/10 manoharan make cctr_code blank in case null
				if (cctrCode == null)
				{
					cctrCode = "     ";
				}
				// end 21/07/10
				detAcct = disComm.getDisparams( "999999", "DRCR_ACCT_CBACK", conn );

				if( detAcct == null || detAcct.equalsIgnoreCase( "NULLFOUND" ) || detAcct.trim().length() == 0 )
				{
					errCode = "VMDRCRACCT"; //'DS000' + string(sqlca.sqldbcode)
					break;
				}

				detCctr = disComm.getDisparams( "999999", "DRCR_CCTR_CBACK", conn );

				if( detCctr == null || detCctr.equalsIgnoreCase( "NULLFOUND" ) || detCctr.trim().length() == 0 )
				{
					// 21/07/10 manoharan if cctr_code is null then assign as cctr_code__ar (blank included)
					//errCode = "VMLSCCTR"; //'DS000' + string(sqlca.sqldbcode)
					//break;
					detCctr = cctrCode;
					// end 21/07/10 manoharan if cctr_code is null then assign as cctr_code__ar (blank included)
				}

				tranType = disComm.getDisparams( "999999", "CHARGE_BACK_TRAN_TYPE", conn );

				if( tranType == null || tranType.equalsIgnoreCase( "NULLFOUND" ) || tranType.trim().length() == 0 )
				{
					errCode = "VMLSTRTYPE"; //'DS000' + string(sqlca.sqldbcode)
					break;
				}

				reasonCd = disComm.getDisparams( "999999", "CHARGE_BACK_REASON_CODE", conn );
				System.out.println( "reasonCd ::" + reasonCd );
				if( reasonCd == null || reasonCd.equalsIgnoreCase( "NULLFOUND" ) || reasonCd.trim().length() == 0 )
				{
					errCode = "VMREASON"; //'DS000' + string(sqlca.sqldbcode)
					break;
				}
				
				System.out.println("claimAmt::["+claimAmt+"]netAmt:::["+netAmt+"]");
				System.out.println("drcrAmt::["+drcrAmt+"]");
				
				
				if( claimAmt <= 0 )
				{
					claimAmt = 0;
					drcrAmt = netAmt;
				}
				else
				{
					drcrAmt = claimAmt < netAmt ? claimAmt : netAmt;
				}
				//cHANGED BY POONAM FOR TAX CALCULATION 
				
				xmlBuff.append("<tran_ser><![CDATA["+ "MDRCRC" +"]]></tran_ser>");
				xmlBuff.append("<tran_date><![CDATA["+ sdf.format(currDate).toString() +"]]></tran_date>");
				xmlBuff.append("<eff_date><![CDATA["+ sdf.format(currDate).toString() +"]]></eff_date>");
				xmlBuff.append("<fin_entity><![CDATA["+ finEntity   +"]]></fin_entity>");
				xmlBuff.append("<site_code><![CDATA["+siteCodeCr +"]]></site_code>");
				xmlBuff.append("<sundry_type><![CDATA["+ "C"  +"]]></sundry_type>");
				xmlBuff.append("<sundry_code><![CDATA["+ custCodeCr  +"]]></sundry_code>");
				xmlBuff.append("<acct_code><![CDATA["+checkNull(acctCode)  +"]]></acct_code>");
				xmlBuff.append("<curr_code><![CDATA["+ checkNull(cctrCode) +"]]></curr_code>");
				
				
				
				
				
				
				
				
				//crNtTranId = generateTranId("W_MISC_DRCR_RCP_CR", getCurrdateInAppFormat(), loginSite, userId, tranType );
				/*drNtTranId = generateTranId("W_MISC_DRCR_RCP_DR", getCurrdateInAppFormat(), siteCodeCr, userId, tranType );
				//-----------------------Inserting into header-----------------------------------
				pstmtHdr.setString( 1, drNtTranId );
				pstmtHdr.setString( 2, "MDRCRD" );
				pstmtHdr.setTimestamp( 3, currDate );
				pstmtHdr.setTimestamp( 4, currDate );
				pstmtHdr.setString( 5, finEntity );
				pstmtHdr.setString( 6, siteCodeCr);
				pstmtHdr.setString( 7, "C" );
				pstmtHdr.setString( 8, custCodeCr );
				pstmtHdr.setString( 9, acctCode == null ? "" : acctCode );
				pstmtHdr.setString( 10, cctrCode == null ? "    " : cctrCode );*/
				sql = "select nvl(round,'N') ls_round, nvl(round_to,0.001) lc_round_to from customer where cust_code = ? ";
				pstmt1 = conn.prepareStatement( sql );
				pstmt1.setString(1, custCodeCr );
				rSet = pstmt1.executeQuery();
				if( rSet.next() )
				{
					round = rSet.getString( "ls_round" );
					roundTo = rSet.getDouble( "lc_round_to" );
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;

				roundAmt = disComm.getRndamt( drcrAmt, round, roundTo );
				
				System.out.println("drcrAmt in debit note["+drcrAmt+"]roundAmt["+roundAmt);
				
				if(drcrAmt < 0)
				{
					drcrAmt = drcrAmt * (-1);
				}
				
				System.out.println("drcrAmt IN debit note"+drcrAmt);
				
				diffAmt = roundAmt - drcrAmt;
				
				//pstmtHdr.setDouble( 11, drcrAmt );//CHANGED BY POONAM
				/*pstmtHdr.setDouble( 11, roundAmt );//CHANGED BY POONAM
				pstmtHdr.setString( 12, currCode == null || currCode.trim().length() == 0 ? "" : currCode);//CHANGED BY POONAM
				pstmtHdr.setDouble( 13, exchgRate );*///CHANGED BY POONAM
				
				xmlBuff.append("<amount><![CDATA["+ drcrAmt +"]]></amount>");
				xmlBuff.append("<curr_code><![CDATA["+ checkNull(currCode ) +"]]></curr_code>");
				xmlBuff.append("<exch_rate><![CDATA["+ exchgRate +"]]></exch_rate>");
				

				if( remarks == null || remarks.trim().length() == 0 )
				{
					String tRemStr = null;
					System.out.println("tranIdSel->"+tranIdSel+" pOrderNo->"+pOrderNo+" pOrderDate->"+pOrderDate);
					tRemStr = ( "CB " + tranIdSel );
					//pstmtHdr.setString( 14, tRemStr ); //CHANGED BY POONAM
					xmlBuff.append("<remarks><![CDATA["+ tRemStr  +"]]></remarks>");
				}
				else
				{
					//pstmtHdr.setString( 14, remarks.trim() );//CHANGED BY POONAM
					xmlBuff.append("<remarks><![CDATA["+ remarks.trim()  +"]]></remarks>");
				}
				
				xmlBuff.append("<drcr_flag><![CDATA["+ "C"   +"]]></drcr_flag>");
				xmlBuff.append("<tran_id__rcv><![CDATA["+ ""   +"]]></tran_id__rcv>");
				xmlBuff.append("<confirmed><![CDATA["+ "N"   +"]]></confirmed>");
				xmlBuff.append("<chg_user><![CDATA["+ userId   +"]]></chg_user>");
				xmlBuff.append("<chg_date><![CDATA["+ sdf.format(currDate).toString()   +"]]></chg_date>");
				xmlBuff.append("<chg_term><![CDATA["+ termId   +"]]></chg_term>");
				xmlBuff.append("<conf_date><![CDATA["+ sdf.format(currDate).toString()   +"]]></conf_date>");
				
				xmlBuff.append("<emp_code__aprv><![CDATA["+ empCodeAprv   +"]]></emp_code__aprv>");
				xmlBuff.append("<due_date><![CDATA["+ sdf.format(currDate).toString()   +"]]></due_date>");
				xmlBuff.append("<tran_type><![CDATA["+ checkNull(tranType)   +"]]></tran_type>");
				xmlBuff.append("<item_ser><![CDATA["+ checkNull(itemSer )   +"]]></item_ser>");
				xmlBuff.append("<amount__bc><![CDATA["+  roundAmt * exchgRate   +"]]></amount__bc>");
				xmlBuff.append("<sreturn_no><![CDATA["+ checkNull(tranIdSel)   +"]]></sreturn_no>");
				xmlBuff.append("<adj_misc_crn><![CDATA["+ ""   +"]]></adj_misc_crn>");
				xmlBuff.append("<adj_amount><![CDATA["+ 0.0   +"]]></adj_amount>");
				xmlBuff.append("<parent__tran_id><![CDATA["+ ""   +"]]></parent__tran_id>");
				xmlBuff.append("<rev__tran><![CDATA["+ ""   +"]]></rev__tran>");
				xmlBuff.append("<round_adj><![CDATA["+ 0.0   +"]]></round_adj>");
				xmlBuff.append("<cust_ref_no><![CDATA["+ ""   +"]]></cust_ref_no>");
				//xmlBuff.append("<cust_ref_date><![CDATA["+  sdf.format(currDate).toString() +"]]></cust_ref_date>");
				/*xmlBuff.append("<cust_ref_amt><![CDATA["+ 0.0   +"]]></cust_ref_amt>");
				xmlBuff.append("<rnd_off><![CDATA["+ 0.0   +"]]></rnd_off>");
				xmlBuff.append("<rnd_to><![CDATA["+ 0.0   +"]]></rnd_to>");*/
				
				//POONAM
				
				/*pstmtHdr.setString( 15, "D" );//Changed by Poonam to created debit note..
				pstmtHdr.setString( 16, "" );
				pstmtHdr.setString( 17, "N" );
				pstmtHdr.setString( 18, userId );
				pstmtHdr.setTimestamp( 19, currDate );
				pstmtHdr.setString( 20, termId );
				pstmtHdr.setNull( 21, java.sql.Types.DATE );
				pstmtHdr.setString( 22, empCodeAprv );
				pstmtHdr.setTimestamp( 23, currDate );
				pstmtHdr.setString( 24, ( tranType == null || tranType.trim().length() == 0 ? "" :tranType.trim() ) );
				pstmtHdr.setString( 25, ( itemSer == null || itemSer.trim().length() == 0 ? "" : itemSer.trim() ) );
				//pstmtHdr.setDouble( 26, drcrAmt );
				pstmtHdr.setDouble( 26, roundAmt * exchgRate);
				pstmtHdr.setString( 27, ( tranIdSel == null || tranIdSel.trim().length() == 0 ? "" :  tranIdSel.trim() ) );
				pstmtHdr.setString( 28, "" ); //ADJ_MISC_CRN
				pstmtHdr.setDouble( 29, 0.0 ); //ADJ_AMOUNT
				pstmtHdr.setString( 30, "" ); //PARENT__TRAN_ID
				pstmtHdr.setString( 31, "" ); //REV__TRAN
				pstmtHdr.setDouble( 32, 0.0 ); //ROUND_ADJ
				//pstmt.setInt( 33, 0 ); //LINE_NO__SRET
				//pstmt.setInt( 34, 0 ); //LINE_NO__SRET
				//pstmt.setString( 35, "" ); //LOT_NO
				pstmtHdr.setString( 33, "" ); //CUST_REF_NO
				pstmtHdr.setNull( 34, java.sql.Types.DATE ); //CUST_REF_DATE
				pstmtHdr.setDouble( 35, 0.0 ); //CUST_REF_AMT
				pstmtHdr.setDouble( 36, 0.0 ); //RND_OFF
				pstmtHdr.setDouble( 37, 0.0 ); //RND_TO

				int updtCnt = pstmtHdr.executeUpdate();*/
				//System.out.println("updtCnt==>"+updtCnt);
				//-----------------------Inserting into detail-----------------------------------
				
				System.out.println("drcrAmt in credit detail"+drcrAmt);
				System.out.println("grossAmount in debit detail"+grossAmount);
				llLineNo = 0;
				
				analCode = finCommon.getFinparams("999999", "ANAL_CODE", conn);
				
				System.out.println("analCode:::"+analCode);
				
				xmlBuffDet = new StringBuffer();
				
				xmlBuffDet.append("<Detail2 dbID=\"\" domID=\"1\" objName=\"misc_drcr_rcp_dr\" objContext=\"1\">");  
				xmlBuffDet.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
				xmlBuffDet.append("<tran_id/>");	
				llLineNo++;
				xmlBuffDet.append("<line_no><![CDATA["+ llLineNo   +"]]></line_no>");
				xmlBuffDet.append("<acct_code><![CDATA["+ detAcct   +"]]></acct_code>");
				xmlBuffDet.append("<cctr_code><![CDATA["+ detCctr   +"]]></cctr_code>");
				
				
				
				//CHANGED BY POONAM
				
				/*pstmtDtl.setString( 1, drNtTranId );
				llLineNo++;
				pstmtDtl.setInt( 2, llLineNo );
				pstmtDtl.setString( 3, detAcct );
				pstmtDtl.setString( 4, detCctr );*/
				
				if(drcrAmt < 0)
				{
					drcrAmt = drcrAmt * (-1);
				}
				if(grossAmount < 0)
				{
					grossAmount = grossAmount * (-1);
				}
				if(taxAmt < 0)
				{
					taxAmt = taxAmt * (-1);
				}
				
				System.out.println("drcrAmt in debit detail"+drcrAmt);
				System.out.println("grossAmount in debit detail"+grossAmount);
				System.out.println("taxAmt in debit detail"+taxAmt);

				//if( claimAmt > 0 && claimAmt < netAmt )
				//{
					//pstmtDtl.setDouble( 5, drcrAmt );
					//pstmtDtl.setDouble( 6, drcrAmt );
					//CHANGED BY POONAM
				if(claimAmt > 0 && claimAmt < netAmt)
				{
					xmlBuffDet.append("<amount><![CDATA["+ drcrAmt   +"]]></amount>");
					xmlBuffDet.append("<net_amt><![CDATA["+ drcrAmt   +"]]></net_amt>");
					//xmlBuffDet.append("<tax_amt><![CDATA["+ taxAmt   +"]]></tax_amt>");
				}
				else
				{
					xmlBuffDet.append("<amount><![CDATA["+ grossAmount+"]]></amount>");
					//xmlBuffDet.append("<net_amt><![CDATA["+ drcrAmt   +"]]></net_amt>");
					//xmlBuffDet.append("<tax_amt><![CDATA["+ taxAmt   +"]]></tax_amt>");
				}
				//}
				/*else
				{
					//pstmtDtl.setDouble( 5, grossAmount );
					//pstmtDtl.setDouble( 6, grossAmount );
					//CHANGED BY POONAM
					xmlBuffDet.append("<amount><![CDATA["+ grossAmount   +"]]></amount>");
					xmlBuffDet.append("<net_amt><![CDATA["+ grossAmount   +"]]></net_amt>");
				}*/
				//CHANGED BY POONAM
				/*pstmtDtl.setString( 7, tranIdSel ); //ref_no
				pstmtDtl.setString( 8, ( reasonCd == null || reasonCd.trim().length() == 0 ? "" : reasonCd.trim() ) ); //reas_code
				pstmtDtl.setString( 9, "" ); //ANAL_CODE
*/				
				
				xmlBuffDet.append("<ref_no><![CDATA["+ tranIdSel   +"]]></ref_no>");
				xmlBuffDet.append("<reas_code><![CDATA["+  checkNull(reasonCd)    +"]]></reas_code>");
				xmlBuffDet.append("<anal_code><![CDATA["+ analCode   +"]]></anal_code>");
				
				
				xmlBuffDet.append("<tax_class><![CDATA["+ checkNull(taxClass) +"]]></tax_class>");
				xmlBuffDet.append("<tax_chap><![CDATA["+ checkNull(taxChap) +"]]></tax_chap>");
				xmlBuffDet.append("<tax_env><![CDATA["+ checkNull(taxEnv) +"]]></tax_env>");
				
				xmlBuffDet.append("</Detail2>");

				//Changed by poonam :taxtran not required
				
				/*pstmtDtl.addBatch();

				sql = "select acct_code, cctr_code, sum(tax_amt) taxamt "
					+" from taxtran "
					+" where tran_code = 'S-CHB' and tran_id = ? "
					+" and tax_amt <> 0 "
					+" and effect <> 'N' "
					+" group by acct_code, cctr_code " ;
				//
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, tranIdSel);
				rSet = pstmt1.executeQuery();
				while( rSet.next() )
				{
					acctCodeTax = rSet.getString( "acct_code" );
					cctrCodeTax = rSet.getString( "acct_code" );
					amtTax =  rSet.getDouble( "taxamt" );

					if( acctCodeTax == null || acctCodeTax.trim().length() == 0 )
					{
						acctCodeTax = detAcct;
					}
					if( cctrCodeTax == null || cctrCodeTax.trim().length() == 0 )
					{
						cctrCodeTax = detCctr;
					}

					total = total + amtTax;

					pstmtDtl.setString( 1, drNtTranId );

					llLineNo++;
					pstmtDtl.setInt( 2, llLineNo );
					pstmtDtl.setString( 3, acctCodeTax );
					pstmtDtl.setString( 4, acctCodeTax );
					pstmtDtl.setDouble( 5, amtTax);
					pstmtDtl.setDouble( 6, 0.0 );
					pstmtDtl.setString( 7, "" ); //ref_no
					pstmtDtl.setString( 8, "" ); //reas_code
					pstmtDtl.setString( 9, "" ); //ANAL_CODE

					pstmtDtl.addBatch();
					
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;

				pstmtDtl.executeBatch();

				pstmtDtl.close();
				pstmtDtl = null;
				pstmtHdr.close();
				pstmtHdr = null;*/

				

				/*sql = "select nvl(round,'N') ls_round, nvl(round_to,0.001) lc_round_to from customer where cust_code = ? ";
				pstmt1 = conn.prepareStatement( sql );
				pstmt1.setString(1, custCodeCr );
				rSet = pstmt1.executeQuery();
				if( rSet.next() )
				{
					round = rSet.getString( "ls_round" );
					roundTo = rSet.getDouble( "lc_round_to" );
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;*/

				roundAmt = disComm.getRndamt( drcrAmt, round, roundTo );
				diffAmt = roundAmt - drcrAmt;
				System.out.println("diffAmt IN DR["+diffAmt+"]");
			//if( diffAmt != 0 )
				//{
					//1. update header
					//2. insert record in detail
					
					
					
					
					/*insDtlsql = "insert into MISC_DRCR_RDET( "
						+" TRAN_ID, LINE_NO, ACCT_CODE, CCTR_CODE, AMOUNT, "
						+" NET_AMT, REF_NO, REAS_CODE, ANAL_CODE, TAX_AMT"
						+" ) values ( "
						+" ?, ?, ?, ?, ?, "
						+" ?, ?, ?, ?, ? )";
					pstmt1 = conn.prepareStatement( insDtlsql );
					pstmt1.setString( 1, drNtTranId );

					llLineNo++;

					pstmt1.setInt( 2, llLineNo );
					pstmt1.setString( 3, detAcct );
					pstmt1.setString( 4, detCctr );
					pstmt1.setDouble( 5, -diffAmt);
					pstmt1.setDouble( 6, -diffAmt );
					pstmt1.setString( 7, "" ); //ref_no
					pstmt1.setString( 8, reasonCd.trim() ); //reas_code
					pstmt1.setString( 9, "" ); //ANAL_CODE
					pstmt1.setDouble( 10, 0 );

					pstmt1.executeUpdate();

					pstmt1.close();
					pstmt1 = null;*/
				//}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			xmlBuff.append("</Detail1>");
			xmlBuff.append(xmlBuffDet);
			xmlBuff.append("</Header0>");
			xmlBuff.append("</group0>");
			xmlBuff.append("</DocumentRoot>");
			xmlString = xmlBuff.toString();
			System.out.println("@@@@@2: xmlString:"+xmlBuff.toString());
			System.out.println("...............just before savdata distorder()");
			siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			System.out.println("== site code =="+siteCode);
			errString = saveData(siteCode,xmlString,xtraParams,conn);
			System.out.println("@@@@@2: retString:"+errString);
			System.out.println("--retString finished--");
			if (errString.indexOf("Success") > -1)
			{
				System.out.println("@@@@@@3: Success"+errString);
				dom = genericUtility.parseString(errString);
				System.out.println("dom>>>"+dom);
				drNtTranId = genericUtility.getColumnValue("TranID",dom);
			}
			else
			{
				System.out.println("[SuccessSuccess" + errString + "]");	
				conn.rollback();
				return errString;
			}
			
			
			sql = "update charge_back set "
					+" tran_id__crn = ? "
					+" where tran_id = ? ";

			pstmt1 = conn.prepareStatement( sql );
			pstmt1.setString(1, drNtTranId );
			pstmt1.setString(2, tranIdSel );
			int updCount = 0 ;
			updCount = pstmt1.executeUpdate();

			if( updCount == 0 )
			{
				errCode = "DS000NR";
					//break;
			}
			pstmt1.close();
			pstmt1 = null;	
					

			if( "Y".equalsIgnoreCase( asPost )  )
			{
				conn.commit();
				retString = retrieveMiscDrcrRcp( "misc_drcr_rcp",drNtTranId,xtraParams,"N" );
				errCode = getErrCodeFromErrStr(retString);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtDtl != null)
				{
					pstmtDtl.close();
					pstmtDtl = null;
				}
				if(pstmtHdr != null)
				{
					pstmtHdr.close();
					pstmtHdr = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception ChrgBckLocConfEJB....... :\n"+e.getMessage());
			}
		}
		return errCode;
	}
	
	// Added for Debit note generation if amt < 0: Start
	
	private String createMiscDrnoteCback(Timestamp currDate, String str, String siteCode, String tranIdFr, String tranIdTo, Timestamp tranDateFr, Timestamp tranDateTo, String custCodeFr, String custCodeTo, String confirm, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{
		System.out.println("Inside createMiscDrnoteCback................");
		PreparedStatement pstmt = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmtHdr = null;
		PreparedStatement pstmtDtl = null;
		ResultSet rs = null;
		Statement stmt = null;
		ResultSet rSet = null;
		String sql = null;
		String custCodeCr = "";
		String currCode = "";
		String finEntity = "";
		String acctCode = "";
		String cctrCode = "";
		String empCodeAprv = "";
		String tranIdSel = "";
		String pOrderNo = "";
		String siteCodeCr = "";
		String itemSer = "";
		String remarks = "";
		String detAcct = "";
		String errCode = "";
		String retString = "";
		String detCctr = "";
		String tranType = "";
		String reasonCd = "";
		String drNtTranId = "";
		String acctCodeTax = "";
		String cctrCodeTax = "";
		String round = "";
		String insDtlsql = "";
		String asPost = confirm;
		double roundTo = 0.0;
		double exchgRate = 0.0;
		double netAmt = 0.0;
		double claimAmt = 0.0;
		double grossAmount = 0.0;
		double drcrAmt = 0.0;
		double amtTax = 0.0;
		double total = 0.0;
		double roundAmt = 0.0;
		double diffAmt = 0.0;
		double discountAmt = 0.0 ,taxAmt = 0.0;
		int llLineNo = 0;
		java.sql.Timestamp tranDate = null;
		java.sql.Timestamp pOrderDate = null;
		
		StringBuffer xmlBuff = null;
		StringBuffer xmlBuffDet = null;
		String xmlString="",errString = "",taxClass = "",taxEnv = "",taxChap = "",analCode = "" ;
		Document dom = null ;
			
		
		ArrayList diffAmtList = null;
		
		
		/*String insHdrSql = "insert into MISC_DRCR_RCP ( "
			+" TRAN_ID, TRAN_SER, TRAN_DATE, EFF_DATE, FIN_ENTITY, "
			+" SITE_CODE, SUNDRY_TYPE, SUNDRY_CODE, ACCT_CODE, CCTR_CODE, "
			+" AMOUNT, CURR_CODE, EXCH_RATE, REMARKS, DRCR_FLAG, "
			+" TRAN_ID__RCV, CONFIRMED, CHG_USER, CHG_DATE, CHG_TERM, "
			+" CONF_DATE, EMP_CODE__APRV, DUE_DATE, TRAN_TYPE, ITEM_SER, "
			+" AMOUNT__BC, SRETURN_NO, ADJ_MISC_CRN, ADJ_AMOUNT, PARENT__TRAN_ID, "
			+" REV__TRAN, ROUND_ADJ, "
			+" CUST_REF_NO, CUST_REF_DATE, CUST_REF_AMT, RND_OFF, RND_TO ) "
			+" values ( "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?  ) ";

		String insertDtl = "insert into MISC_DRCR_RDET( "
			+" TRAN_ID, LINE_NO, ACCT_CODE, CCTR_CODE, AMOUNT, "
			+" NET_AMT, REF_NO, REAS_CODE, ANAL_CODE"
			+" ) values ( "
			+" ?, ?, ?, ?, ?, "
			+" ?, ?, ?, ? )";*/

		DistCommon disComm = new DistCommon();

		try
		{	
			//pstmtHdr = conn.prepareStatement( insHdrSql );
			//pstmtDtl = conn.prepareStatement( insertDtl );
			
			diffAmtList = new ArrayList();
			xmlBuff = new StringBuffer();		
			System.out.println("--XML CREATION ------");
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			xmlBuff.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
			xmlBuff.append("<DocumentRoot>");
			xmlBuff.append("<description>").append("Datawindow Root").append("</description>");
			xmlBuff.append("<group0>");
			xmlBuff.append("<description>").append("Group0 description").append("</description>");
			xmlBuff.append("<Header0>");
			xmlBuff.append("<objName><![CDATA[").append("misc_drcr_rcp_dr").append("]]></objName>");  
			xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
			xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			xmlBuff.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
			xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
			xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			xmlBuff.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
			xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
			xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			xmlBuff.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
			xmlBuff.append("<description>").append("Header0 members").append("</description>");	
			xmlBuff.append("<Detail1 dbID=\"\" domID=\"1\" objName=\"misc_drcr_rcp_dr\" objContext=\"1\">");  
			xmlBuff.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
			xmlBuff.append("<tran_id/>");	
			
			
			sql = "select a.cust_code__credit, a.curr_code, a.exch_rate, a.emp_code__aprv, a.tran_id, "
				+" a.net_amt, a.tax_amt,a.porder_no, a.porder_date, a.claum_amt, a.site_code__cr, a.item_ser, "
				+" a.amount, a.remarks, sum(b.discount_amt) as discAmt ,b.tax_class as tax_class,b.tax_chap as tax_chap,b.tax_env as tax_env    "
				+" from charge_back a, charge_back_det b "
				+"	where a.tran_id = b.tran_id "
				+" and a.tran_id >= ? "
				+" and	a.tran_id <= ? "
				+" and a.tran_date >= ? "
				+" and a.tran_date <= ? "
				+" and a.cust_code >= ? "
				+" and a.cust_code <= ? "
				+" and a.site_code = ? "
				// +" and a.confirmed = 'Y' "
				+" group by a.cust_code__credit, a.curr_code, a.exch_rate, a.emp_code__aprv, a.tran_id, "
				+" a.net_amt, a.tax_amt,a.porder_no, a.porder_date, a.claum_amt, a.site_code__cr, a.item_ser, "
				+" a.amount, a.remarks ,b.tax_class ,b.tax_chap ,b.tax_env";

			pstmt = conn.prepareStatement( sql );
			pstmt.setString( 1, tranIdFr );
			pstmt.setString( 2, tranIdTo );
			pstmt.setTimestamp( 3, tranDateFr );
			pstmt.setTimestamp( 4, tranDateTo );
			pstmt.setString( 5, custCodeFr );
			pstmt.setString( 6, custCodeTo );
			pstmt.setString( 7, siteCode );

			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				
				custCodeCr = rs.getString("cust_code__credit");
				currCode = rs.getString("curr_code");
				exchgRate = rs.getDouble("exch_rate");
				empCodeAprv = rs.getString("emp_code__aprv");
				tranIdSel = rs.getString("tran_id");
				netAmt = rs.getDouble("net_amt");
				taxAmt = rs.getDouble("tax_amt");
				pOrderNo = rs.getString("porder_no");
				pOrderDate = rs.getTimestamp("porder_date");
				claimAmt = rs.getDouble("claum_amt");
				siteCodeCr = rs.getString("site_code__cr");
				itemSer = rs.getString("item_ser");
				grossAmount = rs.getDouble("amount");
				remarks = rs.getString("remarks");
				discountAmt = rs.getDouble("discAmt");
				taxClass = rs.getString("tax_class");
				taxChap = rs.getString("tax_chap");
				taxEnv = rs.getString("tax_env");

				System.out.println("taxClass==>["+taxClass+"]");
				System.out.println("taxChap==>["+taxChap+"]");
				System.out.println("taxEnv==>["+taxEnv+"]");
				if( siteCodeCr == null || siteCodeCr.trim().length() == 0 )
				{
					siteCodeCr = siteCode;
				}

				sql = "select fin_entity from site where site_code = ?" ;
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, siteCodeCr.trim() );
				rSet = pstmt1.executeQuery();
				if( rSet.next() )
				{
					finEntity = rSet.getString( "fin_entity" );
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;

				sql = "select acct_code__ar, cctr_code__ar from customer where cust_code = ? " ;
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, custCodeCr.trim() );
				rSet = pstmt1.executeQuery();
				if( rSet.next() )
				{
					acctCode = rSet.getString( "acct_code__ar" );
					cctrCode = rSet.getString( "cctr_code__ar" );
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;
				// 21/07/10 manoharan make cctr_code blank in case null
				if (cctrCode == null)
				{
					cctrCode = "     ";
				}
				// end 21/07/10
				detAcct = disComm.getDisparams( "999999", "DRCR_ACCT_CBACK", conn );

				if( detAcct == null || detAcct.equalsIgnoreCase( "NULLFOUND" ) || detAcct.trim().length() == 0 )
				{
					errCode = "VMDRCRACCT"; //'DS000' + string(sqlca.sqldbcode)
					break;
				}

				detCctr = disComm.getDisparams( "999999", "DRCR_CCTR_CBACK", conn );

				if( detCctr == null || detCctr.equalsIgnoreCase( "NULLFOUND" ) || detCctr.trim().length() == 0 )
				{
					// 21/07/10 manoharan if cctr_code is null then assign as cctr_code__ar (blank included)
					//errCode = "VMLSCCTR"; //'DS000' + string(sqlca.sqldbcode)
					//break;
					detCctr = cctrCode;
					// end 21/07/10 manoharan if cctr_code is null then assign as cctr_code__ar (blank included)
				}

				tranType = disComm.getDisparams( "999999", "CHARGE_BACK_TRAN_TYPE", conn );

				if( tranType == null || tranType.equalsIgnoreCase( "NULLFOUND" ) || tranType.trim().length() == 0 )
				{
					errCode = "VMLSTRTYPE"; //'DS000' + string(sqlca.sqldbcode)
					break;
				}

				reasonCd = disComm.getDisparams( "999999", "CHARGE_BACK_REASON_CODE", conn );
				System.out.println( "reasonCd ::" + reasonCd );
				if( reasonCd == null || reasonCd.equalsIgnoreCase( "NULLFOUND" ) || reasonCd.trim().length() == 0 )
				{
					errCode = "VMREASON"; //'DS000' + string(sqlca.sqldbcode)
					break;
				}
				
				System.out.println("claimAmt::["+claimAmt+"]netAmt:::["+netAmt+"]");
				System.out.println("drcrAmt::["+drcrAmt+"]");
				
				
				if( claimAmt <= 0 )
				{
					claimAmt = 0;
					drcrAmt = netAmt;
				}
				else
				{
					drcrAmt = claimAmt < netAmt ? claimAmt : netAmt;
				}
				//cHANGED BY POONAM FOR TAX CALCULATION 
				
				xmlBuff.append("<tran_ser><![CDATA["+ "MDRCRD" +"]]></tran_ser>");
				xmlBuff.append("<tran_date><![CDATA["+ sdf.format(currDate).toString() +"]]></tran_date>");
				xmlBuff.append("<eff_date><![CDATA["+ sdf.format(currDate).toString() +"]]></eff_date>");
				xmlBuff.append("<fin_entity><![CDATA["+ finEntity   +"]]></fin_entity>");
				xmlBuff.append("<site_code><![CDATA["+siteCodeCr +"]]></site_code>");
				xmlBuff.append("<sundry_type><![CDATA["+ "C"  +"]]></sundry_type>");
				xmlBuff.append("<sundry_code><![CDATA["+ custCodeCr  +"]]></sundry_code>");
				xmlBuff.append("<acct_code><![CDATA["+checkNull(acctCode)  +"]]></acct_code>");
				xmlBuff.append("<curr_code><![CDATA["+ checkNull(cctrCode) +"]]></curr_code>");
				
				
				
				
				
				
				
				
				//crNtTranId = generateTranId("W_MISC_DRCR_RCP_CR", getCurrdateInAppFormat(), loginSite, userId, tranType );
				/*drNtTranId = generateTranId("W_MISC_DRCR_RCP_DR", getCurrdateInAppFormat(), siteCodeCr, userId, tranType );
				//-----------------------Inserting into header-----------------------------------
				pstmtHdr.setString( 1, drNtTranId );
				pstmtHdr.setString( 2, "MDRCRD" );
				pstmtHdr.setTimestamp( 3, currDate );
				pstmtHdr.setTimestamp( 4, currDate );
				pstmtHdr.setString( 5, finEntity );
				pstmtHdr.setString( 6, siteCodeCr);
				pstmtHdr.setString( 7, "C" );
				pstmtHdr.setString( 8, custCodeCr );
				pstmtHdr.setString( 9, acctCode == null ? "" : acctCode );
				pstmtHdr.setString( 10, cctrCode == null ? "    " : cctrCode );*/
				sql = "select nvl(round,'N') ls_round, nvl(round_to,0.001) lc_round_to from customer where cust_code = ? ";
				pstmt1 = conn.prepareStatement( sql );
				pstmt1.setString(1, custCodeCr );
				rSet = pstmt1.executeQuery();
				if( rSet.next() )
				{
					round = rSet.getString( "ls_round" );
					roundTo = rSet.getDouble( "lc_round_to" );
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;

				roundAmt = disComm.getRndamt( drcrAmt, round, roundTo );
				
				System.out.println("drcrAmt in debit note["+drcrAmt+"]roundAmt["+roundAmt);
				
				if(drcrAmt < 0)
				{
					drcrAmt = drcrAmt * (-1);
				}
				
				
				
				System.out.println("drcrAmt IN debit note"+drcrAmt);
				
				diffAmt = roundAmt - drcrAmt;
				
				//pstmtHdr.setDouble( 11, drcrAmt );//CHANGED BY POONAM
				/*pstmtHdr.setDouble( 11, roundAmt );//CHANGED BY POONAM
				pstmtHdr.setString( 12, currCode == null || currCode.trim().length() == 0 ? "" : currCode);//CHANGED BY POONAM
				pstmtHdr.setDouble( 13, exchgRate );*///CHANGED BY POONAM
				
				xmlBuff.append("<amount><![CDATA["+ drcrAmt +"]]></amount>");
				xmlBuff.append("<curr_code><![CDATA["+ checkNull(currCode ) +"]]></curr_code>");
				xmlBuff.append("<exch_rate><![CDATA["+ exchgRate +"]]></exch_rate>");
				

				if( remarks == null || remarks.trim().length() == 0 )
				{
					String tRemStr = null;
					System.out.println("tranIdSel->"+tranIdSel+" pOrderNo->"+pOrderNo+" pOrderDate->"+pOrderDate);
					tRemStr = ( "CB " + tranIdSel );
					//pstmtHdr.setString( 14, tRemStr ); //CHANGED BY POONAM
					xmlBuff.append("<remarks><![CDATA["+ tRemStr  +"]]></remarks>");
				}
				else
				{
					//pstmtHdr.setString( 14, remarks.trim() );//CHANGED BY POONAM
					xmlBuff.append("<remarks><![CDATA["+ remarks.trim()  +"]]></remarks>");
				}
				
				xmlBuff.append("<drcr_flag><![CDATA["+ "D"   +"]]></drcr_flag>");
				xmlBuff.append("<tran_id__rcv><![CDATA["+ ""   +"]]></tran_id__rcv>");
				xmlBuff.append("<confirmed><![CDATA["+ "N"   +"]]></confirmed>");
				xmlBuff.append("<chg_user><![CDATA["+ userId   +"]]></chg_user>");
				xmlBuff.append("<chg_date><![CDATA["+ sdf.format(currDate).toString()   +"]]></chg_date>");
				xmlBuff.append("<chg_term><![CDATA["+ termId   +"]]></chg_term>");
				xmlBuff.append("<conf_date><![CDATA["+ sdf.format(currDate).toString()   +"]]></conf_date>");
				
				xmlBuff.append("<emp_code__aprv><![CDATA["+ empCodeAprv   +"]]></emp_code__aprv>");
				xmlBuff.append("<due_date><![CDATA["+ sdf.format(currDate).toString()   +"]]></due_date>");
				xmlBuff.append("<tran_type><![CDATA["+ checkNull(tranType)   +"]]></tran_type>");
				xmlBuff.append("<item_ser><![CDATA["+ checkNull(itemSer )   +"]]></item_ser>");
				xmlBuff.append("<amount__bc><![CDATA["+  roundAmt * exchgRate   +"]]></amount__bc>");
				xmlBuff.append("<sreturn_no><![CDATA["+ checkNull(tranIdSel)   +"]]></sreturn_no>");
				xmlBuff.append("<adj_misc_crn><![CDATA["+ ""   +"]]></adj_misc_crn>");
				xmlBuff.append("<adj_amount><![CDATA["+ 0.0   +"]]></adj_amount>");
				xmlBuff.append("<parent__tran_id><![CDATA["+ ""   +"]]></parent__tran_id>");
				xmlBuff.append("<rev__tran><![CDATA["+ ""   +"]]></rev__tran>");
				xmlBuff.append("<round_adj><![CDATA["+ 0.0   +"]]></round_adj>");
				xmlBuff.append("<cust_ref_no><![CDATA["+ ""   +"]]></cust_ref_no>");
				//xmlBuff.append("<cust_ref_date><![CDATA["+  sdf.format(currDate).toString() +"]]></cust_ref_date>");
				/*xmlBuff.append("<cust_ref_amt><![CDATA["+ 0.0   +"]]></cust_ref_amt>");
				xmlBuff.append("<rnd_off><![CDATA["+ 0.0   +"]]></rnd_off>");
				xmlBuff.append("<rnd_to><![CDATA["+ 0.0   +"]]></rnd_to>");*/
				
				//POONAM
				
				/*pstmtHdr.setString( 15, "D" );//Changed by Poonam to created debit note..
				pstmtHdr.setString( 16, "" );
				pstmtHdr.setString( 17, "N" );
				pstmtHdr.setString( 18, userId );
				pstmtHdr.setTimestamp( 19, currDate );
				pstmtHdr.setString( 20, termId );
				pstmtHdr.setNull( 21, java.sql.Types.DATE );
				pstmtHdr.setString( 22, empCodeAprv );
				pstmtHdr.setTimestamp( 23, currDate );
				pstmtHdr.setString( 24, ( tranType == null || tranType.trim().length() == 0 ? "" :tranType.trim() ) );
				pstmtHdr.setString( 25, ( itemSer == null || itemSer.trim().length() == 0 ? "" : itemSer.trim() ) );
				//pstmtHdr.setDouble( 26, drcrAmt );
				pstmtHdr.setDouble( 26, roundAmt * exchgRate);
				pstmtHdr.setString( 27, ( tranIdSel == null || tranIdSel.trim().length() == 0 ? "" :  tranIdSel.trim() ) );
				pstmtHdr.setString( 28, "" ); //ADJ_MISC_CRN
				pstmtHdr.setDouble( 29, 0.0 ); //ADJ_AMOUNT
				pstmtHdr.setString( 30, "" ); //PARENT__TRAN_ID
				pstmtHdr.setString( 31, "" ); //REV__TRAN
				pstmtHdr.setDouble( 32, 0.0 ); //ROUND_ADJ
				//pstmt.setInt( 33, 0 ); //LINE_NO__SRET
				//pstmt.setInt( 34, 0 ); //LINE_NO__SRET
				//pstmt.setString( 35, "" ); //LOT_NO
				pstmtHdr.setString( 33, "" ); //CUST_REF_NO
				pstmtHdr.setNull( 34, java.sql.Types.DATE ); //CUST_REF_DATE
				pstmtHdr.setDouble( 35, 0.0 ); //CUST_REF_AMT
				pstmtHdr.setDouble( 36, 0.0 ); //RND_OFF
				pstmtHdr.setDouble( 37, 0.0 ); //RND_TO

				int updtCnt = pstmtHdr.executeUpdate();*/
				//System.out.println("updtCnt==>"+updtCnt);
				//-----------------------Inserting into detail-----------------------------------
				
				System.out.println("drcrAmt in debit detail"+drcrAmt);
				System.out.println("grossAmount in debit detail"+grossAmount);
				llLineNo = 0;
				
				analCode = finCommon.getFinparams("999999", "ANAL_CODE", conn);
				
				System.out.println("analCode:::"+analCode);
				
				xmlBuffDet = new StringBuffer();
				
				xmlBuffDet.append("<Detail2 dbID=\"\" domID=\"1\" objName=\"misc_drcr_rcp_dr\" objContext=\"1\">");  
				xmlBuffDet.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
				xmlBuffDet.append("<tran_id/>");	
				llLineNo++;
				xmlBuffDet.append("<line_no><![CDATA["+ llLineNo   +"]]></line_no>");
				xmlBuffDet.append("<acct_code><![CDATA["+ detAcct   +"]]></acct_code>");
				xmlBuffDet.append("<cctr_code><![CDATA["+ detCctr   +"]]></cctr_code>");
				
				
				
				//CHANGED BY POONAM
				
				/*pstmtDtl.setString( 1, drNtTranId );
				llLineNo++;
				pstmtDtl.setInt( 2, llLineNo );
				pstmtDtl.setString( 3, detAcct );
				pstmtDtl.setString( 4, detCctr );*/
				
				if(drcrAmt < 0)
				{
					drcrAmt = drcrAmt * (-1);
				}
				if(grossAmount < 0)
				{
					grossAmount = grossAmount * (-1);
				}
				if(taxAmt < 0)
				{
					taxAmt = taxAmt * (-1);
				}
				System.out.println("drcrAmt in debit detail"+drcrAmt);
				System.out.println("grossAmount in debit detail"+grossAmount);
				System.out.println("taxAmt in debit detail"+taxAmt);

				//if( claimAmt > 0 && claimAmt < netAmt )
				//{
					//pstmtDtl.setDouble( 5, drcrAmt );
					//pstmtDtl.setDouble( 6, drcrAmt );
					//CHANGED BY POONAM
					xmlBuffDet.append("<amount><![CDATA["+ grossAmount   +"]]></amount>");
					xmlBuffDet.append("<net_amt><![CDATA["+ drcrAmt   +"]]></net_amt>");
					xmlBuffDet.append("<net_amt><![CDATA["+ taxAmt   +"]]></net_amt>");
				//}
				/*else
				{
					//pstmtDtl.setDouble( 5, grossAmount );
					//pstmtDtl.setDouble( 6, grossAmount );
					//CHANGED BY POONAM
					xmlBuffDet.append("<amount><![CDATA["+ grossAmount   +"]]></amount>");
					xmlBuffDet.append("<net_amt><![CDATA["+ grossAmount   +"]]></net_amt>");
				}*/
				//CHANGED BY POONAM
				/*pstmtDtl.setString( 7, tranIdSel ); //ref_no
				pstmtDtl.setString( 8, ( reasonCd == null || reasonCd.trim().length() == 0 ? "" : reasonCd.trim() ) ); //reas_code
				pstmtDtl.setString( 9, "" ); //ANAL_CODE
*/				
				
				xmlBuffDet.append("<ref_no><![CDATA["+ tranIdSel   +"]]></ref_no>");
				xmlBuffDet.append("<reas_code><![CDATA["+  checkNull(reasonCd)    +"]]></reas_code>");
				xmlBuffDet.append("<anal_code><![CDATA["+ analCode   +"]]></anal_code>");
				xmlBuffDet.append("<tax_class><![CDATA["+ checkNull(taxClass) +"]]></tax_class>");
				xmlBuffDet.append("<tax_chap><![CDATA["+ checkNull(taxChap) +"]]></tax_chap>");
				xmlBuffDet.append("<tax_env><![CDATA["+ checkNull(taxEnv) +"]]></tax_env>");
				
				xmlBuffDet.append("</Detail2>");

				//Changed by poonam :taxtran not required
				
				/*pstmtDtl.addBatch();

				sql = "select acct_code, cctr_code, sum(tax_amt) taxamt "
					+" from taxtran "
					+" where tran_code = 'S-CHB' and tran_id = ? "
					+" and tax_amt <> 0 "
					+" and effect <> 'N' "
					+" group by acct_code, cctr_code " ;
				//
				pstmt1 = conn.prepareStatement(sql);
				pstmt1.setString(1, tranIdSel);
				rSet = pstmt1.executeQuery();
				while( rSet.next() )
				{
					acctCodeTax = rSet.getString( "acct_code" );
					cctrCodeTax = rSet.getString( "acct_code" );
					amtTax =  rSet.getDouble( "taxamt" );

					if( acctCodeTax == null || acctCodeTax.trim().length() == 0 )
					{
						acctCodeTax = detAcct;
					}
					if( cctrCodeTax == null || cctrCodeTax.trim().length() == 0 )
					{
						cctrCodeTax = detCctr;
					}

					total = total + amtTax;

					pstmtDtl.setString( 1, drNtTranId );

					llLineNo++;
					pstmtDtl.setInt( 2, llLineNo );
					pstmtDtl.setString( 3, acctCodeTax );
					pstmtDtl.setString( 4, acctCodeTax );
					pstmtDtl.setDouble( 5, amtTax);
					pstmtDtl.setDouble( 6, 0.0 );
					pstmtDtl.setString( 7, "" ); //ref_no
					pstmtDtl.setString( 8, "" ); //reas_code
					pstmtDtl.setString( 9, "" ); //ANAL_CODE

					pstmtDtl.addBatch();
					
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;

				pstmtDtl.executeBatch();

				pstmtDtl.close();
				pstmtDtl = null;
				pstmtHdr.close();
				pstmtHdr = null;*/

				

				/*sql = "select nvl(round,'N') ls_round, nvl(round_to,0.001) lc_round_to from customer where cust_code = ? ";
				pstmt1 = conn.prepareStatement( sql );
				pstmt1.setString(1, custCodeCr );
				rSet = pstmt1.executeQuery();
				if( rSet.next() )
				{
					round = rSet.getString( "ls_round" );
					roundTo = rSet.getDouble( "lc_round_to" );
				}
				rSet.close();
				rSet = null;
				pstmt1.close();
				pstmt1 = null;

				roundAmt = disComm.getRndamt( drcrAmt, round, roundTo );
				diffAmt = roundAmt - drcrAmt;*/
				
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			xmlBuff.append("</Detail1>");
			xmlBuff.append(xmlBuffDet);
			xmlBuff.append("</Header0>");
			xmlBuff.append("</group0>");
			xmlBuff.append("</DocumentRoot>");
			xmlString = xmlBuff.toString();
			System.out.println("@@@@@2: xmlString:"+xmlBuff.toString());
			System.out.println("...............just before savdata distorder()");
			siteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			System.out.println("== site code =="+siteCode);
			errString = saveData(siteCode,xmlString,xtraParams,conn);
			System.out.println("@@@@@2: retString:"+errString);
			System.out.println("--retString finished--");
			if (errString.indexOf("Success") > -1)
			{
				System.out.println("@@@@@@3: Success"+errString);
				dom = genericUtility.parseString(errString);
				System.out.println("dom>>>"+dom);
				drNtTranId = genericUtility.getColumnValue("TranID",dom);
			}
			else
			{
				System.out.println("[SuccessSuccess" + errString + "]");	
				conn.rollback();
				return errString;
			}
			
			
			sql = "update charge_back set "
					+" tran_id__crn = ? "
					+" where tran_id = ? ";

			pstmt1 = conn.prepareStatement( sql );
			pstmt1.setString(1, drNtTranId );
			pstmt1.setString(2, tranIdSel );
			int updCount = 0 ;
			updCount = pstmt1.executeUpdate();

			if( updCount == 0 )
			{
				errCode = "DS000NR";
					//break;
			}
			pstmt1.close();
			pstmt1 = null;
			
			

			if( "Y".equalsIgnoreCase( asPost )  )
			{
				conn.commit();
				retString = retrieveMiscDrcrRcp( "misc_drcr_rcp",drNtTranId,xtraParams,"N" );
				errCode = getErrCodeFromErrStr(retString);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtDtl != null)
				{
					pstmtDtl.close();
					pstmtDtl = null;
				}
				if(pstmtHdr != null)
				{
					pstmtHdr.close();
					pstmtHdr = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception ChrgBckLocConfEJB....... :\n"+e.getMessage());
			}
		}
		return errCode;
	}
	// Added for Debit note generation if amt < 0: Start
	
	private String saveData(String siteCode,String xmlString, String xtraParams,Connection conn) throws ITMException
	{
		System.out.println("saving data...........");
		InitialContext ctx = null;
		String retString = null;
		MasterStatefulLocal masterStateful = null; // for ejb3
		ibase.utility.UserInfoBean userInfo;
		String chgUser = "", chgTerm = "";
		String loginCode = "", loginEmpCode = "", loginSiteCode = "";
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
			System.out.println("-----------masterStateful------- " + masterStateful);
			String [] authencate = new String[2];
			authencate[0] = "";
			authencate[1] = "";
			System.out.println("xmlString to masterstateful [" + xmlString + "]");
			
			userInfo = new ibase.utility.UserInfoBean();
			System.out.println("xtraParams>>>>" + xtraParams);
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgUser");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			userInfo.setEmpCode(loginEmpCode);
			userInfo.setRemoteHost(chgTerm);
			userInfo.setSiteCode(loginSiteCode);
			userInfo.setLoginCode(loginCode);
			userInfo.setEntityCode(loginEmpCode);
			System.out.println("userInfo>>>>>" + userInfo);

			System.out.println("chgUser :" + chgUser);
			System.out.println("chgTerm :" + chgTerm);
			System.out.println("loginCode :" + loginCode);
			System.out.println("loginEmpCode :" + loginEmpCode);
			
			//retString = masterStateful.processRequest(userInfo, siteCode, true, xmlString,true,conn);
			retString = masterStateful.processRequest(userInfo, xmlString, true, conn);
			System.out.println("--retString - -"+retString);
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :CreateDistOrder :saveData :==>");
			throw itme;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :CreateDistOrder :saveData :==>");
			throw new ITMException(e);
		}
		return retString;
	}
	private String checkNull(String input)	
	{
		if (input == null)
		{
			input="";
		}
		return input.trim();
	}
}
