package ibase.dashboard.gst.servlet;
import ibase.dashboard.gst.ejb.TransactionInOutEJBRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

@SuppressWarnings("serial")
public class TranTypeDetailServlet extends HttpServlet
{

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		 doPost( request, response );
	}
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		TransactionInOutEJBRemote transactionInOutEJBRemote = null;
		InitialContext context                = null;
		AppConnectParm appConnectParm         = new AppConnectParm();
		JSONObject jsonObjData                = null;
		OutputStream outputStream             = null;
		ibase.utility.UserInfoBean userInfo = null;
		String dataSourceName                 = "";
		String periodCode                     = "";
		String titleTran                  	  = "";
		String sessionSiteCode                = "";
		String tranType						  = "";
		String status = "", gstcode = "";
		try
		{
			response.setContentType("application/xml");			
			HttpSession session = request.getSession(true);
			userInfo 			= (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			sessionSiteCode 	= userInfo.getSiteCode();
			System.out.println("SessionSiteCode: "+sessionSiteCode);
			dataSourceName 		= request.getParameter("dataSourceName");
			periodCode   		= request.getParameter("periodCode");
			titleTran   		= checkNull(request.getParameter("titleTran"));
			tranType			= request.getParameter("tranType");
			status				= request.getParameter("GST_STATUS");
			gstcode				= request.getParameter("GST_NUMBER");
			System.out.println("===================tranType: "+tranType);
			titleTran = titleTran.replace("%20", " ");
			gstcode = gstcode.replace("%20", " ");
			context        		= new InitialContext(appConnectParm.getProperty());
			transactionInOutEJBRemote = (TransactionInOutEJBRemote) context.lookup("ibase/TransactionInOutEJB/remote");
			jsonObjData         = (JSONObject) transactionInOutEJBRemote.getTransactionTypeDetail(dataSourceName, periodCode, sessionSiteCode,titleTran,tranType,status,gstcode);			
			outputStream        = response.getOutputStream();
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for TranTypeDetailServlet build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : TranTypeDetailServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

	private String checkNull(String str)
   	{
   		if(str == null)
   		{
   			return "";
   		}
   		else
   		{
   			return str.trim();
   		}
   	} 	
	
	
}