package ibase.webitm.ejb.adm;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.adm.AdmCommon;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.utility.TransIDGenerator;
import ibase.utility.CommonConstants;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;

import org.w3c.dom.*;


@javax.ejb.Stateless
public class FullFinalPos extends ValidatorEJB implements FullFinalPosLocal, FullFinalPosRemote
{
	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	public String postSave(String xmlString, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{

		String tranId = "";
		String errString = "";
		String sql = "";
		String errCode = "";
		String confirmedFlag = "";
		
		double totAmtHdr = 0d;
		double amtHdr = 0d;
		double totAmtDet = 0d;
		double totNetAmtDet = 0d;

		int updCnt = 0;

		PreparedStatement pstmt = null;		
		ResultSet rs = null;


		ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();		
		AdmCommon admCommon = new AdmCommon();
		GenericUtility genericUtility = GenericUtility.getInstance();


		Document headerDom = null;

		try
		{

			System.out.println("XML String :"+xmlString);
			headerDom = genericUtility.parseString(xmlString); 				

			tranId = checkNullAndTrim(genericUtility.getColumnValue("tran_id",headerDom));
			sql = "SELECT SUM(CASE WHEN NET_AMT IS NULL THEN 0 ELSE NET_AMT END) AS NET_AMT , SUM(CASE WHEN AMOUNT IS NULL THEN 0 ELSE AMOUNT END) AS AMOUNT FROM FULLFINAL_DET WHERE TRAN_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1 , tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				totNetAmtDet = rs.getDouble("NET_AMT");
				totAmtDet = rs.getDouble("AMOUNT");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			sql = "UPDATE FULLFINAL_HDR SET TOTAL_AMT = ? , AMOUNT = ? WHERE TRAN_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setDouble(1 , totNetAmtDet);
			pstmt.setDouble(2 , totAmtDet);
			pstmt.setString(3 , tranId);
			updCnt = pstmt.executeUpdate();
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			try
			{

				System.out.println("Exception IN FullFinalPos::::"+e.getMessage());
				e.printStackTrace();			
				throw new ITMException(e);
			}
			catch (Exception e1)
			{
				e1.printStackTrace();
				throw new ITMException(e1);
			}
		}
		finally
		{
			try
			{	
				if(errString != null && errString.trim().length() > 0)
				{
					{
						conn.rollback();
					}
				}

				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception in FullFinalPos "+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}

	private String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal.trim();
	}
}

