package ibase.e12ria.e12table.client;

import ibase.e12ria.e12table.client.E12CustomTextCell.CellData;

import java.util.HashMap;
import java.util.Iterator;

/**
 * 
 * It's a model class used to save the row Data of AdvDataGrid table in the form
 * of object.
 */
public class DataGridTableRowModel {

	private String domID ;
	private HashMap<Integer, E12CustomTextCell.CellData> rowData ;
	
	public DataGridTableRowModel(String domID, HashMap<Integer, E12CustomTextCell.CellData> rowData)
	{
		this.domID = domID;
		this.rowData = rowData;
	}

	public DataGridTableRowModel(HashMap<Integer, E12CustomTextCell.CellData> rowData)
	{
		this.rowData = rowData;
	}

	/**
	 * returns the column value for DataGrid Table
	 * 
	 * @param index
	 * @return String
	 */
	public String getCellText(int index) 
	{
		if ( rowData.containsKey(index) ) 
		{
			return rowData.get(index).getData();
		} 
		return "";
	}
	
	/**
	 * returns the column value for DataGrid Table
	 * 
	 * @param colName
	 * @return String
	 */
	public String getCellText( String colName ) 
	{
		Iterator<Integer> keyIterator = rowData.keySet().iterator();
		while( keyIterator.hasNext() )
		{
			int keyIndex = keyIterator.next();
			CellData cellData = rowData.get( keyIndex );
			if( cellData != null && colName.equalsIgnoreCase( cellData.getName() ) )
			{
				return cellData.getData();
			}
		}
		
		return "";
	}
	
	public E12CustomTextCell.CellData getCellData(int index)
	{
		if ( rowData.containsKey(index) ) 
		{
			return rowData.get(index);
		} 
		return null;
	}
	
	public void setCellData(int index, E12CustomTextCell.CellData cellData)
	{
		rowData.put(index, cellData);
	}
	
	@Override
	public String toString() {
		return "[\n\t columnData: " + rowData + "]";
	}

	public String getDomID() 
	{
		return domID;
	}
	
	public HashMap<Integer, CellData> getRowData()
	{
		return rowData;
	}
	
	public int getIntDomID() 
	{
		return (int) Double.parseDouble(domID);
	}
}
