/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.bean;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMFreeFormRemote;
import ibase.webitm.ejb.XSLBuilderRemote;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ITMFreeFormBean
implements Serializable {
    String objName;
    String pContext = "2";
    String objContext = "1";
    String editFlag = "A";
    String reqParamStr = "";
    private boolean isDataFound = true;
    String userLang = "en";
    String userCountry = "US";
    UserInfoBean userInfo = null;

    public void setObjName(String string) {
        this.objName = string;
    }

    public String getObjName() {
        return this.objName;
    }

    public void setPContext(String string) {
        if (string != null && !"null".equalsIgnoreCase(string) && string.length() > 0) {
            this.pContext = string;
        }
    }

    public String getPContext() {
        return this.pContext;
    }

    public void setObjContext(String string) {
        if (string != null && !"null".equalsIgnoreCase(string) && string.length() > 0) {
            this.objContext = string;
        }
    }

    public String getObjContext() {
        return this.objContext;
    }

    public void setEditFlag(String string) {
        if (string != null && !"null".equalsIgnoreCase(string) && string.length() > 0) {
            this.editFlag = string;
        }
    }

    public String getEditFlag() {
        return this.editFlag;
    }

    public void setRequestParamStr(String string) {
        this.reqParamStr = string;
    }

    public boolean isDataFound() {
        return this.isDataFound;
    }

    public void setUserInfo(UserInfoBean userInfoBean) {
        this.userInfo = userInfoBean;
    }

    public String getHTMLData() throws ITMException {
        String string = "";
        try {
            GenericUtility genericUtility = new GenericUtility();
            String string2 = this.getXSLFileName();
            String string3 = this.getXMLData();
            if (string3 != null && string3.length() > 0) {
                Document document = genericUtility.parseString(string3);
                NodeList nodeList = document.getElementsByTagName("Detail1");
                if (nodeList.item(0) != null) {
                    String string4 = CommonConstants.APPLICATION_CONTEXT + File.separator + "temp";
                    string = genericUtility.transformToString(string2, string3, string4, "Output", ".html");
                } else {
                    this.isDataFound = false;
                }
            }
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
        return string;
    }

    public String getXMLData() throws ITMException {
        String string = null;
        try {
            if (this.userInfo != null) {
                InitialContext initialContext = new InitialContext(new AppConnectParm().getProperty());
                ITMFreeFormRemote iTMFreeFormRemote = (ITMFreeFormRemote)initialContext.lookup("ibase/ITMFreeFormEJB/remote");
                if ("A".equalsIgnoreCase(this.editFlag)) {
                    string = iTMFreeFormRemote.getBlankAddForm(this.objName, this.objContext, this.objName + this.pContext + this.objContext, this.reqParamStr, this.userInfo);
                } else if ("V".equalsIgnoreCase(this.editFlag)) {
                    string = iTMFreeFormRemote.getViewFreeForm(this.objName, this.objContext, this.objName + this.pContext + this.objContext, this.reqParamStr, this.userInfo);
                }
            } else {
                string = "ERR_MSG :User Info not in session";
            }
        }
        catch (ITMException iTMException) {
            throw iTMException;
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
        return string;
    }

    private String getXSLFileName() throws ITMException {
        String string = null;
        try {
            File file;
            String string2 = null;
            string2 = CommonConstants.APPLICATION_CONTEXT != null ? CommonConstants.APPLICATION_CONTEXT + "webitm" + File.separator : ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + "webitm" + File.separator;
            String string3 = this.objName + this.pContext + this.objContext + "_" + this.userLang + "_" + this.userCountry + "_" + this.editFlag + ".xsl";
            if (!new File(string2 + File.separator + "xsl" + File.separator + CommonConstants.THEME).exists()) {
                System.out.println(" ITMFreeFormBean::creating  theme folder");
                new File(string2 + File.separator + "xsl" + File.separator + CommonConstants.THEME).mkdir();
            }
            if ((file = new File(string2 + File.separator + "xsl" + File.separator + CommonConstants.THEME, string3)).exists()) {
                string = file.getAbsolutePath();
            } else {
                AppConnectParm appConnectParm = new AppConnectParm();
                Properties properties = appConnectParm.getProperty();
                InitialContext initialContext = new InitialContext(properties);
                XSLBuilderRemote xSLBuilderRemote = (XSLBuilderRemote)initialContext.lookup("ibase/XSLBuilderEJB/remote");
                String string4 = xSLBuilderRemote.buildXSLString(this.objName, this.objContext, this.userLang, this.userCountry, this.pContext, this.editFlag, CommonConstants.APPLICATION_CONTEXT, this.userInfo.getProfileIdRes());
                if (!string4.endsWith(".xsl")) {
                    byte[] byArray = string4.getBytes();
                    int n = byArray.length;
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray, 0, n);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    fileOutputStream = null;
                    string = file.getAbsolutePath();
                } else {
                    string = string4;
                }
            }
        }
        catch (Exception exception) {
            throw new ITMException(exception);
        }
        return string;
    }
}

