/*
 * Author: Wasim Ansari
 * Date: 26-SEP-2016
 * Request: S16EBAS006 (Sale Order Wizard)
 */

package ibase.webitm.servlet.wms;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.webitm.bean.wms.SorderWizBean;
import ibase.webitm.ejb.dis.SalesOrderICRemote;
import ibase.webitm.ejb.wms.SorderWizardEJB;
import ibase.webitm.ejb.wms.SorderWizardEJBRemote;
import ibase.webitm.servlet.Messages;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.zip.GZIPOutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;



public class SorderWizHandlerServlet extends HttpServlet
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		doPost( request, response );
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		System.out.println("XXXXXXXXXXXXXXXXXXXXXX[ SorderWizHandlerServlet ]XXXXXXXXXXXXXXXXXXXX");
		
		request.setCharacterEncoding(CommonConstants.ENCODING);
		
		String htmlData = "",action = ""; //$NON-NLS-1$
		//SorderWizBean sordBeanObj = new SorderWizBean();
		//SorderWizardEJB sorderObj = new SorderWizardEJB();
		SorderWizardEJBRemote sordBeanObj = null;
		
		try
		{
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = ( ibase.utility.UserInfoBean )session.getAttribute( "USER_INFO" );
			
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sordBeanObj = (SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			
			if(userInfo != null)
			{
				action = checkNullAndTrim(request.getParameter("ACTION"));
				
				System.out.println("Action ["+action+"]");
				
				if("ITEM_CHANGE".equalsIgnoreCase(action))
				{
					//String saleOrder = checkNullAndTrim(request.getParameter("SALE_ORDER"));
					String field = checkNullAndTrim(request.getParameter("FIELD"));
					String fieldValue = checkNullAndTrim(request.getParameter("FIELD_VALUE"));
					
					String result = "";
					
					System.out.println("Field=["+field+"]  Field Value["+fieldValue+"]");
					
					if("SALE_ORDER".equalsIgnoreCase(field))
					{
						String flag = checkNullAndTrim(request.getParameter("FLAG"));
						result = sordBeanObj.getSorderHeader(fieldValue, flag);
					}
					else if("CUST_CODE".equalsIgnoreCase(field) || "CUST_CODE__DLV".equalsIgnoreCase(field) || "CUST_CODE__BIL".equalsIgnoreCase(field))
					{
						/*String [] values = fieldValue.split(",");//This just for TimePass
						String details = "";
						//result = sorderObj.getList(fieldValue, field, values,details);
						result = sordBeanObj.getList(fieldValue, field, values,details);*/
						
						String currXmlDataStr = "", hdrXmlDataStr = "", allXmlDataStr = "", currentColumn = "", objContext = "", editFlag = "";
						
						currXmlDataStr = checkNullAndTrim(request.getParameter("CUR_XML_STR"));
						hdrXmlDataStr = checkNullAndTrim(request.getParameter("HDR_XML_STR"));
						allXmlDataStr = checkNullAndTrim(request.getParameter("ALL_XML_STR"));
						currentColumn = checkNullAndTrim(request.getParameter("CUR_COLUMN"));
						objContext = checkNullAndTrim(request.getParameter("OBJ_CONTEXT"));
						editFlag = checkNullAndTrim(request.getParameter("EDIT_FLAG"));
						
						SalesOrderICRemote sordICObj = null;
						sordICObj = (SalesOrderICRemote) ctx.lookup("ibase/SalesOrderIC/remote");
						result = sordICObj.itemChanged(currXmlDataStr, hdrXmlDataStr, allXmlDataStr, objContext, currentColumn, editFlag, "");
					}
					else if("ITEM_CODE".equalsIgnoreCase(field))
					{
						String dlvDate = "";
						String details = "";
						String otherDetails = checkNullAndTrim(request.getParameter("OTHER_DETAILS"));
						result = sordBeanObj.getSKUDetail(fieldValue,dlvDate,details,otherDetails);
						
						//sendResponse(response,productSet);
					}
					
					sendResponse(response,result);
				}
				else if("GET_SORD_DET_2".equalsIgnoreCase(action))
				{
					String siteCode = checkNullAndTrim(request.getParameter("SITE_CODE"));
					String empCode  = checkNullAndTrim(request.getParameter("EMP_CODE"));
					String status   = checkNullAndTrim(request.getParameter("STATUS"));
					String saleOrder= checkNullAndTrim(request.getParameter("SALE_ORDER"));
					
					String retString   = sordBeanObj.getSorderDetail2(siteCode,empCode,saleOrder,status);
					
					sendResponse(response,retString);
				}
				else if("PRODUCT_SET".equalsIgnoreCase(action))
				{
					String dlvDate = checkNullAndTrim(request.getParameter("DLV_DATE"));
					String details = checkNullAndTrim(request.getParameter("TRANTYPE"));
					String itemParent = checkNullAndTrim(request.getParameter("ITEM_CODE"));
					String otherDetails = checkNullAndTrim(request.getParameter("OTHER_DETAILS"));
					System.out.println("Item Parent="+itemParent);
					
					String productSet = sordBeanObj.getSKUDetail(itemParent,dlvDate,details,otherDetails);
					
					sendResponse(response,productSet);
				}
				/*else if("SAVE_SORD_HEADER".equalsIgnoreCase(action))
				{
					String data = checkNullAndTrim(request.getParameter("STR"));
					String result = sordBeanObj.SaveSorderHeader(data);
				}*/
				else if("SAVE_SORD_DETAIL".equalsIgnoreCase(action))
				{
					String data = checkNullAndTrim(request.getParameter("STR"));
					String result = sordBeanObj.SaveSorderDetail(data);
					
					System.out.println("Result="+result);
					sendResponse(response,result);
				}
				else if("RESET_HEADER".equalsIgnoreCase(action))
				{
					String data = checkNullAndTrim(request.getParameter("STR"));
					String result = sordBeanObj.ResetHeader(data);
				}
				else if("AUTO_SEARCH".equalsIgnoreCase(action))
				{
					String field = checkNullAndTrim(request.getParameter("FIELD"));
					String searchStr = checkNullAndTrim(request.getParameter("SEARCH_STR"));
					String param = checkNullAndTrim(request.getParameter("PARAM"));
					String[] fieldValue = searchStr.split(",");
					//String result = sorderObj.getAutoSearchData(searchStr,field);
					String result = sordBeanObj.getAutoSearchData(searchStr,field, param);
					//String result = sorderObj.getList(searchStr, field, fieldValue);
					
					sendResponse(response,result);
				}
				else if ("previous".equalsIgnoreCase(request.getParameter("action")))
				{	
					String objName 	= request.getParameter("OBJ_NAME");//Storing ObjectName //$NON-NLS-1$
					String formNo 	= request.getParameter("FORM_NO");//Storing Current FormNo //$NON-NLS-1$
					action	= request.getParameter("action");//Which actions is performed e.g. 'Next','Previous','Finish' //$NON-NLS-1$
					//String formType = request.getParameter("formType");//Type of form to implement MultipleForms //$NON-NLS-1$
					//String forceSave = request.getParameter("forceSave");//To override Warnings from Business Components //$NON-NLS-1$
					
					String preFormVal = request.getParameter("PRE_FORM_VAL");
					
					String editorId = (String) request.getSession().getAttribute( "WIZARD_BEAN_ID_" + objName );
			        System.out.println(" SorderWizHandlerServlet :: editorId["+editorId+"]" );
			        
					if (request.getSession().getAttribute("WIZARD_BEAN_" + editorId) != null) 
					{
						System.out.println(" Wizard Object Found ");
		
						if ("2".equalsIgnoreCase(formNo)) 
						{
							request.getRequestDispatcher("/webitm/jsp/sorderWizFormI.jsp").forward(request, response);
						}
						if ("3".equalsIgnoreCase( formNo )  )
						{
							request.getSession().removeAttribute( "WIZARD_BEAN_" + objName );
							request.getRequestDispatcher("/webitm/jsp/sorderWizFormII.jsp").forward(request, response);
						}
					}
				}
				else if("GET_DOCID".equalsIgnoreCase(action))
				{
					String refSer = checkNullAndTrim(request.getParameter("REF_SER"));
					String refId = checkNullAndTrim(request.getParameter("REF_ID"));
					String imgStr = checkNullAndTrim(request.getParameter("IMG_STR"));

					String result = sordBeanObj.getDocIDImages(refSer,refId,imgStr);
					
					sendResponse(response,result);
				}
				else if("GET_DEFAULT_VALUES_FLAG".equalsIgnoreCase(action))
				{
					String varName = checkNullAndTrim(request.getParameter("VAR_NAME"));
					String result = sordBeanObj.getDefaultValuesFlag(varName);
					sendResponse(response,result);
				}
				else if("GET_DEFAULT_VALUES".equalsIgnoreCase(action))
				{
					String fileName = checkNullAndTrim(request.getParameter("FILE_NAME"));
					JSONObject jsonObject = new JSONObject();
					jsonObject = sordBeanObj.getDefaultValuesfromJSON(fileName);
					sendResponse(response,jsonObject.toString());
				}
			}//End if user info
			else
			{
				htmlData = Messages.getString("SorderWizHandlerServlet_UserNotLogin")+"\n"+Messages.getString("SorderWizHandlerServlet_pleaseReLogin"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception inside SorderWizHandlerServlet ==>"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			if(sordBeanObj != null)
			{
				sordBeanObj = null;
			}
		}
	}
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	public void sendResponse(HttpServletResponse response,String retString)
	{
		try
		{
			response.setContentType("text/xml");
            
            if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
			{
				response.setHeader("Content-Encoding", "gzip");
				GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
				gzOutStream.write(retString.getBytes());
				gzOutStream.flush();
				gzOutStream.close();
			}
			else
			{
				response.setHeader("Content-Encoding", "");
				OutputStream outStream = response.getOutputStream();
				outStream.write(retString.getBytes());
				outStream.flush();
				outStream.close();
			}
		}
		catch(Exception e)
		{
			System.out.println("Inside catch sendResponse");
			e.printStackTrace();
		}
	}
}
