package ibase.webitm.ejb.fin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

import javax.xml.rpc.ParameterMode;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
//import org.apache.poi.xssf.usermodel.XSSFSheet;
//import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;




import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.reports.utility.ArgumentHandler;
import ibase.webitm.reports.utility.JasperReportGenerator;
import ibase.webitm.reports.utility.ResourceConstants;
import ibase.webitm.reports.utility.XSDParser;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

public class InvoiceRanbaxyReportSch implements Schedule
{

	E12GenericUtility genericUtility = new E12GenericUtility();
	FileOutputStream fos1 = null;
	Calendar calendar = Calendar.getInstance();
	java.util.Date startDate = new java.util.Date(System.currentTimeMillis());
	String startDateStr = null;

	@Override
	public String schedule(String scheduleParamXML) throws Exception, ITMException
	{
		ibase.utility.UserInfoBean userInfo = null;
		String loginSiteCode = "";
		try
		{
			Document dom = null;
			String xtraParams = "", siteList = "";
			int childNodeListLength = 0;
			String childNodeName = null;
			String voucher_date = "", sysDate = "",entityCode="";

			NodeList parentNodeList = null, childNodeList = null;
			Node parentNode = null, childNode = null;
			SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getDBDateFormat());

			Node currDetail = null;
			int noOfParam = 0;

			System.out.println("@V@  InvoiceRanbaxyReportSch scheduleParamXML[" + scheduleParamXML + "]");
			userInfo = new ibase.utility.UserInfoBean(scheduleParamXML);
			loginSiteCode = userInfo.getSiteCode();
			entityCode=userInfo.getEntityCode();
			System.out.println("@V@ IntializingLog " + intializingLog("Rnbaxy_Inv_report_log"));
			System.out.println("@V@ Log in Site code" + loginSiteCode + "]");
			xtraParams = "loginEmpCode=" + userInfo.getEmpCode() + "~~loginCode=" + userInfo.getLoginCode() + "~~termId="
			+ userInfo.getRemoteHost() + "~~loginSiteCode=" + loginSiteCode+"~~entityCode="+entityCode;

			dom = genericUtility.parseString(scheduleParamXML);

			// NodeList paramList = dom.getElementsByTagName( "SCHEDULE" );
			// noOfParam = paramList.getLength();
			//
			// parentNodeList = dom.getElementsByTagName("ACTUALPARAMETERS");
			// parentNode = parentNodeList.item(0);
			// childNodeList = parentNode.getChildNodes();
			// childNodeListLength = childNodeList.getLength();
			// System.out.println("@V@ CshildNodeListLength :-["+childNodeListLength+"]");

			invoiceRanbaxyReportSch(xtraParams);

		} catch (Exception e)
		{

			System.out.println("@V@ Exception :SplitSchedularSOrder :schedule :Exception :==>\n" + e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (fos1 != null)
				{
					fos1.close();
					fos1 = null;
				}
			} catch (Exception e)
			{
				System.out.println("@V@ Exception" + e.getMessage());
			}
		}
		return "";
	}

	private String intializingLog(String fileName)
	{
		String log = "intializingLog_Failed";
		String strToWrite = "";
		String currTime = null;
		try
		{
			SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getDBDateFormat());
			try
			{
				currTime = sdf1.format(new Timestamp(System.currentTimeMillis())).toString();
				currTime = currTime.replaceAll("-", "");
				calendar.setTime(new java.sql.Timestamp(System.currentTimeMillis()));
				fileName = fileName + currTime + calendar.get(Calendar.HOUR) + "" + calendar.get(Calendar.MINUTE) + ".txt";
				fos1 = new FileOutputStream(CommonConstants.JBOSSHOME + File.separator + "EDI" + File.separator + fileName);
			} catch (Exception e)
			{
				System.out.println("@V@ Exception:-" + e.getMessage());
				e.printStackTrace();
			}
			startDate = new java.util.Date(System.currentTimeMillis());
			calendar.setTime(new java.sql.Timestamp(System.currentTimeMillis()));
			startDateStr = sdf1.format(startDate) + " " + calendar.get(Calendar.HOUR) + ":" + calendar.get(Calendar.MINUTE) + ":"
			+ calendar.get(Calendar.SECOND);
			fos1.write(("Fetching Records Started At " + startDateStr + "\r\n").getBytes());

		} catch (Exception e)
		{
			System.out.println("@V@ Exception2 :-" + e.getMessage());
			e.printStackTrace();
		}

		log = "intializingLog_Successesfull";
		return log;
	}

	private String checkNull(String input)
	{
		if (input == null)
		{
			input = "";
		}
		return input;
	}

	public void invoiceRanbaxyReportSch(String xtraParams) throws ITMException
	{
		ConnDriver connDriver = new ConnDriver();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		String sql = "", siteCode = "", custCode = "", emailAddr = "";
		String tranId = "", retString = "", reportName = "", reportArgs = "", reportType = "",formatCode="";


		reportName = "d_invoice_ranbaxy_report";
//		 reportArgs="tran_id.String:tran_id,user_id.String:as_user_id,site_code.String:as_site";
		 reportArgs="user_id.String:as_user_id,site_code.String:as_site,site_code.String:as_site_code,cust_code.String:as_cust_code";
//		reportArgs = "cust_code.String:custCode,site_code.String:siteCode";
		reportType = "EXCEL";
		
//		formatCode="DRCPSH";// send mail only for 'To'.
		formatCode="RBXINV";// send mail only for 'To'.

		String sqlCondition = "";
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			
			

			/**
			 * Select SQL condition from table DISPARM for
			 * var_name='INVOICE_SITE_RANBAXY'
			 * */
			DistCommon distCommon = new DistCommon();
			sqlCondition = distCommon.getDisparams("999999", "INVOICE_SITE_RANBAXY", conn);
			System.out.println("@V@ sqlCondition[" + sqlCondition + "]");

			/**
			 * Select cust_code, site_code
			 *  from table 'SITE_CUSTOMER'
			 * */
			sql = "SELECT CUST_CODE, SITE_CODE FROM SITE_CUSTOMER ";

			if (sqlCondition != null && sqlCondition.trim().length() > 0 && !(sqlCondition.equalsIgnoreCase("NULLFOUND")))
			{
				sql = sql + sqlCondition;
			}
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				siteCode = checkNull(rs.getString("SITE_CODE")).trim();
				custCode = checkNull(rs.getString("CUST_CODE")).trim();
				System.out.println("@V@ siteCode[" + siteCode + "]custCode[" + custCode + "]");

				fos1.write(("\n Site code is:-  [" + siteCode + "] and Customer code is :- [" + custCode + "]").getBytes());

				/**
				 * Generate Invoice report 
				 * for each cust_code and site_code pair
				 * */
//				reportName = reportName + "_" + custCode + "_" + siteCode+"_";
				
				retString=generateReport(custCode,siteCode,reportName,reportArgs,reportType,xtraParams,formatCode,conn);
				
				fos1.write(("\n Final Return String:-  [" +retString+ "]\n\n").getBytes());
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

		} catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} finally
		{
			if (rs != null)
			{
				try
				{
					rs.close();
				} catch (SQLException e)
				{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			if (pstmt != null)
			{
				try
				{
					pstmt.close();
				} catch (SQLException e)
				{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			if (conn != null)
			{
				try
				{
					conn.close();
				} catch (SQLException e)
				{
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			rs = null;
			pstmt = null;
			conn = null;
		}
	}

	private String generateReport(String custCode, String siteCode, String reportName, String reportArgs, String reportType, String xtraParams,
			String formatCode, Connection conn)
    {
	    // TODO Auto-generated method stub
		String retString="",xmlString="";
		
		/**
		 * Generate XML String
		 * */
		StringBuffer xmlBuff = null;
		xmlBuff = new StringBuffer();
				
		xmlBuff.append("<?xml version='1.0' encoding='UTF-8'?>\n");
		xmlBuff.append("<DocumentRoot>");
		xmlBuff.append("<description>").append("Datawindow Root").append("</description>");
		xmlBuff.append("<group0>");
		xmlBuff.append("<description>").append("Group0 description").append("</description>");
		xmlBuff.append("<Header0>");
//		xmlBuff.append("<objName><![CDATA[").append("distrcp_exsh").append("]]></objName>");  
		xmlBuff.append("<objName><![CDATA[").append("invoice_ranbaxy_report").append("]]></objName>"); 
		xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
		xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
		xmlBuff.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
		xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
		xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
		xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
		xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
		xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
		xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
		xmlBuff.append("<description>").append("Header0 members").append("</description>");
		xmlBuff.append("<Detail1 objContext=\"1\" objName=\"invoice_ranbaxy_report\" domID=\"\" dbID=\"\">"); 
		xmlBuff.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
		xmlBuff.append("<cust_code><![CDATA["+ custCode.trim() +"]]></cust_code>");
		xmlBuff.append("<site_code><![CDATA["+ siteCode.trim() +"]]></site_code>");
		xmlBuff.append("</Detail1>");
		xmlBuff.append("</Header0>");
		xmlBuff.append("</group0>");
		xmlBuff.append("</DocumentRoot>");
		
		xmlString = xmlBuff.toString();
		System.out.println("@V@ xmlString for sendReport:-["+xmlString+"]");
		
		retString= this.sendReport(custCode,siteCode,xmlString, reportName, reportArgs, reportType, formatCode, xtraParams, conn);
		
	    return retString;
    }

	private String sendReport(String custCode, String siteCode, String xmlString, String reportName, String reportArgs, String reportType,
			String formatCode, String xtraParams, Connection conn)
    {
		String resposeStr = "";
		String objName = "";
		String argumentString = "";
		ibase.utility.E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String messageStr = "SEND_SUCCESS";
		String sql="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String tranIdRcp="",siteCodeShip="",emailAddr="",retString = "",userType="",empCode="";
		java.util.Date  tranDate= null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		itmDBAccessEJB = new ITMDBAccessEJB();
		StringBuffer commInfo = new StringBuffer();
		boolean isError = false;
		boolean isFileNotEmpty=false;
		String reportDestination = "";
		String msgNo = "", mailRetStr="";
		try
		{
			System.out.println("@V@ xmlString :-"+xmlString);
			System.out.println("@V@ reportName :-["+reportName +"]");
			System.out.println("@V@ reportArgs :-["+reportArgs +"]");
			System.out.println("@V@ reportType :-["+reportType +"]");
			System.out.println("@V@ formatCode :-["+formatCode +"]");
			System.out.println("@V@ xtraParams :-["+xtraParams +"]");
			String argName = "";
			String argType = "";
			String rptArgName = "";
			String argValue = "";
			Document xmlDom = genericUtility.parseString(xmlString);
		
			if(reportName == null || reportName.trim().length() == 0)
			{
				isError = true;
				messageStr = itmDBAccessEJB.getErrorString("", "RPTNAMENF", "");
				generateLog(messageStr, reportName, reportDestination, formatCode, xtraParams);
			}
			else if(reportType == null || reportType.trim().length() == 0)
			{
				isError = true;
				messageStr = itmDBAccessEJB.getErrorString("", "RPTTYPENF", "");
				generateLog(messageStr, reportName, reportDestination, formatCode, xtraParams);
			}
			else if(formatCode == null || formatCode.trim().length() == 0)
			{
				isError = true;
				messageStr = itmDBAccessEJB.getErrorString("", "RPTFRMTNF", "");
				generateLog(messageStr, reportName, reportDestination, formatCode, xtraParams);	
			}
			else
			{
				if(reportArgs != null && reportArgs.trim().length() > 0)
				{
					String[] argNameArray= reportArgs.split(",");
					argumentString= "<Arguments>";
					for ( int cnt = 0 ; cnt < argNameArray.length ; cnt++ )
					{
						argName = argNameArray[cnt].substring( 0 , argNameArray[cnt].lastIndexOf("."));
						if(argNameArray[cnt].lastIndexOf(":") != -1)
						{
							rptArgName = argNameArray[cnt].substring( argNameArray[cnt].lastIndexOf(":") + 1 , argNameArray[cnt].length());
	
							argType = argNameArray[cnt].substring( argNameArray[cnt].lastIndexOf(".")+1 , argNameArray[cnt].lastIndexOf(":"));
						}
						else
						{
							rptArgName = argName;
							argType = argNameArray[cnt].substring( argNameArray[cnt].lastIndexOf(".")+1 );
						}
						if("login_site".equalsIgnoreCase(argName))
						{
							argValue = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
						}
						else if("user_id".equalsIgnoreCase(argName))
						{
							argValue = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
						}
						else if("terminal_id".equalsIgnoreCase(argName))
						{
							argValue = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
						}
						else if("entity_code".equalsIgnoreCase(argName))
						{
							argValue = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode");
						}
						else
						{
							argValue = genericUtility.getColumnValue(argName, xmlDom, "1");
						}
						
						argumentString += "<Argument id=\"" +  rptArgName + "\" name = \"" + rptArgName + "\">";
						argumentString += "<argType>" + argType +"</argType>"; 
						argumentString += "<value>" + argValue +"</value>";		
						argumentString += "</Argument>" ;
						
					}
					argumentString += "</Arguments>";
				}
				System.out.println("@V@ argumentString :- ["+argumentString+"]");
				
				String userName =  genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
				System.out.println("@V@ user name found from xtraParams :- ["+userName+"]");
//				String outputFilename = reportName + userName + System.currentTimeMillis();
				String outputFilename = reportName + custCode + System.currentTimeMillis();
//				String outputFilename = reportName;
				System.out.println("@V@ outputFilename :- ["+outputFilename+"]");
			
				if("HTML".equalsIgnoreCase(reportType) || "PDF".equalsIgnoreCase(reportType) || "CSV".equalsIgnoreCase(reportType)
						|| "CSVDATA".equalsIgnoreCase(reportType) || "EXCEL".equalsIgnoreCase(reportType) || "EXCELDATA".equalsIgnoreCase(reportType)
						|| "TEXT".equalsIgnoreCase(reportType) || "ODS".equalsIgnoreCase(reportType) || "EXCEL(XLSX)".equalsIgnoreCase(reportType))
				{
					System.out.println("@V@ Report extention found :- ["+reportType+"]");
					XSDParser xsdParser = new XSDParser(reportName);
					ArgumentHandler argObj = new ArgumentHandler(xsdParser);
					argObj.init();
					JasperReportGenerator  jasperReport= new  JasperReportGenerator();
					TreeMap argMap = jasperReport.createArgMap(argumentString);
					argMap.put("report_save_type", reportType);
					
					
					/**
					 * Check report file extension.
					 * */
					String rptExt = "";
					System.out.println("@V@ checking report ext @@");
					if("CSV".equalsIgnoreCase(reportType) || "CSVDATA".equalsIgnoreCase(reportType) )
					{
						rptExt = "csv";
					}
					else if("EXCEL".equalsIgnoreCase(reportType) || "EXCELDATA".equalsIgnoreCase(reportType) || "ODS".equalsIgnoreCase(reportType) )
					{
						rptExt = "xls";
					}
					else if("EXCEL(XLSX)".equalsIgnoreCase(reportType) )
					{
						rptExt = "xlsx";
					}
					else if("TEXT".equalsIgnoreCase(reportType) )
					{
						rptExt = "txt";
					}
					else
					{
						rptExt = reportType.toLowerCase();
					}
					System.out.println("@V@ Report ext found :- ["+rptExt+"] creating report now");
					
					System.out.println("@V@ Report Name :- ["+reportName+"]");
					System.out.println("@V@ Arg Map :- ["+argMap+"]");
					System.out.println("@V@ XSD Parser :- ["+xsdParser+"]");
					System.out.println("@V@ User Name :- ["+userName+"]");
					System.out.println("@V@ Out Put file name :- ["+outputFilename+"]");
					
					/**
					 * Generate Jasper report
					 * for Invoice
					 * */
					jasperReport.createReport(reportName ,argMap, xsdParser, userName,outputFilename);
					String reportOutputFileName = jasperReport.getOutputFileName(); 
					
					System.out.println("@V@ Report OUT put file name :- ["+reportOutputFileName+"]");
				
					reportDestination = ResourceConstants.REPORTDESTINATION + File.separator + userName + File.separator 
							+ reportOutputFileName + "." + rptExt;
					System.out.println("@V@ Report Destination Path :- ["+reportDestination+"]");
					
					/**
					 * Check generated report file
					 * is not EMPTY
					 * */
					boolean isEmpty=isFileEmpty(reportDestination);
					System.out.println("@V@ File ["+reportDestination+"] found check empty  :- ["+isEmpty+"]");
					if(isEmpty)
					{
						isFileNotEmpty=true;
					}
					else
					{
						isFileNotEmpty=false;
					}
					System.out.println("@V@ File not Empty :-["+isFileNotEmpty+"]");
					
				}
				
				/**
				 * Sending mail
				 * */
				if(isFileNotEmpty && (formatCode != null && formatCode.trim().length() > 0) )
				{
					System.out.println("@V@ Format Code :- ["+formatCode+"]");	
					
					/**
					 * Find 'EMAIL_ADDR'
					 *  for each 'CUST_CODE'
					 *  from table 'CUSTOMER'
					 * */
//					emailAddr = getCustEmailAddr(custCode, conn);
//					System.out.println("@V@ Email addres found :- ["+emailAddr+"]");
//					

					/**
					 * Generate mail format XML
					 * to send mail
					 * */
					commInfo.append("<ROOT>");
					commInfo.append("<MAIL><EMAIL_TYPE>page</EMAIL_TYPE><ENTITY_CODE>BASE</ENTITY_CODE>");
					commInfo.append("<ENTITY_TYPE>"+userType+"</ENTITY_TYPE>");
//					commInfo.append("<TO_ADD>"+emailAddr+"</TO_ADD>");
					commInfo.append("<TO_ADD></TO_ADD>");
					commInfo.append("<BCC_ADD></BCC_ADD>");
					commInfo.append("<FORMAT_CODE>"+formatCode+"</FORMAT_CODE>");							
					commInfo.append("<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>");
					commInfo.append("</MAIL>");
					commInfo.append("<XML_DATA><ROOT><Detail1><cust_code>"+custCode+"</cust_code><site_code>"+siteCode+"</site_code><emp_code>"
					+empCode+"</emp_code>");
					commInfo.append("<cc_to></cc_to></Detail1></ROOT></XML_DATA>");
					commInfo.append("<EMAIL_TYPE>page</EMAIL_TYPE><XML_DATA_FILE_PATH>"+reportDestination
							+"</XML_DATA_FILE_PATH><ENTITY_CODE></ENTITY_CODE>");
					commInfo.append("</ROOT>");	
					EMail email = new EMail();
					mailRetStr=email.sendMail(commInfo.toString(), "ITM"); 
					System.out.println("@V@ Mail return String  :- ["+mailRetStr+"]");
					
					if(mailRetStr.contains("S"))
					{						
						System.out.println("@V@ Cust code :- [" + custCode + "] Email Addres :- [" + emailAddr + "]");
						fos1.write(("\n Email send SUCCESSFULLY for Customer code :- [" + custCode + "]").getBytes());
					}
					else
					{
						System.out.println("@V@ Email addr NOT FOUND for Cust code :- [" + custCode + "]");
						fos1.write(("\n Email sending FAIL for Customer code :- [" + custCode + "]").getBytes());
					}
				}
				else
				{
					System.out.println("@V@ Skipping the mail for :-["+custCode+"]");
					fos1.write(("\n Skipping the mail for Customer code :- [" + custCode + "] the reoprt file may be empty").getBytes());
				}
			}
		}
		catch(Exception e)
		{
			isError = true;
			try
			{
				messageStr = itmDBAccessEJB.getErrorString("", "RPTFAILED", "");
				String errMsg = e.getMessage();
				generateLog("REPORT Sending Failed :"+errMsg, reportName, reportDestination, formatCode, xtraParams);
			}
			catch(Exception se)
			{
				
			}
			System.out.println("@V@ Exception :- ["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				System.out.println("@V@ isError in finally :- ["+isError+"]");
				if(!isError)
				{
					messageStr = itmDBAccessEJB.getErrorString("", "REPORTSUCC", "");
					System.out.println("@V@ Message Str :- ["+messageStr+"]");
					generateLog("Status : MSG_NO :REPORTSUCC", reportName, reportDestination, formatCode, xtraParams);
				}
			}
			catch(Exception fe)
			{
				System.out.println("Exception ::"+fe.getMessage());
				fe.printStackTrace();
			}
		}
		System.out.println("@V@ messageStr :- ["+messageStr+"]");
		return messageStr;
	}

	private boolean isFileEmpty(String reportDestination)
    {
	    // TODO Auto-generated method stub
		
		
		try
        {
			HSSFWorkbook wBook = new HSSFWorkbook(new FileInputStream(reportDestination));
			for(int sCnt=0; sCnt< wBook.getNumberOfSheets();sCnt++)
			{
				HSSFSheet sheet=wBook.getSheetAt(sCnt);
				Iterator rows = sheet.rowIterator();
			       while (rows.hasNext()) {
			           HSSFRow row = (HSSFRow) rows.next();
			           Iterator cells = row.cellIterator();
			           while (cells.hasNext()) {
			                HSSFCell cell = (HSSFCell) cells.next();
			                if(!cell.getStringCellValue().isEmpty()){
			                	return true;
			                }
			           }
			}
			}
	        
        } catch (IOException e)
        {
	        // TODO Auto-generated catch block
	        e.printStackTrace();
        }
		
		return false;
    }

//	private String getCustEmailAddr(String custCode, Connection conn) throws ITMException
//	{
//		// TODO Auto-generated method stub
//		String sql = "", emailAddr = "";
//		PreparedStatement pstmt = null;
//		ResultSet rs = null;
//
//		try
//		{
//			sql = "select email_addr from customer where cust_code=?";
//			pstmt = conn.prepareStatement(sql);
//			pstmt.setString(1, custCode);
//			rs = pstmt.executeQuery();
//			if (rs.next())
//			{
//				emailAddr = checkNull(rs.getString("email_addr"));
//			}
//			pstmt.close();
//			pstmt = null;
//			rs.close();
//			rs = null;
//		} catch (SQLException e)
//		{
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//			throw new ITMException(e);
//		}
//
//		return emailAddr;
//	}
	
	private void generateLog(String responseStr, String reportName, String reportFilePath, String formatCode,
			String xtraParams)throws RemoteException, ITMException
	{
		ConnDriver mConnDriver = null;
		Connection mConnection = null;
		PreparedStatement pStmt = null;
		ResultSet mRs = null;
		
		String status = "";
		try
		{
			mConnDriver = new ConnDriver();
			mConnection = mConnDriver.getConnectDB("DriverITM"); 
			
			String tranID = generateTranID(mConnection, xtraParams);
			
			if(tranID != null && tranID.trim().length() > 0)
			{
				String insertSql = "INSERT INTO REPORT_LOG (TRAN_ID, OBJ_NAME, REPORT_NAME, REPORT_SEND_DATE, REPORT_FILE_PATH, FORMAT_CODE,"
						+ " STATUS, CHG_DATE,CHG_USER,CHG_TERM) VALUES(?,?,?,?,?,?,?,?,?,?)";
				pStmt = mConnection.prepareStatement(insertSql);
				
				pStmt.setString(1, tranID);
//				pStmt.setString(2, objName);
				pStmt.setString(2, "d_invoice_ranbaxy_report");
				pStmt.setString(3,reportName);
				pStmt.setTimestamp(4, new java.sql.Timestamp(System.currentTimeMillis()));
				pStmt.setString(5, reportFilePath);
				pStmt.setString(6, formatCode);
				pStmt.setString(7, responseStr);
				pStmt.setTimestamp(8, new java.sql.Timestamp(System.currentTimeMillis()));
//				pStmt.setString(9,  getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
	//			pStmt.setString(10,  getValueFromXTRA_PARAMS(xtraParams, "termId"));
				pStmt.setString(9,  genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
				pStmt.setString(10,  genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
				
				int insCnt = pStmt.executeUpdate();
				
				if(insCnt > 0)
				{
					mConnection.commit();
				}
			}
			else
			{
				System.out.println("Transaction id is null.......");
			}
		}
		catch (ITMException itme)
		{ 
			System.err.println("ITMException :generateLog :\n"); //$NON-NLS-1$
			throw itme;
		}
		catch (Exception e)
		{ 
			System.err.println("Exception :generateLog :\n"+e.getMessage()); //$NON-NLS-1$
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(mConnection != null)
				{					
					if(mRs != null)
					{
						mRs.close();
						mRs = null;
					}
					if(pStmt != null)
					{
						pStmt.close();
						pStmt = null;
					}
					mConnection.close();
					mConnection = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :generateLog :\n"+e.getMessage()); //$NON-NLS-1$
				throw new ITMException(e);
			}
		}
	}
	
	private String generateTranID( Connection conn, String xtraParams )
	{
		String sprsTravelTranID = "";
		PreparedStatement pStmt = null;
		ResultSet rSet = null;
		String refSer="";
		String tranIdCol="";
		String keyString="";
		ibase.utility.E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		
		try
		{
			String transSql = "SELECT REF_SER,TRAN_ID_COL,KEY_STRING FROM TRANSETUP WHERE TRAN_WINDOW  = 'w_report_log'";

			pStmt = conn.prepareStatement(transSql);
			rSet = pStmt.executeQuery();
			
			if( rSet.next() )
			{
				refSer = (rSet.getString("REF_SER") == null) ?"":rSet.getString("REF_SER").trim();
				tranIdCol = (rSet.getString("TRAN_ID_COL") == null) ?"":rSet.getString("TRAN_ID_COL").trim();
				keyString = (rSet.getString("KEY_STRING") == null) ?"":rSet.getString("KEY_STRING").trim();
			}
			System.out.println("refSer["+refSer+"]tranIdCol["+tranIdCol+"]keyString["+keyString+"]");

//			TransIDGenerator tranIDGenerator = new TransIDGenerator("<Root></Root>", getValueFromXTRA_PARAMS(xtraParams, "loginCode"),
//			CommonConstants.DB_NAME);
			TransIDGenerator tranIDGenerator = new TransIDGenerator("<Root></Root>", genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"),
					CommonConstants.DB_NAME);
			sprsTravelTranID = tranIDGenerator.generateTranSeqID( refSer,tranIdCol,keyString,conn) ;
		}
		catch( Exception exp )
		{
			System.out.println("Exception In generateTranID......");
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if( rSet != null )
				{
					rSet.close();
					rSet.close();
				}
				if( pStmt != null )
				{
					pStmt.close();
					pStmt.close();
				}
			}
			catch( Exception expRsc )
			{
				expRsc.printStackTrace();
			}
		}
		return sprsTravelTranID;
	}

	@Override
	public String schedule(HashMap arg0) throws Exception
	{
		// TODO Auto-generated method stub
		return null;
	}

	// @Override
	public String schedulePriority(String arg0) throws Exception
	{
		// TODO Auto-generated method stub
		return null;
	}

}
